package software.amazon.awscdk.services.codeguruprofiler;

/**
 * Collection of grant methods for a IProfilingGroupRef.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codeguruprofiler.*;
 * import software.amazon.awscdk.interfaces.codeguruprofiler.*;
 * IProfilingGroupRef profilingGroupRef;
 * ProfilingGroupGrants profilingGroupGrants = ProfilingGroupGrants.fromProfilingGroup(profilingGroupRef);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:16.898Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codeguruprofiler.ProfilingGroupGrants")
public class ProfilingGroupGrants extends software.amazon.jsii.JsiiObject {

    protected ProfilingGroupGrants(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ProfilingGroupGrants(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Creates grants for ProfilingGroupGrants.
     * <p>
     * @param resource This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codeguruprofiler.ProfilingGroupGrants fromProfilingGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.codeguruprofiler.IProfilingGroupRef resource) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codeguruprofiler.ProfilingGroupGrants.class, "fromProfilingGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codeguruprofiler.ProfilingGroupGrants.class), new Object[] { java.util.Objects.requireNonNull(resource, "resource is required") });
    }

    /**
     * Grant access to publish profiling information to the Profiling Group to the given identity.
     * <p>
     * This will grant the following permissions:
     * <p>
     * <ul>
     * <li>codeguru-profiler:ConfigureAgent</li>
     * <li>codeguru-profiler:PostAgentProfile</li>
     * </ul>
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant publish(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "publish", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Grant access to read profiling information from the Profiling Group to the given identity.
     * <p>
     * This will grant the following permissions:
     * <p>
     * <ul>
     * <li>codeguru-profiler:GetProfile</li>
     * <li>codeguru-profiler:DescribeProfilingGroup</li>
     * </ul>
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant read(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "read", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.codeguruprofiler.IProfilingGroupRef getResource() {
        return software.amazon.jsii.Kernel.get(this, "resource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.codeguruprofiler.IProfilingGroupRef.class));
    }
}
