package software.amazon.awscdk.services.codepipeline;

/**
 * Properties for defining a CodePipeline Rule.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * CodeStarConnectionsSourceAction sourceAction;
 * CodeBuildAction buildAction;
 * Pipeline.Builder.create(this, "Pipeline")
 *         .pipelineType(PipelineType.V2)
 *         .stages(List.of(StageProps.builder()
 *                 .stageName("Source")
 *                 .actions(List.of(sourceAction))
 *                 .build(), StageProps.builder()
 *                 .stageName("Build")
 *                 .actions(List.of(buildAction))
 *                 // BeforeEntry condition - checks before entering the stage
 *                 .beforeEntry(Conditions.builder()
 *                         .conditions(List.of(Condition.builder()
 *                                 .rules(List.of(Rule.Builder.create()
 *                                         .name("LambdaCheck")
 *                                         .provider("LambdaInvoke")
 *                                         .version("1")
 *                                         .configuration(Map.of(
 *                                                 "FunctionName", "LambdaFunctionName"))
 *                                         .build()))
 *                                 .result(Result.FAIL)
 *                                 .build()))
 *                         .build())
 *                 // OnSuccess condition - checks after successful stage completion
 *                 .onSuccess(Conditions.builder()
 *                         .conditions(List.of(Condition.builder()
 *                                 .result(Result.FAIL)
 *                                 .rules(List.of(Rule.Builder.create()
 *                                         .name("CloudWatchCheck")
 *                                         .provider("LambdaInvoke")
 *                                         .version("1")
 *                                         .configuration(Map.of(
 *                                                 "AlarmName", "AlarmName1",
 *                                                 "WaitTime", "300",  // 5 minutes
 *                                                 "FunctionName", "funcName2"))
 *                                         .build()))
 *                                 .build()))
 *                         .build())
 *                 // OnFailure condition - handles stage failure
 *                 .onFailure(FailureConditions.builder()
 *                         .conditions(List.of(Condition.builder()
 *                                 .result(Result.ROLLBACK)
 *                                 .rules(List.of(Rule.Builder.create()
 *                                         .name("RollBackOnFailure")
 *                                         .provider("LambdaInvoke")
 *                                         .version("1")
 *                                         .configuration(Map.of(
 *                                                 "AlarmName", "Alarm",
 *                                                 "WaitTime", "300",  // 5 minutes
 *                                                 "FunctionName", "funcName1"))
 *                                         .build()))
 *                                 .build()))
 *                         .build())
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:17.001Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.RuleProps")
@software.amazon.jsii.Jsii.Proxy(RuleProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RuleProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The shell commands to run with your commands rule in CodePipeline.
     * <p>
     * All commands are supported except multi-line formats. While CodeBuild logs and permissions are used,
     * you do not need to create any resources in CodeBuild.
     * <p>
     * Default: - No commands
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCommands() {
        return null;
    }

    /**
     * The action configuration fields for the rule.
     * <p>
     * This can include custom parameters specific to the rule type.
     * <p>
     * Default: - No configuration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable com.fasterxml.jackson.databind.node.ObjectNode getConfiguration() {
        return null;
    }

    /**
     * The input artifacts fields for the rule, such as specifying an input file for the rule.
     * <p>
     * Each string in the array represents an artifact name that this rule will use as input.
     * <p>
     * Default: - No input artifacts
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInputArtifacts() {
        return null;
    }

    /**
     * The name of the rule that is created for the condition.
     * <p>
     * Must be unique within the pipeline.
     * <p>
     * Default: - A unique name will be generated
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * "VariableCheck";
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The rule provider that implements the rule's functionality.
     * <p>
     * Default: - No provider, must be specified if rule is used
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * "DeploymentWindow";
     * </pre></blockquote>
     * <p>
     * @see <a href="AWS CodePipeline rule reference for available providers">AWS CodePipeline rule reference for available providers</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProvider() {
        return null;
    }

    /**
     * The AWS Region for the condition associated with the rule.
     * <p>
     * If not specified, uses the pipeline's region.
     * <p>
     * Default: - Pipeline's region
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
        return null;
    }

    /**
     * The IAM role that the rule will use to execute its actions.
     * <p>
     * The role must have sufficient permissions to perform the rule's tasks.
     * <p>
     * Default: - A new role will be created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.Role getRole() {
        return null;
    }

    /**
     * The version of the rule to use.
     * <p>
     * Different versions may have different features or behaviors.
     * <p>
     * Default: '1'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link RuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RuleProps> {
        java.util.List<java.lang.String> commands;
        com.fasterxml.jackson.databind.node.ObjectNode configuration;
        java.util.List<java.lang.String> inputArtifacts;
        java.lang.String name;
        java.lang.String provider;
        java.lang.String region;
        software.amazon.awscdk.services.iam.Role role;
        java.lang.String version;

        /**
         * Sets the value of {@link RuleProps#getCommands}
         * @param commands The shell commands to run with your commands rule in CodePipeline.
         *                 All commands are supported except multi-line formats. While CodeBuild logs and permissions are used,
         *                 you do not need to create any resources in CodeBuild.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder commands(java.util.List<java.lang.String> commands) {
            this.commands = commands;
            return this;
        }

        /**
         * Sets the value of {@link RuleProps#getConfiguration}
         * @param configuration The action configuration fields for the rule.
         *                      This can include custom parameters specific to the rule type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(com.fasterxml.jackson.databind.node.ObjectNode configuration) {
            this.configuration = configuration;
            return this;
        }

        /**
         * Sets the value of {@link RuleProps#getInputArtifacts}
         * @param inputArtifacts The input artifacts fields for the rule, such as specifying an input file for the rule.
         *                       Each string in the array represents an artifact name that this rule will use as input.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputArtifacts(java.util.List<java.lang.String> inputArtifacts) {
            this.inputArtifacts = inputArtifacts;
            return this;
        }

        /**
         * Sets the value of {@link RuleProps#getName}
         * @param name The name of the rule that is created for the condition.
         *             Must be unique within the pipeline.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link RuleProps#getProvider}
         * @param provider The rule provider that implements the rule's functionality.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provider(java.lang.String provider) {
            this.provider = provider;
            return this;
        }

        /**
         * Sets the value of {@link RuleProps#getRegion}
         * @param region The AWS Region for the condition associated with the rule.
         *               If not specified, uses the pipeline's region.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Sets the value of {@link RuleProps#getRole}
         * @param role The IAM role that the rule will use to execute its actions.
         *             The role must have sufficient permissions to perform the rule's tasks.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.Role role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link RuleProps#getVersion}
         * @param version The version of the rule to use.
         *                Different versions may have different features or behaviors.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder version(java.lang.String version) {
            this.version = version;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RuleProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuleProps {
        private final java.util.List<java.lang.String> commands;
        private final com.fasterxml.jackson.databind.node.ObjectNode configuration;
        private final java.util.List<java.lang.String> inputArtifacts;
        private final java.lang.String name;
        private final java.lang.String provider;
        private final java.lang.String region;
        private final software.amazon.awscdk.services.iam.Role role;
        private final java.lang.String version;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.commands = software.amazon.jsii.Kernel.get(this, "commands", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.configuration = software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(com.fasterxml.jackson.databind.node.ObjectNode.class));
            this.inputArtifacts = software.amazon.jsii.Kernel.get(this, "inputArtifacts", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.provider = software.amazon.jsii.Kernel.get(this, "provider", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Role.class));
            this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.commands = builder.commands;
            this.configuration = builder.configuration;
            this.inputArtifacts = builder.inputArtifacts;
            this.name = builder.name;
            this.provider = builder.provider;
            this.region = builder.region;
            this.role = builder.role;
            this.version = builder.version;
        }

        @Override
        public final java.util.List<java.lang.String> getCommands() {
            return this.commands;
        }

        @Override
        public final com.fasterxml.jackson.databind.node.ObjectNode getConfiguration() {
            return this.configuration;
        }

        @Override
        public final java.util.List<java.lang.String> getInputArtifacts() {
            return this.inputArtifacts;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getProvider() {
            return this.provider;
        }

        @Override
        public final java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public final software.amazon.awscdk.services.iam.Role getRole() {
            return this.role;
        }

        @Override
        public final java.lang.String getVersion() {
            return this.version;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCommands() != null) {
                data.set("commands", om.valueToTree(this.getCommands()));
            }
            if (this.getConfiguration() != null) {
                data.set("configuration", om.valueToTree(this.getConfiguration()));
            }
            if (this.getInputArtifacts() != null) {
                data.set("inputArtifacts", om.valueToTree(this.getInputArtifacts()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getProvider() != null) {
                data.set("provider", om.valueToTree(this.getProvider()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getVersion() != null) {
                data.set("version", om.valueToTree(this.getVersion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.RuleProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RuleProps.Jsii$Proxy that = (RuleProps.Jsii$Proxy) o;

            if (this.commands != null ? !this.commands.equals(that.commands) : that.commands != null) return false;
            if (this.configuration != null ? !this.configuration.equals(that.configuration) : that.configuration != null) return false;
            if (this.inputArtifacts != null ? !this.inputArtifacts.equals(that.inputArtifacts) : that.inputArtifacts != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.provider != null ? !this.provider.equals(that.provider) : that.provider != null) return false;
            if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            return this.version != null ? this.version.equals(that.version) : that.version == null;
        }

        @Override
        public final int hashCode() {
            int result = this.commands != null ? this.commands.hashCode() : 0;
            result = 31 * result + (this.configuration != null ? this.configuration.hashCode() : 0);
            result = 31 * result + (this.inputArtifacts != null ? this.inputArtifacts.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.provider != null ? this.provider.hashCode() : 0);
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
            return result;
        }
    }
}
