package software.amazon.awscdk.services.codepipeline.actions;

/**
 * Properties for the CloudFormationDeployStackInstancesAction.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Pipeline pipeline;
 * Artifact sourceOutput;
 * pipeline.addStage(StageOptions.builder()
 *         .stageName("DeployStackSets")
 *         .actions(List.of(
 *             // First, update the StackSet itself with the newest template
 *             CloudFormationDeployStackSetAction.Builder.create()
 *                     .actionName("UpdateStackSet")
 *                     .runOrder(1)
 *                     .stackSetName("MyStackSet")
 *                     .template(StackSetTemplate.fromArtifactPath(sourceOutput.atPath("template.yaml")))
 *                     // Change this to 'StackSetDeploymentModel.organizations()' if you want to deploy to OUs
 *                     .deploymentModel(StackSetDeploymentModel.selfManaged())
 *                     // This deploys to a set of accounts
 *                     .stackInstances(StackInstances.inAccounts(List.of("111111111111"), List.of("us-east-1", "eu-west-1")))
 *                     .build(),
 *             // Afterwards, update/create additional instances in other accounts
 *             CloudFormationDeployStackInstancesAction.Builder.create()
 *                     .actionName("AddMoreInstances")
 *                     .runOrder(2)
 *                     .stackSetName("MyStackSet")
 *                     .stackInstances(StackInstances.inAccounts(List.of("222222222222", "333333333333"), List.of("us-east-1", "eu-west-1")))
 *                     .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:17.058Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.CloudFormationDeployStackInstancesActionProps")
@software.amazon.jsii.Jsii.Proxy(CloudFormationDeployStackInstancesActionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CloudFormationDeployStackInstancesActionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.codepipeline.CommonAwsActionProps, software.amazon.awscdk.services.codepipeline.actions.CommonCloudFormationStackSetOptions {

    /**
     * Specify where to create or update Stack Instances.
     * <p>
     * You can specify either AWS Accounts Ids or AWS Organizations Organizational Units.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.StackInstances getStackInstances();

    /**
     * The name of the StackSet we are adding instances to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStackSetName();

    /**
     * Parameter values that only apply to the current Stack Instances.
     * <p>
     * These parameters are shared between all instances added by this action.
     * <p>
     * Default: - no parameters will be overridden
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codepipeline.actions.StackSetParameters getParameterOverrides() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CloudFormationDeployStackInstancesActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CloudFormationDeployStackInstancesActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CloudFormationDeployStackInstancesActionProps> {
        software.amazon.awscdk.services.codepipeline.actions.StackInstances stackInstances;
        java.lang.String stackSetName;
        software.amazon.awscdk.services.codepipeline.actions.StackSetParameters parameterOverrides;
        software.amazon.awscdk.services.iam.IRole role;
        java.lang.String actionName;
        java.lang.Number runOrder;
        java.lang.String variablesNamespace;
        java.lang.Number failureTolerancePercentage;
        java.lang.Number maxAccountConcurrencyPercentage;
        java.lang.String stackSetRegion;

        /**
         * Sets the value of {@link CloudFormationDeployStackInstancesActionProps#getStackInstances}
         * @param stackInstances Specify where to create or update Stack Instances. This parameter is required.
         *                       You can specify either AWS Accounts Ids or AWS Organizations Organizational Units.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackInstances(software.amazon.awscdk.services.codepipeline.actions.StackInstances stackInstances) {
            this.stackInstances = stackInstances;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationDeployStackInstancesActionProps#getStackSetName}
         * @param stackSetName The name of the StackSet we are adding instances to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackSetName(java.lang.String stackSetName) {
            this.stackSetName = stackSetName;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationDeployStackInstancesActionProps#getParameterOverrides}
         * @param parameterOverrides Parameter values that only apply to the current Stack Instances.
         *                           These parameters are shared between all instances added by this action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameterOverrides(software.amazon.awscdk.services.codepipeline.actions.StackSetParameters parameterOverrides) {
            this.parameterOverrides = parameterOverrides;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationDeployStackInstancesActionProps#getRole}
         * @param role The Role in which context's this Action will be executing in.
         *             The Pipeline's Role will assume this Role
         *             (the required permissions for that will be granted automatically)
         *             right before executing this Action.
         *             This Action will be passed into your <code>IAction.bind</code>
         *             method in the <code>ActionBindOptions.role</code> property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationDeployStackInstancesActionProps#getActionName}
         * @param actionName The physical, human-readable name of the Action. This parameter is required.
         *                   Note that Action names must be unique within a single Stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionName(java.lang.String actionName) {
            this.actionName = actionName;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationDeployStackInstancesActionProps#getRunOrder}
         * @param runOrder The runOrder property for this Action.
         *                 RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runOrder(java.lang.Number runOrder) {
            this.runOrder = runOrder;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationDeployStackInstancesActionProps#getVariablesNamespace}
         * @param variablesNamespace The name of the namespace to use for variables emitted by this action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variablesNamespace(java.lang.String variablesNamespace) {
            this.variablesNamespace = variablesNamespace;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationDeployStackInstancesActionProps#getFailureTolerancePercentage}
         * @param failureTolerancePercentage The percentage of accounts per Region for which this stack operation can fail before AWS CloudFormation stops the operation in that Region.
         *                                   If
         *                                   the operation is stopped in a Region, AWS CloudFormation doesn't attempt the operation in subsequent Regions. When calculating the number
         *                                   of accounts based on the specified percentage, AWS CloudFormation rounds down to the next whole number.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failureTolerancePercentage(java.lang.Number failureTolerancePercentage) {
            this.failureTolerancePercentage = failureTolerancePercentage;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationDeployStackInstancesActionProps#getMaxAccountConcurrencyPercentage}
         * @param maxAccountConcurrencyPercentage The maximum percentage of accounts in which to perform this operation at one time.
         *                                        When calculating the number of accounts based on the specified
         *                                        percentage, AWS CloudFormation rounds down to the next whole number. If rounding down would result in zero, AWS CloudFormation sets the number as
         *                                        one instead. Although you use this setting to specify the maximum, for large deployments the actual number of accounts acted upon concurrently
         *                                        may be lower due to service throttling.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxAccountConcurrencyPercentage(java.lang.Number maxAccountConcurrencyPercentage) {
            this.maxAccountConcurrencyPercentage = maxAccountConcurrencyPercentage;
            return this;
        }

        /**
         * Sets the value of {@link CloudFormationDeployStackInstancesActionProps#getStackSetRegion}
         * @param stackSetRegion The AWS Region the StackSet is in.
         *                       Note that a cross-region Pipeline requires replication buckets to function correctly.
         *                       You can provide their names with the <code>PipelineProps.crossRegionReplicationBuckets</code> property.
         *                       If you don't, the CodePipeline Construct will create new Stacks in your CDK app containing those buckets,
         *                       that you will need to <code>cdk deploy</code> before deploying the main, Pipeline-containing Stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackSetRegion(java.lang.String stackSetRegion) {
            this.stackSetRegion = stackSetRegion;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CloudFormationDeployStackInstancesActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CloudFormationDeployStackInstancesActionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CloudFormationDeployStackInstancesActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudFormationDeployStackInstancesActionProps {
        private final software.amazon.awscdk.services.codepipeline.actions.StackInstances stackInstances;
        private final java.lang.String stackSetName;
        private final software.amazon.awscdk.services.codepipeline.actions.StackSetParameters parameterOverrides;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final java.lang.String actionName;
        private final java.lang.Number runOrder;
        private final java.lang.String variablesNamespace;
        private final java.lang.Number failureTolerancePercentage;
        private final java.lang.Number maxAccountConcurrencyPercentage;
        private final java.lang.String stackSetRegion;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.stackInstances = software.amazon.jsii.Kernel.get(this, "stackInstances", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.StackInstances.class));
            this.stackSetName = software.amazon.jsii.Kernel.get(this, "stackSetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.parameterOverrides = software.amazon.jsii.Kernel.get(this, "parameterOverrides", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.StackSetParameters.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.actionName = software.amazon.jsii.Kernel.get(this, "actionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.runOrder = software.amazon.jsii.Kernel.get(this, "runOrder", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.variablesNamespace = software.amazon.jsii.Kernel.get(this, "variablesNamespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.failureTolerancePercentage = software.amazon.jsii.Kernel.get(this, "failureTolerancePercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxAccountConcurrencyPercentage = software.amazon.jsii.Kernel.get(this, "maxAccountConcurrencyPercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.stackSetRegion = software.amazon.jsii.Kernel.get(this, "stackSetRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.stackInstances = java.util.Objects.requireNonNull(builder.stackInstances, "stackInstances is required");
            this.stackSetName = java.util.Objects.requireNonNull(builder.stackSetName, "stackSetName is required");
            this.parameterOverrides = builder.parameterOverrides;
            this.role = builder.role;
            this.actionName = java.util.Objects.requireNonNull(builder.actionName, "actionName is required");
            this.runOrder = builder.runOrder;
            this.variablesNamespace = builder.variablesNamespace;
            this.failureTolerancePercentage = builder.failureTolerancePercentage;
            this.maxAccountConcurrencyPercentage = builder.maxAccountConcurrencyPercentage;
            this.stackSetRegion = builder.stackSetRegion;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.actions.StackInstances getStackInstances() {
            return this.stackInstances;
        }

        @Override
        public final java.lang.String getStackSetName() {
            return this.stackSetName;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.actions.StackSetParameters getParameterOverrides() {
            return this.parameterOverrides;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final java.lang.String getActionName() {
            return this.actionName;
        }

        @Override
        public final java.lang.Number getRunOrder() {
            return this.runOrder;
        }

        @Override
        public final java.lang.String getVariablesNamespace() {
            return this.variablesNamespace;
        }

        @Override
        public final java.lang.Number getFailureTolerancePercentage() {
            return this.failureTolerancePercentage;
        }

        @Override
        public final java.lang.Number getMaxAccountConcurrencyPercentage() {
            return this.maxAccountConcurrencyPercentage;
        }

        @Override
        public final java.lang.String getStackSetRegion() {
            return this.stackSetRegion;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("stackInstances", om.valueToTree(this.getStackInstances()));
            data.set("stackSetName", om.valueToTree(this.getStackSetName()));
            if (this.getParameterOverrides() != null) {
                data.set("parameterOverrides", om.valueToTree(this.getParameterOverrides()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            data.set("actionName", om.valueToTree(this.getActionName()));
            if (this.getRunOrder() != null) {
                data.set("runOrder", om.valueToTree(this.getRunOrder()));
            }
            if (this.getVariablesNamespace() != null) {
                data.set("variablesNamespace", om.valueToTree(this.getVariablesNamespace()));
            }
            if (this.getFailureTolerancePercentage() != null) {
                data.set("failureTolerancePercentage", om.valueToTree(this.getFailureTolerancePercentage()));
            }
            if (this.getMaxAccountConcurrencyPercentage() != null) {
                data.set("maxAccountConcurrencyPercentage", om.valueToTree(this.getMaxAccountConcurrencyPercentage()));
            }
            if (this.getStackSetRegion() != null) {
                data.set("stackSetRegion", om.valueToTree(this.getStackSetRegion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline_actions.CloudFormationDeployStackInstancesActionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CloudFormationDeployStackInstancesActionProps.Jsii$Proxy that = (CloudFormationDeployStackInstancesActionProps.Jsii$Proxy) o;

            if (!stackInstances.equals(that.stackInstances)) return false;
            if (!stackSetName.equals(that.stackSetName)) return false;
            if (this.parameterOverrides != null ? !this.parameterOverrides.equals(that.parameterOverrides) : that.parameterOverrides != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (!actionName.equals(that.actionName)) return false;
            if (this.runOrder != null ? !this.runOrder.equals(that.runOrder) : that.runOrder != null) return false;
            if (this.variablesNamespace != null ? !this.variablesNamespace.equals(that.variablesNamespace) : that.variablesNamespace != null) return false;
            if (this.failureTolerancePercentage != null ? !this.failureTolerancePercentage.equals(that.failureTolerancePercentage) : that.failureTolerancePercentage != null) return false;
            if (this.maxAccountConcurrencyPercentage != null ? !this.maxAccountConcurrencyPercentage.equals(that.maxAccountConcurrencyPercentage) : that.maxAccountConcurrencyPercentage != null) return false;
            return this.stackSetRegion != null ? this.stackSetRegion.equals(that.stackSetRegion) : that.stackSetRegion == null;
        }

        @Override
        public final int hashCode() {
            int result = this.stackInstances.hashCode();
            result = 31 * result + (this.stackSetName.hashCode());
            result = 31 * result + (this.parameterOverrides != null ? this.parameterOverrides.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.actionName.hashCode());
            result = 31 * result + (this.runOrder != null ? this.runOrder.hashCode() : 0);
            result = 31 * result + (this.variablesNamespace != null ? this.variablesNamespace.hashCode() : 0);
            result = 31 * result + (this.failureTolerancePercentage != null ? this.failureTolerancePercentage.hashCode() : 0);
            result = 31 * result + (this.maxAccountConcurrencyPercentage != null ? this.maxAccountConcurrencyPercentage.hashCode() : 0);
            result = 31 * result + (this.stackSetRegion != null ? this.stackSetRegion.hashCode() : 0);
            return result;
        }
    }
}
