package software.amazon.awscdk.services.codepipeline.actions;

/**
 * Construction properties of the <code>CommandsAction</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Artifact sourceArtifact;
 * Artifact outputArtifact;
 * CommandsAction commandsAction = CommandsAction.Builder.create()
 *         .actionName("Commands")
 *         .commands(List.of("export MY_OUTPUT=my-key"))
 *         .input(sourceArtifact)
 *         .output(outputArtifact)
 *         .outputVariables(List.of("MY_OUTPUT", "CODEBUILD_BUILD_ID"))
 *         .build();
 * // Deploy action
 * S3DeployAction deployAction = S3DeployAction.Builder.create()
 *         .actionName("DeployAction")
 *         .extract(true)
 *         .input(outputArtifact)
 *         .bucket(new Bucket(this, "DeployBucket"))
 *         .objectKey(commandsAction.variable("MY_OUTPUT"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:17.094Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.CommandsActionProps")
@software.amazon.jsii.Jsii.Proxy(CommandsActionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CommandsActionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.codepipeline.CommonAwsActionProps {

    /**
     * Shell commands for the Commands action to run.
     * <p>
     * All formats are supported except multi-line formats.
     * <p>
     * The length of the commands array must be between 1 and 50.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getCommands();

    /**
     * The source to use as input for this action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.Artifact getInput();

    /**
     * The list of additional input artifacts for this action.
     * <p>
     * Default: - no extra inputs
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.codepipeline.Artifact> getExtraInputs() {
        return null;
    }

    /**
     * The output artifact for this action.
     * <p>
     * You can filter files that you want to export as the output artifact for the action.
     * <p>
     * Default: - no output artifact
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * new Artifact("CommandsArtifact", List.of("my-dir/**"));
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codepipeline.Artifact getOutput() {
        return null;
    }

    /**
     * The names of the variables in your environment that you want to export.
     * <p>
     * These variables can be referenced in other actions by using the <code>variable</code> method
     * of this class.
     * <p>
     * Default: - No output variables are exported
     * <p>
     * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-env-vars.html">https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-env-vars.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getOutputVariables() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CommandsActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CommandsActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CommandsActionProps> {
        java.util.List<java.lang.String> commands;
        software.amazon.awscdk.services.codepipeline.Artifact input;
        java.util.List<software.amazon.awscdk.services.codepipeline.Artifact> extraInputs;
        software.amazon.awscdk.services.codepipeline.Artifact output;
        java.util.List<java.lang.String> outputVariables;
        software.amazon.awscdk.services.iam.IRole role;
        java.lang.String actionName;
        java.lang.Number runOrder;
        java.lang.String variablesNamespace;

        /**
         * Sets the value of {@link CommandsActionProps#getCommands}
         * @param commands Shell commands for the Commands action to run. This parameter is required.
         *                 All formats are supported except multi-line formats.
         *                 <p>
         *                 The length of the commands array must be between 1 and 50.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder commands(java.util.List<java.lang.String> commands) {
            this.commands = commands;
            return this;
        }

        /**
         * Sets the value of {@link CommandsActionProps#getInput}
         * @param input The source to use as input for this action. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder input(software.amazon.awscdk.services.codepipeline.Artifact input) {
            this.input = input;
            return this;
        }

        /**
         * Sets the value of {@link CommandsActionProps#getExtraInputs}
         * @param extraInputs The list of additional input artifacts for this action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder extraInputs(java.util.List<? extends software.amazon.awscdk.services.codepipeline.Artifact> extraInputs) {
            this.extraInputs = (java.util.List<software.amazon.awscdk.services.codepipeline.Artifact>)extraInputs;
            return this;
        }

        /**
         * Sets the value of {@link CommandsActionProps#getOutput}
         * @param output The output artifact for this action.
         *               You can filter files that you want to export as the output artifact for the action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder output(software.amazon.awscdk.services.codepipeline.Artifact output) {
            this.output = output;
            return this;
        }

        /**
         * Sets the value of {@link CommandsActionProps#getOutputVariables}
         * @param outputVariables The names of the variables in your environment that you want to export.
         *                        These variables can be referenced in other actions by using the <code>variable</code> method
         *                        of this class.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputVariables(java.util.List<java.lang.String> outputVariables) {
            this.outputVariables = outputVariables;
            return this;
        }

        /**
         * Sets the value of {@link CommandsActionProps#getRole}
         * @param role The Role in which context's this Action will be executing in.
         *             The Pipeline's Role will assume this Role
         *             (the required permissions for that will be granted automatically)
         *             right before executing this Action.
         *             This Action will be passed into your <code>IAction.bind</code>
         *             method in the <code>ActionBindOptions.role</code> property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link CommandsActionProps#getActionName}
         * @param actionName The physical, human-readable name of the Action. This parameter is required.
         *                   Note that Action names must be unique within a single Stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionName(java.lang.String actionName) {
            this.actionName = actionName;
            return this;
        }

        /**
         * Sets the value of {@link CommandsActionProps#getRunOrder}
         * @param runOrder The runOrder property for this Action.
         *                 RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runOrder(java.lang.Number runOrder) {
            this.runOrder = runOrder;
            return this;
        }

        /**
         * Sets the value of {@link CommandsActionProps#getVariablesNamespace}
         * @param variablesNamespace The name of the namespace to use for variables emitted by this action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variablesNamespace(java.lang.String variablesNamespace) {
            this.variablesNamespace = variablesNamespace;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CommandsActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CommandsActionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CommandsActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CommandsActionProps {
        private final java.util.List<java.lang.String> commands;
        private final software.amazon.awscdk.services.codepipeline.Artifact input;
        private final java.util.List<software.amazon.awscdk.services.codepipeline.Artifact> extraInputs;
        private final software.amazon.awscdk.services.codepipeline.Artifact output;
        private final java.util.List<java.lang.String> outputVariables;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final java.lang.String actionName;
        private final java.lang.Number runOrder;
        private final java.lang.String variablesNamespace;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.commands = software.amazon.jsii.Kernel.get(this, "commands", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.input = software.amazon.jsii.Kernel.get(this, "input", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.Artifact.class));
            this.extraInputs = software.amazon.jsii.Kernel.get(this, "extraInputs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.Artifact.class)));
            this.output = software.amazon.jsii.Kernel.get(this, "output", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.Artifact.class));
            this.outputVariables = software.amazon.jsii.Kernel.get(this, "outputVariables", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.actionName = software.amazon.jsii.Kernel.get(this, "actionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.runOrder = software.amazon.jsii.Kernel.get(this, "runOrder", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.variablesNamespace = software.amazon.jsii.Kernel.get(this, "variablesNamespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.commands = java.util.Objects.requireNonNull(builder.commands, "commands is required");
            this.input = java.util.Objects.requireNonNull(builder.input, "input is required");
            this.extraInputs = (java.util.List<software.amazon.awscdk.services.codepipeline.Artifact>)builder.extraInputs;
            this.output = builder.output;
            this.outputVariables = builder.outputVariables;
            this.role = builder.role;
            this.actionName = java.util.Objects.requireNonNull(builder.actionName, "actionName is required");
            this.runOrder = builder.runOrder;
            this.variablesNamespace = builder.variablesNamespace;
        }

        @Override
        public final java.util.List<java.lang.String> getCommands() {
            return this.commands;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.Artifact getInput() {
            return this.input;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.codepipeline.Artifact> getExtraInputs() {
            return this.extraInputs;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.Artifact getOutput() {
            return this.output;
        }

        @Override
        public final java.util.List<java.lang.String> getOutputVariables() {
            return this.outputVariables;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final java.lang.String getActionName() {
            return this.actionName;
        }

        @Override
        public final java.lang.Number getRunOrder() {
            return this.runOrder;
        }

        @Override
        public final java.lang.String getVariablesNamespace() {
            return this.variablesNamespace;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("commands", om.valueToTree(this.getCommands()));
            data.set("input", om.valueToTree(this.getInput()));
            if (this.getExtraInputs() != null) {
                data.set("extraInputs", om.valueToTree(this.getExtraInputs()));
            }
            if (this.getOutput() != null) {
                data.set("output", om.valueToTree(this.getOutput()));
            }
            if (this.getOutputVariables() != null) {
                data.set("outputVariables", om.valueToTree(this.getOutputVariables()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            data.set("actionName", om.valueToTree(this.getActionName()));
            if (this.getRunOrder() != null) {
                data.set("runOrder", om.valueToTree(this.getRunOrder()));
            }
            if (this.getVariablesNamespace() != null) {
                data.set("variablesNamespace", om.valueToTree(this.getVariablesNamespace()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline_actions.CommandsActionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CommandsActionProps.Jsii$Proxy that = (CommandsActionProps.Jsii$Proxy) o;

            if (!commands.equals(that.commands)) return false;
            if (!input.equals(that.input)) return false;
            if (this.extraInputs != null ? !this.extraInputs.equals(that.extraInputs) : that.extraInputs != null) return false;
            if (this.output != null ? !this.output.equals(that.output) : that.output != null) return false;
            if (this.outputVariables != null ? !this.outputVariables.equals(that.outputVariables) : that.outputVariables != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (!actionName.equals(that.actionName)) return false;
            if (this.runOrder != null ? !this.runOrder.equals(that.runOrder) : that.runOrder != null) return false;
            return this.variablesNamespace != null ? this.variablesNamespace.equals(that.variablesNamespace) : that.variablesNamespace == null;
        }

        @Override
        public final int hashCode() {
            int result = this.commands.hashCode();
            result = 31 * result + (this.input.hashCode());
            result = 31 * result + (this.extraInputs != null ? this.extraInputs.hashCode() : 0);
            result = 31 * result + (this.output != null ? this.output.hashCode() : 0);
            result = 31 * result + (this.outputVariables != null ? this.outputVariables.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.actionName.hashCode());
            result = 31 * result + (this.runOrder != null ? this.runOrder.hashCode() : 0);
            result = 31 * result + (this.variablesNamespace != null ? this.variablesNamespace.hashCode() : 0);
            return result;
        }
    }
}
