package software.amazon.awscdk.services.cognito;

/**
 * Identity providers supported by the UserPoolClient.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserPool pool = new UserPool(this, "Pool");
 * pool.addClient("app-client", UserPoolClientOptions.builder()
 *         // ...
 *         .supportedIdentityProviders(List.of(UserPoolClientIdentityProvider.AMAZON, UserPoolClientIdentityProvider.COGNITO))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:17.379Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.UserPoolClientIdentityProvider")
public class UserPoolClientIdentityProvider extends software.amazon.jsii.JsiiObject {

    protected UserPoolClientIdentityProvider(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected UserPoolClientIdentityProvider(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        AMAZON = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider.class, "AMAZON", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider.class));
        APPLE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider.class, "APPLE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider.class));
        COGNITO = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider.class, "COGNITO", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider.class));
        FACEBOOK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider.class, "FACEBOOK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider.class));
        GOOGLE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider.class, "GOOGLE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider.class));
    }

    /**
     * Specify a provider not yet supported by the CDK.
     * <p>
     * @param name name of the identity provider as recognized by CloudFormation property <code>SupportedIdentityProviders</code>. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider custom(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider.class, "custom", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * Allow users to sign in using 'Login With Amazon'.
     * <p>
     * A <code>UserPoolIdentityProviderAmazon</code> must be attached to the user pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider AMAZON;

    /**
     * Allow users to sign in using 'Sign In With Apple'.
     * <p>
     * A <code>UserPoolIdentityProviderApple</code> must be attached to the user pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider APPLE;

    /**
     * Allow users to sign in directly as a user of the User Pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider COGNITO;

    /**
     * Allow users to sign in using 'Facebook Login'.
     * <p>
     * A <code>UserPoolIdentityProviderFacebook</code> must be attached to the user pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider FACEBOOK;

    /**
     * Allow users to sign in using 'Google Login'.
     * <p>
     * A <code>UserPoolIdentityProviderGoogle</code> must be attached to the user pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider GOOGLE;

    /**
     * The name of the identity provider as recognized by CloudFormation property <code>SupportedIdentityProviders</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
