package software.amazon.awscdk.services.cognito.identitypool;

/**
 * Map roles to users in the Identity Pool based on claims from the Identity Provider.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cognito.identitypool.*;
 * import software.amazon.awscdk.services.iam.*;
 * IdentityPoolProviderUrl identityPoolProviderUrl;
 * Role role;
 * IdentityPoolRoleMapping identityPoolRoleMapping = IdentityPoolRoleMapping.builder()
 *         .providerUrl(identityPoolProviderUrl)
 *         // the properties below are optional
 *         .mappingKey("mappingKey")
 *         .resolveAmbiguousRoles(false)
 *         .rules(List.of(RoleMappingRule.builder()
 *                 .claim("claim")
 *                 .claimValue("claimValue")
 *                 .mappedRole(role)
 *                 // the properties below are optional
 *                 .matchType(RoleMappingMatchType.EQUALS)
 *                 .build()))
 *         .useToken(false)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolroleattachment.html">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypoolroleattachment.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:17.434Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito_identitypool.IdentityPoolRoleMapping")
@software.amazon.jsii.Jsii.Proxy(IdentityPoolRoleMapping.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IdentityPoolRoleMapping extends software.amazon.jsii.JsiiSerializable {

    /**
     * The url of the Provider for which the role is mapped.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl getProviderUrl();

    /**
     * The key used for the role mapping in the role mapping hash.
     * <p>
     * Required if the providerUrl is a token.
     * <p>
     * Default: - The provided providerUrl
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMappingKey() {
        return null;
    }

    /**
     * Allow for role assumption when results of role mapping are ambiguous.
     * <p>
     * Default: false - Ambiguous role resolutions will lead to requester being denied
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getResolveAmbiguousRoles() {
        return null;
    }

    /**
     * The claim and value that must be matched in order to assume the role.
     * <p>
     * Required if useToken is false
     * <p>
     * Default: - No role mapping rule
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.cognito.identitypool.RoleMappingRule> getRules() {
        return null;
    }

    /**
     * If true then mapped roles must be passed through the cognito:roles or cognito:preferred_role claims from Identity Provider.
     * <p>
     * Default: false
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/role-based-access-control.html#using-tokens-to-assign-roles-to-users">https://docs.aws.amazon.com/cognito/latest/developerguide/role-based-access-control.html#using-tokens-to-assign-roles-to-users</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getUseToken() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link IdentityPoolRoleMapping}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link IdentityPoolRoleMapping}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<IdentityPoolRoleMapping> {
        software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl providerUrl;
        java.lang.String mappingKey;
        java.lang.Boolean resolveAmbiguousRoles;
        java.util.List<software.amazon.awscdk.services.cognito.identitypool.RoleMappingRule> rules;
        java.lang.Boolean useToken;

        /**
         * Sets the value of {@link IdentityPoolRoleMapping#getProviderUrl}
         * @param providerUrl The url of the Provider for which the role is mapped. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder providerUrl(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl providerUrl) {
            this.providerUrl = providerUrl;
            return this;
        }

        /**
         * Sets the value of {@link IdentityPoolRoleMapping#getMappingKey}
         * @param mappingKey The key used for the role mapping in the role mapping hash.
         *                   Required if the providerUrl is a token.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mappingKey(java.lang.String mappingKey) {
            this.mappingKey = mappingKey;
            return this;
        }

        /**
         * Sets the value of {@link IdentityPoolRoleMapping#getResolveAmbiguousRoles}
         * @param resolveAmbiguousRoles Allow for role assumption when results of role mapping are ambiguous.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resolveAmbiguousRoles(java.lang.Boolean resolveAmbiguousRoles) {
            this.resolveAmbiguousRoles = resolveAmbiguousRoles;
            return this;
        }

        /**
         * Sets the value of {@link IdentityPoolRoleMapping#getRules}
         * @param rules The claim and value that must be matched in order to assume the role.
         *              Required if useToken is false
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder rules(java.util.List<? extends software.amazon.awscdk.services.cognito.identitypool.RoleMappingRule> rules) {
            this.rules = (java.util.List<software.amazon.awscdk.services.cognito.identitypool.RoleMappingRule>)rules;
            return this;
        }

        /**
         * Sets the value of {@link IdentityPoolRoleMapping#getUseToken}
         * @param useToken If true then mapped roles must be passed through the cognito:roles or cognito:preferred_role claims from Identity Provider.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useToken(java.lang.Boolean useToken) {
            this.useToken = useToken;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IdentityPoolRoleMapping}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public IdentityPoolRoleMapping build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link IdentityPoolRoleMapping}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IdentityPoolRoleMapping {
        private final software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl providerUrl;
        private final java.lang.String mappingKey;
        private final java.lang.Boolean resolveAmbiguousRoles;
        private final java.util.List<software.amazon.awscdk.services.cognito.identitypool.RoleMappingRule> rules;
        private final java.lang.Boolean useToken;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.providerUrl = software.amazon.jsii.Kernel.get(this, "providerUrl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl.class));
            this.mappingKey = software.amazon.jsii.Kernel.get(this, "mappingKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resolveAmbiguousRoles = software.amazon.jsii.Kernel.get(this, "resolveAmbiguousRoles", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.rules = software.amazon.jsii.Kernel.get(this, "rules", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.identitypool.RoleMappingRule.class)));
            this.useToken = software.amazon.jsii.Kernel.get(this, "useToken", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.providerUrl = java.util.Objects.requireNonNull(builder.providerUrl, "providerUrl is required");
            this.mappingKey = builder.mappingKey;
            this.resolveAmbiguousRoles = builder.resolveAmbiguousRoles;
            this.rules = (java.util.List<software.amazon.awscdk.services.cognito.identitypool.RoleMappingRule>)builder.rules;
            this.useToken = builder.useToken;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl getProviderUrl() {
            return this.providerUrl;
        }

        @Override
        public final java.lang.String getMappingKey() {
            return this.mappingKey;
        }

        @Override
        public final java.lang.Boolean getResolveAmbiguousRoles() {
            return this.resolveAmbiguousRoles;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cognito.identitypool.RoleMappingRule> getRules() {
            return this.rules;
        }

        @Override
        public final java.lang.Boolean getUseToken() {
            return this.useToken;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("providerUrl", om.valueToTree(this.getProviderUrl()));
            if (this.getMappingKey() != null) {
                data.set("mappingKey", om.valueToTree(this.getMappingKey()));
            }
            if (this.getResolveAmbiguousRoles() != null) {
                data.set("resolveAmbiguousRoles", om.valueToTree(this.getResolveAmbiguousRoles()));
            }
            if (this.getRules() != null) {
                data.set("rules", om.valueToTree(this.getRules()));
            }
            if (this.getUseToken() != null) {
                data.set("useToken", om.valueToTree(this.getUseToken()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito_identitypool.IdentityPoolRoleMapping"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            IdentityPoolRoleMapping.Jsii$Proxy that = (IdentityPoolRoleMapping.Jsii$Proxy) o;

            if (!providerUrl.equals(that.providerUrl)) return false;
            if (this.mappingKey != null ? !this.mappingKey.equals(that.mappingKey) : that.mappingKey != null) return false;
            if (this.resolveAmbiguousRoles != null ? !this.resolveAmbiguousRoles.equals(that.resolveAmbiguousRoles) : that.resolveAmbiguousRoles != null) return false;
            if (this.rules != null ? !this.rules.equals(that.rules) : that.rules != null) return false;
            return this.useToken != null ? this.useToken.equals(that.useToken) : that.useToken == null;
        }

        @Override
        public final int hashCode() {
            int result = this.providerUrl.hashCode();
            result = 31 * result + (this.mappingKey != null ? this.mappingKey.hashCode() : 0);
            result = 31 * result + (this.resolveAmbiguousRoles != null ? this.resolveAmbiguousRoles.hashCode() : 0);
            result = 31 * result + (this.rules != null ? this.rules.hashCode() : 0);
            result = 31 * result + (this.useToken != null ? this.useToken.hashCode() : 0);
            return result;
        }
    }
}
