package software.amazon.awscdk.services.connect;

/**
 * Creates an evaluation form for the specified Amazon Connect instance.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.connect.*;
 * EvaluationFormSectionProperty evaluationFormSectionProperty_;
 * CfnEvaluationForm cfnEvaluationForm = CfnEvaluationForm.Builder.create(this, "MyCfnEvaluationForm")
 *         .instanceArn("instanceArn")
 *         .items(List.of(EvaluationFormBaseItemProperty.builder()
 *                 .section(EvaluationFormSectionProperty.builder()
 *                         .refId("refId")
 *                         .title("title")
 *                         // the properties below are optional
 *                         .instructions("instructions")
 *                         .items(List.of(EvaluationFormItemProperty.builder()
 *                                 .question(EvaluationFormQuestionProperty.builder()
 *                                         .questionType("questionType")
 *                                         .refId("refId")
 *                                         .title("title")
 *                                         // the properties below are optional
 *                                         .enablement(EvaluationFormItemEnablementConfigurationProperty.builder()
 *                                                 .action("action")
 *                                                 .condition(EvaluationFormItemEnablementConditionProperty.builder()
 *                                                         .operands(List.of(EvaluationFormItemEnablementConditionOperandProperty.builder()
 *                                                                 .expression(EvaluationFormItemEnablementExpressionProperty.builder()
 *                                                                         .comparator("comparator")
 *                                                                         .source(EvaluationFormItemEnablementSourceProperty.builder()
 *                                                                                 .type("type")
 *                                                                                 // the properties below are optional
 *                                                                                 .refId("refId")
 *                                                                                 .build())
 *                                                                         .values(List.of(EvaluationFormItemEnablementSourceValueProperty.builder()
 *                                                                                 .refId("refId")
 *                                                                                 .type("type")
 *                                                                                 .build()))
 *                                                                         .build())
 *                                                                 .build()))
 *                                                         // the properties below are optional
 *                                                         .operator("operator")
 *                                                         .build())
 *                                                 // the properties below are optional
 *                                                 .defaultAction("defaultAction")
 *                                                 .build())
 *                                         .instructions("instructions")
 *                                         .notApplicableEnabled(false)
 *                                         .questionTypeProperties(EvaluationFormQuestionTypePropertiesProperty.builder()
 *                                                 .multiSelect(EvaluationFormMultiSelectQuestionPropertiesProperty.builder()
 *                                                         .options(List.of(EvaluationFormMultiSelectQuestionOptionProperty.builder()
 *                                                                 .refId("refId")
 *                                                                 .text("text")
 *                                                                 .build()))
 *                                                         // the properties below are optional
 *                                                         .automation(EvaluationFormMultiSelectQuestionAutomationProperty.builder()
 *                                                                 .options(List.of(EvaluationFormMultiSelectQuestionAutomationOptionProperty.builder()
 *                                                                         .ruleCategory(MultiSelectQuestionRuleCategoryAutomationProperty.builder()
 *                                                                                 .category("category")
 *                                                                                 .condition("condition")
 *                                                                                 .optionRefIds(List.of("optionRefIds"))
 *                                                                                 .build())
 *                                                                         .build()))
 *                                                                 // the properties below are optional
 *                                                                 .answerSource(EvaluationFormQuestionAutomationAnswerSourceProperty.builder()
 *                                                                         .sourceType("sourceType")
 *                                                                         .build())
 *                                                                 .defaultOptionRefIds(List.of("defaultOptionRefIds"))
 *                                                                 .build())
 *                                                         .displayAs("displayAs")
 *                                                         .build())
 *                                                 .numeric(EvaluationFormNumericQuestionPropertiesProperty.builder()
 *                                                         .maxValue(123)
 *                                                         .minValue(123)
 *                                                         // the properties below are optional
 *                                                         .automation(EvaluationFormNumericQuestionAutomationProperty.builder()
 *                                                                 .answerSource(EvaluationFormQuestionAutomationAnswerSourceProperty.builder()
 *                                                                         .sourceType("sourceType")
 *                                                                         .build())
 *                                                                 .propertyValue(NumericQuestionPropertyValueAutomationProperty.builder()
 *                                                                         .label("label")
 *                                                                         .build())
 *                                                                 .build())
 *                                                         .options(List.of(EvaluationFormNumericQuestionOptionProperty.builder()
 *                                                                 .maxValue(123)
 *                                                                 .minValue(123)
 *                                                                 // the properties below are optional
 *                                                                 .automaticFail(false)
 *                                                                 .automaticFailConfiguration(AutomaticFailConfigurationProperty.builder()
 *                                                                         .targetSection("targetSection")
 *                                                                         .build())
 *                                                                 .score(123)
 *                                                                 .build()))
 *                                                         .build())
 *                                                 .singleSelect(EvaluationFormSingleSelectQuestionPropertiesProperty.builder()
 *                                                         .options(List.of(EvaluationFormSingleSelectQuestionOptionProperty.builder()
 *                                                                 .refId("refId")
 *                                                                 .text("text")
 *                                                                 // the properties below are optional
 *                                                                 .automaticFail(false)
 *                                                                 .automaticFailConfiguration(AutomaticFailConfigurationProperty.builder()
 *                                                                         .targetSection("targetSection")
 *                                                                         .build())
 *                                                                 .score(123)
 *                                                                 .build()))
 *                                                         // the properties below are optional
 *                                                         .automation(EvaluationFormSingleSelectQuestionAutomationProperty.builder()
 *                                                                 .options(List.of(EvaluationFormSingleSelectQuestionAutomationOptionProperty.builder()
 *                                                                         .ruleCategory(SingleSelectQuestionRuleCategoryAutomationProperty.builder()
 *                                                                                 .category("category")
 *                                                                                 .condition("condition")
 *                                                                                 .optionRefId("optionRefId")
 *                                                                                 .build())
 *                                                                         .build()))
 *                                                                 // the properties below are optional
 *                                                                 .answerSource(EvaluationFormQuestionAutomationAnswerSourceProperty.builder()
 *                                                                         .sourceType("sourceType")
 *                                                                         .build())
 *                                                                 .defaultOptionRefId("defaultOptionRefId")
 *                                                                 .build())
 *                                                         .displayAs("displayAs")
 *                                                         .build())
 *                                                 .text(EvaluationFormTextQuestionPropertiesProperty.builder()
 *                                                         .automation(EvaluationFormTextQuestionAutomationProperty.builder()
 *                                                                 .answerSource(EvaluationFormQuestionAutomationAnswerSourceProperty.builder()
 *                                                                         .sourceType("sourceType")
 *                                                                         .build())
 *                                                                 .build())
 *                                                         .build())
 *                                                 .build())
 *                                         .weight(123)
 *                                         .build())
 *                                 .section(evaluationFormSectionProperty_)
 *                                 .build()))
 *                         .weight(123)
 *                         .build())
 *                 .build()))
 *         .status("status")
 *         .title("title")
 *         // the properties below are optional
 *         .autoEvaluationConfiguration(AutoEvaluationConfigurationProperty.builder()
 *                 .enabled(false)
 *                 .build())
 *         .description("description")
 *         .languageConfiguration(EvaluationFormLanguageConfigurationProperty.builder()
 *                 .formLanguage("formLanguage")
 *                 .build())
 *         .scoringStrategy(ScoringStrategyProperty.builder()
 *                 .mode("mode")
 *                 .status("status")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .targetConfiguration(EvaluationFormTargetConfigurationProperty.builder()
 *                 .contactInteractionType("contactInteractionType")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:17.580Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm")
public class CfnEvaluationForm extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.connect.IEvaluationFormRef, software.amazon.awscdk.ITaggable {

    protected CfnEvaluationForm(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnEvaluationForm(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.connect.CfnEvaluationForm.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::Connect::EvaluationForm</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnEvaluationForm(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.connect.CfnEvaluationFormProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * @param resource This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String arnForEvaluationForm(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.connect.IEvaluationFormRef resource) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.connect.CfnEvaluationForm.class, "arnForEvaluationForm", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(resource, "resource is required") });
    }

    /**
     * Checks whether the given object is a CfnEvaluationForm.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isCfnEvaluationForm(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.connect.CfnEvaluationForm.class, "isCfnEvaluationForm", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the evaluation form.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEvaluationFormArn() {
        return software.amazon.jsii.Kernel.get(this, "attrEvaluationFormArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a EvaluationForm resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.connect.EvaluationFormReference getEvaluationFormRef() {
        return software.amazon.jsii.Kernel.get(this, "evaluationFormRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.connect.EvaluationFormReference.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The identifier of the Amazon Connect instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getInstanceArn() {
        return software.amazon.jsii.Kernel.get(this, "instanceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of the Amazon Connect instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "instanceArn", java.util.Objects.requireNonNull(value, "instanceArn is required"));
    }

    /**
     * Items that are part of the evaluation form.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormBaseItemProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getItems() {
        return software.amazon.jsii.Kernel.get(this, "items", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Items that are part of the evaluation form.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setItems(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "items", java.util.Objects.requireNonNull(value, "items is required"));
    }

    /**
     * Items that are part of the evaluation form.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setItems(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormBaseItemProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormBaseItemProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "items", java.util.Objects.requireNonNull(value, "items is required"));
    }

    /**
     * The status of the evaluation form.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getStatus() {
        return software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status of the evaluation form.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStatus(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "status", java.util.Objects.requireNonNull(value, "status is required"));
    }

    /**
     * A title of the evaluation form.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTitle() {
        return software.amazon.jsii.Kernel.get(this, "title", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A title of the evaluation form.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTitle(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "title", java.util.Objects.requireNonNull(value, "title is required"));
    }

    /**
     * The automatic evaluation configuration of an evaluation form.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.connect.CfnEvaluationForm.AutoEvaluationConfigurationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAutoEvaluationConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "autoEvaluationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The automatic evaluation configuration of an evaluation form.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoEvaluationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "autoEvaluationConfiguration", value);
    }

    /**
     * The automatic evaluation configuration of an evaluation form.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoEvaluationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.connect.CfnEvaluationForm.AutoEvaluationConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "autoEvaluationConfiguration", value);
    }

    /**
     * The description of the evaluation form.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the evaluation form.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormLanguageConfigurationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLanguageConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "languageConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLanguageConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "languageConfiguration", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLanguageConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormLanguageConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "languageConfiguration", value);
    }

    /**
     * A scoring strategy of the evaluation form.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.connect.CfnEvaluationForm.ScoringStrategyProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getScoringStrategy() {
        return software.amazon.jsii.Kernel.get(this, "scoringStrategy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A scoring strategy of the evaluation form.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScoringStrategy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "scoringStrategy", value);
    }

    /**
     * A scoring strategy of the evaluation form.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScoringStrategy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.connect.CfnEvaluationForm.ScoringStrategyProperty value) {
        software.amazon.jsii.Kernel.set(this, "scoringStrategy", value);
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormTargetConfigurationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTargetConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "targetConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargetConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "targetConfiguration", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargetConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormTargetConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "targetConfiguration", value);
    }
    /**
     * Configuration information about automated evaluations.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * AutoEvaluationConfigurationProperty autoEvaluationConfigurationProperty = AutoEvaluationConfigurationProperty.builder()
     *         .enabled(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-autoevaluationconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-autoevaluationconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm.AutoEvaluationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AutoEvaluationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AutoEvaluationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-autoevaluationconfiguration.html#cfn-connect-evaluationform-autoevaluationconfiguration-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-autoevaluationconfiguration.html#cfn-connect-evaluationform-autoevaluationconfiguration-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AutoEvaluationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AutoEvaluationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AutoEvaluationConfigurationProperty> {
            java.lang.Object enabled;

            /**
             * Sets the value of {@link AutoEvaluationConfigurationProperty#getEnabled}
             * @param enabled the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link AutoEvaluationConfigurationProperty#getEnabled}
             * @param enabled the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AutoEvaluationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AutoEvaluationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AutoEvaluationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutoEvaluationConfigurationProperty {
            private final java.lang.Object enabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = builder.enabled;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnEvaluationForm.AutoEvaluationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AutoEvaluationConfigurationProperty.Jsii$Proxy that = (AutoEvaluationConfigurationProperty.Jsii$Proxy) o;

                return this.enabled != null ? this.enabled.equals(that.enabled) : that.enabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Information about automatic fail configuration for an evaluation form.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * AutomaticFailConfigurationProperty automaticFailConfigurationProperty = AutomaticFailConfigurationProperty.builder()
     *         .targetSection("targetSection")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-automaticfailconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-automaticfailconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm.AutomaticFailConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AutomaticFailConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AutomaticFailConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The referenceId of the target section for auto failure.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-automaticfailconfiguration.html#cfn-connect-evaluationform-automaticfailconfiguration-targetsection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-automaticfailconfiguration.html#cfn-connect-evaluationform-automaticfailconfiguration-targetsection</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTargetSection() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AutomaticFailConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AutomaticFailConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AutomaticFailConfigurationProperty> {
            java.lang.String targetSection;

            /**
             * Sets the value of {@link AutomaticFailConfigurationProperty#getTargetSection}
             * @param targetSection The referenceId of the target section for auto failure.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetSection(java.lang.String targetSection) {
                this.targetSection = targetSection;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AutomaticFailConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AutomaticFailConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AutomaticFailConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutomaticFailConfigurationProperty {
            private final java.lang.String targetSection;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.targetSection = software.amazon.jsii.Kernel.get(this, "targetSection", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.targetSection = builder.targetSection;
            }

            @Override
            public final java.lang.String getTargetSection() {
                return this.targetSection;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getTargetSection() != null) {
                    data.set("targetSection", om.valueToTree(this.getTargetSection()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnEvaluationForm.AutomaticFailConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AutomaticFailConfigurationProperty.Jsii$Proxy that = (AutomaticFailConfigurationProperty.Jsii$Proxy) o;

                return this.targetSection != null ? this.targetSection.equals(that.targetSection) : that.targetSection == null;
            }

            @Override
            public final int hashCode() {
                int result = this.targetSection != null ? this.targetSection.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * An item at the root level.
     * <p>
     * All items must be sections.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * EvaluationFormSectionProperty evaluationFormSectionProperty_;
     * EvaluationFormBaseItemProperty evaluationFormBaseItemProperty = EvaluationFormBaseItemProperty.builder()
     *         .section(EvaluationFormSectionProperty.builder()
     *                 .refId("refId")
     *                 .title("title")
     *                 // the properties below are optional
     *                 .instructions("instructions")
     *                 .items(List.of(EvaluationFormItemProperty.builder()
     *                         .question(EvaluationFormQuestionProperty.builder()
     *                                 .questionType("questionType")
     *                                 .refId("refId")
     *                                 .title("title")
     *                                 // the properties below are optional
     *                                 .enablement(EvaluationFormItemEnablementConfigurationProperty.builder()
     *                                         .action("action")
     *                                         .condition(EvaluationFormItemEnablementConditionProperty.builder()
     *                                                 .operands(List.of(EvaluationFormItemEnablementConditionOperandProperty.builder()
     *                                                         .expression(EvaluationFormItemEnablementExpressionProperty.builder()
     *                                                                 .comparator("comparator")
     *                                                                 .source(EvaluationFormItemEnablementSourceProperty.builder()
     *                                                                         .type("type")
     *                                                                         // the properties below are optional
     *                                                                         .refId("refId")
     *                                                                         .build())
     *                                                                 .values(List.of(EvaluationFormItemEnablementSourceValueProperty.builder()
     *                                                                         .refId("refId")
     *                                                                         .type("type")
     *                                                                         .build()))
     *                                                                 .build())
     *                                                         .build()))
     *                                                 // the properties below are optional
     *                                                 .operator("operator")
     *                                                 .build())
     *                                         // the properties below are optional
     *                                         .defaultAction("defaultAction")
     *                                         .build())
     *                                 .instructions("instructions")
     *                                 .notApplicableEnabled(false)
     *                                 .questionTypeProperties(EvaluationFormQuestionTypePropertiesProperty.builder()
     *                                         .multiSelect(EvaluationFormMultiSelectQuestionPropertiesProperty.builder()
     *                                                 .options(List.of(EvaluationFormMultiSelectQuestionOptionProperty.builder()
     *                                                         .refId("refId")
     *                                                         .text("text")
     *                                                         .build()))
     *                                                 // the properties below are optional
     *                                                 .automation(EvaluationFormMultiSelectQuestionAutomationProperty.builder()
     *                                                         .options(List.of(EvaluationFormMultiSelectQuestionAutomationOptionProperty.builder()
     *                                                                 .ruleCategory(MultiSelectQuestionRuleCategoryAutomationProperty.builder()
     *                                                                         .category("category")
     *                                                                         .condition("condition")
     *                                                                         .optionRefIds(List.of("optionRefIds"))
     *                                                                         .build())
     *                                                                 .build()))
     *                                                         // the properties below are optional
     *                                                         .answerSource(EvaluationFormQuestionAutomationAnswerSourceProperty.builder()
     *                                                                 .sourceType("sourceType")
     *                                                                 .build())
     *                                                         .defaultOptionRefIds(List.of("defaultOptionRefIds"))
     *                                                         .build())
     *                                                 .displayAs("displayAs")
     *                                                 .build())
     *                                         .numeric(EvaluationFormNumericQuestionPropertiesProperty.builder()
     *                                                 .maxValue(123)
     *                                                 .minValue(123)
     *                                                 // the properties below are optional
     *                                                 .automation(EvaluationFormNumericQuestionAutomationProperty.builder()
     *                                                         .answerSource(EvaluationFormQuestionAutomationAnswerSourceProperty.builder()
     *                                                                 .sourceType("sourceType")
     *                                                                 .build())
     *                                                         .propertyValue(NumericQuestionPropertyValueAutomationProperty.builder()
     *                                                                 .label("label")
     *                                                                 .build())
     *                                                         .build())
     *                                                 .options(List.of(EvaluationFormNumericQuestionOptionProperty.builder()
     *                                                         .maxValue(123)
     *                                                         .minValue(123)
     *                                                         // the properties below are optional
     *                                                         .automaticFail(false)
     *                                                         .automaticFailConfiguration(AutomaticFailConfigurationProperty.builder()
     *                                                                 .targetSection("targetSection")
     *                                                                 .build())
     *                                                         .score(123)
     *                                                         .build()))
     *                                                 .build())
     *                                         .singleSelect(EvaluationFormSingleSelectQuestionPropertiesProperty.builder()
     *                                                 .options(List.of(EvaluationFormSingleSelectQuestionOptionProperty.builder()
     *                                                         .refId("refId")
     *                                                         .text("text")
     *                                                         // the properties below are optional
     *                                                         .automaticFail(false)
     *                                                         .automaticFailConfiguration(AutomaticFailConfigurationProperty.builder()
     *                                                                 .targetSection("targetSection")
     *                                                                 .build())
     *                                                         .score(123)
     *                                                         .build()))
     *                                                 // the properties below are optional
     *                                                 .automation(EvaluationFormSingleSelectQuestionAutomationProperty.builder()
     *                                                         .options(List.of(EvaluationFormSingleSelectQuestionAutomationOptionProperty.builder()
     *                                                                 .ruleCategory(SingleSelectQuestionRuleCategoryAutomationProperty.builder()
     *                                                                         .category("category")
     *                                                                         .condition("condition")
     *                                                                         .optionRefId("optionRefId")
     *                                                                         .build())
     *                                                                 .build()))
     *                                                         // the properties below are optional
     *                                                         .answerSource(EvaluationFormQuestionAutomationAnswerSourceProperty.builder()
     *                                                                 .sourceType("sourceType")
     *                                                                 .build())
     *                                                         .defaultOptionRefId("defaultOptionRefId")
     *                                                         .build())
     *                                                 .displayAs("displayAs")
     *                                                 .build())
     *                                         .text(EvaluationFormTextQuestionPropertiesProperty.builder()
     *                                                 .automation(EvaluationFormTextQuestionAutomationProperty.builder()
     *                                                         .answerSource(EvaluationFormQuestionAutomationAnswerSourceProperty.builder()
     *                                                                 .sourceType("sourceType")
     *                                                                 .build())
     *                                                         .build())
     *                                                 .build())
     *                                         .build())
     *                                 .weight(123)
     *                                 .build())
     *                         .section(evaluationFormSectionProperty_)
     *                         .build()))
     *                 .weight(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformbaseitem.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformbaseitem.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormBaseItemProperty")
    @software.amazon.jsii.Jsii.Proxy(EvaluationFormBaseItemProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EvaluationFormBaseItemProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A subsection or inner section of an item.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormSectionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformbaseitem.html#cfn-connect-evaluationform-evaluationformbaseitem-section">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformbaseitem.html#cfn-connect-evaluationform-evaluationformbaseitem-section</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSection();

        /**
         * @return a {@link Builder} of {@link EvaluationFormBaseItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EvaluationFormBaseItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EvaluationFormBaseItemProperty> {
            java.lang.Object section;

            /**
             * Sets the value of {@link EvaluationFormBaseItemProperty#getSection}
             * @param section A subsection or inner section of an item. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder section(software.amazon.awscdk.IResolvable section) {
                this.section = section;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormBaseItemProperty#getSection}
             * @param section A subsection or inner section of an item. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder section(software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormSectionProperty section) {
                this.section = section;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EvaluationFormBaseItemProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EvaluationFormBaseItemProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EvaluationFormBaseItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EvaluationFormBaseItemProperty {
            private final java.lang.Object section;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.section = software.amazon.jsii.Kernel.get(this, "section", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.section = java.util.Objects.requireNonNull(builder.section, "section is required");
            }

            @Override
            public final java.lang.Object getSection() {
                return this.section;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("section", om.valueToTree(this.getSection()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormBaseItemProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EvaluationFormBaseItemProperty.Jsii$Proxy that = (EvaluationFormBaseItemProperty.Jsii$Proxy) o;

                return this.section.equals(that.section);
            }

            @Override
            public final int hashCode() {
                int result = this.section.hashCode();
                return result;
            }
        }
    }
    /**
     * An operand of the enablement condition.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * EvaluationFormItemEnablementConditionOperandProperty evaluationFormItemEnablementConditionOperandProperty = EvaluationFormItemEnablementConditionOperandProperty.builder()
     *         .expression(EvaluationFormItemEnablementExpressionProperty.builder()
     *                 .comparator("comparator")
     *                 .source(EvaluationFormItemEnablementSourceProperty.builder()
     *                         .type("type")
     *                         // the properties below are optional
     *                         .refId("refId")
     *                         .build())
     *                 .values(List.of(EvaluationFormItemEnablementSourceValueProperty.builder()
     *                         .refId("refId")
     *                         .type("type")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitemenablementconditionoperand.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitemenablementconditionoperand.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormItemEnablementConditionOperandProperty")
    @software.amazon.jsii.Jsii.Proxy(EvaluationFormItemEnablementConditionOperandProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EvaluationFormItemEnablementConditionOperandProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An expression of the enablement condition.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormItemEnablementExpressionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitemenablementconditionoperand.html#cfn-connect-evaluationform-evaluationformitemenablementconditionoperand-expression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitemenablementconditionoperand.html#cfn-connect-evaluationform-evaluationformitemenablementconditionoperand-expression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExpression() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EvaluationFormItemEnablementConditionOperandProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EvaluationFormItemEnablementConditionOperandProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EvaluationFormItemEnablementConditionOperandProperty> {
            java.lang.Object expression;

            /**
             * Sets the value of {@link EvaluationFormItemEnablementConditionOperandProperty#getExpression}
             * @param expression An expression of the enablement condition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expression(software.amazon.awscdk.IResolvable expression) {
                this.expression = expression;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormItemEnablementConditionOperandProperty#getExpression}
             * @param expression An expression of the enablement condition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expression(software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormItemEnablementExpressionProperty expression) {
                this.expression = expression;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EvaluationFormItemEnablementConditionOperandProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EvaluationFormItemEnablementConditionOperandProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EvaluationFormItemEnablementConditionOperandProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EvaluationFormItemEnablementConditionOperandProperty {
            private final java.lang.Object expression;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.expression = software.amazon.jsii.Kernel.get(this, "expression", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.expression = builder.expression;
            }

            @Override
            public final java.lang.Object getExpression() {
                return this.expression;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExpression() != null) {
                    data.set("expression", om.valueToTree(this.getExpression()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormItemEnablementConditionOperandProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EvaluationFormItemEnablementConditionOperandProperty.Jsii$Proxy that = (EvaluationFormItemEnablementConditionOperandProperty.Jsii$Proxy) o;

                return this.expression != null ? this.expression.equals(that.expression) : that.expression == null;
            }

            @Override
            public final int hashCode() {
                int result = this.expression != null ? this.expression.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A condition for item enablement.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * EvaluationFormItemEnablementConditionProperty evaluationFormItemEnablementConditionProperty = EvaluationFormItemEnablementConditionProperty.builder()
     *         .operands(List.of(EvaluationFormItemEnablementConditionOperandProperty.builder()
     *                 .expression(EvaluationFormItemEnablementExpressionProperty.builder()
     *                         .comparator("comparator")
     *                         .source(EvaluationFormItemEnablementSourceProperty.builder()
     *                                 .type("type")
     *                                 // the properties below are optional
     *                                 .refId("refId")
     *                                 .build())
     *                         .values(List.of(EvaluationFormItemEnablementSourceValueProperty.builder()
     *                                 .refId("refId")
     *                                 .type("type")
     *                                 .build()))
     *                         .build())
     *                 .build()))
     *         // the properties below are optional
     *         .operator("operator")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitemenablementcondition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitemenablementcondition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormItemEnablementConditionProperty")
    @software.amazon.jsii.Jsii.Proxy(EvaluationFormItemEnablementConditionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EvaluationFormItemEnablementConditionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Operands of the enablement condition.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormItemEnablementConditionOperandProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitemenablementcondition.html#cfn-connect-evaluationform-evaluationformitemenablementcondition-operands">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitemenablementcondition.html#cfn-connect-evaluationform-evaluationformitemenablementcondition-operands</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getOperands();

        /**
         * The operator to be used to be applied to operands if more than one provided.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitemenablementcondition.html#cfn-connect-evaluationform-evaluationformitemenablementcondition-operator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitemenablementcondition.html#cfn-connect-evaluationform-evaluationformitemenablementcondition-operator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOperator() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EvaluationFormItemEnablementConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EvaluationFormItemEnablementConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EvaluationFormItemEnablementConditionProperty> {
            java.lang.Object operands;
            java.lang.String operator;

            /**
             * Sets the value of {@link EvaluationFormItemEnablementConditionProperty#getOperands}
             * @param operands Operands of the enablement condition. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder operands(software.amazon.awscdk.IResolvable operands) {
                this.operands = operands;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormItemEnablementConditionProperty#getOperands}
             * @param operands Operands of the enablement condition. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder operands(java.util.List<? extends java.lang.Object> operands) {
                this.operands = operands;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormItemEnablementConditionProperty#getOperator}
             * @param operator The operator to be used to be applied to operands if more than one provided.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder operator(java.lang.String operator) {
                this.operator = operator;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EvaluationFormItemEnablementConditionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EvaluationFormItemEnablementConditionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EvaluationFormItemEnablementConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EvaluationFormItemEnablementConditionProperty {
            private final java.lang.Object operands;
            private final java.lang.String operator;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.operands = software.amazon.jsii.Kernel.get(this, "operands", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.operator = software.amazon.jsii.Kernel.get(this, "operator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.operands = java.util.Objects.requireNonNull(builder.operands, "operands is required");
                this.operator = builder.operator;
            }

            @Override
            public final java.lang.Object getOperands() {
                return this.operands;
            }

            @Override
            public final java.lang.String getOperator() {
                return this.operator;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("operands", om.valueToTree(this.getOperands()));
                if (this.getOperator() != null) {
                    data.set("operator", om.valueToTree(this.getOperator()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormItemEnablementConditionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EvaluationFormItemEnablementConditionProperty.Jsii$Proxy that = (EvaluationFormItemEnablementConditionProperty.Jsii$Proxy) o;

                if (!operands.equals(that.operands)) return false;
                return this.operator != null ? this.operator.equals(that.operator) : that.operator == null;
            }

            @Override
            public final int hashCode() {
                int result = this.operands.hashCode();
                result = 31 * result + (this.operator != null ? this.operator.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An item enablement configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * EvaluationFormItemEnablementConfigurationProperty evaluationFormItemEnablementConfigurationProperty = EvaluationFormItemEnablementConfigurationProperty.builder()
     *         .action("action")
     *         .condition(EvaluationFormItemEnablementConditionProperty.builder()
     *                 .operands(List.of(EvaluationFormItemEnablementConditionOperandProperty.builder()
     *                         .expression(EvaluationFormItemEnablementExpressionProperty.builder()
     *                                 .comparator("comparator")
     *                                 .source(EvaluationFormItemEnablementSourceProperty.builder()
     *                                         .type("type")
     *                                         // the properties below are optional
     *                                         .refId("refId")
     *                                         .build())
     *                                 .values(List.of(EvaluationFormItemEnablementSourceValueProperty.builder()
     *                                         .refId("refId")
     *                                         .type("type")
     *                                         .build()))
     *                                 .build())
     *                         .build()))
     *                 // the properties below are optional
     *                 .operator("operator")
     *                 .build())
     *         // the properties below are optional
     *         .defaultAction("defaultAction")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitemenablementconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitemenablementconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormItemEnablementConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(EvaluationFormItemEnablementConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EvaluationFormItemEnablementConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An enablement action that if condition is satisfied.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitemenablementconfiguration.html#cfn-connect-evaluationform-evaluationformitemenablementconfiguration-action">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitemenablementconfiguration.html#cfn-connect-evaluationform-evaluationformitemenablementconfiguration-action</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAction();

        /**
         * A condition for item enablement configuration.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormItemEnablementConditionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitemenablementconfiguration.html#cfn-connect-evaluationform-evaluationformitemenablementconfiguration-condition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitemenablementconfiguration.html#cfn-connect-evaluationform-evaluationformitemenablementconfiguration-condition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getCondition();

        /**
         * An enablement action that if condition is not satisfied.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitemenablementconfiguration.html#cfn-connect-evaluationform-evaluationformitemenablementconfiguration-defaultaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitemenablementconfiguration.html#cfn-connect-evaluationform-evaluationformitemenablementconfiguration-defaultaction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDefaultAction() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EvaluationFormItemEnablementConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EvaluationFormItemEnablementConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EvaluationFormItemEnablementConfigurationProperty> {
            java.lang.String action;
            java.lang.Object condition;
            java.lang.String defaultAction;

            /**
             * Sets the value of {@link EvaluationFormItemEnablementConfigurationProperty#getAction}
             * @param action An enablement action that if condition is satisfied. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(java.lang.String action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormItemEnablementConfigurationProperty#getCondition}
             * @param condition A condition for item enablement configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder condition(software.amazon.awscdk.IResolvable condition) {
                this.condition = condition;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormItemEnablementConfigurationProperty#getCondition}
             * @param condition A condition for item enablement configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder condition(software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormItemEnablementConditionProperty condition) {
                this.condition = condition;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormItemEnablementConfigurationProperty#getDefaultAction}
             * @param defaultAction An enablement action that if condition is not satisfied.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultAction(java.lang.String defaultAction) {
                this.defaultAction = defaultAction;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EvaluationFormItemEnablementConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EvaluationFormItemEnablementConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EvaluationFormItemEnablementConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EvaluationFormItemEnablementConfigurationProperty {
            private final java.lang.String action;
            private final java.lang.Object condition;
            private final java.lang.String defaultAction;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.condition = software.amazon.jsii.Kernel.get(this, "condition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.defaultAction = software.amazon.jsii.Kernel.get(this, "defaultAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.action = java.util.Objects.requireNonNull(builder.action, "action is required");
                this.condition = java.util.Objects.requireNonNull(builder.condition, "condition is required");
                this.defaultAction = builder.defaultAction;
            }

            @Override
            public final java.lang.String getAction() {
                return this.action;
            }

            @Override
            public final java.lang.Object getCondition() {
                return this.condition;
            }

            @Override
            public final java.lang.String getDefaultAction() {
                return this.defaultAction;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("action", om.valueToTree(this.getAction()));
                data.set("condition", om.valueToTree(this.getCondition()));
                if (this.getDefaultAction() != null) {
                    data.set("defaultAction", om.valueToTree(this.getDefaultAction()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormItemEnablementConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EvaluationFormItemEnablementConfigurationProperty.Jsii$Proxy that = (EvaluationFormItemEnablementConfigurationProperty.Jsii$Proxy) o;

                if (!action.equals(that.action)) return false;
                if (!condition.equals(that.condition)) return false;
                return this.defaultAction != null ? this.defaultAction.equals(that.defaultAction) : that.defaultAction == null;
            }

            @Override
            public final int hashCode() {
                int result = this.action.hashCode();
                result = 31 * result + (this.condition.hashCode());
                result = 31 * result + (this.defaultAction != null ? this.defaultAction.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An expression that defines a basic building block of conditional enablement.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * EvaluationFormItemEnablementExpressionProperty evaluationFormItemEnablementExpressionProperty = EvaluationFormItemEnablementExpressionProperty.builder()
     *         .comparator("comparator")
     *         .source(EvaluationFormItemEnablementSourceProperty.builder()
     *                 .type("type")
     *                 // the properties below are optional
     *                 .refId("refId")
     *                 .build())
     *         .values(List.of(EvaluationFormItemEnablementSourceValueProperty.builder()
     *                 .refId("refId")
     *                 .type("type")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitemenablementexpression.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitemenablementexpression.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormItemEnablementExpressionProperty")
    @software.amazon.jsii.Jsii.Proxy(EvaluationFormItemEnablementExpressionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EvaluationFormItemEnablementExpressionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A comparator to be used against list of values.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitemenablementexpression.html#cfn-connect-evaluationform-evaluationformitemenablementexpression-comparator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitemenablementexpression.html#cfn-connect-evaluationform-evaluationformitemenablementexpression-comparator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getComparator();

        /**
         * A source item of enablement expression.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormItemEnablementSourceProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitemenablementexpression.html#cfn-connect-evaluationform-evaluationformitemenablementexpression-source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitemenablementexpression.html#cfn-connect-evaluationform-evaluationformitemenablementexpression-source</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSource();

        /**
         * A list of values from source item.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormItemEnablementSourceValueProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitemenablementexpression.html#cfn-connect-evaluationform-evaluationformitemenablementexpression-values">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitemenablementexpression.html#cfn-connect-evaluationform-evaluationformitemenablementexpression-values</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getValues();

        /**
         * @return a {@link Builder} of {@link EvaluationFormItemEnablementExpressionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EvaluationFormItemEnablementExpressionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EvaluationFormItemEnablementExpressionProperty> {
            java.lang.String comparator;
            java.lang.Object source;
            java.lang.Object values;

            /**
             * Sets the value of {@link EvaluationFormItemEnablementExpressionProperty#getComparator}
             * @param comparator A comparator to be used against list of values. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder comparator(java.lang.String comparator) {
                this.comparator = comparator;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormItemEnablementExpressionProperty#getSource}
             * @param source A source item of enablement expression. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(software.amazon.awscdk.IResolvable source) {
                this.source = source;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormItemEnablementExpressionProperty#getSource}
             * @param source A source item of enablement expression. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormItemEnablementSourceProperty source) {
                this.source = source;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormItemEnablementExpressionProperty#getValues}
             * @param values A list of values from source item. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(software.amazon.awscdk.IResolvable values) {
                this.values = values;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormItemEnablementExpressionProperty#getValues}
             * @param values A list of values from source item. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<? extends java.lang.Object> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EvaluationFormItemEnablementExpressionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EvaluationFormItemEnablementExpressionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EvaluationFormItemEnablementExpressionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EvaluationFormItemEnablementExpressionProperty {
            private final java.lang.String comparator;
            private final java.lang.Object source;
            private final java.lang.Object values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.comparator = software.amazon.jsii.Kernel.get(this, "comparator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.comparator = java.util.Objects.requireNonNull(builder.comparator, "comparator is required");
                this.source = java.util.Objects.requireNonNull(builder.source, "source is required");
                this.values = java.util.Objects.requireNonNull(builder.values, "values is required");
            }

            @Override
            public final java.lang.String getComparator() {
                return this.comparator;
            }

            @Override
            public final java.lang.Object getSource() {
                return this.source;
            }

            @Override
            public final java.lang.Object getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("comparator", om.valueToTree(this.getComparator()));
                data.set("source", om.valueToTree(this.getSource()));
                data.set("values", om.valueToTree(this.getValues()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormItemEnablementExpressionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EvaluationFormItemEnablementExpressionProperty.Jsii$Proxy that = (EvaluationFormItemEnablementExpressionProperty.Jsii$Proxy) o;

                if (!comparator.equals(that.comparator)) return false;
                if (!source.equals(that.source)) return false;
                return this.values.equals(that.values);
            }

            @Override
            public final int hashCode() {
                int result = this.comparator.hashCode();
                result = 31 * result + (this.source.hashCode());
                result = 31 * result + (this.values.hashCode());
                return result;
            }
        }
    }
    /**
     * An enablement expression source item.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * EvaluationFormItemEnablementSourceProperty evaluationFormItemEnablementSourceProperty = EvaluationFormItemEnablementSourceProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .refId("refId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitemenablementsource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitemenablementsource.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormItemEnablementSourceProperty")
    @software.amazon.jsii.Jsii.Proxy(EvaluationFormItemEnablementSourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EvaluationFormItemEnablementSourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A type of source item.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitemenablementsource.html#cfn-connect-evaluationform-evaluationformitemenablementsource-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitemenablementsource.html#cfn-connect-evaluationform-evaluationformitemenablementsource-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * A referenceId of the source item.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitemenablementsource.html#cfn-connect-evaluationform-evaluationformitemenablementsource-refid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitemenablementsource.html#cfn-connect-evaluationform-evaluationformitemenablementsource-refid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRefId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EvaluationFormItemEnablementSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EvaluationFormItemEnablementSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EvaluationFormItemEnablementSourceProperty> {
            java.lang.String type;
            java.lang.String refId;

            /**
             * Sets the value of {@link EvaluationFormItemEnablementSourceProperty#getType}
             * @param type A type of source item. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormItemEnablementSourceProperty#getRefId}
             * @param refId A referenceId of the source item.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder refId(java.lang.String refId) {
                this.refId = refId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EvaluationFormItemEnablementSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EvaluationFormItemEnablementSourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EvaluationFormItemEnablementSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EvaluationFormItemEnablementSourceProperty {
            private final java.lang.String type;
            private final java.lang.String refId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.refId = software.amazon.jsii.Kernel.get(this, "refId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.refId = builder.refId;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getRefId() {
                return this.refId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getRefId() != null) {
                    data.set("refId", om.valueToTree(this.getRefId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormItemEnablementSourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EvaluationFormItemEnablementSourceProperty.Jsii$Proxy that = (EvaluationFormItemEnablementSourceProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                return this.refId != null ? this.refId.equals(that.refId) : that.refId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.refId != null ? this.refId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An enablement expression source value.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * EvaluationFormItemEnablementSourceValueProperty evaluationFormItemEnablementSourceValueProperty = EvaluationFormItemEnablementSourceValueProperty.builder()
     *         .refId("refId")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitemenablementsourcevalue.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitemenablementsourcevalue.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormItemEnablementSourceValueProperty")
    @software.amazon.jsii.Jsii.Proxy(EvaluationFormItemEnablementSourceValueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EvaluationFormItemEnablementSourceValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A referenceId of the source value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitemenablementsourcevalue.html#cfn-connect-evaluationform-evaluationformitemenablementsourcevalue-refid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitemenablementsourcevalue.html#cfn-connect-evaluationform-evaluationformitemenablementsourcevalue-refid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRefId() {
            return null;
        }

        /**
         * A type of source item value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitemenablementsourcevalue.html#cfn-connect-evaluationform-evaluationformitemenablementsourcevalue-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitemenablementsourcevalue.html#cfn-connect-evaluationform-evaluationformitemenablementsourcevalue-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EvaluationFormItemEnablementSourceValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EvaluationFormItemEnablementSourceValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EvaluationFormItemEnablementSourceValueProperty> {
            java.lang.String refId;
            java.lang.String type;

            /**
             * Sets the value of {@link EvaluationFormItemEnablementSourceValueProperty#getRefId}
             * @param refId A referenceId of the source value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder refId(java.lang.String refId) {
                this.refId = refId;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormItemEnablementSourceValueProperty#getType}
             * @param type A type of source item value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EvaluationFormItemEnablementSourceValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EvaluationFormItemEnablementSourceValueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EvaluationFormItemEnablementSourceValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EvaluationFormItemEnablementSourceValueProperty {
            private final java.lang.String refId;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.refId = software.amazon.jsii.Kernel.get(this, "refId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.refId = builder.refId;
                this.type = builder.type;
            }

            @Override
            public final java.lang.String getRefId() {
                return this.refId;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRefId() != null) {
                    data.set("refId", om.valueToTree(this.getRefId()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormItemEnablementSourceValueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EvaluationFormItemEnablementSourceValueProperty.Jsii$Proxy that = (EvaluationFormItemEnablementSourceValueProperty.Jsii$Proxy) o;

                if (this.refId != null ? !this.refId.equals(that.refId) : that.refId != null) return false;
                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.refId != null ? this.refId.hashCode() : 0;
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Items that are part of the evaluation form.
     * <p>
     * The total number of sections and questions must not exceed 100 each. Questions must be contained in a section.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * EvaluationFormItemProperty evaluationFormItemProperty_;
     * EvaluationFormItemProperty evaluationFormItemProperty = EvaluationFormItemProperty.builder()
     *         .question(EvaluationFormQuestionProperty.builder()
     *                 .questionType("questionType")
     *                 .refId("refId")
     *                 .title("title")
     *                 // the properties below are optional
     *                 .enablement(EvaluationFormItemEnablementConfigurationProperty.builder()
     *                         .action("action")
     *                         .condition(EvaluationFormItemEnablementConditionProperty.builder()
     *                                 .operands(List.of(EvaluationFormItemEnablementConditionOperandProperty.builder()
     *                                         .expression(EvaluationFormItemEnablementExpressionProperty.builder()
     *                                                 .comparator("comparator")
     *                                                 .source(EvaluationFormItemEnablementSourceProperty.builder()
     *                                                         .type("type")
     *                                                         // the properties below are optional
     *                                                         .refId("refId")
     *                                                         .build())
     *                                                 .values(List.of(EvaluationFormItemEnablementSourceValueProperty.builder()
     *                                                         .refId("refId")
     *                                                         .type("type")
     *                                                         .build()))
     *                                                 .build())
     *                                         .build()))
     *                                 // the properties below are optional
     *                                 .operator("operator")
     *                                 .build())
     *                         // the properties below are optional
     *                         .defaultAction("defaultAction")
     *                         .build())
     *                 .instructions("instructions")
     *                 .notApplicableEnabled(false)
     *                 .questionTypeProperties(EvaluationFormQuestionTypePropertiesProperty.builder()
     *                         .multiSelect(EvaluationFormMultiSelectQuestionPropertiesProperty.builder()
     *                                 .options(List.of(EvaluationFormMultiSelectQuestionOptionProperty.builder()
     *                                         .refId("refId")
     *                                         .text("text")
     *                                         .build()))
     *                                 // the properties below are optional
     *                                 .automation(EvaluationFormMultiSelectQuestionAutomationProperty.builder()
     *                                         .options(List.of(EvaluationFormMultiSelectQuestionAutomationOptionProperty.builder()
     *                                                 .ruleCategory(MultiSelectQuestionRuleCategoryAutomationProperty.builder()
     *                                                         .category("category")
     *                                                         .condition("condition")
     *                                                         .optionRefIds(List.of("optionRefIds"))
     *                                                         .build())
     *                                                 .build()))
     *                                         // the properties below are optional
     *                                         .answerSource(EvaluationFormQuestionAutomationAnswerSourceProperty.builder()
     *                                                 .sourceType("sourceType")
     *                                                 .build())
     *                                         .defaultOptionRefIds(List.of("defaultOptionRefIds"))
     *                                         .build())
     *                                 .displayAs("displayAs")
     *                                 .build())
     *                         .numeric(EvaluationFormNumericQuestionPropertiesProperty.builder()
     *                                 .maxValue(123)
     *                                 .minValue(123)
     *                                 // the properties below are optional
     *                                 .automation(EvaluationFormNumericQuestionAutomationProperty.builder()
     *                                         .answerSource(EvaluationFormQuestionAutomationAnswerSourceProperty.builder()
     *                                                 .sourceType("sourceType")
     *                                                 .build())
     *                                         .propertyValue(NumericQuestionPropertyValueAutomationProperty.builder()
     *                                                 .label("label")
     *                                                 .build())
     *                                         .build())
     *                                 .options(List.of(EvaluationFormNumericQuestionOptionProperty.builder()
     *                                         .maxValue(123)
     *                                         .minValue(123)
     *                                         // the properties below are optional
     *                                         .automaticFail(false)
     *                                         .automaticFailConfiguration(AutomaticFailConfigurationProperty.builder()
     *                                                 .targetSection("targetSection")
     *                                                 .build())
     *                                         .score(123)
     *                                         .build()))
     *                                 .build())
     *                         .singleSelect(EvaluationFormSingleSelectQuestionPropertiesProperty.builder()
     *                                 .options(List.of(EvaluationFormSingleSelectQuestionOptionProperty.builder()
     *                                         .refId("refId")
     *                                         .text("text")
     *                                         // the properties below are optional
     *                                         .automaticFail(false)
     *                                         .automaticFailConfiguration(AutomaticFailConfigurationProperty.builder()
     *                                                 .targetSection("targetSection")
     *                                                 .build())
     *                                         .score(123)
     *                                         .build()))
     *                                 // the properties below are optional
     *                                 .automation(EvaluationFormSingleSelectQuestionAutomationProperty.builder()
     *                                         .options(List.of(EvaluationFormSingleSelectQuestionAutomationOptionProperty.builder()
     *                                                 .ruleCategory(SingleSelectQuestionRuleCategoryAutomationProperty.builder()
     *                                                         .category("category")
     *                                                         .condition("condition")
     *                                                         .optionRefId("optionRefId")
     *                                                         .build())
     *                                                 .build()))
     *                                         // the properties below are optional
     *                                         .answerSource(EvaluationFormQuestionAutomationAnswerSourceProperty.builder()
     *                                                 .sourceType("sourceType")
     *                                                 .build())
     *                                         .defaultOptionRefId("defaultOptionRefId")
     *                                         .build())
     *                                 .displayAs("displayAs")
     *                                 .build())
     *                         .text(EvaluationFormTextQuestionPropertiesProperty.builder()
     *                                 .automation(EvaluationFormTextQuestionAutomationProperty.builder()
     *                                         .answerSource(EvaluationFormQuestionAutomationAnswerSourceProperty.builder()
     *                                                 .sourceType("sourceType")
     *                                                 .build())
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .weight(123)
     *                 .build())
     *         .section(EvaluationFormSectionProperty.builder()
     *                 .refId("refId")
     *                 .title("title")
     *                 // the properties below are optional
     *                 .instructions("instructions")
     *                 .items(List.of(evaluationFormItemProperty_))
     *                 .weight(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitem.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitem.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormItemProperty")
    @software.amazon.jsii.Jsii.Proxy(EvaluationFormItemProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EvaluationFormItemProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The information of the question.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormQuestionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitem.html#cfn-connect-evaluationform-evaluationformitem-question">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitem.html#cfn-connect-evaluationform-evaluationformitem-question</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getQuestion() {
            return null;
        }

        /**
         * The information of the section.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormSectionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitem.html#cfn-connect-evaluationform-evaluationformitem-section">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformitem.html#cfn-connect-evaluationform-evaluationformitem-section</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSection() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EvaluationFormItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EvaluationFormItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EvaluationFormItemProperty> {
            java.lang.Object question;
            java.lang.Object section;

            /**
             * Sets the value of {@link EvaluationFormItemProperty#getQuestion}
             * @param question The information of the question.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder question(software.amazon.awscdk.IResolvable question) {
                this.question = question;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormItemProperty#getQuestion}
             * @param question The information of the question.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder question(software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormQuestionProperty question) {
                this.question = question;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormItemProperty#getSection}
             * @param section The information of the section.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder section(software.amazon.awscdk.IResolvable section) {
                this.section = section;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormItemProperty#getSection}
             * @param section The information of the section.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder section(software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormSectionProperty section) {
                this.section = section;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EvaluationFormItemProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EvaluationFormItemProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EvaluationFormItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EvaluationFormItemProperty {
            private final java.lang.Object question;
            private final java.lang.Object section;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.question = software.amazon.jsii.Kernel.get(this, "question", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.section = software.amazon.jsii.Kernel.get(this, "section", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.question = builder.question;
                this.section = builder.section;
            }

            @Override
            public final java.lang.Object getQuestion() {
                return this.question;
            }

            @Override
            public final java.lang.Object getSection() {
                return this.section;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getQuestion() != null) {
                    data.set("question", om.valueToTree(this.getQuestion()));
                }
                if (this.getSection() != null) {
                    data.set("section", om.valueToTree(this.getSection()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormItemProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EvaluationFormItemProperty.Jsii$Proxy that = (EvaluationFormItemProperty.Jsii$Proxy) o;

                if (this.question != null ? !this.question.equals(that.question) : that.question != null) return false;
                return this.section != null ? this.section.equals(that.section) : that.section == null;
            }

            @Override
            public final int hashCode() {
                int result = this.question != null ? this.question.hashCode() : 0;
                result = 31 * result + (this.section != null ? this.section.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * EvaluationFormLanguageConfigurationProperty evaluationFormLanguageConfigurationProperty = EvaluationFormLanguageConfigurationProperty.builder()
     *         .formLanguage("formLanguage")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformlanguageconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformlanguageconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormLanguageConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(EvaluationFormLanguageConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EvaluationFormLanguageConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The language of the form.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformlanguageconfiguration.html#cfn-connect-evaluationform-evaluationformlanguageconfiguration-formlanguage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformlanguageconfiguration.html#cfn-connect-evaluationform-evaluationformlanguageconfiguration-formlanguage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFormLanguage() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EvaluationFormLanguageConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EvaluationFormLanguageConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EvaluationFormLanguageConfigurationProperty> {
            java.lang.String formLanguage;

            /**
             * Sets the value of {@link EvaluationFormLanguageConfigurationProperty#getFormLanguage}
             * @param formLanguage The language of the form.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder formLanguage(java.lang.String formLanguage) {
                this.formLanguage = formLanguage;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EvaluationFormLanguageConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EvaluationFormLanguageConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EvaluationFormLanguageConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EvaluationFormLanguageConfigurationProperty {
            private final java.lang.String formLanguage;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.formLanguage = software.amazon.jsii.Kernel.get(this, "formLanguage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.formLanguage = builder.formLanguage;
            }

            @Override
            public final java.lang.String getFormLanguage() {
                return this.formLanguage;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getFormLanguage() != null) {
                    data.set("formLanguage", om.valueToTree(this.getFormLanguage()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormLanguageConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EvaluationFormLanguageConfigurationProperty.Jsii$Proxy that = (EvaluationFormLanguageConfigurationProperty.Jsii$Proxy) o;

                return this.formLanguage != null ? this.formLanguage.equals(that.formLanguage) : that.formLanguage == null;
            }

            @Override
            public final int hashCode() {
                int result = this.formLanguage != null ? this.formLanguage.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * EvaluationFormMultiSelectQuestionAutomationOptionProperty evaluationFormMultiSelectQuestionAutomationOptionProperty = EvaluationFormMultiSelectQuestionAutomationOptionProperty.builder()
     *         .ruleCategory(MultiSelectQuestionRuleCategoryAutomationProperty.builder()
     *                 .category("category")
     *                 .condition("condition")
     *                 .optionRefIds(List.of("optionRefIds"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformmultiselectquestionautomationoption.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformmultiselectquestionautomationoption.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormMultiSelectQuestionAutomationOptionProperty")
    @software.amazon.jsii.Jsii.Proxy(EvaluationFormMultiSelectQuestionAutomationOptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EvaluationFormMultiSelectQuestionAutomationOptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.connect.CfnEvaluationForm.MultiSelectQuestionRuleCategoryAutomationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformmultiselectquestionautomationoption.html#cfn-connect-evaluationform-evaluationformmultiselectquestionautomationoption-rulecategory">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformmultiselectquestionautomationoption.html#cfn-connect-evaluationform-evaluationformmultiselectquestionautomationoption-rulecategory</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRuleCategory();

        /**
         * @return a {@link Builder} of {@link EvaluationFormMultiSelectQuestionAutomationOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EvaluationFormMultiSelectQuestionAutomationOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EvaluationFormMultiSelectQuestionAutomationOptionProperty> {
            java.lang.Object ruleCategory;

            /**
             * Sets the value of {@link EvaluationFormMultiSelectQuestionAutomationOptionProperty#getRuleCategory}
             * @param ruleCategory the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ruleCategory(software.amazon.awscdk.IResolvable ruleCategory) {
                this.ruleCategory = ruleCategory;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormMultiSelectQuestionAutomationOptionProperty#getRuleCategory}
             * @param ruleCategory the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ruleCategory(software.amazon.awscdk.services.connect.CfnEvaluationForm.MultiSelectQuestionRuleCategoryAutomationProperty ruleCategory) {
                this.ruleCategory = ruleCategory;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EvaluationFormMultiSelectQuestionAutomationOptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EvaluationFormMultiSelectQuestionAutomationOptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EvaluationFormMultiSelectQuestionAutomationOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EvaluationFormMultiSelectQuestionAutomationOptionProperty {
            private final java.lang.Object ruleCategory;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ruleCategory = software.amazon.jsii.Kernel.get(this, "ruleCategory", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ruleCategory = java.util.Objects.requireNonNull(builder.ruleCategory, "ruleCategory is required");
            }

            @Override
            public final java.lang.Object getRuleCategory() {
                return this.ruleCategory;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("ruleCategory", om.valueToTree(this.getRuleCategory()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormMultiSelectQuestionAutomationOptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EvaluationFormMultiSelectQuestionAutomationOptionProperty.Jsii$Proxy that = (EvaluationFormMultiSelectQuestionAutomationOptionProperty.Jsii$Proxy) o;

                return this.ruleCategory.equals(that.ruleCategory);
            }

            @Override
            public final int hashCode() {
                int result = this.ruleCategory.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * EvaluationFormMultiSelectQuestionAutomationProperty evaluationFormMultiSelectQuestionAutomationProperty = EvaluationFormMultiSelectQuestionAutomationProperty.builder()
     *         .options(List.of(EvaluationFormMultiSelectQuestionAutomationOptionProperty.builder()
     *                 .ruleCategory(MultiSelectQuestionRuleCategoryAutomationProperty.builder()
     *                         .category("category")
     *                         .condition("condition")
     *                         .optionRefIds(List.of("optionRefIds"))
     *                         .build())
     *                 .build()))
     *         // the properties below are optional
     *         .answerSource(EvaluationFormQuestionAutomationAnswerSourceProperty.builder()
     *                 .sourceType("sourceType")
     *                 .build())
     *         .defaultOptionRefIds(List.of("defaultOptionRefIds"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformmultiselectquestionautomation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformmultiselectquestionautomation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormMultiSelectQuestionAutomationProperty")
    @software.amazon.jsii.Jsii.Proxy(EvaluationFormMultiSelectQuestionAutomationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EvaluationFormMultiSelectQuestionAutomationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The answer options for the automation.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormMultiSelectQuestionAutomationOptionProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformmultiselectquestionautomation.html#cfn-connect-evaluationform-evaluationformmultiselectquestionautomation-options">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformmultiselectquestionautomation.html#cfn-connect-evaluationform-evaluationformmultiselectquestionautomation-options</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getOptions();

        /**
         * A question automation answer.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormQuestionAutomationAnswerSourceProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformmultiselectquestionautomation.html#cfn-connect-evaluationform-evaluationformmultiselectquestionautomation-answersource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformmultiselectquestionautomation.html#cfn-connect-evaluationform-evaluationformmultiselectquestionautomation-answersource</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAnswerSource() {
            return null;
        }

        /**
         * The list of reference id.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformmultiselectquestionautomation.html#cfn-connect-evaluationform-evaluationformmultiselectquestionautomation-defaultoptionrefids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformmultiselectquestionautomation.html#cfn-connect-evaluationform-evaluationformmultiselectquestionautomation-defaultoptionrefids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDefaultOptionRefIds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EvaluationFormMultiSelectQuestionAutomationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EvaluationFormMultiSelectQuestionAutomationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EvaluationFormMultiSelectQuestionAutomationProperty> {
            java.lang.Object options;
            java.lang.Object answerSource;
            java.util.List<java.lang.String> defaultOptionRefIds;

            /**
             * Sets the value of {@link EvaluationFormMultiSelectQuestionAutomationProperty#getOptions}
             * @param options The answer options for the automation. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder options(software.amazon.awscdk.IResolvable options) {
                this.options = options;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormMultiSelectQuestionAutomationProperty#getOptions}
             * @param options The answer options for the automation. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder options(java.util.List<? extends java.lang.Object> options) {
                this.options = options;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormMultiSelectQuestionAutomationProperty#getAnswerSource}
             * @param answerSource A question automation answer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder answerSource(software.amazon.awscdk.IResolvable answerSource) {
                this.answerSource = answerSource;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormMultiSelectQuestionAutomationProperty#getAnswerSource}
             * @param answerSource A question automation answer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder answerSource(software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormQuestionAutomationAnswerSourceProperty answerSource) {
                this.answerSource = answerSource;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormMultiSelectQuestionAutomationProperty#getDefaultOptionRefIds}
             * @param defaultOptionRefIds The list of reference id.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultOptionRefIds(java.util.List<java.lang.String> defaultOptionRefIds) {
                this.defaultOptionRefIds = defaultOptionRefIds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EvaluationFormMultiSelectQuestionAutomationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EvaluationFormMultiSelectQuestionAutomationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EvaluationFormMultiSelectQuestionAutomationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EvaluationFormMultiSelectQuestionAutomationProperty {
            private final java.lang.Object options;
            private final java.lang.Object answerSource;
            private final java.util.List<java.lang.String> defaultOptionRefIds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.options = software.amazon.jsii.Kernel.get(this, "options", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.answerSource = software.amazon.jsii.Kernel.get(this, "answerSource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.defaultOptionRefIds = software.amazon.jsii.Kernel.get(this, "defaultOptionRefIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.options = java.util.Objects.requireNonNull(builder.options, "options is required");
                this.answerSource = builder.answerSource;
                this.defaultOptionRefIds = builder.defaultOptionRefIds;
            }

            @Override
            public final java.lang.Object getOptions() {
                return this.options;
            }

            @Override
            public final java.lang.Object getAnswerSource() {
                return this.answerSource;
            }

            @Override
            public final java.util.List<java.lang.String> getDefaultOptionRefIds() {
                return this.defaultOptionRefIds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("options", om.valueToTree(this.getOptions()));
                if (this.getAnswerSource() != null) {
                    data.set("answerSource", om.valueToTree(this.getAnswerSource()));
                }
                if (this.getDefaultOptionRefIds() != null) {
                    data.set("defaultOptionRefIds", om.valueToTree(this.getDefaultOptionRefIds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormMultiSelectQuestionAutomationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EvaluationFormMultiSelectQuestionAutomationProperty.Jsii$Proxy that = (EvaluationFormMultiSelectQuestionAutomationProperty.Jsii$Proxy) o;

                if (!options.equals(that.options)) return false;
                if (this.answerSource != null ? !this.answerSource.equals(that.answerSource) : that.answerSource != null) return false;
                return this.defaultOptionRefIds != null ? this.defaultOptionRefIds.equals(that.defaultOptionRefIds) : that.defaultOptionRefIds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.options.hashCode();
                result = 31 * result + (this.answerSource != null ? this.answerSource.hashCode() : 0);
                result = 31 * result + (this.defaultOptionRefIds != null ? this.defaultOptionRefIds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * EvaluationFormMultiSelectQuestionOptionProperty evaluationFormMultiSelectQuestionOptionProperty = EvaluationFormMultiSelectQuestionOptionProperty.builder()
     *         .refId("refId")
     *         .text("text")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformmultiselectquestionoption.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformmultiselectquestionoption.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormMultiSelectQuestionOptionProperty")
    @software.amazon.jsii.Jsii.Proxy(EvaluationFormMultiSelectQuestionOptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EvaluationFormMultiSelectQuestionOptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The identifier to reference the item.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformmultiselectquestionoption.html#cfn-connect-evaluationform-evaluationformmultiselectquestionoption-refid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformmultiselectquestionoption.html#cfn-connect-evaluationform-evaluationformmultiselectquestionoption-refid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRefId();

        /**
         * The title of the option.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformmultiselectquestionoption.html#cfn-connect-evaluationform-evaluationformmultiselectquestionoption-text">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformmultiselectquestionoption.html#cfn-connect-evaluationform-evaluationformmultiselectquestionoption-text</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getText();

        /**
         * @return a {@link Builder} of {@link EvaluationFormMultiSelectQuestionOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EvaluationFormMultiSelectQuestionOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EvaluationFormMultiSelectQuestionOptionProperty> {
            java.lang.String refId;
            java.lang.String text;

            /**
             * Sets the value of {@link EvaluationFormMultiSelectQuestionOptionProperty#getRefId}
             * @param refId The identifier to reference the item. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder refId(java.lang.String refId) {
                this.refId = refId;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormMultiSelectQuestionOptionProperty#getText}
             * @param text The title of the option. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder text(java.lang.String text) {
                this.text = text;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EvaluationFormMultiSelectQuestionOptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EvaluationFormMultiSelectQuestionOptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EvaluationFormMultiSelectQuestionOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EvaluationFormMultiSelectQuestionOptionProperty {
            private final java.lang.String refId;
            private final java.lang.String text;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.refId = software.amazon.jsii.Kernel.get(this, "refId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.text = software.amazon.jsii.Kernel.get(this, "text", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.refId = java.util.Objects.requireNonNull(builder.refId, "refId is required");
                this.text = java.util.Objects.requireNonNull(builder.text, "text is required");
            }

            @Override
            public final java.lang.String getRefId() {
                return this.refId;
            }

            @Override
            public final java.lang.String getText() {
                return this.text;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("refId", om.valueToTree(this.getRefId()));
                data.set("text", om.valueToTree(this.getText()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormMultiSelectQuestionOptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EvaluationFormMultiSelectQuestionOptionProperty.Jsii$Proxy that = (EvaluationFormMultiSelectQuestionOptionProperty.Jsii$Proxy) o;

                if (!refId.equals(that.refId)) return false;
                return this.text.equals(that.text);
            }

            @Override
            public final int hashCode() {
                int result = this.refId.hashCode();
                result = 31 * result + (this.text.hashCode());
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * EvaluationFormMultiSelectQuestionPropertiesProperty evaluationFormMultiSelectQuestionPropertiesProperty = EvaluationFormMultiSelectQuestionPropertiesProperty.builder()
     *         .options(List.of(EvaluationFormMultiSelectQuestionOptionProperty.builder()
     *                 .refId("refId")
     *                 .text("text")
     *                 .build()))
     *         // the properties below are optional
     *         .automation(EvaluationFormMultiSelectQuestionAutomationProperty.builder()
     *                 .options(List.of(EvaluationFormMultiSelectQuestionAutomationOptionProperty.builder()
     *                         .ruleCategory(MultiSelectQuestionRuleCategoryAutomationProperty.builder()
     *                                 .category("category")
     *                                 .condition("condition")
     *                                 .optionRefIds(List.of("optionRefIds"))
     *                                 .build())
     *                         .build()))
     *                 // the properties below are optional
     *                 .answerSource(EvaluationFormQuestionAutomationAnswerSourceProperty.builder()
     *                         .sourceType("sourceType")
     *                         .build())
     *                 .defaultOptionRefIds(List.of("defaultOptionRefIds"))
     *                 .build())
     *         .displayAs("displayAs")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformmultiselectquestionproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformmultiselectquestionproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormMultiSelectQuestionPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(EvaluationFormMultiSelectQuestionPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EvaluationFormMultiSelectQuestionPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The list of options for the question.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormMultiSelectQuestionOptionProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformmultiselectquestionproperties.html#cfn-connect-evaluationform-evaluationformmultiselectquestionproperties-options">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformmultiselectquestionproperties.html#cfn-connect-evaluationform-evaluationformmultiselectquestionproperties-options</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getOptions();

        /**
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormMultiSelectQuestionAutomationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformmultiselectquestionproperties.html#cfn-connect-evaluationform-evaluationformmultiselectquestionproperties-automation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformmultiselectquestionproperties.html#cfn-connect-evaluationform-evaluationformmultiselectquestionproperties-automation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAutomation() {
            return null;
        }

        /**
         * The display mode of the multi-select question.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformmultiselectquestionproperties.html#cfn-connect-evaluationform-evaluationformmultiselectquestionproperties-displayas">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformmultiselectquestionproperties.html#cfn-connect-evaluationform-evaluationformmultiselectquestionproperties-displayas</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDisplayAs() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EvaluationFormMultiSelectQuestionPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EvaluationFormMultiSelectQuestionPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EvaluationFormMultiSelectQuestionPropertiesProperty> {
            java.lang.Object options;
            java.lang.Object automation;
            java.lang.String displayAs;

            /**
             * Sets the value of {@link EvaluationFormMultiSelectQuestionPropertiesProperty#getOptions}
             * @param options The list of options for the question. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder options(software.amazon.awscdk.IResolvable options) {
                this.options = options;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormMultiSelectQuestionPropertiesProperty#getOptions}
             * @param options The list of options for the question. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder options(java.util.List<? extends java.lang.Object> options) {
                this.options = options;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormMultiSelectQuestionPropertiesProperty#getAutomation}
             * @param automation the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder automation(software.amazon.awscdk.IResolvable automation) {
                this.automation = automation;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormMultiSelectQuestionPropertiesProperty#getAutomation}
             * @param automation the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder automation(software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormMultiSelectQuestionAutomationProperty automation) {
                this.automation = automation;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormMultiSelectQuestionPropertiesProperty#getDisplayAs}
             * @param displayAs The display mode of the multi-select question.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder displayAs(java.lang.String displayAs) {
                this.displayAs = displayAs;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EvaluationFormMultiSelectQuestionPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EvaluationFormMultiSelectQuestionPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EvaluationFormMultiSelectQuestionPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EvaluationFormMultiSelectQuestionPropertiesProperty {
            private final java.lang.Object options;
            private final java.lang.Object automation;
            private final java.lang.String displayAs;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.options = software.amazon.jsii.Kernel.get(this, "options", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.automation = software.amazon.jsii.Kernel.get(this, "automation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.displayAs = software.amazon.jsii.Kernel.get(this, "displayAs", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.options = java.util.Objects.requireNonNull(builder.options, "options is required");
                this.automation = builder.automation;
                this.displayAs = builder.displayAs;
            }

            @Override
            public final java.lang.Object getOptions() {
                return this.options;
            }

            @Override
            public final java.lang.Object getAutomation() {
                return this.automation;
            }

            @Override
            public final java.lang.String getDisplayAs() {
                return this.displayAs;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("options", om.valueToTree(this.getOptions()));
                if (this.getAutomation() != null) {
                    data.set("automation", om.valueToTree(this.getAutomation()));
                }
                if (this.getDisplayAs() != null) {
                    data.set("displayAs", om.valueToTree(this.getDisplayAs()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormMultiSelectQuestionPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EvaluationFormMultiSelectQuestionPropertiesProperty.Jsii$Proxy that = (EvaluationFormMultiSelectQuestionPropertiesProperty.Jsii$Proxy) o;

                if (!options.equals(that.options)) return false;
                if (this.automation != null ? !this.automation.equals(that.automation) : that.automation != null) return false;
                return this.displayAs != null ? this.displayAs.equals(that.displayAs) : that.displayAs == null;
            }

            @Override
            public final int hashCode() {
                int result = this.options.hashCode();
                result = 31 * result + (this.automation != null ? this.automation.hashCode() : 0);
                result = 31 * result + (this.displayAs != null ? this.displayAs.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about the automation configuration in numeric questions.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * EvaluationFormNumericQuestionAutomationProperty evaluationFormNumericQuestionAutomationProperty = EvaluationFormNumericQuestionAutomationProperty.builder()
     *         .answerSource(EvaluationFormQuestionAutomationAnswerSourceProperty.builder()
     *                 .sourceType("sourceType")
     *                 .build())
     *         .propertyValue(NumericQuestionPropertyValueAutomationProperty.builder()
     *                 .label("label")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionautomation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionautomation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormNumericQuestionAutomationProperty")
    @software.amazon.jsii.Jsii.Proxy(EvaluationFormNumericQuestionAutomationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EvaluationFormNumericQuestionAutomationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A source of automation answer for numeric question.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormQuestionAutomationAnswerSourceProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionautomation.html#cfn-connect-evaluationform-evaluationformnumericquestionautomation-answersource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionautomation.html#cfn-connect-evaluationform-evaluationformnumericquestionautomation-answersource</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAnswerSource() {
            return null;
        }

        /**
         * The property value of the automation.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.connect.CfnEvaluationForm.NumericQuestionPropertyValueAutomationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionautomation.html#cfn-connect-evaluationform-evaluationformnumericquestionautomation-propertyvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionautomation.html#cfn-connect-evaluationform-evaluationformnumericquestionautomation-propertyvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPropertyValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EvaluationFormNumericQuestionAutomationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EvaluationFormNumericQuestionAutomationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EvaluationFormNumericQuestionAutomationProperty> {
            java.lang.Object answerSource;
            java.lang.Object propertyValue;

            /**
             * Sets the value of {@link EvaluationFormNumericQuestionAutomationProperty#getAnswerSource}
             * @param answerSource A source of automation answer for numeric question.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder answerSource(software.amazon.awscdk.IResolvable answerSource) {
                this.answerSource = answerSource;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormNumericQuestionAutomationProperty#getAnswerSource}
             * @param answerSource A source of automation answer for numeric question.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder answerSource(software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormQuestionAutomationAnswerSourceProperty answerSource) {
                this.answerSource = answerSource;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormNumericQuestionAutomationProperty#getPropertyValue}
             * @param propertyValue The property value of the automation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder propertyValue(software.amazon.awscdk.IResolvable propertyValue) {
                this.propertyValue = propertyValue;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormNumericQuestionAutomationProperty#getPropertyValue}
             * @param propertyValue The property value of the automation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder propertyValue(software.amazon.awscdk.services.connect.CfnEvaluationForm.NumericQuestionPropertyValueAutomationProperty propertyValue) {
                this.propertyValue = propertyValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EvaluationFormNumericQuestionAutomationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EvaluationFormNumericQuestionAutomationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EvaluationFormNumericQuestionAutomationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EvaluationFormNumericQuestionAutomationProperty {
            private final java.lang.Object answerSource;
            private final java.lang.Object propertyValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.answerSource = software.amazon.jsii.Kernel.get(this, "answerSource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.propertyValue = software.amazon.jsii.Kernel.get(this, "propertyValue", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.answerSource = builder.answerSource;
                this.propertyValue = builder.propertyValue;
            }

            @Override
            public final java.lang.Object getAnswerSource() {
                return this.answerSource;
            }

            @Override
            public final java.lang.Object getPropertyValue() {
                return this.propertyValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAnswerSource() != null) {
                    data.set("answerSource", om.valueToTree(this.getAnswerSource()));
                }
                if (this.getPropertyValue() != null) {
                    data.set("propertyValue", om.valueToTree(this.getPropertyValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormNumericQuestionAutomationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EvaluationFormNumericQuestionAutomationProperty.Jsii$Proxy that = (EvaluationFormNumericQuestionAutomationProperty.Jsii$Proxy) o;

                if (this.answerSource != null ? !this.answerSource.equals(that.answerSource) : that.answerSource != null) return false;
                return this.propertyValue != null ? this.propertyValue.equals(that.propertyValue) : that.propertyValue == null;
            }

            @Override
            public final int hashCode() {
                int result = this.answerSource != null ? this.answerSource.hashCode() : 0;
                result = 31 * result + (this.propertyValue != null ? this.propertyValue.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about the option range used for scoring in numeric questions.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * EvaluationFormNumericQuestionOptionProperty evaluationFormNumericQuestionOptionProperty = EvaluationFormNumericQuestionOptionProperty.builder()
     *         .maxValue(123)
     *         .minValue(123)
     *         // the properties below are optional
     *         .automaticFail(false)
     *         .automaticFailConfiguration(AutomaticFailConfigurationProperty.builder()
     *                 .targetSection("targetSection")
     *                 .build())
     *         .score(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionoption.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionoption.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormNumericQuestionOptionProperty")
    @software.amazon.jsii.Jsii.Proxy(EvaluationFormNumericQuestionOptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EvaluationFormNumericQuestionOptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum answer value of the range option.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionoption.html#cfn-connect-evaluationform-evaluationformnumericquestionoption-maxvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionoption.html#cfn-connect-evaluationform-evaluationformnumericquestionoption-maxvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxValue();

        /**
         * The minimum answer value of the range option.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionoption.html#cfn-connect-evaluationform-evaluationformnumericquestionoption-minvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionoption.html#cfn-connect-evaluationform-evaluationformnumericquestionoption-minvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMinValue();

        /**
         * The flag to mark the option as automatic fail.
         * <p>
         * If an automatic fail answer is provided, the overall evaluation gets a score of 0.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionoption.html#cfn-connect-evaluationform-evaluationformnumericquestionoption-automaticfail">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionoption.html#cfn-connect-evaluationform-evaluationformnumericquestionoption-automaticfail</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAutomaticFail() {
            return null;
        }

        /**
         * A configuration for automatic fail.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.connect.CfnEvaluationForm.AutomaticFailConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionoption.html#cfn-connect-evaluationform-evaluationformnumericquestionoption-automaticfailconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionoption.html#cfn-connect-evaluationform-evaluationformnumericquestionoption-automaticfailconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAutomaticFailConfiguration() {
            return null;
        }

        /**
         * The score assigned to answer values within the range option.
         * <p>
         * <em>Minimum</em> : 0
         * <p>
         * <em>Maximum</em> : 10
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionoption.html#cfn-connect-evaluationform-evaluationformnumericquestionoption-score">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionoption.html#cfn-connect-evaluationform-evaluationformnumericquestionoption-score</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getScore() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EvaluationFormNumericQuestionOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EvaluationFormNumericQuestionOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EvaluationFormNumericQuestionOptionProperty> {
            java.lang.Number maxValue;
            java.lang.Number minValue;
            java.lang.Object automaticFail;
            java.lang.Object automaticFailConfiguration;
            java.lang.Number score;

            /**
             * Sets the value of {@link EvaluationFormNumericQuestionOptionProperty#getMaxValue}
             * @param maxValue The maximum answer value of the range option. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxValue(java.lang.Number maxValue) {
                this.maxValue = maxValue;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormNumericQuestionOptionProperty#getMinValue}
             * @param minValue The minimum answer value of the range option. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minValue(java.lang.Number minValue) {
                this.minValue = minValue;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormNumericQuestionOptionProperty#getAutomaticFail}
             * @param automaticFail The flag to mark the option as automatic fail.
             *                      If an automatic fail answer is provided, the overall evaluation gets a score of 0.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder automaticFail(java.lang.Boolean automaticFail) {
                this.automaticFail = automaticFail;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormNumericQuestionOptionProperty#getAutomaticFail}
             * @param automaticFail The flag to mark the option as automatic fail.
             *                      If an automatic fail answer is provided, the overall evaluation gets a score of 0.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder automaticFail(software.amazon.awscdk.IResolvable automaticFail) {
                this.automaticFail = automaticFail;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormNumericQuestionOptionProperty#getAutomaticFailConfiguration}
             * @param automaticFailConfiguration A configuration for automatic fail.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder automaticFailConfiguration(software.amazon.awscdk.IResolvable automaticFailConfiguration) {
                this.automaticFailConfiguration = automaticFailConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormNumericQuestionOptionProperty#getAutomaticFailConfiguration}
             * @param automaticFailConfiguration A configuration for automatic fail.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder automaticFailConfiguration(software.amazon.awscdk.services.connect.CfnEvaluationForm.AutomaticFailConfigurationProperty automaticFailConfiguration) {
                this.automaticFailConfiguration = automaticFailConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormNumericQuestionOptionProperty#getScore}
             * @param score The score assigned to answer values within the range option.
             *              <em>Minimum</em> : 0
             *              <p>
             *              <em>Maximum</em> : 10
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder score(java.lang.Number score) {
                this.score = score;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EvaluationFormNumericQuestionOptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EvaluationFormNumericQuestionOptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EvaluationFormNumericQuestionOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EvaluationFormNumericQuestionOptionProperty {
            private final java.lang.Number maxValue;
            private final java.lang.Number minValue;
            private final java.lang.Object automaticFail;
            private final java.lang.Object automaticFailConfiguration;
            private final java.lang.Number score;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxValue = software.amazon.jsii.Kernel.get(this, "maxValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minValue = software.amazon.jsii.Kernel.get(this, "minValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.automaticFail = software.amazon.jsii.Kernel.get(this, "automaticFail", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.automaticFailConfiguration = software.amazon.jsii.Kernel.get(this, "automaticFailConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.score = software.amazon.jsii.Kernel.get(this, "score", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxValue = java.util.Objects.requireNonNull(builder.maxValue, "maxValue is required");
                this.minValue = java.util.Objects.requireNonNull(builder.minValue, "minValue is required");
                this.automaticFail = builder.automaticFail;
                this.automaticFailConfiguration = builder.automaticFailConfiguration;
                this.score = builder.score;
            }

            @Override
            public final java.lang.Number getMaxValue() {
                return this.maxValue;
            }

            @Override
            public final java.lang.Number getMinValue() {
                return this.minValue;
            }

            @Override
            public final java.lang.Object getAutomaticFail() {
                return this.automaticFail;
            }

            @Override
            public final java.lang.Object getAutomaticFailConfiguration() {
                return this.automaticFailConfiguration;
            }

            @Override
            public final java.lang.Number getScore() {
                return this.score;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maxValue", om.valueToTree(this.getMaxValue()));
                data.set("minValue", om.valueToTree(this.getMinValue()));
                if (this.getAutomaticFail() != null) {
                    data.set("automaticFail", om.valueToTree(this.getAutomaticFail()));
                }
                if (this.getAutomaticFailConfiguration() != null) {
                    data.set("automaticFailConfiguration", om.valueToTree(this.getAutomaticFailConfiguration()));
                }
                if (this.getScore() != null) {
                    data.set("score", om.valueToTree(this.getScore()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormNumericQuestionOptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EvaluationFormNumericQuestionOptionProperty.Jsii$Proxy that = (EvaluationFormNumericQuestionOptionProperty.Jsii$Proxy) o;

                if (!maxValue.equals(that.maxValue)) return false;
                if (!minValue.equals(that.minValue)) return false;
                if (this.automaticFail != null ? !this.automaticFail.equals(that.automaticFail) : that.automaticFail != null) return false;
                if (this.automaticFailConfiguration != null ? !this.automaticFailConfiguration.equals(that.automaticFailConfiguration) : that.automaticFailConfiguration != null) return false;
                return this.score != null ? this.score.equals(that.score) : that.score == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maxValue.hashCode();
                result = 31 * result + (this.minValue.hashCode());
                result = 31 * result + (this.automaticFail != null ? this.automaticFail.hashCode() : 0);
                result = 31 * result + (this.automaticFailConfiguration != null ? this.automaticFailConfiguration.hashCode() : 0);
                result = 31 * result + (this.score != null ? this.score.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about properties for a numeric question in an evaluation form.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * EvaluationFormNumericQuestionPropertiesProperty evaluationFormNumericQuestionPropertiesProperty = EvaluationFormNumericQuestionPropertiesProperty.builder()
     *         .maxValue(123)
     *         .minValue(123)
     *         // the properties below are optional
     *         .automation(EvaluationFormNumericQuestionAutomationProperty.builder()
     *                 .answerSource(EvaluationFormQuestionAutomationAnswerSourceProperty.builder()
     *                         .sourceType("sourceType")
     *                         .build())
     *                 .propertyValue(NumericQuestionPropertyValueAutomationProperty.builder()
     *                         .label("label")
     *                         .build())
     *                 .build())
     *         .options(List.of(EvaluationFormNumericQuestionOptionProperty.builder()
     *                 .maxValue(123)
     *                 .minValue(123)
     *                 // the properties below are optional
     *                 .automaticFail(false)
     *                 .automaticFailConfiguration(AutomaticFailConfigurationProperty.builder()
     *                         .targetSection("targetSection")
     *                         .build())
     *                 .score(123)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormNumericQuestionPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(EvaluationFormNumericQuestionPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EvaluationFormNumericQuestionPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum answer value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionproperties.html#cfn-connect-evaluationform-evaluationformnumericquestionproperties-maxvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionproperties.html#cfn-connect-evaluationform-evaluationformnumericquestionproperties-maxvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxValue();

        /**
         * The minimum answer value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionproperties.html#cfn-connect-evaluationform-evaluationformnumericquestionproperties-minvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionproperties.html#cfn-connect-evaluationform-evaluationformnumericquestionproperties-minvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMinValue();

        /**
         * The automation properties of the numeric question.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormNumericQuestionAutomationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionproperties.html#cfn-connect-evaluationform-evaluationformnumericquestionproperties-automation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionproperties.html#cfn-connect-evaluationform-evaluationformnumericquestionproperties-automation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAutomation() {
            return null;
        }

        /**
         * The scoring options of the numeric question.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormNumericQuestionOptionProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionproperties.html#cfn-connect-evaluationform-evaluationformnumericquestionproperties-options">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformnumericquestionproperties.html#cfn-connect-evaluationform-evaluationformnumericquestionproperties-options</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOptions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EvaluationFormNumericQuestionPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EvaluationFormNumericQuestionPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EvaluationFormNumericQuestionPropertiesProperty> {
            java.lang.Number maxValue;
            java.lang.Number minValue;
            java.lang.Object automation;
            java.lang.Object options;

            /**
             * Sets the value of {@link EvaluationFormNumericQuestionPropertiesProperty#getMaxValue}
             * @param maxValue The maximum answer value. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxValue(java.lang.Number maxValue) {
                this.maxValue = maxValue;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormNumericQuestionPropertiesProperty#getMinValue}
             * @param minValue The minimum answer value. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minValue(java.lang.Number minValue) {
                this.minValue = minValue;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormNumericQuestionPropertiesProperty#getAutomation}
             * @param automation The automation properties of the numeric question.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder automation(software.amazon.awscdk.IResolvable automation) {
                this.automation = automation;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormNumericQuestionPropertiesProperty#getAutomation}
             * @param automation The automation properties of the numeric question.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder automation(software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormNumericQuestionAutomationProperty automation) {
                this.automation = automation;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormNumericQuestionPropertiesProperty#getOptions}
             * @param options The scoring options of the numeric question.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder options(software.amazon.awscdk.IResolvable options) {
                this.options = options;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormNumericQuestionPropertiesProperty#getOptions}
             * @param options The scoring options of the numeric question.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder options(java.util.List<? extends java.lang.Object> options) {
                this.options = options;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EvaluationFormNumericQuestionPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EvaluationFormNumericQuestionPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EvaluationFormNumericQuestionPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EvaluationFormNumericQuestionPropertiesProperty {
            private final java.lang.Number maxValue;
            private final java.lang.Number minValue;
            private final java.lang.Object automation;
            private final java.lang.Object options;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxValue = software.amazon.jsii.Kernel.get(this, "maxValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minValue = software.amazon.jsii.Kernel.get(this, "minValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.automation = software.amazon.jsii.Kernel.get(this, "automation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.options = software.amazon.jsii.Kernel.get(this, "options", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxValue = java.util.Objects.requireNonNull(builder.maxValue, "maxValue is required");
                this.minValue = java.util.Objects.requireNonNull(builder.minValue, "minValue is required");
                this.automation = builder.automation;
                this.options = builder.options;
            }

            @Override
            public final java.lang.Number getMaxValue() {
                return this.maxValue;
            }

            @Override
            public final java.lang.Number getMinValue() {
                return this.minValue;
            }

            @Override
            public final java.lang.Object getAutomation() {
                return this.automation;
            }

            @Override
            public final java.lang.Object getOptions() {
                return this.options;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maxValue", om.valueToTree(this.getMaxValue()));
                data.set("minValue", om.valueToTree(this.getMinValue()));
                if (this.getAutomation() != null) {
                    data.set("automation", om.valueToTree(this.getAutomation()));
                }
                if (this.getOptions() != null) {
                    data.set("options", om.valueToTree(this.getOptions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormNumericQuestionPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EvaluationFormNumericQuestionPropertiesProperty.Jsii$Proxy that = (EvaluationFormNumericQuestionPropertiesProperty.Jsii$Proxy) o;

                if (!maxValue.equals(that.maxValue)) return false;
                if (!minValue.equals(that.minValue)) return false;
                if (this.automation != null ? !this.automation.equals(that.automation) : that.automation != null) return false;
                return this.options != null ? this.options.equals(that.options) : that.options == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maxValue.hashCode();
                result = 31 * result + (this.minValue.hashCode());
                result = 31 * result + (this.automation != null ? this.automation.hashCode() : 0);
                result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A question automation answer.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * EvaluationFormQuestionAutomationAnswerSourceProperty evaluationFormQuestionAutomationAnswerSourceProperty = EvaluationFormQuestionAutomationAnswerSourceProperty.builder()
     *         .sourceType("sourceType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestionautomationanswersource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestionautomationanswersource.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormQuestionAutomationAnswerSourceProperty")
    @software.amazon.jsii.Jsii.Proxy(EvaluationFormQuestionAutomationAnswerSourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EvaluationFormQuestionAutomationAnswerSourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The automation answer source type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestionautomationanswersource.html#cfn-connect-evaluationform-evaluationformquestionautomationanswersource-sourcetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestionautomationanswersource.html#cfn-connect-evaluationform-evaluationformquestionautomationanswersource-sourcetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSourceType();

        /**
         * @return a {@link Builder} of {@link EvaluationFormQuestionAutomationAnswerSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EvaluationFormQuestionAutomationAnswerSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EvaluationFormQuestionAutomationAnswerSourceProperty> {
            java.lang.String sourceType;

            /**
             * Sets the value of {@link EvaluationFormQuestionAutomationAnswerSourceProperty#getSourceType}
             * @param sourceType The automation answer source type. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceType(java.lang.String sourceType) {
                this.sourceType = sourceType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EvaluationFormQuestionAutomationAnswerSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EvaluationFormQuestionAutomationAnswerSourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EvaluationFormQuestionAutomationAnswerSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EvaluationFormQuestionAutomationAnswerSourceProperty {
            private final java.lang.String sourceType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sourceType = software.amazon.jsii.Kernel.get(this, "sourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sourceType = java.util.Objects.requireNonNull(builder.sourceType, "sourceType is required");
            }

            @Override
            public final java.lang.String getSourceType() {
                return this.sourceType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("sourceType", om.valueToTree(this.getSourceType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormQuestionAutomationAnswerSourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EvaluationFormQuestionAutomationAnswerSourceProperty.Jsii$Proxy that = (EvaluationFormQuestionAutomationAnswerSourceProperty.Jsii$Proxy) o;

                return this.sourceType.equals(that.sourceType);
            }

            @Override
            public final int hashCode() {
                int result = this.sourceType.hashCode();
                return result;
            }
        }
    }
    /**
     * Information about a question from an evaluation form.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * EvaluationFormQuestionProperty evaluationFormQuestionProperty = EvaluationFormQuestionProperty.builder()
     *         .questionType("questionType")
     *         .refId("refId")
     *         .title("title")
     *         // the properties below are optional
     *         .enablement(EvaluationFormItemEnablementConfigurationProperty.builder()
     *                 .action("action")
     *                 .condition(EvaluationFormItemEnablementConditionProperty.builder()
     *                         .operands(List.of(EvaluationFormItemEnablementConditionOperandProperty.builder()
     *                                 .expression(EvaluationFormItemEnablementExpressionProperty.builder()
     *                                         .comparator("comparator")
     *                                         .source(EvaluationFormItemEnablementSourceProperty.builder()
     *                                                 .type("type")
     *                                                 // the properties below are optional
     *                                                 .refId("refId")
     *                                                 .build())
     *                                         .values(List.of(EvaluationFormItemEnablementSourceValueProperty.builder()
     *                                                 .refId("refId")
     *                                                 .type("type")
     *                                                 .build()))
     *                                         .build())
     *                                 .build()))
     *                         // the properties below are optional
     *                         .operator("operator")
     *                         .build())
     *                 // the properties below are optional
     *                 .defaultAction("defaultAction")
     *                 .build())
     *         .instructions("instructions")
     *         .notApplicableEnabled(false)
     *         .questionTypeProperties(EvaluationFormQuestionTypePropertiesProperty.builder()
     *                 .multiSelect(EvaluationFormMultiSelectQuestionPropertiesProperty.builder()
     *                         .options(List.of(EvaluationFormMultiSelectQuestionOptionProperty.builder()
     *                                 .refId("refId")
     *                                 .text("text")
     *                                 .build()))
     *                         // the properties below are optional
     *                         .automation(EvaluationFormMultiSelectQuestionAutomationProperty.builder()
     *                                 .options(List.of(EvaluationFormMultiSelectQuestionAutomationOptionProperty.builder()
     *                                         .ruleCategory(MultiSelectQuestionRuleCategoryAutomationProperty.builder()
     *                                                 .category("category")
     *                                                 .condition("condition")
     *                                                 .optionRefIds(List.of("optionRefIds"))
     *                                                 .build())
     *                                         .build()))
     *                                 // the properties below are optional
     *                                 .answerSource(EvaluationFormQuestionAutomationAnswerSourceProperty.builder()
     *                                         .sourceType("sourceType")
     *                                         .build())
     *                                 .defaultOptionRefIds(List.of("defaultOptionRefIds"))
     *                                 .build())
     *                         .displayAs("displayAs")
     *                         .build())
     *                 .numeric(EvaluationFormNumericQuestionPropertiesProperty.builder()
     *                         .maxValue(123)
     *                         .minValue(123)
     *                         // the properties below are optional
     *                         .automation(EvaluationFormNumericQuestionAutomationProperty.builder()
     *                                 .answerSource(EvaluationFormQuestionAutomationAnswerSourceProperty.builder()
     *                                         .sourceType("sourceType")
     *                                         .build())
     *                                 .propertyValue(NumericQuestionPropertyValueAutomationProperty.builder()
     *                                         .label("label")
     *                                         .build())
     *                                 .build())
     *                         .options(List.of(EvaluationFormNumericQuestionOptionProperty.builder()
     *                                 .maxValue(123)
     *                                 .minValue(123)
     *                                 // the properties below are optional
     *                                 .automaticFail(false)
     *                                 .automaticFailConfiguration(AutomaticFailConfigurationProperty.builder()
     *                                         .targetSection("targetSection")
     *                                         .build())
     *                                 .score(123)
     *                                 .build()))
     *                         .build())
     *                 .singleSelect(EvaluationFormSingleSelectQuestionPropertiesProperty.builder()
     *                         .options(List.of(EvaluationFormSingleSelectQuestionOptionProperty.builder()
     *                                 .refId("refId")
     *                                 .text("text")
     *                                 // the properties below are optional
     *                                 .automaticFail(false)
     *                                 .automaticFailConfiguration(AutomaticFailConfigurationProperty.builder()
     *                                         .targetSection("targetSection")
     *                                         .build())
     *                                 .score(123)
     *                                 .build()))
     *                         // the properties below are optional
     *                         .automation(EvaluationFormSingleSelectQuestionAutomationProperty.builder()
     *                                 .options(List.of(EvaluationFormSingleSelectQuestionAutomationOptionProperty.builder()
     *                                         .ruleCategory(SingleSelectQuestionRuleCategoryAutomationProperty.builder()
     *                                                 .category("category")
     *                                                 .condition("condition")
     *                                                 .optionRefId("optionRefId")
     *                                                 .build())
     *                                         .build()))
     *                                 // the properties below are optional
     *                                 .answerSource(EvaluationFormQuestionAutomationAnswerSourceProperty.builder()
     *                                         .sourceType("sourceType")
     *                                         .build())
     *                                 .defaultOptionRefId("defaultOptionRefId")
     *                                 .build())
     *                         .displayAs("displayAs")
     *                         .build())
     *                 .text(EvaluationFormTextQuestionPropertiesProperty.builder()
     *                         .automation(EvaluationFormTextQuestionAutomationProperty.builder()
     *                                 .answerSource(EvaluationFormQuestionAutomationAnswerSourceProperty.builder()
     *                                         .sourceType("sourceType")
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .weight(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestion.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestion.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormQuestionProperty")
    @software.amazon.jsii.Jsii.Proxy(EvaluationFormQuestionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EvaluationFormQuestionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of the question.
         * <p>
         * <em>Allowed values</em> : <code>NUMERIC</code> | <code>SINGLESELECT</code> | <code>TEXT</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestion.html#cfn-connect-evaluationform-evaluationformquestion-questiontype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestion.html#cfn-connect-evaluationform-evaluationformquestion-questiontype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getQuestionType();

        /**
         * The identifier of the question. An identifier must be unique within the evaluation form.
         * <p>
         * <em>Length Constraints</em> : Minimum length of 1. Maximum length of 40.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestion.html#cfn-connect-evaluationform-evaluationformquestion-refid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestion.html#cfn-connect-evaluationform-evaluationformquestion-refid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRefId();

        /**
         * The title of the question.
         * <p>
         * <em>Length Constraints</em> : Minimum length of 1. Maximum length of 350.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestion.html#cfn-connect-evaluationform-evaluationformquestion-title">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestion.html#cfn-connect-evaluationform-evaluationformquestion-title</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTitle();

        /**
         * A question conditional enablement.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormItemEnablementConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestion.html#cfn-connect-evaluationform-evaluationformquestion-enablement">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestion.html#cfn-connect-evaluationform-evaluationformquestion-enablement</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnablement() {
            return null;
        }

        /**
         * The instructions of the section.
         * <p>
         * <em>Length Constraints</em> : Minimum length of 0. Maximum length of 1024.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestion.html#cfn-connect-evaluationform-evaluationformquestion-instructions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestion.html#cfn-connect-evaluationform-evaluationformquestion-instructions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstructions() {
            return null;
        }

        /**
         * The flag to enable not applicable answers to the question.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestion.html#cfn-connect-evaluationform-evaluationformquestion-notapplicableenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestion.html#cfn-connect-evaluationform-evaluationformquestion-notapplicableenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNotApplicableEnabled() {
            return null;
        }

        /**
         * The properties of the type of question.
         * <p>
         * Text questions do not have to define question type properties.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormQuestionTypePropertiesProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestion.html#cfn-connect-evaluationform-evaluationformquestion-questiontypeproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestion.html#cfn-connect-evaluationform-evaluationformquestion-questiontypeproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getQuestionTypeProperties() {
            return null;
        }

        /**
         * The scoring weight of the section.
         * <p>
         * <em>Minimum</em> : 0
         * <p>
         * <em>Maximum</em> : 100
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestion.html#cfn-connect-evaluationform-evaluationformquestion-weight">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestion.html#cfn-connect-evaluationform-evaluationformquestion-weight</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getWeight() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EvaluationFormQuestionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EvaluationFormQuestionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EvaluationFormQuestionProperty> {
            java.lang.String questionType;
            java.lang.String refId;
            java.lang.String title;
            java.lang.Object enablement;
            java.lang.String instructions;
            java.lang.Object notApplicableEnabled;
            java.lang.Object questionTypeProperties;
            java.lang.Number weight;

            /**
             * Sets the value of {@link EvaluationFormQuestionProperty#getQuestionType}
             * @param questionType The type of the question. This parameter is required.
             *                     <em>Allowed values</em> : <code>NUMERIC</code> | <code>SINGLESELECT</code> | <code>TEXT</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder questionType(java.lang.String questionType) {
                this.questionType = questionType;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormQuestionProperty#getRefId}
             * @param refId The identifier of the question. An identifier must be unique within the evaluation form. This parameter is required.
             *              <em>Length Constraints</em> : Minimum length of 1. Maximum length of 40.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder refId(java.lang.String refId) {
                this.refId = refId;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormQuestionProperty#getTitle}
             * @param title The title of the question. This parameter is required.
             *              <em>Length Constraints</em> : Minimum length of 1. Maximum length of 350.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder title(java.lang.String title) {
                this.title = title;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormQuestionProperty#getEnablement}
             * @param enablement A question conditional enablement.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enablement(software.amazon.awscdk.IResolvable enablement) {
                this.enablement = enablement;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormQuestionProperty#getEnablement}
             * @param enablement A question conditional enablement.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enablement(software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormItemEnablementConfigurationProperty enablement) {
                this.enablement = enablement;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormQuestionProperty#getInstructions}
             * @param instructions The instructions of the section.
             *                     <em>Length Constraints</em> : Minimum length of 0. Maximum length of 1024.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instructions(java.lang.String instructions) {
                this.instructions = instructions;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormQuestionProperty#getNotApplicableEnabled}
             * @param notApplicableEnabled The flag to enable not applicable answers to the question.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notApplicableEnabled(java.lang.Boolean notApplicableEnabled) {
                this.notApplicableEnabled = notApplicableEnabled;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormQuestionProperty#getNotApplicableEnabled}
             * @param notApplicableEnabled The flag to enable not applicable answers to the question.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notApplicableEnabled(software.amazon.awscdk.IResolvable notApplicableEnabled) {
                this.notApplicableEnabled = notApplicableEnabled;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormQuestionProperty#getQuestionTypeProperties}
             * @param questionTypeProperties The properties of the type of question.
             *                               Text questions do not have to define question type properties.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder questionTypeProperties(software.amazon.awscdk.IResolvable questionTypeProperties) {
                this.questionTypeProperties = questionTypeProperties;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormQuestionProperty#getQuestionTypeProperties}
             * @param questionTypeProperties The properties of the type of question.
             *                               Text questions do not have to define question type properties.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder questionTypeProperties(software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormQuestionTypePropertiesProperty questionTypeProperties) {
                this.questionTypeProperties = questionTypeProperties;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormQuestionProperty#getWeight}
             * @param weight The scoring weight of the section.
             *               <em>Minimum</em> : 0
             *               <p>
             *               <em>Maximum</em> : 100
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weight(java.lang.Number weight) {
                this.weight = weight;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EvaluationFormQuestionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EvaluationFormQuestionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EvaluationFormQuestionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EvaluationFormQuestionProperty {
            private final java.lang.String questionType;
            private final java.lang.String refId;
            private final java.lang.String title;
            private final java.lang.Object enablement;
            private final java.lang.String instructions;
            private final java.lang.Object notApplicableEnabled;
            private final java.lang.Object questionTypeProperties;
            private final java.lang.Number weight;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.questionType = software.amazon.jsii.Kernel.get(this, "questionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.refId = software.amazon.jsii.Kernel.get(this, "refId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.title = software.amazon.jsii.Kernel.get(this, "title", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.enablement = software.amazon.jsii.Kernel.get(this, "enablement", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.instructions = software.amazon.jsii.Kernel.get(this, "instructions", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.notApplicableEnabled = software.amazon.jsii.Kernel.get(this, "notApplicableEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.questionTypeProperties = software.amazon.jsii.Kernel.get(this, "questionTypeProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.weight = software.amazon.jsii.Kernel.get(this, "weight", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.questionType = java.util.Objects.requireNonNull(builder.questionType, "questionType is required");
                this.refId = java.util.Objects.requireNonNull(builder.refId, "refId is required");
                this.title = java.util.Objects.requireNonNull(builder.title, "title is required");
                this.enablement = builder.enablement;
                this.instructions = builder.instructions;
                this.notApplicableEnabled = builder.notApplicableEnabled;
                this.questionTypeProperties = builder.questionTypeProperties;
                this.weight = builder.weight;
            }

            @Override
            public final java.lang.String getQuestionType() {
                return this.questionType;
            }

            @Override
            public final java.lang.String getRefId() {
                return this.refId;
            }

            @Override
            public final java.lang.String getTitle() {
                return this.title;
            }

            @Override
            public final java.lang.Object getEnablement() {
                return this.enablement;
            }

            @Override
            public final java.lang.String getInstructions() {
                return this.instructions;
            }

            @Override
            public final java.lang.Object getNotApplicableEnabled() {
                return this.notApplicableEnabled;
            }

            @Override
            public final java.lang.Object getQuestionTypeProperties() {
                return this.questionTypeProperties;
            }

            @Override
            public final java.lang.Number getWeight() {
                return this.weight;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("questionType", om.valueToTree(this.getQuestionType()));
                data.set("refId", om.valueToTree(this.getRefId()));
                data.set("title", om.valueToTree(this.getTitle()));
                if (this.getEnablement() != null) {
                    data.set("enablement", om.valueToTree(this.getEnablement()));
                }
                if (this.getInstructions() != null) {
                    data.set("instructions", om.valueToTree(this.getInstructions()));
                }
                if (this.getNotApplicableEnabled() != null) {
                    data.set("notApplicableEnabled", om.valueToTree(this.getNotApplicableEnabled()));
                }
                if (this.getQuestionTypeProperties() != null) {
                    data.set("questionTypeProperties", om.valueToTree(this.getQuestionTypeProperties()));
                }
                if (this.getWeight() != null) {
                    data.set("weight", om.valueToTree(this.getWeight()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormQuestionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EvaluationFormQuestionProperty.Jsii$Proxy that = (EvaluationFormQuestionProperty.Jsii$Proxy) o;

                if (!questionType.equals(that.questionType)) return false;
                if (!refId.equals(that.refId)) return false;
                if (!title.equals(that.title)) return false;
                if (this.enablement != null ? !this.enablement.equals(that.enablement) : that.enablement != null) return false;
                if (this.instructions != null ? !this.instructions.equals(that.instructions) : that.instructions != null) return false;
                if (this.notApplicableEnabled != null ? !this.notApplicableEnabled.equals(that.notApplicableEnabled) : that.notApplicableEnabled != null) return false;
                if (this.questionTypeProperties != null ? !this.questionTypeProperties.equals(that.questionTypeProperties) : that.questionTypeProperties != null) return false;
                return this.weight != null ? this.weight.equals(that.weight) : that.weight == null;
            }

            @Override
            public final int hashCode() {
                int result = this.questionType.hashCode();
                result = 31 * result + (this.refId.hashCode());
                result = 31 * result + (this.title.hashCode());
                result = 31 * result + (this.enablement != null ? this.enablement.hashCode() : 0);
                result = 31 * result + (this.instructions != null ? this.instructions.hashCode() : 0);
                result = 31 * result + (this.notApplicableEnabled != null ? this.notApplicableEnabled.hashCode() : 0);
                result = 31 * result + (this.questionTypeProperties != null ? this.questionTypeProperties.hashCode() : 0);
                result = 31 * result + (this.weight != null ? this.weight.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about properties for a question in an evaluation form.
     * <p>
     * The question type properties must be either for a numeric question or a single select question.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * EvaluationFormQuestionTypePropertiesProperty evaluationFormQuestionTypePropertiesProperty = EvaluationFormQuestionTypePropertiesProperty.builder()
     *         .multiSelect(EvaluationFormMultiSelectQuestionPropertiesProperty.builder()
     *                 .options(List.of(EvaluationFormMultiSelectQuestionOptionProperty.builder()
     *                         .refId("refId")
     *                         .text("text")
     *                         .build()))
     *                 // the properties below are optional
     *                 .automation(EvaluationFormMultiSelectQuestionAutomationProperty.builder()
     *                         .options(List.of(EvaluationFormMultiSelectQuestionAutomationOptionProperty.builder()
     *                                 .ruleCategory(MultiSelectQuestionRuleCategoryAutomationProperty.builder()
     *                                         .category("category")
     *                                         .condition("condition")
     *                                         .optionRefIds(List.of("optionRefIds"))
     *                                         .build())
     *                                 .build()))
     *                         // the properties below are optional
     *                         .answerSource(EvaluationFormQuestionAutomationAnswerSourceProperty.builder()
     *                                 .sourceType("sourceType")
     *                                 .build())
     *                         .defaultOptionRefIds(List.of("defaultOptionRefIds"))
     *                         .build())
     *                 .displayAs("displayAs")
     *                 .build())
     *         .numeric(EvaluationFormNumericQuestionPropertiesProperty.builder()
     *                 .maxValue(123)
     *                 .minValue(123)
     *                 // the properties below are optional
     *                 .automation(EvaluationFormNumericQuestionAutomationProperty.builder()
     *                         .answerSource(EvaluationFormQuestionAutomationAnswerSourceProperty.builder()
     *                                 .sourceType("sourceType")
     *                                 .build())
     *                         .propertyValue(NumericQuestionPropertyValueAutomationProperty.builder()
     *                                 .label("label")
     *                                 .build())
     *                         .build())
     *                 .options(List.of(EvaluationFormNumericQuestionOptionProperty.builder()
     *                         .maxValue(123)
     *                         .minValue(123)
     *                         // the properties below are optional
     *                         .automaticFail(false)
     *                         .automaticFailConfiguration(AutomaticFailConfigurationProperty.builder()
     *                                 .targetSection("targetSection")
     *                                 .build())
     *                         .score(123)
     *                         .build()))
     *                 .build())
     *         .singleSelect(EvaluationFormSingleSelectQuestionPropertiesProperty.builder()
     *                 .options(List.of(EvaluationFormSingleSelectQuestionOptionProperty.builder()
     *                         .refId("refId")
     *                         .text("text")
     *                         // the properties below are optional
     *                         .automaticFail(false)
     *                         .automaticFailConfiguration(AutomaticFailConfigurationProperty.builder()
     *                                 .targetSection("targetSection")
     *                                 .build())
     *                         .score(123)
     *                         .build()))
     *                 // the properties below are optional
     *                 .automation(EvaluationFormSingleSelectQuestionAutomationProperty.builder()
     *                         .options(List.of(EvaluationFormSingleSelectQuestionAutomationOptionProperty.builder()
     *                                 .ruleCategory(SingleSelectQuestionRuleCategoryAutomationProperty.builder()
     *                                         .category("category")
     *                                         .condition("condition")
     *                                         .optionRefId("optionRefId")
     *                                         .build())
     *                                 .build()))
     *                         // the properties below are optional
     *                         .answerSource(EvaluationFormQuestionAutomationAnswerSourceProperty.builder()
     *                                 .sourceType("sourceType")
     *                                 .build())
     *                         .defaultOptionRefId("defaultOptionRefId")
     *                         .build())
     *                 .displayAs("displayAs")
     *                 .build())
     *         .text(EvaluationFormTextQuestionPropertiesProperty.builder()
     *                 .automation(EvaluationFormTextQuestionAutomationProperty.builder()
     *                         .answerSource(EvaluationFormQuestionAutomationAnswerSourceProperty.builder()
     *                                 .sourceType("sourceType")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestiontypeproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestiontypeproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormQuestionTypePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(EvaluationFormQuestionTypePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EvaluationFormQuestionTypePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormMultiSelectQuestionPropertiesProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestiontypeproperties.html#cfn-connect-evaluationform-evaluationformquestiontypeproperties-multiselect">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestiontypeproperties.html#cfn-connect-evaluationform-evaluationformquestiontypeproperties-multiselect</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMultiSelect() {
            return null;
        }

        /**
         * The properties of the numeric question.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormNumericQuestionPropertiesProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestiontypeproperties.html#cfn-connect-evaluationform-evaluationformquestiontypeproperties-numeric">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestiontypeproperties.html#cfn-connect-evaluationform-evaluationformquestiontypeproperties-numeric</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNumeric() {
            return null;
        }

        /**
         * The properties of the numeric question.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormSingleSelectQuestionPropertiesProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestiontypeproperties.html#cfn-connect-evaluationform-evaluationformquestiontypeproperties-singleselect">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestiontypeproperties.html#cfn-connect-evaluationform-evaluationformquestiontypeproperties-singleselect</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSingleSelect() {
            return null;
        }

        /**
         * The properties of the text question.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormTextQuestionPropertiesProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestiontypeproperties.html#cfn-connect-evaluationform-evaluationformquestiontypeproperties-text">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformquestiontypeproperties.html#cfn-connect-evaluationform-evaluationformquestiontypeproperties-text</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getText() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EvaluationFormQuestionTypePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EvaluationFormQuestionTypePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EvaluationFormQuestionTypePropertiesProperty> {
            java.lang.Object multiSelect;
            java.lang.Object numeric;
            java.lang.Object singleSelect;
            java.lang.Object text;

            /**
             * Sets the value of {@link EvaluationFormQuestionTypePropertiesProperty#getMultiSelect}
             * @param multiSelect the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder multiSelect(software.amazon.awscdk.IResolvable multiSelect) {
                this.multiSelect = multiSelect;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormQuestionTypePropertiesProperty#getMultiSelect}
             * @param multiSelect the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder multiSelect(software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormMultiSelectQuestionPropertiesProperty multiSelect) {
                this.multiSelect = multiSelect;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormQuestionTypePropertiesProperty#getNumeric}
             * @param numeric The properties of the numeric question.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder numeric(software.amazon.awscdk.IResolvable numeric) {
                this.numeric = numeric;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormQuestionTypePropertiesProperty#getNumeric}
             * @param numeric The properties of the numeric question.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder numeric(software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormNumericQuestionPropertiesProperty numeric) {
                this.numeric = numeric;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormQuestionTypePropertiesProperty#getSingleSelect}
             * @param singleSelect The properties of the numeric question.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singleSelect(software.amazon.awscdk.IResolvable singleSelect) {
                this.singleSelect = singleSelect;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormQuestionTypePropertiesProperty#getSingleSelect}
             * @param singleSelect The properties of the numeric question.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singleSelect(software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormSingleSelectQuestionPropertiesProperty singleSelect) {
                this.singleSelect = singleSelect;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormQuestionTypePropertiesProperty#getText}
             * @param text The properties of the text question.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder text(software.amazon.awscdk.IResolvable text) {
                this.text = text;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormQuestionTypePropertiesProperty#getText}
             * @param text The properties of the text question.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder text(software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormTextQuestionPropertiesProperty text) {
                this.text = text;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EvaluationFormQuestionTypePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EvaluationFormQuestionTypePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EvaluationFormQuestionTypePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EvaluationFormQuestionTypePropertiesProperty {
            private final java.lang.Object multiSelect;
            private final java.lang.Object numeric;
            private final java.lang.Object singleSelect;
            private final java.lang.Object text;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.multiSelect = software.amazon.jsii.Kernel.get(this, "multiSelect", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.numeric = software.amazon.jsii.Kernel.get(this, "numeric", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.singleSelect = software.amazon.jsii.Kernel.get(this, "singleSelect", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.text = software.amazon.jsii.Kernel.get(this, "text", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.multiSelect = builder.multiSelect;
                this.numeric = builder.numeric;
                this.singleSelect = builder.singleSelect;
                this.text = builder.text;
            }

            @Override
            public final java.lang.Object getMultiSelect() {
                return this.multiSelect;
            }

            @Override
            public final java.lang.Object getNumeric() {
                return this.numeric;
            }

            @Override
            public final java.lang.Object getSingleSelect() {
                return this.singleSelect;
            }

            @Override
            public final java.lang.Object getText() {
                return this.text;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMultiSelect() != null) {
                    data.set("multiSelect", om.valueToTree(this.getMultiSelect()));
                }
                if (this.getNumeric() != null) {
                    data.set("numeric", om.valueToTree(this.getNumeric()));
                }
                if (this.getSingleSelect() != null) {
                    data.set("singleSelect", om.valueToTree(this.getSingleSelect()));
                }
                if (this.getText() != null) {
                    data.set("text", om.valueToTree(this.getText()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormQuestionTypePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EvaluationFormQuestionTypePropertiesProperty.Jsii$Proxy that = (EvaluationFormQuestionTypePropertiesProperty.Jsii$Proxy) o;

                if (this.multiSelect != null ? !this.multiSelect.equals(that.multiSelect) : that.multiSelect != null) return false;
                if (this.numeric != null ? !this.numeric.equals(that.numeric) : that.numeric != null) return false;
                if (this.singleSelect != null ? !this.singleSelect.equals(that.singleSelect) : that.singleSelect != null) return false;
                return this.text != null ? this.text.equals(that.text) : that.text == null;
            }

            @Override
            public final int hashCode() {
                int result = this.multiSelect != null ? this.multiSelect.hashCode() : 0;
                result = 31 * result + (this.numeric != null ? this.numeric.hashCode() : 0);
                result = 31 * result + (this.singleSelect != null ? this.singleSelect.hashCode() : 0);
                result = 31 * result + (this.text != null ? this.text.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about a section from an evaluation form.
     * <p>
     * A section can contain sections and/or questions. Evaluation forms can only contain sections and subsections (two level nesting).
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * EvaluationFormSectionProperty evaluationFormSectionProperty_;
     * EvaluationFormSectionProperty evaluationFormSectionProperty = EvaluationFormSectionProperty.builder()
     *         .refId("refId")
     *         .title("title")
     *         // the properties below are optional
     *         .instructions("instructions")
     *         .items(List.of(EvaluationFormItemProperty.builder()
     *                 .question(EvaluationFormQuestionProperty.builder()
     *                         .questionType("questionType")
     *                         .refId("refId")
     *                         .title("title")
     *                         // the properties below are optional
     *                         .enablement(EvaluationFormItemEnablementConfigurationProperty.builder()
     *                                 .action("action")
     *                                 .condition(EvaluationFormItemEnablementConditionProperty.builder()
     *                                         .operands(List.of(EvaluationFormItemEnablementConditionOperandProperty.builder()
     *                                                 .expression(EvaluationFormItemEnablementExpressionProperty.builder()
     *                                                         .comparator("comparator")
     *                                                         .source(EvaluationFormItemEnablementSourceProperty.builder()
     *                                                                 .type("type")
     *                                                                 // the properties below are optional
     *                                                                 .refId("refId")
     *                                                                 .build())
     *                                                         .values(List.of(EvaluationFormItemEnablementSourceValueProperty.builder()
     *                                                                 .refId("refId")
     *                                                                 .type("type")
     *                                                                 .build()))
     *                                                         .build())
     *                                                 .build()))
     *                                         // the properties below are optional
     *                                         .operator("operator")
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .defaultAction("defaultAction")
     *                                 .build())
     *                         .instructions("instructions")
     *                         .notApplicableEnabled(false)
     *                         .questionTypeProperties(EvaluationFormQuestionTypePropertiesProperty.builder()
     *                                 .multiSelect(EvaluationFormMultiSelectQuestionPropertiesProperty.builder()
     *                                         .options(List.of(EvaluationFormMultiSelectQuestionOptionProperty.builder()
     *                                                 .refId("refId")
     *                                                 .text("text")
     *                                                 .build()))
     *                                         // the properties below are optional
     *                                         .automation(EvaluationFormMultiSelectQuestionAutomationProperty.builder()
     *                                                 .options(List.of(EvaluationFormMultiSelectQuestionAutomationOptionProperty.builder()
     *                                                         .ruleCategory(MultiSelectQuestionRuleCategoryAutomationProperty.builder()
     *                                                                 .category("category")
     *                                                                 .condition("condition")
     *                                                                 .optionRefIds(List.of("optionRefIds"))
     *                                                                 .build())
     *                                                         .build()))
     *                                                 // the properties below are optional
     *                                                 .answerSource(EvaluationFormQuestionAutomationAnswerSourceProperty.builder()
     *                                                         .sourceType("sourceType")
     *                                                         .build())
     *                                                 .defaultOptionRefIds(List.of("defaultOptionRefIds"))
     *                                                 .build())
     *                                         .displayAs("displayAs")
     *                                         .build())
     *                                 .numeric(EvaluationFormNumericQuestionPropertiesProperty.builder()
     *                                         .maxValue(123)
     *                                         .minValue(123)
     *                                         // the properties below are optional
     *                                         .automation(EvaluationFormNumericQuestionAutomationProperty.builder()
     *                                                 .answerSource(EvaluationFormQuestionAutomationAnswerSourceProperty.builder()
     *                                                         .sourceType("sourceType")
     *                                                         .build())
     *                                                 .propertyValue(NumericQuestionPropertyValueAutomationProperty.builder()
     *                                                         .label("label")
     *                                                         .build())
     *                                                 .build())
     *                                         .options(List.of(EvaluationFormNumericQuestionOptionProperty.builder()
     *                                                 .maxValue(123)
     *                                                 .minValue(123)
     *                                                 // the properties below are optional
     *                                                 .automaticFail(false)
     *                                                 .automaticFailConfiguration(AutomaticFailConfigurationProperty.builder()
     *                                                         .targetSection("targetSection")
     *                                                         .build())
     *                                                 .score(123)
     *                                                 .build()))
     *                                         .build())
     *                                 .singleSelect(EvaluationFormSingleSelectQuestionPropertiesProperty.builder()
     *                                         .options(List.of(EvaluationFormSingleSelectQuestionOptionProperty.builder()
     *                                                 .refId("refId")
     *                                                 .text("text")
     *                                                 // the properties below are optional
     *                                                 .automaticFail(false)
     *                                                 .automaticFailConfiguration(AutomaticFailConfigurationProperty.builder()
     *                                                         .targetSection("targetSection")
     *                                                         .build())
     *                                                 .score(123)
     *                                                 .build()))
     *                                         // the properties below are optional
     *                                         .automation(EvaluationFormSingleSelectQuestionAutomationProperty.builder()
     *                                                 .options(List.of(EvaluationFormSingleSelectQuestionAutomationOptionProperty.builder()
     *                                                         .ruleCategory(SingleSelectQuestionRuleCategoryAutomationProperty.builder()
     *                                                                 .category("category")
     *                                                                 .condition("condition")
     *                                                                 .optionRefId("optionRefId")
     *                                                                 .build())
     *                                                         .build()))
     *                                                 // the properties below are optional
     *                                                 .answerSource(EvaluationFormQuestionAutomationAnswerSourceProperty.builder()
     *                                                         .sourceType("sourceType")
     *                                                         .build())
     *                                                 .defaultOptionRefId("defaultOptionRefId")
     *                                                 .build())
     *                                         .displayAs("displayAs")
     *                                         .build())
     *                                 .text(EvaluationFormTextQuestionPropertiesProperty.builder()
     *                                         .automation(EvaluationFormTextQuestionAutomationProperty.builder()
     *                                                 .answerSource(EvaluationFormQuestionAutomationAnswerSourceProperty.builder()
     *                                                         .sourceType("sourceType")
     *                                                         .build())
     *                                                 .build())
     *                                         .build())
     *                                 .build())
     *                         .weight(123)
     *                         .build())
     *                 .section(evaluationFormSectionProperty_)
     *                 .build()))
     *         .weight(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsection.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsection.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormSectionProperty")
    @software.amazon.jsii.Jsii.Proxy(EvaluationFormSectionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EvaluationFormSectionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The identifier of the section. An identifier must be unique within the evaluation form.
         * <p>
         * <em>Length Constraints</em> : Minimum length of 1. Maximum length of 40.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsection.html#cfn-connect-evaluationform-evaluationformsection-refid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsection.html#cfn-connect-evaluationform-evaluationformsection-refid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRefId();

        /**
         * The title of the section.
         * <p>
         * <em>Length Constraints</em> : Minimum length of 1. Maximum length of 128.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsection.html#cfn-connect-evaluationform-evaluationformsection-title">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsection.html#cfn-connect-evaluationform-evaluationformsection-title</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTitle();

        /**
         * The instructions of the section.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsection.html#cfn-connect-evaluationform-evaluationformsection-instructions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsection.html#cfn-connect-evaluationform-evaluationformsection-instructions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstructions() {
            return null;
        }

        /**
         * The items of the section.
         * <p>
         * <em>Minimum</em> : 1
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormItemProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsection.html#cfn-connect-evaluationform-evaluationformsection-items">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsection.html#cfn-connect-evaluationform-evaluationformsection-items</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getItems() {
            return null;
        }

        /**
         * The scoring weight of the section.
         * <p>
         * <em>Minimum</em> : 0
         * <p>
         * <em>Maximum</em> : 100
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsection.html#cfn-connect-evaluationform-evaluationformsection-weight">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsection.html#cfn-connect-evaluationform-evaluationformsection-weight</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getWeight() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EvaluationFormSectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EvaluationFormSectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EvaluationFormSectionProperty> {
            java.lang.String refId;
            java.lang.String title;
            java.lang.String instructions;
            java.lang.Object items;
            java.lang.Number weight;

            /**
             * Sets the value of {@link EvaluationFormSectionProperty#getRefId}
             * @param refId The identifier of the section. An identifier must be unique within the evaluation form. This parameter is required.
             *              <em>Length Constraints</em> : Minimum length of 1. Maximum length of 40.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder refId(java.lang.String refId) {
                this.refId = refId;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormSectionProperty#getTitle}
             * @param title The title of the section. This parameter is required.
             *              <em>Length Constraints</em> : Minimum length of 1. Maximum length of 128.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder title(java.lang.String title) {
                this.title = title;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormSectionProperty#getInstructions}
             * @param instructions The instructions of the section.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instructions(java.lang.String instructions) {
                this.instructions = instructions;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormSectionProperty#getItems}
             * @param items The items of the section.
             *              <em>Minimum</em> : 1
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder items(software.amazon.awscdk.IResolvable items) {
                this.items = items;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormSectionProperty#getItems}
             * @param items The items of the section.
             *              <em>Minimum</em> : 1
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder items(java.util.List<? extends java.lang.Object> items) {
                this.items = items;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormSectionProperty#getWeight}
             * @param weight The scoring weight of the section.
             *               <em>Minimum</em> : 0
             *               <p>
             *               <em>Maximum</em> : 100
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weight(java.lang.Number weight) {
                this.weight = weight;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EvaluationFormSectionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EvaluationFormSectionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EvaluationFormSectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EvaluationFormSectionProperty {
            private final java.lang.String refId;
            private final java.lang.String title;
            private final java.lang.String instructions;
            private final java.lang.Object items;
            private final java.lang.Number weight;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.refId = software.amazon.jsii.Kernel.get(this, "refId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.title = software.amazon.jsii.Kernel.get(this, "title", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.instructions = software.amazon.jsii.Kernel.get(this, "instructions", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.items = software.amazon.jsii.Kernel.get(this, "items", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.weight = software.amazon.jsii.Kernel.get(this, "weight", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.refId = java.util.Objects.requireNonNull(builder.refId, "refId is required");
                this.title = java.util.Objects.requireNonNull(builder.title, "title is required");
                this.instructions = builder.instructions;
                this.items = builder.items;
                this.weight = builder.weight;
            }

            @Override
            public final java.lang.String getRefId() {
                return this.refId;
            }

            @Override
            public final java.lang.String getTitle() {
                return this.title;
            }

            @Override
            public final java.lang.String getInstructions() {
                return this.instructions;
            }

            @Override
            public final java.lang.Object getItems() {
                return this.items;
            }

            @Override
            public final java.lang.Number getWeight() {
                return this.weight;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("refId", om.valueToTree(this.getRefId()));
                data.set("title", om.valueToTree(this.getTitle()));
                if (this.getInstructions() != null) {
                    data.set("instructions", om.valueToTree(this.getInstructions()));
                }
                if (this.getItems() != null) {
                    data.set("items", om.valueToTree(this.getItems()));
                }
                if (this.getWeight() != null) {
                    data.set("weight", om.valueToTree(this.getWeight()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormSectionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EvaluationFormSectionProperty.Jsii$Proxy that = (EvaluationFormSectionProperty.Jsii$Proxy) o;

                if (!refId.equals(that.refId)) return false;
                if (!title.equals(that.title)) return false;
                if (this.instructions != null ? !this.instructions.equals(that.instructions) : that.instructions != null) return false;
                if (this.items != null ? !this.items.equals(that.items) : that.items != null) return false;
                return this.weight != null ? this.weight.equals(that.weight) : that.weight == null;
            }

            @Override
            public final int hashCode() {
                int result = this.refId.hashCode();
                result = 31 * result + (this.title.hashCode());
                result = 31 * result + (this.instructions != null ? this.instructions.hashCode() : 0);
                result = 31 * result + (this.items != null ? this.items.hashCode() : 0);
                result = 31 * result + (this.weight != null ? this.weight.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The automation options of the single select question.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * EvaluationFormSingleSelectQuestionAutomationOptionProperty evaluationFormSingleSelectQuestionAutomationOptionProperty = EvaluationFormSingleSelectQuestionAutomationOptionProperty.builder()
     *         .ruleCategory(SingleSelectQuestionRuleCategoryAutomationProperty.builder()
     *                 .category("category")
     *                 .condition("condition")
     *                 .optionRefId("optionRefId")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionautomationoption.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionautomationoption.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormSingleSelectQuestionAutomationOptionProperty")
    @software.amazon.jsii.Jsii.Proxy(EvaluationFormSingleSelectQuestionAutomationOptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EvaluationFormSingleSelectQuestionAutomationOptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The automation option based on a rule category for the single select question.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.connect.CfnEvaluationForm.SingleSelectQuestionRuleCategoryAutomationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionautomationoption.html#cfn-connect-evaluationform-evaluationformsingleselectquestionautomationoption-rulecategory">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionautomationoption.html#cfn-connect-evaluationform-evaluationformsingleselectquestionautomationoption-rulecategory</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRuleCategory();

        /**
         * @return a {@link Builder} of {@link EvaluationFormSingleSelectQuestionAutomationOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EvaluationFormSingleSelectQuestionAutomationOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EvaluationFormSingleSelectQuestionAutomationOptionProperty> {
            java.lang.Object ruleCategory;

            /**
             * Sets the value of {@link EvaluationFormSingleSelectQuestionAutomationOptionProperty#getRuleCategory}
             * @param ruleCategory The automation option based on a rule category for the single select question. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ruleCategory(software.amazon.awscdk.IResolvable ruleCategory) {
                this.ruleCategory = ruleCategory;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormSingleSelectQuestionAutomationOptionProperty#getRuleCategory}
             * @param ruleCategory The automation option based on a rule category for the single select question. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ruleCategory(software.amazon.awscdk.services.connect.CfnEvaluationForm.SingleSelectQuestionRuleCategoryAutomationProperty ruleCategory) {
                this.ruleCategory = ruleCategory;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EvaluationFormSingleSelectQuestionAutomationOptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EvaluationFormSingleSelectQuestionAutomationOptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EvaluationFormSingleSelectQuestionAutomationOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EvaluationFormSingleSelectQuestionAutomationOptionProperty {
            private final java.lang.Object ruleCategory;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ruleCategory = software.amazon.jsii.Kernel.get(this, "ruleCategory", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ruleCategory = java.util.Objects.requireNonNull(builder.ruleCategory, "ruleCategory is required");
            }

            @Override
            public final java.lang.Object getRuleCategory() {
                return this.ruleCategory;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("ruleCategory", om.valueToTree(this.getRuleCategory()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormSingleSelectQuestionAutomationOptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EvaluationFormSingleSelectQuestionAutomationOptionProperty.Jsii$Proxy that = (EvaluationFormSingleSelectQuestionAutomationOptionProperty.Jsii$Proxy) o;

                return this.ruleCategory.equals(that.ruleCategory);
            }

            @Override
            public final int hashCode() {
                int result = this.ruleCategory.hashCode();
                return result;
            }
        }
    }
    /**
     * Information about the automation configuration in single select questions.
     * <p>
     * Automation options are evaluated in order, and the first matched option is applied. If no automation option matches, and there is a default option, then the default option is applied.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * EvaluationFormSingleSelectQuestionAutomationProperty evaluationFormSingleSelectQuestionAutomationProperty = EvaluationFormSingleSelectQuestionAutomationProperty.builder()
     *         .options(List.of(EvaluationFormSingleSelectQuestionAutomationOptionProperty.builder()
     *                 .ruleCategory(SingleSelectQuestionRuleCategoryAutomationProperty.builder()
     *                         .category("category")
     *                         .condition("condition")
     *                         .optionRefId("optionRefId")
     *                         .build())
     *                 .build()))
     *         // the properties below are optional
     *         .answerSource(EvaluationFormQuestionAutomationAnswerSourceProperty.builder()
     *                 .sourceType("sourceType")
     *                 .build())
     *         .defaultOptionRefId("defaultOptionRefId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionautomation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionautomation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormSingleSelectQuestionAutomationProperty")
    @software.amazon.jsii.Jsii.Proxy(EvaluationFormSingleSelectQuestionAutomationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EvaluationFormSingleSelectQuestionAutomationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The automation options of the single select question.
         * <p>
         * <em>Minimum</em> : 1
         * <p>
         * <em>Maximum</em> : 20
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormSingleSelectQuestionAutomationOptionProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionautomation.html#cfn-connect-evaluationform-evaluationformsingleselectquestionautomation-options">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionautomation.html#cfn-connect-evaluationform-evaluationformsingleselectquestionautomation-options</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getOptions();

        /**
         * Automation answer source.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormQuestionAutomationAnswerSourceProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionautomation.html#cfn-connect-evaluationform-evaluationformsingleselectquestionautomation-answersource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionautomation.html#cfn-connect-evaluationform-evaluationformsingleselectquestionautomation-answersource</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAnswerSource() {
            return null;
        }

        /**
         * The identifier of the default answer option, when none of the automation options match the criteria.
         * <p>
         * <em>Length Constraints</em> : Minimum length of 1. Maximum length of 40.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionautomation.html#cfn-connect-evaluationform-evaluationformsingleselectquestionautomation-defaultoptionrefid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionautomation.html#cfn-connect-evaluationform-evaluationformsingleselectquestionautomation-defaultoptionrefid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDefaultOptionRefId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EvaluationFormSingleSelectQuestionAutomationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EvaluationFormSingleSelectQuestionAutomationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EvaluationFormSingleSelectQuestionAutomationProperty> {
            java.lang.Object options;
            java.lang.Object answerSource;
            java.lang.String defaultOptionRefId;

            /**
             * Sets the value of {@link EvaluationFormSingleSelectQuestionAutomationProperty#getOptions}
             * @param options The automation options of the single select question. This parameter is required.
             *                <em>Minimum</em> : 1
             *                <p>
             *                <em>Maximum</em> : 20
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder options(software.amazon.awscdk.IResolvable options) {
                this.options = options;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormSingleSelectQuestionAutomationProperty#getOptions}
             * @param options The automation options of the single select question. This parameter is required.
             *                <em>Minimum</em> : 1
             *                <p>
             *                <em>Maximum</em> : 20
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder options(java.util.List<? extends java.lang.Object> options) {
                this.options = options;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormSingleSelectQuestionAutomationProperty#getAnswerSource}
             * @param answerSource Automation answer source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder answerSource(software.amazon.awscdk.IResolvable answerSource) {
                this.answerSource = answerSource;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormSingleSelectQuestionAutomationProperty#getAnswerSource}
             * @param answerSource Automation answer source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder answerSource(software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormQuestionAutomationAnswerSourceProperty answerSource) {
                this.answerSource = answerSource;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormSingleSelectQuestionAutomationProperty#getDefaultOptionRefId}
             * @param defaultOptionRefId The identifier of the default answer option, when none of the automation options match the criteria.
             *                           <em>Length Constraints</em> : Minimum length of 1. Maximum length of 40.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultOptionRefId(java.lang.String defaultOptionRefId) {
                this.defaultOptionRefId = defaultOptionRefId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EvaluationFormSingleSelectQuestionAutomationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EvaluationFormSingleSelectQuestionAutomationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EvaluationFormSingleSelectQuestionAutomationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EvaluationFormSingleSelectQuestionAutomationProperty {
            private final java.lang.Object options;
            private final java.lang.Object answerSource;
            private final java.lang.String defaultOptionRefId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.options = software.amazon.jsii.Kernel.get(this, "options", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.answerSource = software.amazon.jsii.Kernel.get(this, "answerSource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.defaultOptionRefId = software.amazon.jsii.Kernel.get(this, "defaultOptionRefId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.options = java.util.Objects.requireNonNull(builder.options, "options is required");
                this.answerSource = builder.answerSource;
                this.defaultOptionRefId = builder.defaultOptionRefId;
            }

            @Override
            public final java.lang.Object getOptions() {
                return this.options;
            }

            @Override
            public final java.lang.Object getAnswerSource() {
                return this.answerSource;
            }

            @Override
            public final java.lang.String getDefaultOptionRefId() {
                return this.defaultOptionRefId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("options", om.valueToTree(this.getOptions()));
                if (this.getAnswerSource() != null) {
                    data.set("answerSource", om.valueToTree(this.getAnswerSource()));
                }
                if (this.getDefaultOptionRefId() != null) {
                    data.set("defaultOptionRefId", om.valueToTree(this.getDefaultOptionRefId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormSingleSelectQuestionAutomationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EvaluationFormSingleSelectQuestionAutomationProperty.Jsii$Proxy that = (EvaluationFormSingleSelectQuestionAutomationProperty.Jsii$Proxy) o;

                if (!options.equals(that.options)) return false;
                if (this.answerSource != null ? !this.answerSource.equals(that.answerSource) : that.answerSource != null) return false;
                return this.defaultOptionRefId != null ? this.defaultOptionRefId.equals(that.defaultOptionRefId) : that.defaultOptionRefId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.options.hashCode();
                result = 31 * result + (this.answerSource != null ? this.answerSource.hashCode() : 0);
                result = 31 * result + (this.defaultOptionRefId != null ? this.defaultOptionRefId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about the automation configuration in single select questions.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * EvaluationFormSingleSelectQuestionOptionProperty evaluationFormSingleSelectQuestionOptionProperty = EvaluationFormSingleSelectQuestionOptionProperty.builder()
     *         .refId("refId")
     *         .text("text")
     *         // the properties below are optional
     *         .automaticFail(false)
     *         .automaticFailConfiguration(AutomaticFailConfigurationProperty.builder()
     *                 .targetSection("targetSection")
     *                 .build())
     *         .score(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionoption.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionoption.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormSingleSelectQuestionOptionProperty")
    @software.amazon.jsii.Jsii.Proxy(EvaluationFormSingleSelectQuestionOptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EvaluationFormSingleSelectQuestionOptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The identifier of the answer option. An identifier must be unique within the question.
         * <p>
         * <em>Length Constraints</em> : Minimum length of 1. Maximum length of 40.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionoption.html#cfn-connect-evaluationform-evaluationformsingleselectquestionoption-refid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionoption.html#cfn-connect-evaluationform-evaluationformsingleselectquestionoption-refid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRefId();

        /**
         * The title of the answer option.
         * <p>
         * <em>Length Constraints</em> : Minimum length of 1. Maximum length of 128.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionoption.html#cfn-connect-evaluationform-evaluationformsingleselectquestionoption-text">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionoption.html#cfn-connect-evaluationform-evaluationformsingleselectquestionoption-text</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getText();

        /**
         * The flag to mark the option as automatic fail.
         * <p>
         * If an automatic fail answer is provided, the overall evaluation gets a score of 0.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionoption.html#cfn-connect-evaluationform-evaluationformsingleselectquestionoption-automaticfail">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionoption.html#cfn-connect-evaluationform-evaluationformsingleselectquestionoption-automaticfail</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAutomaticFail() {
            return null;
        }

        /**
         * Whether automatic fail is configured on a single select question.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.connect.CfnEvaluationForm.AutomaticFailConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionoption.html#cfn-connect-evaluationform-evaluationformsingleselectquestionoption-automaticfailconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionoption.html#cfn-connect-evaluationform-evaluationformsingleselectquestionoption-automaticfailconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAutomaticFailConfiguration() {
            return null;
        }

        /**
         * The score assigned to the answer option.
         * <p>
         * <em>Minimum</em> : 0
         * <p>
         * <em>Maximum</em> : 10
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionoption.html#cfn-connect-evaluationform-evaluationformsingleselectquestionoption-score">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionoption.html#cfn-connect-evaluationform-evaluationformsingleselectquestionoption-score</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getScore() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EvaluationFormSingleSelectQuestionOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EvaluationFormSingleSelectQuestionOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EvaluationFormSingleSelectQuestionOptionProperty> {
            java.lang.String refId;
            java.lang.String text;
            java.lang.Object automaticFail;
            java.lang.Object automaticFailConfiguration;
            java.lang.Number score;

            /**
             * Sets the value of {@link EvaluationFormSingleSelectQuestionOptionProperty#getRefId}
             * @param refId The identifier of the answer option. An identifier must be unique within the question. This parameter is required.
             *              <em>Length Constraints</em> : Minimum length of 1. Maximum length of 40.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder refId(java.lang.String refId) {
                this.refId = refId;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormSingleSelectQuestionOptionProperty#getText}
             * @param text The title of the answer option. This parameter is required.
             *             <em>Length Constraints</em> : Minimum length of 1. Maximum length of 128.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder text(java.lang.String text) {
                this.text = text;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormSingleSelectQuestionOptionProperty#getAutomaticFail}
             * @param automaticFail The flag to mark the option as automatic fail.
             *                      If an automatic fail answer is provided, the overall evaluation gets a score of 0.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder automaticFail(java.lang.Boolean automaticFail) {
                this.automaticFail = automaticFail;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormSingleSelectQuestionOptionProperty#getAutomaticFail}
             * @param automaticFail The flag to mark the option as automatic fail.
             *                      If an automatic fail answer is provided, the overall evaluation gets a score of 0.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder automaticFail(software.amazon.awscdk.IResolvable automaticFail) {
                this.automaticFail = automaticFail;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormSingleSelectQuestionOptionProperty#getAutomaticFailConfiguration}
             * @param automaticFailConfiguration Whether automatic fail is configured on a single select question.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder automaticFailConfiguration(software.amazon.awscdk.IResolvable automaticFailConfiguration) {
                this.automaticFailConfiguration = automaticFailConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormSingleSelectQuestionOptionProperty#getAutomaticFailConfiguration}
             * @param automaticFailConfiguration Whether automatic fail is configured on a single select question.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder automaticFailConfiguration(software.amazon.awscdk.services.connect.CfnEvaluationForm.AutomaticFailConfigurationProperty automaticFailConfiguration) {
                this.automaticFailConfiguration = automaticFailConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormSingleSelectQuestionOptionProperty#getScore}
             * @param score The score assigned to the answer option.
             *              <em>Minimum</em> : 0
             *              <p>
             *              <em>Maximum</em> : 10
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder score(java.lang.Number score) {
                this.score = score;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EvaluationFormSingleSelectQuestionOptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EvaluationFormSingleSelectQuestionOptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EvaluationFormSingleSelectQuestionOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EvaluationFormSingleSelectQuestionOptionProperty {
            private final java.lang.String refId;
            private final java.lang.String text;
            private final java.lang.Object automaticFail;
            private final java.lang.Object automaticFailConfiguration;
            private final java.lang.Number score;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.refId = software.amazon.jsii.Kernel.get(this, "refId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.text = software.amazon.jsii.Kernel.get(this, "text", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.automaticFail = software.amazon.jsii.Kernel.get(this, "automaticFail", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.automaticFailConfiguration = software.amazon.jsii.Kernel.get(this, "automaticFailConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.score = software.amazon.jsii.Kernel.get(this, "score", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.refId = java.util.Objects.requireNonNull(builder.refId, "refId is required");
                this.text = java.util.Objects.requireNonNull(builder.text, "text is required");
                this.automaticFail = builder.automaticFail;
                this.automaticFailConfiguration = builder.automaticFailConfiguration;
                this.score = builder.score;
            }

            @Override
            public final java.lang.String getRefId() {
                return this.refId;
            }

            @Override
            public final java.lang.String getText() {
                return this.text;
            }

            @Override
            public final java.lang.Object getAutomaticFail() {
                return this.automaticFail;
            }

            @Override
            public final java.lang.Object getAutomaticFailConfiguration() {
                return this.automaticFailConfiguration;
            }

            @Override
            public final java.lang.Number getScore() {
                return this.score;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("refId", om.valueToTree(this.getRefId()));
                data.set("text", om.valueToTree(this.getText()));
                if (this.getAutomaticFail() != null) {
                    data.set("automaticFail", om.valueToTree(this.getAutomaticFail()));
                }
                if (this.getAutomaticFailConfiguration() != null) {
                    data.set("automaticFailConfiguration", om.valueToTree(this.getAutomaticFailConfiguration()));
                }
                if (this.getScore() != null) {
                    data.set("score", om.valueToTree(this.getScore()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormSingleSelectQuestionOptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EvaluationFormSingleSelectQuestionOptionProperty.Jsii$Proxy that = (EvaluationFormSingleSelectQuestionOptionProperty.Jsii$Proxy) o;

                if (!refId.equals(that.refId)) return false;
                if (!text.equals(that.text)) return false;
                if (this.automaticFail != null ? !this.automaticFail.equals(that.automaticFail) : that.automaticFail != null) return false;
                if (this.automaticFailConfiguration != null ? !this.automaticFailConfiguration.equals(that.automaticFailConfiguration) : that.automaticFailConfiguration != null) return false;
                return this.score != null ? this.score.equals(that.score) : that.score == null;
            }

            @Override
            public final int hashCode() {
                int result = this.refId.hashCode();
                result = 31 * result + (this.text.hashCode());
                result = 31 * result + (this.automaticFail != null ? this.automaticFail.hashCode() : 0);
                result = 31 * result + (this.automaticFailConfiguration != null ? this.automaticFailConfiguration.hashCode() : 0);
                result = 31 * result + (this.score != null ? this.score.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about the options in single select questions.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * EvaluationFormSingleSelectQuestionPropertiesProperty evaluationFormSingleSelectQuestionPropertiesProperty = EvaluationFormSingleSelectQuestionPropertiesProperty.builder()
     *         .options(List.of(EvaluationFormSingleSelectQuestionOptionProperty.builder()
     *                 .refId("refId")
     *                 .text("text")
     *                 // the properties below are optional
     *                 .automaticFail(false)
     *                 .automaticFailConfiguration(AutomaticFailConfigurationProperty.builder()
     *                         .targetSection("targetSection")
     *                         .build())
     *                 .score(123)
     *                 .build()))
     *         // the properties below are optional
     *         .automation(EvaluationFormSingleSelectQuestionAutomationProperty.builder()
     *                 .options(List.of(EvaluationFormSingleSelectQuestionAutomationOptionProperty.builder()
     *                         .ruleCategory(SingleSelectQuestionRuleCategoryAutomationProperty.builder()
     *                                 .category("category")
     *                                 .condition("condition")
     *                                 .optionRefId("optionRefId")
     *                                 .build())
     *                         .build()))
     *                 // the properties below are optional
     *                 .answerSource(EvaluationFormQuestionAutomationAnswerSourceProperty.builder()
     *                         .sourceType("sourceType")
     *                         .build())
     *                 .defaultOptionRefId("defaultOptionRefId")
     *                 .build())
     *         .displayAs("displayAs")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormSingleSelectQuestionPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(EvaluationFormSingleSelectQuestionPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EvaluationFormSingleSelectQuestionPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The answer options of the single select question.
         * <p>
         * <em>Minimum</em> : 2
         * <p>
         * <em>Maximum</em> : 256
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormSingleSelectQuestionOptionProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionproperties.html#cfn-connect-evaluationform-evaluationformsingleselectquestionproperties-options">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionproperties.html#cfn-connect-evaluationform-evaluationformsingleselectquestionproperties-options</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getOptions();

        /**
         * The display mode of the single select question.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormSingleSelectQuestionAutomationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionproperties.html#cfn-connect-evaluationform-evaluationformsingleselectquestionproperties-automation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionproperties.html#cfn-connect-evaluationform-evaluationformsingleselectquestionproperties-automation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAutomation() {
            return null;
        }

        /**
         * The display mode of the single select question.
         * <p>
         * <em>Allowed values</em> : <code>DROPDOWN</code> | <code>RADIO</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionproperties.html#cfn-connect-evaluationform-evaluationformsingleselectquestionproperties-displayas">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformsingleselectquestionproperties.html#cfn-connect-evaluationform-evaluationformsingleselectquestionproperties-displayas</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDisplayAs() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EvaluationFormSingleSelectQuestionPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EvaluationFormSingleSelectQuestionPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EvaluationFormSingleSelectQuestionPropertiesProperty> {
            java.lang.Object options;
            java.lang.Object automation;
            java.lang.String displayAs;

            /**
             * Sets the value of {@link EvaluationFormSingleSelectQuestionPropertiesProperty#getOptions}
             * @param options The answer options of the single select question. This parameter is required.
             *                <em>Minimum</em> : 2
             *                <p>
             *                <em>Maximum</em> : 256
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder options(software.amazon.awscdk.IResolvable options) {
                this.options = options;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormSingleSelectQuestionPropertiesProperty#getOptions}
             * @param options The answer options of the single select question. This parameter is required.
             *                <em>Minimum</em> : 2
             *                <p>
             *                <em>Maximum</em> : 256
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder options(java.util.List<? extends java.lang.Object> options) {
                this.options = options;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormSingleSelectQuestionPropertiesProperty#getAutomation}
             * @param automation The display mode of the single select question.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder automation(software.amazon.awscdk.IResolvable automation) {
                this.automation = automation;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormSingleSelectQuestionPropertiesProperty#getAutomation}
             * @param automation The display mode of the single select question.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder automation(software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormSingleSelectQuestionAutomationProperty automation) {
                this.automation = automation;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormSingleSelectQuestionPropertiesProperty#getDisplayAs}
             * @param displayAs The display mode of the single select question.
             *                  <em>Allowed values</em> : <code>DROPDOWN</code> | <code>RADIO</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder displayAs(java.lang.String displayAs) {
                this.displayAs = displayAs;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EvaluationFormSingleSelectQuestionPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EvaluationFormSingleSelectQuestionPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EvaluationFormSingleSelectQuestionPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EvaluationFormSingleSelectQuestionPropertiesProperty {
            private final java.lang.Object options;
            private final java.lang.Object automation;
            private final java.lang.String displayAs;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.options = software.amazon.jsii.Kernel.get(this, "options", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.automation = software.amazon.jsii.Kernel.get(this, "automation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.displayAs = software.amazon.jsii.Kernel.get(this, "displayAs", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.options = java.util.Objects.requireNonNull(builder.options, "options is required");
                this.automation = builder.automation;
                this.displayAs = builder.displayAs;
            }

            @Override
            public final java.lang.Object getOptions() {
                return this.options;
            }

            @Override
            public final java.lang.Object getAutomation() {
                return this.automation;
            }

            @Override
            public final java.lang.String getDisplayAs() {
                return this.displayAs;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("options", om.valueToTree(this.getOptions()));
                if (this.getAutomation() != null) {
                    data.set("automation", om.valueToTree(this.getAutomation()));
                }
                if (this.getDisplayAs() != null) {
                    data.set("displayAs", om.valueToTree(this.getDisplayAs()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormSingleSelectQuestionPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EvaluationFormSingleSelectQuestionPropertiesProperty.Jsii$Proxy that = (EvaluationFormSingleSelectQuestionPropertiesProperty.Jsii$Proxy) o;

                if (!options.equals(that.options)) return false;
                if (this.automation != null ? !this.automation.equals(that.automation) : that.automation != null) return false;
                return this.displayAs != null ? this.displayAs.equals(that.displayAs) : that.displayAs == null;
            }

            @Override
            public final int hashCode() {
                int result = this.options.hashCode();
                result = 31 * result + (this.automation != null ? this.automation.hashCode() : 0);
                result = 31 * result + (this.displayAs != null ? this.displayAs.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * EvaluationFormTargetConfigurationProperty evaluationFormTargetConfigurationProperty = EvaluationFormTargetConfigurationProperty.builder()
     *         .contactInteractionType("contactInteractionType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformtargetconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformtargetconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormTargetConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(EvaluationFormTargetConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EvaluationFormTargetConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The interaction type of a contact.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformtargetconfiguration.html#cfn-connect-evaluationform-evaluationformtargetconfiguration-contactinteractiontype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformtargetconfiguration.html#cfn-connect-evaluationform-evaluationformtargetconfiguration-contactinteractiontype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getContactInteractionType();

        /**
         * @return a {@link Builder} of {@link EvaluationFormTargetConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EvaluationFormTargetConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EvaluationFormTargetConfigurationProperty> {
            java.lang.String contactInteractionType;

            /**
             * Sets the value of {@link EvaluationFormTargetConfigurationProperty#getContactInteractionType}
             * @param contactInteractionType The interaction type of a contact. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contactInteractionType(java.lang.String contactInteractionType) {
                this.contactInteractionType = contactInteractionType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EvaluationFormTargetConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EvaluationFormTargetConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EvaluationFormTargetConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EvaluationFormTargetConfigurationProperty {
            private final java.lang.String contactInteractionType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.contactInteractionType = software.amazon.jsii.Kernel.get(this, "contactInteractionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.contactInteractionType = java.util.Objects.requireNonNull(builder.contactInteractionType, "contactInteractionType is required");
            }

            @Override
            public final java.lang.String getContactInteractionType() {
                return this.contactInteractionType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("contactInteractionType", om.valueToTree(this.getContactInteractionType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormTargetConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EvaluationFormTargetConfigurationProperty.Jsii$Proxy that = (EvaluationFormTargetConfigurationProperty.Jsii$Proxy) o;

                return this.contactInteractionType.equals(that.contactInteractionType);
            }

            @Override
            public final int hashCode() {
                int result = this.contactInteractionType.hashCode();
                return result;
            }
        }
    }
    /**
     * Information about the automation configuration in text questions.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * EvaluationFormTextQuestionAutomationProperty evaluationFormTextQuestionAutomationProperty = EvaluationFormTextQuestionAutomationProperty.builder()
     *         .answerSource(EvaluationFormQuestionAutomationAnswerSourceProperty.builder()
     *                 .sourceType("sourceType")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformtextquestionautomation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformtextquestionautomation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormTextQuestionAutomationProperty")
    @software.amazon.jsii.Jsii.Proxy(EvaluationFormTextQuestionAutomationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EvaluationFormTextQuestionAutomationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Automation answer source.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormQuestionAutomationAnswerSourceProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformtextquestionautomation.html#cfn-connect-evaluationform-evaluationformtextquestionautomation-answersource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformtextquestionautomation.html#cfn-connect-evaluationform-evaluationformtextquestionautomation-answersource</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAnswerSource() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EvaluationFormTextQuestionAutomationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EvaluationFormTextQuestionAutomationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EvaluationFormTextQuestionAutomationProperty> {
            java.lang.Object answerSource;

            /**
             * Sets the value of {@link EvaluationFormTextQuestionAutomationProperty#getAnswerSource}
             * @param answerSource Automation answer source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder answerSource(software.amazon.awscdk.IResolvable answerSource) {
                this.answerSource = answerSource;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormTextQuestionAutomationProperty#getAnswerSource}
             * @param answerSource Automation answer source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder answerSource(software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormQuestionAutomationAnswerSourceProperty answerSource) {
                this.answerSource = answerSource;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EvaluationFormTextQuestionAutomationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EvaluationFormTextQuestionAutomationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EvaluationFormTextQuestionAutomationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EvaluationFormTextQuestionAutomationProperty {
            private final java.lang.Object answerSource;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.answerSource = software.amazon.jsii.Kernel.get(this, "answerSource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.answerSource = builder.answerSource;
            }

            @Override
            public final java.lang.Object getAnswerSource() {
                return this.answerSource;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAnswerSource() != null) {
                    data.set("answerSource", om.valueToTree(this.getAnswerSource()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormTextQuestionAutomationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EvaluationFormTextQuestionAutomationProperty.Jsii$Proxy that = (EvaluationFormTextQuestionAutomationProperty.Jsii$Proxy) o;

                return this.answerSource != null ? this.answerSource.equals(that.answerSource) : that.answerSource == null;
            }

            @Override
            public final int hashCode() {
                int result = this.answerSource != null ? this.answerSource.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Information about properties for a text question in an evaluation form.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * EvaluationFormTextQuestionPropertiesProperty evaluationFormTextQuestionPropertiesProperty = EvaluationFormTextQuestionPropertiesProperty.builder()
     *         .automation(EvaluationFormTextQuestionAutomationProperty.builder()
     *                 .answerSource(EvaluationFormQuestionAutomationAnswerSourceProperty.builder()
     *                         .sourceType("sourceType")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformtextquestionproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformtextquestionproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormTextQuestionPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(EvaluationFormTextQuestionPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EvaluationFormTextQuestionPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The automation properties of the text question.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormTextQuestionAutomationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformtextquestionproperties.html#cfn-connect-evaluationform-evaluationformtextquestionproperties-automation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-evaluationformtextquestionproperties.html#cfn-connect-evaluationform-evaluationformtextquestionproperties-automation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAutomation() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EvaluationFormTextQuestionPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EvaluationFormTextQuestionPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EvaluationFormTextQuestionPropertiesProperty> {
            java.lang.Object automation;

            /**
             * Sets the value of {@link EvaluationFormTextQuestionPropertiesProperty#getAutomation}
             * @param automation The automation properties of the text question.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder automation(software.amazon.awscdk.IResolvable automation) {
                this.automation = automation;
                return this;
            }

            /**
             * Sets the value of {@link EvaluationFormTextQuestionPropertiesProperty#getAutomation}
             * @param automation The automation properties of the text question.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder automation(software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormTextQuestionAutomationProperty automation) {
                this.automation = automation;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EvaluationFormTextQuestionPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EvaluationFormTextQuestionPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EvaluationFormTextQuestionPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EvaluationFormTextQuestionPropertiesProperty {
            private final java.lang.Object automation;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.automation = software.amazon.jsii.Kernel.get(this, "automation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.automation = builder.automation;
            }

            @Override
            public final java.lang.Object getAutomation() {
                return this.automation;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAutomation() != null) {
                    data.set("automation", om.valueToTree(this.getAutomation()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnEvaluationForm.EvaluationFormTextQuestionPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EvaluationFormTextQuestionPropertiesProperty.Jsii$Proxy that = (EvaluationFormTextQuestionPropertiesProperty.Jsii$Proxy) o;

                return this.automation != null ? this.automation.equals(that.automation) : that.automation == null;
            }

            @Override
            public final int hashCode() {
                int result = this.automation != null ? this.automation.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * MultiSelectQuestionRuleCategoryAutomationProperty multiSelectQuestionRuleCategoryAutomationProperty = MultiSelectQuestionRuleCategoryAutomationProperty.builder()
     *         .category("category")
     *         .condition("condition")
     *         .optionRefIds(List.of("optionRefIds"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-multiselectquestionrulecategoryautomation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-multiselectquestionrulecategoryautomation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm.MultiSelectQuestionRuleCategoryAutomationProperty")
    @software.amazon.jsii.Jsii.Proxy(MultiSelectQuestionRuleCategoryAutomationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MultiSelectQuestionRuleCategoryAutomationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The category name as defined in Rules.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-multiselectquestionrulecategoryautomation.html#cfn-connect-evaluationform-multiselectquestionrulecategoryautomation-category">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-multiselectquestionrulecategoryautomation.html#cfn-connect-evaluationform-multiselectquestionrulecategoryautomation-category</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCategory();

        /**
         * The automation condition applied on contact categories.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-multiselectquestionrulecategoryautomation.html#cfn-connect-evaluationform-multiselectquestionrulecategoryautomation-condition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-multiselectquestionrulecategoryautomation.html#cfn-connect-evaluationform-multiselectquestionrulecategoryautomation-condition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCondition();

        /**
         * The list of reference id.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-multiselectquestionrulecategoryautomation.html#cfn-connect-evaluationform-multiselectquestionrulecategoryautomation-optionrefids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-multiselectquestionrulecategoryautomation.html#cfn-connect-evaluationform-multiselectquestionrulecategoryautomation-optionrefids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getOptionRefIds();

        /**
         * @return a {@link Builder} of {@link MultiSelectQuestionRuleCategoryAutomationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MultiSelectQuestionRuleCategoryAutomationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MultiSelectQuestionRuleCategoryAutomationProperty> {
            java.lang.String category;
            java.lang.String condition;
            java.util.List<java.lang.String> optionRefIds;

            /**
             * Sets the value of {@link MultiSelectQuestionRuleCategoryAutomationProperty#getCategory}
             * @param category The category name as defined in Rules. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder category(java.lang.String category) {
                this.category = category;
                return this;
            }

            /**
             * Sets the value of {@link MultiSelectQuestionRuleCategoryAutomationProperty#getCondition}
             * @param condition The automation condition applied on contact categories. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder condition(java.lang.String condition) {
                this.condition = condition;
                return this;
            }

            /**
             * Sets the value of {@link MultiSelectQuestionRuleCategoryAutomationProperty#getOptionRefIds}
             * @param optionRefIds The list of reference id. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder optionRefIds(java.util.List<java.lang.String> optionRefIds) {
                this.optionRefIds = optionRefIds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MultiSelectQuestionRuleCategoryAutomationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MultiSelectQuestionRuleCategoryAutomationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MultiSelectQuestionRuleCategoryAutomationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MultiSelectQuestionRuleCategoryAutomationProperty {
            private final java.lang.String category;
            private final java.lang.String condition;
            private final java.util.List<java.lang.String> optionRefIds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.category = software.amazon.jsii.Kernel.get(this, "category", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.condition = software.amazon.jsii.Kernel.get(this, "condition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.optionRefIds = software.amazon.jsii.Kernel.get(this, "optionRefIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.category = java.util.Objects.requireNonNull(builder.category, "category is required");
                this.condition = java.util.Objects.requireNonNull(builder.condition, "condition is required");
                this.optionRefIds = java.util.Objects.requireNonNull(builder.optionRefIds, "optionRefIds is required");
            }

            @Override
            public final java.lang.String getCategory() {
                return this.category;
            }

            @Override
            public final java.lang.String getCondition() {
                return this.condition;
            }

            @Override
            public final java.util.List<java.lang.String> getOptionRefIds() {
                return this.optionRefIds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("category", om.valueToTree(this.getCategory()));
                data.set("condition", om.valueToTree(this.getCondition()));
                data.set("optionRefIds", om.valueToTree(this.getOptionRefIds()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnEvaluationForm.MultiSelectQuestionRuleCategoryAutomationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MultiSelectQuestionRuleCategoryAutomationProperty.Jsii$Proxy that = (MultiSelectQuestionRuleCategoryAutomationProperty.Jsii$Proxy) o;

                if (!category.equals(that.category)) return false;
                if (!condition.equals(that.condition)) return false;
                return this.optionRefIds.equals(that.optionRefIds);
            }

            @Override
            public final int hashCode() {
                int result = this.category.hashCode();
                result = 31 * result + (this.condition.hashCode());
                result = 31 * result + (this.optionRefIds.hashCode());
                return result;
            }
        }
    }
    /**
     * Information about the property value used in automation of a numeric questions.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * NumericQuestionPropertyValueAutomationProperty numericQuestionPropertyValueAutomationProperty = NumericQuestionPropertyValueAutomationProperty.builder()
     *         .label("label")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-numericquestionpropertyvalueautomation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-numericquestionpropertyvalueautomation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm.NumericQuestionPropertyValueAutomationProperty")
    @software.amazon.jsii.Jsii.Proxy(NumericQuestionPropertyValueAutomationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NumericQuestionPropertyValueAutomationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The property label of the automation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-numericquestionpropertyvalueautomation.html#cfn-connect-evaluationform-numericquestionpropertyvalueautomation-label">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-numericquestionpropertyvalueautomation.html#cfn-connect-evaluationform-numericquestionpropertyvalueautomation-label</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLabel();

        /**
         * @return a {@link Builder} of {@link NumericQuestionPropertyValueAutomationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NumericQuestionPropertyValueAutomationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NumericQuestionPropertyValueAutomationProperty> {
            java.lang.String label;

            /**
             * Sets the value of {@link NumericQuestionPropertyValueAutomationProperty#getLabel}
             * @param label The property label of the automation. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder label(java.lang.String label) {
                this.label = label;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NumericQuestionPropertyValueAutomationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NumericQuestionPropertyValueAutomationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NumericQuestionPropertyValueAutomationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NumericQuestionPropertyValueAutomationProperty {
            private final java.lang.String label;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.label = software.amazon.jsii.Kernel.get(this, "label", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.label = java.util.Objects.requireNonNull(builder.label, "label is required");
            }

            @Override
            public final java.lang.String getLabel() {
                return this.label;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("label", om.valueToTree(this.getLabel()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnEvaluationForm.NumericQuestionPropertyValueAutomationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NumericQuestionPropertyValueAutomationProperty.Jsii$Proxy that = (NumericQuestionPropertyValueAutomationProperty.Jsii$Proxy) o;

                return this.label.equals(that.label);
            }

            @Override
            public final int hashCode() {
                int result = this.label.hashCode();
                return result;
            }
        }
    }
    /**
     * A scoring strategy of the evaluation form.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * ScoringStrategyProperty scoringStrategyProperty = ScoringStrategyProperty.builder()
     *         .mode("mode")
     *         .status("status")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-scoringstrategy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-scoringstrategy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm.ScoringStrategyProperty")
    @software.amazon.jsii.Jsii.Proxy(ScoringStrategyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScoringStrategyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The scoring mode of the evaluation form.
         * <p>
         * <em>Allowed values</em> : <code>QUESTION_ONLY</code> | <code>SECTION_ONLY</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-scoringstrategy.html#cfn-connect-evaluationform-scoringstrategy-mode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-scoringstrategy.html#cfn-connect-evaluationform-scoringstrategy-mode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMode();

        /**
         * The scoring status of the evaluation form.
         * <p>
         * <em>Allowed values</em> : <code>ENABLED</code> | <code>DISABLED</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-scoringstrategy.html#cfn-connect-evaluationform-scoringstrategy-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-scoringstrategy.html#cfn-connect-evaluationform-scoringstrategy-status</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStatus();

        /**
         * @return a {@link Builder} of {@link ScoringStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScoringStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScoringStrategyProperty> {
            java.lang.String mode;
            java.lang.String status;

            /**
             * Sets the value of {@link ScoringStrategyProperty#getMode}
             * @param mode The scoring mode of the evaluation form. This parameter is required.
             *             <em>Allowed values</em> : <code>QUESTION_ONLY</code> | <code>SECTION_ONLY</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mode(java.lang.String mode) {
                this.mode = mode;
                return this;
            }

            /**
             * Sets the value of {@link ScoringStrategyProperty#getStatus}
             * @param status The scoring status of the evaluation form. This parameter is required.
             *               <em>Allowed values</em> : <code>ENABLED</code> | <code>DISABLED</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScoringStrategyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScoringStrategyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScoringStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScoringStrategyProperty {
            private final java.lang.String mode;
            private final java.lang.String status;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.mode = software.amazon.jsii.Kernel.get(this, "mode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.mode = java.util.Objects.requireNonNull(builder.mode, "mode is required");
                this.status = java.util.Objects.requireNonNull(builder.status, "status is required");
            }

            @Override
            public final java.lang.String getMode() {
                return this.mode;
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("mode", om.valueToTree(this.getMode()));
                data.set("status", om.valueToTree(this.getStatus()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnEvaluationForm.ScoringStrategyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScoringStrategyProperty.Jsii$Proxy that = (ScoringStrategyProperty.Jsii$Proxy) o;

                if (!mode.equals(that.mode)) return false;
                return this.status.equals(that.status);
            }

            @Override
            public final int hashCode() {
                int result = this.mode.hashCode();
                result = 31 * result + (this.status.hashCode());
                return result;
            }
        }
    }
    /**
     * Information about the automation option based on a rule category for a single select question.
     * <p>
     * <em>Length Constraints</em> : Minimum length of 1. Maximum length of 50.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * SingleSelectQuestionRuleCategoryAutomationProperty singleSelectQuestionRuleCategoryAutomationProperty = SingleSelectQuestionRuleCategoryAutomationProperty.builder()
     *         .category("category")
     *         .condition("condition")
     *         .optionRefId("optionRefId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-singleselectquestionrulecategoryautomation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-singleselectquestionrulecategoryautomation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnEvaluationForm.SingleSelectQuestionRuleCategoryAutomationProperty")
    @software.amazon.jsii.Jsii.Proxy(SingleSelectQuestionRuleCategoryAutomationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SingleSelectQuestionRuleCategoryAutomationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The category name, as defined in Rules.
         * <p>
         * <em>Minimum</em> : 1
         * <p>
         * <em>Maximum</em> : 50
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-singleselectquestionrulecategoryautomation.html#cfn-connect-evaluationform-singleselectquestionrulecategoryautomation-category">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-singleselectquestionrulecategoryautomation.html#cfn-connect-evaluationform-singleselectquestionrulecategoryautomation-category</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCategory();

        /**
         * The condition to apply for the automation option.
         * <p>
         * If the condition is PRESENT, then the option is applied when the contact data includes the category. Similarly, if the condition is NOT_PRESENT, then the option is applied when the contact data does not include the category.
         * <p>
         * <em>Allowed values</em> : <code>PRESENT</code> | <code>NOT_PRESENT</code>
         * <p>
         * <em>Maximum</em> : 50
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-singleselectquestionrulecategoryautomation.html#cfn-connect-evaluationform-singleselectquestionrulecategoryautomation-condition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-singleselectquestionrulecategoryautomation.html#cfn-connect-evaluationform-singleselectquestionrulecategoryautomation-condition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCondition();

        /**
         * The identifier of the answer option. An identifier must be unique within the question.
         * <p>
         * <em>Length Constraints</em> : Minimum length of 1. Maximum length of 40.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-singleselectquestionrulecategoryautomation.html#cfn-connect-evaluationform-singleselectquestionrulecategoryautomation-optionrefid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-evaluationform-singleselectquestionrulecategoryautomation.html#cfn-connect-evaluationform-singleselectquestionrulecategoryautomation-optionrefid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOptionRefId();

        /**
         * @return a {@link Builder} of {@link SingleSelectQuestionRuleCategoryAutomationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SingleSelectQuestionRuleCategoryAutomationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SingleSelectQuestionRuleCategoryAutomationProperty> {
            java.lang.String category;
            java.lang.String condition;
            java.lang.String optionRefId;

            /**
             * Sets the value of {@link SingleSelectQuestionRuleCategoryAutomationProperty#getCategory}
             * @param category The category name, as defined in Rules. This parameter is required.
             *                 <em>Minimum</em> : 1
             *                 <p>
             *                 <em>Maximum</em> : 50
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder category(java.lang.String category) {
                this.category = category;
                return this;
            }

            /**
             * Sets the value of {@link SingleSelectQuestionRuleCategoryAutomationProperty#getCondition}
             * @param condition The condition to apply for the automation option. This parameter is required.
             *                  If the condition is PRESENT, then the option is applied when the contact data includes the category. Similarly, if the condition is NOT_PRESENT, then the option is applied when the contact data does not include the category.
             *                  <p>
             *                  <em>Allowed values</em> : <code>PRESENT</code> | <code>NOT_PRESENT</code>
             *                  <p>
             *                  <em>Maximum</em> : 50
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder condition(java.lang.String condition) {
                this.condition = condition;
                return this;
            }

            /**
             * Sets the value of {@link SingleSelectQuestionRuleCategoryAutomationProperty#getOptionRefId}
             * @param optionRefId The identifier of the answer option. An identifier must be unique within the question. This parameter is required.
             *                    <em>Length Constraints</em> : Minimum length of 1. Maximum length of 40.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder optionRefId(java.lang.String optionRefId) {
                this.optionRefId = optionRefId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SingleSelectQuestionRuleCategoryAutomationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SingleSelectQuestionRuleCategoryAutomationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SingleSelectQuestionRuleCategoryAutomationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SingleSelectQuestionRuleCategoryAutomationProperty {
            private final java.lang.String category;
            private final java.lang.String condition;
            private final java.lang.String optionRefId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.category = software.amazon.jsii.Kernel.get(this, "category", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.condition = software.amazon.jsii.Kernel.get(this, "condition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.optionRefId = software.amazon.jsii.Kernel.get(this, "optionRefId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.category = java.util.Objects.requireNonNull(builder.category, "category is required");
                this.condition = java.util.Objects.requireNonNull(builder.condition, "condition is required");
                this.optionRefId = java.util.Objects.requireNonNull(builder.optionRefId, "optionRefId is required");
            }

            @Override
            public final java.lang.String getCategory() {
                return this.category;
            }

            @Override
            public final java.lang.String getCondition() {
                return this.condition;
            }

            @Override
            public final java.lang.String getOptionRefId() {
                return this.optionRefId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("category", om.valueToTree(this.getCategory()));
                data.set("condition", om.valueToTree(this.getCondition()));
                data.set("optionRefId", om.valueToTree(this.getOptionRefId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnEvaluationForm.SingleSelectQuestionRuleCategoryAutomationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SingleSelectQuestionRuleCategoryAutomationProperty.Jsii$Proxy that = (SingleSelectQuestionRuleCategoryAutomationProperty.Jsii$Proxy) o;

                if (!category.equals(that.category)) return false;
                if (!condition.equals(that.condition)) return false;
                return this.optionRefId.equals(that.optionRefId);
            }

            @Override
            public final int hashCode() {
                int result = this.category.hashCode();
                result = 31 * result + (this.condition.hashCode());
                result = 31 * result + (this.optionRefId.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.connect.CfnEvaluationForm}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.connect.CfnEvaluationForm> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.connect.CfnEvaluationFormProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.connect.CfnEvaluationFormProps.Builder();
        }

        /**
         * The identifier of the Amazon Connect instance.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-instancearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-instancearn</a>
         * @param instanceArn The identifier of the Amazon Connect instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceArn(final java.lang.String instanceArn) {
            this.props.instanceArn(instanceArn);
            return this;
        }
        /**
         * The identifier of the Amazon Connect instance.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-instancearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-instancearn</a>
         * @param instanceArn The identifier of the Amazon Connect instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceArn(final software.amazon.awscdk.interfaces.connect.IInstanceRef instanceArn) {
            this.props.instanceArn(instanceArn);
            return this;
        }

        /**
         * Items that are part of the evaluation form.
         * <p>
         * The total number of sections and questions must not exceed 100 each. Questions must be contained in a section.
         * <p>
         * <em>Minimum size</em> : 1
         * <p>
         * <em>Maximum size</em> : 100
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-items">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-items</a>
         * @param items Items that are part of the evaluation form. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder items(final software.amazon.awscdk.IResolvable items) {
            this.props.items(items);
            return this;
        }
        /**
         * Items that are part of the evaluation form.
         * <p>
         * The total number of sections and questions must not exceed 100 each. Questions must be contained in a section.
         * <p>
         * <em>Minimum size</em> : 1
         * <p>
         * <em>Maximum size</em> : 100
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-items">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-items</a>
         * @param items Items that are part of the evaluation form. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder items(final java.util.List<? extends java.lang.Object> items) {
            this.props.items(items);
            return this;
        }

        /**
         * The status of the evaluation form.
         * <p>
         * <em>Allowed values</em> : <code>DRAFT</code> | <code>ACTIVE</code>
         * <p>
         * Default: - "DRAFT"
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-status</a>
         * @param status The status of the evaluation form. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder status(final java.lang.String status) {
            this.props.status(status);
            return this;
        }

        /**
         * A title of the evaluation form.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-title">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-title</a>
         * @param title A title of the evaluation form. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder title(final java.lang.String title) {
            this.props.title(title);
            return this;
        }

        /**
         * The automatic evaluation configuration of an evaluation form.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-autoevaluationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-autoevaluationconfiguration</a>
         * @param autoEvaluationConfiguration The automatic evaluation configuration of an evaluation form. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoEvaluationConfiguration(final software.amazon.awscdk.IResolvable autoEvaluationConfiguration) {
            this.props.autoEvaluationConfiguration(autoEvaluationConfiguration);
            return this;
        }
        /**
         * The automatic evaluation configuration of an evaluation form.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-autoevaluationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-autoevaluationconfiguration</a>
         * @param autoEvaluationConfiguration The automatic evaluation configuration of an evaluation form. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoEvaluationConfiguration(final software.amazon.awscdk.services.connect.CfnEvaluationForm.AutoEvaluationConfigurationProperty autoEvaluationConfiguration) {
            this.props.autoEvaluationConfiguration(autoEvaluationConfiguration);
            return this;
        }

        /**
         * The description of the evaluation form.
         * <p>
         * <em>Length Constraints</em> : Minimum length of 0. Maximum length of 1024.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-description</a>
         * @param description The description of the evaluation form. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-languageconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-languageconfiguration</a>
         * @param languageConfiguration This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder languageConfiguration(final software.amazon.awscdk.IResolvable languageConfiguration) {
            this.props.languageConfiguration(languageConfiguration);
            return this;
        }
        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-languageconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-languageconfiguration</a>
         * @param languageConfiguration This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder languageConfiguration(final software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormLanguageConfigurationProperty languageConfiguration) {
            this.props.languageConfiguration(languageConfiguration);
            return this;
        }

        /**
         * A scoring strategy of the evaluation form.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-scoringstrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-scoringstrategy</a>
         * @param scoringStrategy A scoring strategy of the evaluation form. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scoringStrategy(final software.amazon.awscdk.IResolvable scoringStrategy) {
            this.props.scoringStrategy(scoringStrategy);
            return this;
        }
        /**
         * A scoring strategy of the evaluation form.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-scoringstrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-scoringstrategy</a>
         * @param scoringStrategy A scoring strategy of the evaluation form. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scoringStrategy(final software.amazon.awscdk.services.connect.CfnEvaluationForm.ScoringStrategyProperty scoringStrategy) {
            this.props.scoringStrategy(scoringStrategy);
            return this;
        }

        /**
         * The tags used to organize, track, or control access for this resource.
         * <p>
         * For example, { "tags": {"key1":"value1", "key2":"value2"} }.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-tags</a>
         * @param tags The tags used to organize, track, or control access for this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-targetconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-targetconfiguration</a>
         * @param targetConfiguration This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetConfiguration(final software.amazon.awscdk.IResolvable targetConfiguration) {
            this.props.targetConfiguration(targetConfiguration);
            return this;
        }
        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-targetconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-evaluationform.html#cfn-connect-evaluationform-targetconfiguration</a>
         * @param targetConfiguration This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetConfiguration(final software.amazon.awscdk.services.connect.CfnEvaluationForm.EvaluationFormTargetConfigurationProperty targetConfiguration) {
            this.props.targetConfiguration(targetConfiguration);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.connect.CfnEvaluationForm}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.connect.CfnEvaluationForm build() {
            return new software.amazon.awscdk.services.connect.CfnEvaluationForm(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
