package software.amazon.awscdk.services.connect;

/**
 * Creates a security profile.
 * <p>
 * For information about security profiles, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/connect-security-profiles.html">Security Profiles</a> in the <em>Amazon Connect Administrator Guide</em> . For a mapping of the API name and user interface name of the security profile permissions, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-list.html">List of security profile permissions</a> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.connect.*;
 * CfnSecurityProfile cfnSecurityProfile = CfnSecurityProfile.Builder.create(this, "MyCfnSecurityProfile")
 *         .instanceArn("instanceArn")
 *         .securityProfileName("securityProfileName")
 *         // the properties below are optional
 *         .allowedAccessControlHierarchyGroupId("allowedAccessControlHierarchyGroupId")
 *         .allowedAccessControlTags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .applications(List.of(ApplicationProperty.builder()
 *                 .applicationPermissions(List.of("applicationPermissions"))
 *                 .namespace("namespace")
 *                 .build()))
 *         .description("description")
 *         .granularAccessControlConfiguration(GranularAccessControlConfigurationProperty.builder()
 *                 .dataTableAccessControlConfiguration(DataTableAccessControlConfigurationProperty.builder()
 *                         .primaryAttributeAccessControlConfiguration(PrimaryAttributeAccessControlConfigurationItemProperty.builder()
 *                                 .primaryAttributeValues(List.of(PrimaryAttributeValueProperty.builder()
 *                                         .accessType("accessType")
 *                                         .attributeName("attributeName")
 *                                         .values(List.of("values"))
 *                                         .build()))
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .hierarchyRestrictedResources(List.of("hierarchyRestrictedResources"))
 *         .permissions(List.of("permissions"))
 *         .tagRestrictedResources(List.of("tagRestrictedResources"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:17.699Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnSecurityProfile")
public class CfnSecurityProfile extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.connect.ISecurityProfileRef, software.amazon.awscdk.ITaggableV2 {

    protected CfnSecurityProfile(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnSecurityProfile(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.connect.CfnSecurityProfile.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::Connect::SecurityProfile</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnSecurityProfile(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.connect.CfnSecurityProfileProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * @param resource This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String arnForSecurityProfile(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.connect.ISecurityProfileRef resource) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.connect.CfnSecurityProfile.class, "arnForSecurityProfile", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(resource, "resource is required") });
    }

    /**
     * Checks whether the given object is a CfnSecurityProfile.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isCfnSecurityProfile(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.connect.CfnSecurityProfile.class, "isCfnSecurityProfile", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The AWS Region where this resource was last modified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLastModifiedRegion() {
        return software.amazon.jsii.Kernel.get(this, "attrLastModifiedRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The timestamp when this resource was last modified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrLastModifiedTime() {
        return software.amazon.jsii.Kernel.get(this, "attrLastModifiedTime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the security profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSecurityProfileArn() {
        return software.amazon.jsii.Kernel.get(this, "attrSecurityProfileArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a SecurityProfile resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.connect.SecurityProfileReference getSecurityProfileRef() {
        return software.amazon.jsii.Kernel.get(this, "securityProfileRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.connect.SecurityProfileReference.class));
    }

    /**
     * The identifier of the Amazon Connect instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getInstanceArn() {
        return software.amazon.jsii.Kernel.get(this, "instanceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of the Amazon Connect instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "instanceArn", java.util.Objects.requireNonNull(value, "instanceArn is required"));
    }

    /**
     * The name for the security profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSecurityProfileName() {
        return software.amazon.jsii.Kernel.get(this, "securityProfileName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name for the security profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecurityProfileName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "securityProfileName", java.util.Objects.requireNonNull(value, "securityProfileName is required"));
    }

    /**
     * The identifier of the hierarchy group that a security profile uses to restrict access to resources in Amazon Connect.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAllowedAccessControlHierarchyGroupId() {
        return software.amazon.jsii.Kernel.get(this, "allowedAccessControlHierarchyGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of the hierarchy group that a security profile uses to restrict access to resources in Amazon Connect.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAllowedAccessControlHierarchyGroupId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "allowedAccessControlHierarchyGroupId", value);
    }

    /**
     * The list of tags that a security profile uses to restrict access to resources in Amazon Connect.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.CfnTag}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAllowedAccessControlTags() {
        return software.amazon.jsii.Kernel.get(this, "allowedAccessControlTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The list of tags that a security profile uses to restrict access to resources in Amazon Connect.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAllowedAccessControlTags(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "allowedAccessControlTags", value);
    }

    /**
     * The list of tags that a security profile uses to restrict access to resources in Amazon Connect.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAllowedAccessControlTags(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.CfnTag)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.CfnTag; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "allowedAccessControlTags", value);
    }

    /**
     * A list of third-party applications that the security profile will give access to.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.connect.CfnSecurityProfile.ApplicationProperty}>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getApplications() {
        return software.amazon.jsii.Kernel.get(this, "applications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of third-party applications that the security profile will give access to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApplications(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "applications", value);
    }

    /**
     * A list of third-party applications that the security profile will give access to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApplications(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.connect.CfnSecurityProfile.ApplicationProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.connect.CfnSecurityProfile.ApplicationProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "applications", value);
    }

    /**
     * The description of the security profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the security profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.connect.CfnSecurityProfile.GranularAccessControlConfigurationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getGranularAccessControlConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "granularAccessControlConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGranularAccessControlConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "granularAccessControlConfiguration", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGranularAccessControlConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.connect.CfnSecurityProfile.GranularAccessControlConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "granularAccessControlConfiguration", value);
    }

    /**
     * The list of resources that a security profile applies hierarchy restrictions to in Amazon Connect.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getHierarchyRestrictedResources() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "hierarchyRestrictedResources", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The list of resources that a security profile applies hierarchy restrictions to in Amazon Connect.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHierarchyRestrictedResources(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "hierarchyRestrictedResources", value);
    }

    /**
     * Permissions assigned to the security profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPermissions() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "permissions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Permissions assigned to the security profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPermissions(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "permissions", value);
    }

    /**
     * The list of resources that a security profile applies tag restrictions to in Amazon Connect.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTagRestrictedResources() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "tagRestrictedResources", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The list of resources that a security profile applies tag restrictions to in Amazon Connect.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagRestrictedResources(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "tagRestrictedResources", value);
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     * <p>
     * A third-party application's metadata.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * ApplicationProperty applicationProperty = ApplicationProperty.builder()
     *         .applicationPermissions(List.of("applicationPermissions"))
     *         .namespace("namespace")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-securityprofile-application.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-securityprofile-application.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnSecurityProfile.ApplicationProperty")
    @software.amazon.jsii.Jsii.Proxy(ApplicationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ApplicationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The permissions that the agent is granted on the application.
         * <p>
         * Only the <code>ACCESS</code> permission is supported.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-securityprofile-application.html#cfn-connect-securityprofile-application-applicationpermissions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-securityprofile-application.html#cfn-connect-securityprofile-application-applicationpermissions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getApplicationPermissions();

        /**
         * Namespace of the application that you want to give access to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-securityprofile-application.html#cfn-connect-securityprofile-application-namespace">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-securityprofile-application.html#cfn-connect-securityprofile-application-namespace</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getNamespace();

        /**
         * @return a {@link Builder} of {@link ApplicationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ApplicationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ApplicationProperty> {
            java.util.List<java.lang.String> applicationPermissions;
            java.lang.String namespace;

            /**
             * Sets the value of {@link ApplicationProperty#getApplicationPermissions}
             * @param applicationPermissions The permissions that the agent is granted on the application. This parameter is required.
             *                               Only the <code>ACCESS</code> permission is supported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder applicationPermissions(java.util.List<java.lang.String> applicationPermissions) {
                this.applicationPermissions = applicationPermissions;
                return this;
            }

            /**
             * Sets the value of {@link ApplicationProperty#getNamespace}
             * @param namespace Namespace of the application that you want to give access to. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder namespace(java.lang.String namespace) {
                this.namespace = namespace;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ApplicationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ApplicationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ApplicationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplicationProperty {
            private final java.util.List<java.lang.String> applicationPermissions;
            private final java.lang.String namespace;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.applicationPermissions = software.amazon.jsii.Kernel.get(this, "applicationPermissions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.namespace = software.amazon.jsii.Kernel.get(this, "namespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.applicationPermissions = java.util.Objects.requireNonNull(builder.applicationPermissions, "applicationPermissions is required");
                this.namespace = java.util.Objects.requireNonNull(builder.namespace, "namespace is required");
            }

            @Override
            public final java.util.List<java.lang.String> getApplicationPermissions() {
                return this.applicationPermissions;
            }

            @Override
            public final java.lang.String getNamespace() {
                return this.namespace;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("applicationPermissions", om.valueToTree(this.getApplicationPermissions()));
                data.set("namespace", om.valueToTree(this.getNamespace()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnSecurityProfile.ApplicationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ApplicationProperty.Jsii$Proxy that = (ApplicationProperty.Jsii$Proxy) o;

                if (!applicationPermissions.equals(that.applicationPermissions)) return false;
                return this.namespace.equals(that.namespace);
            }

            @Override
            public final int hashCode() {
                int result = this.applicationPermissions.hashCode();
                result = 31 * result + (this.namespace.hashCode());
                return result;
            }
        }
    }
    /**
     * Defines the access control configuration for data tables.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * DataTableAccessControlConfigurationProperty dataTableAccessControlConfigurationProperty = DataTableAccessControlConfigurationProperty.builder()
     *         .primaryAttributeAccessControlConfiguration(PrimaryAttributeAccessControlConfigurationItemProperty.builder()
     *                 .primaryAttributeValues(List.of(PrimaryAttributeValueProperty.builder()
     *                         .accessType("accessType")
     *                         .attributeName("attributeName")
     *                         .values(List.of("values"))
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-securityprofile-datatableaccesscontrolconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-securityprofile-datatableaccesscontrolconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnSecurityProfile.DataTableAccessControlConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DataTableAccessControlConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataTableAccessControlConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Contains the configuration for record-based access control.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.connect.CfnSecurityProfile.PrimaryAttributeAccessControlConfigurationItemProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-securityprofile-datatableaccesscontrolconfiguration.html#cfn-connect-securityprofile-datatableaccesscontrolconfiguration-primaryattributeaccesscontrolconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-securityprofile-datatableaccesscontrolconfiguration.html#cfn-connect-securityprofile-datatableaccesscontrolconfiguration-primaryattributeaccesscontrolconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPrimaryAttributeAccessControlConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataTableAccessControlConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataTableAccessControlConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataTableAccessControlConfigurationProperty> {
            java.lang.Object primaryAttributeAccessControlConfiguration;

            /**
             * Sets the value of {@link DataTableAccessControlConfigurationProperty#getPrimaryAttributeAccessControlConfiguration}
             * @param primaryAttributeAccessControlConfiguration Contains the configuration for record-based access control.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder primaryAttributeAccessControlConfiguration(software.amazon.awscdk.IResolvable primaryAttributeAccessControlConfiguration) {
                this.primaryAttributeAccessControlConfiguration = primaryAttributeAccessControlConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DataTableAccessControlConfigurationProperty#getPrimaryAttributeAccessControlConfiguration}
             * @param primaryAttributeAccessControlConfiguration Contains the configuration for record-based access control.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder primaryAttributeAccessControlConfiguration(software.amazon.awscdk.services.connect.CfnSecurityProfile.PrimaryAttributeAccessControlConfigurationItemProperty primaryAttributeAccessControlConfiguration) {
                this.primaryAttributeAccessControlConfiguration = primaryAttributeAccessControlConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataTableAccessControlConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataTableAccessControlConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataTableAccessControlConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataTableAccessControlConfigurationProperty {
            private final java.lang.Object primaryAttributeAccessControlConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.primaryAttributeAccessControlConfiguration = software.amazon.jsii.Kernel.get(this, "primaryAttributeAccessControlConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.primaryAttributeAccessControlConfiguration = builder.primaryAttributeAccessControlConfiguration;
            }

            @Override
            public final java.lang.Object getPrimaryAttributeAccessControlConfiguration() {
                return this.primaryAttributeAccessControlConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPrimaryAttributeAccessControlConfiguration() != null) {
                    data.set("primaryAttributeAccessControlConfiguration", om.valueToTree(this.getPrimaryAttributeAccessControlConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnSecurityProfile.DataTableAccessControlConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataTableAccessControlConfigurationProperty.Jsii$Proxy that = (DataTableAccessControlConfigurationProperty.Jsii$Proxy) o;

                return this.primaryAttributeAccessControlConfiguration != null ? this.primaryAttributeAccessControlConfiguration.equals(that.primaryAttributeAccessControlConfiguration) : that.primaryAttributeAccessControlConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.primaryAttributeAccessControlConfiguration != null ? this.primaryAttributeAccessControlConfiguration.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * GranularAccessControlConfigurationProperty granularAccessControlConfigurationProperty = GranularAccessControlConfigurationProperty.builder()
     *         .dataTableAccessControlConfiguration(DataTableAccessControlConfigurationProperty.builder()
     *                 .primaryAttributeAccessControlConfiguration(PrimaryAttributeAccessControlConfigurationItemProperty.builder()
     *                         .primaryAttributeValues(List.of(PrimaryAttributeValueProperty.builder()
     *                                 .accessType("accessType")
     *                                 .attributeName("attributeName")
     *                                 .values(List.of("values"))
     *                                 .build()))
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-securityprofile-granularaccesscontrolconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-securityprofile-granularaccesscontrolconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnSecurityProfile.GranularAccessControlConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(GranularAccessControlConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GranularAccessControlConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Defines the access control configuration for data tables.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.connect.CfnSecurityProfile.DataTableAccessControlConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-securityprofile-granularaccesscontrolconfiguration.html#cfn-connect-securityprofile-granularaccesscontrolconfiguration-datatableaccesscontrolconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-securityprofile-granularaccesscontrolconfiguration.html#cfn-connect-securityprofile-granularaccesscontrolconfiguration-datatableaccesscontrolconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDataTableAccessControlConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GranularAccessControlConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GranularAccessControlConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GranularAccessControlConfigurationProperty> {
            java.lang.Object dataTableAccessControlConfiguration;

            /**
             * Sets the value of {@link GranularAccessControlConfigurationProperty#getDataTableAccessControlConfiguration}
             * @param dataTableAccessControlConfiguration Defines the access control configuration for data tables.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataTableAccessControlConfiguration(software.amazon.awscdk.IResolvable dataTableAccessControlConfiguration) {
                this.dataTableAccessControlConfiguration = dataTableAccessControlConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link GranularAccessControlConfigurationProperty#getDataTableAccessControlConfiguration}
             * @param dataTableAccessControlConfiguration Defines the access control configuration for data tables.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataTableAccessControlConfiguration(software.amazon.awscdk.services.connect.CfnSecurityProfile.DataTableAccessControlConfigurationProperty dataTableAccessControlConfiguration) {
                this.dataTableAccessControlConfiguration = dataTableAccessControlConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GranularAccessControlConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GranularAccessControlConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GranularAccessControlConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GranularAccessControlConfigurationProperty {
            private final java.lang.Object dataTableAccessControlConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataTableAccessControlConfiguration = software.amazon.jsii.Kernel.get(this, "dataTableAccessControlConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataTableAccessControlConfiguration = builder.dataTableAccessControlConfiguration;
            }

            @Override
            public final java.lang.Object getDataTableAccessControlConfiguration() {
                return this.dataTableAccessControlConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDataTableAccessControlConfiguration() != null) {
                    data.set("dataTableAccessControlConfiguration", om.valueToTree(this.getDataTableAccessControlConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnSecurityProfile.GranularAccessControlConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GranularAccessControlConfigurationProperty.Jsii$Proxy that = (GranularAccessControlConfigurationProperty.Jsii$Proxy) o;

                return this.dataTableAccessControlConfiguration != null ? this.dataTableAccessControlConfiguration.equals(that.dataTableAccessControlConfiguration) : that.dataTableAccessControlConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dataTableAccessControlConfiguration != null ? this.dataTableAccessControlConfiguration.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Contains the configuration for record-based access control.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * PrimaryAttributeAccessControlConfigurationItemProperty primaryAttributeAccessControlConfigurationItemProperty = PrimaryAttributeAccessControlConfigurationItemProperty.builder()
     *         .primaryAttributeValues(List.of(PrimaryAttributeValueProperty.builder()
     *                 .accessType("accessType")
     *                 .attributeName("attributeName")
     *                 .values(List.of("values"))
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-securityprofile-primaryattributeaccesscontrolconfigurationitem.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-securityprofile-primaryattributeaccesscontrolconfigurationitem.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnSecurityProfile.PrimaryAttributeAccessControlConfigurationItemProperty")
    @software.amazon.jsii.Jsii.Proxy(PrimaryAttributeAccessControlConfigurationItemProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PrimaryAttributeAccessControlConfigurationItemProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An array of PrimaryAttributeValue objects.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.connect.CfnSecurityProfile.PrimaryAttributeValueProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-securityprofile-primaryattributeaccesscontrolconfigurationitem.html#cfn-connect-securityprofile-primaryattributeaccesscontrolconfigurationitem-primaryattributevalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-securityprofile-primaryattributeaccesscontrolconfigurationitem.html#cfn-connect-securityprofile-primaryattributeaccesscontrolconfigurationitem-primaryattributevalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getPrimaryAttributeValues();

        /**
         * @return a {@link Builder} of {@link PrimaryAttributeAccessControlConfigurationItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PrimaryAttributeAccessControlConfigurationItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PrimaryAttributeAccessControlConfigurationItemProperty> {
            java.lang.Object primaryAttributeValues;

            /**
             * Sets the value of {@link PrimaryAttributeAccessControlConfigurationItemProperty#getPrimaryAttributeValues}
             * @param primaryAttributeValues An array of PrimaryAttributeValue objects. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder primaryAttributeValues(software.amazon.awscdk.IResolvable primaryAttributeValues) {
                this.primaryAttributeValues = primaryAttributeValues;
                return this;
            }

            /**
             * Sets the value of {@link PrimaryAttributeAccessControlConfigurationItemProperty#getPrimaryAttributeValues}
             * @param primaryAttributeValues An array of PrimaryAttributeValue objects. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder primaryAttributeValues(java.util.List<? extends java.lang.Object> primaryAttributeValues) {
                this.primaryAttributeValues = primaryAttributeValues;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PrimaryAttributeAccessControlConfigurationItemProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PrimaryAttributeAccessControlConfigurationItemProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PrimaryAttributeAccessControlConfigurationItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PrimaryAttributeAccessControlConfigurationItemProperty {
            private final java.lang.Object primaryAttributeValues;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.primaryAttributeValues = software.amazon.jsii.Kernel.get(this, "primaryAttributeValues", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.primaryAttributeValues = java.util.Objects.requireNonNull(builder.primaryAttributeValues, "primaryAttributeValues is required");
            }

            @Override
            public final java.lang.Object getPrimaryAttributeValues() {
                return this.primaryAttributeValues;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("primaryAttributeValues", om.valueToTree(this.getPrimaryAttributeValues()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnSecurityProfile.PrimaryAttributeAccessControlConfigurationItemProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PrimaryAttributeAccessControlConfigurationItemProperty.Jsii$Proxy that = (PrimaryAttributeAccessControlConfigurationItemProperty.Jsii$Proxy) o;

                return this.primaryAttributeValues.equals(that.primaryAttributeValues);
            }

            @Override
            public final int hashCode() {
                int result = this.primaryAttributeValues.hashCode();
                return result;
            }
        }
    }
    /**
     * An object defining the access control for a specific attribute and its values.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.connect.*;
     * PrimaryAttributeValueProperty primaryAttributeValueProperty = PrimaryAttributeValueProperty.builder()
     *         .accessType("accessType")
     *         .attributeName("attributeName")
     *         .values(List.of("values"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-securityprofile-primaryattributevalue.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-securityprofile-primaryattributevalue.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_connect.CfnSecurityProfile.PrimaryAttributeValueProperty")
    @software.amazon.jsii.Jsii.Proxy(PrimaryAttributeValueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PrimaryAttributeValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the type of access granted.
         * <p>
         * Currently, only "ALLOW" is supported
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-securityprofile-primaryattributevalue.html#cfn-connect-securityprofile-primaryattributevalue-accesstype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-securityprofile-primaryattributevalue.html#cfn-connect-securityprofile-primaryattributevalue-accesstype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAccessType();

        /**
         * The name of the primary attribute.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-securityprofile-primaryattributevalue.html#cfn-connect-securityprofile-primaryattributevalue-attributename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-securityprofile-primaryattributevalue.html#cfn-connect-securityprofile-primaryattributevalue-attributename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAttributeName();

        /**
         * An array of allowed primary values for the specified primary attribute.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-securityprofile-primaryattributevalue.html#cfn-connect-securityprofile-primaryattributevalue-values">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-connect-securityprofile-primaryattributevalue.html#cfn-connect-securityprofile-primaryattributevalue-values</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getValues();

        /**
         * @return a {@link Builder} of {@link PrimaryAttributeValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PrimaryAttributeValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PrimaryAttributeValueProperty> {
            java.lang.String accessType;
            java.lang.String attributeName;
            java.util.List<java.lang.String> values;

            /**
             * Sets the value of {@link PrimaryAttributeValueProperty#getAccessType}
             * @param accessType Specifies the type of access granted. This parameter is required.
             *                   Currently, only "ALLOW" is supported
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessType(java.lang.String accessType) {
                this.accessType = accessType;
                return this;
            }

            /**
             * Sets the value of {@link PrimaryAttributeValueProperty#getAttributeName}
             * @param attributeName The name of the primary attribute. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributeName(java.lang.String attributeName) {
                this.attributeName = attributeName;
                return this;
            }

            /**
             * Sets the value of {@link PrimaryAttributeValueProperty#getValues}
             * @param values An array of allowed primary values for the specified primary attribute. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PrimaryAttributeValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PrimaryAttributeValueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PrimaryAttributeValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PrimaryAttributeValueProperty {
            private final java.lang.String accessType;
            private final java.lang.String attributeName;
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accessType = software.amazon.jsii.Kernel.get(this, "accessType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.attributeName = software.amazon.jsii.Kernel.get(this, "attributeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accessType = java.util.Objects.requireNonNull(builder.accessType, "accessType is required");
                this.attributeName = java.util.Objects.requireNonNull(builder.attributeName, "attributeName is required");
                this.values = java.util.Objects.requireNonNull(builder.values, "values is required");
            }

            @Override
            public final java.lang.String getAccessType() {
                return this.accessType;
            }

            @Override
            public final java.lang.String getAttributeName() {
                return this.attributeName;
            }

            @Override
            public final java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("accessType", om.valueToTree(this.getAccessType()));
                data.set("attributeName", om.valueToTree(this.getAttributeName()));
                data.set("values", om.valueToTree(this.getValues()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_connect.CfnSecurityProfile.PrimaryAttributeValueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PrimaryAttributeValueProperty.Jsii$Proxy that = (PrimaryAttributeValueProperty.Jsii$Proxy) o;

                if (!accessType.equals(that.accessType)) return false;
                if (!attributeName.equals(that.attributeName)) return false;
                return this.values.equals(that.values);
            }

            @Override
            public final int hashCode() {
                int result = this.accessType.hashCode();
                result = 31 * result + (this.attributeName.hashCode());
                result = 31 * result + (this.values.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.connect.CfnSecurityProfile}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.connect.CfnSecurityProfile> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.connect.CfnSecurityProfileProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.connect.CfnSecurityProfileProps.Builder();
        }

        /**
         * The identifier of the Amazon Connect instance.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-instancearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-instancearn</a>
         * @param instanceArn The identifier of the Amazon Connect instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceArn(final java.lang.String instanceArn) {
            this.props.instanceArn(instanceArn);
            return this;
        }
        /**
         * The identifier of the Amazon Connect instance.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-instancearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-instancearn</a>
         * @param instanceArn The identifier of the Amazon Connect instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceArn(final software.amazon.awscdk.interfaces.connect.IInstanceRef instanceArn) {
            this.props.instanceArn(instanceArn);
            return this;
        }

        /**
         * The name for the security profile.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-securityprofilename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-securityprofilename</a>
         * @param securityProfileName The name for the security profile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityProfileName(final java.lang.String securityProfileName) {
            this.props.securityProfileName(securityProfileName);
            return this;
        }

        /**
         * The identifier of the hierarchy group that a security profile uses to restrict access to resources in Amazon Connect.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-allowedaccesscontrolhierarchygroupid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-allowedaccesscontrolhierarchygroupid</a>
         * @param allowedAccessControlHierarchyGroupId The identifier of the hierarchy group that a security profile uses to restrict access to resources in Amazon Connect. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedAccessControlHierarchyGroupId(final java.lang.String allowedAccessControlHierarchyGroupId) {
            this.props.allowedAccessControlHierarchyGroupId(allowedAccessControlHierarchyGroupId);
            return this;
        }

        /**
         * The list of tags that a security profile uses to restrict access to resources in Amazon Connect.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-allowedaccesscontroltags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-allowedaccesscontroltags</a>
         * @param allowedAccessControlTags The list of tags that a security profile uses to restrict access to resources in Amazon Connect. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedAccessControlTags(final software.amazon.awscdk.IResolvable allowedAccessControlTags) {
            this.props.allowedAccessControlTags(allowedAccessControlTags);
            return this;
        }
        /**
         * The list of tags that a security profile uses to restrict access to resources in Amazon Connect.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-allowedaccesscontroltags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-allowedaccesscontroltags</a>
         * @param allowedAccessControlTags The list of tags that a security profile uses to restrict access to resources in Amazon Connect. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedAccessControlTags(final java.util.List<? extends java.lang.Object> allowedAccessControlTags) {
            this.props.allowedAccessControlTags(allowedAccessControlTags);
            return this;
        }

        /**
         * A list of third-party applications that the security profile will give access to.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-applications">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-applications</a>
         * @param applications A list of third-party applications that the security profile will give access to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applications(final software.amazon.awscdk.IResolvable applications) {
            this.props.applications(applications);
            return this;
        }
        /**
         * A list of third-party applications that the security profile will give access to.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-applications">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-applications</a>
         * @param applications A list of third-party applications that the security profile will give access to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applications(final java.util.List<? extends java.lang.Object> applications) {
            this.props.applications(applications);
            return this;
        }

        /**
         * The description of the security profile.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-description</a>
         * @param description The description of the security profile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-granularaccesscontrolconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-granularaccesscontrolconfiguration</a>
         * @param granularAccessControlConfiguration This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder granularAccessControlConfiguration(final software.amazon.awscdk.IResolvable granularAccessControlConfiguration) {
            this.props.granularAccessControlConfiguration(granularAccessControlConfiguration);
            return this;
        }
        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-granularaccesscontrolconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-granularaccesscontrolconfiguration</a>
         * @param granularAccessControlConfiguration This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder granularAccessControlConfiguration(final software.amazon.awscdk.services.connect.CfnSecurityProfile.GranularAccessControlConfigurationProperty granularAccessControlConfiguration) {
            this.props.granularAccessControlConfiguration(granularAccessControlConfiguration);
            return this;
        }

        /**
         * The list of resources that a security profile applies hierarchy restrictions to in Amazon Connect.
         * <p>
         * Following are acceptable ResourceNames: <code>User</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-hierarchyrestrictedresources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-hierarchyrestrictedresources</a>
         * @param hierarchyRestrictedResources The list of resources that a security profile applies hierarchy restrictions to in Amazon Connect. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hierarchyRestrictedResources(final java.util.List<java.lang.String> hierarchyRestrictedResources) {
            this.props.hierarchyRestrictedResources(hierarchyRestrictedResources);
            return this;
        }

        /**
         * Permissions assigned to the security profile.
         * <p>
         * For a list of valid permissions, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-list.html">List of security profile permissions</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-permissions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-permissions</a>
         * @param permissions Permissions assigned to the security profile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissions(final java.util.List<java.lang.String> permissions) {
            this.props.permissions(permissions);
            return this;
        }

        /**
         * The list of resources that a security profile applies tag restrictions to in Amazon Connect.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-tagrestrictedresources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-tagrestrictedresources</a>
         * @param tagRestrictedResources The list of resources that a security profile applies tag restrictions to in Amazon Connect. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tagRestrictedResources(final java.util.List<java.lang.String> tagRestrictedResources) {
            this.props.tagRestrictedResources(tagRestrictedResources);
            return this;
        }

        /**
         * The tags used to organize, track, or control access for this resource.
         * <p>
         * For example, { "Tags": {"key1":"value1", "key2":"value2"} }.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-connect-securityprofile.html#cfn-connect-securityprofile-tags</a>
         * @param tags The tags used to organize, track, or control access for this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.connect.CfnSecurityProfile}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.connect.CfnSecurityProfile build() {
            return new software.amazon.awscdk.services.connect.CfnSecurityProfile(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
