package software.amazon.awscdk.services.datasync;

/**
 * The <code>AWS::DataSync::LocationObjectStorage</code> resource specifies an endpoint for a self-managed object storage bucket.
 * <p>
 * For more information about self-managed object storage locations, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-object-location.html">Creating a Location for Object Storage</a> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.datasync.*;
 * CfnLocationObjectStorage cfnLocationObjectStorage = CfnLocationObjectStorage.Builder.create(this, "MyCfnLocationObjectStorage")
 *         .accessKey("accessKey")
 *         .agentArns(List.of("agentArns"))
 *         .bucketName("bucketName")
 *         .cmkSecretConfig(CmkSecretConfigProperty.builder()
 *                 .kmsKeyArn("kmsKeyArn")
 *                 .secretArn("secretArn")
 *                 .build())
 *         .customSecretConfig(CustomSecretConfigProperty.builder()
 *                 .secretAccessRoleArn("secretAccessRoleArn")
 *                 .secretArn("secretArn")
 *                 .build())
 *         .secretKey("secretKey")
 *         .serverCertificate("serverCertificate")
 *         .serverHostname("serverHostname")
 *         .serverPort(123)
 *         .serverProtocol("serverProtocol")
 *         .subdirectory("subdirectory")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:17.992Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datasync.CfnLocationObjectStorage")
public class CfnLocationObjectStorage extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.datasync.ILocationObjectStorageRef, software.amazon.awscdk.ITaggable {

    protected CfnLocationObjectStorage(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnLocationObjectStorage(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.datasync.CfnLocationObjectStorage.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::DataSync::LocationObjectStorage</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnLocationObjectStorage(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.datasync.CfnLocationObjectStorageProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new <code>AWS::DataSync::LocationObjectStorage</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnLocationObjectStorage(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Checks whether the given object is a CfnLocationObjectStorage.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isCfnLocationObjectStorage(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.datasync.CfnLocationObjectStorage.class, "isCfnLocationObjectStorage", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Specifies the ARN for the DataSync-managed AWS Secrets Manager secret that that is used to access a specific storage location.
     * <p>
     * This property is generated by DataSync and is read-only. DataSync encrypts this secret with the KMS key that you specify for <code>KmsKeyArn</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCmkSecretConfigSecretArn() {
        return software.amazon.jsii.Kernel.get(this, "attrCmkSecretConfigSecretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the specified object storage location.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLocationArn() {
        return software.amazon.jsii.Kernel.get(this, "attrLocationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The URI of the specified object storage location.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLocationUri() {
        return software.amazon.jsii.Kernel.get(this, "attrLocationUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies configuration information for a DataSync-managed secret, such as an authentication token or set of credentials that DataSync uses to access a specific transfer location.
     * <p>
     * DataSync uses the default AWS-managed KMS key to encrypt this secret in AWS Secrets Manager.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrManagedSecretConfig() {
        return software.amazon.jsii.Kernel.get(this, "attrManagedSecretConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a LocationObjectStorage resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.datasync.LocationObjectStorageReference getLocationObjectStorageRef() {
        return software.amazon.jsii.Kernel.get(this, "locationObjectStorageRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.datasync.LocationObjectStorageReference.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * Specifies the access key (for example, a user name) if credentials are required to authenticate with the object storage server.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAccessKey() {
        return software.amazon.jsii.Kernel.get(this, "accessKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the access key (for example, a user name) if credentials are required to authenticate with the object storage server.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccessKey(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "accessKey", value);
    }

    /**
     * (Optional) Specifies the Amazon Resource Names (ARNs) of the DataSync agents that can connect with your object storage system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAgentArns() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "agentArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * (Optional) Specifies the Amazon Resource Names (ARNs) of the DataSync agents that can connect with your object storage system.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAgentArns(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "agentArns", value);
    }

    /**
     * Specifies the name of the object storage bucket involved in the transfer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getBucketName() {
        return software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the name of the object storage bucket involved in the transfer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBucketName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "bucketName", value);
    }

    /**
     * Specifies configuration information for a DataSync-managed secret, which includes the <code>SecretKey</code> that DataSync uses to access a specific object storage location, with a customer-managed AWS KMS key .
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.datasync.CfnLocationObjectStorage.CmkSecretConfigProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCmkSecretConfig() {
        return software.amazon.jsii.Kernel.get(this, "cmkSecretConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies configuration information for a DataSync-managed secret, which includes the <code>SecretKey</code> that DataSync uses to access a specific object storage location, with a customer-managed AWS KMS key .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCmkSecretConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "cmkSecretConfig", value);
    }

    /**
     * Specifies configuration information for a DataSync-managed secret, which includes the <code>SecretKey</code> that DataSync uses to access a specific object storage location, with a customer-managed AWS KMS key .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCmkSecretConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.datasync.CfnLocationObjectStorage.CmkSecretConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "cmkSecretConfig", value);
    }

    /**
     * Specifies configuration information for a customer-managed Secrets Manager secret where the secret key for a specific object storage location is stored in plain text.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.datasync.CfnLocationObjectStorage.CustomSecretConfigProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCustomSecretConfig() {
        return software.amazon.jsii.Kernel.get(this, "customSecretConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies configuration information for a customer-managed Secrets Manager secret where the secret key for a specific object storage location is stored in plain text.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomSecretConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "customSecretConfig", value);
    }

    /**
     * Specifies configuration information for a customer-managed Secrets Manager secret where the secret key for a specific object storage location is stored in plain text.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomSecretConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.datasync.CfnLocationObjectStorage.CustomSecretConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "customSecretConfig", value);
    }

    /**
     * Specifies the secret key (for example, a password) if credentials are required to authenticate with the object storage server.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSecretKey() {
        return software.amazon.jsii.Kernel.get(this, "secretKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the secret key (for example, a password) if credentials are required to authenticate with the object storage server.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecretKey(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "secretKey", value);
    }

    /**
     * Specifies a certificate chain for DataSync to authenticate with your object storage system if the system uses a private or self-signed certificate authority (CA).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getServerCertificate() {
        return software.amazon.jsii.Kernel.get(this, "serverCertificate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies a certificate chain for DataSync to authenticate with your object storage system if the system uses a private or self-signed certificate authority (CA).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServerCertificate(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "serverCertificate", value);
    }

    /**
     * Specifies the domain name or IP address (IPv4 or IPv6) of the object storage server that your DataSync agent connects to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getServerHostname() {
        return software.amazon.jsii.Kernel.get(this, "serverHostname", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the domain name or IP address (IPv4 or IPv6) of the object storage server that your DataSync agent connects to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServerHostname(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "serverHostname", value);
    }

    /**
     * Specifies the port that your object storage server accepts inbound network traffic on (for example, port 443).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getServerPort() {
        return software.amazon.jsii.Kernel.get(this, "serverPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Specifies the port that your object storage server accepts inbound network traffic on (for example, port 443).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServerPort(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "serverPort", value);
    }

    /**
     * Specifies the protocol that your object storage server uses to communicate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getServerProtocol() {
        return software.amazon.jsii.Kernel.get(this, "serverProtocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the protocol that your object storage server uses to communicate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServerProtocol(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "serverProtocol", value);
    }

    /**
     * Specifies the object prefix for your object storage server.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSubdirectory() {
        return software.amazon.jsii.Kernel.get(this, "subdirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the object prefix for your object storage server.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSubdirectory(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "subdirectory", value);
    }

    /**
     * Specifies the key-value pair that represents a tag that you want to add to the resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Specifies the key-value pair that represents a tag that you want to add to the resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * Specifies configuration information for a DataSync-managed secret, such as an authentication token or secret key that DataSync uses to access a specific storage location, with a customer-managed AWS KMS key .
     * <p>
     * <blockquote>
     * <p>
     * You can use either <code>CmkSecretConfig</code> or <code>CustomSecretConfig</code> to provide credentials for a <code>CreateLocation</code> request. Do not provide both parameters for the same request.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datasync.*;
     * CmkSecretConfigProperty cmkSecretConfigProperty = CmkSecretConfigProperty.builder()
     *         .kmsKeyArn("kmsKeyArn")
     *         .secretArn("secretArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-locationobjectstorage-cmksecretconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-locationobjectstorage-cmksecretconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datasync.CfnLocationObjectStorage.CmkSecretConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(CmkSecretConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CmkSecretConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the ARN for the customer-managed AWS KMS key that DataSync uses to encrypt the DataSync-managed secret stored for <code>SecretArn</code> .
         * <p>
         * DataSync provides this key to AWS Secrets Manager .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-locationobjectstorage-cmksecretconfig.html#cfn-datasync-locationobjectstorage-cmksecretconfig-kmskeyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-locationobjectstorage-cmksecretconfig.html#cfn-datasync-locationobjectstorage-cmksecretconfig-kmskeyarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyArn() {
            return null;
        }

        /**
         * Specifies the ARN for the DataSync-managed AWS Secrets Manager secret that that is used to access a specific storage location.
         * <p>
         * This property is generated by DataSync and is read-only. DataSync encrypts this secret with the KMS key that you specify for <code>KmsKeyArn</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-locationobjectstorage-cmksecretconfig.html#cfn-datasync-locationobjectstorage-cmksecretconfig-secretarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-locationobjectstorage-cmksecretconfig.html#cfn-datasync-locationobjectstorage-cmksecretconfig-secretarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CmkSecretConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CmkSecretConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CmkSecretConfigProperty> {
            java.lang.String kmsKeyArn;
            java.lang.String secretArn;

            /**
             * Sets the value of {@link CmkSecretConfigProperty#getKmsKeyArn}
             * @param kmsKeyArn Specifies the ARN for the customer-managed AWS KMS key that DataSync uses to encrypt the DataSync-managed secret stored for <code>SecretArn</code> .
             *                  DataSync provides this key to AWS Secrets Manager .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyArn(java.lang.String kmsKeyArn) {
                this.kmsKeyArn = kmsKeyArn;
                return this;
            }

            /**
             * Sets the value of {@link CmkSecretConfigProperty#getSecretArn}
             * @param secretArn Specifies the ARN for the DataSync-managed AWS Secrets Manager secret that that is used to access a specific storage location.
             *                  This property is generated by DataSync and is read-only. DataSync encrypts this secret with the KMS key that you specify for <code>KmsKeyArn</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretArn(java.lang.String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CmkSecretConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CmkSecretConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CmkSecretConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CmkSecretConfigProperty {
            private final java.lang.String kmsKeyArn;
            private final java.lang.String secretArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.kmsKeyArn = software.amazon.jsii.Kernel.get(this, "kmsKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretArn = software.amazon.jsii.Kernel.get(this, "secretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.kmsKeyArn = builder.kmsKeyArn;
                this.secretArn = builder.secretArn;
            }

            @Override
            public final java.lang.String getKmsKeyArn() {
                return this.kmsKeyArn;
            }

            @Override
            public final java.lang.String getSecretArn() {
                return this.secretArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getKmsKeyArn() != null) {
                    data.set("kmsKeyArn", om.valueToTree(this.getKmsKeyArn()));
                }
                if (this.getSecretArn() != null) {
                    data.set("secretArn", om.valueToTree(this.getSecretArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datasync.CfnLocationObjectStorage.CmkSecretConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CmkSecretConfigProperty.Jsii$Proxy that = (CmkSecretConfigProperty.Jsii$Proxy) o;

                if (this.kmsKeyArn != null ? !this.kmsKeyArn.equals(that.kmsKeyArn) : that.kmsKeyArn != null) return false;
                return this.secretArn != null ? this.secretArn.equals(that.secretArn) : that.secretArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.kmsKeyArn != null ? this.kmsKeyArn.hashCode() : 0;
                result = 31 * result + (this.secretArn != null ? this.secretArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies configuration information for a customer-managed Secrets Manager secret where a storage location authentication token or secret key is stored in plain text.
     * <p>
     * This configuration includes the secret ARN, and the ARN for an IAM role that provides access to the secret.
     * <p>
     * <blockquote>
     * <p>
     * You can use either <code>CmkSecretConfig</code> or <code>CustomSecretConfig</code> to provide credentials for a <code>CreateLocation</code> request. Do not provide both parameters for the same request.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datasync.*;
     * CustomSecretConfigProperty customSecretConfigProperty = CustomSecretConfigProperty.builder()
     *         .secretAccessRoleArn("secretAccessRoleArn")
     *         .secretArn("secretArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-locationobjectstorage-customsecretconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-locationobjectstorage-customsecretconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datasync.CfnLocationObjectStorage.CustomSecretConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomSecretConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomSecretConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the ARN for the AWS Identity and Access Management role that DataSync uses to access the secret specified for <code>SecretArn</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-locationobjectstorage-customsecretconfig.html#cfn-datasync-locationobjectstorage-customsecretconfig-secretaccessrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-locationobjectstorage-customsecretconfig.html#cfn-datasync-locationobjectstorage-customsecretconfig-secretaccessrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSecretAccessRoleArn();

        /**
         * Specifies the ARN for an AWS Secrets Manager secret.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-locationobjectstorage-customsecretconfig.html#cfn-datasync-locationobjectstorage-customsecretconfig-secretarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-locationobjectstorage-customsecretconfig.html#cfn-datasync-locationobjectstorage-customsecretconfig-secretarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSecretArn();

        /**
         * @return a {@link Builder} of {@link CustomSecretConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomSecretConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomSecretConfigProperty> {
            java.lang.String secretAccessRoleArn;
            java.lang.String secretArn;

            /**
             * Sets the value of {@link CustomSecretConfigProperty#getSecretAccessRoleArn}
             * @param secretAccessRoleArn Specifies the ARN for the AWS Identity and Access Management role that DataSync uses to access the secret specified for <code>SecretArn</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretAccessRoleArn(java.lang.String secretAccessRoleArn) {
                this.secretAccessRoleArn = secretAccessRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link CustomSecretConfigProperty#getSecretArn}
             * @param secretArn Specifies the ARN for an AWS Secrets Manager secret. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretArn(java.lang.String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomSecretConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomSecretConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomSecretConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomSecretConfigProperty {
            private final java.lang.String secretAccessRoleArn;
            private final java.lang.String secretArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.secretAccessRoleArn = software.amazon.jsii.Kernel.get(this, "secretAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretArn = software.amazon.jsii.Kernel.get(this, "secretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.secretAccessRoleArn = java.util.Objects.requireNonNull(builder.secretAccessRoleArn, "secretAccessRoleArn is required");
                this.secretArn = java.util.Objects.requireNonNull(builder.secretArn, "secretArn is required");
            }

            @Override
            public final java.lang.String getSecretAccessRoleArn() {
                return this.secretAccessRoleArn;
            }

            @Override
            public final java.lang.String getSecretArn() {
                return this.secretArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("secretAccessRoleArn", om.valueToTree(this.getSecretAccessRoleArn()));
                data.set("secretArn", om.valueToTree(this.getSecretArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datasync.CfnLocationObjectStorage.CustomSecretConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomSecretConfigProperty.Jsii$Proxy that = (CustomSecretConfigProperty.Jsii$Proxy) o;

                if (!secretAccessRoleArn.equals(that.secretAccessRoleArn)) return false;
                return this.secretArn.equals(that.secretArn);
            }

            @Override
            public final int hashCode() {
                int result = this.secretAccessRoleArn.hashCode();
                result = 31 * result + (this.secretArn.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies configuration information for a DataSync-managed secret, such as an authentication token or set of credentials that DataSync uses to access a specific transfer location.
     * <p>
     * DataSync uses the default AWS -managed KMS key to encrypt this secret in AWS Secrets Manager .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datasync.*;
     * ManagedSecretConfigProperty managedSecretConfigProperty = ManagedSecretConfigProperty.builder()
     *         .secretArn("secretArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-locationobjectstorage-managedsecretconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-locationobjectstorage-managedsecretconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datasync.CfnLocationObjectStorage.ManagedSecretConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ManagedSecretConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ManagedSecretConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the ARN for an AWS Secrets Manager secret.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-locationobjectstorage-managedsecretconfig.html#cfn-datasync-locationobjectstorage-managedsecretconfig-secretarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-locationobjectstorage-managedsecretconfig.html#cfn-datasync-locationobjectstorage-managedsecretconfig-secretarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSecretArn();

        /**
         * @return a {@link Builder} of {@link ManagedSecretConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ManagedSecretConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ManagedSecretConfigProperty> {
            java.lang.String secretArn;

            /**
             * Sets the value of {@link ManagedSecretConfigProperty#getSecretArn}
             * @param secretArn Specifies the ARN for an AWS Secrets Manager secret. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretArn(java.lang.String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ManagedSecretConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ManagedSecretConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ManagedSecretConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ManagedSecretConfigProperty {
            private final java.lang.String secretArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.secretArn = software.amazon.jsii.Kernel.get(this, "secretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.secretArn = java.util.Objects.requireNonNull(builder.secretArn, "secretArn is required");
            }

            @Override
            public final java.lang.String getSecretArn() {
                return this.secretArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("secretArn", om.valueToTree(this.getSecretArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datasync.CfnLocationObjectStorage.ManagedSecretConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ManagedSecretConfigProperty.Jsii$Proxy that = (ManagedSecretConfigProperty.Jsii$Proxy) o;

                return this.secretArn.equals(that.secretArn);
            }

            @Override
            public final int hashCode() {
                int result = this.secretArn.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.datasync.CfnLocationObjectStorage}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.datasync.CfnLocationObjectStorage> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.datasync.CfnLocationObjectStorageProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Specifies the access key (for example, a user name) if credentials are required to authenticate with the object storage server.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html#cfn-datasync-locationobjectstorage-accesskey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html#cfn-datasync-locationobjectstorage-accesskey</a>
         * @param accessKey Specifies the access key (for example, a user name) if credentials are required to authenticate with the object storage server. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessKey(final java.lang.String accessKey) {
            this.props().accessKey(accessKey);
            return this;
        }

        /**
         * (Optional) Specifies the Amazon Resource Names (ARNs) of the DataSync agents that can connect with your object storage system.
         * <p>
         * If you are setting up an agentless cross-cloud transfer, you do not need to specify a value for this parameter.
         * <p>
         * <blockquote>
         * <p>
         * Make sure you configure this parameter correctly when you first create your storage location. You cannot add or remove agents from a storage location after you create it.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html#cfn-datasync-locationobjectstorage-agentarns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html#cfn-datasync-locationobjectstorage-agentarns</a>
         * @param agentArns (Optional) Specifies the Amazon Resource Names (ARNs) of the DataSync agents that can connect with your object storage system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder agentArns(final java.util.List<java.lang.String> agentArns) {
            this.props().agentArns(agentArns);
            return this;
        }

        /**
         * Specifies the name of the object storage bucket involved in the transfer.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html#cfn-datasync-locationobjectstorage-bucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html#cfn-datasync-locationobjectstorage-bucketname</a>
         * @param bucketName Specifies the name of the object storage bucket involved in the transfer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketName(final java.lang.String bucketName) {
            this.props().bucketName(bucketName);
            return this;
        }

        /**
         * Specifies configuration information for a DataSync-managed secret, which includes the <code>SecretKey</code> that DataSync uses to access a specific object storage location, with a customer-managed AWS KMS key .
         * <p>
         * When you include this paramater as part of a <code>CreateLocationObjectStorage</code> request, you provide only the KMS key ARN. DataSync uses this KMS key together with the value you specify for the <code>SecretKey</code> parameter to create a DataSync-managed secret to store the location access credentials.
         * <p>
         * Make sure the DataSync has permission to access the KMS key that you specify.
         * <p>
         * <blockquote>
         * <p>
         * You can use either <code>CmkSecretConfig</code> (with <code>SecretKey</code> ) or <code>CustomSecretConfig</code> (without <code>SecretKey</code> ) to provide credentials for a <code>CreateLocationObjectStorage</code> request. Do not provide both parameters for the same request.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html#cfn-datasync-locationobjectstorage-cmksecretconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html#cfn-datasync-locationobjectstorage-cmksecretconfig</a>
         * @param cmkSecretConfig Specifies configuration information for a DataSync-managed secret, which includes the <code>SecretKey</code> that DataSync uses to access a specific object storage location, with a customer-managed AWS KMS key . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cmkSecretConfig(final software.amazon.awscdk.IResolvable cmkSecretConfig) {
            this.props().cmkSecretConfig(cmkSecretConfig);
            return this;
        }
        /**
         * Specifies configuration information for a DataSync-managed secret, which includes the <code>SecretKey</code> that DataSync uses to access a specific object storage location, with a customer-managed AWS KMS key .
         * <p>
         * When you include this paramater as part of a <code>CreateLocationObjectStorage</code> request, you provide only the KMS key ARN. DataSync uses this KMS key together with the value you specify for the <code>SecretKey</code> parameter to create a DataSync-managed secret to store the location access credentials.
         * <p>
         * Make sure the DataSync has permission to access the KMS key that you specify.
         * <p>
         * <blockquote>
         * <p>
         * You can use either <code>CmkSecretConfig</code> (with <code>SecretKey</code> ) or <code>CustomSecretConfig</code> (without <code>SecretKey</code> ) to provide credentials for a <code>CreateLocationObjectStorage</code> request. Do not provide both parameters for the same request.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html#cfn-datasync-locationobjectstorage-cmksecretconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html#cfn-datasync-locationobjectstorage-cmksecretconfig</a>
         * @param cmkSecretConfig Specifies configuration information for a DataSync-managed secret, which includes the <code>SecretKey</code> that DataSync uses to access a specific object storage location, with a customer-managed AWS KMS key . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cmkSecretConfig(final software.amazon.awscdk.services.datasync.CfnLocationObjectStorage.CmkSecretConfigProperty cmkSecretConfig) {
            this.props().cmkSecretConfig(cmkSecretConfig);
            return this;
        }

        /**
         * Specifies configuration information for a customer-managed Secrets Manager secret where the secret key for a specific object storage location is stored in plain text.
         * <p>
         * This configuration includes the secret ARN, and the ARN for an IAM role that provides access to the secret.
         * <p>
         * <blockquote>
         * <p>
         * You can use either <code>CmkSecretConfig</code> (with <code>SecretKey</code> ) or <code>CustomSecretConfig</code> (without <code>SecretKey</code> ) to provide credentials for a <code>CreateLocationObjectStorage</code> request. Do not provide both parameters for the same request.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html#cfn-datasync-locationobjectstorage-customsecretconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html#cfn-datasync-locationobjectstorage-customsecretconfig</a>
         * @param customSecretConfig Specifies configuration information for a customer-managed Secrets Manager secret where the secret key for a specific object storage location is stored in plain text. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customSecretConfig(final software.amazon.awscdk.IResolvable customSecretConfig) {
            this.props().customSecretConfig(customSecretConfig);
            return this;
        }
        /**
         * Specifies configuration information for a customer-managed Secrets Manager secret where the secret key for a specific object storage location is stored in plain text.
         * <p>
         * This configuration includes the secret ARN, and the ARN for an IAM role that provides access to the secret.
         * <p>
         * <blockquote>
         * <p>
         * You can use either <code>CmkSecretConfig</code> (with <code>SecretKey</code> ) or <code>CustomSecretConfig</code> (without <code>SecretKey</code> ) to provide credentials for a <code>CreateLocationObjectStorage</code> request. Do not provide both parameters for the same request.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html#cfn-datasync-locationobjectstorage-customsecretconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html#cfn-datasync-locationobjectstorage-customsecretconfig</a>
         * @param customSecretConfig Specifies configuration information for a customer-managed Secrets Manager secret where the secret key for a specific object storage location is stored in plain text. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customSecretConfig(final software.amazon.awscdk.services.datasync.CfnLocationObjectStorage.CustomSecretConfigProperty customSecretConfig) {
            this.props().customSecretConfig(customSecretConfig);
            return this;
        }

        /**
         * Specifies the secret key (for example, a password) if credentials are required to authenticate with the object storage server.
         * <p>
         * <blockquote>
         * <p>
         * If you provide a secret using <code>SecretKey</code> , but do not provide secret configuration details using <code>CmkSecretConfig</code> or <code>CustomSecretConfig</code> , then DataSync stores the token using your AWS account's Secrets Manager secret.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html#cfn-datasync-locationobjectstorage-secretkey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html#cfn-datasync-locationobjectstorage-secretkey</a>
         * @param secretKey Specifies the secret key (for example, a password) if credentials are required to authenticate with the object storage server. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secretKey(final java.lang.String secretKey) {
            this.props().secretKey(secretKey);
            return this;
        }

        /**
         * Specifies a certificate chain for DataSync to authenticate with your object storage system if the system uses a private or self-signed certificate authority (CA).
         * <p>
         * You must specify a single <code>.pem</code> file with a full certificate chain (for example, <code>file:///home/user/.ssh/object_storage_certificates.pem</code> ).
         * <p>
         * The certificate chain might include:
         * <p>
         * <ul>
         * <li>The object storage system's certificate</li>
         * <li>All intermediate certificates (if there are any)</li>
         * <li>The root certificate of the signing CA</li>
         * </ul>
         * <p>
         * You can concatenate your certificates into a <code>.pem</code> file (which can be up to 32768 bytes before base64 encoding). The following example <code>cat</code> command creates an <code>object_storage_certificates.pem</code> file that includes three certificates:
         * <p>
         * <code>cat object_server_certificate.pem intermediate_certificate.pem ca_root_certificate.pem &gt; object_storage_certificates.pem</code>
         * <p>
         * To use this parameter, configure <code>ServerProtocol</code> to <code>HTTPS</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html#cfn-datasync-locationobjectstorage-servercertificate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html#cfn-datasync-locationobjectstorage-servercertificate</a>
         * @param serverCertificate Specifies a certificate chain for DataSync to authenticate with your object storage system if the system uses a private or self-signed certificate authority (CA). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverCertificate(final java.lang.String serverCertificate) {
            this.props().serverCertificate(serverCertificate);
            return this;
        }

        /**
         * Specifies the domain name or IP address (IPv4 or IPv6) of the object storage server that your DataSync agent connects to.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html#cfn-datasync-locationobjectstorage-serverhostname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html#cfn-datasync-locationobjectstorage-serverhostname</a>
         * @param serverHostname Specifies the domain name or IP address (IPv4 or IPv6) of the object storage server that your DataSync agent connects to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverHostname(final java.lang.String serverHostname) {
            this.props().serverHostname(serverHostname);
            return this;
        }

        /**
         * Specifies the port that your object storage server accepts inbound network traffic on (for example, port 443).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html#cfn-datasync-locationobjectstorage-serverport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html#cfn-datasync-locationobjectstorage-serverport</a>
         * @param serverPort Specifies the port that your object storage server accepts inbound network traffic on (for example, port 443). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverPort(final java.lang.Number serverPort) {
            this.props().serverPort(serverPort);
            return this;
        }

        /**
         * Specifies the protocol that your object storage server uses to communicate.
         * <p>
         * If not specified, the default value is <code>HTTPS</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html#cfn-datasync-locationobjectstorage-serverprotocol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html#cfn-datasync-locationobjectstorage-serverprotocol</a>
         * @param serverProtocol Specifies the protocol that your object storage server uses to communicate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverProtocol(final java.lang.String serverProtocol) {
            this.props().serverProtocol(serverProtocol);
            return this;
        }

        /**
         * Specifies the object prefix for your object storage server.
         * <p>
         * If this is a source location, DataSync only copies objects with this prefix. If this is a destination location, DataSync writes all objects with this prefix.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html#cfn-datasync-locationobjectstorage-subdirectory">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html#cfn-datasync-locationobjectstorage-subdirectory</a>
         * @param subdirectory Specifies the object prefix for your object storage server. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subdirectory(final java.lang.String subdirectory) {
            this.props().subdirectory(subdirectory);
            return this;
        }

        /**
         * Specifies the key-value pair that represents a tag that you want to add to the resource.
         * <p>
         * Tags can help you manage, filter, and search for your resources. We recommend creating a name tag for your location.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html#cfn-datasync-locationobjectstorage-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-locationobjectstorage.html#cfn-datasync-locationobjectstorage-tags</a>
         * @param tags Specifies the key-value pair that represents a tag that you want to add to the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.datasync.CfnLocationObjectStorage}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.datasync.CfnLocationObjectStorage build() {
            return new software.amazon.awscdk.services.datasync.CfnLocationObjectStorage(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.datasync.CfnLocationObjectStorageProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.datasync.CfnLocationObjectStorageProps.Builder();
            }
            return this.props;
        }
    }
}
