package software.amazon.awscdk.services.datasync;

/**
 * Properties for defining a <code>CfnTask</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.datasync.*;
 * CfnTaskProps cfnTaskProps = CfnTaskProps.builder()
 *         .destinationLocationArn("destinationLocationArn")
 *         .sourceLocationArn("sourceLocationArn")
 *         // the properties below are optional
 *         .cloudWatchLogGroupArn("cloudWatchLogGroupArn")
 *         .excludes(List.of(FilterRuleProperty.builder()
 *                 .filterType("filterType")
 *                 .value("value")
 *                 .build()))
 *         .includes(List.of(FilterRuleProperty.builder()
 *                 .filterType("filterType")
 *                 .value("value")
 *                 .build()))
 *         .manifestConfig(ManifestConfigProperty.builder()
 *                 .source(SourceProperty.builder()
 *                         .s3(ManifestConfigSourceS3Property.builder()
 *                                 .bucketAccessRoleArn("bucketAccessRoleArn")
 *                                 .manifestObjectPath("manifestObjectPath")
 *                                 .manifestObjectVersionId("manifestObjectVersionId")
 *                                 .s3BucketArn("s3BucketArn")
 *                                 .build())
 *                         .build())
 *                 // the properties below are optional
 *                 .action("action")
 *                 .format("format")
 *                 .build())
 *         .name("name")
 *         .options(OptionsProperty.builder()
 *                 .atime("atime")
 *                 .bytesPerSecond(123)
 *                 .gid("gid")
 *                 .logLevel("logLevel")
 *                 .mtime("mtime")
 *                 .objectTags("objectTags")
 *                 .overwriteMode("overwriteMode")
 *                 .posixPermissions("posixPermissions")
 *                 .preserveDeletedFiles("preserveDeletedFiles")
 *                 .preserveDevices("preserveDevices")
 *                 .securityDescriptorCopyFlags("securityDescriptorCopyFlags")
 *                 .taskQueueing("taskQueueing")
 *                 .transferMode("transferMode")
 *                 .uid("uid")
 *                 .verifyMode("verifyMode")
 *                 .build())
 *         .schedule(TaskScheduleProperty.builder()
 *                 .scheduleExpression("scheduleExpression")
 *                 .status("status")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .taskMode("taskMode")
 *         .taskReportConfig(TaskReportConfigProperty.builder()
 *                 .destination(DestinationProperty.builder()
 *                         .s3(S3Property.builder()
 *                                 .bucketAccessRoleArn("bucketAccessRoleArn")
 *                                 .s3BucketArn("s3BucketArn")
 *                                 .subdirectory("subdirectory")
 *                                 .build())
 *                         .build())
 *                 .outputType("outputType")
 *                 // the properties below are optional
 *                 .objectVersionIds("objectVersionIds")
 *                 .overrides(OverridesProperty.builder()
 *                         .deleted(DeletedProperty.builder()
 *                                 .reportLevel("reportLevel")
 *                                 .build())
 *                         .skipped(SkippedProperty.builder()
 *                                 .reportLevel("reportLevel")
 *                                 .build())
 *                         .transferred(TransferredProperty.builder()
 *                                 .reportLevel("reportLevel")
 *                                 .build())
 *                         .verified(VerifiedProperty.builder()
 *                                 .reportLevel("reportLevel")
 *                                 .build())
 *                         .build())
 *                 .reportLevel("reportLevel")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:18.031Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datasync.CfnTaskProps")
@software.amazon.jsii.Jsii.Proxy(CfnTaskProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnTaskProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) of an AWS storage resource's location.
     * <p>
     * Returns union: either {@link java.lang.String} or {@link software.amazon.awscdk.interfaces.datasync.ILocationEFSRef} or {@link software.amazon.awscdk.interfaces.datasync.ILocationS3Ref}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-destinationlocationarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-destinationlocationarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getDestinationLocationArn();

    /**
     * Specifies the ARN of your transfer's source location.
     * <p>
     * Returns union: either {@link java.lang.String} or {@link software.amazon.awscdk.interfaces.datasync.ILocationNFSRef} or {@link software.amazon.awscdk.interfaces.datasync.ILocationS3Ref}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-sourcelocationarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-sourcelocationarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getSourceLocationArn();

    /**
     * Specifies the Amazon Resource Name (ARN) of an Amazon CloudWatch log group for monitoring your task.
     * <p>
     * For Enhanced mode tasks, you don't need to specify anything. DataSync automatically sends logs to a CloudWatch log group named <code>/aws/datasync</code> .
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/configure-logging.html">Monitoring data transfers with CloudWatch Logs</a> .
     * <p>
     * Returns union: either {@link java.lang.String} or {@link software.amazon.awscdk.interfaces.logs.ILogGroupRef}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-cloudwatchloggrouparn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-cloudwatchloggrouparn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCloudWatchLogGroupArn() {
        return null;
    }

    /**
     * Specifies exclude filters that define the files, objects, and folders in your source location that you don't want DataSync to transfer.
     * <p>
     * For more information and examples, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Specifying what DataSync transfers by using filters</a> .
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.datasync.CfnTask.FilterRuleProperty}>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-excludes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-excludes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getExcludes() {
        return null;
    }

    /**
     * Specifies include filters that define the files, objects, and folders in your source location that you want DataSync to transfer.
     * <p>
     * For more information and examples, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Specifying what DataSync transfers by using filters</a> .
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.datasync.CfnTask.FilterRuleProperty}>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-includes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-includes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getIncludes() {
        return null;
    }

    /**
     * The configuration of the manifest that lists the files or objects that you want DataSync to transfer.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html">Specifying what DataSync transfers by using a manifest</a> .
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.datasync.CfnTask.ManifestConfigProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-manifestconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-manifestconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getManifestConfig() {
        return null;
    }

    /**
     * Specifies the name of your task.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * Specifies your task's settings, such as preserving file metadata, verifying data integrity, among other options.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.datasync.CfnTask.OptionsProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-options">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-options</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOptions() {
        return null;
    }

    /**
     * Specifies a schedule for when you want your task to run.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html">Scheduling your task</a> .
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.datasync.CfnTask.TaskScheduleProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-schedule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-schedule</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSchedule() {
        return null;
    }

    /**
     * Specifies the tags that you want to apply to your task.
     * <p>
     * <em>Tags</em> are key-value pairs that help you manage, filter, and search for your DataSync resources.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The task mode that you're using.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/choosing-task-mode.html">Choosing a task mode for your data transfer</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-taskmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-taskmode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTaskMode() {
        return null;
    }

    /**
     * The configuration of your task report, which provides detailed information about your DataSync transfer.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html">Monitoring your DataSync transfers with task reports</a> .
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.datasync.CfnTask.TaskReportConfigProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-taskreportconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-taskreportconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTaskReportConfig() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnTaskProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTaskProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnTaskProps> {
        java.lang.Object destinationLocationArn;
        java.lang.Object sourceLocationArn;
        java.lang.Object cloudWatchLogGroupArn;
        java.lang.Object excludes;
        java.lang.Object includes;
        java.lang.Object manifestConfig;
        java.lang.String name;
        java.lang.Object options;
        java.lang.Object schedule;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String taskMode;
        java.lang.Object taskReportConfig;

        /**
         * Sets the value of {@link CfnTaskProps#getDestinationLocationArn}
         * @param destinationLocationArn The Amazon Resource Name (ARN) of an AWS storage resource's location. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationLocationArn(java.lang.String destinationLocationArn) {
            this.destinationLocationArn = destinationLocationArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskProps#getDestinationLocationArn}
         * @param destinationLocationArn The Amazon Resource Name (ARN) of an AWS storage resource's location. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationLocationArn(software.amazon.awscdk.interfaces.datasync.ILocationEFSRef destinationLocationArn) {
            this.destinationLocationArn = destinationLocationArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskProps#getDestinationLocationArn}
         * @param destinationLocationArn The Amazon Resource Name (ARN) of an AWS storage resource's location. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationLocationArn(software.amazon.awscdk.interfaces.datasync.ILocationS3Ref destinationLocationArn) {
            this.destinationLocationArn = destinationLocationArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskProps#getSourceLocationArn}
         * @param sourceLocationArn Specifies the ARN of your transfer's source location. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceLocationArn(java.lang.String sourceLocationArn) {
            this.sourceLocationArn = sourceLocationArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskProps#getSourceLocationArn}
         * @param sourceLocationArn Specifies the ARN of your transfer's source location. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceLocationArn(software.amazon.awscdk.interfaces.datasync.ILocationNFSRef sourceLocationArn) {
            this.sourceLocationArn = sourceLocationArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskProps#getSourceLocationArn}
         * @param sourceLocationArn Specifies the ARN of your transfer's source location. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceLocationArn(software.amazon.awscdk.interfaces.datasync.ILocationS3Ref sourceLocationArn) {
            this.sourceLocationArn = sourceLocationArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskProps#getCloudWatchLogGroupArn}
         * @param cloudWatchLogGroupArn Specifies the Amazon Resource Name (ARN) of an Amazon CloudWatch log group for monitoring your task.
         *                              For Enhanced mode tasks, you don't need to specify anything. DataSync automatically sends logs to a CloudWatch log group named <code>/aws/datasync</code> .
         *                              <p>
         *                              For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/configure-logging.html">Monitoring data transfers with CloudWatch Logs</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudWatchLogGroupArn(java.lang.String cloudWatchLogGroupArn) {
            this.cloudWatchLogGroupArn = cloudWatchLogGroupArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskProps#getCloudWatchLogGroupArn}
         * @param cloudWatchLogGroupArn Specifies the Amazon Resource Name (ARN) of an Amazon CloudWatch log group for monitoring your task.
         *                              For Enhanced mode tasks, you don't need to specify anything. DataSync automatically sends logs to a CloudWatch log group named <code>/aws/datasync</code> .
         *                              <p>
         *                              For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/configure-logging.html">Monitoring data transfers with CloudWatch Logs</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudWatchLogGroupArn(software.amazon.awscdk.interfaces.logs.ILogGroupRef cloudWatchLogGroupArn) {
            this.cloudWatchLogGroupArn = cloudWatchLogGroupArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskProps#getExcludes}
         * @param excludes Specifies exclude filters that define the files, objects, and folders in your source location that you don't want DataSync to transfer.
         *                 For more information and examples, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Specifying what DataSync transfers by using filters</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludes(software.amazon.awscdk.IResolvable excludes) {
            this.excludes = excludes;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskProps#getExcludes}
         * @param excludes Specifies exclude filters that define the files, objects, and folders in your source location that you don't want DataSync to transfer.
         *                 For more information and examples, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Specifying what DataSync transfers by using filters</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludes(java.util.List<? extends java.lang.Object> excludes) {
            this.excludes = excludes;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskProps#getIncludes}
         * @param includes Specifies include filters that define the files, objects, and folders in your source location that you want DataSync to transfer.
         *                 For more information and examples, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Specifying what DataSync transfers by using filters</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includes(software.amazon.awscdk.IResolvable includes) {
            this.includes = includes;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskProps#getIncludes}
         * @param includes Specifies include filters that define the files, objects, and folders in your source location that you want DataSync to transfer.
         *                 For more information and examples, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Specifying what DataSync transfers by using filters</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includes(java.util.List<? extends java.lang.Object> includes) {
            this.includes = includes;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskProps#getManifestConfig}
         * @param manifestConfig The configuration of the manifest that lists the files or objects that you want DataSync to transfer.
         *                       For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html">Specifying what DataSync transfers by using a manifest</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder manifestConfig(software.amazon.awscdk.IResolvable manifestConfig) {
            this.manifestConfig = manifestConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskProps#getManifestConfig}
         * @param manifestConfig The configuration of the manifest that lists the files or objects that you want DataSync to transfer.
         *                       For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html">Specifying what DataSync transfers by using a manifest</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder manifestConfig(software.amazon.awscdk.services.datasync.CfnTask.ManifestConfigProperty manifestConfig) {
            this.manifestConfig = manifestConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskProps#getName}
         * @param name Specifies the name of your task.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskProps#getOptions}
         * @param options Specifies your task's settings, such as preserving file metadata, verifying data integrity, among other options.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder options(software.amazon.awscdk.IResolvable options) {
            this.options = options;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskProps#getOptions}
         * @param options Specifies your task's settings, such as preserving file metadata, verifying data integrity, among other options.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder options(software.amazon.awscdk.services.datasync.CfnTask.OptionsProperty options) {
            this.options = options;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskProps#getSchedule}
         * @param schedule Specifies a schedule for when you want your task to run.
         *                 For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html">Scheduling your task</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(software.amazon.awscdk.IResolvable schedule) {
            this.schedule = schedule;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskProps#getSchedule}
         * @param schedule Specifies a schedule for when you want your task to run.
         *                 For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html">Scheduling your task</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(software.amazon.awscdk.services.datasync.CfnTask.TaskScheduleProperty schedule) {
            this.schedule = schedule;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskProps#getTags}
         * @param tags Specifies the tags that you want to apply to your task.
         *             <em>Tags</em> are key-value pairs that help you manage, filter, and search for your DataSync resources.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskProps#getTaskMode}
         * @param taskMode The task mode that you're using.
         *                 For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/choosing-task-mode.html">Choosing a task mode for your data transfer</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskMode(java.lang.String taskMode) {
            this.taskMode = taskMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskProps#getTaskReportConfig}
         * @param taskReportConfig The configuration of your task report, which provides detailed information about your DataSync transfer.
         *                         For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html">Monitoring your DataSync transfers with task reports</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskReportConfig(software.amazon.awscdk.IResolvable taskReportConfig) {
            this.taskReportConfig = taskReportConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskProps#getTaskReportConfig}
         * @param taskReportConfig The configuration of your task report, which provides detailed information about your DataSync transfer.
         *                         For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html">Monitoring your DataSync transfers with task reports</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskReportConfig(software.amazon.awscdk.services.datasync.CfnTask.TaskReportConfigProperty taskReportConfig) {
            this.taskReportConfig = taskReportConfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTaskProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnTaskProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnTaskProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTaskProps {
        private final java.lang.Object destinationLocationArn;
        private final java.lang.Object sourceLocationArn;
        private final java.lang.Object cloudWatchLogGroupArn;
        private final java.lang.Object excludes;
        private final java.lang.Object includes;
        private final java.lang.Object manifestConfig;
        private final java.lang.String name;
        private final java.lang.Object options;
        private final java.lang.Object schedule;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String taskMode;
        private final java.lang.Object taskReportConfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.destinationLocationArn = software.amazon.jsii.Kernel.get(this, "destinationLocationArn", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.sourceLocationArn = software.amazon.jsii.Kernel.get(this, "sourceLocationArn", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.cloudWatchLogGroupArn = software.amazon.jsii.Kernel.get(this, "cloudWatchLogGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.excludes = software.amazon.jsii.Kernel.get(this, "excludes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.includes = software.amazon.jsii.Kernel.get(this, "includes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.manifestConfig = software.amazon.jsii.Kernel.get(this, "manifestConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.options = software.amazon.jsii.Kernel.get(this, "options", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.schedule = software.amazon.jsii.Kernel.get(this, "schedule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.taskMode = software.amazon.jsii.Kernel.get(this, "taskMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.taskReportConfig = software.amazon.jsii.Kernel.get(this, "taskReportConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.destinationLocationArn = java.util.Objects.requireNonNull(builder.destinationLocationArn, "destinationLocationArn is required");
            this.sourceLocationArn = java.util.Objects.requireNonNull(builder.sourceLocationArn, "sourceLocationArn is required");
            this.cloudWatchLogGroupArn = builder.cloudWatchLogGroupArn;
            this.excludes = builder.excludes;
            this.includes = builder.includes;
            this.manifestConfig = builder.manifestConfig;
            this.name = builder.name;
            this.options = builder.options;
            this.schedule = builder.schedule;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.taskMode = builder.taskMode;
            this.taskReportConfig = builder.taskReportConfig;
        }

        @Override
        public final java.lang.Object getDestinationLocationArn() {
            return this.destinationLocationArn;
        }

        @Override
        public final java.lang.Object getSourceLocationArn() {
            return this.sourceLocationArn;
        }

        @Override
        public final java.lang.Object getCloudWatchLogGroupArn() {
            return this.cloudWatchLogGroupArn;
        }

        @Override
        public final java.lang.Object getExcludes() {
            return this.excludes;
        }

        @Override
        public final java.lang.Object getIncludes() {
            return this.includes;
        }

        @Override
        public final java.lang.Object getManifestConfig() {
            return this.manifestConfig;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getOptions() {
            return this.options;
        }

        @Override
        public final java.lang.Object getSchedule() {
            return this.schedule;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getTaskMode() {
            return this.taskMode;
        }

        @Override
        public final java.lang.Object getTaskReportConfig() {
            return this.taskReportConfig;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("destinationLocationArn", om.valueToTree(this.getDestinationLocationArn()));
            data.set("sourceLocationArn", om.valueToTree(this.getSourceLocationArn()));
            if (this.getCloudWatchLogGroupArn() != null) {
                data.set("cloudWatchLogGroupArn", om.valueToTree(this.getCloudWatchLogGroupArn()));
            }
            if (this.getExcludes() != null) {
                data.set("excludes", om.valueToTree(this.getExcludes()));
            }
            if (this.getIncludes() != null) {
                data.set("includes", om.valueToTree(this.getIncludes()));
            }
            if (this.getManifestConfig() != null) {
                data.set("manifestConfig", om.valueToTree(this.getManifestConfig()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getOptions() != null) {
                data.set("options", om.valueToTree(this.getOptions()));
            }
            if (this.getSchedule() != null) {
                data.set("schedule", om.valueToTree(this.getSchedule()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTaskMode() != null) {
                data.set("taskMode", om.valueToTree(this.getTaskMode()));
            }
            if (this.getTaskReportConfig() != null) {
                data.set("taskReportConfig", om.valueToTree(this.getTaskReportConfig()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datasync.CfnTaskProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTaskProps.Jsii$Proxy that = (CfnTaskProps.Jsii$Proxy) o;

            if (!destinationLocationArn.equals(that.destinationLocationArn)) return false;
            if (!sourceLocationArn.equals(that.sourceLocationArn)) return false;
            if (this.cloudWatchLogGroupArn != null ? !this.cloudWatchLogGroupArn.equals(that.cloudWatchLogGroupArn) : that.cloudWatchLogGroupArn != null) return false;
            if (this.excludes != null ? !this.excludes.equals(that.excludes) : that.excludes != null) return false;
            if (this.includes != null ? !this.includes.equals(that.includes) : that.includes != null) return false;
            if (this.manifestConfig != null ? !this.manifestConfig.equals(that.manifestConfig) : that.manifestConfig != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.options != null ? !this.options.equals(that.options) : that.options != null) return false;
            if (this.schedule != null ? !this.schedule.equals(that.schedule) : that.schedule != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.taskMode != null ? !this.taskMode.equals(that.taskMode) : that.taskMode != null) return false;
            return this.taskReportConfig != null ? this.taskReportConfig.equals(that.taskReportConfig) : that.taskReportConfig == null;
        }

        @Override
        public final int hashCode() {
            int result = this.destinationLocationArn.hashCode();
            result = 31 * result + (this.sourceLocationArn.hashCode());
            result = 31 * result + (this.cloudWatchLogGroupArn != null ? this.cloudWatchLogGroupArn.hashCode() : 0);
            result = 31 * result + (this.excludes != null ? this.excludes.hashCode() : 0);
            result = 31 * result + (this.includes != null ? this.includes.hashCode() : 0);
            result = 31 * result + (this.manifestConfig != null ? this.manifestConfig.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
            result = 31 * result + (this.schedule != null ? this.schedule.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.taskMode != null ? this.taskMode.hashCode() : 0);
            result = 31 * result + (this.taskReportConfig != null ? this.taskReportConfig.hashCode() : 0);
            return result;
        }
    }
}
