package software.amazon.awscdk.services.docdb;

/**
 * Properties that describe an existing cluster instance.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.docdb.*;
 * import software.amazon.awscdk.services.ec2.*;
 * SecurityGroup securityGroup;
 * DatabaseClusterAttributes databaseClusterAttributes = DatabaseClusterAttributes.builder()
 *         .clusterIdentifier("clusterIdentifier")
 *         // the properties below are optional
 *         .clusterEndpointAddress("clusterEndpointAddress")
 *         .instanceEndpointAddresses(List.of("instanceEndpointAddresses"))
 *         .instanceIdentifiers(List.of("instanceIdentifiers"))
 *         .port(123)
 *         .readerEndpointAddress("readerEndpointAddress")
 *         .securityGroup(securityGroup)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:18.465Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_docdb.DatabaseClusterAttributes")
@software.amazon.jsii.Jsii.Proxy(DatabaseClusterAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DatabaseClusterAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * Identifier for the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getClusterIdentifier();

    /**
     * Cluster endpoint address.
     * <p>
     * Default: - no cluster endpoint address
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getClusterEndpointAddress() {
        return null;
    }

    /**
     * Endpoint addresses of individual instances.
     * <p>
     * Default: - no instance endpoint addresses
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInstanceEndpointAddresses() {
        return null;
    }

    /**
     * Identifier for the instances.
     * <p>
     * Default: - no instance identifiers
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInstanceIdentifiers() {
        return null;
    }

    /**
     * The database port.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return null;
    }

    /**
     * Reader endpoint address.
     * <p>
     * Default: - no reader endpoint address
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getReaderEndpointAddress() {
        return null;
    }

    /**
     * The security group of the database cluster.
     * <p>
     * Default: - no security groups
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DatabaseClusterAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DatabaseClusterAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DatabaseClusterAttributes> {
        java.lang.String clusterIdentifier;
        java.lang.String clusterEndpointAddress;
        java.util.List<java.lang.String> instanceEndpointAddresses;
        java.util.List<java.lang.String> instanceIdentifiers;
        java.lang.Number port;
        java.lang.String readerEndpointAddress;
        software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;

        /**
         * Sets the value of {@link DatabaseClusterAttributes#getClusterIdentifier}
         * @param clusterIdentifier Identifier for the cluster. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterIdentifier(java.lang.String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterAttributes#getClusterEndpointAddress}
         * @param clusterEndpointAddress Cluster endpoint address.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterEndpointAddress(java.lang.String clusterEndpointAddress) {
            this.clusterEndpointAddress = clusterEndpointAddress;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterAttributes#getInstanceEndpointAddresses}
         * @param instanceEndpointAddresses Endpoint addresses of individual instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceEndpointAddresses(java.util.List<java.lang.String> instanceEndpointAddresses) {
            this.instanceEndpointAddresses = instanceEndpointAddresses;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterAttributes#getInstanceIdentifiers}
         * @param instanceIdentifiers Identifier for the instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceIdentifiers(java.util.List<java.lang.String> instanceIdentifiers) {
            this.instanceIdentifiers = instanceIdentifiers;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterAttributes#getPort}
         * @param port The database port.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterAttributes#getReaderEndpointAddress}
         * @param readerEndpointAddress Reader endpoint address.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readerEndpointAddress(java.lang.String readerEndpointAddress) {
            this.readerEndpointAddress = readerEndpointAddress;
            return this;
        }

        /**
         * Sets the value of {@link DatabaseClusterAttributes#getSecurityGroup}
         * @param securityGroup The security group of the database cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroup(software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DatabaseClusterAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DatabaseClusterAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DatabaseClusterAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatabaseClusterAttributes {
        private final java.lang.String clusterIdentifier;
        private final java.lang.String clusterEndpointAddress;
        private final java.util.List<java.lang.String> instanceEndpointAddresses;
        private final java.util.List<java.lang.String> instanceIdentifiers;
        private final java.lang.Number port;
        private final java.lang.String readerEndpointAddress;
        private final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.clusterIdentifier = software.amazon.jsii.Kernel.get(this, "clusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clusterEndpointAddress = software.amazon.jsii.Kernel.get(this, "clusterEndpointAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceEndpointAddresses = software.amazon.jsii.Kernel.get(this, "instanceEndpointAddresses", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.instanceIdentifiers = software.amazon.jsii.Kernel.get(this, "instanceIdentifiers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.readerEndpointAddress = software.amazon.jsii.Kernel.get(this, "readerEndpointAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.securityGroup = software.amazon.jsii.Kernel.get(this, "securityGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.clusterIdentifier = java.util.Objects.requireNonNull(builder.clusterIdentifier, "clusterIdentifier is required");
            this.clusterEndpointAddress = builder.clusterEndpointAddress;
            this.instanceEndpointAddresses = builder.instanceEndpointAddresses;
            this.instanceIdentifiers = builder.instanceIdentifiers;
            this.port = builder.port;
            this.readerEndpointAddress = builder.readerEndpointAddress;
            this.securityGroup = builder.securityGroup;
        }

        @Override
        public final java.lang.String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        @Override
        public final java.lang.String getClusterEndpointAddress() {
            return this.clusterEndpointAddress;
        }

        @Override
        public final java.util.List<java.lang.String> getInstanceEndpointAddresses() {
            return this.instanceEndpointAddresses;
        }

        @Override
        public final java.util.List<java.lang.String> getInstanceIdentifiers() {
            return this.instanceIdentifiers;
        }

        @Override
        public final java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public final java.lang.String getReaderEndpointAddress() {
            return this.readerEndpointAddress;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
            return this.securityGroup;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("clusterIdentifier", om.valueToTree(this.getClusterIdentifier()));
            if (this.getClusterEndpointAddress() != null) {
                data.set("clusterEndpointAddress", om.valueToTree(this.getClusterEndpointAddress()));
            }
            if (this.getInstanceEndpointAddresses() != null) {
                data.set("instanceEndpointAddresses", om.valueToTree(this.getInstanceEndpointAddresses()));
            }
            if (this.getInstanceIdentifiers() != null) {
                data.set("instanceIdentifiers", om.valueToTree(this.getInstanceIdentifiers()));
            }
            if (this.getPort() != null) {
                data.set("port", om.valueToTree(this.getPort()));
            }
            if (this.getReaderEndpointAddress() != null) {
                data.set("readerEndpointAddress", om.valueToTree(this.getReaderEndpointAddress()));
            }
            if (this.getSecurityGroup() != null) {
                data.set("securityGroup", om.valueToTree(this.getSecurityGroup()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_docdb.DatabaseClusterAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DatabaseClusterAttributes.Jsii$Proxy that = (DatabaseClusterAttributes.Jsii$Proxy) o;

            if (!clusterIdentifier.equals(that.clusterIdentifier)) return false;
            if (this.clusterEndpointAddress != null ? !this.clusterEndpointAddress.equals(that.clusterEndpointAddress) : that.clusterEndpointAddress != null) return false;
            if (this.instanceEndpointAddresses != null ? !this.instanceEndpointAddresses.equals(that.instanceEndpointAddresses) : that.instanceEndpointAddresses != null) return false;
            if (this.instanceIdentifiers != null ? !this.instanceIdentifiers.equals(that.instanceIdentifiers) : that.instanceIdentifiers != null) return false;
            if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
            if (this.readerEndpointAddress != null ? !this.readerEndpointAddress.equals(that.readerEndpointAddress) : that.readerEndpointAddress != null) return false;
            return this.securityGroup != null ? this.securityGroup.equals(that.securityGroup) : that.securityGroup == null;
        }

        @Override
        public final int hashCode() {
            int result = this.clusterIdentifier.hashCode();
            result = 31 * result + (this.clusterEndpointAddress != null ? this.clusterEndpointAddress.hashCode() : 0);
            result = 31 * result + (this.instanceEndpointAddresses != null ? this.instanceEndpointAddresses.hashCode() : 0);
            result = 31 * result + (this.instanceIdentifiers != null ? this.instanceIdentifiers.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + (this.readerEndpointAddress != null ? this.readerEndpointAddress.hashCode() : 0);
            result = 31 * result + (this.securityGroup != null ? this.securityGroup.hashCode() : 0);
            return result;
        }
    }
}
