package software.amazon.awscdk.services.dynamodb;

/**
 * Properties used to configure a global secondary index.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * TableV2 table = TableV2.Builder.create(this, "Table")
 *         .partitionKey(Attribute.builder().name("pk").type(AttributeType.STRING).build())
 *         .globalSecondaryIndexes(List.of(GlobalSecondaryIndexPropsV2.builder()
 *                 .indexName("gsi1")
 *                 .partitionKey(Attribute.builder().name("pk").type(AttributeType.STRING).build())
 *                 .build()))
 *         .build();
 * table.addGlobalSecondaryIndex(GlobalSecondaryIndexPropsV2.builder()
 *         .indexName("gsi2")
 *         .partitionKey(Attribute.builder().name("pk").type(AttributeType.STRING).build())
 *         .build());
 * // Add a GSI with compound keys
 * table.addGlobalSecondaryIndex(GlobalSecondaryIndexPropsV2.builder()
 *         .indexName("compound-gsi2")
 *         .partitionKeys(List.of(Attribute.builder().name("compound_pk1").type(AttributeType.STRING).build(), Attribute.builder().name("compound_pk2").type(AttributeType.NUMBER).build()))
 *         .sortKey(Attribute.builder().name("sk").type(AttributeType.STRING).build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:18.582Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.GlobalSecondaryIndexPropsV2")
@software.amazon.jsii.Jsii.Proxy(GlobalSecondaryIndexPropsV2.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface GlobalSecondaryIndexPropsV2 extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.dynamodb.SecondaryIndexProps {

    /**
     * The maximum read request units.
     * <p>
     * Note: This can only be configured if the primary table billing is PAY_PER_REQUEST.
     * <p>
     * Default: - inherited from the primary table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxReadRequestUnits() {
        return null;
    }

    /**
     * The maximum write request units.
     * <p>
     * Note: This can only be configured if the primary table billing is PAY_PER_REQUEST.
     * <p>
     * Default: - inherited from the primary table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxWriteRequestUnits() {
        return null;
    }

    /**
     * Partition key attribute definition.
     * <p>
     * If a single field forms the partition key, you can use this field.  Use the
     * <code>partitionKeys</code> field if the partition key is a compound key (consists of
     * multiple fields).
     * <p>
     * Default: - exactly one of `partitionKey` and `partitionKeys` must be specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dynamodb.Attribute getPartitionKey() {
        return null;
    }

    /**
     * Compound partition key.
     * <p>
     * If a single field forms the partition key, you can use either
     * <code>partitionKey</code> or <code>partitionKeys</code> to specify the partition key. Exactly
     * one of these must be specified.
     * <p>
     * You must use <code>partitionKeys</code> field if the partition key is a compound key
     * (consists of multiple fields).
     * <p>
     * NOTE: although the name of this field makes it sound like it creates
     * multiple keys, it does not. It defines a single key that consists of
     * of multiple fields.
     * <p>
     * The order of fields is not important.
     * <p>
     * Default: - exactly one of `partitionKey` and `partitionKeys` must be specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.dynamodb.Attribute> getPartitionKeys() {
        return null;
    }

    /**
     * The read capacity.
     * <p>
     * Note: This can only be configured if the primary table billing is provisioned.
     * <p>
     * Default: - inherited from the primary table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dynamodb.Capacity getReadCapacity() {
        return null;
    }

    /**
     * Sort key attribute definition.
     * <p>
     * If a single field forms the sort key, you can use this field.  Use the
     * <code>sortKeys</code> field if the sort key is a compound key (consists of multiple
     * fields).
     * <p>
     * Default: - no sort key
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dynamodb.Attribute getSortKey() {
        return null;
    }

    /**
     * Compound sort key.
     * <p>
     * If a single field forms the sort key, you can use either
     * <code>sortKey</code> or <code>sortKeys</code> to specify the sort key. At most one of these
     * may be specified.
     * <p>
     * You must use <code>sortKeys</code> field if the sort key is a compound key
     * (consists of multiple fields).
     * <p>
     * NOTE: although the name of this field makes it sound like it creates
     * multiple keys, it does not. It defines a single key that consists of
     * of multiple fields at the same time.
     * <p>
     * NOTE: The order of fields is important!
     * <p>
     * Default: - no sort key
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.dynamodb.Attribute> getSortKeys() {
        return null;
    }

    /**
     * The warm throughput configuration for the global secondary index.
     * <p>
     * Default: - no warm throughput is configured
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dynamodb.WarmThroughput getWarmThroughput() {
        return null;
    }

    /**
     * The write capacity.
     * <p>
     * Note: This can only be configured if the primary table billing is provisioned.
     * <p>
     * Default: - inherited from the primary table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dynamodb.Capacity getWriteCapacity() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link GlobalSecondaryIndexPropsV2}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GlobalSecondaryIndexPropsV2}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<GlobalSecondaryIndexPropsV2> {
        java.lang.Number maxReadRequestUnits;
        java.lang.Number maxWriteRequestUnits;
        software.amazon.awscdk.services.dynamodb.Attribute partitionKey;
        java.util.List<software.amazon.awscdk.services.dynamodb.Attribute> partitionKeys;
        software.amazon.awscdk.services.dynamodb.Capacity readCapacity;
        software.amazon.awscdk.services.dynamodb.Attribute sortKey;
        java.util.List<software.amazon.awscdk.services.dynamodb.Attribute> sortKeys;
        software.amazon.awscdk.services.dynamodb.WarmThroughput warmThroughput;
        software.amazon.awscdk.services.dynamodb.Capacity writeCapacity;
        java.lang.String indexName;
        java.util.List<java.lang.String> nonKeyAttributes;
        software.amazon.awscdk.services.dynamodb.ProjectionType projectionType;

        /**
         * Sets the value of {@link GlobalSecondaryIndexPropsV2#getMaxReadRequestUnits}
         * @param maxReadRequestUnits The maximum read request units.
         *                            Note: This can only be configured if the primary table billing is PAY_PER_REQUEST.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxReadRequestUnits(java.lang.Number maxReadRequestUnits) {
            this.maxReadRequestUnits = maxReadRequestUnits;
            return this;
        }

        /**
         * Sets the value of {@link GlobalSecondaryIndexPropsV2#getMaxWriteRequestUnits}
         * @param maxWriteRequestUnits The maximum write request units.
         *                             Note: This can only be configured if the primary table billing is PAY_PER_REQUEST.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxWriteRequestUnits(java.lang.Number maxWriteRequestUnits) {
            this.maxWriteRequestUnits = maxWriteRequestUnits;
            return this;
        }

        /**
         * Sets the value of {@link GlobalSecondaryIndexPropsV2#getPartitionKey}
         * @param partitionKey Partition key attribute definition.
         *                     If a single field forms the partition key, you can use this field.  Use the
         *                     <code>partitionKeys</code> field if the partition key is a compound key (consists of
         *                     multiple fields).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder partitionKey(software.amazon.awscdk.services.dynamodb.Attribute partitionKey) {
            this.partitionKey = partitionKey;
            return this;
        }

        /**
         * Sets the value of {@link GlobalSecondaryIndexPropsV2#getPartitionKeys}
         * @param partitionKeys Compound partition key.
         *                      If a single field forms the partition key, you can use either
         *                      <code>partitionKey</code> or <code>partitionKeys</code> to specify the partition key. Exactly
         *                      one of these must be specified.
         *                      <p>
         *                      You must use <code>partitionKeys</code> field if the partition key is a compound key
         *                      (consists of multiple fields).
         *                      <p>
         *                      NOTE: although the name of this field makes it sound like it creates
         *                      multiple keys, it does not. It defines a single key that consists of
         *                      of multiple fields.
         *                      <p>
         *                      The order of fields is not important.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder partitionKeys(java.util.List<? extends software.amazon.awscdk.services.dynamodb.Attribute> partitionKeys) {
            this.partitionKeys = (java.util.List<software.amazon.awscdk.services.dynamodb.Attribute>)partitionKeys;
            return this;
        }

        /**
         * Sets the value of {@link GlobalSecondaryIndexPropsV2#getReadCapacity}
         * @param readCapacity The read capacity.
         *                     Note: This can only be configured if the primary table billing is provisioned.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readCapacity(software.amazon.awscdk.services.dynamodb.Capacity readCapacity) {
            this.readCapacity = readCapacity;
            return this;
        }

        /**
         * Sets the value of {@link GlobalSecondaryIndexPropsV2#getSortKey}
         * @param sortKey Sort key attribute definition.
         *                If a single field forms the sort key, you can use this field.  Use the
         *                <code>sortKeys</code> field if the sort key is a compound key (consists of multiple
         *                fields).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sortKey(software.amazon.awscdk.services.dynamodb.Attribute sortKey) {
            this.sortKey = sortKey;
            return this;
        }

        /**
         * Sets the value of {@link GlobalSecondaryIndexPropsV2#getSortKeys}
         * @param sortKeys Compound sort key.
         *                 If a single field forms the sort key, you can use either
         *                 <code>sortKey</code> or <code>sortKeys</code> to specify the sort key. At most one of these
         *                 may be specified.
         *                 <p>
         *                 You must use <code>sortKeys</code> field if the sort key is a compound key
         *                 (consists of multiple fields).
         *                 <p>
         *                 NOTE: although the name of this field makes it sound like it creates
         *                 multiple keys, it does not. It defines a single key that consists of
         *                 of multiple fields at the same time.
         *                 <p>
         *                 NOTE: The order of fields is important!
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder sortKeys(java.util.List<? extends software.amazon.awscdk.services.dynamodb.Attribute> sortKeys) {
            this.sortKeys = (java.util.List<software.amazon.awscdk.services.dynamodb.Attribute>)sortKeys;
            return this;
        }

        /**
         * Sets the value of {@link GlobalSecondaryIndexPropsV2#getWarmThroughput}
         * @param warmThroughput The warm throughput configuration for the global secondary index.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder warmThroughput(software.amazon.awscdk.services.dynamodb.WarmThroughput warmThroughput) {
            this.warmThroughput = warmThroughput;
            return this;
        }

        /**
         * Sets the value of {@link GlobalSecondaryIndexPropsV2#getWriteCapacity}
         * @param writeCapacity The write capacity.
         *                      Note: This can only be configured if the primary table billing is provisioned.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder writeCapacity(software.amazon.awscdk.services.dynamodb.Capacity writeCapacity) {
            this.writeCapacity = writeCapacity;
            return this;
        }

        /**
         * Sets the value of {@link GlobalSecondaryIndexPropsV2#getIndexName}
         * @param indexName The name of the secondary index. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder indexName(java.lang.String indexName) {
            this.indexName = indexName;
            return this;
        }

        /**
         * Sets the value of {@link GlobalSecondaryIndexPropsV2#getNonKeyAttributes}
         * @param nonKeyAttributes The non-key attributes that are projected into the secondary index.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nonKeyAttributes(java.util.List<java.lang.String> nonKeyAttributes) {
            this.nonKeyAttributes = nonKeyAttributes;
            return this;
        }

        /**
         * Sets the value of {@link GlobalSecondaryIndexPropsV2#getProjectionType}
         * @param projectionType The set of attributes that are projected into the secondary index.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder projectionType(software.amazon.awscdk.services.dynamodb.ProjectionType projectionType) {
            this.projectionType = projectionType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GlobalSecondaryIndexPropsV2}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public GlobalSecondaryIndexPropsV2 build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GlobalSecondaryIndexPropsV2}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GlobalSecondaryIndexPropsV2 {
        private final java.lang.Number maxReadRequestUnits;
        private final java.lang.Number maxWriteRequestUnits;
        private final software.amazon.awscdk.services.dynamodb.Attribute partitionKey;
        private final java.util.List<software.amazon.awscdk.services.dynamodb.Attribute> partitionKeys;
        private final software.amazon.awscdk.services.dynamodb.Capacity readCapacity;
        private final software.amazon.awscdk.services.dynamodb.Attribute sortKey;
        private final java.util.List<software.amazon.awscdk.services.dynamodb.Attribute> sortKeys;
        private final software.amazon.awscdk.services.dynamodb.WarmThroughput warmThroughput;
        private final software.amazon.awscdk.services.dynamodb.Capacity writeCapacity;
        private final java.lang.String indexName;
        private final java.util.List<java.lang.String> nonKeyAttributes;
        private final software.amazon.awscdk.services.dynamodb.ProjectionType projectionType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.maxReadRequestUnits = software.amazon.jsii.Kernel.get(this, "maxReadRequestUnits", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxWriteRequestUnits = software.amazon.jsii.Kernel.get(this, "maxWriteRequestUnits", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.partitionKey = software.amazon.jsii.Kernel.get(this, "partitionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.Attribute.class));
            this.partitionKeys = software.amazon.jsii.Kernel.get(this, "partitionKeys", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.Attribute.class)));
            this.readCapacity = software.amazon.jsii.Kernel.get(this, "readCapacity", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.Capacity.class));
            this.sortKey = software.amazon.jsii.Kernel.get(this, "sortKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.Attribute.class));
            this.sortKeys = software.amazon.jsii.Kernel.get(this, "sortKeys", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.Attribute.class)));
            this.warmThroughput = software.amazon.jsii.Kernel.get(this, "warmThroughput", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.WarmThroughput.class));
            this.writeCapacity = software.amazon.jsii.Kernel.get(this, "writeCapacity", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.Capacity.class));
            this.indexName = software.amazon.jsii.Kernel.get(this, "indexName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.nonKeyAttributes = software.amazon.jsii.Kernel.get(this, "nonKeyAttributes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.projectionType = software.amazon.jsii.Kernel.get(this, "projectionType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.ProjectionType.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.maxReadRequestUnits = builder.maxReadRequestUnits;
            this.maxWriteRequestUnits = builder.maxWriteRequestUnits;
            this.partitionKey = builder.partitionKey;
            this.partitionKeys = (java.util.List<software.amazon.awscdk.services.dynamodb.Attribute>)builder.partitionKeys;
            this.readCapacity = builder.readCapacity;
            this.sortKey = builder.sortKey;
            this.sortKeys = (java.util.List<software.amazon.awscdk.services.dynamodb.Attribute>)builder.sortKeys;
            this.warmThroughput = builder.warmThroughput;
            this.writeCapacity = builder.writeCapacity;
            this.indexName = java.util.Objects.requireNonNull(builder.indexName, "indexName is required");
            this.nonKeyAttributes = builder.nonKeyAttributes;
            this.projectionType = builder.projectionType;
        }

        @Override
        public final java.lang.Number getMaxReadRequestUnits() {
            return this.maxReadRequestUnits;
        }

        @Override
        public final java.lang.Number getMaxWriteRequestUnits() {
            return this.maxWriteRequestUnits;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.Attribute getPartitionKey() {
            return this.partitionKey;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.dynamodb.Attribute> getPartitionKeys() {
            return this.partitionKeys;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.Capacity getReadCapacity() {
            return this.readCapacity;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.Attribute getSortKey() {
            return this.sortKey;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.dynamodb.Attribute> getSortKeys() {
            return this.sortKeys;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.WarmThroughput getWarmThroughput() {
            return this.warmThroughput;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.Capacity getWriteCapacity() {
            return this.writeCapacity;
        }

        @Override
        public final java.lang.String getIndexName() {
            return this.indexName;
        }

        @Override
        public final java.util.List<java.lang.String> getNonKeyAttributes() {
            return this.nonKeyAttributes;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.ProjectionType getProjectionType() {
            return this.projectionType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getMaxReadRequestUnits() != null) {
                data.set("maxReadRequestUnits", om.valueToTree(this.getMaxReadRequestUnits()));
            }
            if (this.getMaxWriteRequestUnits() != null) {
                data.set("maxWriteRequestUnits", om.valueToTree(this.getMaxWriteRequestUnits()));
            }
            if (this.getPartitionKey() != null) {
                data.set("partitionKey", om.valueToTree(this.getPartitionKey()));
            }
            if (this.getPartitionKeys() != null) {
                data.set("partitionKeys", om.valueToTree(this.getPartitionKeys()));
            }
            if (this.getReadCapacity() != null) {
                data.set("readCapacity", om.valueToTree(this.getReadCapacity()));
            }
            if (this.getSortKey() != null) {
                data.set("sortKey", om.valueToTree(this.getSortKey()));
            }
            if (this.getSortKeys() != null) {
                data.set("sortKeys", om.valueToTree(this.getSortKeys()));
            }
            if (this.getWarmThroughput() != null) {
                data.set("warmThroughput", om.valueToTree(this.getWarmThroughput()));
            }
            if (this.getWriteCapacity() != null) {
                data.set("writeCapacity", om.valueToTree(this.getWriteCapacity()));
            }
            data.set("indexName", om.valueToTree(this.getIndexName()));
            if (this.getNonKeyAttributes() != null) {
                data.set("nonKeyAttributes", om.valueToTree(this.getNonKeyAttributes()));
            }
            if (this.getProjectionType() != null) {
                data.set("projectionType", om.valueToTree(this.getProjectionType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.GlobalSecondaryIndexPropsV2"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GlobalSecondaryIndexPropsV2.Jsii$Proxy that = (GlobalSecondaryIndexPropsV2.Jsii$Proxy) o;

            if (this.maxReadRequestUnits != null ? !this.maxReadRequestUnits.equals(that.maxReadRequestUnits) : that.maxReadRequestUnits != null) return false;
            if (this.maxWriteRequestUnits != null ? !this.maxWriteRequestUnits.equals(that.maxWriteRequestUnits) : that.maxWriteRequestUnits != null) return false;
            if (this.partitionKey != null ? !this.partitionKey.equals(that.partitionKey) : that.partitionKey != null) return false;
            if (this.partitionKeys != null ? !this.partitionKeys.equals(that.partitionKeys) : that.partitionKeys != null) return false;
            if (this.readCapacity != null ? !this.readCapacity.equals(that.readCapacity) : that.readCapacity != null) return false;
            if (this.sortKey != null ? !this.sortKey.equals(that.sortKey) : that.sortKey != null) return false;
            if (this.sortKeys != null ? !this.sortKeys.equals(that.sortKeys) : that.sortKeys != null) return false;
            if (this.warmThroughput != null ? !this.warmThroughput.equals(that.warmThroughput) : that.warmThroughput != null) return false;
            if (this.writeCapacity != null ? !this.writeCapacity.equals(that.writeCapacity) : that.writeCapacity != null) return false;
            if (!indexName.equals(that.indexName)) return false;
            if (this.nonKeyAttributes != null ? !this.nonKeyAttributes.equals(that.nonKeyAttributes) : that.nonKeyAttributes != null) return false;
            return this.projectionType != null ? this.projectionType.equals(that.projectionType) : that.projectionType == null;
        }

        @Override
        public final int hashCode() {
            int result = this.maxReadRequestUnits != null ? this.maxReadRequestUnits.hashCode() : 0;
            result = 31 * result + (this.maxWriteRequestUnits != null ? this.maxWriteRequestUnits.hashCode() : 0);
            result = 31 * result + (this.partitionKey != null ? this.partitionKey.hashCode() : 0);
            result = 31 * result + (this.partitionKeys != null ? this.partitionKeys.hashCode() : 0);
            result = 31 * result + (this.readCapacity != null ? this.readCapacity.hashCode() : 0);
            result = 31 * result + (this.sortKey != null ? this.sortKey.hashCode() : 0);
            result = 31 * result + (this.sortKeys != null ? this.sortKeys.hashCode() : 0);
            result = 31 * result + (this.warmThroughput != null ? this.warmThroughput.hashCode() : 0);
            result = 31 * result + (this.writeCapacity != null ? this.writeCapacity.hashCode() : 0);
            result = 31 * result + (this.indexName.hashCode());
            result = 31 * result + (this.nonKeyAttributes != null ? this.nonKeyAttributes.hashCode() : 0);
            result = 31 * result + (this.projectionType != null ? this.projectionType.hashCode() : 0);
            return result;
        }
    }
}
