package software.amazon.awscdk.services.dynamodb;

/**
 * A description of a key schema of an LSI, GSI or Table.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.dynamodb.*;
 * KeySchema keySchema = KeySchema.builder()
 *         .partitionKeys(List.of(Attribute.builder()
 *                 .name("name")
 *                 .type(AttributeType.BINARY)
 *                 .build()))
 *         .sortKeys(List.of(Attribute.builder()
 *                 .name("name")
 *                 .type(AttributeType.BINARY)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:18.590Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.KeySchema")
@software.amazon.jsii.Jsii.Proxy(KeySchema.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface KeySchema extends software.amazon.jsii.JsiiSerializable {

    /**
     * Partition key definition.
     * <p>
     * This array has at least one, but potentially multiple entries.  Together,
     * they form the partition key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.dynamodb.Attribute> getPartitionKeys();

    /**
     * Sort key definition.
     * <p>
     * This array has zero or more entries. Together, they form the sort key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.dynamodb.Attribute> getSortKeys();

    /**
     * @return a {@link Builder} of {@link KeySchema}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link KeySchema}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<KeySchema> {
        java.util.List<software.amazon.awscdk.services.dynamodb.Attribute> partitionKeys;
        java.util.List<software.amazon.awscdk.services.dynamodb.Attribute> sortKeys;

        /**
         * Sets the value of {@link KeySchema#getPartitionKeys}
         * @param partitionKeys Partition key definition. This parameter is required.
         *                      This array has at least one, but potentially multiple entries.  Together,
         *                      they form the partition key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder partitionKeys(java.util.List<? extends software.amazon.awscdk.services.dynamodb.Attribute> partitionKeys) {
            this.partitionKeys = (java.util.List<software.amazon.awscdk.services.dynamodb.Attribute>)partitionKeys;
            return this;
        }

        /**
         * Sets the value of {@link KeySchema#getSortKeys}
         * @param sortKeys Sort key definition. This parameter is required.
         *                 This array has zero or more entries. Together, they form the sort key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder sortKeys(java.util.List<? extends software.amazon.awscdk.services.dynamodb.Attribute> sortKeys) {
            this.sortKeys = (java.util.List<software.amazon.awscdk.services.dynamodb.Attribute>)sortKeys;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link KeySchema}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public KeySchema build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link KeySchema}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KeySchema {
        private final java.util.List<software.amazon.awscdk.services.dynamodb.Attribute> partitionKeys;
        private final java.util.List<software.amazon.awscdk.services.dynamodb.Attribute> sortKeys;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.partitionKeys = software.amazon.jsii.Kernel.get(this, "partitionKeys", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.Attribute.class)));
            this.sortKeys = software.amazon.jsii.Kernel.get(this, "sortKeys", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.Attribute.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.partitionKeys = (java.util.List<software.amazon.awscdk.services.dynamodb.Attribute>)java.util.Objects.requireNonNull(builder.partitionKeys, "partitionKeys is required");
            this.sortKeys = (java.util.List<software.amazon.awscdk.services.dynamodb.Attribute>)java.util.Objects.requireNonNull(builder.sortKeys, "sortKeys is required");
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.dynamodb.Attribute> getPartitionKeys() {
            return this.partitionKeys;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.dynamodb.Attribute> getSortKeys() {
            return this.sortKeys;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("partitionKeys", om.valueToTree(this.getPartitionKeys()));
            data.set("sortKeys", om.valueToTree(this.getSortKeys()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.KeySchema"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            KeySchema.Jsii$Proxy that = (KeySchema.Jsii$Proxy) o;

            if (!partitionKeys.equals(that.partitionKeys)) return false;
            return this.sortKeys.equals(that.sortKeys);
        }

        @Override
        public final int hashCode() {
            int result = this.partitionKeys.hashCode();
            result = 31 * result + (this.sortKeys.hashCode());
            return result;
        }
    }
}
