package software.amazon.awscdk.services.dynamodb;

/**
 * A set of permissions to grant on a Table Stream.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.dynamodb.*;
 * import software.amazon.awscdk.services.kms.*;
 * import software.amazon.awscdk.interfaces.dynamodb.*;
 * Key key;
 * ITableRef tableRef;
 * StreamGrants streamGrants = StreamGrants.Builder.create()
 *         .table(tableRef)
 *         .tableStreamArn("tableStreamArn")
 *         // the properties below are optional
 *         .encryptionKey(key)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:18.596Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.StreamGrants")
public class StreamGrants extends software.amazon.jsii.JsiiObject {

    protected StreamGrants(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected StreamGrants(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public StreamGrants(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.StreamGrantsProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Adds an IAM policy statement associated with this table's stream to an IAM principal's policy.
     * <p>
     * If <code>encryptionKey</code> is present, appropriate grants to the key needs to be added
     * separately using the <code>table.encryptionKey.grant*</code> methods.
     * <p>
     * @param grantee The principal (no-op if undefined). This parameter is required.
     * @param actions The set of actions to allow (i.e. "dynamodb:DescribeStream", "dynamodb:GetRecords", ...). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant actions(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... actions) {
        return software.amazon.jsii.Kernel.call(this, "actions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(actions)).toArray(Object[]::new));
    }

    /**
     * Permits an IAM Principal to list streams attached to current dynamodb table.
     * <p>
     * @param grantee The principal (no-op if undefined). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant list(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "list", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Permits an IAM principal all stream data read operations for this table's stream: DescribeStream, GetRecords, GetShardIterator, ListStreams.
     * <p>
     * Appropriate grants will also be added to the customer-managed KMS key
     * if one was configured.
     * <p>
     * @param grantee The principal to grant access to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant read(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "read", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.dynamodb.StreamGrants}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.dynamodb.StreamGrants> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.dynamodb.StreamGrantsProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.dynamodb.StreamGrantsProps.Builder();
        }

        /**
         * The table this stream is for.
         * <p>
         * @return {@code this}
         * @param table The table this stream is for. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder table(final software.amazon.awscdk.interfaces.dynamodb.ITableRef table) {
            this.props.table(table);
            return this;
        }

        /**
         * The ARN of the Stream.
         * <p>
         * @return {@code this}
         * @param tableStreamArn The ARN of the Stream. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableStreamArn(final java.lang.String tableStreamArn) {
            this.props.tableStreamArn(tableStreamArn);
            return this;
        }

        /**
         * The encryption key of the table.
         * <p>
         * Required permissions will be added to the key as well.
         * <p>
         * Default: - No key
         * <p>
         * @return {@code this}
         * @param encryptionKey The encryption key of the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKey(final software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.props.encryptionKey(encryptionKey);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.dynamodb.StreamGrants}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.dynamodb.StreamGrants build() {
            return new software.amazon.awscdk.services.dynamodb.StreamGrants(
                this.props.build()
            );
        }
    }
}
