package software.amazon.awscdk.services.dynamodb;

/**
 * Construction properties for StreamGrants.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.dynamodb.*;
 * import software.amazon.awscdk.services.kms.*;
 * import software.amazon.awscdk.interfaces.dynamodb.*;
 * Key key;
 * ITableRef tableRef;
 * StreamGrantsProps streamGrantsProps = StreamGrantsProps.builder()
 *         .table(tableRef)
 *         .tableStreamArn("tableStreamArn")
 *         // the properties below are optional
 *         .encryptionKey(key)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:18.597Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.StreamGrantsProps")
@software.amazon.jsii.Jsii.Proxy(StreamGrantsProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StreamGrantsProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The table this stream is for.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.dynamodb.ITableRef getTable();

    /**
     * The ARN of the Stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTableStreamArn();

    /**
     * The encryption key of the table.
     * <p>
     * Required permissions will be added to the key as well.
     * <p>
     * Default: - No key
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link StreamGrantsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StreamGrantsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<StreamGrantsProps> {
        software.amazon.awscdk.interfaces.dynamodb.ITableRef table;
        java.lang.String tableStreamArn;
        software.amazon.awscdk.services.kms.IKey encryptionKey;

        /**
         * Sets the value of {@link StreamGrantsProps#getTable}
         * @param table The table this stream is for. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder table(software.amazon.awscdk.interfaces.dynamodb.ITableRef table) {
            this.table = table;
            return this;
        }

        /**
         * Sets the value of {@link StreamGrantsProps#getTableStreamArn}
         * @param tableStreamArn The ARN of the Stream. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableStreamArn(java.lang.String tableStreamArn) {
            this.tableStreamArn = tableStreamArn;
            return this;
        }

        /**
         * Sets the value of {@link StreamGrantsProps#getEncryptionKey}
         * @param encryptionKey The encryption key of the table.
         *                      Required permissions will be added to the key as well.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKey(software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StreamGrantsProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public StreamGrantsProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link StreamGrantsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StreamGrantsProps {
        private final software.amazon.awscdk.interfaces.dynamodb.ITableRef table;
        private final java.lang.String tableStreamArn;
        private final software.amazon.awscdk.services.kms.IKey encryptionKey;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.table = software.amazon.jsii.Kernel.get(this, "table", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.dynamodb.ITableRef.class));
            this.tableStreamArn = software.amazon.jsii.Kernel.get(this, "tableStreamArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.encryptionKey = software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.table = java.util.Objects.requireNonNull(builder.table, "table is required");
            this.tableStreamArn = java.util.Objects.requireNonNull(builder.tableStreamArn, "tableStreamArn is required");
            this.encryptionKey = builder.encryptionKey;
        }

        @Override
        public final software.amazon.awscdk.interfaces.dynamodb.ITableRef getTable() {
            return this.table;
        }

        @Override
        public final java.lang.String getTableStreamArn() {
            return this.tableStreamArn;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("table", om.valueToTree(this.getTable()));
            data.set("tableStreamArn", om.valueToTree(this.getTableStreamArn()));
            if (this.getEncryptionKey() != null) {
                data.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.StreamGrantsProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StreamGrantsProps.Jsii$Proxy that = (StreamGrantsProps.Jsii$Proxy) o;

            if (!table.equals(that.table)) return false;
            if (!tableStreamArn.equals(that.tableStreamArn)) return false;
            return this.encryptionKey != null ? this.encryptionKey.equals(that.encryptionKey) : that.encryptionKey == null;
        }

        @Override
        public final int hashCode() {
            int result = this.table.hashCode();
            result = 31 * result + (this.tableStreamArn.hashCode());
            result = 31 * result + (this.encryptionKey != null ? this.encryptionKey.hashCode() : 0);
            return result;
        }
    }
}
