package software.amazon.awscdk.services.dynamodb;

/**
 * DynamoDB's table class.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * TableV2 table = TableV2.Builder.create(this, "Table")
 *         .partitionKey(Attribute.builder().name("pk").type(AttributeType.STRING).build())
 *         .contributorInsightsSpecification(ContributorInsightsSpecification.builder()
 *                 .enabled(true)
 *                 .build())
 *         .tableClass(TableClass.STANDARD_INFREQUENT_ACCESS)
 *         .pointInTimeRecoverySpecification(PointInTimeRecoverySpecification.builder()
 *                 .pointInTimeRecoveryEnabled(true)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.TableClasses.html">https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.TableClasses.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:18.621Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.TableClass")
public enum TableClass {
    /**
     * Default table class for DynamoDB.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD,
    /**
     * Table class for DynamoDB that reduces storage costs compared to existing DynamoDB standard tables.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD_INFREQUENT_ACCESS,
}
