package software.amazon.awscdk.services.dynamodb;

/**
 * A set of permissions to grant on a Table.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.dynamodb.*;
 * import software.amazon.awscdk.services.iam.*;
 * import software.amazon.awscdk.interfaces.dynamodb.*;
 * IEncryptedResource encryptedResource;
 * IResourceWithPolicyV2 resourceWithPolicyV2;
 * ITableRef tableRef;
 * TableGrants tableGrants = TableGrants.Builder.create()
 *         .table(tableRef)
 *         // the properties below are optional
 *         .encryptedResource(encryptedResource)
 *         .hasIndex(false)
 *         .policyResource(resourceWithPolicyV2)
 *         .regions(List.of("regions"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:18.622Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.TableGrants")
public class TableGrants extends software.amazon.jsii.JsiiObject {

    protected TableGrants(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected TableGrants(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public TableGrants(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.TableGrantsProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Adds an IAM policy statement associated with this table to an IAM principal's policy.
     * <p>
     * If <code>encryptionKey</code> is present, appropriate grants to the key needs to be added
     * separately using the <code>table.encryptionKey.grant*</code> methods.
     * <p>
     * @param grantee The principal (no-op if undefined). This parameter is required.
     * @param actions The set of actions to allow (i.e. "dynamodb:PutItem", "dynamodb:GetItem", ...). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant actions(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... actions) {
        return software.amazon.jsii.Kernel.call(this, "actions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(actions)).toArray(Object[]::new));
    }

    /**
     * Permits all DynamoDB operations ("dynamodb:*") to an IAM principal.
     * <p>
     * Appropriate grants will also be added to the customer-managed KMS key
     * if one was configured.
     * <p>
     * @param grantee The principal to grant access to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant fullAccess(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "fullAccess", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Permits an IAM principal all data read operations from this table: BatchGetItem, GetRecords, GetShardIterator, Query, GetItem, Scan, DescribeTable.
     * <p>
     * Appropriate grants will also be added to the customer-managed KMS key
     * if one was configured.
     * <p>
     * @param grantee The principal to grant access to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant readData(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "readData", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Permits an IAM principal to all data read/write operations to this table.
     * <p>
     * BatchGetItem, GetRecords, GetShardIterator, Query, GetItem, Scan,
     * BatchWriteItem, PutItem, UpdateItem, DeleteItem, DescribeTable
     * <p>
     * Appropriate grants will also be added to the customer-managed KMS key
     * if one was configured.
     * <p>
     * @param grantee The principal to grant access to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant readWriteData(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "readWriteData", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Permits an IAM principal all data write operations to this table: BatchWriteItem, PutItem, UpdateItem, DeleteItem, DescribeTable.
     * <p>
     * Appropriate grants will also be added to the customer-managed KMS key
     * if one was configured.
     * <p>
     * @param grantee The principal to grant access to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant writeData(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "writeData", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.dynamodb.TableGrants}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.dynamodb.TableGrants> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.dynamodb.TableGrantsProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.dynamodb.TableGrantsProps.Builder();
        }

        /**
         * The table to grant permissions on.
         * <p>
         * @return {@code this}
         * @param table The table to grant permissions on. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder table(final software.amazon.awscdk.interfaces.dynamodb.ITableRef table) {
            this.props.table(table);
            return this;
        }

        /**
         * The encrypted resource on which actions will be allowed.
         * <p>
         * Default: - No permission is added to the KMS key, even if it exists
         * <p>
         * @return {@code this}
         * @param encryptedResource The encrypted resource on which actions will be allowed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptedResource(final software.amazon.awscdk.services.iam.IEncryptedResource encryptedResource) {
            this.props.encryptedResource(encryptedResource);
            return this;
        }

        /**
         * Whether this table has indexes.
         * <p>
         * If so, permissions are granted on all table indexes as well.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param hasIndex Whether this table has indexes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hasIndex(final java.lang.Boolean hasIndex) {
            this.props.hasIndex(hasIndex);
            return this;
        }

        /**
         * The resource with policy on which actions will be allowed.
         * <p>
         * Default: - No resource policy is created
         * <p>
         * @return {@code this}
         * @param policyResource The resource with policy on which actions will be allowed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyResource(final software.amazon.awscdk.services.iam.IResourceWithPolicyV2 policyResource) {
            this.props.policyResource(policyResource);
            return this;
        }

        /**
         * Additional regions other than the main one that this table is replicated to.
         * <p>
         * Default: - No regions
         * <p>
         * @return {@code this}
         * @param regions Additional regions other than the main one that this table is replicated to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder regions(final java.util.List<java.lang.String> regions) {
            this.props.regions(regions);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.dynamodb.TableGrants}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.dynamodb.TableGrants build() {
            return new software.amazon.awscdk.services.dynamodb.TableGrants(
                this.props.build()
            );
        }
    }
}
