package software.amazon.awscdk.services.dynamodb;

/**
 * Construction properties for TableGrants.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.dynamodb.*;
 * import software.amazon.awscdk.services.iam.*;
 * import software.amazon.awscdk.interfaces.dynamodb.*;
 * IEncryptedResource encryptedResource;
 * IResourceWithPolicyV2 resourceWithPolicyV2;
 * ITableRef tableRef;
 * TableGrantsProps tableGrantsProps = TableGrantsProps.builder()
 *         .table(tableRef)
 *         // the properties below are optional
 *         .encryptedResource(encryptedResource)
 *         .hasIndex(false)
 *         .policyResource(resourceWithPolicyV2)
 *         .regions(List.of("regions"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:18.623Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.TableGrantsProps")
@software.amazon.jsii.Jsii.Proxy(TableGrantsProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TableGrantsProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The table to grant permissions on.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.dynamodb.ITableRef getTable();

    /**
     * The encrypted resource on which actions will be allowed.
     * <p>
     * Default: - No permission is added to the KMS key, even if it exists
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IEncryptedResource getEncryptedResource() {
        return null;
    }

    /**
     * Whether this table has indexes.
     * <p>
     * If so, permissions are granted on all table indexes as well.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getHasIndex() {
        return null;
    }

    /**
     * The resource with policy on which actions will be allowed.
     * <p>
     * Default: - No resource policy is created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IResourceWithPolicyV2 getPolicyResource() {
        return null;
    }

    /**
     * Additional regions other than the main one that this table is replicated to.
     * <p>
     * Default: - No regions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getRegions() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link TableGrantsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TableGrantsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TableGrantsProps> {
        software.amazon.awscdk.interfaces.dynamodb.ITableRef table;
        software.amazon.awscdk.services.iam.IEncryptedResource encryptedResource;
        java.lang.Boolean hasIndex;
        software.amazon.awscdk.services.iam.IResourceWithPolicyV2 policyResource;
        java.util.List<java.lang.String> regions;

        /**
         * Sets the value of {@link TableGrantsProps#getTable}
         * @param table The table to grant permissions on. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder table(software.amazon.awscdk.interfaces.dynamodb.ITableRef table) {
            this.table = table;
            return this;
        }

        /**
         * Sets the value of {@link TableGrantsProps#getEncryptedResource}
         * @param encryptedResource The encrypted resource on which actions will be allowed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptedResource(software.amazon.awscdk.services.iam.IEncryptedResource encryptedResource) {
            this.encryptedResource = encryptedResource;
            return this;
        }

        /**
         * Sets the value of {@link TableGrantsProps#getHasIndex}
         * @param hasIndex Whether this table has indexes.
         *                 If so, permissions are granted on all table indexes as well.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hasIndex(java.lang.Boolean hasIndex) {
            this.hasIndex = hasIndex;
            return this;
        }

        /**
         * Sets the value of {@link TableGrantsProps#getPolicyResource}
         * @param policyResource The resource with policy on which actions will be allowed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyResource(software.amazon.awscdk.services.iam.IResourceWithPolicyV2 policyResource) {
            this.policyResource = policyResource;
            return this;
        }

        /**
         * Sets the value of {@link TableGrantsProps#getRegions}
         * @param regions Additional regions other than the main one that this table is replicated to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder regions(java.util.List<java.lang.String> regions) {
            this.regions = regions;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TableGrantsProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TableGrantsProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TableGrantsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TableGrantsProps {
        private final software.amazon.awscdk.interfaces.dynamodb.ITableRef table;
        private final software.amazon.awscdk.services.iam.IEncryptedResource encryptedResource;
        private final java.lang.Boolean hasIndex;
        private final software.amazon.awscdk.services.iam.IResourceWithPolicyV2 policyResource;
        private final java.util.List<java.lang.String> regions;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.table = software.amazon.jsii.Kernel.get(this, "table", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.dynamodb.ITableRef.class));
            this.encryptedResource = software.amazon.jsii.Kernel.get(this, "encryptedResource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IEncryptedResource.class));
            this.hasIndex = software.amazon.jsii.Kernel.get(this, "hasIndex", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.policyResource = software.amazon.jsii.Kernel.get(this, "policyResource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IResourceWithPolicyV2.class));
            this.regions = software.amazon.jsii.Kernel.get(this, "regions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.table = java.util.Objects.requireNonNull(builder.table, "table is required");
            this.encryptedResource = builder.encryptedResource;
            this.hasIndex = builder.hasIndex;
            this.policyResource = builder.policyResource;
            this.regions = builder.regions;
        }

        @Override
        public final software.amazon.awscdk.interfaces.dynamodb.ITableRef getTable() {
            return this.table;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IEncryptedResource getEncryptedResource() {
            return this.encryptedResource;
        }

        @Override
        public final java.lang.Boolean getHasIndex() {
            return this.hasIndex;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IResourceWithPolicyV2 getPolicyResource() {
            return this.policyResource;
        }

        @Override
        public final java.util.List<java.lang.String> getRegions() {
            return this.regions;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("table", om.valueToTree(this.getTable()));
            if (this.getEncryptedResource() != null) {
                data.set("encryptedResource", om.valueToTree(this.getEncryptedResource()));
            }
            if (this.getHasIndex() != null) {
                data.set("hasIndex", om.valueToTree(this.getHasIndex()));
            }
            if (this.getPolicyResource() != null) {
                data.set("policyResource", om.valueToTree(this.getPolicyResource()));
            }
            if (this.getRegions() != null) {
                data.set("regions", om.valueToTree(this.getRegions()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.TableGrantsProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TableGrantsProps.Jsii$Proxy that = (TableGrantsProps.Jsii$Proxy) o;

            if (!table.equals(that.table)) return false;
            if (this.encryptedResource != null ? !this.encryptedResource.equals(that.encryptedResource) : that.encryptedResource != null) return false;
            if (this.hasIndex != null ? !this.hasIndex.equals(that.hasIndex) : that.hasIndex != null) return false;
            if (this.policyResource != null ? !this.policyResource.equals(that.policyResource) : that.policyResource != null) return false;
            return this.regions != null ? this.regions.equals(that.regions) : that.regions == null;
        }

        @Override
        public final int hashCode() {
            int result = this.table.hashCode();
            result = 31 * result + (this.encryptedResource != null ? this.encryptedResource.hashCode() : 0);
            result = 31 * result + (this.hasIndex != null ? this.hasIndex.hashCode() : 0);
            result = 31 * result + (this.policyResource != null ? this.policyResource.hashCode() : 0);
            result = 31 * result + (this.regions != null ? this.regions.hashCode() : 0);
            return result;
        }
    }
}
