package software.amazon.awscdk.services.ec2;

/**
 * Request for subnets CIDR to be allocated for a Vpc.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * AllocateCidrRequest allocateCidrRequest = AllocateCidrRequest.builder()
 *         .requestedSubnets(List.of(RequestedSubnet.builder()
 *                 .availabilityZone("availabilityZone")
 *                 .configuration(SubnetConfiguration.builder()
 *                         .name("name")
 *                         .subnetType(SubnetType.PRIVATE_ISOLATED)
 *                         // the properties below are optional
 *                         .cidrMask(123)
 *                         .ipv6AssignAddressOnCreation(false)
 *                         .mapPublicIpOnLaunch(false)
 *                         .reserved(false)
 *                         .build())
 *                 .subnetConstructId("subnetConstructId")
 *                 .build()))
 *         .vpcCidr("vpcCidr")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:18.685Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.AllocateCidrRequest")
@software.amazon.jsii.Jsii.Proxy(AllocateCidrRequest.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AllocateCidrRequest extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Subnets to be allocated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ec2.RequestedSubnet> getRequestedSubnets();

    /**
     * The IPv4 CIDR block for this Vpc.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVpcCidr();

    /**
     * @return a {@link Builder} of {@link AllocateCidrRequest}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AllocateCidrRequest}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AllocateCidrRequest> {
        java.util.List<software.amazon.awscdk.services.ec2.RequestedSubnet> requestedSubnets;
        java.lang.String vpcCidr;

        /**
         * Sets the value of {@link AllocateCidrRequest#getRequestedSubnets}
         * @param requestedSubnets The Subnets to be allocated. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder requestedSubnets(java.util.List<? extends software.amazon.awscdk.services.ec2.RequestedSubnet> requestedSubnets) {
            this.requestedSubnets = (java.util.List<software.amazon.awscdk.services.ec2.RequestedSubnet>)requestedSubnets;
            return this;
        }

        /**
         * Sets the value of {@link AllocateCidrRequest#getVpcCidr}
         * @param vpcCidr The IPv4 CIDR block for this Vpc. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcCidr(java.lang.String vpcCidr) {
            this.vpcCidr = vpcCidr;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AllocateCidrRequest}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AllocateCidrRequest build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AllocateCidrRequest}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AllocateCidrRequest {
        private final java.util.List<software.amazon.awscdk.services.ec2.RequestedSubnet> requestedSubnets;
        private final java.lang.String vpcCidr;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.requestedSubnets = software.amazon.jsii.Kernel.get(this, "requestedSubnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.RequestedSubnet.class)));
            this.vpcCidr = software.amazon.jsii.Kernel.get(this, "vpcCidr", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.requestedSubnets = (java.util.List<software.amazon.awscdk.services.ec2.RequestedSubnet>)java.util.Objects.requireNonNull(builder.requestedSubnets, "requestedSubnets is required");
            this.vpcCidr = java.util.Objects.requireNonNull(builder.vpcCidr, "vpcCidr is required");
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.RequestedSubnet> getRequestedSubnets() {
            return this.requestedSubnets;
        }

        @Override
        public final java.lang.String getVpcCidr() {
            return this.vpcCidr;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("requestedSubnets", om.valueToTree(this.getRequestedSubnets()));
            data.set("vpcCidr", om.valueToTree(this.getVpcCidr()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.AllocateCidrRequest"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AllocateCidrRequest.Jsii$Proxy that = (AllocateCidrRequest.Jsii$Proxy) o;

            if (!requestedSubnets.equals(that.requestedSubnets)) return false;
            return this.vpcCidr.equals(that.vpcCidr);
        }

        @Override
        public final int hashCode() {
            int result = this.requestedSubnets.hashCode();
            result = 31 * result + (this.vpcCidr.hashCode());
            return result;
        }
    }
}
