package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a <code>CfnNatGateway</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnNatGatewayProps cfnNatGatewayProps = CfnNatGatewayProps.builder()
 *         .allocationId("allocationId")
 *         .availabilityMode("availabilityMode")
 *         .availabilityZoneAddresses(List.of(AvailabilityZoneAddressProperty.builder()
 *                 .allocationIds(List.of("allocationIds"))
 *                 // the properties below are optional
 *                 .availabilityZone("availabilityZone")
 *                 .availabilityZoneId("availabilityZoneId")
 *                 .build()))
 *         .connectivityType("connectivityType")
 *         .maxDrainDurationSeconds(123)
 *         .privateIpAddress("privateIpAddress")
 *         .secondaryAllocationIds(List.of("secondaryAllocationIds"))
 *         .secondaryPrivateIpAddressCount(123)
 *         .secondaryPrivateIpAddresses(List.of("secondaryPrivateIpAddresses"))
 *         .subnetId("subnetId")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .vpcId("vpcId")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:18.987Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnNatGatewayProps")
@software.amazon.jsii.Jsii.Proxy(CfnNatGatewayProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnNatGatewayProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * [Public NAT gateway only] The allocation ID of the Elastic IP address that's associated with the NAT gateway.
     * <p>
     * This property is required for a public NAT gateway and cannot be specified with a private NAT gateway.
     * <p>
     * Returns union: either {@link java.lang.String} or {@link software.amazon.awscdk.interfaces.ec2.IEIPRef}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-allocationid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-allocationid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAllocationId() {
        return null;
    }

    /**
     * Indicates whether this is a zonal (single-AZ) or regional (multi-AZ) NAT gateway.
     * <p>
     * A zonal NAT gateway is a NAT Gateway that provides redundancy and scalability within a single availability zone. A regional NAT gateway is a single NAT Gateway that works across multiple availability zones (AZs) in your VPC, providing redundancy, scalability and availability across all the AZs in a Region.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateways-regional.html">Regional NAT gateways for automatic multi-AZ expansion</a> in the <em>Amazon VPC User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-availabilitymode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-availabilitymode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityMode() {
        return null;
    }

    /**
     * For regional NAT gateways only: Specifies which Availability Zones you want the NAT gateway to support and the Elastic IP addresses (EIPs) to use in each AZ.
     * <p>
     * The regional NAT gateway uses these EIPs to handle outbound NAT traffic from their respective AZs. If not specified, the NAT gateway will automatically expand to new AZs and associate EIPs upon detection of an elastic network interface. If you specify this parameter, auto-expansion is disabled and you must manually manage AZ coverage.
     * <p>
     * A regional NAT gateway is a single NAT Gateway that works across multiple availability zones (AZs) in your VPC, providing redundancy, scalability and availability across all the AZs in a Region.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateways-regional.html">Regional NAT gateways for automatic multi-AZ expansion</a> in the <em>Amazon VPC User Guide</em> .
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ec2.CfnNatGateway.AvailabilityZoneAddressProperty}>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-availabilityzoneaddresses">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-availabilityzoneaddresses</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAvailabilityZoneAddresses() {
        return null;
    }

    /**
     * Indicates whether the NAT gateway supports public or private connectivity.
     * <p>
     * The default is public connectivity.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-connectivitytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-connectivitytype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getConnectivityType() {
        return null;
    }

    /**
     * The maximum amount of time to wait (in seconds) before forcibly releasing the IP addresses if connections are still in progress.
     * <p>
     * Default value is 350 seconds.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-maxdraindurationseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-maxdraindurationseconds</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxDrainDurationSeconds() {
        return null;
    }

    /**
     * The private IPv4 address to assign to the NAT gateway.
     * <p>
     * If you don't provide an address, a private IPv4 address will be automatically assigned.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-privateipaddress">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-privateipaddress</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPrivateIpAddress() {
        return null;
    }

    /**
     * Secondary EIP allocation IDs.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-working-with.html">Create a NAT gateway</a> in the <em>Amazon VPC User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-secondaryallocationids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-secondaryallocationids</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecondaryAllocationIds() {
        return null;
    }

    /**
     * [Private NAT gateway only] The number of secondary private IPv4 addresses you want to assign to the NAT gateway.
     * <p>
     * For more information about secondary addresses, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html#nat-gateway-creating">Create a NAT gateway</a> in the <em>Amazon Virtual Private Cloud User Guide</em> .
     * <p>
     * <code>SecondaryPrivateIpAddressCount</code> and <code>SecondaryPrivateIpAddresses</code> cannot be set at the same time.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-secondaryprivateipaddresscount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-secondaryprivateipaddresscount</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getSecondaryPrivateIpAddressCount() {
        return null;
    }

    /**
     * Secondary private IPv4 addresses.
     * <p>
     * For more information about secondary addresses, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html#nat-gateway-creating">Create a NAT gateway</a> in the <em>Amazon Virtual Private Cloud User Guide</em> .
     * <p>
     * <code>SecondaryPrivateIpAddressCount</code> and <code>SecondaryPrivateIpAddresses</code> cannot be set at the same time.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-secondaryprivateipaddresses">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-secondaryprivateipaddresses</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecondaryPrivateIpAddresses() {
        return null;
    }

    /**
     * The ID of the subnet in which the NAT gateway is located.
     * <p>
     * Returns union: either {@link java.lang.String} or {@link software.amazon.awscdk.interfaces.ec2.ISubnetRef}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-subnetid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-subnetid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSubnetId() {
        return null;
    }

    /**
     * The tags for the NAT gateway.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The ID of the VPC in which the NAT gateway is located.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-vpcid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-vpcid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVpcId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnNatGatewayProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnNatGatewayProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnNatGatewayProps> {
        java.lang.Object allocationId;
        java.lang.String availabilityMode;
        java.lang.Object availabilityZoneAddresses;
        java.lang.String connectivityType;
        java.lang.Number maxDrainDurationSeconds;
        java.lang.String privateIpAddress;
        java.util.List<java.lang.String> secondaryAllocationIds;
        java.lang.Number secondaryPrivateIpAddressCount;
        java.util.List<java.lang.String> secondaryPrivateIpAddresses;
        java.lang.Object subnetId;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String vpcId;

        /**
         * Sets the value of {@link CfnNatGatewayProps#getAllocationId}
         * @param allocationId [Public NAT gateway only] The allocation ID of the Elastic IP address that's associated with the NAT gateway.
         *                     This property is required for a public NAT gateway and cannot be specified with a private NAT gateway.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allocationId(java.lang.String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        /**
         * Sets the value of {@link CfnNatGatewayProps#getAllocationId}
         * @param allocationId [Public NAT gateway only] The allocation ID of the Elastic IP address that's associated with the NAT gateway.
         *                     This property is required for a public NAT gateway and cannot be specified with a private NAT gateway.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allocationId(software.amazon.awscdk.interfaces.ec2.IEIPRef allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        /**
         * Sets the value of {@link CfnNatGatewayProps#getAvailabilityMode}
         * @param availabilityMode Indicates whether this is a zonal (single-AZ) or regional (multi-AZ) NAT gateway.
         *                         A zonal NAT gateway is a NAT Gateway that provides redundancy and scalability within a single availability zone. A regional NAT gateway is a single NAT Gateway that works across multiple availability zones (AZs) in your VPC, providing redundancy, scalability and availability across all the AZs in a Region.
         *                         <p>
         *                         For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateways-regional.html">Regional NAT gateways for automatic multi-AZ expansion</a> in the <em>Amazon VPC User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityMode(java.lang.String availabilityMode) {
            this.availabilityMode = availabilityMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnNatGatewayProps#getAvailabilityZoneAddresses}
         * @param availabilityZoneAddresses For regional NAT gateways only: Specifies which Availability Zones you want the NAT gateway to support and the Elastic IP addresses (EIPs) to use in each AZ.
         *                                  The regional NAT gateway uses these EIPs to handle outbound NAT traffic from their respective AZs. If not specified, the NAT gateway will automatically expand to new AZs and associate EIPs upon detection of an elastic network interface. If you specify this parameter, auto-expansion is disabled and you must manually manage AZ coverage.
         *                                  <p>
         *                                  A regional NAT gateway is a single NAT Gateway that works across multiple availability zones (AZs) in your VPC, providing redundancy, scalability and availability across all the AZs in a Region.
         *                                  <p>
         *                                  For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateways-regional.html">Regional NAT gateways for automatic multi-AZ expansion</a> in the <em>Amazon VPC User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZoneAddresses(software.amazon.awscdk.IResolvable availabilityZoneAddresses) {
            this.availabilityZoneAddresses = availabilityZoneAddresses;
            return this;
        }

        /**
         * Sets the value of {@link CfnNatGatewayProps#getAvailabilityZoneAddresses}
         * @param availabilityZoneAddresses For regional NAT gateways only: Specifies which Availability Zones you want the NAT gateway to support and the Elastic IP addresses (EIPs) to use in each AZ.
         *                                  The regional NAT gateway uses these EIPs to handle outbound NAT traffic from their respective AZs. If not specified, the NAT gateway will automatically expand to new AZs and associate EIPs upon detection of an elastic network interface. If you specify this parameter, auto-expansion is disabled and you must manually manage AZ coverage.
         *                                  <p>
         *                                  A regional NAT gateway is a single NAT Gateway that works across multiple availability zones (AZs) in your VPC, providing redundancy, scalability and availability across all the AZs in a Region.
         *                                  <p>
         *                                  For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateways-regional.html">Regional NAT gateways for automatic multi-AZ expansion</a> in the <em>Amazon VPC User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZoneAddresses(java.util.List<? extends java.lang.Object> availabilityZoneAddresses) {
            this.availabilityZoneAddresses = availabilityZoneAddresses;
            return this;
        }

        /**
         * Sets the value of {@link CfnNatGatewayProps#getConnectivityType}
         * @param connectivityType Indicates whether the NAT gateway supports public or private connectivity.
         *                         The default is public connectivity.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectivityType(java.lang.String connectivityType) {
            this.connectivityType = connectivityType;
            return this;
        }

        /**
         * Sets the value of {@link CfnNatGatewayProps#getMaxDrainDurationSeconds}
         * @param maxDrainDurationSeconds The maximum amount of time to wait (in seconds) before forcibly releasing the IP addresses if connections are still in progress.
         *                                Default value is 350 seconds.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxDrainDurationSeconds(java.lang.Number maxDrainDurationSeconds) {
            this.maxDrainDurationSeconds = maxDrainDurationSeconds;
            return this;
        }

        /**
         * Sets the value of {@link CfnNatGatewayProps#getPrivateIpAddress}
         * @param privateIpAddress The private IPv4 address to assign to the NAT gateway.
         *                         If you don't provide an address, a private IPv4 address will be automatically assigned.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privateIpAddress(java.lang.String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        /**
         * Sets the value of {@link CfnNatGatewayProps#getSecondaryAllocationIds}
         * @param secondaryAllocationIds Secondary EIP allocation IDs.
         *                               For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/nat-gateway-working-with.html">Create a NAT gateway</a> in the <em>Amazon VPC User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secondaryAllocationIds(java.util.List<java.lang.String> secondaryAllocationIds) {
            this.secondaryAllocationIds = secondaryAllocationIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnNatGatewayProps#getSecondaryPrivateIpAddressCount}
         * @param secondaryPrivateIpAddressCount [Private NAT gateway only] The number of secondary private IPv4 addresses you want to assign to the NAT gateway.
         *                                       For more information about secondary addresses, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html#nat-gateway-creating">Create a NAT gateway</a> in the <em>Amazon Virtual Private Cloud User Guide</em> .
         *                                       <p>
         *                                       <code>SecondaryPrivateIpAddressCount</code> and <code>SecondaryPrivateIpAddresses</code> cannot be set at the same time.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secondaryPrivateIpAddressCount(java.lang.Number secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
            return this;
        }

        /**
         * Sets the value of {@link CfnNatGatewayProps#getSecondaryPrivateIpAddresses}
         * @param secondaryPrivateIpAddresses Secondary private IPv4 addresses.
         *                                    For more information about secondary addresses, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html#nat-gateway-creating">Create a NAT gateway</a> in the <em>Amazon Virtual Private Cloud User Guide</em> .
         *                                    <p>
         *                                    <code>SecondaryPrivateIpAddressCount</code> and <code>SecondaryPrivateIpAddresses</code> cannot be set at the same time.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secondaryPrivateIpAddresses(java.util.List<java.lang.String> secondaryPrivateIpAddresses) {
            this.secondaryPrivateIpAddresses = secondaryPrivateIpAddresses;
            return this;
        }

        /**
         * Sets the value of {@link CfnNatGatewayProps#getSubnetId}
         * @param subnetId The ID of the subnet in which the NAT gateway is located.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetId(java.lang.String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        /**
         * Sets the value of {@link CfnNatGatewayProps#getSubnetId}
         * @param subnetId The ID of the subnet in which the NAT gateway is located.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetId(software.amazon.awscdk.interfaces.ec2.ISubnetRef subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        /**
         * Sets the value of {@link CfnNatGatewayProps#getTags}
         * @param tags The tags for the NAT gateway.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnNatGatewayProps#getVpcId}
         * @param vpcId The ID of the VPC in which the NAT gateway is located.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcId(java.lang.String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnNatGatewayProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnNatGatewayProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnNatGatewayProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnNatGatewayProps {
        private final java.lang.Object allocationId;
        private final java.lang.String availabilityMode;
        private final java.lang.Object availabilityZoneAddresses;
        private final java.lang.String connectivityType;
        private final java.lang.Number maxDrainDurationSeconds;
        private final java.lang.String privateIpAddress;
        private final java.util.List<java.lang.String> secondaryAllocationIds;
        private final java.lang.Number secondaryPrivateIpAddressCount;
        private final java.util.List<java.lang.String> secondaryPrivateIpAddresses;
        private final java.lang.Object subnetId;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String vpcId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.allocationId = software.amazon.jsii.Kernel.get(this, "allocationId", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.availabilityMode = software.amazon.jsii.Kernel.get(this, "availabilityMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.availabilityZoneAddresses = software.amazon.jsii.Kernel.get(this, "availabilityZoneAddresses", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.connectivityType = software.amazon.jsii.Kernel.get(this, "connectivityType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxDrainDurationSeconds = software.amazon.jsii.Kernel.get(this, "maxDrainDurationSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.privateIpAddress = software.amazon.jsii.Kernel.get(this, "privateIpAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.secondaryAllocationIds = software.amazon.jsii.Kernel.get(this, "secondaryAllocationIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.secondaryPrivateIpAddressCount = software.amazon.jsii.Kernel.get(this, "secondaryPrivateIpAddressCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.secondaryPrivateIpAddresses = software.amazon.jsii.Kernel.get(this, "secondaryPrivateIpAddresses", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.subnetId = software.amazon.jsii.Kernel.get(this, "subnetId", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.vpcId = software.amazon.jsii.Kernel.get(this, "vpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.allocationId = builder.allocationId;
            this.availabilityMode = builder.availabilityMode;
            this.availabilityZoneAddresses = builder.availabilityZoneAddresses;
            this.connectivityType = builder.connectivityType;
            this.maxDrainDurationSeconds = builder.maxDrainDurationSeconds;
            this.privateIpAddress = builder.privateIpAddress;
            this.secondaryAllocationIds = builder.secondaryAllocationIds;
            this.secondaryPrivateIpAddressCount = builder.secondaryPrivateIpAddressCount;
            this.secondaryPrivateIpAddresses = builder.secondaryPrivateIpAddresses;
            this.subnetId = builder.subnetId;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.vpcId = builder.vpcId;
        }

        @Override
        public final java.lang.Object getAllocationId() {
            return this.allocationId;
        }

        @Override
        public final java.lang.String getAvailabilityMode() {
            return this.availabilityMode;
        }

        @Override
        public final java.lang.Object getAvailabilityZoneAddresses() {
            return this.availabilityZoneAddresses;
        }

        @Override
        public final java.lang.String getConnectivityType() {
            return this.connectivityType;
        }

        @Override
        public final java.lang.Number getMaxDrainDurationSeconds() {
            return this.maxDrainDurationSeconds;
        }

        @Override
        public final java.lang.String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        @Override
        public final java.util.List<java.lang.String> getSecondaryAllocationIds() {
            return this.secondaryAllocationIds;
        }

        @Override
        public final java.lang.Number getSecondaryPrivateIpAddressCount() {
            return this.secondaryPrivateIpAddressCount;
        }

        @Override
        public final java.util.List<java.lang.String> getSecondaryPrivateIpAddresses() {
            return this.secondaryPrivateIpAddresses;
        }

        @Override
        public final java.lang.Object getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getVpcId() {
            return this.vpcId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAllocationId() != null) {
                data.set("allocationId", om.valueToTree(this.getAllocationId()));
            }
            if (this.getAvailabilityMode() != null) {
                data.set("availabilityMode", om.valueToTree(this.getAvailabilityMode()));
            }
            if (this.getAvailabilityZoneAddresses() != null) {
                data.set("availabilityZoneAddresses", om.valueToTree(this.getAvailabilityZoneAddresses()));
            }
            if (this.getConnectivityType() != null) {
                data.set("connectivityType", om.valueToTree(this.getConnectivityType()));
            }
            if (this.getMaxDrainDurationSeconds() != null) {
                data.set("maxDrainDurationSeconds", om.valueToTree(this.getMaxDrainDurationSeconds()));
            }
            if (this.getPrivateIpAddress() != null) {
                data.set("privateIpAddress", om.valueToTree(this.getPrivateIpAddress()));
            }
            if (this.getSecondaryAllocationIds() != null) {
                data.set("secondaryAllocationIds", om.valueToTree(this.getSecondaryAllocationIds()));
            }
            if (this.getSecondaryPrivateIpAddressCount() != null) {
                data.set("secondaryPrivateIpAddressCount", om.valueToTree(this.getSecondaryPrivateIpAddressCount()));
            }
            if (this.getSecondaryPrivateIpAddresses() != null) {
                data.set("secondaryPrivateIpAddresses", om.valueToTree(this.getSecondaryPrivateIpAddresses()));
            }
            if (this.getSubnetId() != null) {
                data.set("subnetId", om.valueToTree(this.getSubnetId()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVpcId() != null) {
                data.set("vpcId", om.valueToTree(this.getVpcId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnNatGatewayProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnNatGatewayProps.Jsii$Proxy that = (CfnNatGatewayProps.Jsii$Proxy) o;

            if (this.allocationId != null ? !this.allocationId.equals(that.allocationId) : that.allocationId != null) return false;
            if (this.availabilityMode != null ? !this.availabilityMode.equals(that.availabilityMode) : that.availabilityMode != null) return false;
            if (this.availabilityZoneAddresses != null ? !this.availabilityZoneAddresses.equals(that.availabilityZoneAddresses) : that.availabilityZoneAddresses != null) return false;
            if (this.connectivityType != null ? !this.connectivityType.equals(that.connectivityType) : that.connectivityType != null) return false;
            if (this.maxDrainDurationSeconds != null ? !this.maxDrainDurationSeconds.equals(that.maxDrainDurationSeconds) : that.maxDrainDurationSeconds != null) return false;
            if (this.privateIpAddress != null ? !this.privateIpAddress.equals(that.privateIpAddress) : that.privateIpAddress != null) return false;
            if (this.secondaryAllocationIds != null ? !this.secondaryAllocationIds.equals(that.secondaryAllocationIds) : that.secondaryAllocationIds != null) return false;
            if (this.secondaryPrivateIpAddressCount != null ? !this.secondaryPrivateIpAddressCount.equals(that.secondaryPrivateIpAddressCount) : that.secondaryPrivateIpAddressCount != null) return false;
            if (this.secondaryPrivateIpAddresses != null ? !this.secondaryPrivateIpAddresses.equals(that.secondaryPrivateIpAddresses) : that.secondaryPrivateIpAddresses != null) return false;
            if (this.subnetId != null ? !this.subnetId.equals(that.subnetId) : that.subnetId != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.vpcId != null ? this.vpcId.equals(that.vpcId) : that.vpcId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.allocationId != null ? this.allocationId.hashCode() : 0;
            result = 31 * result + (this.availabilityMode != null ? this.availabilityMode.hashCode() : 0);
            result = 31 * result + (this.availabilityZoneAddresses != null ? this.availabilityZoneAddresses.hashCode() : 0);
            result = 31 * result + (this.connectivityType != null ? this.connectivityType.hashCode() : 0);
            result = 31 * result + (this.maxDrainDurationSeconds != null ? this.maxDrainDurationSeconds.hashCode() : 0);
            result = 31 * result + (this.privateIpAddress != null ? this.privateIpAddress.hashCode() : 0);
            result = 31 * result + (this.secondaryAllocationIds != null ? this.secondaryAllocationIds.hashCode() : 0);
            result = 31 * result + (this.secondaryPrivateIpAddressCount != null ? this.secondaryPrivateIpAddressCount.hashCode() : 0);
            result = 31 * result + (this.secondaryPrivateIpAddresses != null ? this.secondaryPrivateIpAddresses.hashCode() : 0);
            result = 31 * result + (this.subnetId != null ? this.subnetId.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.vpcId != null ? this.vpcId.hashCode() : 0);
            return result;
        }
    }
}
