package software.amazon.awscdk.services.ec2;

/**
 * Describes a transit gateway Connect peer.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnTransitGatewayConnectPeer cfnTransitGatewayConnectPeer = CfnTransitGatewayConnectPeer.Builder.create(this, "MyCfnTransitGatewayConnectPeer")
 *         .connectPeerConfiguration(TransitGatewayConnectPeerConfigurationProperty.builder()
 *                 .insideCidrBlocks(List.of("insideCidrBlocks"))
 *                 .peerAddress("peerAddress")
 *                 // the properties below are optional
 *                 .bgpConfigurations(List.of(TransitGatewayAttachmentBgpConfigurationProperty.builder()
 *                         .bgpStatus("bgpStatus")
 *                         .peerAddress("peerAddress")
 *                         .peerAsn(123)
 *                         .transitGatewayAddress("transitGatewayAddress")
 *                         .transitGatewayAsn(123)
 *                         .build()))
 *                 .protocol("protocol")
 *                 .transitGatewayAddress("transitGatewayAddress")
 *                 .build())
 *         .transitGatewayAttachmentId("transitGatewayAttachmentId")
 *         // the properties below are optional
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayconnectpeer.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayconnectpeer.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:19.211Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnTransitGatewayConnectPeer")
public class CfnTransitGatewayConnectPeer extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.ec2.ITransitGatewayConnectPeerRef, software.amazon.awscdk.ITaggableV2 {

    protected CfnTransitGatewayConnectPeer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnTransitGatewayConnectPeer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnTransitGatewayConnectPeer.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::EC2::TransitGatewayConnectPeer</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnTransitGatewayConnectPeer(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CfnTransitGatewayConnectPeerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * @param resource This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String arnForTransitGatewayConnectPeer(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.ec2.ITransitGatewayConnectPeerRef resource) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.CfnTransitGatewayConnectPeer.class, "arnForTransitGatewayConnectPeer", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(resource, "resource is required") });
    }

    /**
     * Creates a new ITransitGatewayConnectPeerRef from a transitGatewayConnectPeerId.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param transitGatewayConnectPeerId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.ec2.ITransitGatewayConnectPeerRef fromTransitGatewayConnectPeerId(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String transitGatewayConnectPeerId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.CfnTransitGatewayConnectPeer.class, "fromTransitGatewayConnectPeerId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.ec2.ITransitGatewayConnectPeerRef.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(transitGatewayConnectPeerId, "transitGatewayConnectPeerId is required") });
    }

    /**
     * Checks whether the given object is a CfnTransitGatewayConnectPeer.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isCfnTransitGatewayConnectPeer(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.CfnTransitGatewayConnectPeer.class, "isCfnTransitGatewayConnectPeer", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The BGP configuration details.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrConnectPeerConfigurationBgpConfigurations() {
        return software.amazon.jsii.Kernel.get(this, "attrConnectPeerConfigurationBgpConfigurations", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The tunnel protocol.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrConnectPeerConfigurationProtocol() {
        return software.amazon.jsii.Kernel.get(this, "attrConnectPeerConfigurationProtocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The creation time.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The state of the Connect peer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrState() {
        return software.amazon.jsii.Kernel.get(this, "attrState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the Connect peer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrTransitGatewayConnectPeerId() {
        return software.amazon.jsii.Kernel.get(this, "attrTransitGatewayConnectPeerId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a TransitGatewayConnectPeer resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.ec2.TransitGatewayConnectPeerReference getTransitGatewayConnectPeerRef() {
        return software.amazon.jsii.Kernel.get(this, "transitGatewayConnectPeerRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.ec2.TransitGatewayConnectPeerReference.class));
    }

    /**
     * The Connect peer details.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ec2.CfnTransitGatewayConnectPeer.TransitGatewayConnectPeerConfigurationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getConnectPeerConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "connectPeerConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The Connect peer details.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConnectPeerConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "connectPeerConfiguration", java.util.Objects.requireNonNull(value, "connectPeerConfiguration is required"));
    }

    /**
     * The Connect peer details.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConnectPeerConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CfnTransitGatewayConnectPeer.TransitGatewayConnectPeerConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "connectPeerConfiguration", java.util.Objects.requireNonNull(value, "connectPeerConfiguration is required"));
    }

    /**
     * The ID of the Connect attachment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTransitGatewayAttachmentId() {
        return software.amazon.jsii.Kernel.get(this, "transitGatewayAttachmentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the Connect attachment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTransitGatewayAttachmentId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "transitGatewayAttachmentId", java.util.Objects.requireNonNull(value, "transitGatewayAttachmentId is required"));
    }

    /**
     * The tags for the Connect peer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tags for the Connect peer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * The BGP configuration information.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * TransitGatewayAttachmentBgpConfigurationProperty transitGatewayAttachmentBgpConfigurationProperty = TransitGatewayAttachmentBgpConfigurationProperty.builder()
     *         .bgpStatus("bgpStatus")
     *         .peerAddress("peerAddress")
     *         .peerAsn(123)
     *         .transitGatewayAddress("transitGatewayAddress")
     *         .transitGatewayAsn(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-transitgatewayconnectpeer-transitgatewayattachmentbgpconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-transitgatewayconnectpeer-transitgatewayattachmentbgpconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnTransitGatewayConnectPeer.TransitGatewayAttachmentBgpConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(TransitGatewayAttachmentBgpConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TransitGatewayAttachmentBgpConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The BGP status.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-transitgatewayconnectpeer-transitgatewayattachmentbgpconfiguration.html#cfn-ec2-transitgatewayconnectpeer-transitgatewayattachmentbgpconfiguration-bgpstatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-transitgatewayconnectpeer-transitgatewayattachmentbgpconfiguration.html#cfn-ec2-transitgatewayconnectpeer-transitgatewayattachmentbgpconfiguration-bgpstatus</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBgpStatus() {
            return null;
        }

        /**
         * The interior BGP peer IP address for the appliance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-transitgatewayconnectpeer-transitgatewayattachmentbgpconfiguration.html#cfn-ec2-transitgatewayconnectpeer-transitgatewayattachmentbgpconfiguration-peeraddress">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-transitgatewayconnectpeer-transitgatewayattachmentbgpconfiguration.html#cfn-ec2-transitgatewayconnectpeer-transitgatewayattachmentbgpconfiguration-peeraddress</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPeerAddress() {
            return null;
        }

        /**
         * The peer Autonomous System Number (ASN).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-transitgatewayconnectpeer-transitgatewayattachmentbgpconfiguration.html#cfn-ec2-transitgatewayconnectpeer-transitgatewayattachmentbgpconfiguration-peerasn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-transitgatewayconnectpeer-transitgatewayattachmentbgpconfiguration.html#cfn-ec2-transitgatewayconnectpeer-transitgatewayattachmentbgpconfiguration-peerasn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPeerAsn() {
            return null;
        }

        /**
         * The interior BGP peer IP address for the transit gateway.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-transitgatewayconnectpeer-transitgatewayattachmentbgpconfiguration.html#cfn-ec2-transitgatewayconnectpeer-transitgatewayattachmentbgpconfiguration-transitgatewayaddress">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-transitgatewayconnectpeer-transitgatewayattachmentbgpconfiguration.html#cfn-ec2-transitgatewayconnectpeer-transitgatewayattachmentbgpconfiguration-transitgatewayaddress</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTransitGatewayAddress() {
            return null;
        }

        /**
         * The transit gateway Autonomous System Number (ASN).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-transitgatewayconnectpeer-transitgatewayattachmentbgpconfiguration.html#cfn-ec2-transitgatewayconnectpeer-transitgatewayattachmentbgpconfiguration-transitgatewayasn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-transitgatewayconnectpeer-transitgatewayattachmentbgpconfiguration.html#cfn-ec2-transitgatewayconnectpeer-transitgatewayattachmentbgpconfiguration-transitgatewayasn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTransitGatewayAsn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TransitGatewayAttachmentBgpConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TransitGatewayAttachmentBgpConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TransitGatewayAttachmentBgpConfigurationProperty> {
            java.lang.String bgpStatus;
            java.lang.String peerAddress;
            java.lang.Number peerAsn;
            java.lang.String transitGatewayAddress;
            java.lang.Number transitGatewayAsn;

            /**
             * Sets the value of {@link TransitGatewayAttachmentBgpConfigurationProperty#getBgpStatus}
             * @param bgpStatus The BGP status.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bgpStatus(java.lang.String bgpStatus) {
                this.bgpStatus = bgpStatus;
                return this;
            }

            /**
             * Sets the value of {@link TransitGatewayAttachmentBgpConfigurationProperty#getPeerAddress}
             * @param peerAddress The interior BGP peer IP address for the appliance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder peerAddress(java.lang.String peerAddress) {
                this.peerAddress = peerAddress;
                return this;
            }

            /**
             * Sets the value of {@link TransitGatewayAttachmentBgpConfigurationProperty#getPeerAsn}
             * @param peerAsn The peer Autonomous System Number (ASN).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder peerAsn(java.lang.Number peerAsn) {
                this.peerAsn = peerAsn;
                return this;
            }

            /**
             * Sets the value of {@link TransitGatewayAttachmentBgpConfigurationProperty#getTransitGatewayAddress}
             * @param transitGatewayAddress The interior BGP peer IP address for the transit gateway.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transitGatewayAddress(java.lang.String transitGatewayAddress) {
                this.transitGatewayAddress = transitGatewayAddress;
                return this;
            }

            /**
             * Sets the value of {@link TransitGatewayAttachmentBgpConfigurationProperty#getTransitGatewayAsn}
             * @param transitGatewayAsn The transit gateway Autonomous System Number (ASN).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transitGatewayAsn(java.lang.Number transitGatewayAsn) {
                this.transitGatewayAsn = transitGatewayAsn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TransitGatewayAttachmentBgpConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TransitGatewayAttachmentBgpConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TransitGatewayAttachmentBgpConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TransitGatewayAttachmentBgpConfigurationProperty {
            private final java.lang.String bgpStatus;
            private final java.lang.String peerAddress;
            private final java.lang.Number peerAsn;
            private final java.lang.String transitGatewayAddress;
            private final java.lang.Number transitGatewayAsn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bgpStatus = software.amazon.jsii.Kernel.get(this, "bgpStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.peerAddress = software.amazon.jsii.Kernel.get(this, "peerAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.peerAsn = software.amazon.jsii.Kernel.get(this, "peerAsn", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.transitGatewayAddress = software.amazon.jsii.Kernel.get(this, "transitGatewayAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.transitGatewayAsn = software.amazon.jsii.Kernel.get(this, "transitGatewayAsn", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bgpStatus = builder.bgpStatus;
                this.peerAddress = builder.peerAddress;
                this.peerAsn = builder.peerAsn;
                this.transitGatewayAddress = builder.transitGatewayAddress;
                this.transitGatewayAsn = builder.transitGatewayAsn;
            }

            @Override
            public final java.lang.String getBgpStatus() {
                return this.bgpStatus;
            }

            @Override
            public final java.lang.String getPeerAddress() {
                return this.peerAddress;
            }

            @Override
            public final java.lang.Number getPeerAsn() {
                return this.peerAsn;
            }

            @Override
            public final java.lang.String getTransitGatewayAddress() {
                return this.transitGatewayAddress;
            }

            @Override
            public final java.lang.Number getTransitGatewayAsn() {
                return this.transitGatewayAsn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBgpStatus() != null) {
                    data.set("bgpStatus", om.valueToTree(this.getBgpStatus()));
                }
                if (this.getPeerAddress() != null) {
                    data.set("peerAddress", om.valueToTree(this.getPeerAddress()));
                }
                if (this.getPeerAsn() != null) {
                    data.set("peerAsn", om.valueToTree(this.getPeerAsn()));
                }
                if (this.getTransitGatewayAddress() != null) {
                    data.set("transitGatewayAddress", om.valueToTree(this.getTransitGatewayAddress()));
                }
                if (this.getTransitGatewayAsn() != null) {
                    data.set("transitGatewayAsn", om.valueToTree(this.getTransitGatewayAsn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnTransitGatewayConnectPeer.TransitGatewayAttachmentBgpConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TransitGatewayAttachmentBgpConfigurationProperty.Jsii$Proxy that = (TransitGatewayAttachmentBgpConfigurationProperty.Jsii$Proxy) o;

                if (this.bgpStatus != null ? !this.bgpStatus.equals(that.bgpStatus) : that.bgpStatus != null) return false;
                if (this.peerAddress != null ? !this.peerAddress.equals(that.peerAddress) : that.peerAddress != null) return false;
                if (this.peerAsn != null ? !this.peerAsn.equals(that.peerAsn) : that.peerAsn != null) return false;
                if (this.transitGatewayAddress != null ? !this.transitGatewayAddress.equals(that.transitGatewayAddress) : that.transitGatewayAddress != null) return false;
                return this.transitGatewayAsn != null ? this.transitGatewayAsn.equals(that.transitGatewayAsn) : that.transitGatewayAsn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bgpStatus != null ? this.bgpStatus.hashCode() : 0;
                result = 31 * result + (this.peerAddress != null ? this.peerAddress.hashCode() : 0);
                result = 31 * result + (this.peerAsn != null ? this.peerAsn.hashCode() : 0);
                result = 31 * result + (this.transitGatewayAddress != null ? this.transitGatewayAddress.hashCode() : 0);
                result = 31 * result + (this.transitGatewayAsn != null ? this.transitGatewayAsn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the Connect peer details.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * TransitGatewayConnectPeerConfigurationProperty transitGatewayConnectPeerConfigurationProperty = TransitGatewayConnectPeerConfigurationProperty.builder()
     *         .insideCidrBlocks(List.of("insideCidrBlocks"))
     *         .peerAddress("peerAddress")
     *         // the properties below are optional
     *         .bgpConfigurations(List.of(TransitGatewayAttachmentBgpConfigurationProperty.builder()
     *                 .bgpStatus("bgpStatus")
     *                 .peerAddress("peerAddress")
     *                 .peerAsn(123)
     *                 .transitGatewayAddress("transitGatewayAddress")
     *                 .transitGatewayAsn(123)
     *                 .build()))
     *         .protocol("protocol")
     *         .transitGatewayAddress("transitGatewayAddress")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-transitgatewayconnectpeer-transitgatewayconnectpeerconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-transitgatewayconnectpeer-transitgatewayconnectpeerconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnTransitGatewayConnectPeer.TransitGatewayConnectPeerConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(TransitGatewayConnectPeerConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TransitGatewayConnectPeerConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The range of interior BGP peer IP addresses.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-transitgatewayconnectpeer-transitgatewayconnectpeerconfiguration.html#cfn-ec2-transitgatewayconnectpeer-transitgatewayconnectpeerconfiguration-insidecidrblocks">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-transitgatewayconnectpeer-transitgatewayconnectpeerconfiguration.html#cfn-ec2-transitgatewayconnectpeer-transitgatewayconnectpeerconfiguration-insidecidrblocks</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getInsideCidrBlocks();

        /**
         * The Connect peer IP address on the appliance side of the tunnel.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-transitgatewayconnectpeer-transitgatewayconnectpeerconfiguration.html#cfn-ec2-transitgatewayconnectpeer-transitgatewayconnectpeerconfiguration-peeraddress">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-transitgatewayconnectpeer-transitgatewayconnectpeerconfiguration.html#cfn-ec2-transitgatewayconnectpeer-transitgatewayconnectpeerconfiguration-peeraddress</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPeerAddress();

        /**
         * The BGP configuration details.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ec2.CfnTransitGatewayConnectPeer.TransitGatewayAttachmentBgpConfigurationProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-transitgatewayconnectpeer-transitgatewayconnectpeerconfiguration.html#cfn-ec2-transitgatewayconnectpeer-transitgatewayconnectpeerconfiguration-bgpconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-transitgatewayconnectpeer-transitgatewayconnectpeerconfiguration.html#cfn-ec2-transitgatewayconnectpeer-transitgatewayconnectpeerconfiguration-bgpconfigurations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBgpConfigurations() {
            return null;
        }

        /**
         * The tunnel protocol.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-transitgatewayconnectpeer-transitgatewayconnectpeerconfiguration.html#cfn-ec2-transitgatewayconnectpeer-transitgatewayconnectpeerconfiguration-protocol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-transitgatewayconnectpeer-transitgatewayconnectpeerconfiguration.html#cfn-ec2-transitgatewayconnectpeer-transitgatewayconnectpeerconfiguration-protocol</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProtocol() {
            return null;
        }

        /**
         * The Connect peer IP address on the transit gateway side of the tunnel.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-transitgatewayconnectpeer-transitgatewayconnectpeerconfiguration.html#cfn-ec2-transitgatewayconnectpeer-transitgatewayconnectpeerconfiguration-transitgatewayaddress">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-transitgatewayconnectpeer-transitgatewayconnectpeerconfiguration.html#cfn-ec2-transitgatewayconnectpeer-transitgatewayconnectpeerconfiguration-transitgatewayaddress</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTransitGatewayAddress() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TransitGatewayConnectPeerConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TransitGatewayConnectPeerConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TransitGatewayConnectPeerConfigurationProperty> {
            java.util.List<java.lang.String> insideCidrBlocks;
            java.lang.String peerAddress;
            java.lang.Object bgpConfigurations;
            java.lang.String protocol;
            java.lang.String transitGatewayAddress;

            /**
             * Sets the value of {@link TransitGatewayConnectPeerConfigurationProperty#getInsideCidrBlocks}
             * @param insideCidrBlocks The range of interior BGP peer IP addresses. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder insideCidrBlocks(java.util.List<java.lang.String> insideCidrBlocks) {
                this.insideCidrBlocks = insideCidrBlocks;
                return this;
            }

            /**
             * Sets the value of {@link TransitGatewayConnectPeerConfigurationProperty#getPeerAddress}
             * @param peerAddress The Connect peer IP address on the appliance side of the tunnel. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder peerAddress(java.lang.String peerAddress) {
                this.peerAddress = peerAddress;
                return this;
            }

            /**
             * Sets the value of {@link TransitGatewayConnectPeerConfigurationProperty#getBgpConfigurations}
             * @param bgpConfigurations The BGP configuration details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bgpConfigurations(software.amazon.awscdk.IResolvable bgpConfigurations) {
                this.bgpConfigurations = bgpConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link TransitGatewayConnectPeerConfigurationProperty#getBgpConfigurations}
             * @param bgpConfigurations The BGP configuration details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bgpConfigurations(java.util.List<? extends java.lang.Object> bgpConfigurations) {
                this.bgpConfigurations = bgpConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link TransitGatewayConnectPeerConfigurationProperty#getProtocol}
             * @param protocol The tunnel protocol.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocol(java.lang.String protocol) {
                this.protocol = protocol;
                return this;
            }

            /**
             * Sets the value of {@link TransitGatewayConnectPeerConfigurationProperty#getTransitGatewayAddress}
             * @param transitGatewayAddress The Connect peer IP address on the transit gateway side of the tunnel.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transitGatewayAddress(java.lang.String transitGatewayAddress) {
                this.transitGatewayAddress = transitGatewayAddress;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TransitGatewayConnectPeerConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TransitGatewayConnectPeerConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TransitGatewayConnectPeerConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TransitGatewayConnectPeerConfigurationProperty {
            private final java.util.List<java.lang.String> insideCidrBlocks;
            private final java.lang.String peerAddress;
            private final java.lang.Object bgpConfigurations;
            private final java.lang.String protocol;
            private final java.lang.String transitGatewayAddress;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.insideCidrBlocks = software.amazon.jsii.Kernel.get(this, "insideCidrBlocks", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.peerAddress = software.amazon.jsii.Kernel.get(this, "peerAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bgpConfigurations = software.amazon.jsii.Kernel.get(this, "bgpConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.transitGatewayAddress = software.amazon.jsii.Kernel.get(this, "transitGatewayAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.insideCidrBlocks = java.util.Objects.requireNonNull(builder.insideCidrBlocks, "insideCidrBlocks is required");
                this.peerAddress = java.util.Objects.requireNonNull(builder.peerAddress, "peerAddress is required");
                this.bgpConfigurations = builder.bgpConfigurations;
                this.protocol = builder.protocol;
                this.transitGatewayAddress = builder.transitGatewayAddress;
            }

            @Override
            public final java.util.List<java.lang.String> getInsideCidrBlocks() {
                return this.insideCidrBlocks;
            }

            @Override
            public final java.lang.String getPeerAddress() {
                return this.peerAddress;
            }

            @Override
            public final java.lang.Object getBgpConfigurations() {
                return this.bgpConfigurations;
            }

            @Override
            public final java.lang.String getProtocol() {
                return this.protocol;
            }

            @Override
            public final java.lang.String getTransitGatewayAddress() {
                return this.transitGatewayAddress;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("insideCidrBlocks", om.valueToTree(this.getInsideCidrBlocks()));
                data.set("peerAddress", om.valueToTree(this.getPeerAddress()));
                if (this.getBgpConfigurations() != null) {
                    data.set("bgpConfigurations", om.valueToTree(this.getBgpConfigurations()));
                }
                if (this.getProtocol() != null) {
                    data.set("protocol", om.valueToTree(this.getProtocol()));
                }
                if (this.getTransitGatewayAddress() != null) {
                    data.set("transitGatewayAddress", om.valueToTree(this.getTransitGatewayAddress()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnTransitGatewayConnectPeer.TransitGatewayConnectPeerConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TransitGatewayConnectPeerConfigurationProperty.Jsii$Proxy that = (TransitGatewayConnectPeerConfigurationProperty.Jsii$Proxy) o;

                if (!insideCidrBlocks.equals(that.insideCidrBlocks)) return false;
                if (!peerAddress.equals(that.peerAddress)) return false;
                if (this.bgpConfigurations != null ? !this.bgpConfigurations.equals(that.bgpConfigurations) : that.bgpConfigurations != null) return false;
                if (this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null) return false;
                return this.transitGatewayAddress != null ? this.transitGatewayAddress.equals(that.transitGatewayAddress) : that.transitGatewayAddress == null;
            }

            @Override
            public final int hashCode() {
                int result = this.insideCidrBlocks.hashCode();
                result = 31 * result + (this.peerAddress.hashCode());
                result = 31 * result + (this.bgpConfigurations != null ? this.bgpConfigurations.hashCode() : 0);
                result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
                result = 31 * result + (this.transitGatewayAddress != null ? this.transitGatewayAddress.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.CfnTransitGatewayConnectPeer}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.CfnTransitGatewayConnectPeer> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.CfnTransitGatewayConnectPeerProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.CfnTransitGatewayConnectPeerProps.Builder();
        }

        /**
         * The Connect peer details.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayconnectpeer.html#cfn-ec2-transitgatewayconnectpeer-connectpeerconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayconnectpeer.html#cfn-ec2-transitgatewayconnectpeer-connectpeerconfiguration</a>
         * @param connectPeerConfiguration The Connect peer details. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectPeerConfiguration(final software.amazon.awscdk.IResolvable connectPeerConfiguration) {
            this.props.connectPeerConfiguration(connectPeerConfiguration);
            return this;
        }
        /**
         * The Connect peer details.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayconnectpeer.html#cfn-ec2-transitgatewayconnectpeer-connectpeerconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayconnectpeer.html#cfn-ec2-transitgatewayconnectpeer-connectpeerconfiguration</a>
         * @param connectPeerConfiguration The Connect peer details. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectPeerConfiguration(final software.amazon.awscdk.services.ec2.CfnTransitGatewayConnectPeer.TransitGatewayConnectPeerConfigurationProperty connectPeerConfiguration) {
            this.props.connectPeerConfiguration(connectPeerConfiguration);
            return this;
        }

        /**
         * The ID of the Connect attachment.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayconnectpeer.html#cfn-ec2-transitgatewayconnectpeer-transitgatewayattachmentid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayconnectpeer.html#cfn-ec2-transitgatewayconnectpeer-transitgatewayattachmentid</a>
         * @param transitGatewayAttachmentId The ID of the Connect attachment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitGatewayAttachmentId(final java.lang.String transitGatewayAttachmentId) {
            this.props.transitGatewayAttachmentId(transitGatewayAttachmentId);
            return this;
        }

        /**
         * The tags for the Connect peer.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayconnectpeer.html#cfn-ec2-transitgatewayconnectpeer-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayconnectpeer.html#cfn-ec2-transitgatewayconnectpeer-tags</a>
         * @param tags The tags for the Connect peer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ec2.CfnTransitGatewayConnectPeer}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.CfnTransitGatewayConnectPeer build() {
            return new software.amazon.awscdk.services.ec2.CfnTransitGatewayConnectPeer(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
