package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a <code>CfnTransitGatewayMeteringPolicyEntry</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnTransitGatewayMeteringPolicyEntryProps cfnTransitGatewayMeteringPolicyEntryProps = CfnTransitGatewayMeteringPolicyEntryProps.builder()
 *         .meteredAccount("meteredAccount")
 *         .policyRuleNumber(123)
 *         .transitGatewayMeteringPolicyId("transitGatewayMeteringPolicyId")
 *         // the properties below are optional
 *         .destinationCidrBlock("destinationCidrBlock")
 *         .destinationPortRange("destinationPortRange")
 *         .destinationTransitGatewayAttachmentId("destinationTransitGatewayAttachmentId")
 *         .destinationTransitGatewayAttachmentType("destinationTransitGatewayAttachmentType")
 *         .protocol("protocol")
 *         .sourceCidrBlock("sourceCidrBlock")
 *         .sourcePortRange("sourcePortRange")
 *         .sourceTransitGatewayAttachmentId("sourceTransitGatewayAttachmentId")
 *         .sourceTransitGatewayAttachmentType("sourceTransitGatewayAttachmentType")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymeteringpolicyentry.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymeteringpolicyentry.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:19.217Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnTransitGatewayMeteringPolicyEntryProps")
@software.amazon.jsii.Jsii.Proxy(CfnTransitGatewayMeteringPolicyEntryProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnTransitGatewayMeteringPolicyEntryProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The AWS account ID to which the metered traffic is attributed.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymeteringpolicyentry.html#cfn-ec2-transitgatewaymeteringpolicyentry-meteredaccount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymeteringpolicyentry.html#cfn-ec2-transitgatewaymeteringpolicyentry-meteredaccount</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMeteredAccount();

    /**
     * The rule number of the metering policy entry.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymeteringpolicyentry.html#cfn-ec2-transitgatewaymeteringpolicyentry-policyrulenumber">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymeteringpolicyentry.html#cfn-ec2-transitgatewaymeteringpolicyentry-policyrulenumber</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getPolicyRuleNumber();

    /**
     * The ID of the transit gateway metering policy for which the entry is being created.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymeteringpolicyentry.html#cfn-ec2-transitgatewaymeteringpolicyentry-transitgatewaymeteringpolicyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymeteringpolicyentry.html#cfn-ec2-transitgatewaymeteringpolicyentry-transitgatewaymeteringpolicyid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTransitGatewayMeteringPolicyId();

    /**
     * Describes an IPv4 CIDR block.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymeteringpolicyentry.html#cfn-ec2-transitgatewaymeteringpolicyentry-destinationcidrblock">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymeteringpolicyentry.html#cfn-ec2-transitgatewaymeteringpolicyentry-destinationcidrblock</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDestinationCidrBlock() {
        return null;
    }

    /**
     * Describes a range of ports.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymeteringpolicyentry.html#cfn-ec2-transitgatewaymeteringpolicyentry-destinationportrange">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymeteringpolicyentry.html#cfn-ec2-transitgatewaymeteringpolicyentry-destinationportrange</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDestinationPortRange() {
        return null;
    }

    /**
     * The ID of the source attachment through which traffic leaves a transit gateway.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymeteringpolicyentry.html#cfn-ec2-transitgatewaymeteringpolicyentry-destinationtransitgatewayattachmentid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymeteringpolicyentry.html#cfn-ec2-transitgatewaymeteringpolicyentry-destinationtransitgatewayattachmentid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDestinationTransitGatewayAttachmentId() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymeteringpolicyentry.html#cfn-ec2-transitgatewaymeteringpolicyentry-destinationtransitgatewayattachmenttype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymeteringpolicyentry.html#cfn-ec2-transitgatewaymeteringpolicyentry-destinationtransitgatewayattachmenttype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDestinationTransitGatewayAttachmentType() {
        return null;
    }

    /**
     * The protocol of the traffic.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymeteringpolicyentry.html#cfn-ec2-transitgatewaymeteringpolicyentry-protocol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymeteringpolicyentry.html#cfn-ec2-transitgatewaymeteringpolicyentry-protocol</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProtocol() {
        return null;
    }

    /**
     * Describes an IPv4 CIDR block.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymeteringpolicyentry.html#cfn-ec2-transitgatewaymeteringpolicyentry-sourcecidrblock">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymeteringpolicyentry.html#cfn-ec2-transitgatewaymeteringpolicyentry-sourcecidrblock</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSourceCidrBlock() {
        return null;
    }

    /**
     * Describes a range of ports.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymeteringpolicyentry.html#cfn-ec2-transitgatewaymeteringpolicyentry-sourceportrange">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymeteringpolicyentry.html#cfn-ec2-transitgatewaymeteringpolicyentry-sourceportrange</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSourcePortRange() {
        return null;
    }

    /**
     * The ID of the source attachment through which traffic enters a transit gateway.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymeteringpolicyentry.html#cfn-ec2-transitgatewaymeteringpolicyentry-sourcetransitgatewayattachmentid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymeteringpolicyentry.html#cfn-ec2-transitgatewaymeteringpolicyentry-sourcetransitgatewayattachmentid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSourceTransitGatewayAttachmentId() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymeteringpolicyentry.html#cfn-ec2-transitgatewaymeteringpolicyentry-sourcetransitgatewayattachmenttype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewaymeteringpolicyentry.html#cfn-ec2-transitgatewaymeteringpolicyentry-sourcetransitgatewayattachmenttype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSourceTransitGatewayAttachmentType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnTransitGatewayMeteringPolicyEntryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTransitGatewayMeteringPolicyEntryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnTransitGatewayMeteringPolicyEntryProps> {
        java.lang.String meteredAccount;
        java.lang.Number policyRuleNumber;
        java.lang.String transitGatewayMeteringPolicyId;
        java.lang.String destinationCidrBlock;
        java.lang.String destinationPortRange;
        java.lang.String destinationTransitGatewayAttachmentId;
        java.lang.String destinationTransitGatewayAttachmentType;
        java.lang.String protocol;
        java.lang.String sourceCidrBlock;
        java.lang.String sourcePortRange;
        java.lang.String sourceTransitGatewayAttachmentId;
        java.lang.String sourceTransitGatewayAttachmentType;

        /**
         * Sets the value of {@link CfnTransitGatewayMeteringPolicyEntryProps#getMeteredAccount}
         * @param meteredAccount The AWS account ID to which the metered traffic is attributed. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder meteredAccount(java.lang.String meteredAccount) {
            this.meteredAccount = meteredAccount;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransitGatewayMeteringPolicyEntryProps#getPolicyRuleNumber}
         * @param policyRuleNumber The rule number of the metering policy entry. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyRuleNumber(java.lang.Number policyRuleNumber) {
            this.policyRuleNumber = policyRuleNumber;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransitGatewayMeteringPolicyEntryProps#getTransitGatewayMeteringPolicyId}
         * @param transitGatewayMeteringPolicyId The ID of the transit gateway metering policy for which the entry is being created. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitGatewayMeteringPolicyId(java.lang.String transitGatewayMeteringPolicyId) {
            this.transitGatewayMeteringPolicyId = transitGatewayMeteringPolicyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransitGatewayMeteringPolicyEntryProps#getDestinationCidrBlock}
         * @param destinationCidrBlock Describes an IPv4 CIDR block.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationCidrBlock(java.lang.String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransitGatewayMeteringPolicyEntryProps#getDestinationPortRange}
         * @param destinationPortRange Describes a range of ports.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationPortRange(java.lang.String destinationPortRange) {
            this.destinationPortRange = destinationPortRange;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransitGatewayMeteringPolicyEntryProps#getDestinationTransitGatewayAttachmentId}
         * @param destinationTransitGatewayAttachmentId The ID of the source attachment through which traffic leaves a transit gateway.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationTransitGatewayAttachmentId(java.lang.String destinationTransitGatewayAttachmentId) {
            this.destinationTransitGatewayAttachmentId = destinationTransitGatewayAttachmentId;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransitGatewayMeteringPolicyEntryProps#getDestinationTransitGatewayAttachmentType}
         * @param destinationTransitGatewayAttachmentType the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationTransitGatewayAttachmentType(java.lang.String destinationTransitGatewayAttachmentType) {
            this.destinationTransitGatewayAttachmentType = destinationTransitGatewayAttachmentType;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransitGatewayMeteringPolicyEntryProps#getProtocol}
         * @param protocol The protocol of the traffic.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(java.lang.String protocol) {
            this.protocol = protocol;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransitGatewayMeteringPolicyEntryProps#getSourceCidrBlock}
         * @param sourceCidrBlock Describes an IPv4 CIDR block.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceCidrBlock(java.lang.String sourceCidrBlock) {
            this.sourceCidrBlock = sourceCidrBlock;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransitGatewayMeteringPolicyEntryProps#getSourcePortRange}
         * @param sourcePortRange Describes a range of ports.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourcePortRange(java.lang.String sourcePortRange) {
            this.sourcePortRange = sourcePortRange;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransitGatewayMeteringPolicyEntryProps#getSourceTransitGatewayAttachmentId}
         * @param sourceTransitGatewayAttachmentId The ID of the source attachment through which traffic enters a transit gateway.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceTransitGatewayAttachmentId(java.lang.String sourceTransitGatewayAttachmentId) {
            this.sourceTransitGatewayAttachmentId = sourceTransitGatewayAttachmentId;
            return this;
        }

        /**
         * Sets the value of {@link CfnTransitGatewayMeteringPolicyEntryProps#getSourceTransitGatewayAttachmentType}
         * @param sourceTransitGatewayAttachmentType the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceTransitGatewayAttachmentType(java.lang.String sourceTransitGatewayAttachmentType) {
            this.sourceTransitGatewayAttachmentType = sourceTransitGatewayAttachmentType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTransitGatewayMeteringPolicyEntryProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnTransitGatewayMeteringPolicyEntryProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnTransitGatewayMeteringPolicyEntryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTransitGatewayMeteringPolicyEntryProps {
        private final java.lang.String meteredAccount;
        private final java.lang.Number policyRuleNumber;
        private final java.lang.String transitGatewayMeteringPolicyId;
        private final java.lang.String destinationCidrBlock;
        private final java.lang.String destinationPortRange;
        private final java.lang.String destinationTransitGatewayAttachmentId;
        private final java.lang.String destinationTransitGatewayAttachmentType;
        private final java.lang.String protocol;
        private final java.lang.String sourceCidrBlock;
        private final java.lang.String sourcePortRange;
        private final java.lang.String sourceTransitGatewayAttachmentId;
        private final java.lang.String sourceTransitGatewayAttachmentType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.meteredAccount = software.amazon.jsii.Kernel.get(this, "meteredAccount", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.policyRuleNumber = software.amazon.jsii.Kernel.get(this, "policyRuleNumber", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.transitGatewayMeteringPolicyId = software.amazon.jsii.Kernel.get(this, "transitGatewayMeteringPolicyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.destinationCidrBlock = software.amazon.jsii.Kernel.get(this, "destinationCidrBlock", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.destinationPortRange = software.amazon.jsii.Kernel.get(this, "destinationPortRange", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.destinationTransitGatewayAttachmentId = software.amazon.jsii.Kernel.get(this, "destinationTransitGatewayAttachmentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.destinationTransitGatewayAttachmentType = software.amazon.jsii.Kernel.get(this, "destinationTransitGatewayAttachmentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceCidrBlock = software.amazon.jsii.Kernel.get(this, "sourceCidrBlock", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourcePortRange = software.amazon.jsii.Kernel.get(this, "sourcePortRange", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceTransitGatewayAttachmentId = software.amazon.jsii.Kernel.get(this, "sourceTransitGatewayAttachmentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceTransitGatewayAttachmentType = software.amazon.jsii.Kernel.get(this, "sourceTransitGatewayAttachmentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.meteredAccount = java.util.Objects.requireNonNull(builder.meteredAccount, "meteredAccount is required");
            this.policyRuleNumber = java.util.Objects.requireNonNull(builder.policyRuleNumber, "policyRuleNumber is required");
            this.transitGatewayMeteringPolicyId = java.util.Objects.requireNonNull(builder.transitGatewayMeteringPolicyId, "transitGatewayMeteringPolicyId is required");
            this.destinationCidrBlock = builder.destinationCidrBlock;
            this.destinationPortRange = builder.destinationPortRange;
            this.destinationTransitGatewayAttachmentId = builder.destinationTransitGatewayAttachmentId;
            this.destinationTransitGatewayAttachmentType = builder.destinationTransitGatewayAttachmentType;
            this.protocol = builder.protocol;
            this.sourceCidrBlock = builder.sourceCidrBlock;
            this.sourcePortRange = builder.sourcePortRange;
            this.sourceTransitGatewayAttachmentId = builder.sourceTransitGatewayAttachmentId;
            this.sourceTransitGatewayAttachmentType = builder.sourceTransitGatewayAttachmentType;
        }

        @Override
        public final java.lang.String getMeteredAccount() {
            return this.meteredAccount;
        }

        @Override
        public final java.lang.Number getPolicyRuleNumber() {
            return this.policyRuleNumber;
        }

        @Override
        public final java.lang.String getTransitGatewayMeteringPolicyId() {
            return this.transitGatewayMeteringPolicyId;
        }

        @Override
        public final java.lang.String getDestinationCidrBlock() {
            return this.destinationCidrBlock;
        }

        @Override
        public final java.lang.String getDestinationPortRange() {
            return this.destinationPortRange;
        }

        @Override
        public final java.lang.String getDestinationTransitGatewayAttachmentId() {
            return this.destinationTransitGatewayAttachmentId;
        }

        @Override
        public final java.lang.String getDestinationTransitGatewayAttachmentType() {
            return this.destinationTransitGatewayAttachmentType;
        }

        @Override
        public final java.lang.String getProtocol() {
            return this.protocol;
        }

        @Override
        public final java.lang.String getSourceCidrBlock() {
            return this.sourceCidrBlock;
        }

        @Override
        public final java.lang.String getSourcePortRange() {
            return this.sourcePortRange;
        }

        @Override
        public final java.lang.String getSourceTransitGatewayAttachmentId() {
            return this.sourceTransitGatewayAttachmentId;
        }

        @Override
        public final java.lang.String getSourceTransitGatewayAttachmentType() {
            return this.sourceTransitGatewayAttachmentType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("meteredAccount", om.valueToTree(this.getMeteredAccount()));
            data.set("policyRuleNumber", om.valueToTree(this.getPolicyRuleNumber()));
            data.set("transitGatewayMeteringPolicyId", om.valueToTree(this.getTransitGatewayMeteringPolicyId()));
            if (this.getDestinationCidrBlock() != null) {
                data.set("destinationCidrBlock", om.valueToTree(this.getDestinationCidrBlock()));
            }
            if (this.getDestinationPortRange() != null) {
                data.set("destinationPortRange", om.valueToTree(this.getDestinationPortRange()));
            }
            if (this.getDestinationTransitGatewayAttachmentId() != null) {
                data.set("destinationTransitGatewayAttachmentId", om.valueToTree(this.getDestinationTransitGatewayAttachmentId()));
            }
            if (this.getDestinationTransitGatewayAttachmentType() != null) {
                data.set("destinationTransitGatewayAttachmentType", om.valueToTree(this.getDestinationTransitGatewayAttachmentType()));
            }
            if (this.getProtocol() != null) {
                data.set("protocol", om.valueToTree(this.getProtocol()));
            }
            if (this.getSourceCidrBlock() != null) {
                data.set("sourceCidrBlock", om.valueToTree(this.getSourceCidrBlock()));
            }
            if (this.getSourcePortRange() != null) {
                data.set("sourcePortRange", om.valueToTree(this.getSourcePortRange()));
            }
            if (this.getSourceTransitGatewayAttachmentId() != null) {
                data.set("sourceTransitGatewayAttachmentId", om.valueToTree(this.getSourceTransitGatewayAttachmentId()));
            }
            if (this.getSourceTransitGatewayAttachmentType() != null) {
                data.set("sourceTransitGatewayAttachmentType", om.valueToTree(this.getSourceTransitGatewayAttachmentType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnTransitGatewayMeteringPolicyEntryProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTransitGatewayMeteringPolicyEntryProps.Jsii$Proxy that = (CfnTransitGatewayMeteringPolicyEntryProps.Jsii$Proxy) o;

            if (!meteredAccount.equals(that.meteredAccount)) return false;
            if (!policyRuleNumber.equals(that.policyRuleNumber)) return false;
            if (!transitGatewayMeteringPolicyId.equals(that.transitGatewayMeteringPolicyId)) return false;
            if (this.destinationCidrBlock != null ? !this.destinationCidrBlock.equals(that.destinationCidrBlock) : that.destinationCidrBlock != null) return false;
            if (this.destinationPortRange != null ? !this.destinationPortRange.equals(that.destinationPortRange) : that.destinationPortRange != null) return false;
            if (this.destinationTransitGatewayAttachmentId != null ? !this.destinationTransitGatewayAttachmentId.equals(that.destinationTransitGatewayAttachmentId) : that.destinationTransitGatewayAttachmentId != null) return false;
            if (this.destinationTransitGatewayAttachmentType != null ? !this.destinationTransitGatewayAttachmentType.equals(that.destinationTransitGatewayAttachmentType) : that.destinationTransitGatewayAttachmentType != null) return false;
            if (this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null) return false;
            if (this.sourceCidrBlock != null ? !this.sourceCidrBlock.equals(that.sourceCidrBlock) : that.sourceCidrBlock != null) return false;
            if (this.sourcePortRange != null ? !this.sourcePortRange.equals(that.sourcePortRange) : that.sourcePortRange != null) return false;
            if (this.sourceTransitGatewayAttachmentId != null ? !this.sourceTransitGatewayAttachmentId.equals(that.sourceTransitGatewayAttachmentId) : that.sourceTransitGatewayAttachmentId != null) return false;
            return this.sourceTransitGatewayAttachmentType != null ? this.sourceTransitGatewayAttachmentType.equals(that.sourceTransitGatewayAttachmentType) : that.sourceTransitGatewayAttachmentType == null;
        }

        @Override
        public final int hashCode() {
            int result = this.meteredAccount.hashCode();
            result = 31 * result + (this.policyRuleNumber.hashCode());
            result = 31 * result + (this.transitGatewayMeteringPolicyId.hashCode());
            result = 31 * result + (this.destinationCidrBlock != null ? this.destinationCidrBlock.hashCode() : 0);
            result = 31 * result + (this.destinationPortRange != null ? this.destinationPortRange.hashCode() : 0);
            result = 31 * result + (this.destinationTransitGatewayAttachmentId != null ? this.destinationTransitGatewayAttachmentId.hashCode() : 0);
            result = 31 * result + (this.destinationTransitGatewayAttachmentType != null ? this.destinationTransitGatewayAttachmentType.hashCode() : 0);
            result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
            result = 31 * result + (this.sourceCidrBlock != null ? this.sourceCidrBlock.hashCode() : 0);
            result = 31 * result + (this.sourcePortRange != null ? this.sourcePortRange.hashCode() : 0);
            result = 31 * result + (this.sourceTransitGatewayAttachmentId != null ? this.sourceTransitGatewayAttachmentId.hashCode() : 0);
            result = 31 * result + (this.sourceTransitGatewayAttachmentType != null ? this.sourceTransitGatewayAttachmentType.hashCode() : 0);
            return result;
        }
    }
}
