package software.amazon.awscdk.services.ec2;

/**
 * Describes the configuration and state of VPC encryption controls.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-encryption-controls.html">Enforce VPC encryption in transit</a> in the <em>Amazon VPC User Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnVPCEncryptionControl cfnVPCEncryptionControl = CfnVPCEncryptionControl.Builder.create(this, "MyCfnVPCEncryptionControl")
 *         .egressOnlyInternetGatewayExclusionInput("egressOnlyInternetGatewayExclusionInput")
 *         .elasticFileSystemExclusionInput("elasticFileSystemExclusionInput")
 *         .internetGatewayExclusionInput("internetGatewayExclusionInput")
 *         .lambdaExclusionInput("lambdaExclusionInput")
 *         .mode("mode")
 *         .natGatewayExclusionInput("natGatewayExclusionInput")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .virtualPrivateGatewayExclusionInput("virtualPrivateGatewayExclusionInput")
 *         .vpcId("vpcId")
 *         .vpcLatticeExclusionInput("vpcLatticeExclusionInput")
 *         .vpcPeeringExclusionInput("vpcPeeringExclusionInput")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcencryptioncontrol.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcencryptioncontrol.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:19.266Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnVPCEncryptionControl")
public class CfnVPCEncryptionControl extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.ec2.IVPCEncryptionControlRef, software.amazon.awscdk.ITaggableV2 {

    protected CfnVPCEncryptionControl(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnVPCEncryptionControl(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnVPCEncryptionControl.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::EC2::VPCEncryptionControl</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnVPCEncryptionControl(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.CfnVPCEncryptionControlProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new <code>AWS::EC2::VPCEncryptionControl</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnVPCEncryptionControl(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Checks whether the given object is a CfnVPCEncryptionControl.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isCfnVPCEncryptionControl(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.CfnVPCEncryptionControl.class, "isCfnVPCEncryptionControl", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrResourceExclusions() {
        return software.amazon.jsii.Kernel.get(this, "attrResourceExclusions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * Specifies whether to exclude egress-only internet gateway traffic from encryption enforcement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrResourceExclusionsEgressOnlyInternetGateway() {
        return software.amazon.jsii.Kernel.get(this, "attrResourceExclusionsEgressOnlyInternetGateway", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The current state of the exclusion configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrResourceExclusionsEgressOnlyInternetGatewayState() {
        return software.amazon.jsii.Kernel.get(this, "attrResourceExclusionsEgressOnlyInternetGatewayState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A message providing additional information about the exclusion state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrResourceExclusionsEgressOnlyInternetGatewayStateMessage() {
        return software.amazon.jsii.Kernel.get(this, "attrResourceExclusionsEgressOnlyInternetGatewayStateMessage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies whether to exclude Elastic File System traffic from encryption enforcement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrResourceExclusionsElasticFileSystem() {
        return software.amazon.jsii.Kernel.get(this, "attrResourceExclusionsElasticFileSystem", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The current state of the exclusion configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrResourceExclusionsElasticFileSystemState() {
        return software.amazon.jsii.Kernel.get(this, "attrResourceExclusionsElasticFileSystemState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A message providing additional information about the exclusion state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrResourceExclusionsElasticFileSystemStateMessage() {
        return software.amazon.jsii.Kernel.get(this, "attrResourceExclusionsElasticFileSystemStateMessage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies whether to exclude internet gateway traffic from encryption enforcement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrResourceExclusionsInternetGateway() {
        return software.amazon.jsii.Kernel.get(this, "attrResourceExclusionsInternetGateway", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The current state of the exclusion configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrResourceExclusionsInternetGatewayState() {
        return software.amazon.jsii.Kernel.get(this, "attrResourceExclusionsInternetGatewayState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A message providing additional information about the exclusion state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrResourceExclusionsInternetGatewayStateMessage() {
        return software.amazon.jsii.Kernel.get(this, "attrResourceExclusionsInternetGatewayStateMessage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies whether to exclude Lambda function traffic from encryption enforcement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrResourceExclusionsLambda() {
        return software.amazon.jsii.Kernel.get(this, "attrResourceExclusionsLambda", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The current state of the exclusion configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrResourceExclusionsLambdaState() {
        return software.amazon.jsii.Kernel.get(this, "attrResourceExclusionsLambdaState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A message providing additional information about the exclusion state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrResourceExclusionsLambdaStateMessage() {
        return software.amazon.jsii.Kernel.get(this, "attrResourceExclusionsLambdaStateMessage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies whether to exclude NAT gateway traffic from encryption enforcement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrResourceExclusionsNatGateway() {
        return software.amazon.jsii.Kernel.get(this, "attrResourceExclusionsNatGateway", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The current state of the exclusion configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrResourceExclusionsNatGatewayState() {
        return software.amazon.jsii.Kernel.get(this, "attrResourceExclusionsNatGatewayState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A message providing additional information about the exclusion state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrResourceExclusionsNatGatewayStateMessage() {
        return software.amazon.jsii.Kernel.get(this, "attrResourceExclusionsNatGatewayStateMessage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies whether to exclude virtual private gateway traffic from encryption enforcement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrResourceExclusionsVirtualPrivateGateway() {
        return software.amazon.jsii.Kernel.get(this, "attrResourceExclusionsVirtualPrivateGateway", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The current state of the exclusion configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrResourceExclusionsVirtualPrivateGatewayState() {
        return software.amazon.jsii.Kernel.get(this, "attrResourceExclusionsVirtualPrivateGatewayState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A message providing additional information about the exclusion state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrResourceExclusionsVirtualPrivateGatewayStateMessage() {
        return software.amazon.jsii.Kernel.get(this, "attrResourceExclusionsVirtualPrivateGatewayStateMessage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies whether to exclude VPC Lattice traffic from encryption enforcement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrResourceExclusionsVpcLattice() {
        return software.amazon.jsii.Kernel.get(this, "attrResourceExclusionsVpcLattice", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The current state of the exclusion configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrResourceExclusionsVpcLatticeState() {
        return software.amazon.jsii.Kernel.get(this, "attrResourceExclusionsVpcLatticeState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A message providing additional information about the exclusion state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrResourceExclusionsVpcLatticeStateMessage() {
        return software.amazon.jsii.Kernel.get(this, "attrResourceExclusionsVpcLatticeStateMessage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies whether to exclude VPC peering connection traffic from encryption enforcement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrResourceExclusionsVpcPeering() {
        return software.amazon.jsii.Kernel.get(this, "attrResourceExclusionsVpcPeering", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The current state of the exclusion configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrResourceExclusionsVpcPeeringState() {
        return software.amazon.jsii.Kernel.get(this, "attrResourceExclusionsVpcPeeringState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A message providing additional information about the exclusion state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrResourceExclusionsVpcPeeringStateMessage() {
        return software.amazon.jsii.Kernel.get(this, "attrResourceExclusionsVpcPeeringStateMessage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The current state of the VPC Encryption Control configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrState() {
        return software.amazon.jsii.Kernel.get(this, "attrState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A message providing additional information about the encryption control state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStateMessage() {
        return software.amazon.jsii.Kernel.get(this, "attrStateMessage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the VPC Encryption Control configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrVpcEncryptionControlId() {
        return software.amazon.jsii.Kernel.get(this, "attrVpcEncryptionControlId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a VPCEncryptionControl resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.ec2.VPCEncryptionControlReference getVpcEncryptionControlRef() {
        return software.amazon.jsii.Kernel.get(this, "vpcEncryptionControlRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.ec2.VPCEncryptionControlReference.class));
    }

    /**
     * Specifies whether to exclude egress-only internet gateway traffic from encryption enforcement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEgressOnlyInternetGatewayExclusionInput() {
        return software.amazon.jsii.Kernel.get(this, "egressOnlyInternetGatewayExclusionInput", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies whether to exclude egress-only internet gateway traffic from encryption enforcement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEgressOnlyInternetGatewayExclusionInput(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "egressOnlyInternetGatewayExclusionInput", value);
    }

    /**
     * Specifies whether to exclude Elastic File System traffic from encryption enforcement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getElasticFileSystemExclusionInput() {
        return software.amazon.jsii.Kernel.get(this, "elasticFileSystemExclusionInput", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies whether to exclude Elastic File System traffic from encryption enforcement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setElasticFileSystemExclusionInput(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "elasticFileSystemExclusionInput", value);
    }

    /**
     * Specifies whether to exclude internet gateway traffic from encryption enforcement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getInternetGatewayExclusionInput() {
        return software.amazon.jsii.Kernel.get(this, "internetGatewayExclusionInput", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies whether to exclude internet gateway traffic from encryption enforcement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInternetGatewayExclusionInput(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "internetGatewayExclusionInput", value);
    }

    /**
     * Specifies whether to exclude Lambda function traffic from encryption enforcement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLambdaExclusionInput() {
        return software.amazon.jsii.Kernel.get(this, "lambdaExclusionInput", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies whether to exclude Lambda function traffic from encryption enforcement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLambdaExclusionInput(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "lambdaExclusionInput", value);
    }

    /**
     * The encryption mode for the VPC Encryption Control configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMode() {
        return software.amazon.jsii.Kernel.get(this, "mode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The encryption mode for the VPC Encryption Control configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "mode", value);
    }

    /**
     * Specifies whether to exclude NAT gateway traffic from encryption enforcement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getNatGatewayExclusionInput() {
        return software.amazon.jsii.Kernel.get(this, "natGatewayExclusionInput", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies whether to exclude NAT gateway traffic from encryption enforcement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNatGatewayExclusionInput(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "natGatewayExclusionInput", value);
    }

    /**
     * The tags assigned to the VPC Encryption Control configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tags assigned to the VPC Encryption Control configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }

    /**
     * Specifies whether to exclude virtual private gateway traffic from encryption enforcement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getVirtualPrivateGatewayExclusionInput() {
        return software.amazon.jsii.Kernel.get(this, "virtualPrivateGatewayExclusionInput", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies whether to exclude virtual private gateway traffic from encryption enforcement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVirtualPrivateGatewayExclusionInput(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "virtualPrivateGatewayExclusionInput", value);
    }

    /**
     * The ID of the VPC for which to create the encryption control configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getVpcId() {
        return software.amazon.jsii.Kernel.get(this, "vpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the VPC for which to create the encryption control configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "vpcId", value);
    }

    /**
     * Specifies whether to exclude VPC Lattice traffic from encryption enforcement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getVpcLatticeExclusionInput() {
        return software.amazon.jsii.Kernel.get(this, "vpcLatticeExclusionInput", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies whether to exclude VPC Lattice traffic from encryption enforcement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcLatticeExclusionInput(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "vpcLatticeExclusionInput", value);
    }

    /**
     * Specifies whether to exclude VPC peering connection traffic from encryption enforcement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getVpcPeeringExclusionInput() {
        return software.amazon.jsii.Kernel.get(this, "vpcPeeringExclusionInput", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies whether to exclude VPC peering connection traffic from encryption enforcement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcPeeringExclusionInput(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "vpcPeeringExclusionInput", value);
    }
    /**
     * Information about resource exclusions for the VPC Encryption Control configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * ResourceExclusionsProperty resourceExclusionsProperty = ResourceExclusionsProperty.builder()
     *         .egressOnlyInternetGateway(VpcEncryptionControlExclusionProperty.builder()
     *                 .state("state")
     *                 .stateMessage("stateMessage")
     *                 .build())
     *         .elasticFileSystem(VpcEncryptionControlExclusionProperty.builder()
     *                 .state("state")
     *                 .stateMessage("stateMessage")
     *                 .build())
     *         .internetGateway(VpcEncryptionControlExclusionProperty.builder()
     *                 .state("state")
     *                 .stateMessage("stateMessage")
     *                 .build())
     *         .lambda(VpcEncryptionControlExclusionProperty.builder()
     *                 .state("state")
     *                 .stateMessage("stateMessage")
     *                 .build())
     *         .natGateway(VpcEncryptionControlExclusionProperty.builder()
     *                 .state("state")
     *                 .stateMessage("stateMessage")
     *                 .build())
     *         .virtualPrivateGateway(VpcEncryptionControlExclusionProperty.builder()
     *                 .state("state")
     *                 .stateMessage("stateMessage")
     *                 .build())
     *         .vpcLattice(VpcEncryptionControlExclusionProperty.builder()
     *                 .state("state")
     *                 .stateMessage("stateMessage")
     *                 .build())
     *         .vpcPeering(VpcEncryptionControlExclusionProperty.builder()
     *                 .state("state")
     *                 .stateMessage("stateMessage")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpcencryptioncontrol-resourceexclusions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpcencryptioncontrol-resourceexclusions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnVPCEncryptionControl.ResourceExclusionsProperty")
    @software.amazon.jsii.Jsii.Proxy(ResourceExclusionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResourceExclusionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether to exclude egress-only internet gateway traffic from encryption enforcement.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ec2.CfnVPCEncryptionControl.VpcEncryptionControlExclusionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpcencryptioncontrol-resourceexclusions.html#cfn-ec2-vpcencryptioncontrol-resourceexclusions-egressonlyinternetgateway">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpcencryptioncontrol-resourceexclusions.html#cfn-ec2-vpcencryptioncontrol-resourceexclusions-egressonlyinternetgateway</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEgressOnlyInternetGateway() {
            return null;
        }

        /**
         * Specifies whether to exclude Elastic File System traffic from encryption enforcement.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ec2.CfnVPCEncryptionControl.VpcEncryptionControlExclusionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpcencryptioncontrol-resourceexclusions.html#cfn-ec2-vpcencryptioncontrol-resourceexclusions-elasticfilesystem">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpcencryptioncontrol-resourceexclusions.html#cfn-ec2-vpcencryptioncontrol-resourceexclusions-elasticfilesystem</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getElasticFileSystem() {
            return null;
        }

        /**
         * Specifies whether to exclude internet gateway traffic from encryption enforcement.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ec2.CfnVPCEncryptionControl.VpcEncryptionControlExclusionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpcencryptioncontrol-resourceexclusions.html#cfn-ec2-vpcencryptioncontrol-resourceexclusions-internetgateway">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpcencryptioncontrol-resourceexclusions.html#cfn-ec2-vpcencryptioncontrol-resourceexclusions-internetgateway</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInternetGateway() {
            return null;
        }

        /**
         * Specifies whether to exclude Lambda function traffic from encryption enforcement.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ec2.CfnVPCEncryptionControl.VpcEncryptionControlExclusionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpcencryptioncontrol-resourceexclusions.html#cfn-ec2-vpcencryptioncontrol-resourceexclusions-lambda">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpcencryptioncontrol-resourceexclusions.html#cfn-ec2-vpcencryptioncontrol-resourceexclusions-lambda</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLambda() {
            return null;
        }

        /**
         * Specifies whether to exclude NAT gateway traffic from encryption enforcement.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ec2.CfnVPCEncryptionControl.VpcEncryptionControlExclusionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpcencryptioncontrol-resourceexclusions.html#cfn-ec2-vpcencryptioncontrol-resourceexclusions-natgateway">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpcencryptioncontrol-resourceexclusions.html#cfn-ec2-vpcencryptioncontrol-resourceexclusions-natgateway</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNatGateway() {
            return null;
        }

        /**
         * Specifies whether to exclude virtual private gateway traffic from encryption enforcement.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ec2.CfnVPCEncryptionControl.VpcEncryptionControlExclusionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpcencryptioncontrol-resourceexclusions.html#cfn-ec2-vpcencryptioncontrol-resourceexclusions-virtualprivategateway">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpcencryptioncontrol-resourceexclusions.html#cfn-ec2-vpcencryptioncontrol-resourceexclusions-virtualprivategateway</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVirtualPrivateGateway() {
            return null;
        }

        /**
         * Specifies whether to exclude VPC Lattice traffic from encryption enforcement.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ec2.CfnVPCEncryptionControl.VpcEncryptionControlExclusionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpcencryptioncontrol-resourceexclusions.html#cfn-ec2-vpcencryptioncontrol-resourceexclusions-vpclattice">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpcencryptioncontrol-resourceexclusions.html#cfn-ec2-vpcencryptioncontrol-resourceexclusions-vpclattice</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVpcLattice() {
            return null;
        }

        /**
         * Specifies whether to exclude VPC peering connection traffic from encryption enforcement.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ec2.CfnVPCEncryptionControl.VpcEncryptionControlExclusionProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpcencryptioncontrol-resourceexclusions.html#cfn-ec2-vpcencryptioncontrol-resourceexclusions-vpcpeering">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpcencryptioncontrol-resourceexclusions.html#cfn-ec2-vpcencryptioncontrol-resourceexclusions-vpcpeering</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVpcPeering() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ResourceExclusionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResourceExclusionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResourceExclusionsProperty> {
            java.lang.Object egressOnlyInternetGateway;
            java.lang.Object elasticFileSystem;
            java.lang.Object internetGateway;
            java.lang.Object lambda;
            java.lang.Object natGateway;
            java.lang.Object virtualPrivateGateway;
            java.lang.Object vpcLattice;
            java.lang.Object vpcPeering;

            /**
             * Sets the value of {@link ResourceExclusionsProperty#getEgressOnlyInternetGateway}
             * @param egressOnlyInternetGateway Specifies whether to exclude egress-only internet gateway traffic from encryption enforcement.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder egressOnlyInternetGateway(software.amazon.awscdk.IResolvable egressOnlyInternetGateway) {
                this.egressOnlyInternetGateway = egressOnlyInternetGateway;
                return this;
            }

            /**
             * Sets the value of {@link ResourceExclusionsProperty#getEgressOnlyInternetGateway}
             * @param egressOnlyInternetGateway Specifies whether to exclude egress-only internet gateway traffic from encryption enforcement.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder egressOnlyInternetGateway(software.amazon.awscdk.services.ec2.CfnVPCEncryptionControl.VpcEncryptionControlExclusionProperty egressOnlyInternetGateway) {
                this.egressOnlyInternetGateway = egressOnlyInternetGateway;
                return this;
            }

            /**
             * Sets the value of {@link ResourceExclusionsProperty#getElasticFileSystem}
             * @param elasticFileSystem Specifies whether to exclude Elastic File System traffic from encryption enforcement.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder elasticFileSystem(software.amazon.awscdk.IResolvable elasticFileSystem) {
                this.elasticFileSystem = elasticFileSystem;
                return this;
            }

            /**
             * Sets the value of {@link ResourceExclusionsProperty#getElasticFileSystem}
             * @param elasticFileSystem Specifies whether to exclude Elastic File System traffic from encryption enforcement.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder elasticFileSystem(software.amazon.awscdk.services.ec2.CfnVPCEncryptionControl.VpcEncryptionControlExclusionProperty elasticFileSystem) {
                this.elasticFileSystem = elasticFileSystem;
                return this;
            }

            /**
             * Sets the value of {@link ResourceExclusionsProperty#getInternetGateway}
             * @param internetGateway Specifies whether to exclude internet gateway traffic from encryption enforcement.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder internetGateway(software.amazon.awscdk.IResolvable internetGateway) {
                this.internetGateway = internetGateway;
                return this;
            }

            /**
             * Sets the value of {@link ResourceExclusionsProperty#getInternetGateway}
             * @param internetGateway Specifies whether to exclude internet gateway traffic from encryption enforcement.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder internetGateway(software.amazon.awscdk.services.ec2.CfnVPCEncryptionControl.VpcEncryptionControlExclusionProperty internetGateway) {
                this.internetGateway = internetGateway;
                return this;
            }

            /**
             * Sets the value of {@link ResourceExclusionsProperty#getLambda}
             * @param lambda Specifies whether to exclude Lambda function traffic from encryption enforcement.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambda(software.amazon.awscdk.IResolvable lambda) {
                this.lambda = lambda;
                return this;
            }

            /**
             * Sets the value of {@link ResourceExclusionsProperty#getLambda}
             * @param lambda Specifies whether to exclude Lambda function traffic from encryption enforcement.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambda(software.amazon.awscdk.services.ec2.CfnVPCEncryptionControl.VpcEncryptionControlExclusionProperty lambda) {
                this.lambda = lambda;
                return this;
            }

            /**
             * Sets the value of {@link ResourceExclusionsProperty#getNatGateway}
             * @param natGateway Specifies whether to exclude NAT gateway traffic from encryption enforcement.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder natGateway(software.amazon.awscdk.IResolvable natGateway) {
                this.natGateway = natGateway;
                return this;
            }

            /**
             * Sets the value of {@link ResourceExclusionsProperty#getNatGateway}
             * @param natGateway Specifies whether to exclude NAT gateway traffic from encryption enforcement.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder natGateway(software.amazon.awscdk.services.ec2.CfnVPCEncryptionControl.VpcEncryptionControlExclusionProperty natGateway) {
                this.natGateway = natGateway;
                return this;
            }

            /**
             * Sets the value of {@link ResourceExclusionsProperty#getVirtualPrivateGateway}
             * @param virtualPrivateGateway Specifies whether to exclude virtual private gateway traffic from encryption enforcement.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder virtualPrivateGateway(software.amazon.awscdk.IResolvable virtualPrivateGateway) {
                this.virtualPrivateGateway = virtualPrivateGateway;
                return this;
            }

            /**
             * Sets the value of {@link ResourceExclusionsProperty#getVirtualPrivateGateway}
             * @param virtualPrivateGateway Specifies whether to exclude virtual private gateway traffic from encryption enforcement.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder virtualPrivateGateway(software.amazon.awscdk.services.ec2.CfnVPCEncryptionControl.VpcEncryptionControlExclusionProperty virtualPrivateGateway) {
                this.virtualPrivateGateway = virtualPrivateGateway;
                return this;
            }

            /**
             * Sets the value of {@link ResourceExclusionsProperty#getVpcLattice}
             * @param vpcLattice Specifies whether to exclude VPC Lattice traffic from encryption enforcement.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcLattice(software.amazon.awscdk.IResolvable vpcLattice) {
                this.vpcLattice = vpcLattice;
                return this;
            }

            /**
             * Sets the value of {@link ResourceExclusionsProperty#getVpcLattice}
             * @param vpcLattice Specifies whether to exclude VPC Lattice traffic from encryption enforcement.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcLattice(software.amazon.awscdk.services.ec2.CfnVPCEncryptionControl.VpcEncryptionControlExclusionProperty vpcLattice) {
                this.vpcLattice = vpcLattice;
                return this;
            }

            /**
             * Sets the value of {@link ResourceExclusionsProperty#getVpcPeering}
             * @param vpcPeering Specifies whether to exclude VPC peering connection traffic from encryption enforcement.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcPeering(software.amazon.awscdk.IResolvable vpcPeering) {
                this.vpcPeering = vpcPeering;
                return this;
            }

            /**
             * Sets the value of {@link ResourceExclusionsProperty#getVpcPeering}
             * @param vpcPeering Specifies whether to exclude VPC peering connection traffic from encryption enforcement.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcPeering(software.amazon.awscdk.services.ec2.CfnVPCEncryptionControl.VpcEncryptionControlExclusionProperty vpcPeering) {
                this.vpcPeering = vpcPeering;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResourceExclusionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResourceExclusionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResourceExclusionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourceExclusionsProperty {
            private final java.lang.Object egressOnlyInternetGateway;
            private final java.lang.Object elasticFileSystem;
            private final java.lang.Object internetGateway;
            private final java.lang.Object lambda;
            private final java.lang.Object natGateway;
            private final java.lang.Object virtualPrivateGateway;
            private final java.lang.Object vpcLattice;
            private final java.lang.Object vpcPeering;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.egressOnlyInternetGateway = software.amazon.jsii.Kernel.get(this, "egressOnlyInternetGateway", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.elasticFileSystem = software.amazon.jsii.Kernel.get(this, "elasticFileSystem", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.internetGateway = software.amazon.jsii.Kernel.get(this, "internetGateway", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lambda = software.amazon.jsii.Kernel.get(this, "lambda", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.natGateway = software.amazon.jsii.Kernel.get(this, "natGateway", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.virtualPrivateGateway = software.amazon.jsii.Kernel.get(this, "virtualPrivateGateway", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.vpcLattice = software.amazon.jsii.Kernel.get(this, "vpcLattice", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.vpcPeering = software.amazon.jsii.Kernel.get(this, "vpcPeering", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.egressOnlyInternetGateway = builder.egressOnlyInternetGateway;
                this.elasticFileSystem = builder.elasticFileSystem;
                this.internetGateway = builder.internetGateway;
                this.lambda = builder.lambda;
                this.natGateway = builder.natGateway;
                this.virtualPrivateGateway = builder.virtualPrivateGateway;
                this.vpcLattice = builder.vpcLattice;
                this.vpcPeering = builder.vpcPeering;
            }

            @Override
            public final java.lang.Object getEgressOnlyInternetGateway() {
                return this.egressOnlyInternetGateway;
            }

            @Override
            public final java.lang.Object getElasticFileSystem() {
                return this.elasticFileSystem;
            }

            @Override
            public final java.lang.Object getInternetGateway() {
                return this.internetGateway;
            }

            @Override
            public final java.lang.Object getLambda() {
                return this.lambda;
            }

            @Override
            public final java.lang.Object getNatGateway() {
                return this.natGateway;
            }

            @Override
            public final java.lang.Object getVirtualPrivateGateway() {
                return this.virtualPrivateGateway;
            }

            @Override
            public final java.lang.Object getVpcLattice() {
                return this.vpcLattice;
            }

            @Override
            public final java.lang.Object getVpcPeering() {
                return this.vpcPeering;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEgressOnlyInternetGateway() != null) {
                    data.set("egressOnlyInternetGateway", om.valueToTree(this.getEgressOnlyInternetGateway()));
                }
                if (this.getElasticFileSystem() != null) {
                    data.set("elasticFileSystem", om.valueToTree(this.getElasticFileSystem()));
                }
                if (this.getInternetGateway() != null) {
                    data.set("internetGateway", om.valueToTree(this.getInternetGateway()));
                }
                if (this.getLambda() != null) {
                    data.set("lambda", om.valueToTree(this.getLambda()));
                }
                if (this.getNatGateway() != null) {
                    data.set("natGateway", om.valueToTree(this.getNatGateway()));
                }
                if (this.getVirtualPrivateGateway() != null) {
                    data.set("virtualPrivateGateway", om.valueToTree(this.getVirtualPrivateGateway()));
                }
                if (this.getVpcLattice() != null) {
                    data.set("vpcLattice", om.valueToTree(this.getVpcLattice()));
                }
                if (this.getVpcPeering() != null) {
                    data.set("vpcPeering", om.valueToTree(this.getVpcPeering()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnVPCEncryptionControl.ResourceExclusionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResourceExclusionsProperty.Jsii$Proxy that = (ResourceExclusionsProperty.Jsii$Proxy) o;

                if (this.egressOnlyInternetGateway != null ? !this.egressOnlyInternetGateway.equals(that.egressOnlyInternetGateway) : that.egressOnlyInternetGateway != null) return false;
                if (this.elasticFileSystem != null ? !this.elasticFileSystem.equals(that.elasticFileSystem) : that.elasticFileSystem != null) return false;
                if (this.internetGateway != null ? !this.internetGateway.equals(that.internetGateway) : that.internetGateway != null) return false;
                if (this.lambda != null ? !this.lambda.equals(that.lambda) : that.lambda != null) return false;
                if (this.natGateway != null ? !this.natGateway.equals(that.natGateway) : that.natGateway != null) return false;
                if (this.virtualPrivateGateway != null ? !this.virtualPrivateGateway.equals(that.virtualPrivateGateway) : that.virtualPrivateGateway != null) return false;
                if (this.vpcLattice != null ? !this.vpcLattice.equals(that.vpcLattice) : that.vpcLattice != null) return false;
                return this.vpcPeering != null ? this.vpcPeering.equals(that.vpcPeering) : that.vpcPeering == null;
            }

            @Override
            public final int hashCode() {
                int result = this.egressOnlyInternetGateway != null ? this.egressOnlyInternetGateway.hashCode() : 0;
                result = 31 * result + (this.elasticFileSystem != null ? this.elasticFileSystem.hashCode() : 0);
                result = 31 * result + (this.internetGateway != null ? this.internetGateway.hashCode() : 0);
                result = 31 * result + (this.lambda != null ? this.lambda.hashCode() : 0);
                result = 31 * result + (this.natGateway != null ? this.natGateway.hashCode() : 0);
                result = 31 * result + (this.virtualPrivateGateway != null ? this.virtualPrivateGateway.hashCode() : 0);
                result = 31 * result + (this.vpcLattice != null ? this.vpcLattice.hashCode() : 0);
                result = 31 * result + (this.vpcPeering != null ? this.vpcPeering.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes an exclusion configuration for VPC Encryption Control.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/vpc-encryption-controls.html">Enforce VPC encryption in transit</a> in the <em>Amazon VPC User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * VpcEncryptionControlExclusionProperty vpcEncryptionControlExclusionProperty = VpcEncryptionControlExclusionProperty.builder()
     *         .state("state")
     *         .stateMessage("stateMessage")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpcencryptioncontrol-vpcencryptioncontrolexclusion.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpcencryptioncontrol-vpcencryptioncontrolexclusion.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnVPCEncryptionControl.VpcEncryptionControlExclusionProperty")
    @software.amazon.jsii.Jsii.Proxy(VpcEncryptionControlExclusionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VpcEncryptionControlExclusionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The current state of the exclusion configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpcencryptioncontrol-vpcencryptioncontrolexclusion.html#cfn-ec2-vpcencryptioncontrol-vpcencryptioncontrolexclusion-state">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpcencryptioncontrol-vpcencryptioncontrolexclusion.html#cfn-ec2-vpcencryptioncontrol-vpcencryptioncontrolexclusion-state</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getState() {
            return null;
        }

        /**
         * A message providing additional information about the exclusion state.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpcencryptioncontrol-vpcencryptioncontrolexclusion.html#cfn-ec2-vpcencryptioncontrol-vpcencryptioncontrolexclusion-statemessage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpcencryptioncontrol-vpcencryptioncontrolexclusion.html#cfn-ec2-vpcencryptioncontrol-vpcencryptioncontrolexclusion-statemessage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStateMessage() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VpcEncryptionControlExclusionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VpcEncryptionControlExclusionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VpcEncryptionControlExclusionProperty> {
            java.lang.String state;
            java.lang.String stateMessage;

            /**
             * Sets the value of {@link VpcEncryptionControlExclusionProperty#getState}
             * @param state The current state of the exclusion configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder state(java.lang.String state) {
                this.state = state;
                return this;
            }

            /**
             * Sets the value of {@link VpcEncryptionControlExclusionProperty#getStateMessage}
             * @param stateMessage A message providing additional information about the exclusion state.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stateMessage(java.lang.String stateMessage) {
                this.stateMessage = stateMessage;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VpcEncryptionControlExclusionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VpcEncryptionControlExclusionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VpcEncryptionControlExclusionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcEncryptionControlExclusionProperty {
            private final java.lang.String state;
            private final java.lang.String stateMessage;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.state = software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.stateMessage = software.amazon.jsii.Kernel.get(this, "stateMessage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.state = builder.state;
                this.stateMessage = builder.stateMessage;
            }

            @Override
            public final java.lang.String getState() {
                return this.state;
            }

            @Override
            public final java.lang.String getStateMessage() {
                return this.stateMessage;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getState() != null) {
                    data.set("state", om.valueToTree(this.getState()));
                }
                if (this.getStateMessage() != null) {
                    data.set("stateMessage", om.valueToTree(this.getStateMessage()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnVPCEncryptionControl.VpcEncryptionControlExclusionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VpcEncryptionControlExclusionProperty.Jsii$Proxy that = (VpcEncryptionControlExclusionProperty.Jsii$Proxy) o;

                if (this.state != null ? !this.state.equals(that.state) : that.state != null) return false;
                return this.stateMessage != null ? this.stateMessage.equals(that.stateMessage) : that.stateMessage == null;
            }

            @Override
            public final int hashCode() {
                int result = this.state != null ? this.state.hashCode() : 0;
                result = 31 * result + (this.stateMessage != null ? this.stateMessage.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.CfnVPCEncryptionControl}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.CfnVPCEncryptionControl> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.ec2.CfnVPCEncryptionControlProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Specifies whether to exclude egress-only internet gateway traffic from encryption enforcement.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcencryptioncontrol.html#cfn-ec2-vpcencryptioncontrol-egressonlyinternetgatewayexclusioninput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcencryptioncontrol.html#cfn-ec2-vpcencryptioncontrol-egressonlyinternetgatewayexclusioninput</a>
         * @param egressOnlyInternetGatewayExclusionInput Specifies whether to exclude egress-only internet gateway traffic from encryption enforcement. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder egressOnlyInternetGatewayExclusionInput(final java.lang.String egressOnlyInternetGatewayExclusionInput) {
            this.props().egressOnlyInternetGatewayExclusionInput(egressOnlyInternetGatewayExclusionInput);
            return this;
        }

        /**
         * Specifies whether to exclude Elastic File System traffic from encryption enforcement.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcencryptioncontrol.html#cfn-ec2-vpcencryptioncontrol-elasticfilesystemexclusioninput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcencryptioncontrol.html#cfn-ec2-vpcencryptioncontrol-elasticfilesystemexclusioninput</a>
         * @param elasticFileSystemExclusionInput Specifies whether to exclude Elastic File System traffic from encryption enforcement. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder elasticFileSystemExclusionInput(final java.lang.String elasticFileSystemExclusionInput) {
            this.props().elasticFileSystemExclusionInput(elasticFileSystemExclusionInput);
            return this;
        }

        /**
         * Specifies whether to exclude internet gateway traffic from encryption enforcement.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcencryptioncontrol.html#cfn-ec2-vpcencryptioncontrol-internetgatewayexclusioninput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcencryptioncontrol.html#cfn-ec2-vpcencryptioncontrol-internetgatewayexclusioninput</a>
         * @param internetGatewayExclusionInput Specifies whether to exclude internet gateway traffic from encryption enforcement. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder internetGatewayExclusionInput(final java.lang.String internetGatewayExclusionInput) {
            this.props().internetGatewayExclusionInput(internetGatewayExclusionInput);
            return this;
        }

        /**
         * Specifies whether to exclude Lambda function traffic from encryption enforcement.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcencryptioncontrol.html#cfn-ec2-vpcencryptioncontrol-lambdaexclusioninput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcencryptioncontrol.html#cfn-ec2-vpcencryptioncontrol-lambdaexclusioninput</a>
         * @param lambdaExclusionInput Specifies whether to exclude Lambda function traffic from encryption enforcement. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lambdaExclusionInput(final java.lang.String lambdaExclusionInput) {
            this.props().lambdaExclusionInput(lambdaExclusionInput);
            return this;
        }

        /**
         * The encryption mode for the VPC Encryption Control configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcencryptioncontrol.html#cfn-ec2-vpcencryptioncontrol-mode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcencryptioncontrol.html#cfn-ec2-vpcencryptioncontrol-mode</a>
         * @param mode The encryption mode for the VPC Encryption Control configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mode(final java.lang.String mode) {
            this.props().mode(mode);
            return this;
        }

        /**
         * Specifies whether to exclude NAT gateway traffic from encryption enforcement.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcencryptioncontrol.html#cfn-ec2-vpcencryptioncontrol-natgatewayexclusioninput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcencryptioncontrol.html#cfn-ec2-vpcencryptioncontrol-natgatewayexclusioninput</a>
         * @param natGatewayExclusionInput Specifies whether to exclude NAT gateway traffic from encryption enforcement. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder natGatewayExclusionInput(final java.lang.String natGatewayExclusionInput) {
            this.props().natGatewayExclusionInput(natGatewayExclusionInput);
            return this;
        }

        /**
         * The tags assigned to the VPC Encryption Control configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcencryptioncontrol.html#cfn-ec2-vpcencryptioncontrol-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcencryptioncontrol.html#cfn-ec2-vpcencryptioncontrol-tags</a>
         * @param tags The tags assigned to the VPC Encryption Control configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * Specifies whether to exclude virtual private gateway traffic from encryption enforcement.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcencryptioncontrol.html#cfn-ec2-vpcencryptioncontrol-virtualprivategatewayexclusioninput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcencryptioncontrol.html#cfn-ec2-vpcencryptioncontrol-virtualprivategatewayexclusioninput</a>
         * @param virtualPrivateGatewayExclusionInput Specifies whether to exclude virtual private gateway traffic from encryption enforcement. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder virtualPrivateGatewayExclusionInput(final java.lang.String virtualPrivateGatewayExclusionInput) {
            this.props().virtualPrivateGatewayExclusionInput(virtualPrivateGatewayExclusionInput);
            return this;
        }

        /**
         * The ID of the VPC for which to create the encryption control configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcencryptioncontrol.html#cfn-ec2-vpcencryptioncontrol-vpcid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcencryptioncontrol.html#cfn-ec2-vpcencryptioncontrol-vpcid</a>
         * @param vpcId The ID of the VPC for which to create the encryption control configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcId(final java.lang.String vpcId) {
            this.props().vpcId(vpcId);
            return this;
        }

        /**
         * Specifies whether to exclude VPC Lattice traffic from encryption enforcement.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcencryptioncontrol.html#cfn-ec2-vpcencryptioncontrol-vpclatticeexclusioninput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcencryptioncontrol.html#cfn-ec2-vpcencryptioncontrol-vpclatticeexclusioninput</a>
         * @param vpcLatticeExclusionInput Specifies whether to exclude VPC Lattice traffic from encryption enforcement. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcLatticeExclusionInput(final java.lang.String vpcLatticeExclusionInput) {
            this.props().vpcLatticeExclusionInput(vpcLatticeExclusionInput);
            return this;
        }

        /**
         * Specifies whether to exclude VPC peering connection traffic from encryption enforcement.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcencryptioncontrol.html#cfn-ec2-vpcencryptioncontrol-vpcpeeringexclusioninput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcencryptioncontrol.html#cfn-ec2-vpcencryptioncontrol-vpcpeeringexclusioninput</a>
         * @param vpcPeeringExclusionInput Specifies whether to exclude VPC peering connection traffic from encryption enforcement. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcPeeringExclusionInput(final java.lang.String vpcPeeringExclusionInput) {
            this.props().vpcPeeringExclusionInput(vpcPeeringExclusionInput);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ec2.CfnVPCEncryptionControl}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.CfnVPCEncryptionControl build() {
            return new software.amazon.awscdk.services.ec2.CfnVPCEncryptionControl(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ec2.CfnVPCEncryptionControlProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ec2.CfnVPCEncryptionControlProps.Builder();
            }
            return this.props;
        }
    }
}
