package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a <code>CfnVPCEncryptionControl</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnVPCEncryptionControlProps cfnVPCEncryptionControlProps = CfnVPCEncryptionControlProps.builder()
 *         .egressOnlyInternetGatewayExclusionInput("egressOnlyInternetGatewayExclusionInput")
 *         .elasticFileSystemExclusionInput("elasticFileSystemExclusionInput")
 *         .internetGatewayExclusionInput("internetGatewayExclusionInput")
 *         .lambdaExclusionInput("lambdaExclusionInput")
 *         .mode("mode")
 *         .natGatewayExclusionInput("natGatewayExclusionInput")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .virtualPrivateGatewayExclusionInput("virtualPrivateGatewayExclusionInput")
 *         .vpcId("vpcId")
 *         .vpcLatticeExclusionInput("vpcLatticeExclusionInput")
 *         .vpcPeeringExclusionInput("vpcPeeringExclusionInput")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcencryptioncontrol.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcencryptioncontrol.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:19.268Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnVPCEncryptionControlProps")
@software.amazon.jsii.Jsii.Proxy(CfnVPCEncryptionControlProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnVPCEncryptionControlProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies whether to exclude egress-only internet gateway traffic from encryption enforcement.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcencryptioncontrol.html#cfn-ec2-vpcencryptioncontrol-egressonlyinternetgatewayexclusioninput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcencryptioncontrol.html#cfn-ec2-vpcencryptioncontrol-egressonlyinternetgatewayexclusioninput</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEgressOnlyInternetGatewayExclusionInput() {
        return null;
    }

    /**
     * Specifies whether to exclude Elastic File System traffic from encryption enforcement.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcencryptioncontrol.html#cfn-ec2-vpcencryptioncontrol-elasticfilesystemexclusioninput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcencryptioncontrol.html#cfn-ec2-vpcencryptioncontrol-elasticfilesystemexclusioninput</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getElasticFileSystemExclusionInput() {
        return null;
    }

    /**
     * Specifies whether to exclude internet gateway traffic from encryption enforcement.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcencryptioncontrol.html#cfn-ec2-vpcencryptioncontrol-internetgatewayexclusioninput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcencryptioncontrol.html#cfn-ec2-vpcencryptioncontrol-internetgatewayexclusioninput</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInternetGatewayExclusionInput() {
        return null;
    }

    /**
     * Specifies whether to exclude Lambda function traffic from encryption enforcement.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcencryptioncontrol.html#cfn-ec2-vpcencryptioncontrol-lambdaexclusioninput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcencryptioncontrol.html#cfn-ec2-vpcencryptioncontrol-lambdaexclusioninput</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLambdaExclusionInput() {
        return null;
    }

    /**
     * The encryption mode for the VPC Encryption Control configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcencryptioncontrol.html#cfn-ec2-vpcencryptioncontrol-mode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcencryptioncontrol.html#cfn-ec2-vpcencryptioncontrol-mode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMode() {
        return null;
    }

    /**
     * Specifies whether to exclude NAT gateway traffic from encryption enforcement.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcencryptioncontrol.html#cfn-ec2-vpcencryptioncontrol-natgatewayexclusioninput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcencryptioncontrol.html#cfn-ec2-vpcencryptioncontrol-natgatewayexclusioninput</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getNatGatewayExclusionInput() {
        return null;
    }

    /**
     * The tags assigned to the VPC Encryption Control configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcencryptioncontrol.html#cfn-ec2-vpcencryptioncontrol-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcencryptioncontrol.html#cfn-ec2-vpcencryptioncontrol-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * Specifies whether to exclude virtual private gateway traffic from encryption enforcement.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcencryptioncontrol.html#cfn-ec2-vpcencryptioncontrol-virtualprivategatewayexclusioninput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcencryptioncontrol.html#cfn-ec2-vpcencryptioncontrol-virtualprivategatewayexclusioninput</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVirtualPrivateGatewayExclusionInput() {
        return null;
    }

    /**
     * The ID of the VPC for which to create the encryption control configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcencryptioncontrol.html#cfn-ec2-vpcencryptioncontrol-vpcid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcencryptioncontrol.html#cfn-ec2-vpcencryptioncontrol-vpcid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVpcId() {
        return null;
    }

    /**
     * Specifies whether to exclude VPC Lattice traffic from encryption enforcement.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcencryptioncontrol.html#cfn-ec2-vpcencryptioncontrol-vpclatticeexclusioninput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcencryptioncontrol.html#cfn-ec2-vpcencryptioncontrol-vpclatticeexclusioninput</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVpcLatticeExclusionInput() {
        return null;
    }

    /**
     * Specifies whether to exclude VPC peering connection traffic from encryption enforcement.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcencryptioncontrol.html#cfn-ec2-vpcencryptioncontrol-vpcpeeringexclusioninput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcencryptioncontrol.html#cfn-ec2-vpcencryptioncontrol-vpcpeeringexclusioninput</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVpcPeeringExclusionInput() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnVPCEncryptionControlProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnVPCEncryptionControlProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnVPCEncryptionControlProps> {
        java.lang.String egressOnlyInternetGatewayExclusionInput;
        java.lang.String elasticFileSystemExclusionInput;
        java.lang.String internetGatewayExclusionInput;
        java.lang.String lambdaExclusionInput;
        java.lang.String mode;
        java.lang.String natGatewayExclusionInput;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String virtualPrivateGatewayExclusionInput;
        java.lang.String vpcId;
        java.lang.String vpcLatticeExclusionInput;
        java.lang.String vpcPeeringExclusionInput;

        /**
         * Sets the value of {@link CfnVPCEncryptionControlProps#getEgressOnlyInternetGatewayExclusionInput}
         * @param egressOnlyInternetGatewayExclusionInput Specifies whether to exclude egress-only internet gateway traffic from encryption enforcement.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder egressOnlyInternetGatewayExclusionInput(java.lang.String egressOnlyInternetGatewayExclusionInput) {
            this.egressOnlyInternetGatewayExclusionInput = egressOnlyInternetGatewayExclusionInput;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCEncryptionControlProps#getElasticFileSystemExclusionInput}
         * @param elasticFileSystemExclusionInput Specifies whether to exclude Elastic File System traffic from encryption enforcement.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder elasticFileSystemExclusionInput(java.lang.String elasticFileSystemExclusionInput) {
            this.elasticFileSystemExclusionInput = elasticFileSystemExclusionInput;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCEncryptionControlProps#getInternetGatewayExclusionInput}
         * @param internetGatewayExclusionInput Specifies whether to exclude internet gateway traffic from encryption enforcement.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder internetGatewayExclusionInput(java.lang.String internetGatewayExclusionInput) {
            this.internetGatewayExclusionInput = internetGatewayExclusionInput;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCEncryptionControlProps#getLambdaExclusionInput}
         * @param lambdaExclusionInput Specifies whether to exclude Lambda function traffic from encryption enforcement.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lambdaExclusionInput(java.lang.String lambdaExclusionInput) {
            this.lambdaExclusionInput = lambdaExclusionInput;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCEncryptionControlProps#getMode}
         * @param mode The encryption mode for the VPC Encryption Control configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mode(java.lang.String mode) {
            this.mode = mode;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCEncryptionControlProps#getNatGatewayExclusionInput}
         * @param natGatewayExclusionInput Specifies whether to exclude NAT gateway traffic from encryption enforcement.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder natGatewayExclusionInput(java.lang.String natGatewayExclusionInput) {
            this.natGatewayExclusionInput = natGatewayExclusionInput;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCEncryptionControlProps#getTags}
         * @param tags The tags assigned to the VPC Encryption Control configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCEncryptionControlProps#getVirtualPrivateGatewayExclusionInput}
         * @param virtualPrivateGatewayExclusionInput Specifies whether to exclude virtual private gateway traffic from encryption enforcement.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder virtualPrivateGatewayExclusionInput(java.lang.String virtualPrivateGatewayExclusionInput) {
            this.virtualPrivateGatewayExclusionInput = virtualPrivateGatewayExclusionInput;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCEncryptionControlProps#getVpcId}
         * @param vpcId The ID of the VPC for which to create the encryption control configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcId(java.lang.String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCEncryptionControlProps#getVpcLatticeExclusionInput}
         * @param vpcLatticeExclusionInput Specifies whether to exclude VPC Lattice traffic from encryption enforcement.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcLatticeExclusionInput(java.lang.String vpcLatticeExclusionInput) {
            this.vpcLatticeExclusionInput = vpcLatticeExclusionInput;
            return this;
        }

        /**
         * Sets the value of {@link CfnVPCEncryptionControlProps#getVpcPeeringExclusionInput}
         * @param vpcPeeringExclusionInput Specifies whether to exclude VPC peering connection traffic from encryption enforcement.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcPeeringExclusionInput(java.lang.String vpcPeeringExclusionInput) {
            this.vpcPeeringExclusionInput = vpcPeeringExclusionInput;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnVPCEncryptionControlProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnVPCEncryptionControlProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnVPCEncryptionControlProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnVPCEncryptionControlProps {
        private final java.lang.String egressOnlyInternetGatewayExclusionInput;
        private final java.lang.String elasticFileSystemExclusionInput;
        private final java.lang.String internetGatewayExclusionInput;
        private final java.lang.String lambdaExclusionInput;
        private final java.lang.String mode;
        private final java.lang.String natGatewayExclusionInput;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String virtualPrivateGatewayExclusionInput;
        private final java.lang.String vpcId;
        private final java.lang.String vpcLatticeExclusionInput;
        private final java.lang.String vpcPeeringExclusionInput;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.egressOnlyInternetGatewayExclusionInput = software.amazon.jsii.Kernel.get(this, "egressOnlyInternetGatewayExclusionInput", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.elasticFileSystemExclusionInput = software.amazon.jsii.Kernel.get(this, "elasticFileSystemExclusionInput", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.internetGatewayExclusionInput = software.amazon.jsii.Kernel.get(this, "internetGatewayExclusionInput", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.lambdaExclusionInput = software.amazon.jsii.Kernel.get(this, "lambdaExclusionInput", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.mode = software.amazon.jsii.Kernel.get(this, "mode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.natGatewayExclusionInput = software.amazon.jsii.Kernel.get(this, "natGatewayExclusionInput", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.virtualPrivateGatewayExclusionInput = software.amazon.jsii.Kernel.get(this, "virtualPrivateGatewayExclusionInput", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vpcId = software.amazon.jsii.Kernel.get(this, "vpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vpcLatticeExclusionInput = software.amazon.jsii.Kernel.get(this, "vpcLatticeExclusionInput", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vpcPeeringExclusionInput = software.amazon.jsii.Kernel.get(this, "vpcPeeringExclusionInput", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.egressOnlyInternetGatewayExclusionInput = builder.egressOnlyInternetGatewayExclusionInput;
            this.elasticFileSystemExclusionInput = builder.elasticFileSystemExclusionInput;
            this.internetGatewayExclusionInput = builder.internetGatewayExclusionInput;
            this.lambdaExclusionInput = builder.lambdaExclusionInput;
            this.mode = builder.mode;
            this.natGatewayExclusionInput = builder.natGatewayExclusionInput;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.virtualPrivateGatewayExclusionInput = builder.virtualPrivateGatewayExclusionInput;
            this.vpcId = builder.vpcId;
            this.vpcLatticeExclusionInput = builder.vpcLatticeExclusionInput;
            this.vpcPeeringExclusionInput = builder.vpcPeeringExclusionInput;
        }

        @Override
        public final java.lang.String getEgressOnlyInternetGatewayExclusionInput() {
            return this.egressOnlyInternetGatewayExclusionInput;
        }

        @Override
        public final java.lang.String getElasticFileSystemExclusionInput() {
            return this.elasticFileSystemExclusionInput;
        }

        @Override
        public final java.lang.String getInternetGatewayExclusionInput() {
            return this.internetGatewayExclusionInput;
        }

        @Override
        public final java.lang.String getLambdaExclusionInput() {
            return this.lambdaExclusionInput;
        }

        @Override
        public final java.lang.String getMode() {
            return this.mode;
        }

        @Override
        public final java.lang.String getNatGatewayExclusionInput() {
            return this.natGatewayExclusionInput;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getVirtualPrivateGatewayExclusionInput() {
            return this.virtualPrivateGatewayExclusionInput;
        }

        @Override
        public final java.lang.String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final java.lang.String getVpcLatticeExclusionInput() {
            return this.vpcLatticeExclusionInput;
        }

        @Override
        public final java.lang.String getVpcPeeringExclusionInput() {
            return this.vpcPeeringExclusionInput;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getEgressOnlyInternetGatewayExclusionInput() != null) {
                data.set("egressOnlyInternetGatewayExclusionInput", om.valueToTree(this.getEgressOnlyInternetGatewayExclusionInput()));
            }
            if (this.getElasticFileSystemExclusionInput() != null) {
                data.set("elasticFileSystemExclusionInput", om.valueToTree(this.getElasticFileSystemExclusionInput()));
            }
            if (this.getInternetGatewayExclusionInput() != null) {
                data.set("internetGatewayExclusionInput", om.valueToTree(this.getInternetGatewayExclusionInput()));
            }
            if (this.getLambdaExclusionInput() != null) {
                data.set("lambdaExclusionInput", om.valueToTree(this.getLambdaExclusionInput()));
            }
            if (this.getMode() != null) {
                data.set("mode", om.valueToTree(this.getMode()));
            }
            if (this.getNatGatewayExclusionInput() != null) {
                data.set("natGatewayExclusionInput", om.valueToTree(this.getNatGatewayExclusionInput()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVirtualPrivateGatewayExclusionInput() != null) {
                data.set("virtualPrivateGatewayExclusionInput", om.valueToTree(this.getVirtualPrivateGatewayExclusionInput()));
            }
            if (this.getVpcId() != null) {
                data.set("vpcId", om.valueToTree(this.getVpcId()));
            }
            if (this.getVpcLatticeExclusionInput() != null) {
                data.set("vpcLatticeExclusionInput", om.valueToTree(this.getVpcLatticeExclusionInput()));
            }
            if (this.getVpcPeeringExclusionInput() != null) {
                data.set("vpcPeeringExclusionInput", om.valueToTree(this.getVpcPeeringExclusionInput()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnVPCEncryptionControlProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnVPCEncryptionControlProps.Jsii$Proxy that = (CfnVPCEncryptionControlProps.Jsii$Proxy) o;

            if (this.egressOnlyInternetGatewayExclusionInput != null ? !this.egressOnlyInternetGatewayExclusionInput.equals(that.egressOnlyInternetGatewayExclusionInput) : that.egressOnlyInternetGatewayExclusionInput != null) return false;
            if (this.elasticFileSystemExclusionInput != null ? !this.elasticFileSystemExclusionInput.equals(that.elasticFileSystemExclusionInput) : that.elasticFileSystemExclusionInput != null) return false;
            if (this.internetGatewayExclusionInput != null ? !this.internetGatewayExclusionInput.equals(that.internetGatewayExclusionInput) : that.internetGatewayExclusionInput != null) return false;
            if (this.lambdaExclusionInput != null ? !this.lambdaExclusionInput.equals(that.lambdaExclusionInput) : that.lambdaExclusionInput != null) return false;
            if (this.mode != null ? !this.mode.equals(that.mode) : that.mode != null) return false;
            if (this.natGatewayExclusionInput != null ? !this.natGatewayExclusionInput.equals(that.natGatewayExclusionInput) : that.natGatewayExclusionInput != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.virtualPrivateGatewayExclusionInput != null ? !this.virtualPrivateGatewayExclusionInput.equals(that.virtualPrivateGatewayExclusionInput) : that.virtualPrivateGatewayExclusionInput != null) return false;
            if (this.vpcId != null ? !this.vpcId.equals(that.vpcId) : that.vpcId != null) return false;
            if (this.vpcLatticeExclusionInput != null ? !this.vpcLatticeExclusionInput.equals(that.vpcLatticeExclusionInput) : that.vpcLatticeExclusionInput != null) return false;
            return this.vpcPeeringExclusionInput != null ? this.vpcPeeringExclusionInput.equals(that.vpcPeeringExclusionInput) : that.vpcPeeringExclusionInput == null;
        }

        @Override
        public final int hashCode() {
            int result = this.egressOnlyInternetGatewayExclusionInput != null ? this.egressOnlyInternetGatewayExclusionInput.hashCode() : 0;
            result = 31 * result + (this.elasticFileSystemExclusionInput != null ? this.elasticFileSystemExclusionInput.hashCode() : 0);
            result = 31 * result + (this.internetGatewayExclusionInput != null ? this.internetGatewayExclusionInput.hashCode() : 0);
            result = 31 * result + (this.lambdaExclusionInput != null ? this.lambdaExclusionInput.hashCode() : 0);
            result = 31 * result + (this.mode != null ? this.mode.hashCode() : 0);
            result = 31 * result + (this.natGatewayExclusionInput != null ? this.natGatewayExclusionInput.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.virtualPrivateGatewayExclusionInput != null ? this.virtualPrivateGatewayExclusionInput.hashCode() : 0);
            result = 31 * result + (this.vpcId != null ? this.vpcId.hashCode() : 0);
            result = 31 * result + (this.vpcLatticeExclusionInput != null ? this.vpcLatticeExclusionInput.hashCode() : 0);
            result = 31 * result + (this.vpcPeeringExclusionInput != null ? this.vpcPeeringExclusionInput.hashCode() : 0);
            return result;
        }
    }
}
