package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a <code>CfnVolume</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnVolumeProps cfnVolumeProps = CfnVolumeProps.builder()
 *         .autoEnableIo(false)
 *         .availabilityZone("availabilityZone")
 *         .availabilityZoneId("availabilityZoneId")
 *         .encrypted(false)
 *         .iops(123)
 *         .kmsKeyId("kmsKeyId")
 *         .multiAttachEnabled(false)
 *         .outpostArn("outpostArn")
 *         .size(123)
 *         .snapshotId("snapshotId")
 *         .sourceVolumeId("sourceVolumeId")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .throughput(123)
 *         .volumeInitializationRate(123)
 *         .volumeType("volumeType")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-volume.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-volume.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:19.357Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnVolumeProps")
@software.amazon.jsii.Jsii.Proxy(CfnVolumeProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnVolumeProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Indicates whether the volume is auto-enabled for I/O operations.
     * <p>
     * By default, Amazon EBS disables I/O to the volume from attached EC2 instances when it determines that a volume's data is potentially inconsistent. If the consistency of the volume is not a concern, and you prefer that the volume be made available immediately if it's impaired, you can configure the volume to automatically enable I/O.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-volume.html#cfn-ec2-volume-autoenableio">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-volume.html#cfn-ec2-volume-autoenableio</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAutoEnableIo() {
        return null;
    }

    /**
     * The ID of the Availability Zone in which to create the volume. For example, <code>us-east-1a</code> .
     * <p>
     * Either <code>AvailabilityZone</code> or <code>AvailabilityZoneId</code> must be specified, but not both.
     * <p>
     * If you are creating a volume copy, omit this parameter. The volume copy is created in the same Availability Zone as the source volume.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-volume.html#cfn-ec2-volume-availabilityzone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-volume.html#cfn-ec2-volume-availabilityzone</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
        return null;
    }

    /**
     * The ID of the Availability Zone in which to create the volume. For example, <code>use1-az1</code> .
     * <p>
     * Either <code>AvailabilityZone</code> or <code>AvailabilityZoneId</code> must be specified, but not both.
     * <p>
     * If you are creating a volume copy, omit this parameter. The volume copy is created in the same Availability Zone as the source volume.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-volume.html#cfn-ec2-volume-availabilityzoneid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-volume.html#cfn-ec2-volume-availabilityzoneid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZoneId() {
        return null;
    }

    /**
     * Indicates whether the volume should be encrypted.
     * <p>
     * The effect of setting the encryption state to <code>true</code> depends on the volume origin (new, from a snapshot, or from an existing volume), starting encryption state, ownership, and whether encryption by default is enabled. For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/work-with-ebs-encr.html#encryption-by-default">Encryption by default</a> in the <em>Amazon EBS User Guide</em> .
     * <p>
     * If you are creating a volume copy, omit this parameter. The volume is automatically encrypted with the same KMS key as the source volume. You can't copy unencrypted volumes.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-volume.html#cfn-ec2-volume-encrypted">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-volume.html#cfn-ec2-volume-encrypted</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEncrypted() {
        return null;
    }

    /**
     * The number of I/O operations per second (IOPS) to provision for the volume.
     * <p>
     * Required for <code>io1</code> and <code>io2</code> volumes. Optional for <code>gp3</code> volumes. Omit for all other volume types.
     * <p>
     * Valid ranges:
     * <p>
     * <ul>
     * <li>gp3: <code>3,000</code> ( <em>default</em> ) <code>- 80,000</code> IOPS</li>
     * <li>io1: <code>100 - 64,000</code> IOPS</li>
     * <li>io2: <code>100 - 256,000</code> IOPS</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * <a href="https://docs.aws.amazon.com/ec2/latest/instancetypes/ec2-nitro-instances.html">Instances built on the Nitro System</a> can support up to 256,000 IOPS. Other instances can support up to 32,000 IOPS.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-volume.html#cfn-ec2-volume-iops">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-volume.html#cfn-ec2-volume-iops</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getIops() {
        return null;
    }

    /**
     * The identifier of the AWS KMS key to use for Amazon EBS encryption.
     * <p>
     * If <code>KmsKeyId</code> is specified, the encrypted state must be <code>true</code> .
     * <p>
     * If you omit this property and your account is enabled for encryption by default, or <em>Encrypted</em> is set to <code>true</code> , then the volume is encrypted using the default key specified for your account. If your account does not have a default key, then the volume is encrypted using the AWS managed key .
     * <p>
     * Alternatively, if you want to specify a different key, you can specify one of the following:
     * <p>
     * <ul>
     * <li>Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.</li>
     * <li>Key alias. Specify the alias for the key, prefixed with <code>alias/</code> . For example, for a key with the alias <code>my_cmk</code> , use <code>alias/my_cmk</code> . Or to specify the AWS managed key , use <code>alias/aws/ebs</code> .</li>
     * <li>Key ARN. For example, arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.</li>
     * <li>Alias ARN. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.</li>
     * </ul>
     * <p>
     * If you are creating a volume copy, omit this parameter. The volume is automatically encrypted with the same KMS key as the source volume. You can't copy unencrypted volumes.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-volume.html#cfn-ec2-volume-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-volume.html#cfn-ec2-volume-kmskeyid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return null;
    }

    /**
     * Indicates whether Amazon EBS Multi-Attach is enabled.
     * <p>
     * AWS CloudFormation does not currently support updating a single-attach volume to be multi-attach enabled, updating a multi-attach enabled volume to be single-attach, or updating the size or number of I/O operations per second (IOPS) of a multi-attach enabled volume.
     * <p>
     * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-volume.html#cfn-ec2-volume-multiattachenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-volume.html#cfn-ec2-volume-multiattachenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMultiAttachEnabled() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the Outpost on which to create the volume.
     * <p>
     * If you intend to use a volume with an instance running on an outpost, then you must create the volume on the same outpost as the instance. You can't use a volume created in an AWS Region with an instance on an AWS outpost, or the other way around.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-volume.html#cfn-ec2-volume-outpostarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-volume.html#cfn-ec2-volume-outpostarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOutpostArn() {
        return null;
    }

    /**
     * The size of the volume, in GiBs.
     * <p>
     * <ul>
     * <li>Required for new empty volumes.</li>
     * <li>Optional for volumes created from snapshots and volume copies. In this case, the size defaults to the size of the snapshot or source volume. You can optionally specify a size that is equal to or larger than the size of the source snapshot or volume.</li>
     * </ul>
     * <p>
     * Supported volume sizes:
     * <p>
     * <ul>
     * <li>gp2: <code>1 - 16,384</code> GiB</li>
     * <li>gp3: <code>1 - 65,536</code> GiB</li>
     * <li>io1: <code>4 - 16,384</code> GiB</li>
     * <li>io2: <code>4 - 65,536</code> GiB</li>
     * <li>st1 and sc1: <code>125 - 16,384</code> GiB</li>
     * <li>standard: <code>1 - 1024</code> GiB</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-volume.html#cfn-ec2-volume-size">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-volume.html#cfn-ec2-volume-size</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getSize() {
        return null;
    }

    /**
     * The snapshot from which to create the volume.
     * <p>
     * Only specify to create a volume from a snapshot. To create a new empty volume, omit this parameter and specify a value for <code>Size</code> instead. To create a volume copy, omit this parameter and specify <code>SourceVolumeId</code> instead.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-volume.html#cfn-ec2-volume-snapshotid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-volume.html#cfn-ec2-volume-snapshotid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSnapshotId() {
        return null;
    }

    /**
     * The ID of the source EBS volume to copy.
     * <p>
     * When specified, the volume is created as an exact copy of the specified volume. Only specify to create a volume copy. To create a new empty volume or to create a volume from a snapshot, omit this parameter,
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-volume.html#cfn-ec2-volume-sourcevolumeid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-volume.html#cfn-ec2-volume-sourcevolumeid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSourceVolumeId() {
        return null;
    }

    /**
     * The tags to apply to the volume during creation.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-volume.html#cfn-ec2-volume-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-volume.html#cfn-ec2-volume-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The throughput to provision for a volume, with a maximum of 1,000 MiB/s.
     * <p>
     * This parameter is valid only for <code>gp3</code> volumes. The default value is 125.
     * <p>
     * Valid Range: Minimum value of 125. Maximum value of 1000.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-volume.html#cfn-ec2-volume-throughput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-volume.html#cfn-ec2-volume-throughput</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getThroughput() {
        return null;
    }

    /**
     * Specifies the Amazon EBS Provisioned Rate for Volume Initialization (volume initialization rate), in MiB/s, at which to download the snapshot blocks from Amazon S3 to the volume.
     * <p>
     * This is also known as <em>volume initialization</em> . Specifying a volume initialization rate ensures that the volume is initialized at a predictable and consistent rate after creation.
     * <p>
     * This parameter is supported only for volumes created from snapshots. Omit this parameter if:
     * <p>
     * <ul>
     * <li>You want to create the volume using fast snapshot restore. You must specify a snapshot that is enabled for fast snapshot restore. In this case, the volume is fully initialized at creation.</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * If you specify a snapshot that is enabled for fast snapshot restore and a volume initialization rate, the volume will be initialized at the specified rate instead of fast snapshot restore.
     * <p>
     * </blockquote>
     * <p>
     * <ul>
     * <li>You want to create a volume that is initialized at the default rate.</li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/initalize-volume.html">Initialize Amazon EBS volumes</a> in the <em>Amazon EC2 User Guide</em> .
     * <p>
     * Valid range: 100 - 300 MiB/s
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-volume.html#cfn-ec2-volume-volumeinitializationrate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-volume.html#cfn-ec2-volume-volumeinitializationrate</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getVolumeInitializationRate() {
        return null;
    }

    /**
     * The volume type. This parameter can be one of the following values:.
     * <p>
     * <ul>
     * <li>General Purpose SSD: <code>gp2</code> | <code>gp3</code></li>
     * <li>Provisioned IOPS SSD: <code>io1</code> | <code>io2</code></li>
     * <li>Throughput Optimized HDD: <code>st1</code></li>
     * <li>Cold HDD: <code>sc1</code></li>
     * <li>Magnetic: <code>standard</code></li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * Throughput Optimized HDD ( <code>st1</code> ) and Cold HDD ( <code>sc1</code> ) volumes can't be used as boot volumes.
     * <p>
     * </blockquote>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volume-types.html">Amazon EBS volume types</a> in the <em>Amazon EBS User Guide</em> .
     * <p>
     * Default: <code>gp2</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-volume.html#cfn-ec2-volume-volumetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-volume.html#cfn-ec2-volume-volumetype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVolumeType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnVolumeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnVolumeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnVolumeProps> {
        java.lang.Object autoEnableIo;
        java.lang.String availabilityZone;
        java.lang.String availabilityZoneId;
        java.lang.Object encrypted;
        java.lang.Number iops;
        java.lang.String kmsKeyId;
        java.lang.Object multiAttachEnabled;
        java.lang.String outpostArn;
        java.lang.Number size;
        java.lang.String snapshotId;
        java.lang.String sourceVolumeId;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Number throughput;
        java.lang.Number volumeInitializationRate;
        java.lang.String volumeType;

        /**
         * Sets the value of {@link CfnVolumeProps#getAutoEnableIo}
         * @param autoEnableIo Indicates whether the volume is auto-enabled for I/O operations.
         *                     By default, Amazon EBS disables I/O to the volume from attached EC2 instances when it determines that a volume's data is potentially inconsistent. If the consistency of the volume is not a concern, and you prefer that the volume be made available immediately if it's impaired, you can configure the volume to automatically enable I/O.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoEnableIo(java.lang.Boolean autoEnableIo) {
            this.autoEnableIo = autoEnableIo;
            return this;
        }

        /**
         * Sets the value of {@link CfnVolumeProps#getAutoEnableIo}
         * @param autoEnableIo Indicates whether the volume is auto-enabled for I/O operations.
         *                     By default, Amazon EBS disables I/O to the volume from attached EC2 instances when it determines that a volume's data is potentially inconsistent. If the consistency of the volume is not a concern, and you prefer that the volume be made available immediately if it's impaired, you can configure the volume to automatically enable I/O.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoEnableIo(software.amazon.awscdk.IResolvable autoEnableIo) {
            this.autoEnableIo = autoEnableIo;
            return this;
        }

        /**
         * Sets the value of {@link CfnVolumeProps#getAvailabilityZone}
         * @param availabilityZone The ID of the Availability Zone in which to create the volume. For example, <code>us-east-1a</code> .
         *                         Either <code>AvailabilityZone</code> or <code>AvailabilityZoneId</code> must be specified, but not both.
         *                         <p>
         *                         If you are creating a volume copy, omit this parameter. The volume copy is created in the same Availability Zone as the source volume.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(java.lang.String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        /**
         * Sets the value of {@link CfnVolumeProps#getAvailabilityZoneId}
         * @param availabilityZoneId The ID of the Availability Zone in which to create the volume. For example, <code>use1-az1</code> .
         *                           Either <code>AvailabilityZone</code> or <code>AvailabilityZoneId</code> must be specified, but not both.
         *                           <p>
         *                           If you are creating a volume copy, omit this parameter. The volume copy is created in the same Availability Zone as the source volume.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZoneId(java.lang.String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        /**
         * Sets the value of {@link CfnVolumeProps#getEncrypted}
         * @param encrypted Indicates whether the volume should be encrypted.
         *                  The effect of setting the encryption state to <code>true</code> depends on the volume origin (new, from a snapshot, or from an existing volume), starting encryption state, ownership, and whether encryption by default is enabled. For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/work-with-ebs-encr.html#encryption-by-default">Encryption by default</a> in the <em>Amazon EBS User Guide</em> .
         *                  <p>
         *                  If you are creating a volume copy, omit this parameter. The volume is automatically encrypted with the same KMS key as the source volume. You can't copy unencrypted volumes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encrypted(java.lang.Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        /**
         * Sets the value of {@link CfnVolumeProps#getEncrypted}
         * @param encrypted Indicates whether the volume should be encrypted.
         *                  The effect of setting the encryption state to <code>true</code> depends on the volume origin (new, from a snapshot, or from an existing volume), starting encryption state, ownership, and whether encryption by default is enabled. For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/work-with-ebs-encr.html#encryption-by-default">Encryption by default</a> in the <em>Amazon EBS User Guide</em> .
         *                  <p>
         *                  If you are creating a volume copy, omit this parameter. The volume is automatically encrypted with the same KMS key as the source volume. You can't copy unencrypted volumes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encrypted(software.amazon.awscdk.IResolvable encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        /**
         * Sets the value of {@link CfnVolumeProps#getIops}
         * @param iops The number of I/O operations per second (IOPS) to provision for the volume.
         *             Required for <code>io1</code> and <code>io2</code> volumes. Optional for <code>gp3</code> volumes. Omit for all other volume types.
         *             <p>
         *             Valid ranges:
         *             <p>
         *             <ul>
         *             <li>gp3: <code>3,000</code> ( <em>default</em> ) <code>- 80,000</code> IOPS</li>
         *             <li>io1: <code>100 - 64,000</code> IOPS</li>
         *             <li>io2: <code>100 - 256,000</code> IOPS</li>
         *             </ul>
         *             <p>
         *             <blockquote>
         *             <p>
         *             <a href="https://docs.aws.amazon.com/ec2/latest/instancetypes/ec2-nitro-instances.html">Instances built on the Nitro System</a> can support up to 256,000 IOPS. Other instances can support up to 32,000 IOPS.
         *             <p>
         *             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iops(java.lang.Number iops) {
            this.iops = iops;
            return this;
        }

        /**
         * Sets the value of {@link CfnVolumeProps#getKmsKeyId}
         * @param kmsKeyId The identifier of the AWS KMS key to use for Amazon EBS encryption.
         *                 If <code>KmsKeyId</code> is specified, the encrypted state must be <code>true</code> .
         *                 <p>
         *                 If you omit this property and your account is enabled for encryption by default, or <em>Encrypted</em> is set to <code>true</code> , then the volume is encrypted using the default key specified for your account. If your account does not have a default key, then the volume is encrypted using the AWS managed key .
         *                 <p>
         *                 Alternatively, if you want to specify a different key, you can specify one of the following:
         *                 <p>
         *                 <ul>
         *                 <li>Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.</li>
         *                 <li>Key alias. Specify the alias for the key, prefixed with <code>alias/</code> . For example, for a key with the alias <code>my_cmk</code> , use <code>alias/my_cmk</code> . Or to specify the AWS managed key , use <code>alias/aws/ebs</code> .</li>
         *                 <li>Key ARN. For example, arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.</li>
         *                 <li>Alias ARN. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.</li>
         *                 </ul>
         *                 <p>
         *                 If you are creating a volume copy, omit this parameter. The volume is automatically encrypted with the same KMS key as the source volume. You can't copy unencrypted volumes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(java.lang.String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnVolumeProps#getMultiAttachEnabled}
         * @param multiAttachEnabled Indicates whether Amazon EBS Multi-Attach is enabled.
         *                           AWS CloudFormation does not currently support updating a single-attach volume to be multi-attach enabled, updating a multi-attach enabled volume to be single-attach, or updating the size or number of I/O operations per second (IOPS) of a multi-attach enabled volume.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiAttachEnabled(java.lang.Boolean multiAttachEnabled) {
            this.multiAttachEnabled = multiAttachEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnVolumeProps#getMultiAttachEnabled}
         * @param multiAttachEnabled Indicates whether Amazon EBS Multi-Attach is enabled.
         *                           AWS CloudFormation does not currently support updating a single-attach volume to be multi-attach enabled, updating a multi-attach enabled volume to be single-attach, or updating the size or number of I/O operations per second (IOPS) of a multi-attach enabled volume.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiAttachEnabled(software.amazon.awscdk.IResolvable multiAttachEnabled) {
            this.multiAttachEnabled = multiAttachEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnVolumeProps#getOutpostArn}
         * @param outpostArn The Amazon Resource Name (ARN) of the Outpost on which to create the volume.
         *                   If you intend to use a volume with an instance running on an outpost, then you must create the volume on the same outpost as the instance. You can't use a volume created in an AWS Region with an instance on an AWS outpost, or the other way around.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outpostArn(java.lang.String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnVolumeProps#getSize}
         * @param size The size of the volume, in GiBs.
         *             <ul>
         *             <li>Required for new empty volumes.</li>
         *             <li>Optional for volumes created from snapshots and volume copies. In this case, the size defaults to the size of the snapshot or source volume. You can optionally specify a size that is equal to or larger than the size of the source snapshot or volume.</li>
         *             </ul>
         *             <p>
         *             Supported volume sizes:
         *             <p>
         *             <ul>
         *             <li>gp2: <code>1 - 16,384</code> GiB</li>
         *             <li>gp3: <code>1 - 65,536</code> GiB</li>
         *             <li>io1: <code>4 - 16,384</code> GiB</li>
         *             <li>io2: <code>4 - 65,536</code> GiB</li>
         *             <li>st1 and sc1: <code>125 - 16,384</code> GiB</li>
         *             <li>standard: <code>1 - 1024</code> GiB</li>
         *             </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder size(java.lang.Number size) {
            this.size = size;
            return this;
        }

        /**
         * Sets the value of {@link CfnVolumeProps#getSnapshotId}
         * @param snapshotId The snapshot from which to create the volume.
         *                   Only specify to create a volume from a snapshot. To create a new empty volume, omit this parameter and specify a value for <code>Size</code> instead. To create a volume copy, omit this parameter and specify <code>SourceVolumeId</code> instead.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotId(java.lang.String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        /**
         * Sets the value of {@link CfnVolumeProps#getSourceVolumeId}
         * @param sourceVolumeId The ID of the source EBS volume to copy.
         *                       When specified, the volume is created as an exact copy of the specified volume. Only specify to create a volume copy. To create a new empty volume or to create a volume from a snapshot, omit this parameter,
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceVolumeId(java.lang.String sourceVolumeId) {
            this.sourceVolumeId = sourceVolumeId;
            return this;
        }

        /**
         * Sets the value of {@link CfnVolumeProps#getTags}
         * @param tags The tags to apply to the volume during creation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnVolumeProps#getThroughput}
         * @param throughput The throughput to provision for a volume, with a maximum of 1,000 MiB/s.
         *                   This parameter is valid only for <code>gp3</code> volumes. The default value is 125.
         *                   <p>
         *                   Valid Range: Minimum value of 125. Maximum value of 1000.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder throughput(java.lang.Number throughput) {
            this.throughput = throughput;
            return this;
        }

        /**
         * Sets the value of {@link CfnVolumeProps#getVolumeInitializationRate}
         * @param volumeInitializationRate Specifies the Amazon EBS Provisioned Rate for Volume Initialization (volume initialization rate), in MiB/s, at which to download the snapshot blocks from Amazon S3 to the volume.
         *                                 This is also known as <em>volume initialization</em> . Specifying a volume initialization rate ensures that the volume is initialized at a predictable and consistent rate after creation.
         *                                 <p>
         *                                 This parameter is supported only for volumes created from snapshots. Omit this parameter if:
         *                                 <p>
         *                                 <ul>
         *                                 <li>You want to create the volume using fast snapshot restore. You must specify a snapshot that is enabled for fast snapshot restore. In this case, the volume is fully initialized at creation.</li>
         *                                 </ul>
         *                                 <p>
         *                                 <blockquote>
         *                                 <p>
         *                                 If you specify a snapshot that is enabled for fast snapshot restore and a volume initialization rate, the volume will be initialized at the specified rate instead of fast snapshot restore.
         *                                 <p>
         *                                 </blockquote>
         *                                 <p>
         *                                 <ul>
         *                                 <li>You want to create a volume that is initialized at the default rate.</li>
         *                                 </ul>
         *                                 <p>
         *                                 For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/initalize-volume.html">Initialize Amazon EBS volumes</a> in the <em>Amazon EC2 User Guide</em> .
         *                                 <p>
         *                                 Valid range: 100 - 300 MiB/s
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumeInitializationRate(java.lang.Number volumeInitializationRate) {
            this.volumeInitializationRate = volumeInitializationRate;
            return this;
        }

        /**
         * Sets the value of {@link CfnVolumeProps#getVolumeType}
         * @param volumeType The volume type. This parameter can be one of the following values:.
         *                   <ul>
         *                   <li>General Purpose SSD: <code>gp2</code> | <code>gp3</code></li>
         *                   <li>Provisioned IOPS SSD: <code>io1</code> | <code>io2</code></li>
         *                   <li>Throughput Optimized HDD: <code>st1</code></li>
         *                   <li>Cold HDD: <code>sc1</code></li>
         *                   <li>Magnetic: <code>standard</code></li>
         *                   </ul>
         *                   <p>
         *                   <blockquote>
         *                   <p>
         *                   Throughput Optimized HDD ( <code>st1</code> ) and Cold HDD ( <code>sc1</code> ) volumes can't be used as boot volumes.
         *                   <p>
         *                   </blockquote>
         *                   <p>
         *                   For more information, see <a href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volume-types.html">Amazon EBS volume types</a> in the <em>Amazon EBS User Guide</em> .
         *                   <p>
         *                   Default: <code>gp2</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumeType(java.lang.String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnVolumeProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnVolumeProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnVolumeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnVolumeProps {
        private final java.lang.Object autoEnableIo;
        private final java.lang.String availabilityZone;
        private final java.lang.String availabilityZoneId;
        private final java.lang.Object encrypted;
        private final java.lang.Number iops;
        private final java.lang.String kmsKeyId;
        private final java.lang.Object multiAttachEnabled;
        private final java.lang.String outpostArn;
        private final java.lang.Number size;
        private final java.lang.String snapshotId;
        private final java.lang.String sourceVolumeId;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Number throughput;
        private final java.lang.Number volumeInitializationRate;
        private final java.lang.String volumeType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.autoEnableIo = software.amazon.jsii.Kernel.get(this, "autoEnableIo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.availabilityZoneId = software.amazon.jsii.Kernel.get(this, "availabilityZoneId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.encrypted = software.amazon.jsii.Kernel.get(this, "encrypted", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.iops = software.amazon.jsii.Kernel.get(this, "iops", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.multiAttachEnabled = software.amazon.jsii.Kernel.get(this, "multiAttachEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.outpostArn = software.amazon.jsii.Kernel.get(this, "outpostArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.size = software.amazon.jsii.Kernel.get(this, "size", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.snapshotId = software.amazon.jsii.Kernel.get(this, "snapshotId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceVolumeId = software.amazon.jsii.Kernel.get(this, "sourceVolumeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.throughput = software.amazon.jsii.Kernel.get(this, "throughput", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.volumeInitializationRate = software.amazon.jsii.Kernel.get(this, "volumeInitializationRate", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.volumeType = software.amazon.jsii.Kernel.get(this, "volumeType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.autoEnableIo = builder.autoEnableIo;
            this.availabilityZone = builder.availabilityZone;
            this.availabilityZoneId = builder.availabilityZoneId;
            this.encrypted = builder.encrypted;
            this.iops = builder.iops;
            this.kmsKeyId = builder.kmsKeyId;
            this.multiAttachEnabled = builder.multiAttachEnabled;
            this.outpostArn = builder.outpostArn;
            this.size = builder.size;
            this.snapshotId = builder.snapshotId;
            this.sourceVolumeId = builder.sourceVolumeId;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.throughput = builder.throughput;
            this.volumeInitializationRate = builder.volumeInitializationRate;
            this.volumeType = builder.volumeType;
        }

        @Override
        public final java.lang.Object getAutoEnableIo() {
            return this.autoEnableIo;
        }

        @Override
        public final java.lang.String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final java.lang.String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        @Override
        public final java.lang.Object getEncrypted() {
            return this.encrypted;
        }

        @Override
        public final java.lang.Number getIops() {
            return this.iops;
        }

        @Override
        public final java.lang.String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final java.lang.Object getMultiAttachEnabled() {
            return this.multiAttachEnabled;
        }

        @Override
        public final java.lang.String getOutpostArn() {
            return this.outpostArn;
        }

        @Override
        public final java.lang.Number getSize() {
            return this.size;
        }

        @Override
        public final java.lang.String getSnapshotId() {
            return this.snapshotId;
        }

        @Override
        public final java.lang.String getSourceVolumeId() {
            return this.sourceVolumeId;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Number getThroughput() {
            return this.throughput;
        }

        @Override
        public final java.lang.Number getVolumeInitializationRate() {
            return this.volumeInitializationRate;
        }

        @Override
        public final java.lang.String getVolumeType() {
            return this.volumeType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAutoEnableIo() != null) {
                data.set("autoEnableIo", om.valueToTree(this.getAutoEnableIo()));
            }
            if (this.getAvailabilityZone() != null) {
                data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
            }
            if (this.getAvailabilityZoneId() != null) {
                data.set("availabilityZoneId", om.valueToTree(this.getAvailabilityZoneId()));
            }
            if (this.getEncrypted() != null) {
                data.set("encrypted", om.valueToTree(this.getEncrypted()));
            }
            if (this.getIops() != null) {
                data.set("iops", om.valueToTree(this.getIops()));
            }
            if (this.getKmsKeyId() != null) {
                data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
            }
            if (this.getMultiAttachEnabled() != null) {
                data.set("multiAttachEnabled", om.valueToTree(this.getMultiAttachEnabled()));
            }
            if (this.getOutpostArn() != null) {
                data.set("outpostArn", om.valueToTree(this.getOutpostArn()));
            }
            if (this.getSize() != null) {
                data.set("size", om.valueToTree(this.getSize()));
            }
            if (this.getSnapshotId() != null) {
                data.set("snapshotId", om.valueToTree(this.getSnapshotId()));
            }
            if (this.getSourceVolumeId() != null) {
                data.set("sourceVolumeId", om.valueToTree(this.getSourceVolumeId()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getThroughput() != null) {
                data.set("throughput", om.valueToTree(this.getThroughput()));
            }
            if (this.getVolumeInitializationRate() != null) {
                data.set("volumeInitializationRate", om.valueToTree(this.getVolumeInitializationRate()));
            }
            if (this.getVolumeType() != null) {
                data.set("volumeType", om.valueToTree(this.getVolumeType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnVolumeProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnVolumeProps.Jsii$Proxy that = (CfnVolumeProps.Jsii$Proxy) o;

            if (this.autoEnableIo != null ? !this.autoEnableIo.equals(that.autoEnableIo) : that.autoEnableIo != null) return false;
            if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
            if (this.availabilityZoneId != null ? !this.availabilityZoneId.equals(that.availabilityZoneId) : that.availabilityZoneId != null) return false;
            if (this.encrypted != null ? !this.encrypted.equals(that.encrypted) : that.encrypted != null) return false;
            if (this.iops != null ? !this.iops.equals(that.iops) : that.iops != null) return false;
            if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
            if (this.multiAttachEnabled != null ? !this.multiAttachEnabled.equals(that.multiAttachEnabled) : that.multiAttachEnabled != null) return false;
            if (this.outpostArn != null ? !this.outpostArn.equals(that.outpostArn) : that.outpostArn != null) return false;
            if (this.size != null ? !this.size.equals(that.size) : that.size != null) return false;
            if (this.snapshotId != null ? !this.snapshotId.equals(that.snapshotId) : that.snapshotId != null) return false;
            if (this.sourceVolumeId != null ? !this.sourceVolumeId.equals(that.sourceVolumeId) : that.sourceVolumeId != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.throughput != null ? !this.throughput.equals(that.throughput) : that.throughput != null) return false;
            if (this.volumeInitializationRate != null ? !this.volumeInitializationRate.equals(that.volumeInitializationRate) : that.volumeInitializationRate != null) return false;
            return this.volumeType != null ? this.volumeType.equals(that.volumeType) : that.volumeType == null;
        }

        @Override
        public final int hashCode() {
            int result = this.autoEnableIo != null ? this.autoEnableIo.hashCode() : 0;
            result = 31 * result + (this.availabilityZone != null ? this.availabilityZone.hashCode() : 0);
            result = 31 * result + (this.availabilityZoneId != null ? this.availabilityZoneId.hashCode() : 0);
            result = 31 * result + (this.encrypted != null ? this.encrypted.hashCode() : 0);
            result = 31 * result + (this.iops != null ? this.iops.hashCode() : 0);
            result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
            result = 31 * result + (this.multiAttachEnabled != null ? this.multiAttachEnabled.hashCode() : 0);
            result = 31 * result + (this.outpostArn != null ? this.outpostArn.hashCode() : 0);
            result = 31 * result + (this.size != null ? this.size.hashCode() : 0);
            result = 31 * result + (this.snapshotId != null ? this.snapshotId.hashCode() : 0);
            result = 31 * result + (this.sourceVolumeId != null ? this.sourceVolumeId.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.throughput != null ? this.throughput.hashCode() : 0);
            result = 31 * result + (this.volumeInitializationRate != null ? this.volumeInitializationRate.hashCode() : 0);
            result = 31 * result + (this.volumeType != null ? this.volumeType.hashCode() : 0);
            return result;
        }
    }
}
