package software.amazon.awscdk.services.ec2;

/**
 * CPU manufacturers supported by EC2 instances.
 * <p>
 * Restricts the acceptable CPU vendor for selected instance types.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * Role infrastructureRole;
 * InstanceProfile instanceProfile;
 * Cluster cluster = Cluster.Builder.create(this, "Cluster").vpc(vpc).build();
 * // Create a Managed Instances Capacity Provider
 * ManagedInstancesCapacityProvider miCapacityProvider = ManagedInstancesCapacityProvider.Builder.create(this, "MICapacityProvider")
 *         .infrastructureRole(infrastructureRole)
 *         .ec2InstanceProfile(instanceProfile)
 *         .subnets(vpc.getPrivateSubnets())
 *         .securityGroups(List.of(SecurityGroup.Builder.create(this, "MISecurityGroup").vpc(vpc).build()))
 *         .instanceRequirements(InstanceRequirementsConfig.builder()
 *                 .vCpuCountMin(1)
 *                 .memoryMin(Size.gibibytes(2))
 *                 .cpuManufacturers(List.of(CpuManufacturer.INTEL))
 *                 .acceleratorManufacturers(List.of(AcceleratorManufacturer.NVIDIA))
 *                 .build())
 *         .propagateTags(PropagateManagedInstancesTags.CAPACITY_PROVIDER)
 *         .build();
 * // Optionally configure security group rules using IConnectable interface
 * miCapacityProvider.connections.allowFrom(Peer.ipv4(vpc.getVpcCidrBlock()), Port.tcp(80));
 * // Add the capacity provider to the cluster
 * cluster.addManagedInstancesCapacityProvider(miCapacityProvider);
 * TaskDefinition taskDefinition = TaskDefinition.Builder.create(this, "TaskDef")
 *         .memoryMiB("512")
 *         .cpu("256")
 *         .networkMode(NetworkMode.AWS_VPC)
 *         .compatibility(Compatibility.MANAGED_INSTANCES)
 *         .build();
 * taskDefinition.addContainer("web", ContainerDefinitionOptions.builder()
 *         .image(ContainerImage.fromRegistry("amazon/amazon-ecs-sample"))
 *         .memoryReservationMiB(256)
 *         .build());
 * FargateService.Builder.create(this, "FargateService")
 *         .cluster(cluster)
 *         .taskDefinition(taskDefinition)
 *         .minHealthyPercent(100)
 *         .capacityProviderStrategies(List.of(CapacityProviderStrategy.builder()
 *                 .capacityProvider(miCapacityProvider.getCapacityProviderName())
 *                 .weight(1)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:19.389Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CpuManufacturer")
public enum CpuManufacturer {
    /**
     * Intel CPUs (e.g., Xeon families).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    INTEL,
    /**
     * AMD CPUs (e.g., EPYC families).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AMD,
    /**
     * AWS-designed CPUs (e.g., Graviton families).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AWS,
    /**
     * Apple CPUs (e.g., M1, M2).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    APPLE,
}
