package software.amazon.awscdk.services.ec2;

/**
 * Supported EBS volume types for blockDevices.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ImageRecipe imageRecipe = ImageRecipe.Builder.create(this, "BlockDeviceImageRecipe")
 *         .baseImage(BaseImage.fromSsmParameterName("/aws/service/ami-amazon-linux-latest/al2023-ami-minimal-kernel-default-x86_64"))
 *         .blockDevices(List.of(BlockDevice.builder()
 *                 .deviceName("/dev/sda1")
 *                 .volume(BlockDeviceVolume.ebs(100, EbsDeviceOptions.builder()
 *                         .encrypted(true)
 *                         .volumeType(EbsDeviceVolumeType.GENERAL_PURPOSE_SSD_GP3)
 *                         .build()))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:19.393Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.EbsDeviceVolumeType")
public enum EbsDeviceVolumeType {
    /**
     * Magnetic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD,
    /**
     * Provisioned IOPS SSD - IO1.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IO1,
    /**
     * Provisioned IOPS SSD - IO2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IO2,
    /**
     * General Purpose SSD - GP2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GP2,
    /**
     * General Purpose SSD - GP3.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GP3,
    /**
     * Throughput Optimized HDD.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ST1,
    /**
     * Cold HDD.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SC1,
}
