package software.amazon.awscdk.services.ec2;

/**
 * The state of token usage for your instance metadata requests.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * InstanceType instanceType;
 * IMachineImage machineImage;
 * // Example 1: Enforce IMDSv2 with comprehensive options
 * // Example 1: Enforce IMDSv2 with comprehensive options
 * Instance.Builder.create(this, "Instance")
 *         .vpc(vpc)
 *         .instanceType(instanceType)
 *         .machineImage(machineImage)
 *         .httpEndpoint(true)
 *         .httpProtocolIpv6(false)
 *         .httpPutResponseHopLimit(2)
 *         .httpTokens(HttpTokens.REQUIRED)
 *         .instanceMetadataTags(true)
 *         .build();
 * // Example 2: Enforce IMDSv2 with minimal configuration
 * // Example 2: Enforce IMDSv2 with minimal configuration
 * Instance.Builder.create(this, "SecureInstance")
 *         .vpc(vpc)
 *         .instanceType(instanceType)
 *         .machineImage(machineImage)
 *         .httpTokens(HttpTokens.REQUIRED)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-metadataoptions.html#cfn-ec2-instance-metadataoptions-httptokens">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-metadataoptions.html#cfn-ec2-instance-metadataoptions-httptokens</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:19.404Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.HttpTokens")
public enum HttpTokens {
    /**
     * If the state is optional, you can choose to retrieve instance metadata with or without a signed token header on your request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OPTIONAL,
    /**
     * If the state is required, you must send a signed token header with any instance metadata retrieval requests.
     * <p>
     * In this state,
     * retrieving the IAM role credentials always returns the version 2.0 credentials; the version 1.0 credentials are not available.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    REQUIRED,
}
