package software.amazon.awscdk.services.ec2;

/**
 * The properties of a Key Pair.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * InstanceType instanceType;
 * KeyPair keyPair = KeyPair.Builder.create(this, "KeyPair")
 *         .type(KeyPairType.ED25519)
 *         .format(KeyPairFormat.PEM)
 *         .build();
 * Instance instance = Instance.Builder.create(this, "Instance")
 *         .vpc(vpc)
 *         .instanceType(instanceType)
 *         .machineImage(MachineImage.latestAmazonLinux2023())
 *         // Use the custom key pair
 *         .keyPair(keyPair)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:19.507Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.KeyPairProps")
@software.amazon.jsii.Jsii.Proxy(KeyPairProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface KeyPairProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.ResourceProps {

    /**
     * The format of the key pair.
     * <p>
     * Default: PEM
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.KeyPairFormat getFormat() {
        return null;
    }

    /**
     * A unique name for the key pair.
     * <p>
     * Default: A generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKeyPairName() {
        return null;
    }

    /**
     * The public key material.
     * <p>
     * If this is provided the key is considered "imported". For imported
     * keys, it is assumed that you already have the private key material
     * so the private key material will not be returned or stored in
     * AWS Systems Manager Parameter Store.
     * <p>
     * Default: a public and private key will be generated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPublicKeyMaterial() {
        return null;
    }

    /**
     * The type of key pair.
     * <p>
     * Default: RSA (ignored if keyMaterial is provided)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.KeyPairType getType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link KeyPairProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link KeyPairProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<KeyPairProps> {
        software.amazon.awscdk.services.ec2.KeyPairFormat format;
        java.lang.String keyPairName;
        java.lang.String publicKeyMaterial;
        software.amazon.awscdk.services.ec2.KeyPairType type;
        java.lang.String account;
        java.lang.String environmentFromArn;
        java.lang.String physicalName;
        java.lang.String region;

        /**
         * Sets the value of {@link KeyPairProps#getFormat}
         * @param format The format of the key pair.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder format(software.amazon.awscdk.services.ec2.KeyPairFormat format) {
            this.format = format;
            return this;
        }

        /**
         * Sets the value of {@link KeyPairProps#getKeyPairName}
         * @param keyPairName A unique name for the key pair.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyPairName(java.lang.String keyPairName) {
            this.keyPairName = keyPairName;
            return this;
        }

        /**
         * Sets the value of {@link KeyPairProps#getPublicKeyMaterial}
         * @param publicKeyMaterial The public key material.
         *                          If this is provided the key is considered "imported". For imported
         *                          keys, it is assumed that you already have the private key material
         *                          so the private key material will not be returned or stored in
         *                          AWS Systems Manager Parameter Store.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicKeyMaterial(java.lang.String publicKeyMaterial) {
            this.publicKeyMaterial = publicKeyMaterial;
            return this;
        }

        /**
         * Sets the value of {@link KeyPairProps#getType}
         * @param type The type of key pair.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(software.amazon.awscdk.services.ec2.KeyPairType type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link KeyPairProps#getAccount}
         * @param account The AWS account ID this resource belongs to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder account(java.lang.String account) {
            this.account = account;
            return this;
        }

        /**
         * Sets the value of {@link KeyPairProps#getEnvironmentFromArn}
         * @param environmentFromArn ARN to deduce region and account from.
         *                           The ARN is parsed and the account and region are taken from the ARN.
         *                           This should be used for imported resources.
         *                           <p>
         *                           Cannot be supplied together with either <code>account</code> or <code>region</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentFromArn(java.lang.String environmentFromArn) {
            this.environmentFromArn = environmentFromArn;
            return this;
        }

        /**
         * Sets the value of {@link KeyPairProps#getPhysicalName}
         * @param physicalName The value passed in by users to the physical name prop of the resource.
         *                     <ul>
         *                     <li><code>undefined</code> implies that a physical name will be allocated by
         *                     CloudFormation during deployment.</li>
         *                     <li>a concrete value implies a specific physical name</li>
         *                     <li><code>PhysicalName.GENERATE_IF_NEEDED</code> is a marker that indicates that a physical will only be generated
         *                     by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated by CloudFormation.</li>
         *                     </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder physicalName(java.lang.String physicalName) {
            this.physicalName = physicalName;
            return this;
        }

        /**
         * Sets the value of {@link KeyPairProps#getRegion}
         * @param region The AWS region this resource belongs to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link KeyPairProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public KeyPairProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link KeyPairProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KeyPairProps {
        private final software.amazon.awscdk.services.ec2.KeyPairFormat format;
        private final java.lang.String keyPairName;
        private final java.lang.String publicKeyMaterial;
        private final software.amazon.awscdk.services.ec2.KeyPairType type;
        private final java.lang.String account;
        private final java.lang.String environmentFromArn;
        private final java.lang.String physicalName;
        private final java.lang.String region;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.format = software.amazon.jsii.Kernel.get(this, "format", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.KeyPairFormat.class));
            this.keyPairName = software.amazon.jsii.Kernel.get(this, "keyPairName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.publicKeyMaterial = software.amazon.jsii.Kernel.get(this, "publicKeyMaterial", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.KeyPairType.class));
            this.account = software.amazon.jsii.Kernel.get(this, "account", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.environmentFromArn = software.amazon.jsii.Kernel.get(this, "environmentFromArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.physicalName = software.amazon.jsii.Kernel.get(this, "physicalName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.format = builder.format;
            this.keyPairName = builder.keyPairName;
            this.publicKeyMaterial = builder.publicKeyMaterial;
            this.type = builder.type;
            this.account = builder.account;
            this.environmentFromArn = builder.environmentFromArn;
            this.physicalName = builder.physicalName;
            this.region = builder.region;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.KeyPairFormat getFormat() {
            return this.format;
        }

        @Override
        public final java.lang.String getKeyPairName() {
            return this.keyPairName;
        }

        @Override
        public final java.lang.String getPublicKeyMaterial() {
            return this.publicKeyMaterial;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.KeyPairType getType() {
            return this.type;
        }

        @Override
        public final java.lang.String getAccount() {
            return this.account;
        }

        @Override
        public final java.lang.String getEnvironmentFromArn() {
            return this.environmentFromArn;
        }

        @Override
        public final java.lang.String getPhysicalName() {
            return this.physicalName;
        }

        @Override
        public final java.lang.String getRegion() {
            return this.region;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getFormat() != null) {
                data.set("format", om.valueToTree(this.getFormat()));
            }
            if (this.getKeyPairName() != null) {
                data.set("keyPairName", om.valueToTree(this.getKeyPairName()));
            }
            if (this.getPublicKeyMaterial() != null) {
                data.set("publicKeyMaterial", om.valueToTree(this.getPublicKeyMaterial()));
            }
            if (this.getType() != null) {
                data.set("type", om.valueToTree(this.getType()));
            }
            if (this.getAccount() != null) {
                data.set("account", om.valueToTree(this.getAccount()));
            }
            if (this.getEnvironmentFromArn() != null) {
                data.set("environmentFromArn", om.valueToTree(this.getEnvironmentFromArn()));
            }
            if (this.getPhysicalName() != null) {
                data.set("physicalName", om.valueToTree(this.getPhysicalName()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.KeyPairProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            KeyPairProps.Jsii$Proxy that = (KeyPairProps.Jsii$Proxy) o;

            if (this.format != null ? !this.format.equals(that.format) : that.format != null) return false;
            if (this.keyPairName != null ? !this.keyPairName.equals(that.keyPairName) : that.keyPairName != null) return false;
            if (this.publicKeyMaterial != null ? !this.publicKeyMaterial.equals(that.publicKeyMaterial) : that.publicKeyMaterial != null) return false;
            if (this.type != null ? !this.type.equals(that.type) : that.type != null) return false;
            if (this.account != null ? !this.account.equals(that.account) : that.account != null) return false;
            if (this.environmentFromArn != null ? !this.environmentFromArn.equals(that.environmentFromArn) : that.environmentFromArn != null) return false;
            if (this.physicalName != null ? !this.physicalName.equals(that.physicalName) : that.physicalName != null) return false;
            return this.region != null ? this.region.equals(that.region) : that.region == null;
        }

        @Override
        public final int hashCode() {
            int result = this.format != null ? this.format.hashCode() : 0;
            result = 31 * result + (this.keyPairName != null ? this.keyPairName.hashCode() : 0);
            result = 31 * result + (this.publicKeyMaterial != null ? this.publicKeyMaterial.hashCode() : 0);
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            result = 31 * result + (this.account != null ? this.account.hashCode() : 0);
            result = 31 * result + (this.environmentFromArn != null ? this.environmentFromArn.hashCode() : 0);
            result = 31 * result + (this.physicalName != null ? this.physicalName.hashCode() : 0);
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            return result;
        }
    }
}
