package software.amazon.awscdk.services.ec2;

/**
 * Attributes for an imported LaunchTemplate.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * DistributionConfiguration distributionConfiguration = DistributionConfiguration.Builder.create(this, "DistributionConfiguration")
 *         .distributionConfigurationName("test-distribution-configuration")
 *         .description("A Distribution Configuration")
 *         .amiDistributions(List.of(AmiDistribution.builder()
 *                 // Distribute AMI to us-east-2 and publish the AMI ID to an SSM parameter
 *                 .region("us-east-2")
 *                 .ssmParameters(List.of(SSMParameterConfigurations.builder()
 *                         .parameter(StringParameter.fromStringParameterAttributes(this, "CrossRegionParameter", StringParameterAttributes.builder()
 *                                 .parameterName("/imagebuilder/ami")
 *                                 .forceDynamicReference(true)
 *                                 .build()))
 *                         .build()))
 *                 .build()))
 *         .build();
 * // For AMI-based image builds - add an AMI distribution in the current region
 * distributionConfiguration.addAmiDistributions(AmiDistribution.builder()
 *         .amiName("imagebuilder-{{ imagebuilder:buildDate }}")
 *         .amiDescription("Build AMI")
 *         .amiKmsKey(Key.fromLookup(this, "ComponentKey", KeyLookupOptions.builder().aliasName("alias/distribution-encryption-key").build()))
 *         // Copy the AMI to different accounts
 *         .amiTargetAccountIds(List.of("123456789012", "098765432109"))
 *         // Add launch permissions on the AMI
 *         .amiLaunchPermission(AmiLaunchPermission.builder()
 *                 .organizationArns(List.of(this.formatArn(ArnComponents.builder().region("").service("organizations").resource("organization").resourceName("o-1234567abc").build())))
 *                 .organizationalUnitArns(List.of(this.formatArn(ArnComponents.builder()
 *                         .region("")
 *                         .service("organizations")
 *                         .resource("ou")
 *                         .resourceName("o-1234567abc/ou-a123-b4567890")
 *                         .build())))
 *                 .isPublicUserGroup(true)
 *                 .accountIds(List.of("234567890123"))
 *                 .build())
 *         // Attach tags to the AMI
 *         .amiTags(Map.of(
 *                 "Environment", "production",
 *                 "Version", "{{ imagebuilder:buildVersion }}"))
 *         // Optional - publish the distributed AMI ID to an SSM parameter
 *         .ssmParameters(List.of(SSMParameterConfigurations.builder()
 *                 .parameter(StringParameter.fromStringParameterAttributes(this, "Parameter", StringParameterAttributes.builder()
 *                         .parameterName("/imagebuilder/ami")
 *                         .forceDynamicReference(true)
 *                         .build()))
 *                 .build(), SSMParameterConfigurations.builder()
 *                 .amiAccount("098765432109")
 *                 .dataType(ParameterDataType.TEXT)
 *                 .parameter(StringParameter.fromStringParameterAttributes(this, "CrossAccountParameter", StringParameterAttributes.builder()
 *                         .parameterName("imagebuilder-prod-ami")
 *                         .forceDynamicReference(true)
 *                         .build()))
 *                 .build()))
 *         // Optional - create a new launch template version with the distributed AMI ID
 *         .launchTemplates(List.of(LaunchTemplateConfiguration.builder()
 *                 .launchTemplate(LaunchTemplate.fromLaunchTemplateAttributes(this, "LaunchTemplate", LaunchTemplateAttributes.builder()
 *                         .launchTemplateId("lt-1234")
 *                         .build()))
 *                 .setDefaultVersion(true)
 *                 .build(), LaunchTemplateConfiguration.builder()
 *                 .accountId("123456789012")
 *                 .launchTemplate(LaunchTemplate.fromLaunchTemplateAttributes(this, "CrossAccountLaunchTemplate", LaunchTemplateAttributes.builder()
 *                         .launchTemplateId("lt-5678")
 *                         .build()))
 *                 .setDefaultVersion(true)
 *                 .build()))
 *         // Optional - enable Fast Launch on an imported launch template
 *         .fastLaunchConfigurations(List.of(FastLaunchConfiguration.builder()
 *                 .enabled(true)
 *                 .launchTemplate(LaunchTemplate.fromLaunchTemplateAttributes(this, "FastLaunchLT", LaunchTemplateAttributes.builder()
 *                         .launchTemplateName("fast-launch-lt")
 *                         .build()))
 *                 .maxParallelLaunches(10)
 *                 .targetSnapshotCount(2)
 *                 .build()))
 *         // Optional - license configurations to apply to the AMI
 *         .licenseConfigurationArns(List.of("arn:aws:license-manager:us-west-2:123456789012:license-configuration:lic-abcdefghijklmnopqrstuvwxyz"))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:19.510Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.LaunchTemplateAttributes")
@software.amazon.jsii.Jsii.Proxy(LaunchTemplateAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LaunchTemplateAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * The identifier of the Launch Template.
     * <p>
     * Exactly one of <code>launchTemplateId</code> and <code>launchTemplateName</code> may be set.
     * <p>
     * Default: None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLaunchTemplateId() {
        return null;
    }

    /**
     * The name of the Launch Template.
     * <p>
     * Exactly one of <code>launchTemplateId</code> and <code>launchTemplateName</code> may be set.
     * <p>
     * Default: None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLaunchTemplateName() {
        return null;
    }

    /**
     * The version number of this launch template to use.
     * <p>
     * Default: Version: "$Default"
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVersionNumber() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LaunchTemplateAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LaunchTemplateAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LaunchTemplateAttributes> {
        java.lang.String launchTemplateId;
        java.lang.String launchTemplateName;
        java.lang.String versionNumber;

        /**
         * Sets the value of {@link LaunchTemplateAttributes#getLaunchTemplateId}
         * @param launchTemplateId The identifier of the Launch Template.
         *                         Exactly one of <code>launchTemplateId</code> and <code>launchTemplateName</code> may be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchTemplateId(java.lang.String launchTemplateId) {
            this.launchTemplateId = launchTemplateId;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateAttributes#getLaunchTemplateName}
         * @param launchTemplateName The name of the Launch Template.
         *                           Exactly one of <code>launchTemplateId</code> and <code>launchTemplateName</code> may be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchTemplateName(java.lang.String launchTemplateName) {
            this.launchTemplateName = launchTemplateName;
            return this;
        }

        /**
         * Sets the value of {@link LaunchTemplateAttributes#getVersionNumber}
         * @param versionNumber The version number of this launch template to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder versionNumber(java.lang.String versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LaunchTemplateAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LaunchTemplateAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LaunchTemplateAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LaunchTemplateAttributes {
        private final java.lang.String launchTemplateId;
        private final java.lang.String launchTemplateName;
        private final java.lang.String versionNumber;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.launchTemplateId = software.amazon.jsii.Kernel.get(this, "launchTemplateId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.launchTemplateName = software.amazon.jsii.Kernel.get(this, "launchTemplateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.versionNumber = software.amazon.jsii.Kernel.get(this, "versionNumber", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.launchTemplateId = builder.launchTemplateId;
            this.launchTemplateName = builder.launchTemplateName;
            this.versionNumber = builder.versionNumber;
        }

        @Override
        public final java.lang.String getLaunchTemplateId() {
            return this.launchTemplateId;
        }

        @Override
        public final java.lang.String getLaunchTemplateName() {
            return this.launchTemplateName;
        }

        @Override
        public final java.lang.String getVersionNumber() {
            return this.versionNumber;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getLaunchTemplateId() != null) {
                data.set("launchTemplateId", om.valueToTree(this.getLaunchTemplateId()));
            }
            if (this.getLaunchTemplateName() != null) {
                data.set("launchTemplateName", om.valueToTree(this.getLaunchTemplateName()));
            }
            if (this.getVersionNumber() != null) {
                data.set("versionNumber", om.valueToTree(this.getVersionNumber()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.LaunchTemplateAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LaunchTemplateAttributes.Jsii$Proxy that = (LaunchTemplateAttributes.Jsii$Proxy) o;

            if (this.launchTemplateId != null ? !this.launchTemplateId.equals(that.launchTemplateId) : that.launchTemplateId != null) return false;
            if (this.launchTemplateName != null ? !this.launchTemplateName.equals(that.launchTemplateName) : that.launchTemplateName != null) return false;
            return this.versionNumber != null ? this.versionNumber.equals(that.versionNumber) : that.versionNumber == null;
        }

        @Override
        public final int hashCode() {
            int result = this.launchTemplateId != null ? this.launchTemplateId.hashCode() : 0;
            result = 31 * result + (this.launchTemplateName != null ? this.launchTemplateName.hashCode() : 0);
            result = 31 * result + (this.versionNumber != null ? this.versionNumber.hashCode() : 0);
            return result;
        }
    }
}
