package software.amazon.awscdk.services.ec2;

/**
 * Local storage support requirements for EC2 instances.
 * <p>
 * Controls whether selected instance types must, may, or must not
 * include directly attached local storage (instance store).
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Role infrastructureRole;
 * InstanceProfile instanceProfile;
 * Vpc vpc;
 * ManagedInstancesCapacityProvider miCapacityProvider = ManagedInstancesCapacityProvider.Builder.create(this, "MICapacityProvider")
 *         .infrastructureRole(infrastructureRole)
 *         .ec2InstanceProfile(instanceProfile)
 *         .subnets(vpc.getPrivateSubnets())
 *         .instanceRequirements(InstanceRequirementsConfig.builder()
 *                 // Required: CPU and memory constraints
 *                 .vCpuCountMin(2)
 *                 .vCpuCountMax(8)
 *                 .memoryMin(Size.gibibytes(4))
 *                 .memoryMax(Size.gibibytes(32))
 *                 // CPU preferences
 *                 .cpuManufacturers(List.of(CpuManufacturer.INTEL, CpuManufacturer.AMD))
 *                 .instanceGenerations(List.of(InstanceGeneration.CURRENT))
 *                 // Instance type filtering
 *                 .allowedInstanceTypes(List.of("m5.*", "c5.*"))
 *                 // Performance characteristics
 *                 .burstablePerformance(BurstablePerformance.EXCLUDED)
 *                 .bareMetal(BareMetal.EXCLUDED)
 *                 // Accelerator requirements (for ML/AI workloads)
 *                 .acceleratorTypes(List.of(AcceleratorType.GPU))
 *                 .acceleratorManufacturers(List.of(AcceleratorManufacturer.NVIDIA))
 *                 .acceleratorNames(List.of(AcceleratorName.T4, AcceleratorName.V100))
 *                 .acceleratorCountMin(1)
 *                 // Storage requirements
 *                 .localStorage(LocalStorage.REQUIRED)
 *                 .localStorageTypes(List.of(LocalStorageType.SSD))
 *                 .totalLocalStorageGBMin(100)
 *                 // Network requirements
 *                 .networkInterfaceCountMin(2)
 *                 .networkBandwidthGbpsMin(10)
 *                 // Cost optimization
 *                 .onDemandMaxPricePercentageOverLowestPrice(10)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:19.515Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.LocalStorage")
public enum LocalStorage {
    /**
     * Instance types with local storage are allowed, but types without local storage may also be selected.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    INCLUDED,
    /**
     * Only instance types with local storage are allowed.
     * <p>
     * Types without local storage will be excluded.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    REQUIRED,
    /**
     * Instance types with local storage are disallowed.
     * <p>
     * Only types without local storage may be selected.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    EXCLUDED,
}
