package software.amazon.awscdk.services.ec2;

/**
 * Interface for classes that provide the connection-specification parts of a security group rule.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ApplicationLoadBalancer loadBalancer;
 * Vpc vpc = new Vpc(this, "MyVPC");
 * Fleet fleet = Fleet.Builder.create(this, "MyProject")
 *         .computeType(FleetComputeType.MEDIUM)
 *         .environmentType(EnvironmentType.LINUX_CONTAINER)
 *         .baseCapacity(1)
 *         .vpc(vpc)
 *         .build();
 * fleet.connections.allowTo(loadBalancer, Port.tcp(443));
 * Project project = Project.Builder.create(this, "MyProject")
 *         .environment(BuildEnvironment.builder()
 *                 .fleet(fleet)
 *                 .build())
 *         .buildSpec(BuildSpec.fromObject(Map.of()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:19.558Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.Port")
public class Port extends software.amazon.jsii.JsiiObject {

    protected Port(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Port(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        DNS_TCP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.Port.class, "DNS_TCP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Port.class));
        DNS_UDP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.Port.class, "DNS_UDP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Port.class));
        HTTP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.Port.class, "HTTP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Port.class));
        HTTPS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.Port.class, "HTTPS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Port.class));
        IMAP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.Port.class, "IMAP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Port.class));
        IMAPS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.Port.class, "IMAPS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Port.class));
        LDAP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.Port.class, "LDAP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Port.class));
        MSSQL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.Port.class, "MSSQL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Port.class));
        MYSQL_AURORA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.Port.class, "MYSQL_AURORA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Port.class));
        NFS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.Port.class, "NFS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Port.class));
        POP3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.Port.class, "POP3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Port.class));
        POP3_S = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.Port.class, "POP3S", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Port.class));
        POSTGRES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.Port.class, "POSTGRES", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Port.class));
        RDP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.Port.class, "RDP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Port.class));
        SMB = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.Port.class, "SMB", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Port.class));
        SMTP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.Port.class, "SMTP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Port.class));
        SSH = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.Port.class, "SSH", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Port.class));
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Port(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.PortProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A single AH port.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port ah() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Port.class, "ah", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Port.class));
    }

    /**
     * All ICMP traffic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port allIcmp() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Port.class, "allIcmp", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Port.class));
    }

    /**
     * All ICMPv6 traffic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port allIcmpV6() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Port.class, "allIcmpV6", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Port.class));
    }

    /**
     * Any TCP traffic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port allTcp() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Port.class, "allTcp", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Port.class));
    }

    /**
     * All traffic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port allTraffic() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Port.class, "allTraffic", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Port.class));
    }

    /**
     * Any UDP traffic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port allUdp() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Port.class, "allUdp", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Port.class));
    }

    /**
     * A single ESP port.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port esp() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Port.class, "esp", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Port.class));
    }

    /**
     * ICMP ping (echo) traffic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port icmpPing() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Port.class, "icmpPing", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Port.class));
    }

    /**
     * All codes for a single ICMP type.
     * <p>
     * @param type This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port icmpType(final @org.jetbrains.annotations.NotNull java.lang.Number type) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Port.class, "icmpType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Port.class), new Object[] { java.util.Objects.requireNonNull(type, "type is required") });
    }

    /**
     * A specific combination of ICMP type and code.
     * <p>
     * @see <a href="https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml">https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml</a>
     * @param type This parameter is required.
     * @param code This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port icmpTypeAndCode(final @org.jetbrains.annotations.NotNull java.lang.Number type, final @org.jetbrains.annotations.NotNull java.lang.Number code) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Port.class, "icmpTypeAndCode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Port.class), new Object[] { java.util.Objects.requireNonNull(type, "type is required"), java.util.Objects.requireNonNull(code, "code is required") });
    }

    /**
     * A single TCP port.
     * <p>
     * @param port This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port tcp(final @org.jetbrains.annotations.NotNull java.lang.Number port) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Port.class, "tcp", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Port.class), new Object[] { java.util.Objects.requireNonNull(port, "port is required") });
    }

    /**
     * A TCP port range.
     * <p>
     * @param startPort This parameter is required.
     * @param endPort This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port tcpRange(final @org.jetbrains.annotations.NotNull java.lang.Number startPort, final @org.jetbrains.annotations.NotNull java.lang.Number endPort) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Port.class, "tcpRange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Port.class), new Object[] { java.util.Objects.requireNonNull(startPort, "startPort is required"), java.util.Objects.requireNonNull(endPort, "endPort is required") });
    }

    /**
     * A single UDP port.
     * <p>
     * @param port This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port udp(final @org.jetbrains.annotations.NotNull java.lang.Number port) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Port.class, "udp", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Port.class), new Object[] { java.util.Objects.requireNonNull(port, "port is required") });
    }

    /**
     * A UDP port range.
     * <p>
     * @param startPort This parameter is required.
     * @param endPort This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port udpRange(final @org.jetbrains.annotations.NotNull java.lang.Number startPort, final @org.jetbrains.annotations.NotNull java.lang.Number endPort) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.Port.class, "udpRange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Port.class), new Object[] { java.util.Objects.requireNonNull(startPort, "startPort is required"), java.util.Objects.requireNonNull(endPort, "endPort is required") });
    }

    /**
     * Produce the ingress/egress rule JSON for the given connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object toRuleJson() {
        return software.amazon.jsii.Kernel.call(this, "toRuleJson", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Well-known DNS port (TCP 53).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.Port DNS_TCP;

    /**
     * Well-known DNS port (UDP 53).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.Port DNS_UDP;

    /**
     * Well-known HTTP port (TCP 80).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.Port HTTP;

    /**
     * Well-known HTTPS port (TCP 443).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.Port HTTPS;

    /**
     * Well-known IMAP port (TCP 143).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.Port IMAP;

    /**
     * Well-known IMAPS port (TCP 993).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.Port IMAPS;

    /**
     * Well-known LDAP port (TCP 389).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.Port LDAP;

    /**
     * Well-known Microsoft SQL Server port (TCP 1433).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.Port MSSQL;

    /**
     * Well-known MySQL and Aurora port (TCP 3306).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.Port MYSQL_AURORA;

    /**
     * Well-known NFS port (TCP 2049).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.Port NFS;

    /**
     * Well-known POP3 port (TCP 110).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.Port POP3;

    /**
     * Well-known POP3S port (TCP 995).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.Port POP3_S;

    /**
     * Well-known PostgreSQL port (TCP 5432).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.Port POSTGRES;

    /**
     * Well-known Microsoft Remote Desktop Protocol port (TCP 3389).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.Port RDP;

    /**
     * Well-known SMB port (TCP 445).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.Port SMB;

    /**
     * Well-known SMTP port (TCP 25).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.Port SMTP;

    /**
     * Well-known SSH port (TCP 22).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.Port SSH;

    /**
     * Whether the rule containing this port range can be inlined into a securitygroup or not.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getCanInlineRule() {
        return software.amazon.jsii.Kernel.get(this, "canInlineRule", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.Port}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.Port> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.ec2.PortProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.ec2.PortProps.Builder();
        }

        /**
         * The protocol for the range.
         * <p>
         * @return {@code this}
         * @param protocol The protocol for the range. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(final software.amazon.awscdk.services.ec2.Protocol protocol) {
            this.props.protocol(protocol);
            return this;
        }

        /**
         * String representation for this object.
         * <p>
         * @return {@code this}
         * @param stringRepresentation String representation for this object. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stringRepresentation(final java.lang.String stringRepresentation) {
            this.props.stringRepresentation(stringRepresentation);
            return this;
        }

        /**
         * The starting port for the range.
         * <p>
         * Default: - Not included in the rule
         * <p>
         * @return {@code this}
         * @param fromPort The starting port for the range. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fromPort(final java.lang.Number fromPort) {
            this.props.fromPort(fromPort);
            return this;
        }

        /**
         * The ending port for the range.
         * <p>
         * Default: - Not included in the rule
         * <p>
         * @return {@code this}
         * @param toPort The ending port for the range. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder toPort(final java.lang.Number toPort) {
            this.props.toPort(toPort);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ec2.Port}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.Port build() {
            return new software.amazon.awscdk.services.ec2.Port(
                this.props.build()
            );
        }
    }
}
