package software.amazon.awscdk.services.ec2;

/**
 * Enums for all Dns Record IP Address types.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * vpc.addInterfaceEndpoint("ExampleEndpoint", InterfaceVpcEndpointOptions.builder()
 *         .service(InterfaceVpcEndpointAwsService.ECR)
 *         .ipAddressType(VpcEndpointIpAddressType.IPV6)
 *         .dnsRecordIpType(VpcEndpointDnsRecordIpType.IPV6)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:19.611Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.VpcEndpointDnsRecordIpType")
public enum VpcEndpointDnsRecordIpType {
    /**
     * Create A records for the private, Regional, and zonal DNS names.
     * <p>
     * The IP address type must be IPv4 or Dualstack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IPV4,
    /**
     * Create AAAA records for the private, Regional, and zonal DNS names.
     * <p>
     * The IP address type must be IPv6 or Dualstack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IPV6,
    /**
     * Create A and AAAA records for the private, Regional, and zonal DNS names.
     * <p>
     * The IP address type must be Dualstack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DUALSTACK,
    /**
     * Create A records for the private, Regional, and zonal DNS names and AAAA records for the Regional and zonal DNS names.
     * <p>
     * The IP address type must be Dualstack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SERVICE_DEFINED,
}
