package software.amazon.awscdk.services.ec2;

/**
 * IP address type for the endpoint.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * vpc.addInterfaceEndpoint("ExampleEndpoint", InterfaceVpcEndpointOptions.builder()
 *         .service(InterfaceVpcEndpointAwsService.ECR)
 *         .ipAddressType(VpcEndpointIpAddressType.IPV6)
 *         .dnsRecordIpType(VpcEndpointDnsRecordIpType.IPV6)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:19.612Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.VpcEndpointIpAddressType")
public enum VpcEndpointIpAddressType {
    /**
     * Assign IPv4 addresses to the endpoint network interfaces.
     * <p>
     * This option is supported only if all selected subnets have IPv4 address ranges
     * and the endpoint service accepts IPv4 requests.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IPV4,
    /**
     * Assign IPv6 addresses to the endpoint network interfaces.
     * <p>
     * This option is supported only if all selected subnets are IPv6 only subnets
     * and the endpoint service accepts IPv6 requests.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IPV6,
    /**
     * Assign both IPv4 and IPv6 addresses to the endpoint network interfaces.
     * <p>
     * This option is supported only if all selected subnets have both IPv4 and IPv6
     * address ranges and the endpoint service accepts both IPv4 and IPv6 requests.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DUALSTACK,
}
