package software.amazon.awscdk.services.ec2;

/**
 * Options when constructing UserData for Windows.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserData windowsUserData = UserData.forWindows(WindowsUserDataOptions.builder().persist(true).build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:19.622Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.WindowsUserDataOptions")
@software.amazon.jsii.Jsii.Proxy(WindowsUserDataOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface WindowsUserDataOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Set to true to set this userdata to persist through an instance reboot;
     * <p>
     * allowing
     * it to run on every instance start.
     * By default, UserData is run only once during the first instance launch.
     * <p>
     * For more information, see:
     * https://aws.amazon.com/premiumsupport/knowledge-center/execute-user-data-ec2/
     * https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-windows-user-data.html#user-data-scripts
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPersist() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link WindowsUserDataOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link WindowsUserDataOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<WindowsUserDataOptions> {
        java.lang.Boolean persist;

        /**
         * Sets the value of {@link WindowsUserDataOptions#getPersist}
         * @param persist Set to true to set this userdata to persist through an instance reboot;.
         *                allowing
         *                it to run on every instance start.
         *                By default, UserData is run only once during the first instance launch.
         *                <p>
         *                For more information, see:
         *                https://aws.amazon.com/premiumsupport/knowledge-center/execute-user-data-ec2/
         *                https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-windows-user-data.html#user-data-scripts
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder persist(java.lang.Boolean persist) {
            this.persist = persist;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link WindowsUserDataOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public WindowsUserDataOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link WindowsUserDataOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WindowsUserDataOptions {
        private final java.lang.Boolean persist;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.persist = software.amazon.jsii.Kernel.get(this, "persist", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.persist = builder.persist;
        }

        @Override
        public final java.lang.Boolean getPersist() {
            return this.persist;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getPersist() != null) {
                data.set("persist", om.valueToTree(this.getPersist()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.WindowsUserDataOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            WindowsUserDataOptions.Jsii$Proxy that = (WindowsUserDataOptions.Jsii$Proxy) o;

            return this.persist != null ? this.persist.equals(that.persist) : that.persist == null;
        }

        @Override
        public final int hashCode() {
            int result = this.persist != null ? this.persist.hashCode() : 0;
            return result;
        }
    }
}
