package software.amazon.awscdk.services.ecr;

/**
 * Properties for defining a <code>CfnPullThroughCacheRule</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecr.*;
 * CfnPullThroughCacheRuleProps cfnPullThroughCacheRuleProps = CfnPullThroughCacheRuleProps.builder()
 *         .credentialArn("credentialArn")
 *         .customRoleArn("customRoleArn")
 *         .ecrRepositoryPrefix("ecrRepositoryPrefix")
 *         .upstreamRegistry("upstreamRegistry")
 *         .upstreamRegistryUrl("upstreamRegistryUrl")
 *         .upstreamRepositoryPrefix("upstreamRepositoryPrefix")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-pullthroughcacherule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-pullthroughcacherule.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:19.646Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecr.CfnPullThroughCacheRuleProps")
@software.amazon.jsii.Jsii.Proxy(CfnPullThroughCacheRuleProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnPullThroughCacheRuleProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the Secrets Manager secret associated with the pull through cache rule.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-pullthroughcacherule.html#cfn-ecr-pullthroughcacherule-credentialarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-pullthroughcacherule.html#cfn-ecr-pullthroughcacherule-credentialarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCredentialArn() {
        return null;
    }

    /**
     * The ARN of the IAM role associated with the pull through cache rule.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-pullthroughcacherule.html#cfn-ecr-pullthroughcacherule-customrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-pullthroughcacherule.html#cfn-ecr-pullthroughcacherule-customrolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCustomRoleArn() {
        return null;
    }

    /**
     * The Amazon ECR repository prefix associated with the pull through cache rule.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-pullthroughcacherule.html#cfn-ecr-pullthroughcacherule-ecrrepositoryprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-pullthroughcacherule.html#cfn-ecr-pullthroughcacherule-ecrrepositoryprefix</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEcrRepositoryPrefix() {
        return null;
    }

    /**
     * The name of the upstream source registry associated with the pull through cache rule.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-pullthroughcacherule.html#cfn-ecr-pullthroughcacherule-upstreamregistry">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-pullthroughcacherule.html#cfn-ecr-pullthroughcacherule-upstreamregistry</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getUpstreamRegistry() {
        return null;
    }

    /**
     * The upstream registry URL associated with the pull through cache rule.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-pullthroughcacherule.html#cfn-ecr-pullthroughcacherule-upstreamregistryurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-pullthroughcacherule.html#cfn-ecr-pullthroughcacherule-upstreamregistryurl</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getUpstreamRegistryUrl() {
        return null;
    }

    /**
     * The upstream repository prefix associated with the pull through cache rule.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-pullthroughcacherule.html#cfn-ecr-pullthroughcacherule-upstreamrepositoryprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecr-pullthroughcacherule.html#cfn-ecr-pullthroughcacherule-upstreamrepositoryprefix</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getUpstreamRepositoryPrefix() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnPullThroughCacheRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnPullThroughCacheRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnPullThroughCacheRuleProps> {
        java.lang.String credentialArn;
        java.lang.String customRoleArn;
        java.lang.String ecrRepositoryPrefix;
        java.lang.String upstreamRegistry;
        java.lang.String upstreamRegistryUrl;
        java.lang.String upstreamRepositoryPrefix;

        /**
         * Sets the value of {@link CfnPullThroughCacheRuleProps#getCredentialArn}
         * @param credentialArn The ARN of the Secrets Manager secret associated with the pull through cache rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentialArn(java.lang.String credentialArn) {
            this.credentialArn = credentialArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnPullThroughCacheRuleProps#getCustomRoleArn}
         * @param customRoleArn The ARN of the IAM role associated with the pull through cache rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customRoleArn(java.lang.String customRoleArn) {
            this.customRoleArn = customRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnPullThroughCacheRuleProps#getEcrRepositoryPrefix}
         * @param ecrRepositoryPrefix The Amazon ECR repository prefix associated with the pull through cache rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ecrRepositoryPrefix(java.lang.String ecrRepositoryPrefix) {
            this.ecrRepositoryPrefix = ecrRepositoryPrefix;
            return this;
        }

        /**
         * Sets the value of {@link CfnPullThroughCacheRuleProps#getUpstreamRegistry}
         * @param upstreamRegistry The name of the upstream source registry associated with the pull through cache rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder upstreamRegistry(java.lang.String upstreamRegistry) {
            this.upstreamRegistry = upstreamRegistry;
            return this;
        }

        /**
         * Sets the value of {@link CfnPullThroughCacheRuleProps#getUpstreamRegistryUrl}
         * @param upstreamRegistryUrl The upstream registry URL associated with the pull through cache rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder upstreamRegistryUrl(java.lang.String upstreamRegistryUrl) {
            this.upstreamRegistryUrl = upstreamRegistryUrl;
            return this;
        }

        /**
         * Sets the value of {@link CfnPullThroughCacheRuleProps#getUpstreamRepositoryPrefix}
         * @param upstreamRepositoryPrefix The upstream repository prefix associated with the pull through cache rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder upstreamRepositoryPrefix(java.lang.String upstreamRepositoryPrefix) {
            this.upstreamRepositoryPrefix = upstreamRepositoryPrefix;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnPullThroughCacheRuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnPullThroughCacheRuleProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnPullThroughCacheRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnPullThroughCacheRuleProps {
        private final java.lang.String credentialArn;
        private final java.lang.String customRoleArn;
        private final java.lang.String ecrRepositoryPrefix;
        private final java.lang.String upstreamRegistry;
        private final java.lang.String upstreamRegistryUrl;
        private final java.lang.String upstreamRepositoryPrefix;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.credentialArn = software.amazon.jsii.Kernel.get(this, "credentialArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.customRoleArn = software.amazon.jsii.Kernel.get(this, "customRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ecrRepositoryPrefix = software.amazon.jsii.Kernel.get(this, "ecrRepositoryPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.upstreamRegistry = software.amazon.jsii.Kernel.get(this, "upstreamRegistry", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.upstreamRegistryUrl = software.amazon.jsii.Kernel.get(this, "upstreamRegistryUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.upstreamRepositoryPrefix = software.amazon.jsii.Kernel.get(this, "upstreamRepositoryPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.credentialArn = builder.credentialArn;
            this.customRoleArn = builder.customRoleArn;
            this.ecrRepositoryPrefix = builder.ecrRepositoryPrefix;
            this.upstreamRegistry = builder.upstreamRegistry;
            this.upstreamRegistryUrl = builder.upstreamRegistryUrl;
            this.upstreamRepositoryPrefix = builder.upstreamRepositoryPrefix;
        }

        @Override
        public final java.lang.String getCredentialArn() {
            return this.credentialArn;
        }

        @Override
        public final java.lang.String getCustomRoleArn() {
            return this.customRoleArn;
        }

        @Override
        public final java.lang.String getEcrRepositoryPrefix() {
            return this.ecrRepositoryPrefix;
        }

        @Override
        public final java.lang.String getUpstreamRegistry() {
            return this.upstreamRegistry;
        }

        @Override
        public final java.lang.String getUpstreamRegistryUrl() {
            return this.upstreamRegistryUrl;
        }

        @Override
        public final java.lang.String getUpstreamRepositoryPrefix() {
            return this.upstreamRepositoryPrefix;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCredentialArn() != null) {
                data.set("credentialArn", om.valueToTree(this.getCredentialArn()));
            }
            if (this.getCustomRoleArn() != null) {
                data.set("customRoleArn", om.valueToTree(this.getCustomRoleArn()));
            }
            if (this.getEcrRepositoryPrefix() != null) {
                data.set("ecrRepositoryPrefix", om.valueToTree(this.getEcrRepositoryPrefix()));
            }
            if (this.getUpstreamRegistry() != null) {
                data.set("upstreamRegistry", om.valueToTree(this.getUpstreamRegistry()));
            }
            if (this.getUpstreamRegistryUrl() != null) {
                data.set("upstreamRegistryUrl", om.valueToTree(this.getUpstreamRegistryUrl()));
            }
            if (this.getUpstreamRepositoryPrefix() != null) {
                data.set("upstreamRepositoryPrefix", om.valueToTree(this.getUpstreamRepositoryPrefix()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecr.CfnPullThroughCacheRuleProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnPullThroughCacheRuleProps.Jsii$Proxy that = (CfnPullThroughCacheRuleProps.Jsii$Proxy) o;

            if (this.credentialArn != null ? !this.credentialArn.equals(that.credentialArn) : that.credentialArn != null) return false;
            if (this.customRoleArn != null ? !this.customRoleArn.equals(that.customRoleArn) : that.customRoleArn != null) return false;
            if (this.ecrRepositoryPrefix != null ? !this.ecrRepositoryPrefix.equals(that.ecrRepositoryPrefix) : that.ecrRepositoryPrefix != null) return false;
            if (this.upstreamRegistry != null ? !this.upstreamRegistry.equals(that.upstreamRegistry) : that.upstreamRegistry != null) return false;
            if (this.upstreamRegistryUrl != null ? !this.upstreamRegistryUrl.equals(that.upstreamRegistryUrl) : that.upstreamRegistryUrl != null) return false;
            return this.upstreamRepositoryPrefix != null ? this.upstreamRepositoryPrefix.equals(that.upstreamRepositoryPrefix) : that.upstreamRepositoryPrefix == null;
        }

        @Override
        public final int hashCode() {
            int result = this.credentialArn != null ? this.credentialArn.hashCode() : 0;
            result = 31 * result + (this.customRoleArn != null ? this.customRoleArn.hashCode() : 0);
            result = 31 * result + (this.ecrRepositoryPrefix != null ? this.ecrRepositoryPrefix.hashCode() : 0);
            result = 31 * result + (this.upstreamRegistry != null ? this.upstreamRegistry.hashCode() : 0);
            result = 31 * result + (this.upstreamRegistryUrl != null ? this.upstreamRegistryUrl.hashCode() : 0);
            result = 31 * result + (this.upstreamRepositoryPrefix != null ? this.upstreamRepositoryPrefix.hashCode() : 0);
            return result;
        }
    }
}
