package software.amazon.awscdk.services.ecs;

/**
 * Deployment behavior when an ECS Service Deployment Alarm is triggered.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.cloudwatch.*;
 * Cluster cluster;
 * TaskDefinition taskDefinition;
 * Alarm elbAlarm;
 * FargateService service = FargateService.Builder.create(this, "Service")
 *         .cluster(cluster)
 *         .taskDefinition(taskDefinition)
 *         .minHealthyPercent(100)
 *         .deploymentAlarms(DeploymentAlarmConfig.builder()
 *                 .alarmNames(List.of(elbAlarm.getAlarmName()))
 *                 .behavior(AlarmBehavior.ROLLBACK_ON_ALARM)
 *                 .build())
 *         .build();
 * // Defining a deployment alarm after the service has been created
 * String cpuAlarmName = "MyCpuMetricAlarm";
 * Alarm.Builder.create(this, "CPUAlarm")
 *         .alarmName(cpuAlarmName)
 *         .metric(service.metricCpuUtilization())
 *         .evaluationPeriods(2)
 *         .threshold(80)
 *         .build();
 * service.enableDeploymentAlarms(List.of(cpuAlarmName), DeploymentAlarmOptions.builder()
 *         .behavior(AlarmBehavior.FAIL_ON_ALARM)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:19.747Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.AlarmBehavior")
public enum AlarmBehavior {
    /**
     * ROLLBACK_ON_ALARM causes the service to roll back to the previous deployment when any deployment alarm enters the 'Alarm' state.
     * <p>
     * The Cloudformation stack
     * will be rolled back and enter state "UPDATE_ROLLBACK_COMPLETE".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ROLLBACK_ON_ALARM,
    /**
     * FAIL_ON_ALARM causes the deployment to fail immediately when any deployment alarm enters the 'Alarm' state.
     * <p>
     * In order to restore functionality, you must
     * roll the stack forward by pushing a new version of the ECS service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FAIL_ON_ALARM,
}
