package software.amazon.awscdk.services.ecs;

/**
 * Options for AlternateTarget configuration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecs.*;
 * import software.amazon.awscdk.services.iam.*;
 * ListenerRuleConfiguration listenerRuleConfiguration;
 * Role role;
 * AlternateTargetOptions alternateTargetOptions = AlternateTargetOptions.builder()
 *         .role(role)
 *         .testListener(listenerRuleConfiguration)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:19.748Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.AlternateTargetOptions")
@software.amazon.jsii.Jsii.Proxy(AlternateTargetOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AlternateTargetOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The IAM role for the configuration.
     * <p>
     * Default: - a new role will be created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * The test listener configuration.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.ListenerRuleConfiguration getTestListener() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AlternateTargetOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AlternateTargetOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AlternateTargetOptions> {
        software.amazon.awscdk.services.iam.IRole role;
        software.amazon.awscdk.services.ecs.ListenerRuleConfiguration testListener;

        /**
         * Sets the value of {@link AlternateTargetOptions#getRole}
         * @param role The IAM role for the configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link AlternateTargetOptions#getTestListener}
         * @param testListener The test listener configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder testListener(software.amazon.awscdk.services.ecs.ListenerRuleConfiguration testListener) {
            this.testListener = testListener;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AlternateTargetOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AlternateTargetOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AlternateTargetOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AlternateTargetOptions {
        private final software.amazon.awscdk.services.iam.IRole role;
        private final software.amazon.awscdk.services.ecs.ListenerRuleConfiguration testListener;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.testListener = software.amazon.jsii.Kernel.get(this, "testListener", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ListenerRuleConfiguration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.role = builder.role;
            this.testListener = builder.testListener;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.ListenerRuleConfiguration getTestListener() {
            return this.testListener;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getTestListener() != null) {
                data.set("testListener", om.valueToTree(this.getTestListener()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.AlternateTargetOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AlternateTargetOptions.Jsii$Proxy that = (AlternateTargetOptions.Jsii$Proxy) o;

            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            return this.testListener != null ? this.testListener.equals(that.testListener) : that.testListener == null;
        }

        @Override
        public final int hashCode() {
            int result = this.role != null ? this.role.hashCode() : 0;
            result = 31 * result + (this.testListener != null ? this.testListener.hashCode() : 0);
            return result;
        }
    }
}
