package software.amazon.awscdk.services.ecs;

/**
 * Creates a capacity provider.
 * <p>
 * Capacity providers are associated with a cluster and are used in capacity provider strategies to facilitate cluster auto scaling. You can create capacity providers for Amazon ECS Managed Instances and EC2 instances. AWS Fargate has the predefined <code>FARGATE</code> and <code>FARGATE_SPOT</code> capacity providers.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecs.*;
 * CfnCapacityProvider cfnCapacityProvider = CfnCapacityProvider.Builder.create(this, "MyCfnCapacityProvider")
 *         .autoScalingGroupProvider(AutoScalingGroupProviderProperty.builder()
 *                 .autoScalingGroupArn("autoScalingGroupArn")
 *                 // the properties below are optional
 *                 .managedDraining("managedDraining")
 *                 .managedScaling(ManagedScalingProperty.builder()
 *                         .instanceWarmupPeriod(123)
 *                         .maximumScalingStepSize(123)
 *                         .minimumScalingStepSize(123)
 *                         .status("status")
 *                         .targetCapacity(123)
 *                         .build())
 *                 .managedTerminationProtection("managedTerminationProtection")
 *                 .build())
 *         .clusterName("clusterName")
 *         .managedInstancesProvider(ManagedInstancesProviderProperty.builder()
 *                 .infrastructureRoleArn("infrastructureRoleArn")
 *                 .instanceLaunchTemplate(InstanceLaunchTemplateProperty.builder()
 *                         .ec2InstanceProfileArn("ec2InstanceProfileArn")
 *                         .networkConfiguration(ManagedInstancesNetworkConfigurationProperty.builder()
 *                                 .subnets(List.of("subnets"))
 *                                 // the properties below are optional
 *                                 .securityGroups(List.of("securityGroups"))
 *                                 .build())
 *                         // the properties below are optional
 *                         .instanceRequirements(InstanceRequirementsRequestProperty.builder()
 *                                 .memoryMiB(MemoryMiBRequestProperty.builder()
 *                                         .min(123)
 *                                         // the properties below are optional
 *                                         .max(123)
 *                                         .build())
 *                                 .vCpuCount(VCpuCountRangeRequestProperty.builder()
 *                                         .min(123)
 *                                         // the properties below are optional
 *                                         .max(123)
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .acceleratorCount(AcceleratorCountRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .acceleratorManufacturers(List.of("acceleratorManufacturers"))
 *                                 .acceleratorNames(List.of("acceleratorNames"))
 *                                 .acceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .acceleratorTypes(List.of("acceleratorTypes"))
 *                                 .allowedInstanceTypes(List.of("allowedInstanceTypes"))
 *                                 .bareMetal("bareMetal")
 *                                 .baselineEbsBandwidthMbps(BaselineEbsBandwidthMbpsRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .burstablePerformance("burstablePerformance")
 *                                 .cpuManufacturers(List.of("cpuManufacturers"))
 *                                 .excludedInstanceTypes(List.of("excludedInstanceTypes"))
 *                                 .instanceGenerations(List.of("instanceGenerations"))
 *                                 .localStorage("localStorage")
 *                                 .localStorageTypes(List.of("localStorageTypes"))
 *                                 .maxSpotPriceAsPercentageOfOptimalOnDemandPrice(123)
 *                                 .memoryGiBPerVCpu(MemoryGiBPerVCpuRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .networkBandwidthGbps(NetworkBandwidthGbpsRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .networkInterfaceCount(NetworkInterfaceCountRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .onDemandMaxPricePercentageOverLowestPrice(123)
 *                                 .requireHibernateSupport(false)
 *                                 .spotMaxPricePercentageOverLowestPrice(123)
 *                                 .totalLocalStorageGb(TotalLocalStorageGBRequestProperty.builder()
 *                                         .max(123)
 *                                         .min(123)
 *                                         .build())
 *                                 .build())
 *                         .monitoring("monitoring")
 *                         .storageConfiguration(ManagedInstancesStorageConfigurationProperty.builder()
 *                                 .storageSizeGiB(123)
 *                                 .build())
 *                         .build())
 *                 // the properties below are optional
 *                 .infrastructureOptimization(InfrastructureOptimizationProperty.builder()
 *                         .scaleInAfter(123)
 *                         .build())
 *                 .propagateTags("propagateTags")
 *                 .build())
 *         .name("name")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-capacityprovider.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-capacityprovider.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:19.787Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnCapacityProvider")
public class CfnCapacityProvider extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.ecs.ICapacityProviderRef, software.amazon.awscdk.ITaggable {

    protected CfnCapacityProvider(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCapacityProvider(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ecs.CfnCapacityProvider.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::ECS::CapacityProvider</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCapacityProvider(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.CfnCapacityProviderProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new <code>AWS::ECS::CapacityProvider</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCapacityProvider(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * @param resource This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String arnForCapacityProvider(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.ecs.ICapacityProviderRef resource) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.CfnCapacityProvider.class, "arnForCapacityProvider", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(resource, "resource is required") });
    }

    /**
     * Creates a new ICapacityProviderRef from a capacityProviderName.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param capacityProviderName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.ecs.ICapacityProviderRef fromCapacityProviderName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String capacityProviderName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.CfnCapacityProvider.class, "fromCapacityProviderName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.ecs.ICapacityProviderRef.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(capacityProviderName, "capacityProviderName is required") });
    }

    /**
     * Checks whether the given object is a CfnCapacityProvider.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isCfnCapacityProvider(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.CfnCapacityProvider.class, "isCfnCapacityProvider", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * A reference to a CapacityProvider resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.ecs.CapacityProviderReference getCapacityProviderRef() {
        return software.amazon.jsii.Kernel.get(this, "capacityProviderRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.ecs.CapacityProviderReference.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The Auto Scaling group settings for the capacity provider.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ecs.CfnCapacityProvider.AutoScalingGroupProviderProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAutoScalingGroupProvider() {
        return software.amazon.jsii.Kernel.get(this, "autoScalingGroupProvider", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The Auto Scaling group settings for the capacity provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoScalingGroupProvider(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "autoScalingGroupProvider", value);
    }

    /**
     * The Auto Scaling group settings for the capacity provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoScalingGroupProvider(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.CfnCapacityProvider.AutoScalingGroupProviderProperty value) {
        software.amazon.jsii.Kernel.set(this, "autoScalingGroupProvider", value);
    }

    /**
     * The cluster that this capacity provider is associated with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getClusterName() {
        return software.amazon.jsii.Kernel.get(this, "clusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The cluster that this capacity provider is associated with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClusterName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "clusterName", value);
    }

    /**
     * The configuration for the Amazon ECS Managed Instances provider.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ecs.CfnCapacityProvider.ManagedInstancesProviderProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getManagedInstancesProvider() {
        return software.amazon.jsii.Kernel.get(this, "managedInstancesProvider", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration for the Amazon ECS Managed Instances provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setManagedInstancesProvider(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "managedInstancesProvider", value);
    }

    /**
     * The configuration for the Amazon ECS Managed Instances provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setManagedInstancesProvider(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.CfnCapacityProvider.ManagedInstancesProviderProperty value) {
        software.amazon.jsii.Kernel.set(this, "managedInstancesProvider", value);
    }

    /**
     * The name of the capacity provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the capacity provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * The metadata that you apply to the capacity provider to help you categorize and organize it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The metadata that you apply to the capacity provider to help you categorize and organize it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * The minimum and maximum number of accelerators (such as GPUs) for instance type selection.
     * <p>
     * This is used for workloads that require specific numbers of accelerators.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * AcceleratorCountRequestProperty acceleratorCountRequestProperty = AcceleratorCountRequestProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-acceleratorcountrequest.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-acceleratorcountrequest.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnCapacityProvider.AcceleratorCountRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(AcceleratorCountRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AcceleratorCountRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum number of accelerators.
         * <p>
         * Instance types with more accelerators are excluded from selection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-acceleratorcountrequest.html#cfn-ecs-capacityprovider-acceleratorcountrequest-max">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-acceleratorcountrequest.html#cfn-ecs-capacityprovider-acceleratorcountrequest-max</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * The minimum number of accelerators.
         * <p>
         * Instance types with fewer accelerators are excluded from selection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-acceleratorcountrequest.html#cfn-ecs-capacityprovider-acceleratorcountrequest-min">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-acceleratorcountrequest.html#cfn-ecs-capacityprovider-acceleratorcountrequest-min</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AcceleratorCountRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AcceleratorCountRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AcceleratorCountRequestProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link AcceleratorCountRequestProperty#getMax}
             * @param max The maximum number of accelerators.
             *            Instance types with more accelerators are excluded from selection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link AcceleratorCountRequestProperty#getMin}
             * @param min The minimum number of accelerators.
             *            Instance types with fewer accelerators are excluded from selection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AcceleratorCountRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AcceleratorCountRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AcceleratorCountRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AcceleratorCountRequestProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnCapacityProvider.AcceleratorCountRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AcceleratorCountRequestProperty.Jsii$Proxy that = (AcceleratorCountRequestProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The minimum and maximum total accelerator memory in mebibytes (MiB) for instance type selection.
     * <p>
     * This is important for GPU workloads that require specific amounts of video memory.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * AcceleratorTotalMemoryMiBRequestProperty acceleratorTotalMemoryMiBRequestProperty = AcceleratorTotalMemoryMiBRequestProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-acceleratortotalmemorymibrequest.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-acceleratortotalmemorymibrequest.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnCapacityProvider.AcceleratorTotalMemoryMiBRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(AcceleratorTotalMemoryMiBRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AcceleratorTotalMemoryMiBRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum total accelerator memory in MiB.
         * <p>
         * Instance types with more accelerator memory are excluded from selection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-acceleratortotalmemorymibrequest.html#cfn-ecs-capacityprovider-acceleratortotalmemorymibrequest-max">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-acceleratortotalmemorymibrequest.html#cfn-ecs-capacityprovider-acceleratortotalmemorymibrequest-max</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * The minimum total accelerator memory in MiB.
         * <p>
         * Instance types with less accelerator memory are excluded from selection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-acceleratortotalmemorymibrequest.html#cfn-ecs-capacityprovider-acceleratortotalmemorymibrequest-min">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-acceleratortotalmemorymibrequest.html#cfn-ecs-capacityprovider-acceleratortotalmemorymibrequest-min</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AcceleratorTotalMemoryMiBRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AcceleratorTotalMemoryMiBRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AcceleratorTotalMemoryMiBRequestProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link AcceleratorTotalMemoryMiBRequestProperty#getMax}
             * @param max The maximum total accelerator memory in MiB.
             *            Instance types with more accelerator memory are excluded from selection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link AcceleratorTotalMemoryMiBRequestProperty#getMin}
             * @param min The minimum total accelerator memory in MiB.
             *            Instance types with less accelerator memory are excluded from selection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AcceleratorTotalMemoryMiBRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AcceleratorTotalMemoryMiBRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AcceleratorTotalMemoryMiBRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AcceleratorTotalMemoryMiBRequestProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnCapacityProvider.AcceleratorTotalMemoryMiBRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AcceleratorTotalMemoryMiBRequestProperty.Jsii$Proxy that = (AcceleratorTotalMemoryMiBRequestProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The details of the Auto Scaling group for the capacity provider.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * AutoScalingGroupProviderProperty autoScalingGroupProviderProperty = AutoScalingGroupProviderProperty.builder()
     *         .autoScalingGroupArn("autoScalingGroupArn")
     *         // the properties below are optional
     *         .managedDraining("managedDraining")
     *         .managedScaling(ManagedScalingProperty.builder()
     *                 .instanceWarmupPeriod(123)
     *                 .maximumScalingStepSize(123)
     *                 .minimumScalingStepSize(123)
     *                 .status("status")
     *                 .targetCapacity(123)
     *                 .build())
     *         .managedTerminationProtection("managedTerminationProtection")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-autoscalinggroupprovider.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-autoscalinggroupprovider.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnCapacityProvider.AutoScalingGroupProviderProperty")
    @software.amazon.jsii.Jsii.Proxy(AutoScalingGroupProviderProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AutoScalingGroupProviderProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) that identifies the Auto Scaling group, or the Auto Scaling group name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-autoscalinggroupprovider.html#cfn-ecs-capacityprovider-autoscalinggroupprovider-autoscalinggrouparn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-autoscalinggroupprovider.html#cfn-ecs-capacityprovider-autoscalinggroupprovider-autoscalinggrouparn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAutoScalingGroupArn();

        /**
         * The managed draining option for the Auto Scaling group capacity provider.
         * <p>
         * When you enable this, Amazon ECS manages and gracefully drains the EC2 container instances that are in the Auto Scaling group capacity provider.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-autoscalinggroupprovider.html#cfn-ecs-capacityprovider-autoscalinggroupprovider-manageddraining">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-autoscalinggroupprovider.html#cfn-ecs-capacityprovider-autoscalinggroupprovider-manageddraining</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getManagedDraining() {
            return null;
        }

        /**
         * The managed scaling settings for the Auto Scaling group capacity provider.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ecs.CfnCapacityProvider.ManagedScalingProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-autoscalinggroupprovider.html#cfn-ecs-capacityprovider-autoscalinggroupprovider-managedscaling">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-autoscalinggroupprovider.html#cfn-ecs-capacityprovider-autoscalinggroupprovider-managedscaling</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getManagedScaling() {
            return null;
        }

        /**
         * The managed termination protection setting to use for the Auto Scaling group capacity provider.
         * <p>
         * This determines whether the Auto Scaling group has managed termination protection. The default is off.
         * <p>
         * <blockquote>
         * <p>
         * When using managed termination protection, managed scaling must also be used otherwise managed termination protection doesn't work.
         * <p>
         * </blockquote>
         * <p>
         * When managed termination protection is on, Amazon ECS prevents the Amazon EC2 instances in an Auto Scaling group that contain tasks from being terminated during a scale-in action. The Auto Scaling group and each instance in the Auto Scaling group must have instance protection from scale-in actions on as well. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html#instance-protection">Instance Protection</a> in the <em>AWS Auto Scaling User Guide</em> .
         * <p>
         * When managed termination protection is off, your Amazon EC2 instances aren't protected from termination when the Auto Scaling group scales in.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-autoscalinggroupprovider.html#cfn-ecs-capacityprovider-autoscalinggroupprovider-managedterminationprotection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-autoscalinggroupprovider.html#cfn-ecs-capacityprovider-autoscalinggroupprovider-managedterminationprotection</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getManagedTerminationProtection() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AutoScalingGroupProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AutoScalingGroupProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AutoScalingGroupProviderProperty> {
            java.lang.String autoScalingGroupArn;
            java.lang.String managedDraining;
            java.lang.Object managedScaling;
            java.lang.String managedTerminationProtection;

            /**
             * Sets the value of {@link AutoScalingGroupProviderProperty#getAutoScalingGroupArn}
             * @param autoScalingGroupArn The Amazon Resource Name (ARN) that identifies the Auto Scaling group, or the Auto Scaling group name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoScalingGroupArn(java.lang.String autoScalingGroupArn) {
                this.autoScalingGroupArn = autoScalingGroupArn;
                return this;
            }

            /**
             * Sets the value of {@link AutoScalingGroupProviderProperty#getManagedDraining}
             * @param managedDraining The managed draining option for the Auto Scaling group capacity provider.
             *                        When you enable this, Amazon ECS manages and gracefully drains the EC2 container instances that are in the Auto Scaling group capacity provider.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder managedDraining(java.lang.String managedDraining) {
                this.managedDraining = managedDraining;
                return this;
            }

            /**
             * Sets the value of {@link AutoScalingGroupProviderProperty#getManagedScaling}
             * @param managedScaling The managed scaling settings for the Auto Scaling group capacity provider.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder managedScaling(software.amazon.awscdk.IResolvable managedScaling) {
                this.managedScaling = managedScaling;
                return this;
            }

            /**
             * Sets the value of {@link AutoScalingGroupProviderProperty#getManagedScaling}
             * @param managedScaling The managed scaling settings for the Auto Scaling group capacity provider.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder managedScaling(software.amazon.awscdk.services.ecs.CfnCapacityProvider.ManagedScalingProperty managedScaling) {
                this.managedScaling = managedScaling;
                return this;
            }

            /**
             * Sets the value of {@link AutoScalingGroupProviderProperty#getManagedTerminationProtection}
             * @param managedTerminationProtection The managed termination protection setting to use for the Auto Scaling group capacity provider.
             *                                     This determines whether the Auto Scaling group has managed termination protection. The default is off.
             *                                     <p>
             *                                     <blockquote>
             *                                     <p>
             *                                     When using managed termination protection, managed scaling must also be used otherwise managed termination protection doesn't work.
             *                                     <p>
             *                                     </blockquote>
             *                                     <p>
             *                                     When managed termination protection is on, Amazon ECS prevents the Amazon EC2 instances in an Auto Scaling group that contain tasks from being terminated during a scale-in action. The Auto Scaling group and each instance in the Auto Scaling group must have instance protection from scale-in actions on as well. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html#instance-protection">Instance Protection</a> in the <em>AWS Auto Scaling User Guide</em> .
             *                                     <p>
             *                                     When managed termination protection is off, your Amazon EC2 instances aren't protected from termination when the Auto Scaling group scales in.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder managedTerminationProtection(java.lang.String managedTerminationProtection) {
                this.managedTerminationProtection = managedTerminationProtection;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AutoScalingGroupProviderProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AutoScalingGroupProviderProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AutoScalingGroupProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutoScalingGroupProviderProperty {
            private final java.lang.String autoScalingGroupArn;
            private final java.lang.String managedDraining;
            private final java.lang.Object managedScaling;
            private final java.lang.String managedTerminationProtection;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.autoScalingGroupArn = software.amazon.jsii.Kernel.get(this, "autoScalingGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.managedDraining = software.amazon.jsii.Kernel.get(this, "managedDraining", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.managedScaling = software.amazon.jsii.Kernel.get(this, "managedScaling", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.managedTerminationProtection = software.amazon.jsii.Kernel.get(this, "managedTerminationProtection", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.autoScalingGroupArn = java.util.Objects.requireNonNull(builder.autoScalingGroupArn, "autoScalingGroupArn is required");
                this.managedDraining = builder.managedDraining;
                this.managedScaling = builder.managedScaling;
                this.managedTerminationProtection = builder.managedTerminationProtection;
            }

            @Override
            public final java.lang.String getAutoScalingGroupArn() {
                return this.autoScalingGroupArn;
            }

            @Override
            public final java.lang.String getManagedDraining() {
                return this.managedDraining;
            }

            @Override
            public final java.lang.Object getManagedScaling() {
                return this.managedScaling;
            }

            @Override
            public final java.lang.String getManagedTerminationProtection() {
                return this.managedTerminationProtection;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("autoScalingGroupArn", om.valueToTree(this.getAutoScalingGroupArn()));
                if (this.getManagedDraining() != null) {
                    data.set("managedDraining", om.valueToTree(this.getManagedDraining()));
                }
                if (this.getManagedScaling() != null) {
                    data.set("managedScaling", om.valueToTree(this.getManagedScaling()));
                }
                if (this.getManagedTerminationProtection() != null) {
                    data.set("managedTerminationProtection", om.valueToTree(this.getManagedTerminationProtection()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnCapacityProvider.AutoScalingGroupProviderProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AutoScalingGroupProviderProperty.Jsii$Proxy that = (AutoScalingGroupProviderProperty.Jsii$Proxy) o;

                if (!autoScalingGroupArn.equals(that.autoScalingGroupArn)) return false;
                if (this.managedDraining != null ? !this.managedDraining.equals(that.managedDraining) : that.managedDraining != null) return false;
                if (this.managedScaling != null ? !this.managedScaling.equals(that.managedScaling) : that.managedScaling != null) return false;
                return this.managedTerminationProtection != null ? this.managedTerminationProtection.equals(that.managedTerminationProtection) : that.managedTerminationProtection == null;
            }

            @Override
            public final int hashCode() {
                int result = this.autoScalingGroupArn.hashCode();
                result = 31 * result + (this.managedDraining != null ? this.managedDraining.hashCode() : 0);
                result = 31 * result + (this.managedScaling != null ? this.managedScaling.hashCode() : 0);
                result = 31 * result + (this.managedTerminationProtection != null ? this.managedTerminationProtection.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The minimum and maximum baseline Amazon EBS bandwidth in megabits per second (Mbps) for instance type selection.
     * <p>
     * This is important for workloads with high storage I/O requirements.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * BaselineEbsBandwidthMbpsRequestProperty baselineEbsBandwidthMbpsRequestProperty = BaselineEbsBandwidthMbpsRequestProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-baselineebsbandwidthmbpsrequest.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-baselineebsbandwidthmbpsrequest.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnCapacityProvider.BaselineEbsBandwidthMbpsRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(BaselineEbsBandwidthMbpsRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BaselineEbsBandwidthMbpsRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum baseline Amazon EBS bandwidth in Mbps.
         * <p>
         * Instance types with higher Amazon EBS bandwidth are excluded from selection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-baselineebsbandwidthmbpsrequest.html#cfn-ecs-capacityprovider-baselineebsbandwidthmbpsrequest-max">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-baselineebsbandwidthmbpsrequest.html#cfn-ecs-capacityprovider-baselineebsbandwidthmbpsrequest-max</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * The minimum baseline Amazon EBS bandwidth in Mbps.
         * <p>
         * Instance types with lower Amazon EBS bandwidth are excluded from selection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-baselineebsbandwidthmbpsrequest.html#cfn-ecs-capacityprovider-baselineebsbandwidthmbpsrequest-min">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-baselineebsbandwidthmbpsrequest.html#cfn-ecs-capacityprovider-baselineebsbandwidthmbpsrequest-min</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BaselineEbsBandwidthMbpsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BaselineEbsBandwidthMbpsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BaselineEbsBandwidthMbpsRequestProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link BaselineEbsBandwidthMbpsRequestProperty#getMax}
             * @param max The maximum baseline Amazon EBS bandwidth in Mbps.
             *            Instance types with higher Amazon EBS bandwidth are excluded from selection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link BaselineEbsBandwidthMbpsRequestProperty#getMin}
             * @param min The minimum baseline Amazon EBS bandwidth in Mbps.
             *            Instance types with lower Amazon EBS bandwidth are excluded from selection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BaselineEbsBandwidthMbpsRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BaselineEbsBandwidthMbpsRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BaselineEbsBandwidthMbpsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BaselineEbsBandwidthMbpsRequestProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnCapacityProvider.BaselineEbsBandwidthMbpsRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BaselineEbsBandwidthMbpsRequestProperty.Jsii$Proxy that = (BaselineEbsBandwidthMbpsRequestProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration that controls how Amazon ECS optimizes your infrastructure.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * InfrastructureOptimizationProperty infrastructureOptimizationProperty = InfrastructureOptimizationProperty.builder()
     *         .scaleInAfter(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-infrastructureoptimization.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-infrastructureoptimization.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnCapacityProvider.InfrastructureOptimizationProperty")
    @software.amazon.jsii.Jsii.Proxy(InfrastructureOptimizationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InfrastructureOptimizationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * This parameter defines the number of seconds Amazon ECS Managed Instances waits before optimizing EC2 instances that have become idle or underutilized.
         * <p>
         * A longer delay increases the likelihood of placing new tasks on idle or underutilized instances instances, reducing startup time. A shorter delay helps reduce infrastructure costs by optimizing idle or underutilized instances,instances more quickly.
         * <p>
         * Valid values are:
         * <p>
         * <ul>
         * <li><code>null</code> - Uses the default optimization behavior.</li>
         * <li><code>-1</code> - Disables automatic infrastructure optimization.</li>
         * <li>A value between <code>0</code> and <code>3600</code> (inclusive) - Specifies the number of seconds to wait before optimizing instances.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-infrastructureoptimization.html#cfn-ecs-capacityprovider-infrastructureoptimization-scaleinafter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-infrastructureoptimization.html#cfn-ecs-capacityprovider-infrastructureoptimization-scaleinafter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getScaleInAfter() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InfrastructureOptimizationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InfrastructureOptimizationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InfrastructureOptimizationProperty> {
            java.lang.Number scaleInAfter;

            /**
             * Sets the value of {@link InfrastructureOptimizationProperty#getScaleInAfter}
             * @param scaleInAfter This parameter defines the number of seconds Amazon ECS Managed Instances waits before optimizing EC2 instances that have become idle or underutilized.
             *                     A longer delay increases the likelihood of placing new tasks on idle or underutilized instances instances, reducing startup time. A shorter delay helps reduce infrastructure costs by optimizing idle or underutilized instances,instances more quickly.
             *                     <p>
             *                     Valid values are:
             *                     <p>
             *                     <ul>
             *                     <li><code>null</code> - Uses the default optimization behavior.</li>
             *                     <li><code>-1</code> - Disables automatic infrastructure optimization.</li>
             *                     <li>A value between <code>0</code> and <code>3600</code> (inclusive) - Specifies the number of seconds to wait before optimizing instances.</li>
             *                     </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scaleInAfter(java.lang.Number scaleInAfter) {
                this.scaleInAfter = scaleInAfter;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InfrastructureOptimizationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InfrastructureOptimizationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InfrastructureOptimizationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InfrastructureOptimizationProperty {
            private final java.lang.Number scaleInAfter;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.scaleInAfter = software.amazon.jsii.Kernel.get(this, "scaleInAfter", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.scaleInAfter = builder.scaleInAfter;
            }

            @Override
            public final java.lang.Number getScaleInAfter() {
                return this.scaleInAfter;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getScaleInAfter() != null) {
                    data.set("scaleInAfter", om.valueToTree(this.getScaleInAfter()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnCapacityProvider.InfrastructureOptimizationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InfrastructureOptimizationProperty.Jsii$Proxy that = (InfrastructureOptimizationProperty.Jsii$Proxy) o;

                return this.scaleInAfter != null ? this.scaleInAfter.equals(that.scaleInAfter) : that.scaleInAfter == null;
            }

            @Override
            public final int hashCode() {
                int result = this.scaleInAfter != null ? this.scaleInAfter.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The launch template configuration for Amazon ECS Managed Instances.
     * <p>
     * This defines how Amazon ECS launches Amazon EC2 instances, including the instance profile for your tasks, network and storage configuration, capacity options, and instance requirements for flexible instance type selection.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * InstanceLaunchTemplateProperty instanceLaunchTemplateProperty = InstanceLaunchTemplateProperty.builder()
     *         .ec2InstanceProfileArn("ec2InstanceProfileArn")
     *         .networkConfiguration(ManagedInstancesNetworkConfigurationProperty.builder()
     *                 .subnets(List.of("subnets"))
     *                 // the properties below are optional
     *                 .securityGroups(List.of("securityGroups"))
     *                 .build())
     *         // the properties below are optional
     *         .instanceRequirements(InstanceRequirementsRequestProperty.builder()
     *                 .memoryMiB(MemoryMiBRequestProperty.builder()
     *                         .min(123)
     *                         // the properties below are optional
     *                         .max(123)
     *                         .build())
     *                 .vCpuCount(VCpuCountRangeRequestProperty.builder()
     *                         .min(123)
     *                         // the properties below are optional
     *                         .max(123)
     *                         .build())
     *                 // the properties below are optional
     *                 .acceleratorCount(AcceleratorCountRequestProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .acceleratorManufacturers(List.of("acceleratorManufacturers"))
     *                 .acceleratorNames(List.of("acceleratorNames"))
     *                 .acceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBRequestProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .acceleratorTypes(List.of("acceleratorTypes"))
     *                 .allowedInstanceTypes(List.of("allowedInstanceTypes"))
     *                 .bareMetal("bareMetal")
     *                 .baselineEbsBandwidthMbps(BaselineEbsBandwidthMbpsRequestProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .burstablePerformance("burstablePerformance")
     *                 .cpuManufacturers(List.of("cpuManufacturers"))
     *                 .excludedInstanceTypes(List.of("excludedInstanceTypes"))
     *                 .instanceGenerations(List.of("instanceGenerations"))
     *                 .localStorage("localStorage")
     *                 .localStorageTypes(List.of("localStorageTypes"))
     *                 .maxSpotPriceAsPercentageOfOptimalOnDemandPrice(123)
     *                 .memoryGiBPerVCpu(MemoryGiBPerVCpuRequestProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .networkBandwidthGbps(NetworkBandwidthGbpsRequestProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .networkInterfaceCount(NetworkInterfaceCountRequestProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .onDemandMaxPricePercentageOverLowestPrice(123)
     *                 .requireHibernateSupport(false)
     *                 .spotMaxPricePercentageOverLowestPrice(123)
     *                 .totalLocalStorageGb(TotalLocalStorageGBRequestProperty.builder()
     *                         .max(123)
     *                         .min(123)
     *                         .build())
     *                 .build())
     *         .monitoring("monitoring")
     *         .storageConfiguration(ManagedInstancesStorageConfigurationProperty.builder()
     *                 .storageSizeGiB(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancelaunchtemplate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancelaunchtemplate.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnCapacityProvider.InstanceLaunchTemplateProperty")
    @software.amazon.jsii.Jsii.Proxy(InstanceLaunchTemplateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InstanceLaunchTemplateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the instance profile that Amazon ECS applies to Amazon ECS Managed Instances.
         * <p>
         * This instance profile must include the necessary permissions for your tasks to access AWS services and resources.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/managed-instances-instance-profile.html">Amazon ECS instance profile for Managed Instances</a> in the <em>Amazon ECS Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancelaunchtemplate.html#cfn-ecs-capacityprovider-instancelaunchtemplate-ec2instanceprofilearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancelaunchtemplate.html#cfn-ecs-capacityprovider-instancelaunchtemplate-ec2instanceprofilearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEc2InstanceProfileArn();

        /**
         * The network configuration for Amazon ECS Managed Instances.
         * <p>
         * This specifies the subnets and security groups that instances use for network connectivity.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ecs.CfnCapacityProvider.ManagedInstancesNetworkConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancelaunchtemplate.html#cfn-ecs-capacityprovider-instancelaunchtemplate-networkconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancelaunchtemplate.html#cfn-ecs-capacityprovider-instancelaunchtemplate-networkconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getNetworkConfiguration();

        /**
         * The instance requirements. You can specify:.
         * <p>
         * <ul>
         * <li>The instance types</li>
         * <li>Instance requirements such as vCPU count, memory, network performance, and accelerator specifications</li>
         * </ul>
         * <p>
         * Amazon ECS automatically selects the instances that match the specified criteria.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ecs.CfnCapacityProvider.InstanceRequirementsRequestProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancelaunchtemplate.html#cfn-ecs-capacityprovider-instancelaunchtemplate-instancerequirements">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancelaunchtemplate.html#cfn-ecs-capacityprovider-instancelaunchtemplate-instancerequirements</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInstanceRequirements() {
            return null;
        }

        /**
         * CloudWatch provides two categories of monitoring: basic monitoring and detailed monitoring.
         * <p>
         * By default, your managed instance is configured for basic monitoring. You can optionally enable detailed monitoring to help you more quickly identify and act on operational issues. You can enable or turn off detailed monitoring at launch or when the managed instance is running or stopped. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/detailed-monitoring-managed-instances.html">Detailed monitoring for Amazon ECS Managed Instances</a> in the Amazon ECS Developer Guide.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancelaunchtemplate.html#cfn-ecs-capacityprovider-instancelaunchtemplate-monitoring">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancelaunchtemplate.html#cfn-ecs-capacityprovider-instancelaunchtemplate-monitoring</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMonitoring() {
            return null;
        }

        /**
         * The storage configuration for Amazon ECS Managed Instances.
         * <p>
         * This defines the root volume size and type for the instances.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ecs.CfnCapacityProvider.ManagedInstancesStorageConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancelaunchtemplate.html#cfn-ecs-capacityprovider-instancelaunchtemplate-storageconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancelaunchtemplate.html#cfn-ecs-capacityprovider-instancelaunchtemplate-storageconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStorageConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InstanceLaunchTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InstanceLaunchTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InstanceLaunchTemplateProperty> {
            java.lang.String ec2InstanceProfileArn;
            java.lang.Object networkConfiguration;
            java.lang.Object instanceRequirements;
            java.lang.String monitoring;
            java.lang.Object storageConfiguration;

            /**
             * Sets the value of {@link InstanceLaunchTemplateProperty#getEc2InstanceProfileArn}
             * @param ec2InstanceProfileArn The Amazon Resource Name (ARN) of the instance profile that Amazon ECS applies to Amazon ECS Managed Instances. This parameter is required.
             *                              This instance profile must include the necessary permissions for your tasks to access AWS services and resources.
             *                              <p>
             *                              For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/managed-instances-instance-profile.html">Amazon ECS instance profile for Managed Instances</a> in the <em>Amazon ECS Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ec2InstanceProfileArn(java.lang.String ec2InstanceProfileArn) {
                this.ec2InstanceProfileArn = ec2InstanceProfileArn;
                return this;
            }

            /**
             * Sets the value of {@link InstanceLaunchTemplateProperty#getNetworkConfiguration}
             * @param networkConfiguration The network configuration for Amazon ECS Managed Instances. This parameter is required.
             *                             This specifies the subnets and security groups that instances use for network connectivity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkConfiguration(software.amazon.awscdk.IResolvable networkConfiguration) {
                this.networkConfiguration = networkConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link InstanceLaunchTemplateProperty#getNetworkConfiguration}
             * @param networkConfiguration The network configuration for Amazon ECS Managed Instances. This parameter is required.
             *                             This specifies the subnets and security groups that instances use for network connectivity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkConfiguration(software.amazon.awscdk.services.ecs.CfnCapacityProvider.ManagedInstancesNetworkConfigurationProperty networkConfiguration) {
                this.networkConfiguration = networkConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link InstanceLaunchTemplateProperty#getInstanceRequirements}
             * @param instanceRequirements The instance requirements. You can specify:.
             *                             <ul>
             *                             <li>The instance types</li>
             *                             <li>Instance requirements such as vCPU count, memory, network performance, and accelerator specifications</li>
             *                             </ul>
             *                             <p>
             *                             Amazon ECS automatically selects the instances that match the specified criteria.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceRequirements(software.amazon.awscdk.IResolvable instanceRequirements) {
                this.instanceRequirements = instanceRequirements;
                return this;
            }

            /**
             * Sets the value of {@link InstanceLaunchTemplateProperty#getInstanceRequirements}
             * @param instanceRequirements The instance requirements. You can specify:.
             *                             <ul>
             *                             <li>The instance types</li>
             *                             <li>Instance requirements such as vCPU count, memory, network performance, and accelerator specifications</li>
             *                             </ul>
             *                             <p>
             *                             Amazon ECS automatically selects the instances that match the specified criteria.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceRequirements(software.amazon.awscdk.services.ecs.CfnCapacityProvider.InstanceRequirementsRequestProperty instanceRequirements) {
                this.instanceRequirements = instanceRequirements;
                return this;
            }

            /**
             * Sets the value of {@link InstanceLaunchTemplateProperty#getMonitoring}
             * @param monitoring CloudWatch provides two categories of monitoring: basic monitoring and detailed monitoring.
             *                   By default, your managed instance is configured for basic monitoring. You can optionally enable detailed monitoring to help you more quickly identify and act on operational issues. You can enable or turn off detailed monitoring at launch or when the managed instance is running or stopped. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/detailed-monitoring-managed-instances.html">Detailed monitoring for Amazon ECS Managed Instances</a> in the Amazon ECS Developer Guide.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoring(java.lang.String monitoring) {
                this.monitoring = monitoring;
                return this;
            }

            /**
             * Sets the value of {@link InstanceLaunchTemplateProperty#getStorageConfiguration}
             * @param storageConfiguration The storage configuration for Amazon ECS Managed Instances.
             *                             This defines the root volume size and type for the instances.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder storageConfiguration(software.amazon.awscdk.IResolvable storageConfiguration) {
                this.storageConfiguration = storageConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link InstanceLaunchTemplateProperty#getStorageConfiguration}
             * @param storageConfiguration The storage configuration for Amazon ECS Managed Instances.
             *                             This defines the root volume size and type for the instances.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder storageConfiguration(software.amazon.awscdk.services.ecs.CfnCapacityProvider.ManagedInstancesStorageConfigurationProperty storageConfiguration) {
                this.storageConfiguration = storageConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceLaunchTemplateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InstanceLaunchTemplateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InstanceLaunchTemplateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceLaunchTemplateProperty {
            private final java.lang.String ec2InstanceProfileArn;
            private final java.lang.Object networkConfiguration;
            private final java.lang.Object instanceRequirements;
            private final java.lang.String monitoring;
            private final java.lang.Object storageConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ec2InstanceProfileArn = software.amazon.jsii.Kernel.get(this, "ec2InstanceProfileArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.networkConfiguration = software.amazon.jsii.Kernel.get(this, "networkConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.instanceRequirements = software.amazon.jsii.Kernel.get(this, "instanceRequirements", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.monitoring = software.amazon.jsii.Kernel.get(this, "monitoring", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.storageConfiguration = software.amazon.jsii.Kernel.get(this, "storageConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ec2InstanceProfileArn = java.util.Objects.requireNonNull(builder.ec2InstanceProfileArn, "ec2InstanceProfileArn is required");
                this.networkConfiguration = java.util.Objects.requireNonNull(builder.networkConfiguration, "networkConfiguration is required");
                this.instanceRequirements = builder.instanceRequirements;
                this.monitoring = builder.monitoring;
                this.storageConfiguration = builder.storageConfiguration;
            }

            @Override
            public final java.lang.String getEc2InstanceProfileArn() {
                return this.ec2InstanceProfileArn;
            }

            @Override
            public final java.lang.Object getNetworkConfiguration() {
                return this.networkConfiguration;
            }

            @Override
            public final java.lang.Object getInstanceRequirements() {
                return this.instanceRequirements;
            }

            @Override
            public final java.lang.String getMonitoring() {
                return this.monitoring;
            }

            @Override
            public final java.lang.Object getStorageConfiguration() {
                return this.storageConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("ec2InstanceProfileArn", om.valueToTree(this.getEc2InstanceProfileArn()));
                data.set("networkConfiguration", om.valueToTree(this.getNetworkConfiguration()));
                if (this.getInstanceRequirements() != null) {
                    data.set("instanceRequirements", om.valueToTree(this.getInstanceRequirements()));
                }
                if (this.getMonitoring() != null) {
                    data.set("monitoring", om.valueToTree(this.getMonitoring()));
                }
                if (this.getStorageConfiguration() != null) {
                    data.set("storageConfiguration", om.valueToTree(this.getStorageConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnCapacityProvider.InstanceLaunchTemplateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InstanceLaunchTemplateProperty.Jsii$Proxy that = (InstanceLaunchTemplateProperty.Jsii$Proxy) o;

                if (!ec2InstanceProfileArn.equals(that.ec2InstanceProfileArn)) return false;
                if (!networkConfiguration.equals(that.networkConfiguration)) return false;
                if (this.instanceRequirements != null ? !this.instanceRequirements.equals(that.instanceRequirements) : that.instanceRequirements != null) return false;
                if (this.monitoring != null ? !this.monitoring.equals(that.monitoring) : that.monitoring != null) return false;
                return this.storageConfiguration != null ? this.storageConfiguration.equals(that.storageConfiguration) : that.storageConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.ec2InstanceProfileArn.hashCode();
                result = 31 * result + (this.networkConfiguration.hashCode());
                result = 31 * result + (this.instanceRequirements != null ? this.instanceRequirements.hashCode() : 0);
                result = 31 * result + (this.monitoring != null ? this.monitoring.hashCode() : 0);
                result = 31 * result + (this.storageConfiguration != null ? this.storageConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The instance requirements for attribute-based instance type selection.
     * <p>
     * Instead of specifying exact instance types, you define requirements such as vCPU count, memory size, network performance, and accelerator specifications. Amazon ECS automatically selects Amazon EC2 instance types that match these requirements, providing flexibility and helping to mitigate capacity constraints.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * InstanceRequirementsRequestProperty instanceRequirementsRequestProperty = InstanceRequirementsRequestProperty.builder()
     *         .memoryMiB(MemoryMiBRequestProperty.builder()
     *                 .min(123)
     *                 // the properties below are optional
     *                 .max(123)
     *                 .build())
     *         .vCpuCount(VCpuCountRangeRequestProperty.builder()
     *                 .min(123)
     *                 // the properties below are optional
     *                 .max(123)
     *                 .build())
     *         // the properties below are optional
     *         .acceleratorCount(AcceleratorCountRequestProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .acceleratorManufacturers(List.of("acceleratorManufacturers"))
     *         .acceleratorNames(List.of("acceleratorNames"))
     *         .acceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBRequestProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .acceleratorTypes(List.of("acceleratorTypes"))
     *         .allowedInstanceTypes(List.of("allowedInstanceTypes"))
     *         .bareMetal("bareMetal")
     *         .baselineEbsBandwidthMbps(BaselineEbsBandwidthMbpsRequestProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .burstablePerformance("burstablePerformance")
     *         .cpuManufacturers(List.of("cpuManufacturers"))
     *         .excludedInstanceTypes(List.of("excludedInstanceTypes"))
     *         .instanceGenerations(List.of("instanceGenerations"))
     *         .localStorage("localStorage")
     *         .localStorageTypes(List.of("localStorageTypes"))
     *         .maxSpotPriceAsPercentageOfOptimalOnDemandPrice(123)
     *         .memoryGiBPerVCpu(MemoryGiBPerVCpuRequestProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .networkBandwidthGbps(NetworkBandwidthGbpsRequestProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .networkInterfaceCount(NetworkInterfaceCountRequestProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .onDemandMaxPricePercentageOverLowestPrice(123)
     *         .requireHibernateSupport(false)
     *         .spotMaxPricePercentageOverLowestPrice(123)
     *         .totalLocalStorageGb(TotalLocalStorageGBRequestProperty.builder()
     *                 .max(123)
     *                 .min(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnCapacityProvider.InstanceRequirementsRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(InstanceRequirementsRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InstanceRequirementsRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The minimum and maximum amount of memory in mebibytes (MiB) for the instance types.
         * <p>
         * Amazon ECS selects instance types that have memory within this range.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ecs.CfnCapacityProvider.MemoryMiBRequestProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html#cfn-ecs-capacityprovider-instancerequirementsrequest-memorymib">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html#cfn-ecs-capacityprovider-instancerequirementsrequest-memorymib</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMemoryMiB();

        /**
         * The minimum and maximum number of vCPUs for the instance types.
         * <p>
         * Amazon ECS selects instance types that have vCPU counts within this range.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ecs.CfnCapacityProvider.VCpuCountRangeRequestProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html#cfn-ecs-capacityprovider-instancerequirementsrequest-vcpucount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html#cfn-ecs-capacityprovider-instancerequirementsrequest-vcpucount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getVCpuCount();

        /**
         * The minimum and maximum number of accelerators for the instance types.
         * <p>
         * This is used when you need instances with specific numbers of GPUs or other accelerators.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ecs.CfnCapacityProvider.AcceleratorCountRequestProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html#cfn-ecs-capacityprovider-instancerequirementsrequest-acceleratorcount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html#cfn-ecs-capacityprovider-instancerequirementsrequest-acceleratorcount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAcceleratorCount() {
            return null;
        }

        /**
         * The accelerator manufacturers to include.
         * <p>
         * You can specify <code>nvidia</code> , <code>amd</code> , <code>amazon-web-services</code> , or <code>xilinx</code> depending on your accelerator requirements.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html#cfn-ecs-capacityprovider-instancerequirementsrequest-acceleratormanufacturers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html#cfn-ecs-capacityprovider-instancerequirementsrequest-acceleratormanufacturers</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAcceleratorManufacturers() {
            return null;
        }

        /**
         * The specific accelerator names to include.
         * <p>
         * For example, you can specify <code>a100</code> , <code>v100</code> , <code>k80</code> , or other specific accelerator models.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html#cfn-ecs-capacityprovider-instancerequirementsrequest-acceleratornames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html#cfn-ecs-capacityprovider-instancerequirementsrequest-acceleratornames</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAcceleratorNames() {
            return null;
        }

        /**
         * The minimum and maximum total accelerator memory in mebibytes (MiB).
         * <p>
         * This is important for GPU workloads that require specific amounts of video memory.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ecs.CfnCapacityProvider.AcceleratorTotalMemoryMiBRequestProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html#cfn-ecs-capacityprovider-instancerequirementsrequest-acceleratortotalmemorymib">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html#cfn-ecs-capacityprovider-instancerequirementsrequest-acceleratortotalmemorymib</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAcceleratorTotalMemoryMiB() {
            return null;
        }

        /**
         * The accelerator types to include.
         * <p>
         * You can specify <code>gpu</code> for graphics processing units, <code>fpga</code> for field programmable gate arrays, or <code>inference</code> for machine learning inference accelerators.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html#cfn-ecs-capacityprovider-instancerequirementsrequest-acceleratortypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html#cfn-ecs-capacityprovider-instancerequirementsrequest-acceleratortypes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAcceleratorTypes() {
            return null;
        }

        /**
         * The instance types to include in the selection.
         * <p>
         * When specified, Amazon ECS only considers these instance types, subject to the other requirements specified.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html#cfn-ecs-capacityprovider-instancerequirementsrequest-allowedinstancetypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html#cfn-ecs-capacityprovider-instancerequirementsrequest-allowedinstancetypes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedInstanceTypes() {
            return null;
        }

        /**
         * Indicates whether to include bare metal instance types.
         * <p>
         * Set to <code>included</code> to allow bare metal instances, <code>excluded</code> to exclude them, or <code>required</code> to use only bare metal instances.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html#cfn-ecs-capacityprovider-instancerequirementsrequest-baremetal">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html#cfn-ecs-capacityprovider-instancerequirementsrequest-baremetal</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBareMetal() {
            return null;
        }

        /**
         * The minimum and maximum baseline Amazon EBS bandwidth in megabits per second (Mbps).
         * <p>
         * This is important for workloads with high storage I/O requirements.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ecs.CfnCapacityProvider.BaselineEbsBandwidthMbpsRequestProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html#cfn-ecs-capacityprovider-instancerequirementsrequest-baselineebsbandwidthmbps">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html#cfn-ecs-capacityprovider-instancerequirementsrequest-baselineebsbandwidthmbps</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBaselineEbsBandwidthMbps() {
            return null;
        }

        /**
         * Indicates whether to include burstable performance instance types (T2, T3, T3a, T4g).
         * <p>
         * Set to <code>included</code> to allow burstable instances, <code>excluded</code> to exclude them, or <code>required</code> to use only burstable instances.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html#cfn-ecs-capacityprovider-instancerequirementsrequest-burstableperformance">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html#cfn-ecs-capacityprovider-instancerequirementsrequest-burstableperformance</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBurstablePerformance() {
            return null;
        }

        /**
         * The CPU manufacturers to include or exclude.
         * <p>
         * You can specify <code>intel</code> , <code>amd</code> , or <code>amazon-web-services</code> to control which CPU types are used for your workloads.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html#cfn-ecs-capacityprovider-instancerequirementsrequest-cpumanufacturers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html#cfn-ecs-capacityprovider-instancerequirementsrequest-cpumanufacturers</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCpuManufacturers() {
            return null;
        }

        /**
         * The instance types to exclude from selection.
         * <p>
         * Use this to prevent Amazon ECS from selecting specific instance types that may not be suitable for your workloads.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html#cfn-ecs-capacityprovider-instancerequirementsrequest-excludedinstancetypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html#cfn-ecs-capacityprovider-instancerequirementsrequest-excludedinstancetypes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExcludedInstanceTypes() {
            return null;
        }

        /**
         * The instance generations to include.
         * <p>
         * You can specify <code>current</code> to use the latest generation instances, or <code>previous</code> to include previous generation instances for cost optimization.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html#cfn-ecs-capacityprovider-instancerequirementsrequest-instancegenerations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html#cfn-ecs-capacityprovider-instancerequirementsrequest-instancegenerations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInstanceGenerations() {
            return null;
        }

        /**
         * Indicates whether to include instance types with local storage.
         * <p>
         * Set to <code>included</code> to allow local storage, <code>excluded</code> to exclude it, or <code>required</code> to use only instances with local storage.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html#cfn-ecs-capacityprovider-instancerequirementsrequest-localstorage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html#cfn-ecs-capacityprovider-instancerequirementsrequest-localstorage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLocalStorage() {
            return null;
        }

        /**
         * The local storage types to include.
         * <p>
         * You can specify <code>hdd</code> for hard disk drives, <code>ssd</code> for solid state drives, or both.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html#cfn-ecs-capacityprovider-instancerequirementsrequest-localstoragetypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html#cfn-ecs-capacityprovider-instancerequirementsrequest-localstoragetypes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getLocalStorageTypes() {
            return null;
        }

        /**
         * The maximum price for Spot instances as a percentage of the optimal On-Demand price.
         * <p>
         * This provides more precise cost control for Spot instance selection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html#cfn-ecs-capacityprovider-instancerequirementsrequest-maxspotpriceaspercentageofoptimalondemandprice">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html#cfn-ecs-capacityprovider-instancerequirementsrequest-maxspotpriceaspercentageofoptimalondemandprice</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxSpotPriceAsPercentageOfOptimalOnDemandPrice() {
            return null;
        }

        /**
         * The minimum and maximum amount of memory per vCPU in gibibytes (GiB).
         * <p>
         * This helps ensure that instance types have the appropriate memory-to-CPU ratio for your workloads.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ecs.CfnCapacityProvider.MemoryGiBPerVCpuRequestProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html#cfn-ecs-capacityprovider-instancerequirementsrequest-memorygibpervcpu">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html#cfn-ecs-capacityprovider-instancerequirementsrequest-memorygibpervcpu</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMemoryGiBPerVCpu() {
            return null;
        }

        /**
         * The minimum and maximum network bandwidth in gigabits per second (Gbps).
         * <p>
         * This is crucial for network-intensive workloads that require high throughput.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ecs.CfnCapacityProvider.NetworkBandwidthGbpsRequestProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html#cfn-ecs-capacityprovider-instancerequirementsrequest-networkbandwidthgbps">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html#cfn-ecs-capacityprovider-instancerequirementsrequest-networkbandwidthgbps</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkBandwidthGbps() {
            return null;
        }

        /**
         * The minimum and maximum number of network interfaces for the instance types.
         * <p>
         * This is useful for workloads that require multiple network interfaces.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ecs.CfnCapacityProvider.NetworkInterfaceCountRequestProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html#cfn-ecs-capacityprovider-instancerequirementsrequest-networkinterfacecount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html#cfn-ecs-capacityprovider-instancerequirementsrequest-networkinterfacecount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkInterfaceCount() {
            return null;
        }

        /**
         * The price protection threshold for On-Demand Instances, as a percentage higher than an identified On-Demand price.
         * <p>
         * The identified On-Demand price is the price of the lowest priced current generation C, M, or R instance type with your specified attributes. If no current generation C, M, or R instance type matches your attributes, then the identified price is from either the lowest priced current generation instance types or, failing that, the lowest priced previous generation instance types that match your attributes. When Amazon ECS selects instance types with your attributes, we will exclude instance types whose price exceeds your specified threshold.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html#cfn-ecs-capacityprovider-instancerequirementsrequest-ondemandmaxpricepercentageoverlowestprice">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html#cfn-ecs-capacityprovider-instancerequirementsrequest-ondemandmaxpricepercentageoverlowestprice</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getOnDemandMaxPricePercentageOverLowestPrice() {
            return null;
        }

        /**
         * Indicates whether the instance types must support hibernation.
         * <p>
         * When set to <code>true</code> , only instance types that support hibernation are selected.
         * <p>
         * Returns union: either {@link java.lang.Boolean} or {@link software.amazon.awscdk.IResolvable}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html#cfn-ecs-capacityprovider-instancerequirementsrequest-requirehibernatesupport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html#cfn-ecs-capacityprovider-instancerequirementsrequest-requirehibernatesupport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequireHibernateSupport() {
            return null;
        }

        /**
         * The maximum price for Spot instances as a percentage over the lowest priced On-Demand instance.
         * <p>
         * This helps control Spot instance costs while maintaining access to capacity.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html#cfn-ecs-capacityprovider-instancerequirementsrequest-spotmaxpricepercentageoverlowestprice">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html#cfn-ecs-capacityprovider-instancerequirementsrequest-spotmaxpricepercentageoverlowestprice</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSpotMaxPricePercentageOverLowestPrice() {
            return null;
        }

        /**
         * The minimum and maximum total local storage in gigabytes (GB) for instance types with local storage.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ecs.CfnCapacityProvider.TotalLocalStorageGBRequestProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html#cfn-ecs-capacityprovider-instancerequirementsrequest-totallocalstoragegb">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-instancerequirementsrequest.html#cfn-ecs-capacityprovider-instancerequirementsrequest-totallocalstoragegb</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTotalLocalStorageGb() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InstanceRequirementsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InstanceRequirementsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InstanceRequirementsRequestProperty> {
            java.lang.Object memoryMiB;
            java.lang.Object vCpuCount;
            java.lang.Object acceleratorCount;
            java.util.List<java.lang.String> acceleratorManufacturers;
            java.util.List<java.lang.String> acceleratorNames;
            java.lang.Object acceleratorTotalMemoryMiB;
            java.util.List<java.lang.String> acceleratorTypes;
            java.util.List<java.lang.String> allowedInstanceTypes;
            java.lang.String bareMetal;
            java.lang.Object baselineEbsBandwidthMbps;
            java.lang.String burstablePerformance;
            java.util.List<java.lang.String> cpuManufacturers;
            java.util.List<java.lang.String> excludedInstanceTypes;
            java.util.List<java.lang.String> instanceGenerations;
            java.lang.String localStorage;
            java.util.List<java.lang.String> localStorageTypes;
            java.lang.Number maxSpotPriceAsPercentageOfOptimalOnDemandPrice;
            java.lang.Object memoryGiBPerVCpu;
            java.lang.Object networkBandwidthGbps;
            java.lang.Object networkInterfaceCount;
            java.lang.Number onDemandMaxPricePercentageOverLowestPrice;
            java.lang.Object requireHibernateSupport;
            java.lang.Number spotMaxPricePercentageOverLowestPrice;
            java.lang.Object totalLocalStorageGb;

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getMemoryMiB}
             * @param memoryMiB The minimum and maximum amount of memory in mebibytes (MiB) for the instance types. This parameter is required.
             *                  Amazon ECS selects instance types that have memory within this range.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memoryMiB(software.amazon.awscdk.IResolvable memoryMiB) {
                this.memoryMiB = memoryMiB;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getMemoryMiB}
             * @param memoryMiB The minimum and maximum amount of memory in mebibytes (MiB) for the instance types. This parameter is required.
             *                  Amazon ECS selects instance types that have memory within this range.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memoryMiB(software.amazon.awscdk.services.ecs.CfnCapacityProvider.MemoryMiBRequestProperty memoryMiB) {
                this.memoryMiB = memoryMiB;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getVCpuCount}
             * @param vCpuCount The minimum and maximum number of vCPUs for the instance types. This parameter is required.
             *                  Amazon ECS selects instance types that have vCPU counts within this range.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vCpuCount(software.amazon.awscdk.IResolvable vCpuCount) {
                this.vCpuCount = vCpuCount;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getVCpuCount}
             * @param vCpuCount The minimum and maximum number of vCPUs for the instance types. This parameter is required.
             *                  Amazon ECS selects instance types that have vCPU counts within this range.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vCpuCount(software.amazon.awscdk.services.ecs.CfnCapacityProvider.VCpuCountRangeRequestProperty vCpuCount) {
                this.vCpuCount = vCpuCount;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getAcceleratorCount}
             * @param acceleratorCount The minimum and maximum number of accelerators for the instance types.
             *                         This is used when you need instances with specific numbers of GPUs or other accelerators.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorCount(software.amazon.awscdk.IResolvable acceleratorCount) {
                this.acceleratorCount = acceleratorCount;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getAcceleratorCount}
             * @param acceleratorCount The minimum and maximum number of accelerators for the instance types.
             *                         This is used when you need instances with specific numbers of GPUs or other accelerators.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorCount(software.amazon.awscdk.services.ecs.CfnCapacityProvider.AcceleratorCountRequestProperty acceleratorCount) {
                this.acceleratorCount = acceleratorCount;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getAcceleratorManufacturers}
             * @param acceleratorManufacturers The accelerator manufacturers to include.
             *                                 You can specify <code>nvidia</code> , <code>amd</code> , <code>amazon-web-services</code> , or <code>xilinx</code> depending on your accelerator requirements.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorManufacturers(java.util.List<java.lang.String> acceleratorManufacturers) {
                this.acceleratorManufacturers = acceleratorManufacturers;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getAcceleratorNames}
             * @param acceleratorNames The specific accelerator names to include.
             *                         For example, you can specify <code>a100</code> , <code>v100</code> , <code>k80</code> , or other specific accelerator models.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorNames(java.util.List<java.lang.String> acceleratorNames) {
                this.acceleratorNames = acceleratorNames;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getAcceleratorTotalMemoryMiB}
             * @param acceleratorTotalMemoryMiB The minimum and maximum total accelerator memory in mebibytes (MiB).
             *                                  This is important for GPU workloads that require specific amounts of video memory.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorTotalMemoryMiB(software.amazon.awscdk.IResolvable acceleratorTotalMemoryMiB) {
                this.acceleratorTotalMemoryMiB = acceleratorTotalMemoryMiB;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getAcceleratorTotalMemoryMiB}
             * @param acceleratorTotalMemoryMiB The minimum and maximum total accelerator memory in mebibytes (MiB).
             *                                  This is important for GPU workloads that require specific amounts of video memory.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorTotalMemoryMiB(software.amazon.awscdk.services.ecs.CfnCapacityProvider.AcceleratorTotalMemoryMiBRequestProperty acceleratorTotalMemoryMiB) {
                this.acceleratorTotalMemoryMiB = acceleratorTotalMemoryMiB;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getAcceleratorTypes}
             * @param acceleratorTypes The accelerator types to include.
             *                         You can specify <code>gpu</code> for graphics processing units, <code>fpga</code> for field programmable gate arrays, or <code>inference</code> for machine learning inference accelerators.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acceleratorTypes(java.util.List<java.lang.String> acceleratorTypes) {
                this.acceleratorTypes = acceleratorTypes;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getAllowedInstanceTypes}
             * @param allowedInstanceTypes The instance types to include in the selection.
             *                             When specified, Amazon ECS only considers these instance types, subject to the other requirements specified.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedInstanceTypes(java.util.List<java.lang.String> allowedInstanceTypes) {
                this.allowedInstanceTypes = allowedInstanceTypes;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getBareMetal}
             * @param bareMetal Indicates whether to include bare metal instance types.
             *                  Set to <code>included</code> to allow bare metal instances, <code>excluded</code> to exclude them, or <code>required</code> to use only bare metal instances.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bareMetal(java.lang.String bareMetal) {
                this.bareMetal = bareMetal;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getBaselineEbsBandwidthMbps}
             * @param baselineEbsBandwidthMbps The minimum and maximum baseline Amazon EBS bandwidth in megabits per second (Mbps).
             *                                 This is important for workloads with high storage I/O requirements.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder baselineEbsBandwidthMbps(software.amazon.awscdk.IResolvable baselineEbsBandwidthMbps) {
                this.baselineEbsBandwidthMbps = baselineEbsBandwidthMbps;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getBaselineEbsBandwidthMbps}
             * @param baselineEbsBandwidthMbps The minimum and maximum baseline Amazon EBS bandwidth in megabits per second (Mbps).
             *                                 This is important for workloads with high storage I/O requirements.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder baselineEbsBandwidthMbps(software.amazon.awscdk.services.ecs.CfnCapacityProvider.BaselineEbsBandwidthMbpsRequestProperty baselineEbsBandwidthMbps) {
                this.baselineEbsBandwidthMbps = baselineEbsBandwidthMbps;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getBurstablePerformance}
             * @param burstablePerformance Indicates whether to include burstable performance instance types (T2, T3, T3a, T4g).
             *                             Set to <code>included</code> to allow burstable instances, <code>excluded</code> to exclude them, or <code>required</code> to use only burstable instances.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder burstablePerformance(java.lang.String burstablePerformance) {
                this.burstablePerformance = burstablePerformance;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getCpuManufacturers}
             * @param cpuManufacturers The CPU manufacturers to include or exclude.
             *                         You can specify <code>intel</code> , <code>amd</code> , or <code>amazon-web-services</code> to control which CPU types are used for your workloads.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cpuManufacturers(java.util.List<java.lang.String> cpuManufacturers) {
                this.cpuManufacturers = cpuManufacturers;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getExcludedInstanceTypes}
             * @param excludedInstanceTypes The instance types to exclude from selection.
             *                              Use this to prevent Amazon ECS from selecting specific instance types that may not be suitable for your workloads.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludedInstanceTypes(java.util.List<java.lang.String> excludedInstanceTypes) {
                this.excludedInstanceTypes = excludedInstanceTypes;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getInstanceGenerations}
             * @param instanceGenerations The instance generations to include.
             *                            You can specify <code>current</code> to use the latest generation instances, or <code>previous</code> to include previous generation instances for cost optimization.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceGenerations(java.util.List<java.lang.String> instanceGenerations) {
                this.instanceGenerations = instanceGenerations;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getLocalStorage}
             * @param localStorage Indicates whether to include instance types with local storage.
             *                     Set to <code>included</code> to allow local storage, <code>excluded</code> to exclude it, or <code>required</code> to use only instances with local storage.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder localStorage(java.lang.String localStorage) {
                this.localStorage = localStorage;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getLocalStorageTypes}
             * @param localStorageTypes The local storage types to include.
             *                          You can specify <code>hdd</code> for hard disk drives, <code>ssd</code> for solid state drives, or both.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder localStorageTypes(java.util.List<java.lang.String> localStorageTypes) {
                this.localStorageTypes = localStorageTypes;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getMaxSpotPriceAsPercentageOfOptimalOnDemandPrice}
             * @param maxSpotPriceAsPercentageOfOptimalOnDemandPrice The maximum price for Spot instances as a percentage of the optimal On-Demand price.
             *                                                       This provides more precise cost control for Spot instance selection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxSpotPriceAsPercentageOfOptimalOnDemandPrice(java.lang.Number maxSpotPriceAsPercentageOfOptimalOnDemandPrice) {
                this.maxSpotPriceAsPercentageOfOptimalOnDemandPrice = maxSpotPriceAsPercentageOfOptimalOnDemandPrice;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getMemoryGiBPerVCpu}
             * @param memoryGiBPerVCpu The minimum and maximum amount of memory per vCPU in gibibytes (GiB).
             *                         This helps ensure that instance types have the appropriate memory-to-CPU ratio for your workloads.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memoryGiBPerVCpu(software.amazon.awscdk.IResolvable memoryGiBPerVCpu) {
                this.memoryGiBPerVCpu = memoryGiBPerVCpu;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getMemoryGiBPerVCpu}
             * @param memoryGiBPerVCpu The minimum and maximum amount of memory per vCPU in gibibytes (GiB).
             *                         This helps ensure that instance types have the appropriate memory-to-CPU ratio for your workloads.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memoryGiBPerVCpu(software.amazon.awscdk.services.ecs.CfnCapacityProvider.MemoryGiBPerVCpuRequestProperty memoryGiBPerVCpu) {
                this.memoryGiBPerVCpu = memoryGiBPerVCpu;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getNetworkBandwidthGbps}
             * @param networkBandwidthGbps The minimum and maximum network bandwidth in gigabits per second (Gbps).
             *                             This is crucial for network-intensive workloads that require high throughput.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkBandwidthGbps(software.amazon.awscdk.IResolvable networkBandwidthGbps) {
                this.networkBandwidthGbps = networkBandwidthGbps;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getNetworkBandwidthGbps}
             * @param networkBandwidthGbps The minimum and maximum network bandwidth in gigabits per second (Gbps).
             *                             This is crucial for network-intensive workloads that require high throughput.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkBandwidthGbps(software.amazon.awscdk.services.ecs.CfnCapacityProvider.NetworkBandwidthGbpsRequestProperty networkBandwidthGbps) {
                this.networkBandwidthGbps = networkBandwidthGbps;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getNetworkInterfaceCount}
             * @param networkInterfaceCount The minimum and maximum number of network interfaces for the instance types.
             *                              This is useful for workloads that require multiple network interfaces.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkInterfaceCount(software.amazon.awscdk.IResolvable networkInterfaceCount) {
                this.networkInterfaceCount = networkInterfaceCount;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getNetworkInterfaceCount}
             * @param networkInterfaceCount The minimum and maximum number of network interfaces for the instance types.
             *                              This is useful for workloads that require multiple network interfaces.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkInterfaceCount(software.amazon.awscdk.services.ecs.CfnCapacityProvider.NetworkInterfaceCountRequestProperty networkInterfaceCount) {
                this.networkInterfaceCount = networkInterfaceCount;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getOnDemandMaxPricePercentageOverLowestPrice}
             * @param onDemandMaxPricePercentageOverLowestPrice The price protection threshold for On-Demand Instances, as a percentage higher than an identified On-Demand price.
             *                                                  The identified On-Demand price is the price of the lowest priced current generation C, M, or R instance type with your specified attributes. If no current generation C, M, or R instance type matches your attributes, then the identified price is from either the lowest priced current generation instance types or, failing that, the lowest priced previous generation instance types that match your attributes. When Amazon ECS selects instance types with your attributes, we will exclude instance types whose price exceeds your specified threshold.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onDemandMaxPricePercentageOverLowestPrice(java.lang.Number onDemandMaxPricePercentageOverLowestPrice) {
                this.onDemandMaxPricePercentageOverLowestPrice = onDemandMaxPricePercentageOverLowestPrice;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getRequireHibernateSupport}
             * @param requireHibernateSupport Indicates whether the instance types must support hibernation.
             *                                When set to <code>true</code> , only instance types that support hibernation are selected.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireHibernateSupport(java.lang.Boolean requireHibernateSupport) {
                this.requireHibernateSupport = requireHibernateSupport;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getRequireHibernateSupport}
             * @param requireHibernateSupport Indicates whether the instance types must support hibernation.
             *                                When set to <code>true</code> , only instance types that support hibernation are selected.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requireHibernateSupport(software.amazon.awscdk.IResolvable requireHibernateSupport) {
                this.requireHibernateSupport = requireHibernateSupport;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getSpotMaxPricePercentageOverLowestPrice}
             * @param spotMaxPricePercentageOverLowestPrice The maximum price for Spot instances as a percentage over the lowest priced On-Demand instance.
             *                                              This helps control Spot instance costs while maintaining access to capacity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spotMaxPricePercentageOverLowestPrice(java.lang.Number spotMaxPricePercentageOverLowestPrice) {
                this.spotMaxPricePercentageOverLowestPrice = spotMaxPricePercentageOverLowestPrice;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getTotalLocalStorageGb}
             * @param totalLocalStorageGb The minimum and maximum total local storage in gigabytes (GB) for instance types with local storage.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder totalLocalStorageGb(software.amazon.awscdk.IResolvable totalLocalStorageGb) {
                this.totalLocalStorageGb = totalLocalStorageGb;
                return this;
            }

            /**
             * Sets the value of {@link InstanceRequirementsRequestProperty#getTotalLocalStorageGb}
             * @param totalLocalStorageGb The minimum and maximum total local storage in gigabytes (GB) for instance types with local storage.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder totalLocalStorageGb(software.amazon.awscdk.services.ecs.CfnCapacityProvider.TotalLocalStorageGBRequestProperty totalLocalStorageGb) {
                this.totalLocalStorageGb = totalLocalStorageGb;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceRequirementsRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InstanceRequirementsRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InstanceRequirementsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceRequirementsRequestProperty {
            private final java.lang.Object memoryMiB;
            private final java.lang.Object vCpuCount;
            private final java.lang.Object acceleratorCount;
            private final java.util.List<java.lang.String> acceleratorManufacturers;
            private final java.util.List<java.lang.String> acceleratorNames;
            private final java.lang.Object acceleratorTotalMemoryMiB;
            private final java.util.List<java.lang.String> acceleratorTypes;
            private final java.util.List<java.lang.String> allowedInstanceTypes;
            private final java.lang.String bareMetal;
            private final java.lang.Object baselineEbsBandwidthMbps;
            private final java.lang.String burstablePerformance;
            private final java.util.List<java.lang.String> cpuManufacturers;
            private final java.util.List<java.lang.String> excludedInstanceTypes;
            private final java.util.List<java.lang.String> instanceGenerations;
            private final java.lang.String localStorage;
            private final java.util.List<java.lang.String> localStorageTypes;
            private final java.lang.Number maxSpotPriceAsPercentageOfOptimalOnDemandPrice;
            private final java.lang.Object memoryGiBPerVCpu;
            private final java.lang.Object networkBandwidthGbps;
            private final java.lang.Object networkInterfaceCount;
            private final java.lang.Number onDemandMaxPricePercentageOverLowestPrice;
            private final java.lang.Object requireHibernateSupport;
            private final java.lang.Number spotMaxPricePercentageOverLowestPrice;
            private final java.lang.Object totalLocalStorageGb;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.memoryMiB = software.amazon.jsii.Kernel.get(this, "memoryMiB", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.vCpuCount = software.amazon.jsii.Kernel.get(this, "vCpuCount", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.acceleratorCount = software.amazon.jsii.Kernel.get(this, "acceleratorCount", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.acceleratorManufacturers = software.amazon.jsii.Kernel.get(this, "acceleratorManufacturers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.acceleratorNames = software.amazon.jsii.Kernel.get(this, "acceleratorNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.acceleratorTotalMemoryMiB = software.amazon.jsii.Kernel.get(this, "acceleratorTotalMemoryMiB", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.acceleratorTypes = software.amazon.jsii.Kernel.get(this, "acceleratorTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.allowedInstanceTypes = software.amazon.jsii.Kernel.get(this, "allowedInstanceTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.bareMetal = software.amazon.jsii.Kernel.get(this, "bareMetal", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.baselineEbsBandwidthMbps = software.amazon.jsii.Kernel.get(this, "baselineEbsBandwidthMbps", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.burstablePerformance = software.amazon.jsii.Kernel.get(this, "burstablePerformance", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.cpuManufacturers = software.amazon.jsii.Kernel.get(this, "cpuManufacturers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.excludedInstanceTypes = software.amazon.jsii.Kernel.get(this, "excludedInstanceTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.instanceGenerations = software.amazon.jsii.Kernel.get(this, "instanceGenerations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.localStorage = software.amazon.jsii.Kernel.get(this, "localStorage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.localStorageTypes = software.amazon.jsii.Kernel.get(this, "localStorageTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.maxSpotPriceAsPercentageOfOptimalOnDemandPrice = software.amazon.jsii.Kernel.get(this, "maxSpotPriceAsPercentageOfOptimalOnDemandPrice", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.memoryGiBPerVCpu = software.amazon.jsii.Kernel.get(this, "memoryGiBPerVCpu", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.networkBandwidthGbps = software.amazon.jsii.Kernel.get(this, "networkBandwidthGbps", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.networkInterfaceCount = software.amazon.jsii.Kernel.get(this, "networkInterfaceCount", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.onDemandMaxPricePercentageOverLowestPrice = software.amazon.jsii.Kernel.get(this, "onDemandMaxPricePercentageOverLowestPrice", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.requireHibernateSupport = software.amazon.jsii.Kernel.get(this, "requireHibernateSupport", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.spotMaxPricePercentageOverLowestPrice = software.amazon.jsii.Kernel.get(this, "spotMaxPricePercentageOverLowestPrice", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.totalLocalStorageGb = software.amazon.jsii.Kernel.get(this, "totalLocalStorageGb", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.memoryMiB = java.util.Objects.requireNonNull(builder.memoryMiB, "memoryMiB is required");
                this.vCpuCount = java.util.Objects.requireNonNull(builder.vCpuCount, "vCpuCount is required");
                this.acceleratorCount = builder.acceleratorCount;
                this.acceleratorManufacturers = builder.acceleratorManufacturers;
                this.acceleratorNames = builder.acceleratorNames;
                this.acceleratorTotalMemoryMiB = builder.acceleratorTotalMemoryMiB;
                this.acceleratorTypes = builder.acceleratorTypes;
                this.allowedInstanceTypes = builder.allowedInstanceTypes;
                this.bareMetal = builder.bareMetal;
                this.baselineEbsBandwidthMbps = builder.baselineEbsBandwidthMbps;
                this.burstablePerformance = builder.burstablePerformance;
                this.cpuManufacturers = builder.cpuManufacturers;
                this.excludedInstanceTypes = builder.excludedInstanceTypes;
                this.instanceGenerations = builder.instanceGenerations;
                this.localStorage = builder.localStorage;
                this.localStorageTypes = builder.localStorageTypes;
                this.maxSpotPriceAsPercentageOfOptimalOnDemandPrice = builder.maxSpotPriceAsPercentageOfOptimalOnDemandPrice;
                this.memoryGiBPerVCpu = builder.memoryGiBPerVCpu;
                this.networkBandwidthGbps = builder.networkBandwidthGbps;
                this.networkInterfaceCount = builder.networkInterfaceCount;
                this.onDemandMaxPricePercentageOverLowestPrice = builder.onDemandMaxPricePercentageOverLowestPrice;
                this.requireHibernateSupport = builder.requireHibernateSupport;
                this.spotMaxPricePercentageOverLowestPrice = builder.spotMaxPricePercentageOverLowestPrice;
                this.totalLocalStorageGb = builder.totalLocalStorageGb;
            }

            @Override
            public final java.lang.Object getMemoryMiB() {
                return this.memoryMiB;
            }

            @Override
            public final java.lang.Object getVCpuCount() {
                return this.vCpuCount;
            }

            @Override
            public final java.lang.Object getAcceleratorCount() {
                return this.acceleratorCount;
            }

            @Override
            public final java.util.List<java.lang.String> getAcceleratorManufacturers() {
                return this.acceleratorManufacturers;
            }

            @Override
            public final java.util.List<java.lang.String> getAcceleratorNames() {
                return this.acceleratorNames;
            }

            @Override
            public final java.lang.Object getAcceleratorTotalMemoryMiB() {
                return this.acceleratorTotalMemoryMiB;
            }

            @Override
            public final java.util.List<java.lang.String> getAcceleratorTypes() {
                return this.acceleratorTypes;
            }

            @Override
            public final java.util.List<java.lang.String> getAllowedInstanceTypes() {
                return this.allowedInstanceTypes;
            }

            @Override
            public final java.lang.String getBareMetal() {
                return this.bareMetal;
            }

            @Override
            public final java.lang.Object getBaselineEbsBandwidthMbps() {
                return this.baselineEbsBandwidthMbps;
            }

            @Override
            public final java.lang.String getBurstablePerformance() {
                return this.burstablePerformance;
            }

            @Override
            public final java.util.List<java.lang.String> getCpuManufacturers() {
                return this.cpuManufacturers;
            }

            @Override
            public final java.util.List<java.lang.String> getExcludedInstanceTypes() {
                return this.excludedInstanceTypes;
            }

            @Override
            public final java.util.List<java.lang.String> getInstanceGenerations() {
                return this.instanceGenerations;
            }

            @Override
            public final java.lang.String getLocalStorage() {
                return this.localStorage;
            }

            @Override
            public final java.util.List<java.lang.String> getLocalStorageTypes() {
                return this.localStorageTypes;
            }

            @Override
            public final java.lang.Number getMaxSpotPriceAsPercentageOfOptimalOnDemandPrice() {
                return this.maxSpotPriceAsPercentageOfOptimalOnDemandPrice;
            }

            @Override
            public final java.lang.Object getMemoryGiBPerVCpu() {
                return this.memoryGiBPerVCpu;
            }

            @Override
            public final java.lang.Object getNetworkBandwidthGbps() {
                return this.networkBandwidthGbps;
            }

            @Override
            public final java.lang.Object getNetworkInterfaceCount() {
                return this.networkInterfaceCount;
            }

            @Override
            public final java.lang.Number getOnDemandMaxPricePercentageOverLowestPrice() {
                return this.onDemandMaxPricePercentageOverLowestPrice;
            }

            @Override
            public final java.lang.Object getRequireHibernateSupport() {
                return this.requireHibernateSupport;
            }

            @Override
            public final java.lang.Number getSpotMaxPricePercentageOverLowestPrice() {
                return this.spotMaxPricePercentageOverLowestPrice;
            }

            @Override
            public final java.lang.Object getTotalLocalStorageGb() {
                return this.totalLocalStorageGb;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("memoryMiB", om.valueToTree(this.getMemoryMiB()));
                data.set("vCpuCount", om.valueToTree(this.getVCpuCount()));
                if (this.getAcceleratorCount() != null) {
                    data.set("acceleratorCount", om.valueToTree(this.getAcceleratorCount()));
                }
                if (this.getAcceleratorManufacturers() != null) {
                    data.set("acceleratorManufacturers", om.valueToTree(this.getAcceleratorManufacturers()));
                }
                if (this.getAcceleratorNames() != null) {
                    data.set("acceleratorNames", om.valueToTree(this.getAcceleratorNames()));
                }
                if (this.getAcceleratorTotalMemoryMiB() != null) {
                    data.set("acceleratorTotalMemoryMiB", om.valueToTree(this.getAcceleratorTotalMemoryMiB()));
                }
                if (this.getAcceleratorTypes() != null) {
                    data.set("acceleratorTypes", om.valueToTree(this.getAcceleratorTypes()));
                }
                if (this.getAllowedInstanceTypes() != null) {
                    data.set("allowedInstanceTypes", om.valueToTree(this.getAllowedInstanceTypes()));
                }
                if (this.getBareMetal() != null) {
                    data.set("bareMetal", om.valueToTree(this.getBareMetal()));
                }
                if (this.getBaselineEbsBandwidthMbps() != null) {
                    data.set("baselineEbsBandwidthMbps", om.valueToTree(this.getBaselineEbsBandwidthMbps()));
                }
                if (this.getBurstablePerformance() != null) {
                    data.set("burstablePerformance", om.valueToTree(this.getBurstablePerformance()));
                }
                if (this.getCpuManufacturers() != null) {
                    data.set("cpuManufacturers", om.valueToTree(this.getCpuManufacturers()));
                }
                if (this.getExcludedInstanceTypes() != null) {
                    data.set("excludedInstanceTypes", om.valueToTree(this.getExcludedInstanceTypes()));
                }
                if (this.getInstanceGenerations() != null) {
                    data.set("instanceGenerations", om.valueToTree(this.getInstanceGenerations()));
                }
                if (this.getLocalStorage() != null) {
                    data.set("localStorage", om.valueToTree(this.getLocalStorage()));
                }
                if (this.getLocalStorageTypes() != null) {
                    data.set("localStorageTypes", om.valueToTree(this.getLocalStorageTypes()));
                }
                if (this.getMaxSpotPriceAsPercentageOfOptimalOnDemandPrice() != null) {
                    data.set("maxSpotPriceAsPercentageOfOptimalOnDemandPrice", om.valueToTree(this.getMaxSpotPriceAsPercentageOfOptimalOnDemandPrice()));
                }
                if (this.getMemoryGiBPerVCpu() != null) {
                    data.set("memoryGiBPerVCpu", om.valueToTree(this.getMemoryGiBPerVCpu()));
                }
                if (this.getNetworkBandwidthGbps() != null) {
                    data.set("networkBandwidthGbps", om.valueToTree(this.getNetworkBandwidthGbps()));
                }
                if (this.getNetworkInterfaceCount() != null) {
                    data.set("networkInterfaceCount", om.valueToTree(this.getNetworkInterfaceCount()));
                }
                if (this.getOnDemandMaxPricePercentageOverLowestPrice() != null) {
                    data.set("onDemandMaxPricePercentageOverLowestPrice", om.valueToTree(this.getOnDemandMaxPricePercentageOverLowestPrice()));
                }
                if (this.getRequireHibernateSupport() != null) {
                    data.set("requireHibernateSupport", om.valueToTree(this.getRequireHibernateSupport()));
                }
                if (this.getSpotMaxPricePercentageOverLowestPrice() != null) {
                    data.set("spotMaxPricePercentageOverLowestPrice", om.valueToTree(this.getSpotMaxPricePercentageOverLowestPrice()));
                }
                if (this.getTotalLocalStorageGb() != null) {
                    data.set("totalLocalStorageGb", om.valueToTree(this.getTotalLocalStorageGb()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnCapacityProvider.InstanceRequirementsRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InstanceRequirementsRequestProperty.Jsii$Proxy that = (InstanceRequirementsRequestProperty.Jsii$Proxy) o;

                if (!memoryMiB.equals(that.memoryMiB)) return false;
                if (!vCpuCount.equals(that.vCpuCount)) return false;
                if (this.acceleratorCount != null ? !this.acceleratorCount.equals(that.acceleratorCount) : that.acceleratorCount != null) return false;
                if (this.acceleratorManufacturers != null ? !this.acceleratorManufacturers.equals(that.acceleratorManufacturers) : that.acceleratorManufacturers != null) return false;
                if (this.acceleratorNames != null ? !this.acceleratorNames.equals(that.acceleratorNames) : that.acceleratorNames != null) return false;
                if (this.acceleratorTotalMemoryMiB != null ? !this.acceleratorTotalMemoryMiB.equals(that.acceleratorTotalMemoryMiB) : that.acceleratorTotalMemoryMiB != null) return false;
                if (this.acceleratorTypes != null ? !this.acceleratorTypes.equals(that.acceleratorTypes) : that.acceleratorTypes != null) return false;
                if (this.allowedInstanceTypes != null ? !this.allowedInstanceTypes.equals(that.allowedInstanceTypes) : that.allowedInstanceTypes != null) return false;
                if (this.bareMetal != null ? !this.bareMetal.equals(that.bareMetal) : that.bareMetal != null) return false;
                if (this.baselineEbsBandwidthMbps != null ? !this.baselineEbsBandwidthMbps.equals(that.baselineEbsBandwidthMbps) : that.baselineEbsBandwidthMbps != null) return false;
                if (this.burstablePerformance != null ? !this.burstablePerformance.equals(that.burstablePerformance) : that.burstablePerformance != null) return false;
                if (this.cpuManufacturers != null ? !this.cpuManufacturers.equals(that.cpuManufacturers) : that.cpuManufacturers != null) return false;
                if (this.excludedInstanceTypes != null ? !this.excludedInstanceTypes.equals(that.excludedInstanceTypes) : that.excludedInstanceTypes != null) return false;
                if (this.instanceGenerations != null ? !this.instanceGenerations.equals(that.instanceGenerations) : that.instanceGenerations != null) return false;
                if (this.localStorage != null ? !this.localStorage.equals(that.localStorage) : that.localStorage != null) return false;
                if (this.localStorageTypes != null ? !this.localStorageTypes.equals(that.localStorageTypes) : that.localStorageTypes != null) return false;
                if (this.maxSpotPriceAsPercentageOfOptimalOnDemandPrice != null ? !this.maxSpotPriceAsPercentageOfOptimalOnDemandPrice.equals(that.maxSpotPriceAsPercentageOfOptimalOnDemandPrice) : that.maxSpotPriceAsPercentageOfOptimalOnDemandPrice != null) return false;
                if (this.memoryGiBPerVCpu != null ? !this.memoryGiBPerVCpu.equals(that.memoryGiBPerVCpu) : that.memoryGiBPerVCpu != null) return false;
                if (this.networkBandwidthGbps != null ? !this.networkBandwidthGbps.equals(that.networkBandwidthGbps) : that.networkBandwidthGbps != null) return false;
                if (this.networkInterfaceCount != null ? !this.networkInterfaceCount.equals(that.networkInterfaceCount) : that.networkInterfaceCount != null) return false;
                if (this.onDemandMaxPricePercentageOverLowestPrice != null ? !this.onDemandMaxPricePercentageOverLowestPrice.equals(that.onDemandMaxPricePercentageOverLowestPrice) : that.onDemandMaxPricePercentageOverLowestPrice != null) return false;
                if (this.requireHibernateSupport != null ? !this.requireHibernateSupport.equals(that.requireHibernateSupport) : that.requireHibernateSupport != null) return false;
                if (this.spotMaxPricePercentageOverLowestPrice != null ? !this.spotMaxPricePercentageOverLowestPrice.equals(that.spotMaxPricePercentageOverLowestPrice) : that.spotMaxPricePercentageOverLowestPrice != null) return false;
                return this.totalLocalStorageGb != null ? this.totalLocalStorageGb.equals(that.totalLocalStorageGb) : that.totalLocalStorageGb == null;
            }

            @Override
            public final int hashCode() {
                int result = this.memoryMiB.hashCode();
                result = 31 * result + (this.vCpuCount.hashCode());
                result = 31 * result + (this.acceleratorCount != null ? this.acceleratorCount.hashCode() : 0);
                result = 31 * result + (this.acceleratorManufacturers != null ? this.acceleratorManufacturers.hashCode() : 0);
                result = 31 * result + (this.acceleratorNames != null ? this.acceleratorNames.hashCode() : 0);
                result = 31 * result + (this.acceleratorTotalMemoryMiB != null ? this.acceleratorTotalMemoryMiB.hashCode() : 0);
                result = 31 * result + (this.acceleratorTypes != null ? this.acceleratorTypes.hashCode() : 0);
                result = 31 * result + (this.allowedInstanceTypes != null ? this.allowedInstanceTypes.hashCode() : 0);
                result = 31 * result + (this.bareMetal != null ? this.bareMetal.hashCode() : 0);
                result = 31 * result + (this.baselineEbsBandwidthMbps != null ? this.baselineEbsBandwidthMbps.hashCode() : 0);
                result = 31 * result + (this.burstablePerformance != null ? this.burstablePerformance.hashCode() : 0);
                result = 31 * result + (this.cpuManufacturers != null ? this.cpuManufacturers.hashCode() : 0);
                result = 31 * result + (this.excludedInstanceTypes != null ? this.excludedInstanceTypes.hashCode() : 0);
                result = 31 * result + (this.instanceGenerations != null ? this.instanceGenerations.hashCode() : 0);
                result = 31 * result + (this.localStorage != null ? this.localStorage.hashCode() : 0);
                result = 31 * result + (this.localStorageTypes != null ? this.localStorageTypes.hashCode() : 0);
                result = 31 * result + (this.maxSpotPriceAsPercentageOfOptimalOnDemandPrice != null ? this.maxSpotPriceAsPercentageOfOptimalOnDemandPrice.hashCode() : 0);
                result = 31 * result + (this.memoryGiBPerVCpu != null ? this.memoryGiBPerVCpu.hashCode() : 0);
                result = 31 * result + (this.networkBandwidthGbps != null ? this.networkBandwidthGbps.hashCode() : 0);
                result = 31 * result + (this.networkInterfaceCount != null ? this.networkInterfaceCount.hashCode() : 0);
                result = 31 * result + (this.onDemandMaxPricePercentageOverLowestPrice != null ? this.onDemandMaxPricePercentageOverLowestPrice.hashCode() : 0);
                result = 31 * result + (this.requireHibernateSupport != null ? this.requireHibernateSupport.hashCode() : 0);
                result = 31 * result + (this.spotMaxPricePercentageOverLowestPrice != null ? this.spotMaxPricePercentageOverLowestPrice.hashCode() : 0);
                result = 31 * result + (this.totalLocalStorageGb != null ? this.totalLocalStorageGb.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The network configuration for Amazon ECS Managed Instances.
     * <p>
     * This specifies the VPC subnets and security groups that instances use for network connectivity. Amazon ECS Managed Instances support multiple network modes including <code>awsvpc</code> (instances receive ENIs for task isolation), <code>host</code> (instances share network namespace with tasks), and <code>none</code> (no external network connectivity), ensuring backward compatibility for migrating workloads from Fargate or Amazon EC2.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * ManagedInstancesNetworkConfigurationProperty managedInstancesNetworkConfigurationProperty = ManagedInstancesNetworkConfigurationProperty.builder()
     *         .subnets(List.of("subnets"))
     *         // the properties below are optional
     *         .securityGroups(List.of("securityGroups"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-managedinstancesnetworkconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-managedinstancesnetworkconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnCapacityProvider.ManagedInstancesNetworkConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ManagedInstancesNetworkConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ManagedInstancesNetworkConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The list of subnet IDs where Amazon ECS can launch Amazon ECS Managed Instances.
         * <p>
         * Instances are distributed across the specified subnets for high availability. All subnets must be in the same VPC.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-managedinstancesnetworkconfiguration.html#cfn-ecs-capacityprovider-managedinstancesnetworkconfiguration-subnets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-managedinstancesnetworkconfiguration.html#cfn-ecs-capacityprovider-managedinstancesnetworkconfiguration-subnets</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubnets();

        /**
         * The list of security group IDs to apply to Amazon ECS Managed Instances.
         * <p>
         * These security groups control the network traffic allowed to and from the instances.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-managedinstancesnetworkconfiguration.html#cfn-ecs-capacityprovider-managedinstancesnetworkconfiguration-securitygroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-managedinstancesnetworkconfiguration.html#cfn-ecs-capacityprovider-managedinstancesnetworkconfiguration-securitygroups</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroups() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ManagedInstancesNetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ManagedInstancesNetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ManagedInstancesNetworkConfigurationProperty> {
            java.util.List<java.lang.String> subnets;
            java.util.List<java.lang.String> securityGroups;

            /**
             * Sets the value of {@link ManagedInstancesNetworkConfigurationProperty#getSubnets}
             * @param subnets The list of subnet IDs where Amazon ECS can launch Amazon ECS Managed Instances. This parameter is required.
             *                Instances are distributed across the specified subnets for high availability. All subnets must be in the same VPC.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnets(java.util.List<java.lang.String> subnets) {
                this.subnets = subnets;
                return this;
            }

            /**
             * Sets the value of {@link ManagedInstancesNetworkConfigurationProperty#getSecurityGroups}
             * @param securityGroups The list of security group IDs to apply to Amazon ECS Managed Instances.
             *                       These security groups control the network traffic allowed to and from the instances.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroups(java.util.List<java.lang.String> securityGroups) {
                this.securityGroups = securityGroups;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ManagedInstancesNetworkConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ManagedInstancesNetworkConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ManagedInstancesNetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ManagedInstancesNetworkConfigurationProperty {
            private final java.util.List<java.lang.String> subnets;
            private final java.util.List<java.lang.String> securityGroups;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.subnets = software.amazon.jsii.Kernel.get(this, "subnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.subnets = java.util.Objects.requireNonNull(builder.subnets, "subnets is required");
                this.securityGroups = builder.securityGroups;
            }

            @Override
            public final java.util.List<java.lang.String> getSubnets() {
                return this.subnets;
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroups() {
                return this.securityGroups;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("subnets", om.valueToTree(this.getSubnets()));
                if (this.getSecurityGroups() != null) {
                    data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnCapacityProvider.ManagedInstancesNetworkConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ManagedInstancesNetworkConfigurationProperty.Jsii$Proxy that = (ManagedInstancesNetworkConfigurationProperty.Jsii$Proxy) o;

                if (!subnets.equals(that.subnets)) return false;
                return this.securityGroups != null ? this.securityGroups.equals(that.securityGroups) : that.securityGroups == null;
            }

            @Override
            public final int hashCode() {
                int result = this.subnets.hashCode();
                result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration for a Amazon ECS Managed Instances provider.
     * <p>
     * Amazon ECS uses this configuration to automatically launch, manage, and terminate Amazon EC2 instances on your behalf. Managed instances provide access to the full range of Amazon EC2 instance types and features while offloading infrastructure management to AWS .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * ManagedInstancesProviderProperty managedInstancesProviderProperty = ManagedInstancesProviderProperty.builder()
     *         .infrastructureRoleArn("infrastructureRoleArn")
     *         .instanceLaunchTemplate(InstanceLaunchTemplateProperty.builder()
     *                 .ec2InstanceProfileArn("ec2InstanceProfileArn")
     *                 .networkConfiguration(ManagedInstancesNetworkConfigurationProperty.builder()
     *                         .subnets(List.of("subnets"))
     *                         // the properties below are optional
     *                         .securityGroups(List.of("securityGroups"))
     *                         .build())
     *                 // the properties below are optional
     *                 .instanceRequirements(InstanceRequirementsRequestProperty.builder()
     *                         .memoryMiB(MemoryMiBRequestProperty.builder()
     *                                 .min(123)
     *                                 // the properties below are optional
     *                                 .max(123)
     *                                 .build())
     *                         .vCpuCount(VCpuCountRangeRequestProperty.builder()
     *                                 .min(123)
     *                                 // the properties below are optional
     *                                 .max(123)
     *                                 .build())
     *                         // the properties below are optional
     *                         .acceleratorCount(AcceleratorCountRequestProperty.builder()
     *                                 .max(123)
     *                                 .min(123)
     *                                 .build())
     *                         .acceleratorManufacturers(List.of("acceleratorManufacturers"))
     *                         .acceleratorNames(List.of("acceleratorNames"))
     *                         .acceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBRequestProperty.builder()
     *                                 .max(123)
     *                                 .min(123)
     *                                 .build())
     *                         .acceleratorTypes(List.of("acceleratorTypes"))
     *                         .allowedInstanceTypes(List.of("allowedInstanceTypes"))
     *                         .bareMetal("bareMetal")
     *                         .baselineEbsBandwidthMbps(BaselineEbsBandwidthMbpsRequestProperty.builder()
     *                                 .max(123)
     *                                 .min(123)
     *                                 .build())
     *                         .burstablePerformance("burstablePerformance")
     *                         .cpuManufacturers(List.of("cpuManufacturers"))
     *                         .excludedInstanceTypes(List.of("excludedInstanceTypes"))
     *                         .instanceGenerations(List.of("instanceGenerations"))
     *                         .localStorage("localStorage")
     *                         .localStorageTypes(List.of("localStorageTypes"))
     *                         .maxSpotPriceAsPercentageOfOptimalOnDemandPrice(123)
     *                         .memoryGiBPerVCpu(MemoryGiBPerVCpuRequestProperty.builder()
     *                                 .max(123)
     *                                 .min(123)
     *                                 .build())
     *                         .networkBandwidthGbps(NetworkBandwidthGbpsRequestProperty.builder()
     *                                 .max(123)
     *                                 .min(123)
     *                                 .build())
     *                         .networkInterfaceCount(NetworkInterfaceCountRequestProperty.builder()
     *                                 .max(123)
     *                                 .min(123)
     *                                 .build())
     *                         .onDemandMaxPricePercentageOverLowestPrice(123)
     *                         .requireHibernateSupport(false)
     *                         .spotMaxPricePercentageOverLowestPrice(123)
     *                         .totalLocalStorageGb(TotalLocalStorageGBRequestProperty.builder()
     *                                 .max(123)
     *                                 .min(123)
     *                                 .build())
     *                         .build())
     *                 .monitoring("monitoring")
     *                 .storageConfiguration(ManagedInstancesStorageConfigurationProperty.builder()
     *                         .storageSizeGiB(123)
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .infrastructureOptimization(InfrastructureOptimizationProperty.builder()
     *                 .scaleInAfter(123)
     *                 .build())
     *         .propagateTags("propagateTags")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-managedinstancesprovider.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-managedinstancesprovider.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnCapacityProvider.ManagedInstancesProviderProperty")
    @software.amazon.jsii.Jsii.Proxy(ManagedInstancesProviderProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ManagedInstancesProviderProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the infrastructure role that Amazon ECS assumes to manage instances.
         * <p>
         * This role must include permissions for Amazon EC2 instance lifecycle management, networking, and any additional AWS services required for your workloads.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/infrastructure_IAM_role.html">Amazon ECS infrastructure IAM role</a> in the <em>Amazon ECS Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-managedinstancesprovider.html#cfn-ecs-capacityprovider-managedinstancesprovider-infrastructurerolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-managedinstancesprovider.html#cfn-ecs-capacityprovider-managedinstancesprovider-infrastructurerolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInfrastructureRoleArn();

        /**
         * The launch template that defines how Amazon ECS launches Amazon ECS Managed Instances.
         * <p>
         * This includes the instance profile for your tasks, network and storage configuration, and instance requirements that determine which Amazon EC2 instance types can be used.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html">Store instance launch parameters in Amazon EC2 launch templates</a> in the <em>Amazon EC2 User Guide</em> .
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ecs.CfnCapacityProvider.InstanceLaunchTemplateProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-managedinstancesprovider.html#cfn-ecs-capacityprovider-managedinstancesprovider-instancelaunchtemplate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-managedinstancesprovider.html#cfn-ecs-capacityprovider-managedinstancesprovider-instancelaunchtemplate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getInstanceLaunchTemplate();

        /**
         * Defines how Amazon ECS Managed Instances optimizes the infrastastructure in your capacity provider.
         * <p>
         * Configure it to turn on or off the infrastructure optimization in your capacity provider, and to control the idle or underutilized EC2 instances optimization delay.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ecs.CfnCapacityProvider.InfrastructureOptimizationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-managedinstancesprovider.html#cfn-ecs-capacityprovider-managedinstancesprovider-infrastructureoptimization">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-managedinstancesprovider.html#cfn-ecs-capacityprovider-managedinstancesprovider-infrastructureoptimization</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInfrastructureOptimization() {
            return null;
        }

        /**
         * Determines whether tags from the capacity provider are automatically applied to Amazon ECS Managed Instances.
         * <p>
         * This helps with cost allocation and resource management by ensuring consistent tagging across your infrastructure.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-managedinstancesprovider.html#cfn-ecs-capacityprovider-managedinstancesprovider-propagatetags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-managedinstancesprovider.html#cfn-ecs-capacityprovider-managedinstancesprovider-propagatetags</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPropagateTags() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ManagedInstancesProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ManagedInstancesProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ManagedInstancesProviderProperty> {
            java.lang.String infrastructureRoleArn;
            java.lang.Object instanceLaunchTemplate;
            java.lang.Object infrastructureOptimization;
            java.lang.String propagateTags;

            /**
             * Sets the value of {@link ManagedInstancesProviderProperty#getInfrastructureRoleArn}
             * @param infrastructureRoleArn The Amazon Resource Name (ARN) of the infrastructure role that Amazon ECS assumes to manage instances. This parameter is required.
             *                              This role must include permissions for Amazon EC2 instance lifecycle management, networking, and any additional AWS services required for your workloads.
             *                              <p>
             *                              For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/infrastructure_IAM_role.html">Amazon ECS infrastructure IAM role</a> in the <em>Amazon ECS Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder infrastructureRoleArn(java.lang.String infrastructureRoleArn) {
                this.infrastructureRoleArn = infrastructureRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link ManagedInstancesProviderProperty#getInstanceLaunchTemplate}
             * @param instanceLaunchTemplate The launch template that defines how Amazon ECS launches Amazon ECS Managed Instances. This parameter is required.
             *                               This includes the instance profile for your tasks, network and storage configuration, and instance requirements that determine which Amazon EC2 instance types can be used.
             *                               <p>
             *                               For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html">Store instance launch parameters in Amazon EC2 launch templates</a> in the <em>Amazon EC2 User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceLaunchTemplate(software.amazon.awscdk.IResolvable instanceLaunchTemplate) {
                this.instanceLaunchTemplate = instanceLaunchTemplate;
                return this;
            }

            /**
             * Sets the value of {@link ManagedInstancesProviderProperty#getInstanceLaunchTemplate}
             * @param instanceLaunchTemplate The launch template that defines how Amazon ECS launches Amazon ECS Managed Instances. This parameter is required.
             *                               This includes the instance profile for your tasks, network and storage configuration, and instance requirements that determine which Amazon EC2 instance types can be used.
             *                               <p>
             *                               For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html">Store instance launch parameters in Amazon EC2 launch templates</a> in the <em>Amazon EC2 User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceLaunchTemplate(software.amazon.awscdk.services.ecs.CfnCapacityProvider.InstanceLaunchTemplateProperty instanceLaunchTemplate) {
                this.instanceLaunchTemplate = instanceLaunchTemplate;
                return this;
            }

            /**
             * Sets the value of {@link ManagedInstancesProviderProperty#getInfrastructureOptimization}
             * @param infrastructureOptimization Defines how Amazon ECS Managed Instances optimizes the infrastastructure in your capacity provider.
             *                                   Configure it to turn on or off the infrastructure optimization in your capacity provider, and to control the idle or underutilized EC2 instances optimization delay.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder infrastructureOptimization(software.amazon.awscdk.IResolvable infrastructureOptimization) {
                this.infrastructureOptimization = infrastructureOptimization;
                return this;
            }

            /**
             * Sets the value of {@link ManagedInstancesProviderProperty#getInfrastructureOptimization}
             * @param infrastructureOptimization Defines how Amazon ECS Managed Instances optimizes the infrastastructure in your capacity provider.
             *                                   Configure it to turn on or off the infrastructure optimization in your capacity provider, and to control the idle or underutilized EC2 instances optimization delay.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder infrastructureOptimization(software.amazon.awscdk.services.ecs.CfnCapacityProvider.InfrastructureOptimizationProperty infrastructureOptimization) {
                this.infrastructureOptimization = infrastructureOptimization;
                return this;
            }

            /**
             * Sets the value of {@link ManagedInstancesProviderProperty#getPropagateTags}
             * @param propagateTags Determines whether tags from the capacity provider are automatically applied to Amazon ECS Managed Instances.
             *                      This helps with cost allocation and resource management by ensuring consistent tagging across your infrastructure.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder propagateTags(java.lang.String propagateTags) {
                this.propagateTags = propagateTags;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ManagedInstancesProviderProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ManagedInstancesProviderProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ManagedInstancesProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ManagedInstancesProviderProperty {
            private final java.lang.String infrastructureRoleArn;
            private final java.lang.Object instanceLaunchTemplate;
            private final java.lang.Object infrastructureOptimization;
            private final java.lang.String propagateTags;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.infrastructureRoleArn = software.amazon.jsii.Kernel.get(this, "infrastructureRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.instanceLaunchTemplate = software.amazon.jsii.Kernel.get(this, "instanceLaunchTemplate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.infrastructureOptimization = software.amazon.jsii.Kernel.get(this, "infrastructureOptimization", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.propagateTags = software.amazon.jsii.Kernel.get(this, "propagateTags", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.infrastructureRoleArn = java.util.Objects.requireNonNull(builder.infrastructureRoleArn, "infrastructureRoleArn is required");
                this.instanceLaunchTemplate = java.util.Objects.requireNonNull(builder.instanceLaunchTemplate, "instanceLaunchTemplate is required");
                this.infrastructureOptimization = builder.infrastructureOptimization;
                this.propagateTags = builder.propagateTags;
            }

            @Override
            public final java.lang.String getInfrastructureRoleArn() {
                return this.infrastructureRoleArn;
            }

            @Override
            public final java.lang.Object getInstanceLaunchTemplate() {
                return this.instanceLaunchTemplate;
            }

            @Override
            public final java.lang.Object getInfrastructureOptimization() {
                return this.infrastructureOptimization;
            }

            @Override
            public final java.lang.String getPropagateTags() {
                return this.propagateTags;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("infrastructureRoleArn", om.valueToTree(this.getInfrastructureRoleArn()));
                data.set("instanceLaunchTemplate", om.valueToTree(this.getInstanceLaunchTemplate()));
                if (this.getInfrastructureOptimization() != null) {
                    data.set("infrastructureOptimization", om.valueToTree(this.getInfrastructureOptimization()));
                }
                if (this.getPropagateTags() != null) {
                    data.set("propagateTags", om.valueToTree(this.getPropagateTags()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnCapacityProvider.ManagedInstancesProviderProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ManagedInstancesProviderProperty.Jsii$Proxy that = (ManagedInstancesProviderProperty.Jsii$Proxy) o;

                if (!infrastructureRoleArn.equals(that.infrastructureRoleArn)) return false;
                if (!instanceLaunchTemplate.equals(that.instanceLaunchTemplate)) return false;
                if (this.infrastructureOptimization != null ? !this.infrastructureOptimization.equals(that.infrastructureOptimization) : that.infrastructureOptimization != null) return false;
                return this.propagateTags != null ? this.propagateTags.equals(that.propagateTags) : that.propagateTags == null;
            }

            @Override
            public final int hashCode() {
                int result = this.infrastructureRoleArn.hashCode();
                result = 31 * result + (this.instanceLaunchTemplate.hashCode());
                result = 31 * result + (this.infrastructureOptimization != null ? this.infrastructureOptimization.hashCode() : 0);
                result = 31 * result + (this.propagateTags != null ? this.propagateTags.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The storage configuration for Amazon ECS Managed Instances.
     * <p>
     * This defines the root volume configuration for the instances.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * ManagedInstancesStorageConfigurationProperty managedInstancesStorageConfigurationProperty = ManagedInstancesStorageConfigurationProperty.builder()
     *         .storageSizeGiB(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-managedinstancesstorageconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-managedinstancesstorageconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnCapacityProvider.ManagedInstancesStorageConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ManagedInstancesStorageConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ManagedInstancesStorageConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The size of the tasks volume.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-managedinstancesstorageconfiguration.html#cfn-ecs-capacityprovider-managedinstancesstorageconfiguration-storagesizegib">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-managedinstancesstorageconfiguration.html#cfn-ecs-capacityprovider-managedinstancesstorageconfiguration-storagesizegib</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getStorageSizeGiB();

        /**
         * @return a {@link Builder} of {@link ManagedInstancesStorageConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ManagedInstancesStorageConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ManagedInstancesStorageConfigurationProperty> {
            java.lang.Number storageSizeGiB;

            /**
             * Sets the value of {@link ManagedInstancesStorageConfigurationProperty#getStorageSizeGiB}
             * @param storageSizeGiB The size of the tasks volume. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder storageSizeGiB(java.lang.Number storageSizeGiB) {
                this.storageSizeGiB = storageSizeGiB;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ManagedInstancesStorageConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ManagedInstancesStorageConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ManagedInstancesStorageConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ManagedInstancesStorageConfigurationProperty {
            private final java.lang.Number storageSizeGiB;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.storageSizeGiB = software.amazon.jsii.Kernel.get(this, "storageSizeGiB", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.storageSizeGiB = java.util.Objects.requireNonNull(builder.storageSizeGiB, "storageSizeGiB is required");
            }

            @Override
            public final java.lang.Number getStorageSizeGiB() {
                return this.storageSizeGiB;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("storageSizeGiB", om.valueToTree(this.getStorageSizeGiB()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnCapacityProvider.ManagedInstancesStorageConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ManagedInstancesStorageConfigurationProperty.Jsii$Proxy that = (ManagedInstancesStorageConfigurationProperty.Jsii$Proxy) o;

                return this.storageSizeGiB.equals(that.storageSizeGiB);
            }

            @Override
            public final int hashCode() {
                int result = this.storageSizeGiB.hashCode();
                return result;
            }
        }
    }
    /**
     * The managed scaling settings for the Auto Scaling group capacity provider.
     * <p>
     * When managed scaling is turned on, Amazon ECS manages the scale-in and scale-out actions of the Auto Scaling group. Amazon ECS manages a target tracking scaling policy using an Amazon ECS managed CloudWatch metric with the specified <code>targetCapacity</code> value as the target value for the metric. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/asg-capacity-providers.html#asg-capacity-providers-managed-scaling">Using managed scaling</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     * <p>
     * If managed scaling is off, the user must manage the scaling of the Auto Scaling group.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * ManagedScalingProperty managedScalingProperty = ManagedScalingProperty.builder()
     *         .instanceWarmupPeriod(123)
     *         .maximumScalingStepSize(123)
     *         .minimumScalingStepSize(123)
     *         .status("status")
     *         .targetCapacity(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-managedscaling.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-managedscaling.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnCapacityProvider.ManagedScalingProperty")
    @software.amazon.jsii.Jsii.Proxy(ManagedScalingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ManagedScalingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The period of time, in seconds, after a newly launched Amazon EC2 instance can contribute to CloudWatch metrics for Auto Scaling group.
         * <p>
         * If this parameter is omitted, the default value of <code>300</code> seconds is used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-managedscaling.html#cfn-ecs-capacityprovider-managedscaling-instancewarmupperiod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-managedscaling.html#cfn-ecs-capacityprovider-managedscaling-instancewarmupperiod</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getInstanceWarmupPeriod() {
            return null;
        }

        /**
         * The maximum number of Amazon EC2 instances that Amazon ECS will scale out at one time.
         * <p>
         * If this parameter is omitted, the default value of <code>10000</code> is used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-managedscaling.html#cfn-ecs-capacityprovider-managedscaling-maximumscalingstepsize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-managedscaling.html#cfn-ecs-capacityprovider-managedscaling-maximumscalingstepsize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumScalingStepSize() {
            return null;
        }

        /**
         * The minimum number of Amazon EC2 instances that Amazon ECS will scale out at one time.
         * <p>
         * The scale in process is not affected by this parameter If this parameter is omitted, the default value of <code>1</code> is used.
         * <p>
         * When additional capacity is required, Amazon ECS will scale up the minimum scaling step size even if the actual demand is less than the minimum scaling step size.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-managedscaling.html#cfn-ecs-capacityprovider-managedscaling-minimumscalingstepsize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-managedscaling.html#cfn-ecs-capacityprovider-managedscaling-minimumscalingstepsize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinimumScalingStepSize() {
            return null;
        }

        /**
         * Determines whether to use managed scaling for the capacity provider.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-managedscaling.html#cfn-ecs-capacityprovider-managedscaling-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-managedscaling.html#cfn-ecs-capacityprovider-managedscaling-status</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
            return null;
        }

        /**
         * The target capacity utilization as a percentage for the capacity provider.
         * <p>
         * The specified value must be greater than <code>0</code> and less than or equal to <code>100</code> . For example, if you want the capacity provider to maintain 10% spare capacity, then that means the utilization is 90%, so use a <code>targetCapacity</code> of <code>90</code> . The default value of <code>100</code> percent results in the Amazon EC2 instances in your Auto Scaling group being completely used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-managedscaling.html#cfn-ecs-capacityprovider-managedscaling-targetcapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-managedscaling.html#cfn-ecs-capacityprovider-managedscaling-targetcapacity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTargetCapacity() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ManagedScalingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ManagedScalingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ManagedScalingProperty> {
            java.lang.Number instanceWarmupPeriod;
            java.lang.Number maximumScalingStepSize;
            java.lang.Number minimumScalingStepSize;
            java.lang.String status;
            java.lang.Number targetCapacity;

            /**
             * Sets the value of {@link ManagedScalingProperty#getInstanceWarmupPeriod}
             * @param instanceWarmupPeriod The period of time, in seconds, after a newly launched Amazon EC2 instance can contribute to CloudWatch metrics for Auto Scaling group.
             *                             If this parameter is omitted, the default value of <code>300</code> seconds is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceWarmupPeriod(java.lang.Number instanceWarmupPeriod) {
                this.instanceWarmupPeriod = instanceWarmupPeriod;
                return this;
            }

            /**
             * Sets the value of {@link ManagedScalingProperty#getMaximumScalingStepSize}
             * @param maximumScalingStepSize The maximum number of Amazon EC2 instances that Amazon ECS will scale out at one time.
             *                               If this parameter is omitted, the default value of <code>10000</code> is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumScalingStepSize(java.lang.Number maximumScalingStepSize) {
                this.maximumScalingStepSize = maximumScalingStepSize;
                return this;
            }

            /**
             * Sets the value of {@link ManagedScalingProperty#getMinimumScalingStepSize}
             * @param minimumScalingStepSize The minimum number of Amazon EC2 instances that Amazon ECS will scale out at one time.
             *                               The scale in process is not affected by this parameter If this parameter is omitted, the default value of <code>1</code> is used.
             *                               <p>
             *                               When additional capacity is required, Amazon ECS will scale up the minimum scaling step size even if the actual demand is less than the minimum scaling step size.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minimumScalingStepSize(java.lang.Number minimumScalingStepSize) {
                this.minimumScalingStepSize = minimumScalingStepSize;
                return this;
            }

            /**
             * Sets the value of {@link ManagedScalingProperty#getStatus}
             * @param status Determines whether to use managed scaling for the capacity provider.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Sets the value of {@link ManagedScalingProperty#getTargetCapacity}
             * @param targetCapacity The target capacity utilization as a percentage for the capacity provider.
             *                       The specified value must be greater than <code>0</code> and less than or equal to <code>100</code> . For example, if you want the capacity provider to maintain 10% spare capacity, then that means the utilization is 90%, so use a <code>targetCapacity</code> of <code>90</code> . The default value of <code>100</code> percent results in the Amazon EC2 instances in your Auto Scaling group being completely used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetCapacity(java.lang.Number targetCapacity) {
                this.targetCapacity = targetCapacity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ManagedScalingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ManagedScalingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ManagedScalingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ManagedScalingProperty {
            private final java.lang.Number instanceWarmupPeriod;
            private final java.lang.Number maximumScalingStepSize;
            private final java.lang.Number minimumScalingStepSize;
            private final java.lang.String status;
            private final java.lang.Number targetCapacity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instanceWarmupPeriod = software.amazon.jsii.Kernel.get(this, "instanceWarmupPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maximumScalingStepSize = software.amazon.jsii.Kernel.get(this, "maximumScalingStepSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minimumScalingStepSize = software.amazon.jsii.Kernel.get(this, "minimumScalingStepSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetCapacity = software.amazon.jsii.Kernel.get(this, "targetCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instanceWarmupPeriod = builder.instanceWarmupPeriod;
                this.maximumScalingStepSize = builder.maximumScalingStepSize;
                this.minimumScalingStepSize = builder.minimumScalingStepSize;
                this.status = builder.status;
                this.targetCapacity = builder.targetCapacity;
            }

            @Override
            public final java.lang.Number getInstanceWarmupPeriod() {
                return this.instanceWarmupPeriod;
            }

            @Override
            public final java.lang.Number getMaximumScalingStepSize() {
                return this.maximumScalingStepSize;
            }

            @Override
            public final java.lang.Number getMinimumScalingStepSize() {
                return this.minimumScalingStepSize;
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            public final java.lang.Number getTargetCapacity() {
                return this.targetCapacity;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getInstanceWarmupPeriod() != null) {
                    data.set("instanceWarmupPeriod", om.valueToTree(this.getInstanceWarmupPeriod()));
                }
                if (this.getMaximumScalingStepSize() != null) {
                    data.set("maximumScalingStepSize", om.valueToTree(this.getMaximumScalingStepSize()));
                }
                if (this.getMinimumScalingStepSize() != null) {
                    data.set("minimumScalingStepSize", om.valueToTree(this.getMinimumScalingStepSize()));
                }
                if (this.getStatus() != null) {
                    data.set("status", om.valueToTree(this.getStatus()));
                }
                if (this.getTargetCapacity() != null) {
                    data.set("targetCapacity", om.valueToTree(this.getTargetCapacity()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnCapacityProvider.ManagedScalingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ManagedScalingProperty.Jsii$Proxy that = (ManagedScalingProperty.Jsii$Proxy) o;

                if (this.instanceWarmupPeriod != null ? !this.instanceWarmupPeriod.equals(that.instanceWarmupPeriod) : that.instanceWarmupPeriod != null) return false;
                if (this.maximumScalingStepSize != null ? !this.maximumScalingStepSize.equals(that.maximumScalingStepSize) : that.maximumScalingStepSize != null) return false;
                if (this.minimumScalingStepSize != null ? !this.minimumScalingStepSize.equals(that.minimumScalingStepSize) : that.minimumScalingStepSize != null) return false;
                if (this.status != null ? !this.status.equals(that.status) : that.status != null) return false;
                return this.targetCapacity != null ? this.targetCapacity.equals(that.targetCapacity) : that.targetCapacity == null;
            }

            @Override
            public final int hashCode() {
                int result = this.instanceWarmupPeriod != null ? this.instanceWarmupPeriod.hashCode() : 0;
                result = 31 * result + (this.maximumScalingStepSize != null ? this.maximumScalingStepSize.hashCode() : 0);
                result = 31 * result + (this.minimumScalingStepSize != null ? this.minimumScalingStepSize.hashCode() : 0);
                result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
                result = 31 * result + (this.targetCapacity != null ? this.targetCapacity.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The minimum and maximum amount of memory per vCPU in gibibytes (GiB).
     * <p>
     * This helps ensure that instance types have the appropriate memory-to-CPU ratio for your workloads.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * MemoryGiBPerVCpuRequestProperty memoryGiBPerVCpuRequestProperty = MemoryGiBPerVCpuRequestProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-memorygibpervcpurequest.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-memorygibpervcpurequest.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnCapacityProvider.MemoryGiBPerVCpuRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(MemoryGiBPerVCpuRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MemoryGiBPerVCpuRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum amount of memory per vCPU in GiB.
         * <p>
         * Instance types with a higher memory-to-vCPU ratio are excluded from selection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-memorygibpervcpurequest.html#cfn-ecs-capacityprovider-memorygibpervcpurequest-max">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-memorygibpervcpurequest.html#cfn-ecs-capacityprovider-memorygibpervcpurequest-max</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * The minimum amount of memory per vCPU in GiB.
         * <p>
         * Instance types with a lower memory-to-vCPU ratio are excluded from selection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-memorygibpervcpurequest.html#cfn-ecs-capacityprovider-memorygibpervcpurequest-min">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-memorygibpervcpurequest.html#cfn-ecs-capacityprovider-memorygibpervcpurequest-min</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MemoryGiBPerVCpuRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MemoryGiBPerVCpuRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MemoryGiBPerVCpuRequestProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link MemoryGiBPerVCpuRequestProperty#getMax}
             * @param max The maximum amount of memory per vCPU in GiB.
             *            Instance types with a higher memory-to-vCPU ratio are excluded from selection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link MemoryGiBPerVCpuRequestProperty#getMin}
             * @param min The minimum amount of memory per vCPU in GiB.
             *            Instance types with a lower memory-to-vCPU ratio are excluded from selection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MemoryGiBPerVCpuRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MemoryGiBPerVCpuRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MemoryGiBPerVCpuRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MemoryGiBPerVCpuRequestProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnCapacityProvider.MemoryGiBPerVCpuRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MemoryGiBPerVCpuRequestProperty.Jsii$Proxy that = (MemoryGiBPerVCpuRequestProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The minimum and maximum amount of memory in mebibytes (MiB) for instance type selection.
     * <p>
     * This ensures that selected instance types have adequate memory for your workloads.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * MemoryMiBRequestProperty memoryMiBRequestProperty = MemoryMiBRequestProperty.builder()
     *         .min(123)
     *         // the properties below are optional
     *         .max(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-memorymibrequest.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-memorymibrequest.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnCapacityProvider.MemoryMiBRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(MemoryMiBRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MemoryMiBRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The minimum amount of memory in MiB.
         * <p>
         * Instance types with less memory than this value are excluded from selection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-memorymibrequest.html#cfn-ecs-capacityprovider-memorymibrequest-min">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-memorymibrequest.html#cfn-ecs-capacityprovider-memorymibrequest-min</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMin();

        /**
         * The maximum amount of memory in MiB.
         * <p>
         * Instance types with more memory than this value are excluded from selection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-memorymibrequest.html#cfn-ecs-capacityprovider-memorymibrequest-max">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-memorymibrequest.html#cfn-ecs-capacityprovider-memorymibrequest-max</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MemoryMiBRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MemoryMiBRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MemoryMiBRequestProperty> {
            java.lang.Number min;
            java.lang.Number max;

            /**
             * Sets the value of {@link MemoryMiBRequestProperty#getMin}
             * @param min The minimum amount of memory in MiB. This parameter is required.
             *            Instance types with less memory than this value are excluded from selection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Sets the value of {@link MemoryMiBRequestProperty#getMax}
             * @param max The maximum amount of memory in MiB.
             *            Instance types with more memory than this value are excluded from selection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MemoryMiBRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MemoryMiBRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MemoryMiBRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MemoryMiBRequestProperty {
            private final java.lang.Number min;
            private final java.lang.Number max;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.min = java.util.Objects.requireNonNull(builder.min, "min is required");
                this.max = builder.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("min", om.valueToTree(this.getMin()));
                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnCapacityProvider.MemoryMiBRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MemoryMiBRequestProperty.Jsii$Proxy that = (MemoryMiBRequestProperty.Jsii$Proxy) o;

                if (!min.equals(that.min)) return false;
                return this.max != null ? this.max.equals(that.max) : that.max == null;
            }

            @Override
            public final int hashCode() {
                int result = this.min.hashCode();
                result = 31 * result + (this.max != null ? this.max.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The minimum and maximum network bandwidth in gigabits per second (Gbps) for instance type selection.
     * <p>
     * This is important for network-intensive workloads.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * NetworkBandwidthGbpsRequestProperty networkBandwidthGbpsRequestProperty = NetworkBandwidthGbpsRequestProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-networkbandwidthgbpsrequest.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-networkbandwidthgbpsrequest.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnCapacityProvider.NetworkBandwidthGbpsRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(NetworkBandwidthGbpsRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NetworkBandwidthGbpsRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum network bandwidth in Gbps.
         * <p>
         * Instance types with higher network bandwidth are excluded from selection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-networkbandwidthgbpsrequest.html#cfn-ecs-capacityprovider-networkbandwidthgbpsrequest-max">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-networkbandwidthgbpsrequest.html#cfn-ecs-capacityprovider-networkbandwidthgbpsrequest-max</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * The minimum network bandwidth in Gbps.
         * <p>
         * Instance types with lower network bandwidth are excluded from selection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-networkbandwidthgbpsrequest.html#cfn-ecs-capacityprovider-networkbandwidthgbpsrequest-min">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-networkbandwidthgbpsrequest.html#cfn-ecs-capacityprovider-networkbandwidthgbpsrequest-min</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NetworkBandwidthGbpsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NetworkBandwidthGbpsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NetworkBandwidthGbpsRequestProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link NetworkBandwidthGbpsRequestProperty#getMax}
             * @param max The maximum network bandwidth in Gbps.
             *            Instance types with higher network bandwidth are excluded from selection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link NetworkBandwidthGbpsRequestProperty#getMin}
             * @param min The minimum network bandwidth in Gbps.
             *            Instance types with lower network bandwidth are excluded from selection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkBandwidthGbpsRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NetworkBandwidthGbpsRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NetworkBandwidthGbpsRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkBandwidthGbpsRequestProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnCapacityProvider.NetworkBandwidthGbpsRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NetworkBandwidthGbpsRequestProperty.Jsii$Proxy that = (NetworkBandwidthGbpsRequestProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The minimum and maximum number of network interfaces for instance type selection.
     * <p>
     * This is useful for workloads that require multiple network interfaces.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * NetworkInterfaceCountRequestProperty networkInterfaceCountRequestProperty = NetworkInterfaceCountRequestProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-networkinterfacecountrequest.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-networkinterfacecountrequest.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnCapacityProvider.NetworkInterfaceCountRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(NetworkInterfaceCountRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NetworkInterfaceCountRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum number of network interfaces.
         * <p>
         * Instance types that support more network interfaces are excluded from selection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-networkinterfacecountrequest.html#cfn-ecs-capacityprovider-networkinterfacecountrequest-max">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-networkinterfacecountrequest.html#cfn-ecs-capacityprovider-networkinterfacecountrequest-max</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * The minimum number of network interfaces.
         * <p>
         * Instance types that support fewer network interfaces are excluded from selection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-networkinterfacecountrequest.html#cfn-ecs-capacityprovider-networkinterfacecountrequest-min">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-networkinterfacecountrequest.html#cfn-ecs-capacityprovider-networkinterfacecountrequest-min</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NetworkInterfaceCountRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NetworkInterfaceCountRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NetworkInterfaceCountRequestProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link NetworkInterfaceCountRequestProperty#getMax}
             * @param max The maximum number of network interfaces.
             *            Instance types that support more network interfaces are excluded from selection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceCountRequestProperty#getMin}
             * @param min The minimum number of network interfaces.
             *            Instance types that support fewer network interfaces are excluded from selection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkInterfaceCountRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NetworkInterfaceCountRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NetworkInterfaceCountRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkInterfaceCountRequestProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnCapacityProvider.NetworkInterfaceCountRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NetworkInterfaceCountRequestProperty.Jsii$Proxy that = (NetworkInterfaceCountRequestProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The minimum and maximum total local storage in gigabytes (GB) for instance types with local storage.
     * <p>
     * This is useful for workloads that require local storage for temporary data or caching.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * TotalLocalStorageGBRequestProperty totalLocalStorageGBRequestProperty = TotalLocalStorageGBRequestProperty.builder()
     *         .max(123)
     *         .min(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-totallocalstoragegbrequest.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-totallocalstoragegbrequest.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnCapacityProvider.TotalLocalStorageGBRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(TotalLocalStorageGBRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TotalLocalStorageGBRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum total local storage in GB.
         * <p>
         * Instance types with more local storage are excluded from selection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-totallocalstoragegbrequest.html#cfn-ecs-capacityprovider-totallocalstoragegbrequest-max">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-totallocalstoragegbrequest.html#cfn-ecs-capacityprovider-totallocalstoragegbrequest-max</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * The minimum total local storage in GB.
         * <p>
         * Instance types with less local storage are excluded from selection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-totallocalstoragegbrequest.html#cfn-ecs-capacityprovider-totallocalstoragegbrequest-min">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-totallocalstoragegbrequest.html#cfn-ecs-capacityprovider-totallocalstoragegbrequest-min</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMin() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TotalLocalStorageGBRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TotalLocalStorageGBRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TotalLocalStorageGBRequestProperty> {
            java.lang.Number max;
            java.lang.Number min;

            /**
             * Sets the value of {@link TotalLocalStorageGBRequestProperty#getMax}
             * @param max The maximum total local storage in GB.
             *            Instance types with more local storage are excluded from selection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Sets the value of {@link TotalLocalStorageGBRequestProperty#getMin}
             * @param min The minimum total local storage in GB.
             *            Instance types with less local storage are excluded from selection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TotalLocalStorageGBRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TotalLocalStorageGBRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TotalLocalStorageGBRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TotalLocalStorageGBRequestProperty {
            private final java.lang.Number max;
            private final java.lang.Number min;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.max = builder.max;
                this.min = builder.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }
                if (this.getMin() != null) {
                    data.set("min", om.valueToTree(this.getMin()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnCapacityProvider.TotalLocalStorageGBRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TotalLocalStorageGBRequestProperty.Jsii$Proxy that = (TotalLocalStorageGBRequestProperty.Jsii$Proxy) o;

                if (this.max != null ? !this.max.equals(that.max) : that.max != null) return false;
                return this.min != null ? this.min.equals(that.min) : that.min == null;
            }

            @Override
            public final int hashCode() {
                int result = this.max != null ? this.max.hashCode() : 0;
                result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The minimum and maximum number of vCPUs for instance type selection.
     * <p>
     * This allows you to specify a range of vCPU counts that meet your workload requirements.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * VCpuCountRangeRequestProperty vCpuCountRangeRequestProperty = VCpuCountRangeRequestProperty.builder()
     *         .min(123)
     *         // the properties below are optional
     *         .max(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-vcpucountrangerequest.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-vcpucountrangerequest.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnCapacityProvider.VCpuCountRangeRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(VCpuCountRangeRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VCpuCountRangeRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The minimum number of vCPUs.
         * <p>
         * Instance types with fewer vCPUs than this value are excluded from selection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-vcpucountrangerequest.html#cfn-ecs-capacityprovider-vcpucountrangerequest-min">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-vcpucountrangerequest.html#cfn-ecs-capacityprovider-vcpucountrangerequest-min</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMin();

        /**
         * The maximum number of vCPUs.
         * <p>
         * Instance types with more vCPUs than this value are excluded from selection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-vcpucountrangerequest.html#cfn-ecs-capacityprovider-vcpucountrangerequest-max">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-capacityprovider-vcpucountrangerequest.html#cfn-ecs-capacityprovider-vcpucountrangerequest-max</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMax() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VCpuCountRangeRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VCpuCountRangeRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VCpuCountRangeRequestProperty> {
            java.lang.Number min;
            java.lang.Number max;

            /**
             * Sets the value of {@link VCpuCountRangeRequestProperty#getMin}
             * @param min The minimum number of vCPUs. This parameter is required.
             *            Instance types with fewer vCPUs than this value are excluded from selection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder min(java.lang.Number min) {
                this.min = min;
                return this;
            }

            /**
             * Sets the value of {@link VCpuCountRangeRequestProperty#getMax}
             * @param max The maximum number of vCPUs.
             *            Instance types with more vCPUs than this value are excluded from selection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder max(java.lang.Number max) {
                this.max = max;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VCpuCountRangeRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VCpuCountRangeRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VCpuCountRangeRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VCpuCountRangeRequestProperty {
            private final java.lang.Number min;
            private final java.lang.Number max;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.min = software.amazon.jsii.Kernel.get(this, "min", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.max = software.amazon.jsii.Kernel.get(this, "max", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.min = java.util.Objects.requireNonNull(builder.min, "min is required");
                this.max = builder.max;
            }

            @Override
            public final java.lang.Number getMin() {
                return this.min;
            }

            @Override
            public final java.lang.Number getMax() {
                return this.max;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("min", om.valueToTree(this.getMin()));
                if (this.getMax() != null) {
                    data.set("max", om.valueToTree(this.getMax()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnCapacityProvider.VCpuCountRangeRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VCpuCountRangeRequestProperty.Jsii$Proxy that = (VCpuCountRangeRequestProperty.Jsii$Proxy) o;

                if (!min.equals(that.min)) return false;
                return this.max != null ? this.max.equals(that.max) : that.max == null;
            }

            @Override
            public final int hashCode() {
                int result = this.min.hashCode();
                result = 31 * result + (this.max != null ? this.max.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ecs.CfnCapacityProvider}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecs.CfnCapacityProvider> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.ecs.CfnCapacityProviderProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The Auto Scaling group settings for the capacity provider.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-capacityprovider.html#cfn-ecs-capacityprovider-autoscalinggroupprovider">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-capacityprovider.html#cfn-ecs-capacityprovider-autoscalinggroupprovider</a>
         * @param autoScalingGroupProvider The Auto Scaling group settings for the capacity provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingGroupProvider(final software.amazon.awscdk.IResolvable autoScalingGroupProvider) {
            this.props().autoScalingGroupProvider(autoScalingGroupProvider);
            return this;
        }
        /**
         * The Auto Scaling group settings for the capacity provider.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-capacityprovider.html#cfn-ecs-capacityprovider-autoscalinggroupprovider">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-capacityprovider.html#cfn-ecs-capacityprovider-autoscalinggroupprovider</a>
         * @param autoScalingGroupProvider The Auto Scaling group settings for the capacity provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingGroupProvider(final software.amazon.awscdk.services.ecs.CfnCapacityProvider.AutoScalingGroupProviderProperty autoScalingGroupProvider) {
            this.props().autoScalingGroupProvider(autoScalingGroupProvider);
            return this;
        }

        /**
         * The cluster that this capacity provider is associated with.
         * <p>
         * Managed instances capacity providers are cluster-scoped, meaning they can only be used within their associated cluster.
         * <p>
         * This is required for Managed instances.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-capacityprovider.html#cfn-ecs-capacityprovider-clustername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-capacityprovider.html#cfn-ecs-capacityprovider-clustername</a>
         * @param clusterName The cluster that this capacity provider is associated with. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterName(final java.lang.String clusterName) {
            this.props().clusterName(clusterName);
            return this;
        }

        /**
         * The configuration for the Amazon ECS Managed Instances provider.
         * <p>
         * This includes the infrastructure role, the launch template configuration, and tag propagation settings.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-capacityprovider.html#cfn-ecs-capacityprovider-managedinstancesprovider">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-capacityprovider.html#cfn-ecs-capacityprovider-managedinstancesprovider</a>
         * @param managedInstancesProvider The configuration for the Amazon ECS Managed Instances provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder managedInstancesProvider(final software.amazon.awscdk.IResolvable managedInstancesProvider) {
            this.props().managedInstancesProvider(managedInstancesProvider);
            return this;
        }
        /**
         * The configuration for the Amazon ECS Managed Instances provider.
         * <p>
         * This includes the infrastructure role, the launch template configuration, and tag propagation settings.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-capacityprovider.html#cfn-ecs-capacityprovider-managedinstancesprovider">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-capacityprovider.html#cfn-ecs-capacityprovider-managedinstancesprovider</a>
         * @param managedInstancesProvider The configuration for the Amazon ECS Managed Instances provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder managedInstancesProvider(final software.amazon.awscdk.services.ecs.CfnCapacityProvider.ManagedInstancesProviderProperty managedInstancesProvider) {
            this.props().managedInstancesProvider(managedInstancesProvider);
            return this;
        }

        /**
         * The name of the capacity provider.
         * <p>
         * If a name is specified, it cannot start with <code>aws</code> , <code>ecs</code> , or <code>fargate</code> . If no name is specified, a default name in the <code>CFNStackName-CFNResourceName-RandomString</code> format is used.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-capacityprovider.html#cfn-ecs-capacityprovider-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-capacityprovider.html#cfn-ecs-capacityprovider-name</a>
         * @param name The name of the capacity provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props().name(name);
            return this;
        }

        /**
         * The metadata that you apply to the capacity provider to help you categorize and organize it.
         * <p>
         * Each tag consists of a key and an optional value. You define both.
         * <p>
         * The following basic restrictions apply to tags:
         * <p>
         * <ul>
         * <li>Maximum number of tags per resource - 50</li>
         * <li>For each resource, each tag key must be unique, and each tag key can have only one value.</li>
         * <li>Maximum key length - 128 Unicode characters in UTF-8</li>
         * <li>Maximum value length - 256 Unicode characters in UTF-8</li>
         * <li>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : /</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-capacityprovider.html#cfn-ecs-capacityprovider-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-capacityprovider.html#cfn-ecs-capacityprovider-tags</a>
         * @param tags The metadata that you apply to the capacity provider to help you categorize and organize it. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ecs.CfnCapacityProvider}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ecs.CfnCapacityProvider build() {
            return new software.amazon.awscdk.services.ecs.CfnCapacityProvider(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ecs.CfnCapacityProviderProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ecs.CfnCapacityProviderProps.Builder();
            }
            return this.props;
        }
    }
}
