package software.amazon.awscdk.services.ecs;

/**
 * Creates an Express service that simplifies deploying containerized web applications on Amazon ECS with managed AWS infrastructure.
 * <p>
 * This operation provisions and configures Application Load Balancers, target groups, security groups, and auto-scaling policies automatically.
 * <p>
 * Specify a primary container configuration with your application image and basic settings. Amazon ECS creates the necessary AWS resources for traffic distribution, health monitoring, network access control, and capacity management.
 * <p>
 * Provide an execution role for task operations and an infrastructure role for managing AWS resources on your behalf.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecs.*;
 * CfnExpressGatewayService cfnExpressGatewayService = CfnExpressGatewayService.Builder.create(this, "MyCfnExpressGatewayService")
 *         .executionRoleArn("executionRoleArn")
 *         .infrastructureRoleArn("infrastructureRoleArn")
 *         .primaryContainer(ExpressGatewayContainerProperty.builder()
 *                 .image("image")
 *                 // the properties below are optional
 *                 .awsLogsConfiguration(ExpressGatewayServiceAwsLogsConfigurationProperty.builder()
 *                         .logGroup("logGroup")
 *                         .logStreamPrefix("logStreamPrefix")
 *                         .build())
 *                 .command(List.of("command"))
 *                 .containerPort(123)
 *                 .environment(List.of(KeyValuePairProperty.builder()
 *                         .name("name")
 *                         .value("value")
 *                         .build()))
 *                 .repositoryCredentials(ExpressGatewayRepositoryCredentialsProperty.builder()
 *                         .credentialsParameter("credentialsParameter")
 *                         .build())
 *                 .secrets(List.of(SecretProperty.builder()
 *                         .name("name")
 *                         .valueFrom("valueFrom")
 *                         .build()))
 *                 .build())
 *         // the properties below are optional
 *         .cluster("cluster")
 *         .cpu("cpu")
 *         .healthCheckPath("healthCheckPath")
 *         .memory("memory")
 *         .networkConfiguration(ExpressGatewayServiceNetworkConfigurationProperty.builder()
 *                 .securityGroups(List.of("securityGroups"))
 *                 .subnets(List.of("subnets"))
 *                 .build())
 *         .scalingTarget(ExpressGatewayScalingTargetProperty.builder()
 *                 .autoScalingMetric("autoScalingMetric")
 *                 .autoScalingTargetValue(123)
 *                 .maxTaskCount(123)
 *                 .minTaskCount(123)
 *                 .build())
 *         .serviceName("serviceName")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .taskRoleArn("taskRoleArn")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-expressgatewayservice.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-expressgatewayservice.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:19.828Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnExpressGatewayService")
public class CfnExpressGatewayService extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.ecs.IExpressGatewayServiceRef, software.amazon.awscdk.ITaggableV2 {

    protected CfnExpressGatewayService(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnExpressGatewayService(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ecs.CfnExpressGatewayService.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::ECS::ExpressGatewayService</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnExpressGatewayService(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.CfnExpressGatewayServiceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Checks whether the given object is a CfnExpressGatewayService.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isCfnExpressGatewayService(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.CfnExpressGatewayService.class, "isCfnExpressGatewayService", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The list of active service configurations for the Express service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrActiveConfigurations() {
        return software.amazon.jsii.Kernel.get(this, "attrActiveConfigurations", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The Unix timestamp for when the Express service was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN that identifies the Express service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrServiceArn() {
        return software.amazon.jsii.Kernel.get(this, "attrServiceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The Unix timestamp for when the Express service was last updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUpdatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrUpdatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A reference to a ExpressGatewayService resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.ecs.ExpressGatewayServiceReference getExpressGatewayServiceRef() {
        return software.amazon.jsii.Kernel.get(this, "expressGatewayServiceRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.ecs.ExpressGatewayServiceReference.class));
    }

    /**
     * The ARN of the task execution role for the service revision.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getExecutionRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "executionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the task execution role for the service revision.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExecutionRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "executionRoleArn", java.util.Objects.requireNonNull(value, "executionRoleArn is required"));
    }

    /**
     * The ARN of the infrastructure role that manages AWS resources for the Express service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getInfrastructureRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "infrastructureRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the infrastructure role that manages AWS resources for the Express service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInfrastructureRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "infrastructureRoleArn", java.util.Objects.requireNonNull(value, "infrastructureRoleArn is required"));
    }

    /**
     * The primary container configuration for this service revision.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ecs.CfnExpressGatewayService.ExpressGatewayContainerProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getPrimaryContainer() {
        return software.amazon.jsii.Kernel.get(this, "primaryContainer", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The primary container configuration for this service revision.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPrimaryContainer(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "primaryContainer", java.util.Objects.requireNonNull(value, "primaryContainer is required"));
    }

    /**
     * The primary container configuration for this service revision.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPrimaryContainer(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.CfnExpressGatewayService.ExpressGatewayContainerProperty value) {
        software.amazon.jsii.Kernel.set(this, "primaryContainer", java.util.Objects.requireNonNull(value, "primaryContainer is required"));
    }

    /**
     * The short name or full ARN of the cluster that hosts the Express service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCluster() {
        return software.amazon.jsii.Kernel.get(this, "cluster", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The short name or full ARN of the cluster that hosts the Express service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCluster(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "cluster", value);
    }

    /**
     * The CPU allocation for tasks in this service revision.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCpu() {
        return software.amazon.jsii.Kernel.get(this, "cpu", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The CPU allocation for tasks in this service revision.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCpu(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "cpu", value);
    }

    /**
     * The health check path for this service revision.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getHealthCheckPath() {
        return software.amazon.jsii.Kernel.get(this, "healthCheckPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The health check path for this service revision.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHealthCheckPath(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "healthCheckPath", value);
    }

    /**
     * The memory allocation for tasks in this service revision.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMemory() {
        return software.amazon.jsii.Kernel.get(this, "memory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The memory allocation for tasks in this service revision.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMemory(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "memory", value);
    }

    /**
     * The network configuration for tasks in this service revision.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ecs.CfnExpressGatewayService.ExpressGatewayServiceNetworkConfigurationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getNetworkConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "networkConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The network configuration for tasks in this service revision.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNetworkConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "networkConfiguration", value);
    }

    /**
     * The network configuration for tasks in this service revision.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNetworkConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.CfnExpressGatewayService.ExpressGatewayServiceNetworkConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "networkConfiguration", value);
    }

    /**
     * The auto-scaling configuration for this service revision.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ecs.CfnExpressGatewayService.ExpressGatewayScalingTargetProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getScalingTarget() {
        return software.amazon.jsii.Kernel.get(this, "scalingTarget", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The auto-scaling configuration for this service revision.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScalingTarget(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "scalingTarget", value);
    }

    /**
     * The auto-scaling configuration for this service revision.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScalingTarget(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.CfnExpressGatewayService.ExpressGatewayScalingTargetProperty value) {
        software.amazon.jsii.Kernel.set(this, "scalingTarget", value);
    }

    /**
     * The name of the Express service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getServiceName() {
        return software.amazon.jsii.Kernel.get(this, "serviceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the Express service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServiceName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "serviceName", value);
    }

    /**
     * The metadata applied to the Express service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The metadata applied to the Express service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }

    /**
     * The ARN of the task role for the service revision.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTaskRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "taskRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the task role for the service revision.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTaskRoleArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "taskRoleArn", value);
    }
    /**
     * Defines the configuration for the primary container in an Express service.
     * <p>
     * This container receives traffic from the Application Load Balancer and runs your application code.
     * <p>
     * The container configuration includes the container image, port mapping, logging settings, environment variables, and secrets. The container image is the only required parameter, with sensible defaults provided for other settings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * ExpressGatewayContainerProperty expressGatewayContainerProperty = ExpressGatewayContainerProperty.builder()
     *         .image("image")
     *         // the properties below are optional
     *         .awsLogsConfiguration(ExpressGatewayServiceAwsLogsConfigurationProperty.builder()
     *                 .logGroup("logGroup")
     *                 .logStreamPrefix("logStreamPrefix")
     *                 .build())
     *         .command(List.of("command"))
     *         .containerPort(123)
     *         .environment(List.of(KeyValuePairProperty.builder()
     *                 .name("name")
     *                 .value("value")
     *                 .build()))
     *         .repositoryCredentials(ExpressGatewayRepositoryCredentialsProperty.builder()
     *                 .credentialsParameter("credentialsParameter")
     *                 .build())
     *         .secrets(List.of(SecretProperty.builder()
     *                 .name("name")
     *                 .valueFrom("valueFrom")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewaycontainer.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewaycontainer.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnExpressGatewayService.ExpressGatewayContainerProperty")
    @software.amazon.jsii.Jsii.Proxy(ExpressGatewayContainerProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExpressGatewayContainerProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The image used to start a container.
         * <p>
         * This string is passed directly to the Docker daemon. Images in the Docker Hub registry are available by default. Other repositories are specified with either <code>repository-url/image:tag</code> or <code>repository-url/image&#64;digest</code> .
         * <p>
         * For Express services, the image typically contains a web application that listens on the specified container port. The image can be stored in Amazon ECR, Docker Hub, or any other container registry accessible to your execution role.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewaycontainer.html#cfn-ecs-expressgatewayservice-expressgatewaycontainer-image">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewaycontainer.html#cfn-ecs-expressgatewayservice-expressgatewaycontainer-image</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getImage();

        /**
         * The log configuration for the container.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ecs.CfnExpressGatewayService.ExpressGatewayServiceAwsLogsConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewaycontainer.html#cfn-ecs-expressgatewayservice-expressgatewaycontainer-awslogsconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewaycontainer.html#cfn-ecs-expressgatewayservice-expressgatewaycontainer-awslogsconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAwsLogsConfiguration() {
            return null;
        }

        /**
         * The command that is passed to the container.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewaycontainer.html#cfn-ecs-expressgatewayservice-expressgatewaycontainer-command">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewaycontainer.html#cfn-ecs-expressgatewayservice-expressgatewaycontainer-command</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCommand() {
            return null;
        }

        /**
         * The port number on the container that receives traffic from the load balancer.
         * <p>
         * Default is 80.
         * <p>
         * Default: - 80
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewaycontainer.html#cfn-ecs-expressgatewayservice-expressgatewaycontainer-containerport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewaycontainer.html#cfn-ecs-expressgatewayservice-expressgatewaycontainer-containerport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getContainerPort() {
            return null;
        }

        /**
         * The environment variables to pass to the container.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ecs.CfnExpressGatewayService.KeyValuePairProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewaycontainer.html#cfn-ecs-expressgatewayservice-expressgatewaycontainer-environment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewaycontainer.html#cfn-ecs-expressgatewayservice-expressgatewaycontainer-environment</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnvironment() {
            return null;
        }

        /**
         * The configuration for repository credentials for private registry authentication.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ecs.CfnExpressGatewayService.ExpressGatewayRepositoryCredentialsProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewaycontainer.html#cfn-ecs-expressgatewayservice-expressgatewaycontainer-repositorycredentials">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewaycontainer.html#cfn-ecs-expressgatewayservice-expressgatewaycontainer-repositorycredentials</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRepositoryCredentials() {
            return null;
        }

        /**
         * The secrets to pass to the container.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ecs.CfnExpressGatewayService.SecretProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewaycontainer.html#cfn-ecs-expressgatewayservice-expressgatewaycontainer-secrets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewaycontainer.html#cfn-ecs-expressgatewayservice-expressgatewaycontainer-secrets</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSecrets() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ExpressGatewayContainerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExpressGatewayContainerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExpressGatewayContainerProperty> {
            java.lang.String image;
            java.lang.Object awsLogsConfiguration;
            java.util.List<java.lang.String> command;
            java.lang.Number containerPort;
            java.lang.Object environment;
            java.lang.Object repositoryCredentials;
            java.lang.Object secrets;

            /**
             * Sets the value of {@link ExpressGatewayContainerProperty#getImage}
             * @param image The image used to start a container. This parameter is required.
             *              This string is passed directly to the Docker daemon. Images in the Docker Hub registry are available by default. Other repositories are specified with either <code>repository-url/image:tag</code> or <code>repository-url/image&#64;digest</code> .
             *              <p>
             *              For Express services, the image typically contains a web application that listens on the specified container port. The image can be stored in Amazon ECR, Docker Hub, or any other container registry accessible to your execution role.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder image(java.lang.String image) {
                this.image = image;
                return this;
            }

            /**
             * Sets the value of {@link ExpressGatewayContainerProperty#getAwsLogsConfiguration}
             * @param awsLogsConfiguration The log configuration for the container.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsLogsConfiguration(software.amazon.awscdk.IResolvable awsLogsConfiguration) {
                this.awsLogsConfiguration = awsLogsConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ExpressGatewayContainerProperty#getAwsLogsConfiguration}
             * @param awsLogsConfiguration The log configuration for the container.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsLogsConfiguration(software.amazon.awscdk.services.ecs.CfnExpressGatewayService.ExpressGatewayServiceAwsLogsConfigurationProperty awsLogsConfiguration) {
                this.awsLogsConfiguration = awsLogsConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ExpressGatewayContainerProperty#getCommand}
             * @param command The command that is passed to the container.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder command(java.util.List<java.lang.String> command) {
                this.command = command;
                return this;
            }

            /**
             * Sets the value of {@link ExpressGatewayContainerProperty#getContainerPort}
             * @param containerPort The port number on the container that receives traffic from the load balancer.
             *                      Default is 80.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerPort(java.lang.Number containerPort) {
                this.containerPort = containerPort;
                return this;
            }

            /**
             * Sets the value of {@link ExpressGatewayContainerProperty#getEnvironment}
             * @param environment The environment variables to pass to the container.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environment(software.amazon.awscdk.IResolvable environment) {
                this.environment = environment;
                return this;
            }

            /**
             * Sets the value of {@link ExpressGatewayContainerProperty#getEnvironment}
             * @param environment The environment variables to pass to the container.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environment(java.util.List<? extends java.lang.Object> environment) {
                this.environment = environment;
                return this;
            }

            /**
             * Sets the value of {@link ExpressGatewayContainerProperty#getRepositoryCredentials}
             * @param repositoryCredentials The configuration for repository credentials for private registry authentication.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder repositoryCredentials(software.amazon.awscdk.IResolvable repositoryCredentials) {
                this.repositoryCredentials = repositoryCredentials;
                return this;
            }

            /**
             * Sets the value of {@link ExpressGatewayContainerProperty#getRepositoryCredentials}
             * @param repositoryCredentials The configuration for repository credentials for private registry authentication.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder repositoryCredentials(software.amazon.awscdk.services.ecs.CfnExpressGatewayService.ExpressGatewayRepositoryCredentialsProperty repositoryCredentials) {
                this.repositoryCredentials = repositoryCredentials;
                return this;
            }

            /**
             * Sets the value of {@link ExpressGatewayContainerProperty#getSecrets}
             * @param secrets The secrets to pass to the container.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secrets(software.amazon.awscdk.IResolvable secrets) {
                this.secrets = secrets;
                return this;
            }

            /**
             * Sets the value of {@link ExpressGatewayContainerProperty#getSecrets}
             * @param secrets The secrets to pass to the container.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secrets(java.util.List<? extends java.lang.Object> secrets) {
                this.secrets = secrets;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExpressGatewayContainerProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExpressGatewayContainerProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExpressGatewayContainerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExpressGatewayContainerProperty {
            private final java.lang.String image;
            private final java.lang.Object awsLogsConfiguration;
            private final java.util.List<java.lang.String> command;
            private final java.lang.Number containerPort;
            private final java.lang.Object environment;
            private final java.lang.Object repositoryCredentials;
            private final java.lang.Object secrets;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.image = software.amazon.jsii.Kernel.get(this, "image", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.awsLogsConfiguration = software.amazon.jsii.Kernel.get(this, "awsLogsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.command = software.amazon.jsii.Kernel.get(this, "command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.containerPort = software.amazon.jsii.Kernel.get(this, "containerPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.repositoryCredentials = software.amazon.jsii.Kernel.get(this, "repositoryCredentials", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.secrets = software.amazon.jsii.Kernel.get(this, "secrets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.image = java.util.Objects.requireNonNull(builder.image, "image is required");
                this.awsLogsConfiguration = builder.awsLogsConfiguration;
                this.command = builder.command;
                this.containerPort = builder.containerPort;
                this.environment = builder.environment;
                this.repositoryCredentials = builder.repositoryCredentials;
                this.secrets = builder.secrets;
            }

            @Override
            public final java.lang.String getImage() {
                return this.image;
            }

            @Override
            public final java.lang.Object getAwsLogsConfiguration() {
                return this.awsLogsConfiguration;
            }

            @Override
            public final java.util.List<java.lang.String> getCommand() {
                return this.command;
            }

            @Override
            public final java.lang.Number getContainerPort() {
                return this.containerPort;
            }

            @Override
            public final java.lang.Object getEnvironment() {
                return this.environment;
            }

            @Override
            public final java.lang.Object getRepositoryCredentials() {
                return this.repositoryCredentials;
            }

            @Override
            public final java.lang.Object getSecrets() {
                return this.secrets;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("image", om.valueToTree(this.getImage()));
                if (this.getAwsLogsConfiguration() != null) {
                    data.set("awsLogsConfiguration", om.valueToTree(this.getAwsLogsConfiguration()));
                }
                if (this.getCommand() != null) {
                    data.set("command", om.valueToTree(this.getCommand()));
                }
                if (this.getContainerPort() != null) {
                    data.set("containerPort", om.valueToTree(this.getContainerPort()));
                }
                if (this.getEnvironment() != null) {
                    data.set("environment", om.valueToTree(this.getEnvironment()));
                }
                if (this.getRepositoryCredentials() != null) {
                    data.set("repositoryCredentials", om.valueToTree(this.getRepositoryCredentials()));
                }
                if (this.getSecrets() != null) {
                    data.set("secrets", om.valueToTree(this.getSecrets()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnExpressGatewayService.ExpressGatewayContainerProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExpressGatewayContainerProperty.Jsii$Proxy that = (ExpressGatewayContainerProperty.Jsii$Proxy) o;

                if (!image.equals(that.image)) return false;
                if (this.awsLogsConfiguration != null ? !this.awsLogsConfiguration.equals(that.awsLogsConfiguration) : that.awsLogsConfiguration != null) return false;
                if (this.command != null ? !this.command.equals(that.command) : that.command != null) return false;
                if (this.containerPort != null ? !this.containerPort.equals(that.containerPort) : that.containerPort != null) return false;
                if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
                if (this.repositoryCredentials != null ? !this.repositoryCredentials.equals(that.repositoryCredentials) : that.repositoryCredentials != null) return false;
                return this.secrets != null ? this.secrets.equals(that.secrets) : that.secrets == null;
            }

            @Override
            public final int hashCode() {
                int result = this.image.hashCode();
                result = 31 * result + (this.awsLogsConfiguration != null ? this.awsLogsConfiguration.hashCode() : 0);
                result = 31 * result + (this.command != null ? this.command.hashCode() : 0);
                result = 31 * result + (this.containerPort != null ? this.containerPort.hashCode() : 0);
                result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
                result = 31 * result + (this.repositoryCredentials != null ? this.repositoryCredentials.hashCode() : 0);
                result = 31 * result + (this.secrets != null ? this.secrets.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The repository credentials for private registry authentication to pass to the container.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * ExpressGatewayRepositoryCredentialsProperty expressGatewayRepositoryCredentialsProperty = ExpressGatewayRepositoryCredentialsProperty.builder()
     *         .credentialsParameter("credentialsParameter")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayrepositorycredentials.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayrepositorycredentials.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnExpressGatewayService.ExpressGatewayRepositoryCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(ExpressGatewayRepositoryCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExpressGatewayRepositoryCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the secret containing the private repository credentials.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayrepositorycredentials.html#cfn-ecs-expressgatewayservice-expressgatewayrepositorycredentials-credentialsparameter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayrepositorycredentials.html#cfn-ecs-expressgatewayservice-expressgatewayrepositorycredentials-credentialsparameter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCredentialsParameter();

        /**
         * @return a {@link Builder} of {@link ExpressGatewayRepositoryCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExpressGatewayRepositoryCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExpressGatewayRepositoryCredentialsProperty> {
            java.lang.String credentialsParameter;

            /**
             * Sets the value of {@link ExpressGatewayRepositoryCredentialsProperty#getCredentialsParameter}
             * @param credentialsParameter The Amazon Resource Name (ARN) of the secret containing the private repository credentials. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder credentialsParameter(java.lang.String credentialsParameter) {
                this.credentialsParameter = credentialsParameter;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExpressGatewayRepositoryCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExpressGatewayRepositoryCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExpressGatewayRepositoryCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExpressGatewayRepositoryCredentialsProperty {
            private final java.lang.String credentialsParameter;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.credentialsParameter = software.amazon.jsii.Kernel.get(this, "credentialsParameter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.credentialsParameter = java.util.Objects.requireNonNull(builder.credentialsParameter, "credentialsParameter is required");
            }

            @Override
            public final java.lang.String getCredentialsParameter() {
                return this.credentialsParameter;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("credentialsParameter", om.valueToTree(this.getCredentialsParameter()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnExpressGatewayService.ExpressGatewayRepositoryCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExpressGatewayRepositoryCredentialsProperty.Jsii$Proxy that = (ExpressGatewayRepositoryCredentialsProperty.Jsii$Proxy) o;

                return this.credentialsParameter.equals(that.credentialsParameter);
            }

            @Override
            public final int hashCode() {
                int result = this.credentialsParameter.hashCode();
                return result;
            }
        }
    }
    /**
     * Defines the auto-scaling configuration for an Express service.
     * <p>
     * This determines how the service automatically adjusts the number of running tasks based on demand metrics such as CPU utilization, memory utilization, or request count per target.
     * <p>
     * Auto-scaling helps ensure your application can handle varying levels of traffic while optimizing costs by scaling down during low-demand periods. You can specify the minimum and maximum number of tasks, the scaling metric, and the target value for that metric.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * ExpressGatewayScalingTargetProperty expressGatewayScalingTargetProperty = ExpressGatewayScalingTargetProperty.builder()
     *         .autoScalingMetric("autoScalingMetric")
     *         .autoScalingTargetValue(123)
     *         .maxTaskCount(123)
     *         .minTaskCount(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayscalingtarget.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayscalingtarget.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnExpressGatewayService.ExpressGatewayScalingTargetProperty")
    @software.amazon.jsii.Jsii.Proxy(ExpressGatewayScalingTargetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExpressGatewayScalingTargetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The metric used for auto-scaling decisions.
         * <p>
         * The default metric used for an Express service is <code>CPUUtilization</code> .
         * <p>
         * Default: - "AVERAGE_CPU"
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayscalingtarget.html#cfn-ecs-expressgatewayservice-expressgatewayscalingtarget-autoscalingmetric">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayscalingtarget.html#cfn-ecs-expressgatewayservice-expressgatewayscalingtarget-autoscalingmetric</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAutoScalingMetric() {
            return null;
        }

        /**
         * The target value for the auto-scaling metric.
         * <p>
         * The default value for an Express service is 60.
         * <p>
         * Default: - 60
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayscalingtarget.html#cfn-ecs-expressgatewayservice-expressgatewayscalingtarget-autoscalingtargetvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayscalingtarget.html#cfn-ecs-expressgatewayservice-expressgatewayscalingtarget-autoscalingtargetvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getAutoScalingTargetValue() {
            return null;
        }

        /**
         * The maximum number of tasks to run in the Express service.
         * <p>
         * Default: - 1
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayscalingtarget.html#cfn-ecs-expressgatewayservice-expressgatewayscalingtarget-maxtaskcount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayscalingtarget.html#cfn-ecs-expressgatewayservice-expressgatewayscalingtarget-maxtaskcount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxTaskCount() {
            return null;
        }

        /**
         * The minimum number of tasks to run in the Express service.
         * <p>
         * Default: - 1
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayscalingtarget.html#cfn-ecs-expressgatewayservice-expressgatewayscalingtarget-mintaskcount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayscalingtarget.html#cfn-ecs-expressgatewayservice-expressgatewayscalingtarget-mintaskcount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinTaskCount() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ExpressGatewayScalingTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExpressGatewayScalingTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExpressGatewayScalingTargetProperty> {
            java.lang.String autoScalingMetric;
            java.lang.Number autoScalingTargetValue;
            java.lang.Number maxTaskCount;
            java.lang.Number minTaskCount;

            /**
             * Sets the value of {@link ExpressGatewayScalingTargetProperty#getAutoScalingMetric}
             * @param autoScalingMetric The metric used for auto-scaling decisions.
             *                          The default metric used for an Express service is <code>CPUUtilization</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoScalingMetric(java.lang.String autoScalingMetric) {
                this.autoScalingMetric = autoScalingMetric;
                return this;
            }

            /**
             * Sets the value of {@link ExpressGatewayScalingTargetProperty#getAutoScalingTargetValue}
             * @param autoScalingTargetValue The target value for the auto-scaling metric.
             *                               The default value for an Express service is 60.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoScalingTargetValue(java.lang.Number autoScalingTargetValue) {
                this.autoScalingTargetValue = autoScalingTargetValue;
                return this;
            }

            /**
             * Sets the value of {@link ExpressGatewayScalingTargetProperty#getMaxTaskCount}
             * @param maxTaskCount The maximum number of tasks to run in the Express service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxTaskCount(java.lang.Number maxTaskCount) {
                this.maxTaskCount = maxTaskCount;
                return this;
            }

            /**
             * Sets the value of {@link ExpressGatewayScalingTargetProperty#getMinTaskCount}
             * @param minTaskCount The minimum number of tasks to run in the Express service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minTaskCount(java.lang.Number minTaskCount) {
                this.minTaskCount = minTaskCount;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExpressGatewayScalingTargetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExpressGatewayScalingTargetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExpressGatewayScalingTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExpressGatewayScalingTargetProperty {
            private final java.lang.String autoScalingMetric;
            private final java.lang.Number autoScalingTargetValue;
            private final java.lang.Number maxTaskCount;
            private final java.lang.Number minTaskCount;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.autoScalingMetric = software.amazon.jsii.Kernel.get(this, "autoScalingMetric", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.autoScalingTargetValue = software.amazon.jsii.Kernel.get(this, "autoScalingTargetValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maxTaskCount = software.amazon.jsii.Kernel.get(this, "maxTaskCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minTaskCount = software.amazon.jsii.Kernel.get(this, "minTaskCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.autoScalingMetric = builder.autoScalingMetric;
                this.autoScalingTargetValue = builder.autoScalingTargetValue;
                this.maxTaskCount = builder.maxTaskCount;
                this.minTaskCount = builder.minTaskCount;
            }

            @Override
            public final java.lang.String getAutoScalingMetric() {
                return this.autoScalingMetric;
            }

            @Override
            public final java.lang.Number getAutoScalingTargetValue() {
                return this.autoScalingTargetValue;
            }

            @Override
            public final java.lang.Number getMaxTaskCount() {
                return this.maxTaskCount;
            }

            @Override
            public final java.lang.Number getMinTaskCount() {
                return this.minTaskCount;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAutoScalingMetric() != null) {
                    data.set("autoScalingMetric", om.valueToTree(this.getAutoScalingMetric()));
                }
                if (this.getAutoScalingTargetValue() != null) {
                    data.set("autoScalingTargetValue", om.valueToTree(this.getAutoScalingTargetValue()));
                }
                if (this.getMaxTaskCount() != null) {
                    data.set("maxTaskCount", om.valueToTree(this.getMaxTaskCount()));
                }
                if (this.getMinTaskCount() != null) {
                    data.set("minTaskCount", om.valueToTree(this.getMinTaskCount()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnExpressGatewayService.ExpressGatewayScalingTargetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExpressGatewayScalingTargetProperty.Jsii$Proxy that = (ExpressGatewayScalingTargetProperty.Jsii$Proxy) o;

                if (this.autoScalingMetric != null ? !this.autoScalingMetric.equals(that.autoScalingMetric) : that.autoScalingMetric != null) return false;
                if (this.autoScalingTargetValue != null ? !this.autoScalingTargetValue.equals(that.autoScalingTargetValue) : that.autoScalingTargetValue != null) return false;
                if (this.maxTaskCount != null ? !this.maxTaskCount.equals(that.maxTaskCount) : that.maxTaskCount != null) return false;
                return this.minTaskCount != null ? this.minTaskCount.equals(that.minTaskCount) : that.minTaskCount == null;
            }

            @Override
            public final int hashCode() {
                int result = this.autoScalingMetric != null ? this.autoScalingMetric.hashCode() : 0;
                result = 31 * result + (this.autoScalingTargetValue != null ? this.autoScalingTargetValue.hashCode() : 0);
                result = 31 * result + (this.maxTaskCount != null ? this.maxTaskCount.hashCode() : 0);
                result = 31 * result + (this.minTaskCount != null ? this.minTaskCount.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the Amazon CloudWatch Logs configuration for the Express service container.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * ExpressGatewayServiceAwsLogsConfigurationProperty expressGatewayServiceAwsLogsConfigurationProperty = ExpressGatewayServiceAwsLogsConfigurationProperty.builder()
     *         .logGroup("logGroup")
     *         .logStreamPrefix("logStreamPrefix")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayserviceawslogsconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayserviceawslogsconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnExpressGatewayService.ExpressGatewayServiceAwsLogsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ExpressGatewayServiceAwsLogsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExpressGatewayServiceAwsLogsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the CloudWatch Logs log group to send container logs to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayserviceawslogsconfiguration.html#cfn-ecs-expressgatewayservice-expressgatewayserviceawslogsconfiguration-loggroup">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayserviceawslogsconfiguration.html#cfn-ecs-expressgatewayservice-expressgatewayserviceawslogsconfiguration-loggroup</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLogGroup();

        /**
         * The prefix for the CloudWatch Logs log stream names.
         * <p>
         * The default for an Express service is <code>ecs</code> .
         * <p>
         * Default: - "ecs"
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayserviceawslogsconfiguration.html#cfn-ecs-expressgatewayservice-expressgatewayserviceawslogsconfiguration-logstreamprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayserviceawslogsconfiguration.html#cfn-ecs-expressgatewayservice-expressgatewayserviceawslogsconfiguration-logstreamprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLogStreamPrefix();

        /**
         * @return a {@link Builder} of {@link ExpressGatewayServiceAwsLogsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExpressGatewayServiceAwsLogsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExpressGatewayServiceAwsLogsConfigurationProperty> {
            java.lang.String logGroup;
            java.lang.String logStreamPrefix;

            /**
             * Sets the value of {@link ExpressGatewayServiceAwsLogsConfigurationProperty#getLogGroup}
             * @param logGroup The name of the CloudWatch Logs log group to send container logs to. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logGroup(java.lang.String logGroup) {
                this.logGroup = logGroup;
                return this;
            }

            /**
             * Sets the value of {@link ExpressGatewayServiceAwsLogsConfigurationProperty#getLogStreamPrefix}
             * @param logStreamPrefix The prefix for the CloudWatch Logs log stream names. This parameter is required.
             *                        The default for an Express service is <code>ecs</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logStreamPrefix(java.lang.String logStreamPrefix) {
                this.logStreamPrefix = logStreamPrefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExpressGatewayServiceAwsLogsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExpressGatewayServiceAwsLogsConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExpressGatewayServiceAwsLogsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExpressGatewayServiceAwsLogsConfigurationProperty {
            private final java.lang.String logGroup;
            private final java.lang.String logStreamPrefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.logGroup = software.amazon.jsii.Kernel.get(this, "logGroup", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.logStreamPrefix = software.amazon.jsii.Kernel.get(this, "logStreamPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.logGroup = java.util.Objects.requireNonNull(builder.logGroup, "logGroup is required");
                this.logStreamPrefix = java.util.Objects.requireNonNull(builder.logStreamPrefix, "logStreamPrefix is required");
            }

            @Override
            public final java.lang.String getLogGroup() {
                return this.logGroup;
            }

            @Override
            public final java.lang.String getLogStreamPrefix() {
                return this.logStreamPrefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("logGroup", om.valueToTree(this.getLogGroup()));
                data.set("logStreamPrefix", om.valueToTree(this.getLogStreamPrefix()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnExpressGatewayService.ExpressGatewayServiceAwsLogsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExpressGatewayServiceAwsLogsConfigurationProperty.Jsii$Proxy that = (ExpressGatewayServiceAwsLogsConfigurationProperty.Jsii$Proxy) o;

                if (!logGroup.equals(that.logGroup)) return false;
                return this.logStreamPrefix.equals(that.logStreamPrefix);
            }

            @Override
            public final int hashCode() {
                int result = this.logGroup.hashCode();
                result = 31 * result + (this.logStreamPrefix.hashCode());
                return result;
            }
        }
    }
    /**
     * Represents a specific configuration revision of an Express service, containing all the settings and parameters for that revision.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * ExpressGatewayServiceConfigurationProperty expressGatewayServiceConfigurationProperty = ExpressGatewayServiceConfigurationProperty.builder()
     *         .cpu("cpu")
     *         .createdAt("createdAt")
     *         .executionRoleArn("executionRoleArn")
     *         .healthCheckPath("healthCheckPath")
     *         .ingressPaths(List.of(IngressPathSummaryProperty.builder()
     *                 .accessType("accessType")
     *                 .endpoint("endpoint")
     *                 .build()))
     *         .memory("memory")
     *         .networkConfiguration(ExpressGatewayServiceNetworkConfigurationProperty.builder()
     *                 .securityGroups(List.of("securityGroups"))
     *                 .subnets(List.of("subnets"))
     *                 .build())
     *         .primaryContainer(ExpressGatewayContainerProperty.builder()
     *                 .image("image")
     *                 // the properties below are optional
     *                 .awsLogsConfiguration(ExpressGatewayServiceAwsLogsConfigurationProperty.builder()
     *                         .logGroup("logGroup")
     *                         .logStreamPrefix("logStreamPrefix")
     *                         .build())
     *                 .command(List.of("command"))
     *                 .containerPort(123)
     *                 .environment(List.of(KeyValuePairProperty.builder()
     *                         .name("name")
     *                         .value("value")
     *                         .build()))
     *                 .repositoryCredentials(ExpressGatewayRepositoryCredentialsProperty.builder()
     *                         .credentialsParameter("credentialsParameter")
     *                         .build())
     *                 .secrets(List.of(SecretProperty.builder()
     *                         .name("name")
     *                         .valueFrom("valueFrom")
     *                         .build()))
     *                 .build())
     *         .scalingTarget(ExpressGatewayScalingTargetProperty.builder()
     *                 .autoScalingMetric("autoScalingMetric")
     *                 .autoScalingTargetValue(123)
     *                 .maxTaskCount(123)
     *                 .minTaskCount(123)
     *                 .build())
     *         .serviceRevisionArn("serviceRevisionArn")
     *         .taskRoleArn("taskRoleArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayserviceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayserviceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnExpressGatewayService.ExpressGatewayServiceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ExpressGatewayServiceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExpressGatewayServiceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The CPU allocation for tasks in this service revision.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayserviceconfiguration.html#cfn-ecs-expressgatewayservice-expressgatewayserviceconfiguration-cpu">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayserviceconfiguration.html#cfn-ecs-expressgatewayservice-expressgatewayserviceconfiguration-cpu</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCpu() {
            return null;
        }

        /**
         * The Unix timestamp for when this service revision was created.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayserviceconfiguration.html#cfn-ecs-expressgatewayservice-expressgatewayserviceconfiguration-createdat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayserviceconfiguration.html#cfn-ecs-expressgatewayservice-expressgatewayserviceconfiguration-createdat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCreatedAt() {
            return null;
        }

        /**
         * The ARN of the task execution role for the service revision.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayserviceconfiguration.html#cfn-ecs-expressgatewayservice-expressgatewayserviceconfiguration-executionrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayserviceconfiguration.html#cfn-ecs-expressgatewayservice-expressgatewayserviceconfiguration-executionrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExecutionRoleArn() {
            return null;
        }

        /**
         * The health check path for this service revision.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayserviceconfiguration.html#cfn-ecs-expressgatewayservice-expressgatewayserviceconfiguration-healthcheckpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayserviceconfiguration.html#cfn-ecs-expressgatewayservice-expressgatewayserviceconfiguration-healthcheckpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHealthCheckPath() {
            return null;
        }

        /**
         * The entry point into this service revision.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ecs.CfnExpressGatewayService.IngressPathSummaryProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayserviceconfiguration.html#cfn-ecs-expressgatewayservice-expressgatewayserviceconfiguration-ingresspaths">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayserviceconfiguration.html#cfn-ecs-expressgatewayservice-expressgatewayserviceconfiguration-ingresspaths</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIngressPaths() {
            return null;
        }

        /**
         * The memory allocation for tasks in this service revision.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayserviceconfiguration.html#cfn-ecs-expressgatewayservice-expressgatewayserviceconfiguration-memory">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayserviceconfiguration.html#cfn-ecs-expressgatewayservice-expressgatewayserviceconfiguration-memory</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMemory() {
            return null;
        }

        /**
         * The network configuration for tasks in this service revision.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ecs.CfnExpressGatewayService.ExpressGatewayServiceNetworkConfigurationProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayserviceconfiguration.html#cfn-ecs-expressgatewayservice-expressgatewayserviceconfiguration-networkconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayserviceconfiguration.html#cfn-ecs-expressgatewayservice-expressgatewayserviceconfiguration-networkconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkConfiguration() {
            return null;
        }

        /**
         * The primary container configuration for this service revision.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ecs.CfnExpressGatewayService.ExpressGatewayContainerProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayserviceconfiguration.html#cfn-ecs-expressgatewayservice-expressgatewayserviceconfiguration-primarycontainer">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayserviceconfiguration.html#cfn-ecs-expressgatewayservice-expressgatewayserviceconfiguration-primarycontainer</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPrimaryContainer() {
            return null;
        }

        /**
         * The auto-scaling configuration for this service revision.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.ecs.CfnExpressGatewayService.ExpressGatewayScalingTargetProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayserviceconfiguration.html#cfn-ecs-expressgatewayservice-expressgatewayserviceconfiguration-scalingtarget">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayserviceconfiguration.html#cfn-ecs-expressgatewayservice-expressgatewayserviceconfiguration-scalingtarget</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getScalingTarget() {
            return null;
        }

        /**
         * The ARN of the service revision.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayserviceconfiguration.html#cfn-ecs-expressgatewayservice-expressgatewayserviceconfiguration-servicerevisionarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayserviceconfiguration.html#cfn-ecs-expressgatewayservice-expressgatewayserviceconfiguration-servicerevisionarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServiceRevisionArn() {
            return null;
        }

        /**
         * The ARN of the task role for the service revision.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayserviceconfiguration.html#cfn-ecs-expressgatewayservice-expressgatewayserviceconfiguration-taskrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayserviceconfiguration.html#cfn-ecs-expressgatewayservice-expressgatewayserviceconfiguration-taskrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTaskRoleArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ExpressGatewayServiceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExpressGatewayServiceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExpressGatewayServiceConfigurationProperty> {
            java.lang.String cpu;
            java.lang.String createdAt;
            java.lang.String executionRoleArn;
            java.lang.String healthCheckPath;
            java.lang.Object ingressPaths;
            java.lang.String memory;
            java.lang.Object networkConfiguration;
            java.lang.Object primaryContainer;
            java.lang.Object scalingTarget;
            java.lang.String serviceRevisionArn;
            java.lang.String taskRoleArn;

            /**
             * Sets the value of {@link ExpressGatewayServiceConfigurationProperty#getCpu}
             * @param cpu The CPU allocation for tasks in this service revision.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cpu(java.lang.String cpu) {
                this.cpu = cpu;
                return this;
            }

            /**
             * Sets the value of {@link ExpressGatewayServiceConfigurationProperty#getCreatedAt}
             * @param createdAt The Unix timestamp for when this service revision was created.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createdAt(java.lang.String createdAt) {
                this.createdAt = createdAt;
                return this;
            }

            /**
             * Sets the value of {@link ExpressGatewayServiceConfigurationProperty#getExecutionRoleArn}
             * @param executionRoleArn The ARN of the task execution role for the service revision.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder executionRoleArn(java.lang.String executionRoleArn) {
                this.executionRoleArn = executionRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link ExpressGatewayServiceConfigurationProperty#getHealthCheckPath}
             * @param healthCheckPath The health check path for this service revision.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder healthCheckPath(java.lang.String healthCheckPath) {
                this.healthCheckPath = healthCheckPath;
                return this;
            }

            /**
             * Sets the value of {@link ExpressGatewayServiceConfigurationProperty#getIngressPaths}
             * @param ingressPaths The entry point into this service revision.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ingressPaths(software.amazon.awscdk.IResolvable ingressPaths) {
                this.ingressPaths = ingressPaths;
                return this;
            }

            /**
             * Sets the value of {@link ExpressGatewayServiceConfigurationProperty#getIngressPaths}
             * @param ingressPaths The entry point into this service revision.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ingressPaths(java.util.List<? extends java.lang.Object> ingressPaths) {
                this.ingressPaths = ingressPaths;
                return this;
            }

            /**
             * Sets the value of {@link ExpressGatewayServiceConfigurationProperty#getMemory}
             * @param memory The memory allocation for tasks in this service revision.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memory(java.lang.String memory) {
                this.memory = memory;
                return this;
            }

            /**
             * Sets the value of {@link ExpressGatewayServiceConfigurationProperty#getNetworkConfiguration}
             * @param networkConfiguration The network configuration for tasks in this service revision.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkConfiguration(software.amazon.awscdk.IResolvable networkConfiguration) {
                this.networkConfiguration = networkConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ExpressGatewayServiceConfigurationProperty#getNetworkConfiguration}
             * @param networkConfiguration The network configuration for tasks in this service revision.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkConfiguration(software.amazon.awscdk.services.ecs.CfnExpressGatewayService.ExpressGatewayServiceNetworkConfigurationProperty networkConfiguration) {
                this.networkConfiguration = networkConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ExpressGatewayServiceConfigurationProperty#getPrimaryContainer}
             * @param primaryContainer The primary container configuration for this service revision.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder primaryContainer(software.amazon.awscdk.IResolvable primaryContainer) {
                this.primaryContainer = primaryContainer;
                return this;
            }

            /**
             * Sets the value of {@link ExpressGatewayServiceConfigurationProperty#getPrimaryContainer}
             * @param primaryContainer The primary container configuration for this service revision.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder primaryContainer(software.amazon.awscdk.services.ecs.CfnExpressGatewayService.ExpressGatewayContainerProperty primaryContainer) {
                this.primaryContainer = primaryContainer;
                return this;
            }

            /**
             * Sets the value of {@link ExpressGatewayServiceConfigurationProperty#getScalingTarget}
             * @param scalingTarget The auto-scaling configuration for this service revision.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scalingTarget(software.amazon.awscdk.IResolvable scalingTarget) {
                this.scalingTarget = scalingTarget;
                return this;
            }

            /**
             * Sets the value of {@link ExpressGatewayServiceConfigurationProperty#getScalingTarget}
             * @param scalingTarget The auto-scaling configuration for this service revision.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scalingTarget(software.amazon.awscdk.services.ecs.CfnExpressGatewayService.ExpressGatewayScalingTargetProperty scalingTarget) {
                this.scalingTarget = scalingTarget;
                return this;
            }

            /**
             * Sets the value of {@link ExpressGatewayServiceConfigurationProperty#getServiceRevisionArn}
             * @param serviceRevisionArn The ARN of the service revision.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceRevisionArn(java.lang.String serviceRevisionArn) {
                this.serviceRevisionArn = serviceRevisionArn;
                return this;
            }

            /**
             * Sets the value of {@link ExpressGatewayServiceConfigurationProperty#getTaskRoleArn}
             * @param taskRoleArn The ARN of the task role for the service revision.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder taskRoleArn(java.lang.String taskRoleArn) {
                this.taskRoleArn = taskRoleArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExpressGatewayServiceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExpressGatewayServiceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExpressGatewayServiceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExpressGatewayServiceConfigurationProperty {
            private final java.lang.String cpu;
            private final java.lang.String createdAt;
            private final java.lang.String executionRoleArn;
            private final java.lang.String healthCheckPath;
            private final java.lang.Object ingressPaths;
            private final java.lang.String memory;
            private final java.lang.Object networkConfiguration;
            private final java.lang.Object primaryContainer;
            private final java.lang.Object scalingTarget;
            private final java.lang.String serviceRevisionArn;
            private final java.lang.String taskRoleArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cpu = software.amazon.jsii.Kernel.get(this, "cpu", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.createdAt = software.amazon.jsii.Kernel.get(this, "createdAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.executionRoleArn = software.amazon.jsii.Kernel.get(this, "executionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.healthCheckPath = software.amazon.jsii.Kernel.get(this, "healthCheckPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ingressPaths = software.amazon.jsii.Kernel.get(this, "ingressPaths", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.memory = software.amazon.jsii.Kernel.get(this, "memory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.networkConfiguration = software.amazon.jsii.Kernel.get(this, "networkConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.primaryContainer = software.amazon.jsii.Kernel.get(this, "primaryContainer", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.scalingTarget = software.amazon.jsii.Kernel.get(this, "scalingTarget", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.serviceRevisionArn = software.amazon.jsii.Kernel.get(this, "serviceRevisionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.taskRoleArn = software.amazon.jsii.Kernel.get(this, "taskRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cpu = builder.cpu;
                this.createdAt = builder.createdAt;
                this.executionRoleArn = builder.executionRoleArn;
                this.healthCheckPath = builder.healthCheckPath;
                this.ingressPaths = builder.ingressPaths;
                this.memory = builder.memory;
                this.networkConfiguration = builder.networkConfiguration;
                this.primaryContainer = builder.primaryContainer;
                this.scalingTarget = builder.scalingTarget;
                this.serviceRevisionArn = builder.serviceRevisionArn;
                this.taskRoleArn = builder.taskRoleArn;
            }

            @Override
            public final java.lang.String getCpu() {
                return this.cpu;
            }

            @Override
            public final java.lang.String getCreatedAt() {
                return this.createdAt;
            }

            @Override
            public final java.lang.String getExecutionRoleArn() {
                return this.executionRoleArn;
            }

            @Override
            public final java.lang.String getHealthCheckPath() {
                return this.healthCheckPath;
            }

            @Override
            public final java.lang.Object getIngressPaths() {
                return this.ingressPaths;
            }

            @Override
            public final java.lang.String getMemory() {
                return this.memory;
            }

            @Override
            public final java.lang.Object getNetworkConfiguration() {
                return this.networkConfiguration;
            }

            @Override
            public final java.lang.Object getPrimaryContainer() {
                return this.primaryContainer;
            }

            @Override
            public final java.lang.Object getScalingTarget() {
                return this.scalingTarget;
            }

            @Override
            public final java.lang.String getServiceRevisionArn() {
                return this.serviceRevisionArn;
            }

            @Override
            public final java.lang.String getTaskRoleArn() {
                return this.taskRoleArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCpu() != null) {
                    data.set("cpu", om.valueToTree(this.getCpu()));
                }
                if (this.getCreatedAt() != null) {
                    data.set("createdAt", om.valueToTree(this.getCreatedAt()));
                }
                if (this.getExecutionRoleArn() != null) {
                    data.set("executionRoleArn", om.valueToTree(this.getExecutionRoleArn()));
                }
                if (this.getHealthCheckPath() != null) {
                    data.set("healthCheckPath", om.valueToTree(this.getHealthCheckPath()));
                }
                if (this.getIngressPaths() != null) {
                    data.set("ingressPaths", om.valueToTree(this.getIngressPaths()));
                }
                if (this.getMemory() != null) {
                    data.set("memory", om.valueToTree(this.getMemory()));
                }
                if (this.getNetworkConfiguration() != null) {
                    data.set("networkConfiguration", om.valueToTree(this.getNetworkConfiguration()));
                }
                if (this.getPrimaryContainer() != null) {
                    data.set("primaryContainer", om.valueToTree(this.getPrimaryContainer()));
                }
                if (this.getScalingTarget() != null) {
                    data.set("scalingTarget", om.valueToTree(this.getScalingTarget()));
                }
                if (this.getServiceRevisionArn() != null) {
                    data.set("serviceRevisionArn", om.valueToTree(this.getServiceRevisionArn()));
                }
                if (this.getTaskRoleArn() != null) {
                    data.set("taskRoleArn", om.valueToTree(this.getTaskRoleArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnExpressGatewayService.ExpressGatewayServiceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExpressGatewayServiceConfigurationProperty.Jsii$Proxy that = (ExpressGatewayServiceConfigurationProperty.Jsii$Proxy) o;

                if (this.cpu != null ? !this.cpu.equals(that.cpu) : that.cpu != null) return false;
                if (this.createdAt != null ? !this.createdAt.equals(that.createdAt) : that.createdAt != null) return false;
                if (this.executionRoleArn != null ? !this.executionRoleArn.equals(that.executionRoleArn) : that.executionRoleArn != null) return false;
                if (this.healthCheckPath != null ? !this.healthCheckPath.equals(that.healthCheckPath) : that.healthCheckPath != null) return false;
                if (this.ingressPaths != null ? !this.ingressPaths.equals(that.ingressPaths) : that.ingressPaths != null) return false;
                if (this.memory != null ? !this.memory.equals(that.memory) : that.memory != null) return false;
                if (this.networkConfiguration != null ? !this.networkConfiguration.equals(that.networkConfiguration) : that.networkConfiguration != null) return false;
                if (this.primaryContainer != null ? !this.primaryContainer.equals(that.primaryContainer) : that.primaryContainer != null) return false;
                if (this.scalingTarget != null ? !this.scalingTarget.equals(that.scalingTarget) : that.scalingTarget != null) return false;
                if (this.serviceRevisionArn != null ? !this.serviceRevisionArn.equals(that.serviceRevisionArn) : that.serviceRevisionArn != null) return false;
                return this.taskRoleArn != null ? this.taskRoleArn.equals(that.taskRoleArn) : that.taskRoleArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cpu != null ? this.cpu.hashCode() : 0;
                result = 31 * result + (this.createdAt != null ? this.createdAt.hashCode() : 0);
                result = 31 * result + (this.executionRoleArn != null ? this.executionRoleArn.hashCode() : 0);
                result = 31 * result + (this.healthCheckPath != null ? this.healthCheckPath.hashCode() : 0);
                result = 31 * result + (this.ingressPaths != null ? this.ingressPaths.hashCode() : 0);
                result = 31 * result + (this.memory != null ? this.memory.hashCode() : 0);
                result = 31 * result + (this.networkConfiguration != null ? this.networkConfiguration.hashCode() : 0);
                result = 31 * result + (this.primaryContainer != null ? this.primaryContainer.hashCode() : 0);
                result = 31 * result + (this.scalingTarget != null ? this.scalingTarget.hashCode() : 0);
                result = 31 * result + (this.serviceRevisionArn != null ? this.serviceRevisionArn.hashCode() : 0);
                result = 31 * result + (this.taskRoleArn != null ? this.taskRoleArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The network configuration for an Express service.
     * <p>
     * By default, an Express service utilizes subnets and security groups associated with the default VPC.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * ExpressGatewayServiceNetworkConfigurationProperty expressGatewayServiceNetworkConfigurationProperty = ExpressGatewayServiceNetworkConfigurationProperty.builder()
     *         .securityGroups(List.of("securityGroups"))
     *         .subnets(List.of("subnets"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayservicenetworkconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayservicenetworkconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnExpressGatewayService.ExpressGatewayServiceNetworkConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ExpressGatewayServiceNetworkConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExpressGatewayServiceNetworkConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The IDs of the security groups associated with the Express service.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayservicenetworkconfiguration.html#cfn-ecs-expressgatewayservice-expressgatewayservicenetworkconfiguration-securitygroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayservicenetworkconfiguration.html#cfn-ecs-expressgatewayservice-expressgatewayservicenetworkconfiguration-securitygroups</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroups() {
            return null;
        }

        /**
         * The IDs of the subnets associated with the Express service.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayservicenetworkconfiguration.html#cfn-ecs-expressgatewayservice-expressgatewayservicenetworkconfiguration-subnets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayservicenetworkconfiguration.html#cfn-ecs-expressgatewayservice-expressgatewayservicenetworkconfiguration-subnets</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSubnets() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ExpressGatewayServiceNetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExpressGatewayServiceNetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExpressGatewayServiceNetworkConfigurationProperty> {
            java.util.List<java.lang.String> securityGroups;
            java.util.List<java.lang.String> subnets;

            /**
             * Sets the value of {@link ExpressGatewayServiceNetworkConfigurationProperty#getSecurityGroups}
             * @param securityGroups The IDs of the security groups associated with the Express service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroups(java.util.List<java.lang.String> securityGroups) {
                this.securityGroups = securityGroups;
                return this;
            }

            /**
             * Sets the value of {@link ExpressGatewayServiceNetworkConfigurationProperty#getSubnets}
             * @param subnets The IDs of the subnets associated with the Express service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnets(java.util.List<java.lang.String> subnets) {
                this.subnets = subnets;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExpressGatewayServiceNetworkConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExpressGatewayServiceNetworkConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExpressGatewayServiceNetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExpressGatewayServiceNetworkConfigurationProperty {
            private final java.util.List<java.lang.String> securityGroups;
            private final java.util.List<java.lang.String> subnets;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.subnets = software.amazon.jsii.Kernel.get(this, "subnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.securityGroups = builder.securityGroups;
                this.subnets = builder.subnets;
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroups() {
                return this.securityGroups;
            }

            @Override
            public final java.util.List<java.lang.String> getSubnets() {
                return this.subnets;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSecurityGroups() != null) {
                    data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
                }
                if (this.getSubnets() != null) {
                    data.set("subnets", om.valueToTree(this.getSubnets()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnExpressGatewayService.ExpressGatewayServiceNetworkConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExpressGatewayServiceNetworkConfigurationProperty.Jsii$Proxy that = (ExpressGatewayServiceNetworkConfigurationProperty.Jsii$Proxy) o;

                if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
                return this.subnets != null ? this.subnets.equals(that.subnets) : that.subnets == null;
            }

            @Override
            public final int hashCode() {
                int result = this.securityGroups != null ? this.securityGroups.hashCode() : 0;
                result = 31 * result + (this.subnets != null ? this.subnets.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that defines the status of Express service creation and information about the status of the service.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * ExpressGatewayServiceStatusProperty expressGatewayServiceStatusProperty = ExpressGatewayServiceStatusProperty.builder()
     *         .statusCode("statusCode")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayservicestatus.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayservicestatus.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnExpressGatewayService.ExpressGatewayServiceStatusProperty")
    @software.amazon.jsii.Jsii.Proxy(ExpressGatewayServiceStatusProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExpressGatewayServiceStatusProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The status of the Express service.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayservicestatus.html#cfn-ecs-expressgatewayservice-expressgatewayservicestatus-statuscode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-expressgatewayservicestatus.html#cfn-ecs-expressgatewayservice-expressgatewayservicestatus-statuscode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStatusCode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ExpressGatewayServiceStatusProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExpressGatewayServiceStatusProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExpressGatewayServiceStatusProperty> {
            java.lang.String statusCode;

            /**
             * Sets the value of {@link ExpressGatewayServiceStatusProperty#getStatusCode}
             * @param statusCode The status of the Express service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statusCode(java.lang.String statusCode) {
                this.statusCode = statusCode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExpressGatewayServiceStatusProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExpressGatewayServiceStatusProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExpressGatewayServiceStatusProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExpressGatewayServiceStatusProperty {
            private final java.lang.String statusCode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.statusCode = software.amazon.jsii.Kernel.get(this, "statusCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.statusCode = builder.statusCode;
            }

            @Override
            public final java.lang.String getStatusCode() {
                return this.statusCode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getStatusCode() != null) {
                    data.set("statusCode", om.valueToTree(this.getStatusCode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnExpressGatewayService.ExpressGatewayServiceStatusProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExpressGatewayServiceStatusProperty.Jsii$Proxy that = (ExpressGatewayServiceStatusProperty.Jsii$Proxy) o;

                return this.statusCode != null ? this.statusCode.equals(that.statusCode) : that.statusCode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.statusCode != null ? this.statusCode.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The entry point into an Express service.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * IngressPathSummaryProperty ingressPathSummaryProperty = IngressPathSummaryProperty.builder()
     *         .accessType("accessType")
     *         .endpoint("endpoint")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-ingresspathsummary.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-ingresspathsummary.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnExpressGatewayService.IngressPathSummaryProperty")
    @software.amazon.jsii.Jsii.Proxy(IngressPathSummaryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IngressPathSummaryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of access to the endpoint for the Express service.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-ingresspathsummary.html#cfn-ecs-expressgatewayservice-ingresspathsummary-accesstype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-ingresspathsummary.html#cfn-ecs-expressgatewayservice-ingresspathsummary-accesstype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccessType() {
            return null;
        }

        /**
         * The endpoint for access to the service.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-ingresspathsummary.html#cfn-ecs-expressgatewayservice-ingresspathsummary-endpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-ingresspathsummary.html#cfn-ecs-expressgatewayservice-ingresspathsummary-endpoint</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEndpoint() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IngressPathSummaryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IngressPathSummaryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IngressPathSummaryProperty> {
            java.lang.String accessType;
            java.lang.String endpoint;

            /**
             * Sets the value of {@link IngressPathSummaryProperty#getAccessType}
             * @param accessType The type of access to the endpoint for the Express service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessType(java.lang.String accessType) {
                this.accessType = accessType;
                return this;
            }

            /**
             * Sets the value of {@link IngressPathSummaryProperty#getEndpoint}
             * @param endpoint The endpoint for access to the service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endpoint(java.lang.String endpoint) {
                this.endpoint = endpoint;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IngressPathSummaryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IngressPathSummaryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IngressPathSummaryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IngressPathSummaryProperty {
            private final java.lang.String accessType;
            private final java.lang.String endpoint;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accessType = software.amazon.jsii.Kernel.get(this, "accessType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.endpoint = software.amazon.jsii.Kernel.get(this, "endpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accessType = builder.accessType;
                this.endpoint = builder.endpoint;
            }

            @Override
            public final java.lang.String getAccessType() {
                return this.accessType;
            }

            @Override
            public final java.lang.String getEndpoint() {
                return this.endpoint;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAccessType() != null) {
                    data.set("accessType", om.valueToTree(this.getAccessType()));
                }
                if (this.getEndpoint() != null) {
                    data.set("endpoint", om.valueToTree(this.getEndpoint()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnExpressGatewayService.IngressPathSummaryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IngressPathSummaryProperty.Jsii$Proxy that = (IngressPathSummaryProperty.Jsii$Proxy) o;

                if (this.accessType != null ? !this.accessType.equals(that.accessType) : that.accessType != null) return false;
                return this.endpoint != null ? this.endpoint.equals(that.endpoint) : that.endpoint == null;
            }

            @Override
            public final int hashCode() {
                int result = this.accessType != null ? this.accessType.hashCode() : 0;
                result = 31 * result + (this.endpoint != null ? this.endpoint.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A key-value pair object.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * KeyValuePairProperty keyValuePairProperty = KeyValuePairProperty.builder()
     *         .name("name")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-keyvaluepair.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-keyvaluepair.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnExpressGatewayService.KeyValuePairProperty")
    @software.amazon.jsii.Jsii.Proxy(KeyValuePairProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KeyValuePairProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the key-value pair.
         * <p>
         * For environment variables, this is the name of the environment variable.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-keyvaluepair.html#cfn-ecs-expressgatewayservice-keyvaluepair-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-keyvaluepair.html#cfn-ecs-expressgatewayservice-keyvaluepair-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The value of the key-value pair.
         * <p>
         * For environment variables, this is the value of the environment variable.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-keyvaluepair.html#cfn-ecs-expressgatewayservice-keyvaluepair-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-keyvaluepair.html#cfn-ecs-expressgatewayservice-keyvaluepair-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link KeyValuePairProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KeyValuePairProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KeyValuePairProperty> {
            java.lang.String name;
            java.lang.String value;

            /**
             * Sets the value of {@link KeyValuePairProperty#getName}
             * @param name The name of the key-value pair. This parameter is required.
             *             For environment variables, this is the name of the environment variable.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link KeyValuePairProperty#getValue}
             * @param value The value of the key-value pair. This parameter is required.
             *              For environment variables, this is the value of the environment variable.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KeyValuePairProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KeyValuePairProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KeyValuePairProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KeyValuePairProperty {
            private final java.lang.String name;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnExpressGatewayService.KeyValuePairProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KeyValuePairProperty.Jsii$Proxy that = (KeyValuePairProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * An object representing the secret to expose to your container.
     * <p>
     * Secrets can be exposed to a container in the following ways:
     * <p>
     * <ul>
     * <li>To inject sensitive data into your containers as environment variables, use the <code>secrets</code> container definition parameter.</li>
     * <li>To reference sensitive information in the log configuration of a container, use the <code>secretOptions</code> container definition parameter.</li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html">Specifying sensitive data</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * SecretProperty secretProperty = SecretProperty.builder()
     *         .name("name")
     *         .valueFrom("valueFrom")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-secret.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-secret.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnExpressGatewayService.SecretProperty")
    @software.amazon.jsii.Jsii.Proxy(SecretProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SecretProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the secret.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-secret.html#cfn-ecs-expressgatewayservice-secret-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-secret.html#cfn-ecs-expressgatewayservice-secret-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The secret to expose to the container.
         * <p>
         * The supported values are either the full ARN of the AWS Secrets Manager secret or the full ARN of the parameter in the SSM Parameter Store.
         * <p>
         * For information about the require AWS Identity and Access Management permissions, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data-secrets.html#secrets-iam">Required IAM permissions for Amazon ECS secrets</a> (for Secrets Manager) or <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data-parameters.html">Required IAM permissions for Amazon ECS secrets</a> (for Systems Manager Parameter store) in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * If the SSM Parameter Store parameter exists in the same Region as the task you're launching, then you can use either the full ARN or name of the parameter. If the parameter exists in a different Region, then the full ARN must be specified.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-secret.html#cfn-ecs-expressgatewayservice-secret-valuefrom">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-expressgatewayservice-secret.html#cfn-ecs-expressgatewayservice-secret-valuefrom</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValueFrom();

        /**
         * @return a {@link Builder} of {@link SecretProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SecretProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SecretProperty> {
            java.lang.String name;
            java.lang.String valueFrom;

            /**
             * Sets the value of {@link SecretProperty#getName}
             * @param name The name of the secret. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link SecretProperty#getValueFrom}
             * @param valueFrom The secret to expose to the container. This parameter is required.
             *                  The supported values are either the full ARN of the AWS Secrets Manager secret or the full ARN of the parameter in the SSM Parameter Store.
             *                  <p>
             *                  For information about the require AWS Identity and Access Management permissions, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data-secrets.html#secrets-iam">Required IAM permissions for Amazon ECS secrets</a> (for Secrets Manager) or <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data-parameters.html">Required IAM permissions for Amazon ECS secrets</a> (for Systems Manager Parameter store) in the <em>Amazon Elastic Container Service Developer Guide</em> .
             *                  <p>
             *                  <blockquote>
             *                  <p>
             *                  If the SSM Parameter Store parameter exists in the same Region as the task you're launching, then you can use either the full ARN or name of the parameter. If the parameter exists in a different Region, then the full ARN must be specified.
             *                  <p>
             *                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder valueFrom(java.lang.String valueFrom) {
                this.valueFrom = valueFrom;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SecretProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SecretProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SecretProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SecretProperty {
            private final java.lang.String name;
            private final java.lang.String valueFrom;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.valueFrom = software.amazon.jsii.Kernel.get(this, "valueFrom", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.valueFrom = java.util.Objects.requireNonNull(builder.valueFrom, "valueFrom is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValueFrom() {
                return this.valueFrom;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("valueFrom", om.valueToTree(this.getValueFrom()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnExpressGatewayService.SecretProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SecretProperty.Jsii$Proxy that = (SecretProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.valueFrom.equals(that.valueFrom);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.valueFrom.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ecs.CfnExpressGatewayService}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecs.CfnExpressGatewayService> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ecs.CfnExpressGatewayServiceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ecs.CfnExpressGatewayServiceProps.Builder();
        }

        /**
         * The ARN of the task execution role for the service revision.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-expressgatewayservice.html#cfn-ecs-expressgatewayservice-executionrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-expressgatewayservice.html#cfn-ecs-expressgatewayservice-executionrolearn</a>
         * @param executionRoleArn The ARN of the task execution role for the service revision. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRoleArn(final java.lang.String executionRoleArn) {
            this.props.executionRoleArn(executionRoleArn);
            return this;
        }

        /**
         * The ARN of the infrastructure role that manages AWS resources for the Express service.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-expressgatewayservice.html#cfn-ecs-expressgatewayservice-infrastructurerolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-expressgatewayservice.html#cfn-ecs-expressgatewayservice-infrastructurerolearn</a>
         * @param infrastructureRoleArn The ARN of the infrastructure role that manages AWS resources for the Express service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder infrastructureRoleArn(final java.lang.String infrastructureRoleArn) {
            this.props.infrastructureRoleArn(infrastructureRoleArn);
            return this;
        }

        /**
         * The primary container configuration for this service revision.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-expressgatewayservice.html#cfn-ecs-expressgatewayservice-primarycontainer">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-expressgatewayservice.html#cfn-ecs-expressgatewayservice-primarycontainer</a>
         * @param primaryContainer The primary container configuration for this service revision. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder primaryContainer(final software.amazon.awscdk.IResolvable primaryContainer) {
            this.props.primaryContainer(primaryContainer);
            return this;
        }
        /**
         * The primary container configuration for this service revision.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-expressgatewayservice.html#cfn-ecs-expressgatewayservice-primarycontainer">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-expressgatewayservice.html#cfn-ecs-expressgatewayservice-primarycontainer</a>
         * @param primaryContainer The primary container configuration for this service revision. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder primaryContainer(final software.amazon.awscdk.services.ecs.CfnExpressGatewayService.ExpressGatewayContainerProperty primaryContainer) {
            this.props.primaryContainer(primaryContainer);
            return this;
        }

        /**
         * The short name or full ARN of the cluster that hosts the Express service.
         * <p>
         * Default: - "default"
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-expressgatewayservice.html#cfn-ecs-expressgatewayservice-cluster">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-expressgatewayservice.html#cfn-ecs-expressgatewayservice-cluster</a>
         * @param cluster The short name or full ARN of the cluster that hosts the Express service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(final java.lang.String cluster) {
            this.props.cluster(cluster);
            return this;
        }

        /**
         * The CPU allocation for tasks in this service revision.
         * <p>
         * Default: - "256"
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-expressgatewayservice.html#cfn-ecs-expressgatewayservice-cpu">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-expressgatewayservice.html#cfn-ecs-expressgatewayservice-cpu</a>
         * @param cpu The CPU allocation for tasks in this service revision. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpu(final java.lang.String cpu) {
            this.props.cpu(cpu);
            return this;
        }

        /**
         * The health check path for this service revision.
         * <p>
         * Default: - "HTTP:80/ping"
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-expressgatewayservice.html#cfn-ecs-expressgatewayservice-healthcheckpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-expressgatewayservice.html#cfn-ecs-expressgatewayservice-healthcheckpath</a>
         * @param healthCheckPath The health check path for this service revision. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckPath(final java.lang.String healthCheckPath) {
            this.props.healthCheckPath(healthCheckPath);
            return this;
        }

        /**
         * The memory allocation for tasks in this service revision.
         * <p>
         * Default: - "512"
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-expressgatewayservice.html#cfn-ecs-expressgatewayservice-memory">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-expressgatewayservice.html#cfn-ecs-expressgatewayservice-memory</a>
         * @param memory The memory allocation for tasks in this service revision. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memory(final java.lang.String memory) {
            this.props.memory(memory);
            return this;
        }

        /**
         * The network configuration for tasks in this service revision.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-expressgatewayservice.html#cfn-ecs-expressgatewayservice-networkconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-expressgatewayservice.html#cfn-ecs-expressgatewayservice-networkconfiguration</a>
         * @param networkConfiguration The network configuration for tasks in this service revision. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfiguration(final software.amazon.awscdk.IResolvable networkConfiguration) {
            this.props.networkConfiguration(networkConfiguration);
            return this;
        }
        /**
         * The network configuration for tasks in this service revision.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-expressgatewayservice.html#cfn-ecs-expressgatewayservice-networkconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-expressgatewayservice.html#cfn-ecs-expressgatewayservice-networkconfiguration</a>
         * @param networkConfiguration The network configuration for tasks in this service revision. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfiguration(final software.amazon.awscdk.services.ecs.CfnExpressGatewayService.ExpressGatewayServiceNetworkConfigurationProperty networkConfiguration) {
            this.props.networkConfiguration(networkConfiguration);
            return this;
        }

        /**
         * The auto-scaling configuration for this service revision.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-expressgatewayservice.html#cfn-ecs-expressgatewayservice-scalingtarget">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-expressgatewayservice.html#cfn-ecs-expressgatewayservice-scalingtarget</a>
         * @param scalingTarget The auto-scaling configuration for this service revision. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingTarget(final software.amazon.awscdk.IResolvable scalingTarget) {
            this.props.scalingTarget(scalingTarget);
            return this;
        }
        /**
         * The auto-scaling configuration for this service revision.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-expressgatewayservice.html#cfn-ecs-expressgatewayservice-scalingtarget">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-expressgatewayservice.html#cfn-ecs-expressgatewayservice-scalingtarget</a>
         * @param scalingTarget The auto-scaling configuration for this service revision. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingTarget(final software.amazon.awscdk.services.ecs.CfnExpressGatewayService.ExpressGatewayScalingTargetProperty scalingTarget) {
            this.props.scalingTarget(scalingTarget);
            return this;
        }

        /**
         * The name of the Express service.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-expressgatewayservice.html#cfn-ecs-expressgatewayservice-servicename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-expressgatewayservice.html#cfn-ecs-expressgatewayservice-servicename</a>
         * @param serviceName The name of the Express service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceName(final java.lang.String serviceName) {
            this.props.serviceName(serviceName);
            return this;
        }

        /**
         * The metadata applied to the Express service.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-expressgatewayservice.html#cfn-ecs-expressgatewayservice-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-expressgatewayservice.html#cfn-ecs-expressgatewayservice-tags</a>
         * @param tags The metadata applied to the Express service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The ARN of the task role for the service revision.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-expressgatewayservice.html#cfn-ecs-expressgatewayservice-taskrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-expressgatewayservice.html#cfn-ecs-expressgatewayservice-taskrolearn</a>
         * @param taskRoleArn The ARN of the task role for the service revision. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskRoleArn(final java.lang.String taskRoleArn) {
            this.props.taskRoleArn(taskRoleArn);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ecs.CfnExpressGatewayService}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ecs.CfnExpressGatewayService build() {
            return new software.amazon.awscdk.services.ecs.CfnExpressGatewayService(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
