package software.amazon.awscdk.services.ecs;

/**
 * An image from an Amazon ECR repository.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecr.assets.*;
 * import software.amazon.awscdk.services.ecs.*;
 * DockerImageAsset dockerImageAsset;
 * ContainerImage ecrImage = EcrImage.fromDockerImageAsset(dockerImageAsset);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:20.029Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.EcrImage")
public class EcrImage extends software.amazon.awscdk.services.ecs.ContainerImage {

    protected EcrImage(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EcrImage(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Constructs a new instance of the EcrImage class.
     * <p>
     * @param repository This parameter is required.
     * @param tagOrDigest This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public EcrImage(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.IRepository repository, final @org.jetbrains.annotations.NotNull java.lang.String tagOrDigest) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(repository, "repository is required"), java.util.Objects.requireNonNull(tagOrDigest, "tagOrDigest is required") });
    }

    /**
     * Called when the image is used by a ContainerDefinition.
     * <p>
     * @param _scope This parameter is required.
     * @param containerDefinition This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerImageConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct _scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerDefinition containerDefinition) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ContainerImageConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required"), java.util.Objects.requireNonNull(containerDefinition, "containerDefinition is required") });
    }

    /**
     * The image name. Images in Amazon ECR repositories can be specified by either using the full registry/repository:tag or registry/repository&#64;digest.
     * <p>
     * For example, 012345678910.dkr.ecr.<region-name>.amazonaws.com/<repository-name>:latest or
     * 012345678910.dkr.ecr.<region-name>.amazonaws.com/<repository-name>&#64;sha256:94afd1f2e64d908bc90dbca0035a5b567EXAMPLE.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getImageName() {
        return software.amazon.jsii.Kernel.get(this, "imageName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
