package software.amazon.awscdk.services.ecs;

/**
 * Firelens Configuration https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html#firelens-taskdef.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecs.*;
 * FirelensConfig firelensConfig = FirelensConfig.builder()
 *         .type(FirelensLogRouterType.FLUENTBIT)
 *         // the properties below are optional
 *         .options(FirelensOptions.builder()
 *                 .configFileType(FirelensConfigFileType.S3)
 *                 .configFileValue("configFileValue")
 *                 .enableECSLogMetadata(false)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:20.050Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.FirelensConfig")
@software.amazon.jsii.Jsii.Proxy(FirelensConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FirelensConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The log router to use.
     * <p>
     * Default: - fluentbit
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.FirelensLogRouterType getType();

    /**
     * Firelens options.
     * <p>
     * Default: - no additional options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.FirelensOptions getOptions() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link FirelensConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FirelensConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FirelensConfig> {
        software.amazon.awscdk.services.ecs.FirelensLogRouterType type;
        software.amazon.awscdk.services.ecs.FirelensOptions options;

        /**
         * Sets the value of {@link FirelensConfig#getType}
         * @param type The log router to use. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(software.amazon.awscdk.services.ecs.FirelensLogRouterType type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link FirelensConfig#getOptions}
         * @param options Firelens options.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder options(software.amazon.awscdk.services.ecs.FirelensOptions options) {
            this.options = options;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FirelensConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FirelensConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FirelensConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FirelensConfig {
        private final software.amazon.awscdk.services.ecs.FirelensLogRouterType type;
        private final software.amazon.awscdk.services.ecs.FirelensOptions options;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.FirelensLogRouterType.class));
            this.options = software.amazon.jsii.Kernel.get(this, "options", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.FirelensOptions.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.options = builder.options;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.FirelensLogRouterType getType() {
            return this.type;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.FirelensOptions getOptions() {
            return this.options;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("type", om.valueToTree(this.getType()));
            if (this.getOptions() != null) {
                data.set("options", om.valueToTree(this.getOptions()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.FirelensConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FirelensConfig.Jsii$Proxy that = (FirelensConfig.Jsii$Proxy) o;

            if (!type.equals(that.type)) return false;
            return this.options != null ? this.options.equals(that.options) : that.options == null;
        }

        @Override
        public final int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
            return result;
        }
    }
}
