package software.amazon.awscdk.services.ecs;

/**
 * Firelens log router.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.ecs.*;
 * AppProtocol appProtocol;
 * ContainerImage containerImage;
 * CredentialSpec credentialSpec;
 * EnvironmentFile environmentFile;
 * LinuxParameters linuxParameters;
 * LogDriver logDriver;
 * Secret secret;
 * TaskDefinition taskDefinition;
 * FirelensLogRouter firelensLogRouter = FirelensLogRouter.Builder.create(this, "MyFirelensLogRouter")
 *         .firelensConfig(FirelensConfig.builder()
 *                 .type(FirelensLogRouterType.FLUENTBIT)
 *                 // the properties below are optional
 *                 .options(FirelensOptions.builder()
 *                         .configFileType(FirelensConfigFileType.S3)
 *                         .configFileValue("configFileValue")
 *                         .enableECSLogMetadata(false)
 *                         .build())
 *                 .build())
 *         .image(containerImage)
 *         .taskDefinition(taskDefinition)
 *         // the properties below are optional
 *         .command(List.of("command"))
 *         .containerName("containerName")
 *         .cpu(123)
 *         .credentialSpecs(List.of(credentialSpec))
 *         .disableNetworking(false)
 *         .dnsSearchDomains(List.of("dnsSearchDomains"))
 *         .dnsServers(List.of("dnsServers"))
 *         .dockerLabels(Map.of(
 *                 "dockerLabelsKey", "dockerLabels"))
 *         .dockerSecurityOptions(List.of("dockerSecurityOptions"))
 *         .enableRestartPolicy(false)
 *         .entryPoint(List.of("entryPoint"))
 *         .environment(Map.of(
 *                 "environmentKey", "environment"))
 *         .environmentFiles(List.of(environmentFile))
 *         .essential(false)
 *         .extraHosts(Map.of(
 *                 "extraHostsKey", "extraHosts"))
 *         .gpuCount(123)
 *         .healthCheck(HealthCheck.builder()
 *                 .command(List.of("command"))
 *                 // the properties below are optional
 *                 .interval(Duration.minutes(30))
 *                 .retries(123)
 *                 .startPeriod(Duration.minutes(30))
 *                 .timeout(Duration.minutes(30))
 *                 .build())
 *         .hostname("hostname")
 *         .inferenceAcceleratorResources(List.of("inferenceAcceleratorResources"))
 *         .interactive(false)
 *         .linuxParameters(linuxParameters)
 *         .logging(logDriver)
 *         .memoryLimitMiB(123)
 *         .memoryReservationMiB(123)
 *         .portMappings(List.of(PortMapping.builder()
 *                 .containerPort(123)
 *                 // the properties below are optional
 *                 .appProtocol(appProtocol)
 *                 .containerPortRange("containerPortRange")
 *                 .hostPort(123)
 *                 .name("name")
 *                 .protocol(Protocol.TCP)
 *                 .build()))
 *         .privileged(false)
 *         .pseudoTerminal(false)
 *         .readonlyRootFilesystem(false)
 *         .restartAttemptPeriod(Duration.minutes(30))
 *         .restartIgnoredExitCodes(List.of(123))
 *         .secrets(Map.of(
 *                 "secretsKey", secret))
 *         .startTimeout(Duration.minutes(30))
 *         .stopTimeout(Duration.minutes(30))
 *         .systemControls(List.of(SystemControl.builder()
 *                 .namespace("namespace")
 *                 .value("value")
 *                 .build()))
 *         .ulimits(List.of(Ulimit.builder()
 *                 .hardLimit(123)
 *                 .name(UlimitName.CORE)
 *                 .softLimit(123)
 *                 .build()))
 *         .user("user")
 *         .versionConsistency(VersionConsistency.ENABLED)
 *         .workingDirectory("workingDirectory")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:20.050Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.FirelensLogRouter")
public class FirelensLogRouter extends software.amazon.awscdk.services.ecs.ContainerDefinition {

    protected FirelensLogRouter(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FirelensLogRouter(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ecs.FirelensLogRouter.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Constructs a new instance of the FirelensLogRouter class.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public FirelensLogRouter(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.FirelensLogRouterProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Render this container definition to a CloudFormation object.
     * <p>
     * @param _taskDefinition
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.CfnTaskDefinition.ContainerDefinitionProperty renderContainerDefinition(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.TaskDefinition _taskDefinition) {
        return software.amazon.jsii.Kernel.call(this, "renderContainerDefinition", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.CfnTaskDefinition.ContainerDefinitionProperty.class), new Object[] { _taskDefinition });
    }

    /**
     * Render this container definition to a CloudFormation object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.CfnTaskDefinition.ContainerDefinitionProperty renderContainerDefinition() {
        return software.amazon.jsii.Kernel.call(this, "renderContainerDefinition", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.CfnTaskDefinition.ContainerDefinitionProperty.class));
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * Firelens configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.FirelensConfig getFirelensConfig() {
        return software.amazon.jsii.Kernel.get(this, "firelensConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.FirelensConfig.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ecs.FirelensLogRouter}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecs.FirelensLogRouter> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ecs.FirelensLogRouterProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ecs.FirelensLogRouterProps.Builder();
        }

        /**
         * The image used to start a container.
         * <p>
         * This string is passed directly to the Docker daemon.
         * Images in the Docker Hub registry are available by default.
         * Other repositories are specified with either repository-url/image:tag or repository-url/image&#64;digest.
         * TODO: Update these to specify using classes of IContainerImage
         * <p>
         * @return {@code this}
         * @param image The image used to start a container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder image(final software.amazon.awscdk.services.ecs.ContainerImage image) {
            this.props.image(image);
            return this;
        }

        /**
         * The command that is passed to the container.
         * <p>
         * If you provide a shell command as a single string, you have to quote command-line arguments.
         * <p>
         * Default: - CMD value built into container image.
         * <p>
         * @return {@code this}
         * @param command The command that is passed to the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder command(final java.util.List<java.lang.String> command) {
            this.props.command(command);
            return this;
        }

        /**
         * The name of the container.
         * <p>
         * Default: - id of node associated with ContainerDefinition.
         * <p>
         * @return {@code this}
         * @param containerName The name of the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerName(final java.lang.String containerName) {
            this.props.containerName(containerName);
            return this;
        }

        /**
         * The minimum number of CPU units to reserve for the container.
         * <p>
         * Default: - No minimum CPU units reserved.
         * <p>
         * @return {@code this}
         * @param cpu The minimum number of CPU units to reserve for the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpu(final java.lang.Number cpu) {
            this.props.cpu(cpu);
            return this;
        }

        /**
         * A list of ARNs in SSM or Amazon S3 to a credential spec (<code>CredSpec</code>) file that configures the container for Active Directory authentication.
         * <p>
         * We recommend that you use this parameter instead of the <code>dockerSecurityOptions</code>.
         * <p>
         * Currently, only one credential spec is allowed per container definition.
         * <p>
         * Default: - No credential specs.
         * <p>
         * @return {@code this}
         * @param credentialSpecs A list of ARNs in SSM or Amazon S3 to a credential spec (<code>CredSpec</code>) file that configures the container for Active Directory authentication. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentialSpecs(final java.util.List<? extends software.amazon.awscdk.services.ecs.CredentialSpec> credentialSpecs) {
            this.props.credentialSpecs(credentialSpecs);
            return this;
        }

        /**
         * Specifies whether networking is disabled within the container.
         * <p>
         * When this parameter is true, networking is disabled within the container.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param disableNetworking Specifies whether networking is disabled within the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableNetworking(final java.lang.Boolean disableNetworking) {
            this.props.disableNetworking(disableNetworking);
            return this;
        }

        /**
         * A list of DNS search domains that are presented to the container.
         * <p>
         * Default: - No search domains.
         * <p>
         * @return {@code this}
         * @param dnsSearchDomains A list of DNS search domains that are presented to the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dnsSearchDomains(final java.util.List<java.lang.String> dnsSearchDomains) {
            this.props.dnsSearchDomains(dnsSearchDomains);
            return this;
        }

        /**
         * A list of DNS servers that are presented to the container.
         * <p>
         * Default: - Default DNS servers.
         * <p>
         * @return {@code this}
         * @param dnsServers A list of DNS servers that are presented to the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dnsServers(final java.util.List<java.lang.String> dnsServers) {
            this.props.dnsServers(dnsServers);
            return this;
        }

        /**
         * A key/value map of labels to add to the container.
         * <p>
         * Default: - No labels.
         * <p>
         * @return {@code this}
         * @param dockerLabels A key/value map of labels to add to the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dockerLabels(final java.util.Map<java.lang.String, java.lang.String> dockerLabels) {
            this.props.dockerLabels(dockerLabels);
            return this;
        }

        /**
         * A list of strings to provide custom labels for SELinux and AppArmor multi-level security systems.
         * <p>
         * Default: - No security labels.
         * <p>
         * @return {@code this}
         * @param dockerSecurityOptions A list of strings to provide custom labels for SELinux and AppArmor multi-level security systems. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dockerSecurityOptions(final java.util.List<java.lang.String> dockerSecurityOptions) {
            this.props.dockerSecurityOptions(dockerSecurityOptions);
            return this;
        }

        /**
         * Enable a restart policy for a container.
         * <p>
         * When you set up a restart policy, Amazon ECS can restart the container without needing to replace the task.
         * <p>
         * Default: - false unless `restartIgnoredExitCodes` or `restartAttemptPeriod` is set.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/container-restart-policy.html">https://docs.aws.amazon.com/AmazonECS/latest/developerguide/container-restart-policy.html</a>
         * @param enableRestartPolicy Enable a restart policy for a container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableRestartPolicy(final java.lang.Boolean enableRestartPolicy) {
            this.props.enableRestartPolicy(enableRestartPolicy);
            return this;
        }

        /**
         * The ENTRYPOINT value to pass to the container.
         * <p>
         * Default: - Entry point configured in container.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.docker.com/engine/reference/builder/#entrypoint">https://docs.docker.com/engine/reference/builder/#entrypoint</a>
         * @param entryPoint The ENTRYPOINT value to pass to the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder entryPoint(final java.util.List<java.lang.String> entryPoint) {
            this.props.entryPoint(entryPoint);
            return this;
        }

        /**
         * The environment variables to pass to the container.
         * <p>
         * Default: - No environment variables.
         * <p>
         * @return {@code this}
         * @param environment The environment variables to pass to the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(final java.util.Map<java.lang.String, java.lang.String> environment) {
            this.props.environment(environment);
            return this;
        }

        /**
         * The environment files to pass to the container.
         * <p>
         * Default: - No environment files.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/taskdef-envfiles.html">https://docs.aws.amazon.com/AmazonECS/latest/developerguide/taskdef-envfiles.html</a>
         * @param environmentFiles The environment files to pass to the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentFiles(final java.util.List<? extends software.amazon.awscdk.services.ecs.EnvironmentFile> environmentFiles) {
            this.props.environmentFiles(environmentFiles);
            return this;
        }

        /**
         * Specifies whether the container is marked essential.
         * <p>
         * If the essential parameter of a container is marked as true, and that container fails
         * or stops for any reason, all other containers that are part of the task are stopped.
         * If the essential parameter of a container is marked as false, then its failure does not
         * affect the rest of the containers in a task. All tasks must have at least one essential container.
         * <p>
         * If this parameter is omitted, a container is assumed to be essential.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param essential Specifies whether the container is marked essential. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder essential(final java.lang.Boolean essential) {
            this.props.essential(essential);
            return this;
        }

        /**
         * A list of hostnames and IP address mappings to append to the /etc/hosts file on the container.
         * <p>
         * Default: - No extra hosts.
         * <p>
         * @return {@code this}
         * @param extraHosts A list of hostnames and IP address mappings to append to the /etc/hosts file on the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder extraHosts(final java.util.Map<java.lang.String, java.lang.String> extraHosts) {
            this.props.extraHosts(extraHosts);
            return this;
        }

        /**
         * The number of GPUs assigned to the container.
         * <p>
         * Default: - No GPUs assigned.
         * <p>
         * @return {@code this}
         * @param gpuCount The number of GPUs assigned to the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gpuCount(final java.lang.Number gpuCount) {
            this.props.gpuCount(gpuCount);
            return this;
        }

        /**
         * The health check command and associated configuration parameters for the container.
         * <p>
         * Default: - Health check configuration from container.
         * <p>
         * @return {@code this}
         * @param healthCheck The health check command and associated configuration parameters for the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheck(final software.amazon.awscdk.services.ecs.HealthCheck healthCheck) {
            this.props.healthCheck(healthCheck);
            return this;
        }

        /**
         * The hostname to use for your container.
         * <p>
         * Default: - Automatic hostname.
         * <p>
         * @return {@code this}
         * @param hostname The hostname to use for your container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostname(final java.lang.String hostname) {
            this.props.hostname(hostname);
            return this;
        }

        /**
         * The inference accelerators referenced by the container.
         * <p>
         * Default: - No inference accelerators assigned.
         * <p>
         * @return {@code this}
         * @param inferenceAcceleratorResources The inference accelerators referenced by the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inferenceAcceleratorResources(final java.util.List<java.lang.String> inferenceAcceleratorResources) {
            this.props.inferenceAcceleratorResources(inferenceAcceleratorResources);
            return this;
        }

        /**
         * When this parameter is true, you can deploy containerized applications that require stdin or a tty to be allocated.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-interactive">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-interactive</a>
         * @param interactive When this parameter is true, you can deploy containerized applications that require stdin or a tty to be allocated. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder interactive(final java.lang.Boolean interactive) {
            this.props.interactive(interactive);
            return this;
        }

        /**
         * Linux-specific modifications that are applied to the container, such as Linux kernel capabilities.
         * <p>
         * For more information see <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_KernelCapabilities.html">KernelCapabilities</a>.
         * <p>
         * Default: - No Linux parameters.
         * <p>
         * @return {@code this}
         * @param linuxParameters Linux-specific modifications that are applied to the container, such as Linux kernel capabilities. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder linuxParameters(final software.amazon.awscdk.services.ecs.LinuxParameters linuxParameters) {
            this.props.linuxParameters(linuxParameters);
            return this;
        }

        /**
         * The log configuration specification for the container.
         * <p>
         * Default: - Containers use the same logging driver that the Docker daemon uses.
         * <p>
         * @return {@code this}
         * @param logging The log configuration specification for the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logging(final software.amazon.awscdk.services.ecs.LogDriver logging) {
            this.props.logging(logging);
            return this;
        }

        /**
         * The amount (in MiB) of memory to present to the container.
         * <p>
         * If your container attempts to exceed the allocated memory, the container
         * is terminated.
         * <p>
         * At least one of memoryLimitMiB and memoryReservationMiB is required for non-Fargate services.
         * <p>
         * Default: - No memory limit.
         * <p>
         * @return {@code this}
         * @param memoryLimitMiB The amount (in MiB) of memory to present to the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memoryLimitMiB(final java.lang.Number memoryLimitMiB) {
            this.props.memoryLimitMiB(memoryLimitMiB);
            return this;
        }

        /**
         * The soft limit (in MiB) of memory to reserve for the container.
         * <p>
         * When system memory is under heavy contention, Docker attempts to keep the
         * container memory to this soft limit. However, your container can consume more
         * memory when it needs to, up to either the hard limit specified with the memory
         * parameter (if applicable), or all of the available memory on the container
         * instance, whichever comes first.
         * <p>
         * At least one of memoryLimitMiB and memoryReservationMiB is required for non-Fargate services.
         * <p>
         * Default: - No memory reserved.
         * <p>
         * @return {@code this}
         * @param memoryReservationMiB The soft limit (in MiB) of memory to reserve for the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memoryReservationMiB(final java.lang.Number memoryReservationMiB) {
            this.props.memoryReservationMiB(memoryReservationMiB);
            return this;
        }

        /**
         * The port mappings to add to the container definition.
         * <p>
         * Default: - No ports are mapped.
         * <p>
         * @return {@code this}
         * @param portMappings The port mappings to add to the container definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder portMappings(final java.util.List<? extends software.amazon.awscdk.services.ecs.PortMapping> portMappings) {
            this.props.portMappings(portMappings);
            return this;
        }

        /**
         * Specifies whether the container is marked as privileged.
         * <p>
         * When this parameter is true, the container is given elevated privileges on the host container instance (similar to the root user).
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param privileged Specifies whether the container is marked as privileged. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privileged(final java.lang.Boolean privileged) {
            this.props.privileged(privileged);
            return this;
        }

        /**
         * When this parameter is true, a TTY is allocated.
         * <p>
         * This parameter maps to Tty in the "Create a container section" of the
         * Docker Remote API and the --tty option to <code>docker run</code>.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#container_definition_pseudoterminal">https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#container_definition_pseudoterminal</a>
         * @param pseudoTerminal When this parameter is true, a TTY is allocated. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pseudoTerminal(final java.lang.Boolean pseudoTerminal) {
            this.props.pseudoTerminal(pseudoTerminal);
            return this;
        }

        /**
         * When this parameter is true, the container is given read-only access to its root file system.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param readonlyRootFilesystem When this parameter is true, the container is given read-only access to its root file system. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readonlyRootFilesystem(final java.lang.Boolean readonlyRootFilesystem) {
            this.props.readonlyRootFilesystem(readonlyRootFilesystem);
            return this;
        }

        /**
         * A period of time that the container must run for before a restart can be attempted.
         * <p>
         * A container can be restarted only once every <code>restartAttemptPeriod</code> seconds.
         * If a container isn't able to run for this time period and exits early, it will not be restarted.
         * <p>
         * This property can't be used if <code>enableRestartPolicy</code> is set to false.
         * <p>
         * You can set a minimum <code>restartAttemptPeriod</code> of 60 seconds and a maximum <code>restartAttemptPeriod</code>
         * of 1800 seconds.
         * <p>
         * Default: - Duration.seconds(300) if `enableRestartPolicy` is true, otherwise no period.
         * <p>
         * @return {@code this}
         * @param restartAttemptPeriod A period of time that the container must run for before a restart can be attempted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restartAttemptPeriod(final software.amazon.awscdk.Duration restartAttemptPeriod) {
            this.props.restartAttemptPeriod(restartAttemptPeriod);
            return this;
        }

        /**
         * A list of exit codes that Amazon ECS will ignore and not attempt a restart on.
         * <p>
         * This property can't be used if <code>enableRestartPolicy</code> is set to false.
         * <p>
         * You can specify a maximum of 50 container exit codes.
         * <p>
         * Default: - No exit codes are ignored.
         * <p>
         * @return {@code this}
         * @param restartIgnoredExitCodes A list of exit codes that Amazon ECS will ignore and not attempt a restart on. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restartIgnoredExitCodes(final java.util.List<? extends java.lang.Number> restartIgnoredExitCodes) {
            this.props.restartIgnoredExitCodes(restartIgnoredExitCodes);
            return this;
        }

        /**
         * The secret environment variables to pass to the container.
         * <p>
         * Default: - No secret environment variables.
         * <p>
         * @return {@code this}
         * @param secrets The secret environment variables to pass to the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secrets(final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.ecs.Secret> secrets) {
            this.props.secrets(secrets);
            return this;
        }

        /**
         * Time duration (in seconds) to wait before giving up on resolving dependencies for a container.
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @param startTimeout Time duration (in seconds) to wait before giving up on resolving dependencies for a container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startTimeout(final software.amazon.awscdk.Duration startTimeout) {
            this.props.startTimeout(startTimeout);
            return this;
        }

        /**
         * Time duration (in seconds) to wait before the container is forcefully killed if it doesn't exit normally on its own.
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @param stopTimeout Time duration (in seconds) to wait before the container is forcefully killed if it doesn't exit normally on its own. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stopTimeout(final software.amazon.awscdk.Duration stopTimeout) {
            this.props.stopTimeout(stopTimeout);
            return this;
        }

        /**
         * A list of namespaced kernel parameters to set in the container.
         * <p>
         * Default: - No system controls are set.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#container_definition_systemcontrols">https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#container_definition_systemcontrols</a>
         * @param systemControls A list of namespaced kernel parameters to set in the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder systemControls(final java.util.List<? extends software.amazon.awscdk.services.ecs.SystemControl> systemControls) {
            this.props.systemControls(systemControls);
            return this;
        }

        /**
         * An array of ulimits to set in the container.
         * <p>
         * @return {@code this}
         * @param ulimits An array of ulimits to set in the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ulimits(final java.util.List<? extends software.amazon.awscdk.services.ecs.Ulimit> ulimits) {
            this.props.ulimits(ulimits);
            return this;
        }

        /**
         * The user to use inside the container.
         * <p>
         * This parameter maps to User in the Create a container section of the Docker Remote API and the --user option to docker run.
         * <p>
         * Default: root
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#ContainerDefinition-user">https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#ContainerDefinition-user</a>
         * @param user The user to use inside the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder user(final java.lang.String user) {
            this.props.user(user);
            return this;
        }

        /**
         * Specifies whether Amazon ECS will resolve the container image tag provided in the container definition to an image digest.
         * <p>
         * If you set the value for a container as disabled, Amazon ECS will
         * not resolve the provided container image tag to a digest and will use the
         * original image URI specified in the container definition for deployment.
         * <p>
         * Default: VersionConsistency.DISABLED if `image` is a CDK asset, VersionConsistency.ENABLED otherwise
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-versionconsistency">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-taskdefinition-containerdefinition.html#cfn-ecs-taskdefinition-containerdefinition-versionconsistency</a>
         * @param versionConsistency Specifies whether Amazon ECS will resolve the container image tag provided in the container definition to an image digest. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder versionConsistency(final software.amazon.awscdk.services.ecs.VersionConsistency versionConsistency) {
            this.props.versionConsistency(versionConsistency);
            return this;
        }

        /**
         * The working directory in which to run commands inside the container.
         * <p>
         * Default: /
         * <p>
         * @return {@code this}
         * @param workingDirectory The working directory in which to run commands inside the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workingDirectory(final java.lang.String workingDirectory) {
            this.props.workingDirectory(workingDirectory);
            return this;
        }

        /**
         * The name of the task definition that includes this container definition.
         * <p>
         * [disable-awslint:ref-via-interface]
         * <p>
         * @return {@code this}
         * @param taskDefinition The name of the task definition that includes this container definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskDefinition(final software.amazon.awscdk.services.ecs.TaskDefinition taskDefinition) {
            this.props.taskDefinition(taskDefinition);
            return this;
        }

        /**
         * Firelens configuration.
         * <p>
         * @return {@code this}
         * @param firelensConfig Firelens configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder firelensConfig(final software.amazon.awscdk.services.ecs.FirelensConfig firelensConfig) {
            this.props.firelensConfig(firelensConfig);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ecs.FirelensLogRouter}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ecs.FirelensLogRouter build() {
            return new software.amazon.awscdk.services.ecs.FirelensLogRouter(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
