package software.amazon.awscdk.services.ecs.patterns;

/**
 * Properties to define an application load balancer.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.certificatemanager.*;
 * import software.amazon.awscdk.services.ecs.patterns.*;
 * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
 * import software.amazon.awscdk.services.route53.*;
 * Certificate certificate;
 * HostedZone hostedZone;
 * ApplicationLoadBalancerProps applicationLoadBalancerProps = ApplicationLoadBalancerProps.builder()
 *         .listeners(List.of(ApplicationListenerProps.builder()
 *                 .name("name")
 *                 // the properties below are optional
 *                 .certificate(certificate)
 *                 .port(123)
 *                 .protocol(ApplicationProtocol.HTTP)
 *                 .sslPolicy(SslPolicy.RECOMMENDED_TLS)
 *                 .build()))
 *         .name("name")
 *         // the properties below are optional
 *         .domainName("domainName")
 *         .domainZone(hostedZone)
 *         .idleTimeout(Duration.minutes(30))
 *         .publicLoadBalancer(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:20.211Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs_patterns.ApplicationLoadBalancerProps")
@software.amazon.jsii.Jsii.Proxy(ApplicationLoadBalancerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ApplicationLoadBalancerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Listeners (at least one listener) attached to this load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ecs.patterns.ApplicationListenerProps> getListeners();

    /**
     * Name of the load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The domain name for the service, e.g. "api.example.com.".
     * <p>
     * Default: - No domain name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDomainName() {
        return null;
    }

    /**
     * The Route53 hosted zone for the domain, e.g. "example.com.".
     * <p>
     * Default: - No Route53 hosted domain zone.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.route53.IHostedZone getDomainZone() {
        return null;
    }

    /**
     * The load balancer idle timeout, in seconds.
     * <p>
     * Can be between 1 and 4000 seconds.
     * <p>
     * Default: - CloudFormation sets idle timeout to 60 seconds
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getIdleTimeout() {
        return null;
    }

    /**
     * Determines whether the Load Balancer will be internet-facing.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPublicLoadBalancer() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ApplicationLoadBalancerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ApplicationLoadBalancerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ApplicationLoadBalancerProps> {
        java.util.List<software.amazon.awscdk.services.ecs.patterns.ApplicationListenerProps> listeners;
        java.lang.String name;
        java.lang.String domainName;
        software.amazon.awscdk.services.route53.IHostedZone domainZone;
        software.amazon.awscdk.Duration idleTimeout;
        java.lang.Boolean publicLoadBalancer;

        /**
         * Sets the value of {@link ApplicationLoadBalancerProps#getListeners}
         * @param listeners Listeners (at least one listener) attached to this load balancer. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder listeners(java.util.List<? extends software.amazon.awscdk.services.ecs.patterns.ApplicationListenerProps> listeners) {
            this.listeners = (java.util.List<software.amazon.awscdk.services.ecs.patterns.ApplicationListenerProps>)listeners;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancerProps#getName}
         * @param name Name of the load balancer. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancerProps#getDomainName}
         * @param domainName The domain name for the service, e.g. "api.example.com.".
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancerProps#getDomainZone}
         * @param domainZone The Route53 hosted zone for the domain, e.g. "example.com.".
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainZone(software.amazon.awscdk.services.route53.IHostedZone domainZone) {
            this.domainZone = domainZone;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancerProps#getIdleTimeout}
         * @param idleTimeout The load balancer idle timeout, in seconds.
         *                    Can be between 1 and 4000 seconds.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder idleTimeout(software.amazon.awscdk.Duration idleTimeout) {
            this.idleTimeout = idleTimeout;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationLoadBalancerProps#getPublicLoadBalancer}
         * @param publicLoadBalancer Determines whether the Load Balancer will be internet-facing.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicLoadBalancer(java.lang.Boolean publicLoadBalancer) {
            this.publicLoadBalancer = publicLoadBalancer;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApplicationLoadBalancerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ApplicationLoadBalancerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ApplicationLoadBalancerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplicationLoadBalancerProps {
        private final java.util.List<software.amazon.awscdk.services.ecs.patterns.ApplicationListenerProps> listeners;
        private final java.lang.String name;
        private final java.lang.String domainName;
        private final software.amazon.awscdk.services.route53.IHostedZone domainZone;
        private final software.amazon.awscdk.Duration idleTimeout;
        private final java.lang.Boolean publicLoadBalancer;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.listeners = software.amazon.jsii.Kernel.get(this, "listeners", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.patterns.ApplicationListenerProps.class)));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.domainZone = software.amazon.jsii.Kernel.get(this, "domainZone", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.IHostedZone.class));
            this.idleTimeout = software.amazon.jsii.Kernel.get(this, "idleTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.publicLoadBalancer = software.amazon.jsii.Kernel.get(this, "publicLoadBalancer", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.listeners = (java.util.List<software.amazon.awscdk.services.ecs.patterns.ApplicationListenerProps>)java.util.Objects.requireNonNull(builder.listeners, "listeners is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.domainName = builder.domainName;
            this.domainZone = builder.domainZone;
            this.idleTimeout = builder.idleTimeout;
            this.publicLoadBalancer = builder.publicLoadBalancer;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ecs.patterns.ApplicationListenerProps> getListeners() {
            return this.listeners;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public final software.amazon.awscdk.services.route53.IHostedZone getDomainZone() {
            return this.domainZone;
        }

        @Override
        public final software.amazon.awscdk.Duration getIdleTimeout() {
            return this.idleTimeout;
        }

        @Override
        public final java.lang.Boolean getPublicLoadBalancer() {
            return this.publicLoadBalancer;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("listeners", om.valueToTree(this.getListeners()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getDomainName() != null) {
                data.set("domainName", om.valueToTree(this.getDomainName()));
            }
            if (this.getDomainZone() != null) {
                data.set("domainZone", om.valueToTree(this.getDomainZone()));
            }
            if (this.getIdleTimeout() != null) {
                data.set("idleTimeout", om.valueToTree(this.getIdleTimeout()));
            }
            if (this.getPublicLoadBalancer() != null) {
                data.set("publicLoadBalancer", om.valueToTree(this.getPublicLoadBalancer()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs_patterns.ApplicationLoadBalancerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ApplicationLoadBalancerProps.Jsii$Proxy that = (ApplicationLoadBalancerProps.Jsii$Proxy) o;

            if (!listeners.equals(that.listeners)) return false;
            if (!name.equals(that.name)) return false;
            if (this.domainName != null ? !this.domainName.equals(that.domainName) : that.domainName != null) return false;
            if (this.domainZone != null ? !this.domainZone.equals(that.domainZone) : that.domainZone != null) return false;
            if (this.idleTimeout != null ? !this.idleTimeout.equals(that.idleTimeout) : that.idleTimeout != null) return false;
            return this.publicLoadBalancer != null ? this.publicLoadBalancer.equals(that.publicLoadBalancer) : that.publicLoadBalancer == null;
        }

        @Override
        public final int hashCode() {
            int result = this.listeners.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.domainName != null ? this.domainName.hashCode() : 0);
            result = 31 * result + (this.domainZone != null ? this.domainZone.hashCode() : 0);
            result = 31 * result + (this.idleTimeout != null ? this.idleTimeout.hashCode() : 0);
            result = 31 * result + (this.publicLoadBalancer != null ? this.publicLoadBalancer.hashCode() : 0);
            return result;
        }
    }
}
