package software.amazon.awscdk.services.eks;

/**
 * Resource Type definition for EKS Capability.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.eks.*;
 * CfnCapability cfnCapability = CfnCapability.Builder.create(this, "MyCfnCapability")
 *         .capabilityName("capabilityName")
 *         .clusterName("clusterName")
 *         .deletePropagationPolicy("deletePropagationPolicy")
 *         .roleArn("roleArn")
 *         .type("type")
 *         // the properties below are optional
 *         .configuration(CapabilityConfigurationProperty.builder()
 *                 .argoCd(ArgoCdProperty.builder()
 *                         .awsIdc(AwsIdcProperty.builder()
 *                                 .idcInstanceArn("idcInstanceArn")
 *                                 // the properties below are optional
 *                                 .idcManagedApplicationArn("idcManagedApplicationArn")
 *                                 .idcRegion("idcRegion")
 *                                 .build())
 *                         // the properties below are optional
 *                         .namespace("namespace")
 *                         .networkAccess(NetworkAccessProperty.builder()
 *                                 .vpceIds(List.of("vpceIds"))
 *                                 .build())
 *                         .rbacRoleMappings(List.of(ArgoCdRoleMappingProperty.builder()
 *                                 .identities(List.of(SsoIdentityProperty.builder()
 *                                         .id("id")
 *                                         .type("type")
 *                                         .build()))
 *                                 .role("role")
 *                                 .build()))
 *                         .serverUrl("serverUrl")
 *                         .build())
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-capability.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-capability.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:20.399Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.CfnCapability")
public class CfnCapability extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.interfaces.eks.ICapabilityRef, software.amazon.awscdk.ITaggableV2 {

    protected CfnCapability(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCapability(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.CfnCapability.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new <code>AWS::EKS::Capability</code>.
     * <p>
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCapability(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.CfnCapabilityProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * @param resource This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String arnForCapability(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.eks.ICapabilityRef resource) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.eks.CfnCapability.class, "arnForCapability", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(resource, "resource is required") });
    }

    /**
     * Checks whether the given object is a CfnCapability.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isCfnCapability(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.eks.CfnCapability.class, "isCfnCapability", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the capability.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the managed application created in IAM Identity Center for this Argo CD capability.
     * <p>
     * This application is automatically created and managed by EKS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrConfigurationArgoCdAwsIdcIdcManagedApplicationArn() {
        return software.amazon.jsii.Kernel.get(this, "attrConfigurationArgoCdAwsIdcIdcManagedApplicationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The URL of the Argo CD server.
     * <p>
     * Use this URL to access the Argo CD web interface and API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrConfigurationArgoCdServerUrl() {
        return software.amazon.jsii.Kernel.get(this, "attrConfigurationArgoCdServerUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Unix epoch timestamp in seconds for when the capability was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Unix epoch timestamp in seconds for when the capability was last modified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrModifiedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrModifiedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The current status of the capability.
     * <p>
     * Valid values include: CREATING (the capability is being created), ACTIVE (the capability is running and available), UPDATING (the capability is being updated), DELETING (the capability is being deleted), CREATE_FAILED (the capability creation failed), UPDATE_FAILED (the capability update failed), or DELETE_FAILED (the capability deletion failed).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The version of the capability software that is currently running.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrVersion() {
        return software.amazon.jsii.Kernel.get(this, "attrVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A reference to a Capability resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.eks.CapabilityReference getCapabilityRef() {
        return software.amazon.jsii.Kernel.get(this, "capabilityRef", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.eks.CapabilityReference.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A unique name for the capability.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCapabilityName() {
        return software.amazon.jsii.Kernel.get(this, "capabilityName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A unique name for the capability.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCapabilityName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "capabilityName", java.util.Objects.requireNonNull(value, "capabilityName is required"));
    }

    /**
     * The name of the EKS cluster where you want to create the capability.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getClusterName() {
        return software.amazon.jsii.Kernel.get(this, "clusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the EKS cluster where you want to create the capability.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClusterName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "clusterName", java.util.Objects.requireNonNull(value, "clusterName is required"));
    }

    /**
     * Specifies how Kubernetes resources managed by the capability should be handled when the capability is deleted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDeletePropagationPolicy() {
        return software.amazon.jsii.Kernel.get(this, "deletePropagationPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies how Kubernetes resources managed by the capability should be handled when the capability is deleted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeletePropagationPolicy(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "deletePropagationPolicy", java.util.Objects.requireNonNull(value, "deletePropagationPolicy is required"));
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role that the capability uses to interact with AWS services.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role that the capability uses to interact with AWS services.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "roleArn", java.util.Objects.requireNonNull(value, "roleArn is required"));
    }

    /**
     * The type of capability to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of capability to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "type", java.util.Objects.requireNonNull(value, "type is required"));
    }

    /**
     * Configuration settings for a capability.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.eks.CfnCapability.CapabilityConfigurationProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Configuration settings for a capability.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "configuration", value);
    }

    /**
     * Configuration settings for a capability.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.eks.CfnCapability.CapabilityConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "configuration", value);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * Configuration settings for an Argo CD capability.
     * <p>
     * This includes the Kubernetes namespace, IAM Identity Center integration, RBAC role mappings, and network access configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.eks.*;
     * ArgoCdProperty argoCdProperty = ArgoCdProperty.builder()
     *         .awsIdc(AwsIdcProperty.builder()
     *                 .idcInstanceArn("idcInstanceArn")
     *                 // the properties below are optional
     *                 .idcManagedApplicationArn("idcManagedApplicationArn")
     *                 .idcRegion("idcRegion")
     *                 .build())
     *         // the properties below are optional
     *         .namespace("namespace")
     *         .networkAccess(NetworkAccessProperty.builder()
     *                 .vpceIds(List.of("vpceIds"))
     *                 .build())
     *         .rbacRoleMappings(List.of(ArgoCdRoleMappingProperty.builder()
     *                 .identities(List.of(SsoIdentityProperty.builder()
     *                         .id("id")
     *                         .type("type")
     *                         .build()))
     *                 .role("role")
     *                 .build()))
     *         .serverUrl("serverUrl")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-capability-argocd.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-capability-argocd.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.CfnCapability.ArgoCdProperty")
    @software.amazon.jsii.Jsii.Proxy(ArgoCdProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ArgoCdProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration for integrating Argo CD with IAM Identity Center.
         * <p>
         * This allows you to use your organization's identity provider for authentication to Argo CD.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.eks.CfnCapability.AwsIdcProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-capability-argocd.html#cfn-eks-capability-argocd-awsidc">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-capability-argocd.html#cfn-eks-capability-argocd-awsidc</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getAwsIdc();

        /**
         * The Kubernetes namespace where Argo CD resources will be created.
         * <p>
         * If not specified, the default namespace is used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-capability-argocd.html#cfn-eks-capability-argocd-namespace">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-capability-argocd.html#cfn-eks-capability-argocd-namespace</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNamespace() {
            return null;
        }

        /**
         * Configuration for network access to the Argo CD capability's managed API server endpoint.
         * <p>
         * By default, the Argo CD server is accessible via a public endpoint. You can optionally specify one or more VPC endpoint IDs to enable private connectivity from your VPCs.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.eks.CfnCapability.NetworkAccessProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-capability-argocd.html#cfn-eks-capability-argocd-networkaccess">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-capability-argocd.html#cfn-eks-capability-argocd-networkaccess</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkAccess() {
            return null;
        }

        /**
         * A list of role mappings that define which IAM Identity Center users or groups have which Argo CD roles.
         * <p>
         * Each mapping associates an Argo CD role (ADMIN, EDITOR, or VIEWER) with one or more IAM Identity Center identities.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.eks.CfnCapability.ArgoCdRoleMappingProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-capability-argocd.html#cfn-eks-capability-argocd-rbacrolemappings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-capability-argocd.html#cfn-eks-capability-argocd-rbacrolemappings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRbacRoleMappings() {
            return null;
        }

        /**
         * The URL of the Argo CD server.
         * <p>
         * Use this URL to access the Argo CD web interface and API.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-capability-argocd.html#cfn-eks-capability-argocd-serverurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-capability-argocd.html#cfn-eks-capability-argocd-serverurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServerUrl() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ArgoCdProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ArgoCdProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ArgoCdProperty> {
            java.lang.Object awsIdc;
            java.lang.String namespace;
            java.lang.Object networkAccess;
            java.lang.Object rbacRoleMappings;
            java.lang.String serverUrl;

            /**
             * Sets the value of {@link ArgoCdProperty#getAwsIdc}
             * @param awsIdc Configuration for integrating Argo CD with IAM Identity Center. This parameter is required.
             *               This allows you to use your organization's identity provider for authentication to Argo CD.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsIdc(software.amazon.awscdk.IResolvable awsIdc) {
                this.awsIdc = awsIdc;
                return this;
            }

            /**
             * Sets the value of {@link ArgoCdProperty#getAwsIdc}
             * @param awsIdc Configuration for integrating Argo CD with IAM Identity Center. This parameter is required.
             *               This allows you to use your organization's identity provider for authentication to Argo CD.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsIdc(software.amazon.awscdk.services.eks.CfnCapability.AwsIdcProperty awsIdc) {
                this.awsIdc = awsIdc;
                return this;
            }

            /**
             * Sets the value of {@link ArgoCdProperty#getNamespace}
             * @param namespace The Kubernetes namespace where Argo CD resources will be created.
             *                  If not specified, the default namespace is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder namespace(java.lang.String namespace) {
                this.namespace = namespace;
                return this;
            }

            /**
             * Sets the value of {@link ArgoCdProperty#getNetworkAccess}
             * @param networkAccess Configuration for network access to the Argo CD capability's managed API server endpoint.
             *                      By default, the Argo CD server is accessible via a public endpoint. You can optionally specify one or more VPC endpoint IDs to enable private connectivity from your VPCs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkAccess(software.amazon.awscdk.IResolvable networkAccess) {
                this.networkAccess = networkAccess;
                return this;
            }

            /**
             * Sets the value of {@link ArgoCdProperty#getNetworkAccess}
             * @param networkAccess Configuration for network access to the Argo CD capability's managed API server endpoint.
             *                      By default, the Argo CD server is accessible via a public endpoint. You can optionally specify one or more VPC endpoint IDs to enable private connectivity from your VPCs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkAccess(software.amazon.awscdk.services.eks.CfnCapability.NetworkAccessProperty networkAccess) {
                this.networkAccess = networkAccess;
                return this;
            }

            /**
             * Sets the value of {@link ArgoCdProperty#getRbacRoleMappings}
             * @param rbacRoleMappings A list of role mappings that define which IAM Identity Center users or groups have which Argo CD roles.
             *                         Each mapping associates an Argo CD role (ADMIN, EDITOR, or VIEWER) with one or more IAM Identity Center identities.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rbacRoleMappings(software.amazon.awscdk.IResolvable rbacRoleMappings) {
                this.rbacRoleMappings = rbacRoleMappings;
                return this;
            }

            /**
             * Sets the value of {@link ArgoCdProperty#getRbacRoleMappings}
             * @param rbacRoleMappings A list of role mappings that define which IAM Identity Center users or groups have which Argo CD roles.
             *                         Each mapping associates an Argo CD role (ADMIN, EDITOR, or VIEWER) with one or more IAM Identity Center identities.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rbacRoleMappings(java.util.List<? extends java.lang.Object> rbacRoleMappings) {
                this.rbacRoleMappings = rbacRoleMappings;
                return this;
            }

            /**
             * Sets the value of {@link ArgoCdProperty#getServerUrl}
             * @param serverUrl The URL of the Argo CD server.
             *                  Use this URL to access the Argo CD web interface and API.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverUrl(java.lang.String serverUrl) {
                this.serverUrl = serverUrl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ArgoCdProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ArgoCdProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ArgoCdProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ArgoCdProperty {
            private final java.lang.Object awsIdc;
            private final java.lang.String namespace;
            private final java.lang.Object networkAccess;
            private final java.lang.Object rbacRoleMappings;
            private final java.lang.String serverUrl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.awsIdc = software.amazon.jsii.Kernel.get(this, "awsIdc", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.namespace = software.amazon.jsii.Kernel.get(this, "namespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.networkAccess = software.amazon.jsii.Kernel.get(this, "networkAccess", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rbacRoleMappings = software.amazon.jsii.Kernel.get(this, "rbacRoleMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.serverUrl = software.amazon.jsii.Kernel.get(this, "serverUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.awsIdc = java.util.Objects.requireNonNull(builder.awsIdc, "awsIdc is required");
                this.namespace = builder.namespace;
                this.networkAccess = builder.networkAccess;
                this.rbacRoleMappings = builder.rbacRoleMappings;
                this.serverUrl = builder.serverUrl;
            }

            @Override
            public final java.lang.Object getAwsIdc() {
                return this.awsIdc;
            }

            @Override
            public final java.lang.String getNamespace() {
                return this.namespace;
            }

            @Override
            public final java.lang.Object getNetworkAccess() {
                return this.networkAccess;
            }

            @Override
            public final java.lang.Object getRbacRoleMappings() {
                return this.rbacRoleMappings;
            }

            @Override
            public final java.lang.String getServerUrl() {
                return this.serverUrl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("awsIdc", om.valueToTree(this.getAwsIdc()));
                if (this.getNamespace() != null) {
                    data.set("namespace", om.valueToTree(this.getNamespace()));
                }
                if (this.getNetworkAccess() != null) {
                    data.set("networkAccess", om.valueToTree(this.getNetworkAccess()));
                }
                if (this.getRbacRoleMappings() != null) {
                    data.set("rbacRoleMappings", om.valueToTree(this.getRbacRoleMappings()));
                }
                if (this.getServerUrl() != null) {
                    data.set("serverUrl", om.valueToTree(this.getServerUrl()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.CfnCapability.ArgoCdProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ArgoCdProperty.Jsii$Proxy that = (ArgoCdProperty.Jsii$Proxy) o;

                if (!awsIdc.equals(that.awsIdc)) return false;
                if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) return false;
                if (this.networkAccess != null ? !this.networkAccess.equals(that.networkAccess) : that.networkAccess != null) return false;
                if (this.rbacRoleMappings != null ? !this.rbacRoleMappings.equals(that.rbacRoleMappings) : that.rbacRoleMappings != null) return false;
                return this.serverUrl != null ? this.serverUrl.equals(that.serverUrl) : that.serverUrl == null;
            }

            @Override
            public final int hashCode() {
                int result = this.awsIdc.hashCode();
                result = 31 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
                result = 31 * result + (this.networkAccess != null ? this.networkAccess.hashCode() : 0);
                result = 31 * result + (this.rbacRoleMappings != null ? this.rbacRoleMappings.hashCode() : 0);
                result = 31 * result + (this.serverUrl != null ? this.serverUrl.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A mapping between an Argo CD role and IAM Identity Center identities.
     * <p>
     * This defines which users or groups have specific permissions in Argo CD.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.eks.*;
     * ArgoCdRoleMappingProperty argoCdRoleMappingProperty = ArgoCdRoleMappingProperty.builder()
     *         .identities(List.of(SsoIdentityProperty.builder()
     *                 .id("id")
     *                 .type("type")
     *                 .build()))
     *         .role("role")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-capability-argocdrolemapping.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-capability-argocdrolemapping.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.CfnCapability.ArgoCdRoleMappingProperty")
    @software.amazon.jsii.Jsii.Proxy(ArgoCdRoleMappingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ArgoCdRoleMappingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of IAM Identity Center identities (users or groups) that should be assigned this Argo CD role.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or List<either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.eks.CfnCapability.SsoIdentityProperty}>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-capability-argocdrolemapping.html#cfn-eks-capability-argocdrolemapping-identities">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-capability-argocdrolemapping.html#cfn-eks-capability-argocdrolemapping-identities</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getIdentities();

        /**
         * The Argo CD role to assign.
         * <p>
         * Valid values are: ADMIN (full administrative access to Argo CD), EDITOR (edit access to Argo CD resources), or VIEWER (read-only access to Argo CD resources).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-capability-argocdrolemapping.html#cfn-eks-capability-argocdrolemapping-role">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-capability-argocdrolemapping.html#cfn-eks-capability-argocdrolemapping-role</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRole();

        /**
         * @return a {@link Builder} of {@link ArgoCdRoleMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ArgoCdRoleMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ArgoCdRoleMappingProperty> {
            java.lang.Object identities;
            java.lang.String role;

            /**
             * Sets the value of {@link ArgoCdRoleMappingProperty#getIdentities}
             * @param identities A list of IAM Identity Center identities (users or groups) that should be assigned this Argo CD role. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder identities(software.amazon.awscdk.IResolvable identities) {
                this.identities = identities;
                return this;
            }

            /**
             * Sets the value of {@link ArgoCdRoleMappingProperty#getIdentities}
             * @param identities A list of IAM Identity Center identities (users or groups) that should be assigned this Argo CD role. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder identities(java.util.List<? extends java.lang.Object> identities) {
                this.identities = identities;
                return this;
            }

            /**
             * Sets the value of {@link ArgoCdRoleMappingProperty#getRole}
             * @param role The Argo CD role to assign. This parameter is required.
             *             Valid values are: ADMIN (full administrative access to Argo CD), EDITOR (edit access to Argo CD resources), or VIEWER (read-only access to Argo CD resources).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder role(java.lang.String role) {
                this.role = role;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ArgoCdRoleMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ArgoCdRoleMappingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ArgoCdRoleMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ArgoCdRoleMappingProperty {
            private final java.lang.Object identities;
            private final java.lang.String role;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.identities = software.amazon.jsii.Kernel.get(this, "identities", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.identities = java.util.Objects.requireNonNull(builder.identities, "identities is required");
                this.role = java.util.Objects.requireNonNull(builder.role, "role is required");
            }

            @Override
            public final java.lang.Object getIdentities() {
                return this.identities;
            }

            @Override
            public final java.lang.String getRole() {
                return this.role;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("identities", om.valueToTree(this.getIdentities()));
                data.set("role", om.valueToTree(this.getRole()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.CfnCapability.ArgoCdRoleMappingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ArgoCdRoleMappingProperty.Jsii$Proxy that = (ArgoCdRoleMappingProperty.Jsii$Proxy) o;

                if (!identities.equals(that.identities)) return false;
                return this.role.equals(that.role);
            }

            @Override
            public final int hashCode() {
                int result = this.identities.hashCode();
                result = 31 * result + (this.role.hashCode());
                return result;
            }
        }
    }
    /**
     * Configuration for integrating Argo CD with IAM Identity Center.
     * <p>
     * This allows you to use your organization's identity provider for authentication to Argo CD.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.eks.*;
     * AwsIdcProperty awsIdcProperty = AwsIdcProperty.builder()
     *         .idcInstanceArn("idcInstanceArn")
     *         // the properties below are optional
     *         .idcManagedApplicationArn("idcManagedApplicationArn")
     *         .idcRegion("idcRegion")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-capability-awsidc.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-capability-awsidc.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.CfnCapability.AwsIdcProperty")
    @software.amazon.jsii.Jsii.Proxy(AwsIdcProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AwsIdcProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the IAM Identity Center instance to use for authentication.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-capability-awsidc.html#cfn-eks-capability-awsidc-idcinstancearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-capability-awsidc.html#cfn-eks-capability-awsidc-idcinstancearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIdcInstanceArn();

        /**
         * The ARN of the managed application created in IAM Identity Center for this Argo CD capability.
         * <p>
         * This application is automatically created and managed by EKS.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-capability-awsidc.html#cfn-eks-capability-awsidc-idcmanagedapplicationarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-capability-awsidc.html#cfn-eks-capability-awsidc-idcmanagedapplicationarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIdcManagedApplicationArn() {
            return null;
        }

        /**
         * The Region where your IAM Identity Center instance is located.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-capability-awsidc.html#cfn-eks-capability-awsidc-idcregion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-capability-awsidc.html#cfn-eks-capability-awsidc-idcregion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIdcRegion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AwsIdcProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AwsIdcProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AwsIdcProperty> {
            java.lang.String idcInstanceArn;
            java.lang.String idcManagedApplicationArn;
            java.lang.String idcRegion;

            /**
             * Sets the value of {@link AwsIdcProperty#getIdcInstanceArn}
             * @param idcInstanceArn The ARN of the IAM Identity Center instance to use for authentication. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder idcInstanceArn(java.lang.String idcInstanceArn) {
                this.idcInstanceArn = idcInstanceArn;
                return this;
            }

            /**
             * Sets the value of {@link AwsIdcProperty#getIdcManagedApplicationArn}
             * @param idcManagedApplicationArn The ARN of the managed application created in IAM Identity Center for this Argo CD capability.
             *                                 This application is automatically created and managed by EKS.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder idcManagedApplicationArn(java.lang.String idcManagedApplicationArn) {
                this.idcManagedApplicationArn = idcManagedApplicationArn;
                return this;
            }

            /**
             * Sets the value of {@link AwsIdcProperty#getIdcRegion}
             * @param idcRegion The Region where your IAM Identity Center instance is located.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder idcRegion(java.lang.String idcRegion) {
                this.idcRegion = idcRegion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AwsIdcProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AwsIdcProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AwsIdcProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AwsIdcProperty {
            private final java.lang.String idcInstanceArn;
            private final java.lang.String idcManagedApplicationArn;
            private final java.lang.String idcRegion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.idcInstanceArn = software.amazon.jsii.Kernel.get(this, "idcInstanceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.idcManagedApplicationArn = software.amazon.jsii.Kernel.get(this, "idcManagedApplicationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.idcRegion = software.amazon.jsii.Kernel.get(this, "idcRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.idcInstanceArn = java.util.Objects.requireNonNull(builder.idcInstanceArn, "idcInstanceArn is required");
                this.idcManagedApplicationArn = builder.idcManagedApplicationArn;
                this.idcRegion = builder.idcRegion;
            }

            @Override
            public final java.lang.String getIdcInstanceArn() {
                return this.idcInstanceArn;
            }

            @Override
            public final java.lang.String getIdcManagedApplicationArn() {
                return this.idcManagedApplicationArn;
            }

            @Override
            public final java.lang.String getIdcRegion() {
                return this.idcRegion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("idcInstanceArn", om.valueToTree(this.getIdcInstanceArn()));
                if (this.getIdcManagedApplicationArn() != null) {
                    data.set("idcManagedApplicationArn", om.valueToTree(this.getIdcManagedApplicationArn()));
                }
                if (this.getIdcRegion() != null) {
                    data.set("idcRegion", om.valueToTree(this.getIdcRegion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.CfnCapability.AwsIdcProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AwsIdcProperty.Jsii$Proxy that = (AwsIdcProperty.Jsii$Proxy) o;

                if (!idcInstanceArn.equals(that.idcInstanceArn)) return false;
                if (this.idcManagedApplicationArn != null ? !this.idcManagedApplicationArn.equals(that.idcManagedApplicationArn) : that.idcManagedApplicationArn != null) return false;
                return this.idcRegion != null ? this.idcRegion.equals(that.idcRegion) : that.idcRegion == null;
            }

            @Override
            public final int hashCode() {
                int result = this.idcInstanceArn.hashCode();
                result = 31 * result + (this.idcManagedApplicationArn != null ? this.idcManagedApplicationArn.hashCode() : 0);
                result = 31 * result + (this.idcRegion != null ? this.idcRegion.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration settings for a capability.
     * <p>
     * The structure of this object varies depending on the capability type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.eks.*;
     * CapabilityConfigurationProperty capabilityConfigurationProperty = CapabilityConfigurationProperty.builder()
     *         .argoCd(ArgoCdProperty.builder()
     *                 .awsIdc(AwsIdcProperty.builder()
     *                         .idcInstanceArn("idcInstanceArn")
     *                         // the properties below are optional
     *                         .idcManagedApplicationArn("idcManagedApplicationArn")
     *                         .idcRegion("idcRegion")
     *                         .build())
     *                 // the properties below are optional
     *                 .namespace("namespace")
     *                 .networkAccess(NetworkAccessProperty.builder()
     *                         .vpceIds(List.of("vpceIds"))
     *                         .build())
     *                 .rbacRoleMappings(List.of(ArgoCdRoleMappingProperty.builder()
     *                         .identities(List.of(SsoIdentityProperty.builder()
     *                                 .id("id")
     *                                 .type("type")
     *                                 .build()))
     *                         .role("role")
     *                         .build()))
     *                 .serverUrl("serverUrl")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-capability-capabilityconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-capability-capabilityconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.CfnCapability.CapabilityConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(CapabilityConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CapabilityConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration settings for an Argo CD capability.
         * <p>
         * This includes the Kubernetes namespace, IAM Identity Center integration, RBAC role mappings, and network access configuration.
         * <p>
         * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.eks.CfnCapability.ArgoCdProperty}
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-capability-capabilityconfiguration.html#cfn-eks-capability-capabilityconfiguration-argocd">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-capability-capabilityconfiguration.html#cfn-eks-capability-capabilityconfiguration-argocd</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getArgoCd() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CapabilityConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CapabilityConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CapabilityConfigurationProperty> {
            java.lang.Object argoCd;

            /**
             * Sets the value of {@link CapabilityConfigurationProperty#getArgoCd}
             * @param argoCd Configuration settings for an Argo CD capability.
             *               This includes the Kubernetes namespace, IAM Identity Center integration, RBAC role mappings, and network access configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder argoCd(software.amazon.awscdk.IResolvable argoCd) {
                this.argoCd = argoCd;
                return this;
            }

            /**
             * Sets the value of {@link CapabilityConfigurationProperty#getArgoCd}
             * @param argoCd Configuration settings for an Argo CD capability.
             *               This includes the Kubernetes namespace, IAM Identity Center integration, RBAC role mappings, and network access configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder argoCd(software.amazon.awscdk.services.eks.CfnCapability.ArgoCdProperty argoCd) {
                this.argoCd = argoCd;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CapabilityConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CapabilityConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CapabilityConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CapabilityConfigurationProperty {
            private final java.lang.Object argoCd;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.argoCd = software.amazon.jsii.Kernel.get(this, "argoCd", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.argoCd = builder.argoCd;
            }

            @Override
            public final java.lang.Object getArgoCd() {
                return this.argoCd;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getArgoCd() != null) {
                    data.set("argoCd", om.valueToTree(this.getArgoCd()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.CfnCapability.CapabilityConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CapabilityConfigurationProperty.Jsii$Proxy that = (CapabilityConfigurationProperty.Jsii$Proxy) o;

                return this.argoCd != null ? this.argoCd.equals(that.argoCd) : that.argoCd == null;
            }

            @Override
            public final int hashCode() {
                int result = this.argoCd != null ? this.argoCd.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Configuration for network access to the Argo CD capability's managed API server endpoint.
     * <p>
     * By default, the Argo CD server is accessible via a public endpoint. You can optionally specify one or more VPC endpoint IDs to enable private connectivity from your VPCs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.eks.*;
     * NetworkAccessProperty networkAccessProperty = NetworkAccessProperty.builder()
     *         .vpceIds(List.of("vpceIds"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-capability-networkaccess.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-capability-networkaccess.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.CfnCapability.NetworkAccessProperty")
    @software.amazon.jsii.Jsii.Proxy(NetworkAccessProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NetworkAccessProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of VPC endpoint IDs to associate with the managed Argo CD API server endpoint.
         * <p>
         * Each VPC endpoint provides private connectivity from a specific VPC to the Argo CD server. You can specify multiple VPC endpoint IDs to enable access from multiple VPCs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-capability-networkaccess.html#cfn-eks-capability-networkaccess-vpceids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-capability-networkaccess.html#cfn-eks-capability-networkaccess-vpceids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getVpceIds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NetworkAccessProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NetworkAccessProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NetworkAccessProperty> {
            java.util.List<java.lang.String> vpceIds;

            /**
             * Sets the value of {@link NetworkAccessProperty#getVpceIds}
             * @param vpceIds A list of VPC endpoint IDs to associate with the managed Argo CD API server endpoint.
             *                Each VPC endpoint provides private connectivity from a specific VPC to the Argo CD server. You can specify multiple VPC endpoint IDs to enable access from multiple VPCs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpceIds(java.util.List<java.lang.String> vpceIds) {
                this.vpceIds = vpceIds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkAccessProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NetworkAccessProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NetworkAccessProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkAccessProperty {
            private final java.util.List<java.lang.String> vpceIds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.vpceIds = software.amazon.jsii.Kernel.get(this, "vpceIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.vpceIds = builder.vpceIds;
            }

            @Override
            public final java.util.List<java.lang.String> getVpceIds() {
                return this.vpceIds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getVpceIds() != null) {
                    data.set("vpceIds", om.valueToTree(this.getVpceIds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.CfnCapability.NetworkAccessProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NetworkAccessProperty.Jsii$Proxy that = (NetworkAccessProperty.Jsii$Proxy) o;

                return this.vpceIds != null ? this.vpceIds.equals(that.vpceIds) : that.vpceIds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.vpceIds != null ? this.vpceIds.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * An IAM Identity Center identity (user or group) that can be assigned permissions in a capability.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.eks.*;
     * SsoIdentityProperty ssoIdentityProperty = SsoIdentityProperty.builder()
     *         .id("id")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-capability-ssoidentity.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-capability-ssoidentity.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.CfnCapability.SsoIdentityProperty")
    @software.amazon.jsii.Jsii.Proxy(SsoIdentityProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SsoIdentityProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The unique identifier of the IAM Identity Center user or group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-capability-ssoidentity.html#cfn-eks-capability-ssoidentity-id">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-capability-ssoidentity.html#cfn-eks-capability-ssoidentity-id</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getId();

        /**
         * The type of identity.
         * <p>
         * Valid values are SSO_USER or SSO_GROUP.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-capability-ssoidentity.html#cfn-eks-capability-ssoidentity-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-capability-ssoidentity.html#cfn-eks-capability-ssoidentity-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link SsoIdentityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SsoIdentityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SsoIdentityProperty> {
            java.lang.String id;
            java.lang.String type;

            /**
             * Sets the value of {@link SsoIdentityProperty#getId}
             * @param id The unique identifier of the IAM Identity Center user or group. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link SsoIdentityProperty#getType}
             * @param type The type of identity. This parameter is required.
             *             Valid values are SSO_USER or SSO_GROUP.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SsoIdentityProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SsoIdentityProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SsoIdentityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SsoIdentityProperty {
            private final java.lang.String id;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.id = java.util.Objects.requireNonNull(builder.id, "id is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("id", om.valueToTree(this.getId()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.CfnCapability.SsoIdentityProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SsoIdentityProperty.Jsii$Proxy that = (SsoIdentityProperty.Jsii$Proxy) o;

                if (!id.equals(that.id)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.id.hashCode();
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.eks.CfnCapability}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.eks.CfnCapability> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.eks.CfnCapabilityProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.eks.CfnCapabilityProps.Builder();
        }

        /**
         * A unique name for the capability.
         * <p>
         * The name must be unique within your cluster and can contain alphanumeric characters, hyphens, and underscores.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-capability.html#cfn-eks-capability-capabilityname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-capability.html#cfn-eks-capability-capabilityname</a>
         * @param capabilityName A unique name for the capability. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capabilityName(final java.lang.String capabilityName) {
            this.props.capabilityName(capabilityName);
            return this;
        }

        /**
         * The name of the EKS cluster where you want to create the capability.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-capability.html#cfn-eks-capability-clustername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-capability.html#cfn-eks-capability-clustername</a>
         * @param clusterName The name of the EKS cluster where you want to create the capability. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterName(final java.lang.String clusterName) {
            this.props.clusterName(clusterName);
            return this;
        }

        /**
         * Specifies how Kubernetes resources managed by the capability should be handled when the capability is deleted.
         * <p>
         * Currently, the only supported value is RETAIN which retains all Kubernetes resources managed by the capability when the capability is deleted.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-capability.html#cfn-eks-capability-deletepropagationpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-capability.html#cfn-eks-capability-deletepropagationpolicy</a>
         * @param deletePropagationPolicy Specifies how Kubernetes resources managed by the capability should be handled when the capability is deleted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletePropagationPolicy(final java.lang.String deletePropagationPolicy) {
            this.props.deletePropagationPolicy(deletePropagationPolicy);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the IAM role that the capability uses to interact with AWS services.
         * <p>
         * This role must have a trust policy that allows the EKS service principal to assume it, and it must have the necessary permissions for the capability type you're creating.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-capability.html#cfn-eks-capability-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-capability.html#cfn-eks-capability-rolearn</a>
         * @param roleArn The Amazon Resource Name (ARN) of the IAM role that the capability uses to interact with AWS services. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(final java.lang.String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        /**
         * The type of capability to create.
         * <p>
         * Valid values are: ACK (AWS Controllers for Kubernetes, which lets you manage AWS resources directly from Kubernetes), ARGOCD (Argo CD for GitOps-based continuous delivery), or KRO (Kube Resource Orchestrator for composing and managing custom Kubernetes resources).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-capability.html#cfn-eks-capability-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-capability.html#cfn-eks-capability-type</a>
         * @param type The type of capability to create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final java.lang.String type) {
            this.props.type(type);
            return this;
        }

        /**
         * Configuration settings for a capability.
         * <p>
         * The structure of this object varies depending on the capability type.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-capability.html#cfn-eks-capability-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-capability.html#cfn-eks-capability-configuration</a>
         * @param configuration Configuration settings for a capability. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(final software.amazon.awscdk.IResolvable configuration) {
            this.props.configuration(configuration);
            return this;
        }
        /**
         * Configuration settings for a capability.
         * <p>
         * The structure of this object varies depending on the capability type.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-capability.html#cfn-eks-capability-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-capability.html#cfn-eks-capability-configuration</a>
         * @param configuration Configuration settings for a capability. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(final software.amazon.awscdk.services.eks.CfnCapability.CapabilityConfigurationProperty configuration) {
            this.props.configuration(configuration);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-capability.html#cfn-eks-capability-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-capability.html#cfn-eks-capability-tags</a>
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.eks.CfnCapability}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.eks.CfnCapability build() {
            return new software.amazon.awscdk.services.eks.CfnCapability(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
