package software.amazon.awscdk.services.eks;

/**
 * Properties for defining a <code>CfnCapability</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.eks.*;
 * CfnCapabilityProps cfnCapabilityProps = CfnCapabilityProps.builder()
 *         .capabilityName("capabilityName")
 *         .clusterName("clusterName")
 *         .deletePropagationPolicy("deletePropagationPolicy")
 *         .roleArn("roleArn")
 *         .type("type")
 *         // the properties below are optional
 *         .configuration(CapabilityConfigurationProperty.builder()
 *                 .argoCd(ArgoCdProperty.builder()
 *                         .awsIdc(AwsIdcProperty.builder()
 *                                 .idcInstanceArn("idcInstanceArn")
 *                                 // the properties below are optional
 *                                 .idcManagedApplicationArn("idcManagedApplicationArn")
 *                                 .idcRegion("idcRegion")
 *                                 .build())
 *                         // the properties below are optional
 *                         .namespace("namespace")
 *                         .networkAccess(NetworkAccessProperty.builder()
 *                                 .vpceIds(List.of("vpceIds"))
 *                                 .build())
 *                         .rbacRoleMappings(List.of(ArgoCdRoleMappingProperty.builder()
 *                                 .identities(List.of(SsoIdentityProperty.builder()
 *                                         .id("id")
 *                                         .type("type")
 *                                         .build()))
 *                                 .role("role")
 *                                 .build()))
 *                         .serverUrl("serverUrl")
 *                         .build())
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-capability.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-capability.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:20.418Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.CfnCapabilityProps")
@software.amazon.jsii.Jsii.Proxy(CfnCapabilityProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnCapabilityProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A unique name for the capability.
     * <p>
     * The name must be unique within your cluster and can contain alphanumeric characters, hyphens, and underscores.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-capability.html#cfn-eks-capability-capabilityname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-capability.html#cfn-eks-capability-capabilityname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCapabilityName();

    /**
     * The name of the EKS cluster where you want to create the capability.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-capability.html#cfn-eks-capability-clustername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-capability.html#cfn-eks-capability-clustername</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getClusterName();

    /**
     * Specifies how Kubernetes resources managed by the capability should be handled when the capability is deleted.
     * <p>
     * Currently, the only supported value is RETAIN which retains all Kubernetes resources managed by the capability when the capability is deleted.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-capability.html#cfn-eks-capability-deletepropagationpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-capability.html#cfn-eks-capability-deletepropagationpolicy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDeletePropagationPolicy();

    /**
     * The Amazon Resource Name (ARN) of the IAM role that the capability uses to interact with AWS services.
     * <p>
     * This role must have a trust policy that allows the EKS service principal to assume it, and it must have the necessary permissions for the capability type you're creating.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-capability.html#cfn-eks-capability-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-capability.html#cfn-eks-capability-rolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * The type of capability to create.
     * <p>
     * Valid values are: ACK (AWS Controllers for Kubernetes, which lets you manage AWS resources directly from Kubernetes), ARGOCD (Argo CD for GitOps-based continuous delivery), or KRO (Kube Resource Orchestrator for composing and managing custom Kubernetes resources).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-capability.html#cfn-eks-capability-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-capability.html#cfn-eks-capability-type</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getType();

    /**
     * Configuration settings for a capability.
     * <p>
     * The structure of this object varies depending on the capability type.
     * <p>
     * Returns union: either {@link software.amazon.awscdk.IResolvable} or {@link software.amazon.awscdk.services.eks.CfnCapability.CapabilityConfigurationProperty}
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-capability.html#cfn-eks-capability-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-capability.html#cfn-eks-capability-configuration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getConfiguration() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-capability.html#cfn-eks-capability-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-capability.html#cfn-eks-capability-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnCapabilityProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnCapabilityProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnCapabilityProps> {
        java.lang.String capabilityName;
        java.lang.String clusterName;
        java.lang.String deletePropagationPolicy;
        java.lang.String roleArn;
        java.lang.String type;
        java.lang.Object configuration;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnCapabilityProps#getCapabilityName}
         * @param capabilityName A unique name for the capability. This parameter is required.
         *                       The name must be unique within your cluster and can contain alphanumeric characters, hyphens, and underscores.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capabilityName(java.lang.String capabilityName) {
            this.capabilityName = capabilityName;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapabilityProps#getClusterName}
         * @param clusterName The name of the EKS cluster where you want to create the capability. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterName(java.lang.String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapabilityProps#getDeletePropagationPolicy}
         * @param deletePropagationPolicy Specifies how Kubernetes resources managed by the capability should be handled when the capability is deleted. This parameter is required.
         *                                Currently, the only supported value is RETAIN which retains all Kubernetes resources managed by the capability when the capability is deleted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletePropagationPolicy(java.lang.String deletePropagationPolicy) {
            this.deletePropagationPolicy = deletePropagationPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapabilityProps#getRoleArn}
         * @param roleArn The Amazon Resource Name (ARN) of the IAM role that the capability uses to interact with AWS services. This parameter is required.
         *                This role must have a trust policy that allows the EKS service principal to assume it, and it must have the necessary permissions for the capability type you're creating.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapabilityProps#getType}
         * @param type The type of capability to create. This parameter is required.
         *             Valid values are: ACK (AWS Controllers for Kubernetes, which lets you manage AWS resources directly from Kubernetes), ARGOCD (Argo CD for GitOps-based continuous delivery), or KRO (Kube Resource Orchestrator for composing and managing custom Kubernetes resources).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapabilityProps#getConfiguration}
         * @param configuration Configuration settings for a capability.
         *                      The structure of this object varies depending on the capability type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(software.amazon.awscdk.IResolvable configuration) {
            this.configuration = configuration;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapabilityProps#getConfiguration}
         * @param configuration Configuration settings for a capability.
         *                      The structure of this object varies depending on the capability type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(software.amazon.awscdk.services.eks.CfnCapability.CapabilityConfigurationProperty configuration) {
            this.configuration = configuration;
            return this;
        }

        /**
         * Sets the value of {@link CfnCapabilityProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCapabilityProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnCapabilityProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnCapabilityProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCapabilityProps {
        private final java.lang.String capabilityName;
        private final java.lang.String clusterName;
        private final java.lang.String deletePropagationPolicy;
        private final java.lang.String roleArn;
        private final java.lang.String type;
        private final java.lang.Object configuration;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.capabilityName = software.amazon.jsii.Kernel.get(this, "capabilityName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clusterName = software.amazon.jsii.Kernel.get(this, "clusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deletePropagationPolicy = software.amazon.jsii.Kernel.get(this, "deletePropagationPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.configuration = software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.capabilityName = java.util.Objects.requireNonNull(builder.capabilityName, "capabilityName is required");
            this.clusterName = java.util.Objects.requireNonNull(builder.clusterName, "clusterName is required");
            this.deletePropagationPolicy = java.util.Objects.requireNonNull(builder.deletePropagationPolicy, "deletePropagationPolicy is required");
            this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.configuration = builder.configuration;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getCapabilityName() {
            return this.capabilityName;
        }

        @Override
        public final java.lang.String getClusterName() {
            return this.clusterName;
        }

        @Override
        public final java.lang.String getDeletePropagationPolicy() {
            return this.deletePropagationPolicy;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.lang.Object getConfiguration() {
            return this.configuration;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("capabilityName", om.valueToTree(this.getCapabilityName()));
            data.set("clusterName", om.valueToTree(this.getClusterName()));
            data.set("deletePropagationPolicy", om.valueToTree(this.getDeletePropagationPolicy()));
            data.set("roleArn", om.valueToTree(this.getRoleArn()));
            data.set("type", om.valueToTree(this.getType()));
            if (this.getConfiguration() != null) {
                data.set("configuration", om.valueToTree(this.getConfiguration()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.CfnCapabilityProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCapabilityProps.Jsii$Proxy that = (CfnCapabilityProps.Jsii$Proxy) o;

            if (!capabilityName.equals(that.capabilityName)) return false;
            if (!clusterName.equals(that.clusterName)) return false;
            if (!deletePropagationPolicy.equals(that.deletePropagationPolicy)) return false;
            if (!roleArn.equals(that.roleArn)) return false;
            if (!type.equals(that.type)) return false;
            if (this.configuration != null ? !this.configuration.equals(that.configuration) : that.configuration != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.capabilityName.hashCode();
            result = 31 * result + (this.clusterName.hashCode());
            result = 31 * result + (this.deletePropagationPolicy.hashCode());
            result = 31 * result + (this.roleArn.hashCode());
            result = 31 * result + (this.type.hashCode());
            result = 31 * result + (this.configuration != null ? this.configuration.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
