package software.amazon.awscdk.services.eks;

/**
 * Effect types of kubernetes node taint.
 * <p>
 * Note: These values are specifically for AWS EKS NodeGroups and use the AWS API format.
 * When using AWS CLI or API, taint effects must be NO_SCHEDULE, PREFER_NO_SCHEDULE, or NO_EXECUTE.
 * When using Kubernetes directly or kubectl, taint effects must be NoSchedule, PreferNoSchedule, or NoExecute.
 * <p>
 * For Kubernetes manifests (like Karpenter NodePools), use string literals with PascalCase format:
 * <p>
 * <ul>
 * <li>'NoSchedule' instead of TaintEffect.NO_SCHEDULE</li>
 * <li>'PreferNoSchedule' instead of TaintEffect.PREFER_NO_SCHEDULE</li>
 * <li>'NoExecute' instead of TaintEffect.NO_EXECUTE</li>
 * </ul>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * cluster.addNodegroupCapacity("custom-node-group", NodegroupOptions.builder()
 *         .instanceTypes(List.of(new InstanceType("m5.large")))
 *         .taints(List.of(TaintSpec.builder()
 *                 .effect(TaintEffect.NO_SCHEDULE)
 *                 .key("foo")
 *                 .value("bar")
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/eks/latest/userguide/node-taints-managed-node-groups.html">https://docs.aws.amazon.com/eks/latest/userguide/node-taints-managed-node-groups.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:20.541Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.TaintEffect")
public enum TaintEffect {
    /**
     * NoSchedule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NO_SCHEDULE,
    /**
     * PreferNoSchedule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PREFER_NO_SCHEDULE,
    /**
     * NoExecute.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NO_EXECUTE,
}
