package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for configuring a target group health.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * ApplicationTargetGroup targetGroup = ApplicationTargetGroup.Builder.create(this, "TargetGroup")
 *         .vpc(vpc)
 *         .port(80)
 *         .targetGroupHealth(TargetGroupHealth.builder()
 *                 .dnsMinimumHealthyTargetCount(3)
 *                 .dnsMinimumHealthyTargetPercentage(70)
 *                 .routingMinimumHealthyTargetCount(2)
 *                 .routingMinimumHealthyTargetPercentage(50)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html#target-group-attributes">https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html#target-group-attributes</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:20.861Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.TargetGroupHealth")
@software.amazon.jsii.Jsii.Proxy(TargetGroupHealth.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TargetGroupHealth extends software.amazon.jsii.JsiiSerializable {

    /**
     * The minimum number of targets that must be healthy for DNS failover.
     * <p>
     * If below this value, mark the zone as unhealthy in DNS.
     * Use 0 for "off".
     * <p>
     * Default: 1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getDnsMinimumHealthyTargetCount() {
        return null;
    }

    /**
     * The minimum percentage of targets that must be healthy for DNS failover.
     * <p>
     * If below this value, mark the zone as unhealthy in DNS.
     * Use 0 for "off".
     * <p>
     * Default: 0
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getDnsMinimumHealthyTargetPercentage() {
        return null;
    }

    /**
     * The minimum number of targets that must be healthy for unhealthy state routing.
     * <p>
     * If below this value, send traffic to all targets including unhealthy ones.
     * <p>
     * Default: 1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getRoutingMinimumHealthyTargetCount() {
        return null;
    }

    /**
     * The minimum percentage of targets that must be healthy for unhealthy state routing.
     * <p>
     * If below this value, send traffic to all targets including unhealthy ones.
     * Use 0 for "off".
     * <p>
     * Default: 0
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getRoutingMinimumHealthyTargetPercentage() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link TargetGroupHealth}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TargetGroupHealth}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TargetGroupHealth> {
        java.lang.Number dnsMinimumHealthyTargetCount;
        java.lang.Number dnsMinimumHealthyTargetPercentage;
        java.lang.Number routingMinimumHealthyTargetCount;
        java.lang.Number routingMinimumHealthyTargetPercentage;

        /**
         * Sets the value of {@link TargetGroupHealth#getDnsMinimumHealthyTargetCount}
         * @param dnsMinimumHealthyTargetCount The minimum number of targets that must be healthy for DNS failover.
         *                                     If below this value, mark the zone as unhealthy in DNS.
         *                                     Use 0 for "off".
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dnsMinimumHealthyTargetCount(java.lang.Number dnsMinimumHealthyTargetCount) {
            this.dnsMinimumHealthyTargetCount = dnsMinimumHealthyTargetCount;
            return this;
        }

        /**
         * Sets the value of {@link TargetGroupHealth#getDnsMinimumHealthyTargetPercentage}
         * @param dnsMinimumHealthyTargetPercentage The minimum percentage of targets that must be healthy for DNS failover.
         *                                          If below this value, mark the zone as unhealthy in DNS.
         *                                          Use 0 for "off".
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dnsMinimumHealthyTargetPercentage(java.lang.Number dnsMinimumHealthyTargetPercentage) {
            this.dnsMinimumHealthyTargetPercentage = dnsMinimumHealthyTargetPercentage;
            return this;
        }

        /**
         * Sets the value of {@link TargetGroupHealth#getRoutingMinimumHealthyTargetCount}
         * @param routingMinimumHealthyTargetCount The minimum number of targets that must be healthy for unhealthy state routing.
         *                                         If below this value, send traffic to all targets including unhealthy ones.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routingMinimumHealthyTargetCount(java.lang.Number routingMinimumHealthyTargetCount) {
            this.routingMinimumHealthyTargetCount = routingMinimumHealthyTargetCount;
            return this;
        }

        /**
         * Sets the value of {@link TargetGroupHealth#getRoutingMinimumHealthyTargetPercentage}
         * @param routingMinimumHealthyTargetPercentage The minimum percentage of targets that must be healthy for unhealthy state routing.
         *                                              If below this value, send traffic to all targets including unhealthy ones.
         *                                              Use 0 for "off".
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routingMinimumHealthyTargetPercentage(java.lang.Number routingMinimumHealthyTargetPercentage) {
            this.routingMinimumHealthyTargetPercentage = routingMinimumHealthyTargetPercentage;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TargetGroupHealth}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TargetGroupHealth build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TargetGroupHealth}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetGroupHealth {
        private final java.lang.Number dnsMinimumHealthyTargetCount;
        private final java.lang.Number dnsMinimumHealthyTargetPercentage;
        private final java.lang.Number routingMinimumHealthyTargetCount;
        private final java.lang.Number routingMinimumHealthyTargetPercentage;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dnsMinimumHealthyTargetCount = software.amazon.jsii.Kernel.get(this, "dnsMinimumHealthyTargetCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.dnsMinimumHealthyTargetPercentage = software.amazon.jsii.Kernel.get(this, "dnsMinimumHealthyTargetPercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.routingMinimumHealthyTargetCount = software.amazon.jsii.Kernel.get(this, "routingMinimumHealthyTargetCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.routingMinimumHealthyTargetPercentage = software.amazon.jsii.Kernel.get(this, "routingMinimumHealthyTargetPercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dnsMinimumHealthyTargetCount = builder.dnsMinimumHealthyTargetCount;
            this.dnsMinimumHealthyTargetPercentage = builder.dnsMinimumHealthyTargetPercentage;
            this.routingMinimumHealthyTargetCount = builder.routingMinimumHealthyTargetCount;
            this.routingMinimumHealthyTargetPercentage = builder.routingMinimumHealthyTargetPercentage;
        }

        @Override
        public final java.lang.Number getDnsMinimumHealthyTargetCount() {
            return this.dnsMinimumHealthyTargetCount;
        }

        @Override
        public final java.lang.Number getDnsMinimumHealthyTargetPercentage() {
            return this.dnsMinimumHealthyTargetPercentage;
        }

        @Override
        public final java.lang.Number getRoutingMinimumHealthyTargetCount() {
            return this.routingMinimumHealthyTargetCount;
        }

        @Override
        public final java.lang.Number getRoutingMinimumHealthyTargetPercentage() {
            return this.routingMinimumHealthyTargetPercentage;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDnsMinimumHealthyTargetCount() != null) {
                data.set("dnsMinimumHealthyTargetCount", om.valueToTree(this.getDnsMinimumHealthyTargetCount()));
            }
            if (this.getDnsMinimumHealthyTargetPercentage() != null) {
                data.set("dnsMinimumHealthyTargetPercentage", om.valueToTree(this.getDnsMinimumHealthyTargetPercentage()));
            }
            if (this.getRoutingMinimumHealthyTargetCount() != null) {
                data.set("routingMinimumHealthyTargetCount", om.valueToTree(this.getRoutingMinimumHealthyTargetCount()));
            }
            if (this.getRoutingMinimumHealthyTargetPercentage() != null) {
                data.set("routingMinimumHealthyTargetPercentage", om.valueToTree(this.getRoutingMinimumHealthyTargetPercentage()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticloadbalancingv2.TargetGroupHealth"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TargetGroupHealth.Jsii$Proxy that = (TargetGroupHealth.Jsii$Proxy) o;

            if (this.dnsMinimumHealthyTargetCount != null ? !this.dnsMinimumHealthyTargetCount.equals(that.dnsMinimumHealthyTargetCount) : that.dnsMinimumHealthyTargetCount != null) return false;
            if (this.dnsMinimumHealthyTargetPercentage != null ? !this.dnsMinimumHealthyTargetPercentage.equals(that.dnsMinimumHealthyTargetPercentage) : that.dnsMinimumHealthyTargetPercentage != null) return false;
            if (this.routingMinimumHealthyTargetCount != null ? !this.routingMinimumHealthyTargetCount.equals(that.routingMinimumHealthyTargetCount) : that.routingMinimumHealthyTargetCount != null) return false;
            return this.routingMinimumHealthyTargetPercentage != null ? this.routingMinimumHealthyTargetPercentage.equals(that.routingMinimumHealthyTargetPercentage) : that.routingMinimumHealthyTargetPercentage == null;
        }

        @Override
        public final int hashCode() {
            int result = this.dnsMinimumHealthyTargetCount != null ? this.dnsMinimumHealthyTargetCount.hashCode() : 0;
            result = 31 * result + (this.dnsMinimumHealthyTargetPercentage != null ? this.dnsMinimumHealthyTargetPercentage.hashCode() : 0);
            result = 31 * result + (this.routingMinimumHealthyTargetCount != null ? this.routingMinimumHealthyTargetCount.hashCode() : 0);
            result = 31 * result + (this.routingMinimumHealthyTargetPercentage != null ? this.routingMinimumHealthyTargetPercentage.hashCode() : 0);
            return result;
        }
    }
}
