package software.amazon.awscdk.services.elasticsearch;

/**
 * Collection of grant methods for a IDomainRef.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.elasticsearch.*;
 * import software.amazon.awscdk.interfaces.elasticsearch.*;
 * IDomainRef domainRef;
 * DomainGrants domainGrants = DomainGrants.fromDomain(domainRef);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:20.934Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticsearch.DomainGrants")
public class DomainGrants extends software.amazon.jsii.JsiiObject {

    protected DomainGrants(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DomainGrants(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Creates grants for DomainGrants.
     * <p>
     * @param resource This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticsearch.DomainGrants fromDomain(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.elasticsearch.IDomainRef resource) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.elasticsearch.DomainGrants.class, "fromDomain", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticsearch.DomainGrants.class), new Object[] { java.util.Objects.requireNonNull(resource, "resource is required") });
    }

    /**
     * Grant read permissions for this domain and its contents to an IAM principal (Role/Group/User).
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant read(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "read", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Grant read/write permissions for this domain and its contents to an IAM principal (Role/Group/User).
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant readWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "readWrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Grant write permissions for this domain and its contents to an IAM principal (Role/Group/User).
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant write(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "write", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.interfaces.elasticsearch.IDomainRef getResource() {
        return software.amazon.jsii.Kernel.get(this, "resource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.interfaces.elasticsearch.IDomainRef.class));
    }
}
