package software.amazon.awscdk.services.events;

/**
 * Authorization type for an API Destination Connection.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Connection connection = Connection.Builder.create(this, "Connection")
 *         .authorization(Authorization.apiKey("x-api-key", SecretValue.secretsManager("ApiSecretName")))
 *         .description("Connection with API Key x-api-key")
 *         .build();
 * ApiDestination destination = ApiDestination.Builder.create(this, "Destination")
 *         .connection(connection)
 *         .endpoint("https://example.com")
 *         .description("Calling example.com with API key x-api-key")
 *         .build();
 * Rule rule = Rule.Builder.create(this, "Rule")
 *         .schedule(Schedule.rate(Duration.minutes(1)))
 *         .targets(List.of(new ApiDestination(destination)))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.119.0 (build 1634eac)", date = "2025-12-01T16:02:21.119Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.Authorization")
public abstract class Authorization extends software.amazon.jsii.JsiiObject {

    protected Authorization(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Authorization(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected Authorization() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Use API key authorization.
     * <p>
     * API key authorization has two components: an API key name and an API key value.
     * What these are depends on the target of your connection.
     * <p>
     * @param apiKeyName This parameter is required.
     * @param apiKeyValue This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Authorization apiKey(final @org.jetbrains.annotations.NotNull java.lang.String apiKeyName, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.SecretValue apiKeyValue) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.events.Authorization.class, "apiKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Authorization.class), new Object[] { java.util.Objects.requireNonNull(apiKeyName, "apiKeyName is required"), java.util.Objects.requireNonNull(apiKeyValue, "apiKeyValue is required") });
    }

    /**
     * Use username and password authorization.
     * <p>
     * @param username This parameter is required.
     * @param password This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Authorization basic(final @org.jetbrains.annotations.NotNull java.lang.String username, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.SecretValue password) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.events.Authorization.class, "basic", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Authorization.class), new Object[] { java.util.Objects.requireNonNull(username, "username is required"), java.util.Objects.requireNonNull(password, "password is required") });
    }

    /**
     * Use OAuth authorization.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Authorization oauth(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.OAuthAuthorizationProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.events.Authorization.class, "oauth", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Authorization.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.events.Authorization {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
